/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/user_event.proto

package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Detailed page information.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.PageInfo}
 */
public final class PageInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.PageInfo)
    PageInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PageInfo.newBuilder() to construct.
  private PageInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PageInfo() {
    pageviewId_ = "";
    pageCategory_ = "";
    uri_ = "";
    referrerUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PageInfo();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.UserEventProto
        .internal_static_google_cloud_discoveryengine_v1beta_PageInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.UserEventProto
        .internal_static_google_cloud_discoveryengine_v1beta_PageInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.PageInfo.class,
            com.google.cloud.discoveryengine.v1beta.PageInfo.Builder.class);
  }

  public static final int PAGEVIEW_ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object pageviewId_;
  /**
   *
   *
   * <pre>
   * A unique ID of a web page view.
   * This should be kept the same for all user events triggered from the same
   * pageview. For example, an item detail page view could trigger multiple
   * events as the user is browsing the page. The `pageViewId` property should
   * be kept the same for all these events so that they can be grouped together
   * properly.
   * When using the client side event reporting with JavaScript pixel and Google
   * Tag Manager, this value is filled in automatically.
   * </pre>
   *
   * <code>string pageview_id = 1;</code>
   *
   * @return The pageviewId.
   */
  @java.lang.Override
  public java.lang.String getPageviewId() {
    java.lang.Object ref = pageviewId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageviewId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique ID of a web page view.
   * This should be kept the same for all user events triggered from the same
   * pageview. For example, an item detail page view could trigger multiple
   * events as the user is browsing the page. The `pageViewId` property should
   * be kept the same for all these events so that they can be grouped together
   * properly.
   * When using the client side event reporting with JavaScript pixel and Google
   * Tag Manager, this value is filled in automatically.
   * </pre>
   *
   * <code>string pageview_id = 1;</code>
   *
   * @return The bytes for pageviewId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageviewIdBytes() {
    java.lang.Object ref = pageviewId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageviewId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_CATEGORY_FIELD_NUMBER = 2;
  private volatile java.lang.Object pageCategory_;
  /**
   *
   *
   * <pre>
   * The most specific category associated with a category page.
   * To represent full path of category, use '&gt;' sign to separate different
   * hierarchies. If '&gt;' is part of the category name, please replace it with
   * other character(s).
   * Category pages include special pages such as sales or promotions. For
   * instance, a special sale page may have the category hierarchy:
   * "pageCategory" : "Sales &gt; 2017 Black Friday Deals".
   * Required for `view-category-page` events. Other event types should not set
   * this field. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string page_category = 2;</code>
   *
   * @return The pageCategory.
   */
  @java.lang.Override
  public java.lang.String getPageCategory() {
    java.lang.Object ref = pageCategory_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageCategory_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The most specific category associated with a category page.
   * To represent full path of category, use '&gt;' sign to separate different
   * hierarchies. If '&gt;' is part of the category name, please replace it with
   * other character(s).
   * Category pages include special pages such as sales or promotions. For
   * instance, a special sale page may have the category hierarchy:
   * "pageCategory" : "Sales &gt; 2017 Black Friday Deals".
   * Required for `view-category-page` events. Other event types should not set
   * this field. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string page_category = 2;</code>
   *
   * @return The bytes for pageCategory.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageCategoryBytes() {
    java.lang.Object ref = pageCategory_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageCategory_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URI_FIELD_NUMBER = 3;
  private volatile java.lang.Object uri_;
  /**
   *
   *
   * <pre>
   * Complete URL (window.location.href) of the user's current page.
   * When using the client side event reporting with JavaScript pixel and Google
   * Tag Manager, this value is filled in automatically. Maximum length 5,000
   * characters.
   * </pre>
   *
   * <code>string uri = 3;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Complete URL (window.location.href) of the user's current page.
   * When using the client side event reporting with JavaScript pixel and Google
   * Tag Manager, this value is filled in automatically. Maximum length 5,000
   * characters.
   * </pre>
   *
   * <code>string uri = 3;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REFERRER_URI_FIELD_NUMBER = 4;
  private volatile java.lang.Object referrerUri_;
  /**
   *
   *
   * <pre>
   * The referrer URL of the current page.
   * When using the client side event reporting with JavaScript pixel and Google
   * Tag Manager, this value is filled in automatically. However, some browser
   * privacy restrictions may cause this field to be empty.
   * </pre>
   *
   * <code>string referrer_uri = 4;</code>
   *
   * @return The referrerUri.
   */
  @java.lang.Override
  public java.lang.String getReferrerUri() {
    java.lang.Object ref = referrerUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      referrerUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The referrer URL of the current page.
   * When using the client side event reporting with JavaScript pixel and Google
   * Tag Manager, this value is filled in automatically. However, some browser
   * privacy restrictions may cause this field to be empty.
   * </pre>
   *
   * <code>string referrer_uri = 4;</code>
   *
   * @return The bytes for referrerUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReferrerUriBytes() {
    java.lang.Object ref = referrerUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      referrerUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageviewId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pageviewId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageCategory_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, pageCategory_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(referrerUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, referrerUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageviewId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pageviewId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageCategory_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, pageCategory_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(referrerUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, referrerUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.PageInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.PageInfo other =
        (com.google.cloud.discoveryengine.v1beta.PageInfo) obj;

    if (!getPageviewId().equals(other.getPageviewId())) return false;
    if (!getPageCategory().equals(other.getPageCategory())) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (!getReferrerUri().equals(other.getReferrerUri())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PAGEVIEW_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPageviewId().hashCode();
    hash = (37 * hash) + PAGE_CATEGORY_FIELD_NUMBER;
    hash = (53 * hash) + getPageCategory().hashCode();
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    hash = (37 * hash) + REFERRER_URI_FIELD_NUMBER;
    hash = (53 * hash) + getReferrerUri().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.PageInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.PageInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.PageInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.PageInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.PageInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.PageInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.PageInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.PageInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.PageInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.PageInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.PageInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.PageInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1beta.PageInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Detailed page information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.PageInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.PageInfo)
      com.google.cloud.discoveryengine.v1beta.PageInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.UserEventProto
          .internal_static_google_cloud_discoveryengine_v1beta_PageInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.UserEventProto
          .internal_static_google_cloud_discoveryengine_v1beta_PageInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.PageInfo.class,
              com.google.cloud.discoveryengine.v1beta.PageInfo.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.PageInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      pageviewId_ = "";

      pageCategory_ = "";

      uri_ = "";

      referrerUri_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.UserEventProto
          .internal_static_google_cloud_discoveryengine_v1beta_PageInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.PageInfo getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.PageInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.PageInfo build() {
      com.google.cloud.discoveryengine.v1beta.PageInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.PageInfo buildPartial() {
      com.google.cloud.discoveryengine.v1beta.PageInfo result =
          new com.google.cloud.discoveryengine.v1beta.PageInfo(this);
      result.pageviewId_ = pageviewId_;
      result.pageCategory_ = pageCategory_;
      result.uri_ = uri_;
      result.referrerUri_ = referrerUri_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.PageInfo) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.PageInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.PageInfo other) {
      if (other == com.google.cloud.discoveryengine.v1beta.PageInfo.getDefaultInstance())
        return this;
      if (!other.getPageviewId().isEmpty()) {
        pageviewId_ = other.pageviewId_;
        onChanged();
      }
      if (!other.getPageCategory().isEmpty()) {
        pageCategory_ = other.pageCategory_;
        onChanged();
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        onChanged();
      }
      if (!other.getReferrerUri().isEmpty()) {
        referrerUri_ = other.referrerUri_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                pageviewId_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                pageCategory_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                uri_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                referrerUri_ = input.readStringRequireUtf8();

                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object pageviewId_ = "";
    /**
     *
     *
     * <pre>
     * A unique ID of a web page view.
     * This should be kept the same for all user events triggered from the same
     * pageview. For example, an item detail page view could trigger multiple
     * events as the user is browsing the page. The `pageViewId` property should
     * be kept the same for all these events so that they can be grouped together
     * properly.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     * </pre>
     *
     * <code>string pageview_id = 1;</code>
     *
     * @return The pageviewId.
     */
    public java.lang.String getPageviewId() {
      java.lang.Object ref = pageviewId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageviewId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique ID of a web page view.
     * This should be kept the same for all user events triggered from the same
     * pageview. For example, an item detail page view could trigger multiple
     * events as the user is browsing the page. The `pageViewId` property should
     * be kept the same for all these events so that they can be grouped together
     * properly.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     * </pre>
     *
     * <code>string pageview_id = 1;</code>
     *
     * @return The bytes for pageviewId.
     */
    public com.google.protobuf.ByteString getPageviewIdBytes() {
      java.lang.Object ref = pageviewId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageviewId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique ID of a web page view.
     * This should be kept the same for all user events triggered from the same
     * pageview. For example, an item detail page view could trigger multiple
     * events as the user is browsing the page. The `pageViewId` property should
     * be kept the same for all these events so that they can be grouped together
     * properly.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     * </pre>
     *
     * <code>string pageview_id = 1;</code>
     *
     * @param value The pageviewId to set.
     * @return This builder for chaining.
     */
    public Builder setPageviewId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pageviewId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique ID of a web page view.
     * This should be kept the same for all user events triggered from the same
     * pageview. For example, an item detail page view could trigger multiple
     * events as the user is browsing the page. The `pageViewId` property should
     * be kept the same for all these events so that they can be grouped together
     * properly.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     * </pre>
     *
     * <code>string pageview_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageviewId() {

      pageviewId_ = getDefaultInstance().getPageviewId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique ID of a web page view.
     * This should be kept the same for all user events triggered from the same
     * pageview. For example, an item detail page view could trigger multiple
     * events as the user is browsing the page. The `pageViewId` property should
     * be kept the same for all these events so that they can be grouped together
     * properly.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     * </pre>
     *
     * <code>string pageview_id = 1;</code>
     *
     * @param value The bytes for pageviewId to set.
     * @return This builder for chaining.
     */
    public Builder setPageviewIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pageviewId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object pageCategory_ = "";
    /**
     *
     *
     * <pre>
     * The most specific category associated with a category page.
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, please replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategory" : "Sales &gt; 2017 Black Friday Deals".
     * Required for `view-category-page` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string page_category = 2;</code>
     *
     * @return The pageCategory.
     */
    public java.lang.String getPageCategory() {
      java.lang.Object ref = pageCategory_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageCategory_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The most specific category associated with a category page.
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, please replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategory" : "Sales &gt; 2017 Black Friday Deals".
     * Required for `view-category-page` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string page_category = 2;</code>
     *
     * @return The bytes for pageCategory.
     */
    public com.google.protobuf.ByteString getPageCategoryBytes() {
      java.lang.Object ref = pageCategory_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageCategory_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The most specific category associated with a category page.
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, please replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategory" : "Sales &gt; 2017 Black Friday Deals".
     * Required for `view-category-page` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string page_category = 2;</code>
     *
     * @param value The pageCategory to set.
     * @return This builder for chaining.
     */
    public Builder setPageCategory(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pageCategory_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most specific category associated with a category page.
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, please replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategory" : "Sales &gt; 2017 Black Friday Deals".
     * Required for `view-category-page` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string page_category = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageCategory() {

      pageCategory_ = getDefaultInstance().getPageCategory();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The most specific category associated with a category page.
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, please replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategory" : "Sales &gt; 2017 Black Friday Deals".
     * Required for `view-category-page` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string page_category = 2;</code>
     *
     * @param value The bytes for pageCategory to set.
     * @return This builder for chaining.
     */
    public Builder setPageCategoryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pageCategory_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * Complete URL (window.location.href) of the user's current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. Maximum length 5,000
     * characters.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Complete URL (window.location.href) of the user's current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. Maximum length 5,000
     * characters.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Complete URL (window.location.href) of the user's current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. Maximum length 5,000
     * characters.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      uri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Complete URL (window.location.href) of the user's current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. Maximum length 5,000
     * characters.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {

      uri_ = getDefaultInstance().getUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Complete URL (window.location.href) of the user's current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. Maximum length 5,000
     * characters.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      uri_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object referrerUri_ = "";
    /**
     *
     *
     * <pre>
     * The referrer URL of the current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. However, some browser
     * privacy restrictions may cause this field to be empty.
     * </pre>
     *
     * <code>string referrer_uri = 4;</code>
     *
     * @return The referrerUri.
     */
    public java.lang.String getReferrerUri() {
      java.lang.Object ref = referrerUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        referrerUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The referrer URL of the current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. However, some browser
     * privacy restrictions may cause this field to be empty.
     * </pre>
     *
     * <code>string referrer_uri = 4;</code>
     *
     * @return The bytes for referrerUri.
     */
    public com.google.protobuf.ByteString getReferrerUriBytes() {
      java.lang.Object ref = referrerUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        referrerUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The referrer URL of the current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. However, some browser
     * privacy restrictions may cause this field to be empty.
     * </pre>
     *
     * <code>string referrer_uri = 4;</code>
     *
     * @param value The referrerUri to set.
     * @return This builder for chaining.
     */
    public Builder setReferrerUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      referrerUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The referrer URL of the current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. However, some browser
     * privacy restrictions may cause this field to be empty.
     * </pre>
     *
     * <code>string referrer_uri = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReferrerUri() {

      referrerUri_ = getDefaultInstance().getReferrerUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The referrer URL of the current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. However, some browser
     * privacy restrictions may cause this field to be empty.
     * </pre>
     *
     * <code>string referrer_uri = 4;</code>
     *
     * @param value The bytes for referrerUri to set.
     * @return This builder for chaining.
     */
    public Builder setReferrerUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      referrerUri_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.PageInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.PageInfo)
  private static final com.google.cloud.discoveryengine.v1beta.PageInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.PageInfo();
  }

  public static com.google.cloud.discoveryengine.v1beta.PageInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PageInfo> PARSER =
      new com.google.protobuf.AbstractParser<PageInfo>() {
        @java.lang.Override
        public PageInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PageInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PageInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.PageInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
