/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/document.proto

package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Document captures all raw metadata information of items to be recommended or
 * searched.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.Document}
 */
public final class Document extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.Document)
    DocumentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Document.newBuilder() to construct.
  private Document(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Document() {
    name_ = "";
    id_ = "";
    schemaId_ = "";
    parentDocumentId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Document();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.DocumentProto
        .internal_static_google_cloud_discoveryengine_v1beta_Document_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.DocumentProto
        .internal_static_google_cloud_discoveryengine_v1beta_Document_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.Document.class,
            com.google.cloud.discoveryengine.v1beta.Document.Builder.class);
  }

  private int dataCase_ = 0;
  private java.lang.Object data_;

  public enum DataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STRUCT_DATA(4),
    JSON_DATA(5),
    DATA_NOT_SET(0);
    private final int value;

    private DataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataCase forNumber(int value) {
      switch (value) {
        case 4:
          return STRUCT_DATA;
        case 5:
          return JSON_DATA;
        case 0:
          return DATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataCase getDataCase() {
    return DataCase.forNumber(dataCase_);
  }

  public static final int STRUCT_DATA_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The structured JSON data for the document. It should conform to the
   * registered [schema][] or an INVALID_ARGUMENT error is thrown.
   * </pre>
   *
   * <code>.google.protobuf.Struct struct_data = 4;</code>
   *
   * @return Whether the structData field is set.
   */
  @java.lang.Override
  public boolean hasStructData() {
    return dataCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The structured JSON data for the document. It should conform to the
   * registered [schema][] or an INVALID_ARGUMENT error is thrown.
   * </pre>
   *
   * <code>.google.protobuf.Struct struct_data = 4;</code>
   *
   * @return The structData.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getStructData() {
    if (dataCase_ == 4) {
      return (com.google.protobuf.Struct) data_;
    }
    return com.google.protobuf.Struct.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The structured JSON data for the document. It should conform to the
   * registered [schema][] or an INVALID_ARGUMENT error is thrown.
   * </pre>
   *
   * <code>.google.protobuf.Struct struct_data = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getStructDataOrBuilder() {
    if (dataCase_ == 4) {
      return (com.google.protobuf.Struct) data_;
    }
    return com.google.protobuf.Struct.getDefaultInstance();
  }

  public static final int JSON_DATA_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The JSON string representation of the document. It should conform to the
   * registered [schema][] or an INVALID_ARGUMENT error is thrown.
   * </pre>
   *
   * <code>string json_data = 5;</code>
   *
   * @return Whether the jsonData field is set.
   */
  public boolean hasJsonData() {
    return dataCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The JSON string representation of the document. It should conform to the
   * registered [schema][] or an INVALID_ARGUMENT error is thrown.
   * </pre>
   *
   * <code>string json_data = 5;</code>
   *
   * @return The jsonData.
   */
  public java.lang.String getJsonData() {
    java.lang.Object ref = "";
    if (dataCase_ == 5) {
      ref = data_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (dataCase_ == 5) {
        data_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The JSON string representation of the document. It should conform to the
   * registered [schema][] or an INVALID_ARGUMENT error is thrown.
   * </pre>
   *
   * <code>string json_data = 5;</code>
   *
   * @return The bytes for jsonData.
   */
  public com.google.protobuf.ByteString getJsonDataBytes() {
    java.lang.Object ref = "";
    if (dataCase_ == 5) {
      ref = data_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (dataCase_ == 5) {
        data_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Immutable. The full resource name of the document.
   * Format:
   * `projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`.
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The full resource name of the document.
   * Format:
   * `projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`.
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object id_;
  /**
   *
   *
   * <pre>
   * Immutable. The identifier of the document.
   * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
   * standard with a length limit of 63 characters.
   * </pre>
   *
   * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The identifier of the document.
   * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
   * standard with a length limit of 63 characters.
   * </pre>
   *
   * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCHEMA_ID_FIELD_NUMBER = 3;
  private volatile java.lang.Object schemaId_;
  /**
   *
   *
   * <pre>
   * Required. The identifier of the schema located in the same data store.
   * </pre>
   *
   * <code>string schema_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The schemaId.
   */
  @java.lang.Override
  public java.lang.String getSchemaId() {
    java.lang.Object ref = schemaId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schemaId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The identifier of the schema located in the same data store.
   * </pre>
   *
   * <code>string schema_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for schemaId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSchemaIdBytes() {
    java.lang.Object ref = schemaId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schemaId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_DOCUMENT_ID_FIELD_NUMBER = 7;
  private volatile java.lang.Object parentDocumentId_;
  /**
   *
   *
   * <pre>
   * The identifier of the parent document. Currently supports at most two level
   * document hierarchy.
   * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
   * standard with a length limit of 63 characters.
   * </pre>
   *
   * <code>string parent_document_id = 7;</code>
   *
   * @return The parentDocumentId.
   */
  @java.lang.Override
  public java.lang.String getParentDocumentId() {
    java.lang.Object ref = parentDocumentId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentDocumentId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The identifier of the parent document. Currently supports at most two level
   * document hierarchy.
   * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
   * standard with a length limit of 63 characters.
   * </pre>
   *
   * <code>string parent_document_id = 7;</code>
   *
   * @return The bytes for parentDocumentId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentDocumentIdBytes() {
    java.lang.Object ref = parentDocumentId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentDocumentId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schemaId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, schemaId_);
    }
    if (dataCase_ == 4) {
      output.writeMessage(4, (com.google.protobuf.Struct) data_);
    }
    if (dataCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, data_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentDocumentId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, parentDocumentId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schemaId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, schemaId_);
    }
    if (dataCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.protobuf.Struct) data_);
    }
    if (dataCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, data_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentDocumentId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, parentDocumentId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.Document)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.Document other =
        (com.google.cloud.discoveryengine.v1beta.Document) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getId().equals(other.getId())) return false;
    if (!getSchemaId().equals(other.getSchemaId())) return false;
    if (!getParentDocumentId().equals(other.getParentDocumentId())) return false;
    if (!getDataCase().equals(other.getDataCase())) return false;
    switch (dataCase_) {
      case 4:
        if (!getStructData().equals(other.getStructData())) return false;
        break;
      case 5:
        if (!getJsonData().equals(other.getJsonData())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + SCHEMA_ID_FIELD_NUMBER;
    hash = (53 * hash) + getSchemaId().hashCode();
    hash = (37 * hash) + PARENT_DOCUMENT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getParentDocumentId().hashCode();
    switch (dataCase_) {
      case 4:
        hash = (37 * hash) + STRUCT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getStructData().hashCode();
        break;
      case 5:
        hash = (37 * hash) + JSON_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getJsonData().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.Document parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1beta.Document prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Document captures all raw metadata information of items to be recommended or
   * searched.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.Document}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.Document)
      com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.DocumentProto
          .internal_static_google_cloud_discoveryengine_v1beta_Document_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.DocumentProto
          .internal_static_google_cloud_discoveryengine_v1beta_Document_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.Document.class,
              com.google.cloud.discoveryengine.v1beta.Document.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.Document.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (structDataBuilder_ != null) {
        structDataBuilder_.clear();
      }
      name_ = "";

      id_ = "";

      schemaId_ = "";

      parentDocumentId_ = "";

      dataCase_ = 0;
      data_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.DocumentProto
          .internal_static_google_cloud_discoveryengine_v1beta_Document_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Document getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Document build() {
      com.google.cloud.discoveryengine.v1beta.Document result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Document buildPartial() {
      com.google.cloud.discoveryengine.v1beta.Document result =
          new com.google.cloud.discoveryengine.v1beta.Document(this);
      if (dataCase_ == 4) {
        if (structDataBuilder_ == null) {
          result.data_ = data_;
        } else {
          result.data_ = structDataBuilder_.build();
        }
      }
      if (dataCase_ == 5) {
        result.data_ = data_;
      }
      result.name_ = name_;
      result.id_ = id_;
      result.schemaId_ = schemaId_;
      result.parentDocumentId_ = parentDocumentId_;
      result.dataCase_ = dataCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.Document) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.Document) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.Document other) {
      if (other == com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.getSchemaId().isEmpty()) {
        schemaId_ = other.schemaId_;
        onChanged();
      }
      if (!other.getParentDocumentId().isEmpty()) {
        parentDocumentId_ = other.parentDocumentId_;
        onChanged();
      }
      switch (other.getDataCase()) {
        case STRUCT_DATA:
          {
            mergeStructData(other.getStructData());
            break;
          }
        case JSON_DATA:
          {
            dataCase_ = 5;
            data_ = other.data_;
            onChanged();
            break;
          }
        case DATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                id_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                schemaId_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getStructDataFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                dataCase_ = 5;
                data_ = s;
                break;
              } // case 42
            case 58:
              {
                parentDocumentId_ = input.readStringRequireUtf8();

                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dataCase_ = 0;
    private java.lang.Object data_;

    public DataCase getDataCase() {
      return DataCase.forNumber(dataCase_);
    }

    public Builder clearData() {
      dataCase_ = 0;
      data_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        structDataBuilder_;
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [schema][] or an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     *
     * @return Whether the structData field is set.
     */
    @java.lang.Override
    public boolean hasStructData() {
      return dataCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [schema][] or an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     *
     * @return The structData.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getStructData() {
      if (structDataBuilder_ == null) {
        if (dataCase_ == 4) {
          return (com.google.protobuf.Struct) data_;
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      } else {
        if (dataCase_ == 4) {
          return structDataBuilder_.getMessage();
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [schema][] or an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     */
    public Builder setStructData(com.google.protobuf.Struct value) {
      if (structDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        structDataBuilder_.setMessage(value);
      }
      dataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [schema][] or an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     */
    public Builder setStructData(com.google.protobuf.Struct.Builder builderForValue) {
      if (structDataBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        structDataBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [schema][] or an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     */
    public Builder mergeStructData(com.google.protobuf.Struct value) {
      if (structDataBuilder_ == null) {
        if (dataCase_ == 4 && data_ != com.google.protobuf.Struct.getDefaultInstance()) {
          data_ =
              com.google.protobuf.Struct.newBuilder((com.google.protobuf.Struct) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 4) {
          structDataBuilder_.mergeFrom(value);
        } else {
          structDataBuilder_.setMessage(value);
        }
      }
      dataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [schema][] or an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     */
    public Builder clearStructData() {
      if (structDataBuilder_ == null) {
        if (dataCase_ == 4) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 4) {
          dataCase_ = 0;
          data_ = null;
        }
        structDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [schema][] or an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     */
    public com.google.protobuf.Struct.Builder getStructDataBuilder() {
      return getStructDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [schema][] or an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getStructDataOrBuilder() {
      if ((dataCase_ == 4) && (structDataBuilder_ != null)) {
        return structDataBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 4) {
          return (com.google.protobuf.Struct) data_;
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The structured JSON data for the document. It should conform to the
     * registered [schema][] or an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getStructDataFieldBuilder() {
      if (structDataBuilder_ == null) {
        if (!(dataCase_ == 4)) {
          data_ = com.google.protobuf.Struct.getDefaultInstance();
        }
        structDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                (com.google.protobuf.Struct) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 4;
      onChanged();
      ;
      return structDataBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The JSON string representation of the document. It should conform to the
     * registered [schema][] or an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string json_data = 5;</code>
     *
     * @return Whether the jsonData field is set.
     */
    @java.lang.Override
    public boolean hasJsonData() {
      return dataCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The JSON string representation of the document. It should conform to the
     * registered [schema][] or an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string json_data = 5;</code>
     *
     * @return The jsonData.
     */
    @java.lang.Override
    public java.lang.String getJsonData() {
      java.lang.Object ref = "";
      if (dataCase_ == 5) {
        ref = data_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (dataCase_ == 5) {
          data_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The JSON string representation of the document. It should conform to the
     * registered [schema][] or an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string json_data = 5;</code>
     *
     * @return The bytes for jsonData.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getJsonDataBytes() {
      java.lang.Object ref = "";
      if (dataCase_ == 5) {
        ref = data_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (dataCase_ == 5) {
          data_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The JSON string representation of the document. It should conform to the
     * registered [schema][] or an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string json_data = 5;</code>
     *
     * @param value The jsonData to set.
     * @return This builder for chaining.
     */
    public Builder setJsonData(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataCase_ = 5;
      data_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The JSON string representation of the document. It should conform to the
     * registered [schema][] or an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string json_data = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJsonData() {
      if (dataCase_ == 5) {
        dataCase_ = 0;
        data_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The JSON string representation of the document. It should conform to the
     * registered [schema][] or an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string json_data = 5;</code>
     *
     * @param value The bytes for jsonData to set.
     * @return This builder for chaining.
     */
    public Builder setJsonDataBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataCase_ = 5;
      data_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the document.
     * Format:
     * `projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`.
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the document.
     * Format:
     * `projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`.
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the document.
     * Format:
     * `projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`.
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the document.
     * Format:
     * `projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`.
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the document.
     * Format:
     * `projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`.
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The identifier of the document.
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The identifier of the document.
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The identifier of the document.
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      id_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The identifier of the document.
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {

      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The identifier of the document.
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      id_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object schemaId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The identifier of the schema located in the same data store.
     * </pre>
     *
     * <code>string schema_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The schemaId.
     */
    public java.lang.String getSchemaId() {
      java.lang.Object ref = schemaId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schemaId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The identifier of the schema located in the same data store.
     * </pre>
     *
     * <code>string schema_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for schemaId.
     */
    public com.google.protobuf.ByteString getSchemaIdBytes() {
      java.lang.Object ref = schemaId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schemaId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The identifier of the schema located in the same data store.
     * </pre>
     *
     * <code>string schema_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The schemaId to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      schemaId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The identifier of the schema located in the same data store.
     * </pre>
     *
     * <code>string schema_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchemaId() {

      schemaId_ = getDefaultInstance().getSchemaId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The identifier of the schema located in the same data store.
     * </pre>
     *
     * <code>string schema_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for schemaId to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      schemaId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object parentDocumentId_ = "";
    /**
     *
     *
     * <pre>
     * The identifier of the parent document. Currently supports at most two level
     * document hierarchy.
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string parent_document_id = 7;</code>
     *
     * @return The parentDocumentId.
     */
    public java.lang.String getParentDocumentId() {
      java.lang.Object ref = parentDocumentId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentDocumentId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The identifier of the parent document. Currently supports at most two level
     * document hierarchy.
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string parent_document_id = 7;</code>
     *
     * @return The bytes for parentDocumentId.
     */
    public com.google.protobuf.ByteString getParentDocumentIdBytes() {
      java.lang.Object ref = parentDocumentId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentDocumentId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The identifier of the parent document. Currently supports at most two level
     * document hierarchy.
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string parent_document_id = 7;</code>
     *
     * @param value The parentDocumentId to set.
     * @return This builder for chaining.
     */
    public Builder setParentDocumentId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parentDocumentId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier of the parent document. Currently supports at most two level
     * document hierarchy.
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string parent_document_id = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentDocumentId() {

      parentDocumentId_ = getDefaultInstance().getParentDocumentId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier of the parent document. Currently supports at most two level
     * document hierarchy.
     * Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters.
     * </pre>
     *
     * <code>string parent_document_id = 7;</code>
     *
     * @param value The bytes for parentDocumentId to set.
     * @return This builder for chaining.
     */
    public Builder setParentDocumentIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parentDocumentId_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.Document)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.Document)
  private static final com.google.cloud.discoveryengine.v1beta.Document DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.Document();
  }

  public static com.google.cloud.discoveryengine.v1beta.Document getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Document> PARSER =
      new com.google.protobuf.AbstractParser<Document>() {
        @java.lang.Override
        public Document parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Document> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Document> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.Document getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
