/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/webhook.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * The request message for a webhook call. The request is sent as a JSON object
 * and the field names will be presented in camel cases.
 * You may see undocumented fields in an actual request. These fields are used
 * internally by Dialogflow and should be ignored.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.WebhookRequest}
 */
public final class WebhookRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.WebhookRequest)
    WebhookRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WebhookRequest.newBuilder() to construct.
  private WebhookRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WebhookRequest() {
    detectIntentResponseId_ = "";
    languageCode_ = "";
    messages_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WebhookRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.WebhookProto
        .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.WebhookProto
        .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.class,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.Builder.class);
  }

  public interface FulfillmentInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Always present.
     * The value of the [Fulfillment.tag][google.cloud.dialogflow.cx.v3.Fulfillment.tag] field will be populated in this
     * field by Dialogflow when the associated webhook is called.
     * The tag is typically used by the webhook service to identify which
     * fulfillment is being called, but it could be used for other purposes.
     * </pre>
     *
     * <code>string tag = 1;</code>
     *
     * @return The tag.
     */
    java.lang.String getTag();
    /**
     *
     *
     * <pre>
     * Always present.
     * The value of the [Fulfillment.tag][google.cloud.dialogflow.cx.v3.Fulfillment.tag] field will be populated in this
     * field by Dialogflow when the associated webhook is called.
     * The tag is typically used by the webhook service to identify which
     * fulfillment is being called, but it could be used for other purposes.
     * </pre>
     *
     * <code>string tag = 1;</code>
     *
     * @return The bytes for tag.
     */
    com.google.protobuf.ByteString getTagBytes();
  }
  /**
   *
   *
   * <pre>
   * Represents fulfillment information communicated to the webhook.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo}
   */
  public static final class FulfillmentInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo)
      FulfillmentInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FulfillmentInfo.newBuilder() to construct.
    private FulfillmentInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FulfillmentInfo() {
      tag_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FulfillmentInfo();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_FulfillmentInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_FulfillmentInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo.class,
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo.Builder.class);
    }

    public static final int TAG_FIELD_NUMBER = 1;
    private volatile java.lang.Object tag_;
    /**
     *
     *
     * <pre>
     * Always present.
     * The value of the [Fulfillment.tag][google.cloud.dialogflow.cx.v3.Fulfillment.tag] field will be populated in this
     * field by Dialogflow when the associated webhook is called.
     * The tag is typically used by the webhook service to identify which
     * fulfillment is being called, but it could be used for other purposes.
     * </pre>
     *
     * <code>string tag = 1;</code>
     *
     * @return The tag.
     */
    @java.lang.Override
    public java.lang.String getTag() {
      java.lang.Object ref = tag_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tag_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Always present.
     * The value of the [Fulfillment.tag][google.cloud.dialogflow.cx.v3.Fulfillment.tag] field will be populated in this
     * field by Dialogflow when the associated webhook is called.
     * The tag is typically used by the webhook service to identify which
     * fulfillment is being called, but it could be used for other purposes.
     * </pre>
     *
     * <code>string tag = 1;</code>
     *
     * @return The bytes for tag.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTagBytes() {
      java.lang.Object ref = tag_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tag_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tag_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tag_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tag_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo other =
          (com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo) obj;

      if (!getTag().equals(other.getTag())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TAG_FIELD_NUMBER;
      hash = (53 * hash) + getTag().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents fulfillment information communicated to the webhook.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo)
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_FulfillmentInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_FulfillmentInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo.class,
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        tag_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_FulfillmentInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo build() {
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo buildPartial() {
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo result =
            new com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo(this);
        result.tag_ = tag_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo
                .getDefaultInstance()) return this;
        if (!other.getTag().isEmpty()) {
          tag_ = other.tag_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  tag_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object tag_ = "";
      /**
       *
       *
       * <pre>
       * Always present.
       * The value of the [Fulfillment.tag][google.cloud.dialogflow.cx.v3.Fulfillment.tag] field will be populated in this
       * field by Dialogflow when the associated webhook is called.
       * The tag is typically used by the webhook service to identify which
       * fulfillment is being called, but it could be used for other purposes.
       * </pre>
       *
       * <code>string tag = 1;</code>
       *
       * @return The tag.
       */
      public java.lang.String getTag() {
        java.lang.Object ref = tag_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tag_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Always present.
       * The value of the [Fulfillment.tag][google.cloud.dialogflow.cx.v3.Fulfillment.tag] field will be populated in this
       * field by Dialogflow when the associated webhook is called.
       * The tag is typically used by the webhook service to identify which
       * fulfillment is being called, but it could be used for other purposes.
       * </pre>
       *
       * <code>string tag = 1;</code>
       *
       * @return The bytes for tag.
       */
      public com.google.protobuf.ByteString getTagBytes() {
        java.lang.Object ref = tag_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tag_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Always present.
       * The value of the [Fulfillment.tag][google.cloud.dialogflow.cx.v3.Fulfillment.tag] field will be populated in this
       * field by Dialogflow when the associated webhook is called.
       * The tag is typically used by the webhook service to identify which
       * fulfillment is being called, but it could be used for other purposes.
       * </pre>
       *
       * <code>string tag = 1;</code>
       *
       * @param value The tag to set.
       * @return This builder for chaining.
       */
      public Builder setTag(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        tag_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Always present.
       * The value of the [Fulfillment.tag][google.cloud.dialogflow.cx.v3.Fulfillment.tag] field will be populated in this
       * field by Dialogflow when the associated webhook is called.
       * The tag is typically used by the webhook service to identify which
       * fulfillment is being called, but it could be used for other purposes.
       * </pre>
       *
       * <code>string tag = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTag() {

        tag_ = getDefaultInstance().getTag();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Always present.
       * The value of the [Fulfillment.tag][google.cloud.dialogflow.cx.v3.Fulfillment.tag] field will be populated in this
       * field by Dialogflow when the associated webhook is called.
       * The tag is typically used by the webhook service to identify which
       * fulfillment is being called, but it could be used for other purposes.
       * </pre>
       *
       * <code>string tag = 1;</code>
       *
       * @param value The bytes for tag to set.
       * @return This builder for chaining.
       */
      public Builder setTagBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        tag_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo)
    private static final com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo();
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FulfillmentInfo> PARSER =
        new com.google.protobuf.AbstractParser<FulfillmentInfo>() {
          @java.lang.Override
          public FulfillmentInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FulfillmentInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FulfillmentInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IntentInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Always present. The unique identifier of the last matched
     * [intent][google.cloud.dialogflow.cx.v3.Intent].
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string last_matched_intent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The lastMatchedIntent.
     */
    java.lang.String getLastMatchedIntent();
    /**
     *
     *
     * <pre>
     * Always present. The unique identifier of the last matched
     * [intent][google.cloud.dialogflow.cx.v3.Intent].
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string last_matched_intent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for lastMatchedIntent.
     */
    com.google.protobuf.ByteString getLastMatchedIntentBytes();

    /**
     *
     *
     * <pre>
     * Always present. The display name of the last matched [intent][google.cloud.dialogflow.cx.v3.Intent].
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * Always present. The display name of the last matched [intent][google.cloud.dialogflow.cx.v3.Intent].
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Parameters identified as a result of intent matching. This is a map of
     * the name of the identified parameter to the value of the parameter
     * identified from the user's utterance. All parameters defined in the
     * matched intent that are identified will be surfaced here.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
     * </code>
     */
    int getParametersCount();
    /**
     *
     *
     * <pre>
     * Parameters identified as a result of intent matching. This is a map of
     * the name of the identified parameter to the value of the parameter
     * identified from the user's utterance. All parameters defined in the
     * matched intent that are identified will be surfaced here.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
     * </code>
     */
    boolean containsParameters(java.lang.String key);
    /** Use {@link #getParametersMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<
            java.lang.String,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
        getParameters();
    /**
     *
     *
     * <pre>
     * Parameters identified as a result of intent matching. This is a map of
     * the name of the identified parameter to the value of the parameter
     * identified from the user's utterance. All parameters defined in the
     * matched intent that are identified will be surfaced here.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
     * </code>
     */
    java.util.Map<
            java.lang.String,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
        getParametersMap();
    /**
     *
     *
     * <pre>
     * Parameters identified as a result of intent matching. This is a map of
     * the name of the identified parameter to the value of the parameter
     * identified from the user's utterance. All parameters defined in the
     * matched intent that are identified will be surfaced here.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
     * </code>
     */

    /* nullable */
    com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
        getParametersOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
                defaultValue);
    /**
     *
     *
     * <pre>
     * Parameters identified as a result of intent matching. This is a map of
     * the name of the identified parameter to the value of the parameter
     * identified from the user's utterance. All parameters defined in the
     * matched intent that are identified will be surfaced here.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
        getParametersOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * The confidence of the matched intent. Values range from 0.0 (completely
     * uncertain) to 1.0 (completely certain).
     * </pre>
     *
     * <code>float confidence = 4;</code>
     *
     * @return The confidence.
     */
    float getConfidence();
  }
  /**
   *
   *
   * <pre>
   * Represents intent information communicated to the webhook.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo}
   */
  public static final class IntentInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo)
      IntentInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IntentInfo.newBuilder() to construct.
    private IntentInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IntentInfo() {
      lastMatchedIntent_ = "";
      displayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IntentInfo();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_IntentInfo_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetParameters();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_IntentInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.class,
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.Builder.class);
    }

    public interface IntentParameterValueOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Always present. Original text value extracted from user utterance.
       * </pre>
       *
       * <code>string original_value = 1;</code>
       *
       * @return The originalValue.
       */
      java.lang.String getOriginalValue();
      /**
       *
       *
       * <pre>
       * Always present. Original text value extracted from user utterance.
       * </pre>
       *
       * <code>string original_value = 1;</code>
       *
       * @return The bytes for originalValue.
       */
      com.google.protobuf.ByteString getOriginalValueBytes();

      /**
       *
       *
       * <pre>
       * Always present. Structured value for the parameter extracted from user
       * utterance.
       * </pre>
       *
       * <code>.google.protobuf.Value resolved_value = 2;</code>
       *
       * @return Whether the resolvedValue field is set.
       */
      boolean hasResolvedValue();
      /**
       *
       *
       * <pre>
       * Always present. Structured value for the parameter extracted from user
       * utterance.
       * </pre>
       *
       * <code>.google.protobuf.Value resolved_value = 2;</code>
       *
       * @return The resolvedValue.
       */
      com.google.protobuf.Value getResolvedValue();
      /**
       *
       *
       * <pre>
       * Always present. Structured value for the parameter extracted from user
       * utterance.
       * </pre>
       *
       * <code>.google.protobuf.Value resolved_value = 2;</code>
       */
      com.google.protobuf.ValueOrBuilder getResolvedValueOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Represents a value for an intent parameter.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue}
     */
    public static final class IntentParameterValue extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue)
        IntentParameterValueOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use IntentParameterValue.newBuilder() to construct.
      private IntentParameterValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private IntentParameterValue() {
        originalValue_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new IntentParameterValue();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_IntentInfo_IntentParameterValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_IntentInfo_IntentParameterValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
                    .class,
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
                    .Builder.class);
      }

      public static final int ORIGINAL_VALUE_FIELD_NUMBER = 1;
      private volatile java.lang.Object originalValue_;
      /**
       *
       *
       * <pre>
       * Always present. Original text value extracted from user utterance.
       * </pre>
       *
       * <code>string original_value = 1;</code>
       *
       * @return The originalValue.
       */
      @java.lang.Override
      public java.lang.String getOriginalValue() {
        java.lang.Object ref = originalValue_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          originalValue_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Always present. Original text value extracted from user utterance.
       * </pre>
       *
       * <code>string original_value = 1;</code>
       *
       * @return The bytes for originalValue.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getOriginalValueBytes() {
        java.lang.Object ref = originalValue_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          originalValue_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int RESOLVED_VALUE_FIELD_NUMBER = 2;
      private com.google.protobuf.Value resolvedValue_;
      /**
       *
       *
       * <pre>
       * Always present. Structured value for the parameter extracted from user
       * utterance.
       * </pre>
       *
       * <code>.google.protobuf.Value resolved_value = 2;</code>
       *
       * @return Whether the resolvedValue field is set.
       */
      @java.lang.Override
      public boolean hasResolvedValue() {
        return resolvedValue_ != null;
      }
      /**
       *
       *
       * <pre>
       * Always present. Structured value for the parameter extracted from user
       * utterance.
       * </pre>
       *
       * <code>.google.protobuf.Value resolved_value = 2;</code>
       *
       * @return The resolvedValue.
       */
      @java.lang.Override
      public com.google.protobuf.Value getResolvedValue() {
        return resolvedValue_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : resolvedValue_;
      }
      /**
       *
       *
       * <pre>
       * Always present. Structured value for the parameter extracted from user
       * utterance.
       * </pre>
       *
       * <code>.google.protobuf.Value resolved_value = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.ValueOrBuilder getResolvedValueOrBuilder() {
        return getResolvedValue();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(originalValue_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, originalValue_);
        }
        if (resolvedValue_ != null) {
          output.writeMessage(2, getResolvedValue());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(originalValue_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, originalValue_);
        }
        if (resolvedValue_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getResolvedValue());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue other =
            (com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue) obj;

        if (!getOriginalValue().equals(other.getOriginalValue())) return false;
        if (hasResolvedValue() != other.hasResolvedValue()) return false;
        if (hasResolvedValue()) {
          if (!getResolvedValue().equals(other.getResolvedValue())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ORIGINAL_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getOriginalValue().hashCode();
        if (hasResolvedValue()) {
          hash = (37 * hash) + RESOLVED_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getResolvedValue().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Represents a value for an intent parameter.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue)
          com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo
              .IntentParameterValueOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3.WebhookProto
              .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_IntentInfo_IntentParameterValue_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3.WebhookProto
              .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_IntentInfo_IntentParameterValue_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
                      .class,
                  com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          originalValue_ = "";

          if (resolvedValueBuilder_ == null) {
            resolvedValue_ = null;
          } else {
            resolvedValue_ = null;
            resolvedValueBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3.WebhookProto
              .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_IntentInfo_IntentParameterValue_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
            build() {
          com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue result =
              new com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue(
                  this);
          result.originalValue_ = originalValue_;
          if (resolvedValueBuilder_ == null) {
            result.resolvedValue_ = resolvedValue_;
          } else {
            result.resolvedValue_ = resolvedValueBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
                other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
                  .getDefaultInstance()) return this;
          if (!other.getOriginalValue().isEmpty()) {
            originalValue_ = other.originalValue_;
            onChanged();
          }
          if (other.hasResolvedValue()) {
            mergeResolvedValue(other.getResolvedValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    originalValue_ = input.readStringRequireUtf8();

                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getResolvedValueFieldBuilder().getBuilder(), extensionRegistry);

                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private java.lang.Object originalValue_ = "";
        /**
         *
         *
         * <pre>
         * Always present. Original text value extracted from user utterance.
         * </pre>
         *
         * <code>string original_value = 1;</code>
         *
         * @return The originalValue.
         */
        public java.lang.String getOriginalValue() {
          java.lang.Object ref = originalValue_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            originalValue_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Always present. Original text value extracted from user utterance.
         * </pre>
         *
         * <code>string original_value = 1;</code>
         *
         * @return The bytes for originalValue.
         */
        public com.google.protobuf.ByteString getOriginalValueBytes() {
          java.lang.Object ref = originalValue_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            originalValue_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Always present. Original text value extracted from user utterance.
         * </pre>
         *
         * <code>string original_value = 1;</code>
         *
         * @param value The originalValue to set.
         * @return This builder for chaining.
         */
        public Builder setOriginalValue(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          originalValue_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Always present. Original text value extracted from user utterance.
         * </pre>
         *
         * <code>string original_value = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOriginalValue() {

          originalValue_ = getDefaultInstance().getOriginalValue();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Always present. Original text value extracted from user utterance.
         * </pre>
         *
         * <code>string original_value = 1;</code>
         *
         * @param value The bytes for originalValue to set.
         * @return This builder for chaining.
         */
        public Builder setOriginalValueBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          originalValue_ = value;
          onChanged();
          return this;
        }

        private com.google.protobuf.Value resolvedValue_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>
            resolvedValueBuilder_;
        /**
         *
         *
         * <pre>
         * Always present. Structured value for the parameter extracted from user
         * utterance.
         * </pre>
         *
         * <code>.google.protobuf.Value resolved_value = 2;</code>
         *
         * @return Whether the resolvedValue field is set.
         */
        public boolean hasResolvedValue() {
          return resolvedValueBuilder_ != null || resolvedValue_ != null;
        }
        /**
         *
         *
         * <pre>
         * Always present. Structured value for the parameter extracted from user
         * utterance.
         * </pre>
         *
         * <code>.google.protobuf.Value resolved_value = 2;</code>
         *
         * @return The resolvedValue.
         */
        public com.google.protobuf.Value getResolvedValue() {
          if (resolvedValueBuilder_ == null) {
            return resolvedValue_ == null
                ? com.google.protobuf.Value.getDefaultInstance()
                : resolvedValue_;
          } else {
            return resolvedValueBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Always present. Structured value for the parameter extracted from user
         * utterance.
         * </pre>
         *
         * <code>.google.protobuf.Value resolved_value = 2;</code>
         */
        public Builder setResolvedValue(com.google.protobuf.Value value) {
          if (resolvedValueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            resolvedValue_ = value;
            onChanged();
          } else {
            resolvedValueBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Always present. Structured value for the parameter extracted from user
         * utterance.
         * </pre>
         *
         * <code>.google.protobuf.Value resolved_value = 2;</code>
         */
        public Builder setResolvedValue(com.google.protobuf.Value.Builder builderForValue) {
          if (resolvedValueBuilder_ == null) {
            resolvedValue_ = builderForValue.build();
            onChanged();
          } else {
            resolvedValueBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Always present. Structured value for the parameter extracted from user
         * utterance.
         * </pre>
         *
         * <code>.google.protobuf.Value resolved_value = 2;</code>
         */
        public Builder mergeResolvedValue(com.google.protobuf.Value value) {
          if (resolvedValueBuilder_ == null) {
            if (resolvedValue_ != null) {
              resolvedValue_ =
                  com.google.protobuf.Value.newBuilder(resolvedValue_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              resolvedValue_ = value;
            }
            onChanged();
          } else {
            resolvedValueBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Always present. Structured value for the parameter extracted from user
         * utterance.
         * </pre>
         *
         * <code>.google.protobuf.Value resolved_value = 2;</code>
         */
        public Builder clearResolvedValue() {
          if (resolvedValueBuilder_ == null) {
            resolvedValue_ = null;
            onChanged();
          } else {
            resolvedValue_ = null;
            resolvedValueBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Always present. Structured value for the parameter extracted from user
         * utterance.
         * </pre>
         *
         * <code>.google.protobuf.Value resolved_value = 2;</code>
         */
        public com.google.protobuf.Value.Builder getResolvedValueBuilder() {

          onChanged();
          return getResolvedValueFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Always present. Structured value for the parameter extracted from user
         * utterance.
         * </pre>
         *
         * <code>.google.protobuf.Value resolved_value = 2;</code>
         */
        public com.google.protobuf.ValueOrBuilder getResolvedValueOrBuilder() {
          if (resolvedValueBuilder_ != null) {
            return resolvedValueBuilder_.getMessageOrBuilder();
          } else {
            return resolvedValue_ == null
                ? com.google.protobuf.Value.getDefaultInstance()
                : resolvedValue_;
          }
        }
        /**
         *
         *
         * <pre>
         * Always present. Structured value for the parameter extracted from user
         * utterance.
         * </pre>
         *
         * <code>.google.protobuf.Value resolved_value = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>
            getResolvedValueFieldBuilder() {
          if (resolvedValueBuilder_ == null) {
            resolvedValueBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Value,
                    com.google.protobuf.Value.Builder,
                    com.google.protobuf.ValueOrBuilder>(
                    getResolvedValue(), getParentForChildren(), isClean());
            resolvedValue_ = null;
          }
          return resolvedValueBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue)
      private static final com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo
              .IntentParameterValue
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue();
      }

      public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<IntentParameterValue> PARSER =
          new com.google.protobuf.AbstractParser<IntentParameterValue>() {
            @java.lang.Override
            public IntentParameterValue parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<IntentParameterValue> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<IntentParameterValue> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int LAST_MATCHED_INTENT_FIELD_NUMBER = 1;
    private volatile java.lang.Object lastMatchedIntent_;
    /**
     *
     *
     * <pre>
     * Always present. The unique identifier of the last matched
     * [intent][google.cloud.dialogflow.cx.v3.Intent].
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string last_matched_intent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The lastMatchedIntent.
     */
    @java.lang.Override
    public java.lang.String getLastMatchedIntent() {
      java.lang.Object ref = lastMatchedIntent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lastMatchedIntent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Always present. The unique identifier of the last matched
     * [intent][google.cloud.dialogflow.cx.v3.Intent].
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string last_matched_intent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for lastMatchedIntent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLastMatchedIntentBytes() {
      java.lang.Object ref = lastMatchedIntent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lastMatchedIntent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 3;
    private volatile java.lang.Object displayName_;
    /**
     *
     *
     * <pre>
     * Always present. The display name of the last matched [intent][google.cloud.dialogflow.cx.v3.Intent].
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Always present. The display name of the last matched [intent][google.cloud.dialogflow.cx.v3.Intent].
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARAMETERS_FIELD_NUMBER = 2;

    private static final class ParametersDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String,
                      com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo
                          .IntentParameterValue>
                      newDefaultInstance(
                          com.google.cloud.dialogflow.cx.v3.WebhookProto
                              .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_IntentInfo_ParametersEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo
                              .IntentParameterValue.getDefaultInstance());
    }

    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
        parameters_;

    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
        internalGetParameters() {
      if (parameters_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ParametersDefaultEntryHolder.defaultEntry);
      }
      return parameters_;
    }

    public int getParametersCount() {
      return internalGetParameters().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Parameters identified as a result of intent matching. This is a map of
     * the name of the identified parameter to the value of the parameter
     * identified from the user's utterance. All parameters defined in the
     * matched intent that are identified will be surfaced here.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
     * </code>
     */
    @java.lang.Override
    public boolean containsParameters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParameters().getMap().containsKey(key);
    }
    /** Use {@link #getParametersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
        getParameters() {
      return getParametersMap();
    }
    /**
     *
     *
     * <pre>
     * Parameters identified as a result of intent matching. This is a map of
     * the name of the identified parameter to the value of the parameter
     * identified from the user's utterance. All parameters defined in the
     * matched intent that are identified will be surfaced here.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
        getParametersMap() {
      return internalGetParameters().getMap();
    }
    /**
     *
     *
     * <pre>
     * Parameters identified as a result of intent matching. This is a map of
     * the name of the identified parameter to the value of the parameter
     * identified from the user's utterance. All parameters defined in the
     * matched intent that are identified will be surfaced here.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
        getParametersOrDefault(
            java.lang.String key,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
                defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
          map = internalGetParameters().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Parameters identified as a result of intent matching. This is a map of
     * the name of the identified parameter to the value of the parameter
     * identified from the user's utterance. All parameters defined in the
     * matched intent that are identified will be surfaced here.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
        getParametersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
          map = internalGetParameters().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int CONFIDENCE_FIELD_NUMBER = 4;
    private float confidence_;
    /**
     *
     *
     * <pre>
     * The confidence of the matched intent. Values range from 0.0 (completely
     * uncertain) to 1.0 (completely certain).
     * </pre>
     *
     * <code>float confidence = 4;</code>
     *
     * @return The confidence.
     */
    @java.lang.Override
    public float getConfidence() {
      return confidence_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastMatchedIntent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, lastMatchedIntent_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetParameters(), ParametersDefaultEntryHolder.defaultEntry, 2);
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
      }
      if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
        output.writeFloat(4, confidence_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastMatchedIntent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, lastMatchedIntent_);
      }
      for (java.util.Map.Entry<
              java.lang.String,
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
          entry : internalGetParameters().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
            parameters__ =
                ParametersDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, parameters__);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
      }
      if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, confidence_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo other =
          (com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo) obj;

      if (!getLastMatchedIntent().equals(other.getLastMatchedIntent())) return false;
      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (!internalGetParameters().equals(other.internalGetParameters())) return false;
      if (java.lang.Float.floatToIntBits(getConfidence())
          != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LAST_MATCHED_INTENT_FIELD_NUMBER;
      hash = (53 * hash) + getLastMatchedIntent().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      if (!internalGetParameters().getMap().isEmpty()) {
        hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetParameters().hashCode();
      }
      hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents intent information communicated to the webhook.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo)
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_IntentInfo_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 2:
            return internalGetParameters();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 2:
            return internalGetMutableParameters();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_IntentInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.class,
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        lastMatchedIntent_ = "";

        displayName_ = "";

        internalGetMutableParameters().clear();
        confidence_ = 0F;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_IntentInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo build() {
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo buildPartial() {
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo result =
            new com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo(this);
        int from_bitField0_ = bitField0_;
        result.lastMatchedIntent_ = lastMatchedIntent_;
        result.displayName_ = displayName_;
        result.parameters_ = internalGetParameters();
        result.parameters_.makeImmutable();
        result.confidence_ = confidence_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.getDefaultInstance())
          return this;
        if (!other.getLastMatchedIntent().isEmpty()) {
          lastMatchedIntent_ = other.lastMatchedIntent_;
          onChanged();
        }
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          onChanged();
        }
        internalGetMutableParameters().mergeFrom(other.internalGetParameters());
        if (other.getConfidence() != 0F) {
          setConfidence(other.getConfidence());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  lastMatchedIntent_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String,
                          com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo
                              .IntentParameterValue>
                      parameters__ =
                          input.readMessage(
                              ParametersDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableParameters()
                      .getMutableMap()
                      .put(parameters__.getKey(), parameters__.getValue());
                  break;
                } // case 18
              case 26:
                {
                  displayName_ = input.readStringRequireUtf8();

                  break;
                } // case 26
              case 37:
                {
                  confidence_ = input.readFloat();

                  break;
                } // case 37
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object lastMatchedIntent_ = "";
      /**
       *
       *
       * <pre>
       * Always present. The unique identifier of the last matched
       * [intent][google.cloud.dialogflow.cx.v3.Intent].
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;/intents/&lt;Intent ID&gt;`.
       * </pre>
       *
       * <code>string last_matched_intent = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The lastMatchedIntent.
       */
      public java.lang.String getLastMatchedIntent() {
        java.lang.Object ref = lastMatchedIntent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          lastMatchedIntent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Always present. The unique identifier of the last matched
       * [intent][google.cloud.dialogflow.cx.v3.Intent].
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;/intents/&lt;Intent ID&gt;`.
       * </pre>
       *
       * <code>string last_matched_intent = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for lastMatchedIntent.
       */
      public com.google.protobuf.ByteString getLastMatchedIntentBytes() {
        java.lang.Object ref = lastMatchedIntent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          lastMatchedIntent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Always present. The unique identifier of the last matched
       * [intent][google.cloud.dialogflow.cx.v3.Intent].
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;/intents/&lt;Intent ID&gt;`.
       * </pre>
       *
       * <code>string last_matched_intent = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The lastMatchedIntent to set.
       * @return This builder for chaining.
       */
      public Builder setLastMatchedIntent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        lastMatchedIntent_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Always present. The unique identifier of the last matched
       * [intent][google.cloud.dialogflow.cx.v3.Intent].
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;/intents/&lt;Intent ID&gt;`.
       * </pre>
       *
       * <code>string last_matched_intent = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLastMatchedIntent() {

        lastMatchedIntent_ = getDefaultInstance().getLastMatchedIntent();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Always present. The unique identifier of the last matched
       * [intent][google.cloud.dialogflow.cx.v3.Intent].
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;/intents/&lt;Intent ID&gt;`.
       * </pre>
       *
       * <code>string last_matched_intent = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for lastMatchedIntent to set.
       * @return This builder for chaining.
       */
      public Builder setLastMatchedIntentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        lastMatchedIntent_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * Always present. The display name of the last matched [intent][google.cloud.dialogflow.cx.v3.Intent].
       * </pre>
       *
       * <code>string display_name = 3;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Always present. The display name of the last matched [intent][google.cloud.dialogflow.cx.v3.Intent].
       * </pre>
       *
       * <code>string display_name = 3;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Always present. The display name of the last matched [intent][google.cloud.dialogflow.cx.v3.Intent].
       * </pre>
       *
       * <code>string display_name = 3;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        displayName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Always present. The display name of the last matched [intent][google.cloud.dialogflow.cx.v3.Intent].
       * </pre>
       *
       * <code>string display_name = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {

        displayName_ = getDefaultInstance().getDisplayName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Always present. The display name of the last matched [intent][google.cloud.dialogflow.cx.v3.Intent].
       * </pre>
       *
       * <code>string display_name = 3;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        displayName_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<
              java.lang.String,
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
          parameters_;

      private com.google.protobuf.MapField<
              java.lang.String,
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
          internalGetParameters() {
        if (parameters_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              ParametersDefaultEntryHolder.defaultEntry);
        }
        return parameters_;
      }

      private com.google.protobuf.MapField<
              java.lang.String,
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
          internalGetMutableParameters() {
        onChanged();
        ;
        if (parameters_ == null) {
          parameters_ =
              com.google.protobuf.MapField.newMapField(ParametersDefaultEntryHolder.defaultEntry);
        }
        if (!parameters_.isMutable()) {
          parameters_ = parameters_.copy();
        }
        return parameters_;
      }

      public int getParametersCount() {
        return internalGetParameters().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Parameters identified as a result of intent matching. This is a map of
       * the name of the identified parameter to the value of the parameter
       * identified from the user's utterance. All parameters defined in the
       * matched intent that are identified will be surfaced here.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
       * </code>
       */
      @java.lang.Override
      public boolean containsParameters(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetParameters().getMap().containsKey(key);
      }
      /** Use {@link #getParametersMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
          getParameters() {
        return getParametersMap();
      }
      /**
       *
       *
       * <pre>
       * Parameters identified as a result of intent matching. This is a map of
       * the name of the identified parameter to the value of the parameter
       * identified from the user's utterance. All parameters defined in the
       * matched intent that are identified will be surfaced here.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String,
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
          getParametersMap() {
        return internalGetParameters().getMap();
      }
      /**
       *
       *
       * <pre>
       * Parameters identified as a result of intent matching. This is a map of
       * the name of the identified parameter to the value of the parameter
       * identified from the user's utterance. All parameters defined in the
       * matched intent that are identified will be surfaced here.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          getParametersOrDefault(
              java.lang.String key,
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
                  defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
            map = internalGetParameters().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Parameters identified as a result of intent matching. This is a map of
       * the name of the identified parameter to the value of the parameter
       * identified from the user's utterance. All parameters defined in the
       * matched intent that are identified will be surfaced here.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
          getParametersOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
            map = internalGetParameters().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearParameters() {
        internalGetMutableParameters().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parameters identified as a result of intent matching. This is a map of
       * the name of the identified parameter to the value of the parameter
       * identified from the user's utterance. All parameters defined in the
       * matched intent that are identified will be surfaced here.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
       * </code>
       */
      public Builder removeParameters(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableParameters().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
          getMutableParameters() {
        return internalGetMutableParameters().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Parameters identified as a result of intent matching. This is a map of
       * the name of the identified parameter to the value of the parameter
       * identified from the user's utterance. All parameters defined in the
       * matched intent that are identified will be surfaced here.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
       * </code>
       */
      public Builder putParameters(
          java.lang.String key,
          com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }

        internalGetMutableParameters().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parameters identified as a result of intent matching. This is a map of
       * the name of the identified parameter to the value of the parameter
       * identified from the user's utterance. All parameters defined in the
       * matched intent that are identified will be surfaced here.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue&gt; parameters = 2;
       * </code>
       */
      public Builder putAllParameters(
          java.util.Map<
                  java.lang.String,
                  com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue>
              values) {
        internalGetMutableParameters().getMutableMap().putAll(values);
        return this;
      }

      private float confidence_;
      /**
       *
       *
       * <pre>
       * The confidence of the matched intent. Values range from 0.0 (completely
       * uncertain) to 1.0 (completely certain).
       * </pre>
       *
       * <code>float confidence = 4;</code>
       *
       * @return The confidence.
       */
      @java.lang.Override
      public float getConfidence() {
        return confidence_;
      }
      /**
       *
       *
       * <pre>
       * The confidence of the matched intent. Values range from 0.0 (completely
       * uncertain) to 1.0 (completely certain).
       * </pre>
       *
       * <code>float confidence = 4;</code>
       *
       * @param value The confidence to set.
       * @return This builder for chaining.
       */
      public Builder setConfidence(float value) {

        confidence_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The confidence of the matched intent. Values range from 0.0 (completely
       * uncertain) to 1.0 (completely certain).
       * </pre>
       *
       * <code>float confidence = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConfidence() {

        confidence_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo)
    private static final com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo();
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IntentInfo> PARSER =
        new com.google.protobuf.AbstractParser<IntentInfo>() {
          @java.lang.Override
          public IntentInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IntentInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IntentInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SentimentAnalysisResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
     * sentiment).
     * </pre>
     *
     * <code>float score = 1;</code>
     *
     * @return The score.
     */
    float getScore();

    /**
     *
     *
     * <pre>
     * A non-negative number in the [0, +inf) range, which represents the
     * absolute magnitude of sentiment, regardless of score (positive or
     * negative).
     * </pre>
     *
     * <code>float magnitude = 2;</code>
     *
     * @return The magnitude.
     */
    float getMagnitude();
  }
  /**
   *
   *
   * <pre>
   * Represents the result of sentiment analysis.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult}
   */
  public static final class SentimentAnalysisResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult)
      SentimentAnalysisResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SentimentAnalysisResult.newBuilder() to construct.
    private SentimentAnalysisResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SentimentAnalysisResult() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SentimentAnalysisResult();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_SentimentAnalysisResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_SentimentAnalysisResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult.class,
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult.Builder
                  .class);
    }

    public static final int SCORE_FIELD_NUMBER = 1;
    private float score_;
    /**
     *
     *
     * <pre>
     * Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
     * sentiment).
     * </pre>
     *
     * <code>float score = 1;</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public float getScore() {
      return score_;
    }

    public static final int MAGNITUDE_FIELD_NUMBER = 2;
    private float magnitude_;
    /**
     *
     *
     * <pre>
     * A non-negative number in the [0, +inf) range, which represents the
     * absolute magnitude of sentiment, regardless of score (positive or
     * negative).
     * </pre>
     *
     * <code>float magnitude = 2;</code>
     *
     * @return The magnitude.
     */
    @java.lang.Override
    public float getMagnitude() {
      return magnitude_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Float.floatToRawIntBits(score_) != 0) {
        output.writeFloat(1, score_);
      }
      if (java.lang.Float.floatToRawIntBits(magnitude_) != 0) {
        output.writeFloat(2, magnitude_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Float.floatToRawIntBits(score_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, score_);
      }
      if (java.lang.Float.floatToRawIntBits(magnitude_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, magnitude_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult other =
          (com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult) obj;

      if (java.lang.Float.floatToIntBits(getScore())
          != java.lang.Float.floatToIntBits(other.getScore())) return false;
      if (java.lang.Float.floatToIntBits(getMagnitude())
          != java.lang.Float.floatToIntBits(other.getMagnitude())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SCORE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getScore());
      hash = (37 * hash) + MAGNITUDE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getMagnitude());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents the result of sentiment analysis.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult)
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_SentimentAnalysisResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_SentimentAnalysisResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult.class,
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        score_ = 0F;

        magnitude_ = 0F;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_SentimentAnalysisResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult build() {
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult result =
            new com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult(this);
        result.score_ = score_;
        result.magnitude_ = magnitude_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
                .getDefaultInstance()) return this;
        if (other.getScore() != 0F) {
          setScore(other.getScore());
        }
        if (other.getMagnitude() != 0F) {
          setMagnitude(other.getMagnitude());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  score_ = input.readFloat();

                  break;
                } // case 13
              case 21:
                {
                  magnitude_ = input.readFloat();

                  break;
                } // case 21
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private float score_;
      /**
       *
       *
       * <pre>
       * Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
       * sentiment).
       * </pre>
       *
       * <code>float score = 1;</code>
       *
       * @return The score.
       */
      @java.lang.Override
      public float getScore() {
        return score_;
      }
      /**
       *
       *
       * <pre>
       * Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
       * sentiment).
       * </pre>
       *
       * <code>float score = 1;</code>
       *
       * @param value The score to set.
       * @return This builder for chaining.
       */
      public Builder setScore(float value) {

        score_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
       * sentiment).
       * </pre>
       *
       * <code>float score = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScore() {

        score_ = 0F;
        onChanged();
        return this;
      }

      private float magnitude_;
      /**
       *
       *
       * <pre>
       * A non-negative number in the [0, +inf) range, which represents the
       * absolute magnitude of sentiment, regardless of score (positive or
       * negative).
       * </pre>
       *
       * <code>float magnitude = 2;</code>
       *
       * @return The magnitude.
       */
      @java.lang.Override
      public float getMagnitude() {
        return magnitude_;
      }
      /**
       *
       *
       * <pre>
       * A non-negative number in the [0, +inf) range, which represents the
       * absolute magnitude of sentiment, regardless of score (positive or
       * negative).
       * </pre>
       *
       * <code>float magnitude = 2;</code>
       *
       * @param value The magnitude to set.
       * @return This builder for chaining.
       */
      public Builder setMagnitude(float value) {

        magnitude_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A non-negative number in the [0, +inf) range, which represents the
       * absolute magnitude of sentiment, regardless of score (positive or
       * negative).
       * </pre>
       *
       * <code>float magnitude = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMagnitude() {

        magnitude_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult)
    private static final com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult();
    }

    public static com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SentimentAnalysisResult> PARSER =
        new com.google.protobuf.AbstractParser<SentimentAnalysisResult>() {
          @java.lang.Override
          public SentimentAnalysisResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SentimentAnalysisResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SentimentAnalysisResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int queryCase_ = 0;
  private java.lang.Object query_;

  public enum QueryCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEXT(10),
    TRIGGER_INTENT(11),
    TRANSCRIPT(12),
    TRIGGER_EVENT(14),
    QUERY_NOT_SET(0);
    private final int value;

    private QueryCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueryCase valueOf(int value) {
      return forNumber(value);
    }

    public static QueryCase forNumber(int value) {
      switch (value) {
        case 10:
          return TEXT;
        case 11:
          return TRIGGER_INTENT;
        case 12:
          return TRANSCRIPT;
        case 14:
          return TRIGGER_EVENT;
        case 0:
          return QUERY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public QueryCase getQueryCase() {
    return QueryCase.forNumber(queryCase_);
  }

  public static final int DETECT_INTENT_RESPONSE_ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object detectIntentResponseId_;
  /**
   *
   *
   * <pre>
   * Always present. The unique identifier of the [DetectIntentResponse][google.cloud.dialogflow.cx.v3.DetectIntentResponse] that
   * will be returned to the API caller.
   * </pre>
   *
   * <code>string detect_intent_response_id = 1;</code>
   *
   * @return The detectIntentResponseId.
   */
  @java.lang.Override
  public java.lang.String getDetectIntentResponseId() {
    java.lang.Object ref = detectIntentResponseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      detectIntentResponseId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Always present. The unique identifier of the [DetectIntentResponse][google.cloud.dialogflow.cx.v3.DetectIntentResponse] that
   * will be returned to the API caller.
   * </pre>
   *
   * <code>string detect_intent_response_id = 1;</code>
   *
   * @return The bytes for detectIntentResponseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDetectIntentResponseIdBytes() {
    java.lang.Object ref = detectIntentResponseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      detectIntentResponseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TEXT_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was provided as input, this field
   * will contain a copy of the text.
   * </pre>
   *
   * <code>string text = 10;</code>
   *
   * @return Whether the text field is set.
   */
  public boolean hasText() {
    return queryCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was provided as input, this field
   * will contain a copy of the text.
   * </pre>
   *
   * <code>string text = 10;</code>
   *
   * @return The text.
   */
  public java.lang.String getText() {
    java.lang.Object ref = "";
    if (queryCase_ == 10) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (queryCase_ == 10) {
        query_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was provided as input, this field
   * will contain a copy of the text.
   * </pre>
   *
   * <code>string text = 10;</code>
   *
   * @return The bytes for text.
   */
  public com.google.protobuf.ByteString getTextBytes() {
    java.lang.Object ref = "";
    if (queryCase_ == 10) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (queryCase_ == 10) {
        query_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRIGGER_INTENT_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as input, this field will
   * contain a copy of the intent identifier.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/intents/&lt;Intent ID&gt;`.
   * </pre>
   *
   * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the triggerIntent field is set.
   */
  public boolean hasTriggerIntent() {
    return queryCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as input, this field will
   * contain a copy of the intent identifier.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/intents/&lt;Intent ID&gt;`.
   * </pre>
   *
   * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The triggerIntent.
   */
  public java.lang.String getTriggerIntent() {
    java.lang.Object ref = "";
    if (queryCase_ == 11) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (queryCase_ == 11) {
        query_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as input, this field will
   * contain a copy of the intent identifier.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/intents/&lt;Intent ID&gt;`.
   * </pre>
   *
   * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for triggerIntent.
   */
  public com.google.protobuf.ByteString getTriggerIntentBytes() {
    java.lang.Object ref = "";
    if (queryCase_ == 11) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (queryCase_ == 11) {
        query_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSCRIPT_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * If [natural language speech audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
   * this field will contain the transcript for the audio.
   * </pre>
   *
   * <code>string transcript = 12;</code>
   *
   * @return Whether the transcript field is set.
   */
  public boolean hasTranscript() {
    return queryCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * If [natural language speech audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
   * this field will contain the transcript for the audio.
   * </pre>
   *
   * <code>string transcript = 12;</code>
   *
   * @return The transcript.
   */
  public java.lang.String getTranscript() {
    java.lang.Object ref = "";
    if (queryCase_ == 12) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (queryCase_ == 12) {
        query_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If [natural language speech audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
   * this field will contain the transcript for the audio.
   * </pre>
   *
   * <code>string transcript = 12;</code>
   *
   * @return The bytes for transcript.
   */
  public com.google.protobuf.ByteString getTranscriptBytes() {
    java.lang.Object ref = "";
    if (queryCase_ == 12) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (queryCase_ == 12) {
        query_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRIGGER_EVENT_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as input, this field will contain
   * the name of the event.
   * </pre>
   *
   * <code>string trigger_event = 14;</code>
   *
   * @return Whether the triggerEvent field is set.
   */
  public boolean hasTriggerEvent() {
    return queryCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as input, this field will contain
   * the name of the event.
   * </pre>
   *
   * <code>string trigger_event = 14;</code>
   *
   * @return The triggerEvent.
   */
  public java.lang.String getTriggerEvent() {
    java.lang.Object ref = "";
    if (queryCase_ == 14) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (queryCase_ == 14) {
        query_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as input, this field will contain
   * the name of the event.
   * </pre>
   *
   * <code>string trigger_event = 14;</code>
   *
   * @return The bytes for triggerEvent.
   */
  public com.google.protobuf.ByteString getTriggerEventBytes() {
    java.lang.Object ref = "";
    if (queryCase_ == 14) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (queryCase_ == 14) {
        query_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 15;
  private volatile java.lang.Object languageCode_;
  /**
   *
   *
   * <pre>
   * The language code specified in the [original
   * request][QueryInput.language_code].
   * </pre>
   *
   * <code>string language_code = 15;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The language code specified in the [original
   * request][QueryInput.language_code].
   * </pre>
   *
   * <code>string language_code = 15;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FULFILLMENT_INFO_FIELD_NUMBER = 6;
  private com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo fulfillmentInfo_;
  /**
   *
   *
   * <pre>
   * Always present. Information about the fulfillment that triggered this
   * webhook call.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo fulfillment_info = 6;
   * </code>
   *
   * @return Whether the fulfillmentInfo field is set.
   */
  @java.lang.Override
  public boolean hasFulfillmentInfo() {
    return fulfillmentInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Always present. Information about the fulfillment that triggered this
   * webhook call.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo fulfillment_info = 6;
   * </code>
   *
   * @return The fulfillmentInfo.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo getFulfillmentInfo() {
    return fulfillmentInfo_ == null
        ? com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo.getDefaultInstance()
        : fulfillmentInfo_;
  }
  /**
   *
   *
   * <pre>
   * Always present. Information about the fulfillment that triggered this
   * webhook call.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo fulfillment_info = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfoOrBuilder
      getFulfillmentInfoOrBuilder() {
    return getFulfillmentInfo();
  }

  public static final int INTENT_INFO_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo intentInfo_;
  /**
   *
   *
   * <pre>
   * Information about the last matched intent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo intent_info = 3;</code>
   *
   * @return Whether the intentInfo field is set.
   */
  @java.lang.Override
  public boolean hasIntentInfo() {
    return intentInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Information about the last matched intent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo intent_info = 3;</code>
   *
   * @return The intentInfo.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo getIntentInfo() {
    return intentInfo_ == null
        ? com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.getDefaultInstance()
        : intentInfo_;
  }
  /**
   *
   *
   * <pre>
   * Information about the last matched intent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo intent_info = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfoOrBuilder
      getIntentInfoOrBuilder() {
    return getIntentInfo();
  }

  public static final int PAGE_INFO_FIELD_NUMBER = 4;
  private com.google.cloud.dialogflow.cx.v3.PageInfo pageInfo_;
  /**
   *
   *
   * <pre>
   * Information about page status.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.PageInfo page_info = 4;</code>
   *
   * @return Whether the pageInfo field is set.
   */
  @java.lang.Override
  public boolean hasPageInfo() {
    return pageInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Information about page status.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.PageInfo page_info = 4;</code>
   *
   * @return The pageInfo.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.PageInfo getPageInfo() {
    return pageInfo_ == null
        ? com.google.cloud.dialogflow.cx.v3.PageInfo.getDefaultInstance()
        : pageInfo_;
  }
  /**
   *
   *
   * <pre>
   * Information about page status.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.PageInfo page_info = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.PageInfoOrBuilder getPageInfoOrBuilder() {
    return getPageInfo();
  }

  public static final int SESSION_INFO_FIELD_NUMBER = 5;
  private com.google.cloud.dialogflow.cx.v3.SessionInfo sessionInfo_;
  /**
   *
   *
   * <pre>
   * Information about session status.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SessionInfo session_info = 5;</code>
   *
   * @return Whether the sessionInfo field is set.
   */
  @java.lang.Override
  public boolean hasSessionInfo() {
    return sessionInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Information about session status.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SessionInfo session_info = 5;</code>
   *
   * @return The sessionInfo.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SessionInfo getSessionInfo() {
    return sessionInfo_ == null
        ? com.google.cloud.dialogflow.cx.v3.SessionInfo.getDefaultInstance()
        : sessionInfo_;
  }
  /**
   *
   *
   * <pre>
   * Information about session status.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SessionInfo session_info = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SessionInfoOrBuilder getSessionInfoOrBuilder() {
    return getSessionInfo();
  }

  public static final int MESSAGES_FIELD_NUMBER = 7;
  private java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage> messages_;
  /**
   *
   *
   * <pre>
   * The list of rich message responses to present to the user. Webhook can
   * choose to append or replace this list in
   * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage> getMessagesList() {
    return messages_;
  }
  /**
   *
   *
   * <pre>
   * The list of rich message responses to present to the user. Webhook can
   * choose to append or replace this list in
   * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>
      getMessagesOrBuilderList() {
    return messages_;
  }
  /**
   *
   *
   * <pre>
   * The list of rich message responses to present to the user. Webhook can
   * choose to append or replace this list in
   * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
   */
  @java.lang.Override
  public int getMessagesCount() {
    return messages_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of rich message responses to present to the user. Webhook can
   * choose to append or replace this list in
   * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ResponseMessage getMessages(int index) {
    return messages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of rich message responses to present to the user. Webhook can
   * choose to append or replace this list in
   * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder getMessagesOrBuilder(
      int index) {
    return messages_.get(index);
  }

  public static final int PAYLOAD_FIELD_NUMBER = 8;
  private com.google.protobuf.Struct payload_;
  /**
   *
   *
   * <pre>
   * Custom data set in [QueryParameters.payload][google.cloud.dialogflow.cx.v3.QueryParameters.payload].
   * </pre>
   *
   * <code>.google.protobuf.Struct payload = 8;</code>
   *
   * @return Whether the payload field is set.
   */
  @java.lang.Override
  public boolean hasPayload() {
    return payload_ != null;
  }
  /**
   *
   *
   * <pre>
   * Custom data set in [QueryParameters.payload][google.cloud.dialogflow.cx.v3.QueryParameters.payload].
   * </pre>
   *
   * <code>.google.protobuf.Struct payload = 8;</code>
   *
   * @return The payload.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getPayload() {
    return payload_ == null ? com.google.protobuf.Struct.getDefaultInstance() : payload_;
  }
  /**
   *
   *
   * <pre>
   * Custom data set in [QueryParameters.payload][google.cloud.dialogflow.cx.v3.QueryParameters.payload].
   * </pre>
   *
   * <code>.google.protobuf.Struct payload = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getPayloadOrBuilder() {
    return getPayload();
  }

  public static final int SENTIMENT_ANALYSIS_RESULT_FIELD_NUMBER = 9;
  private com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
      sentimentAnalysisResult_;
  /**
   *
   *
   * <pre>
   * The sentiment analysis result of the current user request. The field is
   * filled when sentiment analysis is configured to be enabled for the request.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult sentiment_analysis_result = 9;
   * </code>
   *
   * @return Whether the sentimentAnalysisResult field is set.
   */
  @java.lang.Override
  public boolean hasSentimentAnalysisResult() {
    return sentimentAnalysisResult_ != null;
  }
  /**
   *
   *
   * <pre>
   * The sentiment analysis result of the current user request. The field is
   * filled when sentiment analysis is configured to be enabled for the request.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult sentiment_analysis_result = 9;
   * </code>
   *
   * @return The sentimentAnalysisResult.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
      getSentimentAnalysisResult() {
    return sentimentAnalysisResult_ == null
        ? com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
            .getDefaultInstance()
        : sentimentAnalysisResult_;
  }
  /**
   *
   *
   * <pre>
   * The sentiment analysis result of the current user request. The field is
   * filled when sentiment analysis is configured to be enabled for the request.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult sentiment_analysis_result = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResultOrBuilder
      getSentimentAnalysisResultOrBuilder() {
    return getSentimentAnalysisResult();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detectIntentResponseId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, detectIntentResponseId_);
    }
    if (intentInfo_ != null) {
      output.writeMessage(3, getIntentInfo());
    }
    if (pageInfo_ != null) {
      output.writeMessage(4, getPageInfo());
    }
    if (sessionInfo_ != null) {
      output.writeMessage(5, getSessionInfo());
    }
    if (fulfillmentInfo_ != null) {
      output.writeMessage(6, getFulfillmentInfo());
    }
    for (int i = 0; i < messages_.size(); i++) {
      output.writeMessage(7, messages_.get(i));
    }
    if (payload_ != null) {
      output.writeMessage(8, getPayload());
    }
    if (sentimentAnalysisResult_ != null) {
      output.writeMessage(9, getSentimentAnalysisResult());
    }
    if (queryCase_ == 10) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, query_);
    }
    if (queryCase_ == 11) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, query_);
    }
    if (queryCase_ == 12) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, query_);
    }
    if (queryCase_ == 14) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, query_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, languageCode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detectIntentResponseId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, detectIntentResponseId_);
    }
    if (intentInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getIntentInfo());
    }
    if (pageInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPageInfo());
    }
    if (sessionInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getSessionInfo());
    }
    if (fulfillmentInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getFulfillmentInfo());
    }
    for (int i = 0; i < messages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, messages_.get(i));
    }
    if (payload_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getPayload());
    }
    if (sentimentAnalysisResult_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(9, getSentimentAnalysisResult());
    }
    if (queryCase_ == 10) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, query_);
    }
    if (queryCase_ == 11) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, query_);
    }
    if (queryCase_ == 12) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, query_);
    }
    if (queryCase_ == 14) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, query_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, languageCode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.WebhookRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.WebhookRequest other =
        (com.google.cloud.dialogflow.cx.v3.WebhookRequest) obj;

    if (!getDetectIntentResponseId().equals(other.getDetectIntentResponseId())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (hasFulfillmentInfo() != other.hasFulfillmentInfo()) return false;
    if (hasFulfillmentInfo()) {
      if (!getFulfillmentInfo().equals(other.getFulfillmentInfo())) return false;
    }
    if (hasIntentInfo() != other.hasIntentInfo()) return false;
    if (hasIntentInfo()) {
      if (!getIntentInfo().equals(other.getIntentInfo())) return false;
    }
    if (hasPageInfo() != other.hasPageInfo()) return false;
    if (hasPageInfo()) {
      if (!getPageInfo().equals(other.getPageInfo())) return false;
    }
    if (hasSessionInfo() != other.hasSessionInfo()) return false;
    if (hasSessionInfo()) {
      if (!getSessionInfo().equals(other.getSessionInfo())) return false;
    }
    if (!getMessagesList().equals(other.getMessagesList())) return false;
    if (hasPayload() != other.hasPayload()) return false;
    if (hasPayload()) {
      if (!getPayload().equals(other.getPayload())) return false;
    }
    if (hasSentimentAnalysisResult() != other.hasSentimentAnalysisResult()) return false;
    if (hasSentimentAnalysisResult()) {
      if (!getSentimentAnalysisResult().equals(other.getSentimentAnalysisResult())) return false;
    }
    if (!getQueryCase().equals(other.getQueryCase())) return false;
    switch (queryCase_) {
      case 10:
        if (!getText().equals(other.getText())) return false;
        break;
      case 11:
        if (!getTriggerIntent().equals(other.getTriggerIntent())) return false;
        break;
      case 12:
        if (!getTranscript().equals(other.getTranscript())) return false;
        break;
      case 14:
        if (!getTriggerEvent().equals(other.getTriggerEvent())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DETECT_INTENT_RESPONSE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDetectIntentResponseId().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    if (hasFulfillmentInfo()) {
      hash = (37 * hash) + FULFILLMENT_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getFulfillmentInfo().hashCode();
    }
    if (hasIntentInfo()) {
      hash = (37 * hash) + INTENT_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getIntentInfo().hashCode();
    }
    if (hasPageInfo()) {
      hash = (37 * hash) + PAGE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getPageInfo().hashCode();
    }
    if (hasSessionInfo()) {
      hash = (37 * hash) + SESSION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getSessionInfo().hashCode();
    }
    if (getMessagesCount() > 0) {
      hash = (37 * hash) + MESSAGES_FIELD_NUMBER;
      hash = (53 * hash) + getMessagesList().hashCode();
    }
    if (hasPayload()) {
      hash = (37 * hash) + PAYLOAD_FIELD_NUMBER;
      hash = (53 * hash) + getPayload().hashCode();
    }
    if (hasSentimentAnalysisResult()) {
      hash = (37 * hash) + SENTIMENT_ANALYSIS_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getSentimentAnalysisResult().hashCode();
    }
    switch (queryCase_) {
      case 10:
        hash = (37 * hash) + TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getText().hashCode();
        break;
      case 11:
        hash = (37 * hash) + TRIGGER_INTENT_FIELD_NUMBER;
        hash = (53 * hash) + getTriggerIntent().hashCode();
        break;
      case 12:
        hash = (37 * hash) + TRANSCRIPT_FIELD_NUMBER;
        hash = (53 * hash) + getTranscript().hashCode();
        break;
      case 14:
        hash = (37 * hash) + TRIGGER_EVENT_FIELD_NUMBER;
        hash = (53 * hash) + getTriggerEvent().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.WebhookRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.WebhookRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.WebhookRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.WebhookRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.WebhookRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.WebhookRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.WebhookRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.WebhookRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.WebhookRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.WebhookRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.WebhookRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.WebhookRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.WebhookRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for a webhook call. The request is sent as a JSON object
   * and the field names will be presented in camel cases.
   * You may see undocumented fields in an actual request. These fields are used
   * internally by Dialogflow and should be ignored.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.WebhookRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.WebhookRequest)
      com.google.cloud.dialogflow.cx.v3.WebhookRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.class,
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.WebhookRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      detectIntentResponseId_ = "";

      languageCode_ = "";

      if (fulfillmentInfoBuilder_ == null) {
        fulfillmentInfo_ = null;
      } else {
        fulfillmentInfo_ = null;
        fulfillmentInfoBuilder_ = null;
      }
      if (intentInfoBuilder_ == null) {
        intentInfo_ = null;
      } else {
        intentInfo_ = null;
        intentInfoBuilder_ = null;
      }
      if (pageInfoBuilder_ == null) {
        pageInfo_ = null;
      } else {
        pageInfo_ = null;
        pageInfoBuilder_ = null;
      }
      if (sessionInfoBuilder_ == null) {
        sessionInfo_ = null;
      } else {
        sessionInfo_ = null;
        sessionInfoBuilder_ = null;
      }
      if (messagesBuilder_ == null) {
        messages_ = java.util.Collections.emptyList();
      } else {
        messages_ = null;
        messagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (payloadBuilder_ == null) {
        payload_ = null;
      } else {
        payload_ = null;
        payloadBuilder_ = null;
      }
      if (sentimentAnalysisResultBuilder_ == null) {
        sentimentAnalysisResult_ = null;
      } else {
        sentimentAnalysisResult_ = null;
        sentimentAnalysisResultBuilder_ = null;
      }
      queryCase_ = 0;
      query_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_WebhookRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.WebhookRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest build() {
      com.google.cloud.dialogflow.cx.v3.WebhookRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest buildPartial() {
      com.google.cloud.dialogflow.cx.v3.WebhookRequest result =
          new com.google.cloud.dialogflow.cx.v3.WebhookRequest(this);
      int from_bitField0_ = bitField0_;
      result.detectIntentResponseId_ = detectIntentResponseId_;
      if (queryCase_ == 10) {
        result.query_ = query_;
      }
      if (queryCase_ == 11) {
        result.query_ = query_;
      }
      if (queryCase_ == 12) {
        result.query_ = query_;
      }
      if (queryCase_ == 14) {
        result.query_ = query_;
      }
      result.languageCode_ = languageCode_;
      if (fulfillmentInfoBuilder_ == null) {
        result.fulfillmentInfo_ = fulfillmentInfo_;
      } else {
        result.fulfillmentInfo_ = fulfillmentInfoBuilder_.build();
      }
      if (intentInfoBuilder_ == null) {
        result.intentInfo_ = intentInfo_;
      } else {
        result.intentInfo_ = intentInfoBuilder_.build();
      }
      if (pageInfoBuilder_ == null) {
        result.pageInfo_ = pageInfo_;
      } else {
        result.pageInfo_ = pageInfoBuilder_.build();
      }
      if (sessionInfoBuilder_ == null) {
        result.sessionInfo_ = sessionInfo_;
      } else {
        result.sessionInfo_ = sessionInfoBuilder_.build();
      }
      if (messagesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          messages_ = java.util.Collections.unmodifiableList(messages_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.messages_ = messages_;
      } else {
        result.messages_ = messagesBuilder_.build();
      }
      if (payloadBuilder_ == null) {
        result.payload_ = payload_;
      } else {
        result.payload_ = payloadBuilder_.build();
      }
      if (sentimentAnalysisResultBuilder_ == null) {
        result.sentimentAnalysisResult_ = sentimentAnalysisResult_;
      } else {
        result.sentimentAnalysisResult_ = sentimentAnalysisResultBuilder_.build();
      }
      result.queryCase_ = queryCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.WebhookRequest) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.WebhookRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.WebhookRequest other) {
      if (other == com.google.cloud.dialogflow.cx.v3.WebhookRequest.getDefaultInstance())
        return this;
      if (!other.getDetectIntentResponseId().isEmpty()) {
        detectIntentResponseId_ = other.detectIntentResponseId_;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        onChanged();
      }
      if (other.hasFulfillmentInfo()) {
        mergeFulfillmentInfo(other.getFulfillmentInfo());
      }
      if (other.hasIntentInfo()) {
        mergeIntentInfo(other.getIntentInfo());
      }
      if (other.hasPageInfo()) {
        mergePageInfo(other.getPageInfo());
      }
      if (other.hasSessionInfo()) {
        mergeSessionInfo(other.getSessionInfo());
      }
      if (messagesBuilder_ == null) {
        if (!other.messages_.isEmpty()) {
          if (messages_.isEmpty()) {
            messages_ = other.messages_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureMessagesIsMutable();
            messages_.addAll(other.messages_);
          }
          onChanged();
        }
      } else {
        if (!other.messages_.isEmpty()) {
          if (messagesBuilder_.isEmpty()) {
            messagesBuilder_.dispose();
            messagesBuilder_ = null;
            messages_ = other.messages_;
            bitField0_ = (bitField0_ & ~0x00000001);
            messagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMessagesFieldBuilder()
                    : null;
          } else {
            messagesBuilder_.addAllMessages(other.messages_);
          }
        }
      }
      if (other.hasPayload()) {
        mergePayload(other.getPayload());
      }
      if (other.hasSentimentAnalysisResult()) {
        mergeSentimentAnalysisResult(other.getSentimentAnalysisResult());
      }
      switch (other.getQueryCase()) {
        case TEXT:
          {
            queryCase_ = 10;
            query_ = other.query_;
            onChanged();
            break;
          }
        case TRIGGER_INTENT:
          {
            queryCase_ = 11;
            query_ = other.query_;
            onChanged();
            break;
          }
        case TRANSCRIPT:
          {
            queryCase_ = 12;
            query_ = other.query_;
            onChanged();
            break;
          }
        case TRIGGER_EVENT:
          {
            queryCase_ = 14;
            query_ = other.query_;
            onChanged();
            break;
          }
        case QUERY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                detectIntentResponseId_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 26:
              {
                input.readMessage(getIntentInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getPageInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getSessionInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                input.readMessage(getFulfillmentInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 58:
              {
                com.google.cloud.dialogflow.cx.v3.ResponseMessage m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.ResponseMessage.parser(),
                        extensionRegistry);
                if (messagesBuilder_ == null) {
                  ensureMessagesIsMutable();
                  messages_.add(m);
                } else {
                  messagesBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getPayloadFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getSentimentAnalysisResultFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 74
            case 82:
              {
                java.lang.String s = input.readStringRequireUtf8();
                queryCase_ = 10;
                query_ = s;
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                queryCase_ = 11;
                query_ = s;
                break;
              } // case 90
            case 98:
              {
                java.lang.String s = input.readStringRequireUtf8();
                queryCase_ = 12;
                query_ = s;
                break;
              } // case 98
            case 114:
              {
                java.lang.String s = input.readStringRequireUtf8();
                queryCase_ = 14;
                query_ = s;
                break;
              } // case 114
            case 122:
              {
                languageCode_ = input.readStringRequireUtf8();

                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int queryCase_ = 0;
    private java.lang.Object query_;

    public QueryCase getQueryCase() {
      return QueryCase.forNumber(queryCase_);
    }

    public Builder clearQuery() {
      queryCase_ = 0;
      query_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object detectIntentResponseId_ = "";
    /**
     *
     *
     * <pre>
     * Always present. The unique identifier of the [DetectIntentResponse][google.cloud.dialogflow.cx.v3.DetectIntentResponse] that
     * will be returned to the API caller.
     * </pre>
     *
     * <code>string detect_intent_response_id = 1;</code>
     *
     * @return The detectIntentResponseId.
     */
    public java.lang.String getDetectIntentResponseId() {
      java.lang.Object ref = detectIntentResponseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        detectIntentResponseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Always present. The unique identifier of the [DetectIntentResponse][google.cloud.dialogflow.cx.v3.DetectIntentResponse] that
     * will be returned to the API caller.
     * </pre>
     *
     * <code>string detect_intent_response_id = 1;</code>
     *
     * @return The bytes for detectIntentResponseId.
     */
    public com.google.protobuf.ByteString getDetectIntentResponseIdBytes() {
      java.lang.Object ref = detectIntentResponseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        detectIntentResponseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Always present. The unique identifier of the [DetectIntentResponse][google.cloud.dialogflow.cx.v3.DetectIntentResponse] that
     * will be returned to the API caller.
     * </pre>
     *
     * <code>string detect_intent_response_id = 1;</code>
     *
     * @param value The detectIntentResponseId to set.
     * @return This builder for chaining.
     */
    public Builder setDetectIntentResponseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      detectIntentResponseId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Always present. The unique identifier of the [DetectIntentResponse][google.cloud.dialogflow.cx.v3.DetectIntentResponse] that
     * will be returned to the API caller.
     * </pre>
     *
     * <code>string detect_intent_response_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDetectIntentResponseId() {

      detectIntentResponseId_ = getDefaultInstance().getDetectIntentResponseId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Always present. The unique identifier of the [DetectIntentResponse][google.cloud.dialogflow.cx.v3.DetectIntentResponse] that
     * will be returned to the API caller.
     * </pre>
     *
     * <code>string detect_intent_response_id = 1;</code>
     *
     * @param value The bytes for detectIntentResponseId to set.
     * @return This builder for chaining.
     */
    public Builder setDetectIntentResponseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      detectIntentResponseId_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was provided as input, this field
     * will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 10;</code>
     *
     * @return Whether the text field is set.
     */
    @java.lang.Override
    public boolean hasText() {
      return queryCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was provided as input, this field
     * will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 10;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = "";
      if (queryCase_ == 10) {
        ref = query_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (queryCase_ == 10) {
          query_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was provided as input, this field
     * will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 10;</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = "";
      if (queryCase_ == 10) {
        ref = query_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (queryCase_ == 10) {
          query_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was provided as input, this field
     * will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 10;</code>
     *
     * @param value The text to set.
     * @return This builder for chaining.
     */
    public Builder setText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryCase_ = 10;
      query_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was provided as input, this field
     * will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearText() {
      if (queryCase_ == 10) {
        queryCase_ = 0;
        query_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was provided as input, this field
     * will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 10;</code>
     *
     * @param value The bytes for text to set.
     * @return This builder for chaining.
     */
    public Builder setTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryCase_ = 10;
      query_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as input, this field will
     * contain a copy of the intent identifier.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the triggerIntent field is set.
     */
    @java.lang.Override
    public boolean hasTriggerIntent() {
      return queryCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as input, this field will
     * contain a copy of the intent identifier.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The triggerIntent.
     */
    @java.lang.Override
    public java.lang.String getTriggerIntent() {
      java.lang.Object ref = "";
      if (queryCase_ == 11) {
        ref = query_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (queryCase_ == 11) {
          query_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as input, this field will
     * contain a copy of the intent identifier.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for triggerIntent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTriggerIntentBytes() {
      java.lang.Object ref = "";
      if (queryCase_ == 11) {
        ref = query_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (queryCase_ == 11) {
          query_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as input, this field will
     * contain a copy of the intent identifier.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The triggerIntent to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerIntent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryCase_ = 11;
      query_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as input, this field will
     * contain a copy of the intent identifier.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTriggerIntent() {
      if (queryCase_ == 11) {
        queryCase_ = 0;
        query_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as input, this field will
     * contain a copy of the intent identifier.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for triggerIntent to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerIntentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryCase_ = 11;
      query_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If [natural language speech audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
     * this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 12;</code>
     *
     * @return Whether the transcript field is set.
     */
    @java.lang.Override
    public boolean hasTranscript() {
      return queryCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * If [natural language speech audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
     * this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 12;</code>
     *
     * @return The transcript.
     */
    @java.lang.Override
    public java.lang.String getTranscript() {
      java.lang.Object ref = "";
      if (queryCase_ == 12) {
        ref = query_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (queryCase_ == 12) {
          query_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If [natural language speech audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
     * this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 12;</code>
     *
     * @return The bytes for transcript.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTranscriptBytes() {
      java.lang.Object ref = "";
      if (queryCase_ == 12) {
        ref = query_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (queryCase_ == 12) {
          query_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If [natural language speech audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
     * this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 12;</code>
     *
     * @param value The transcript to set.
     * @return This builder for chaining.
     */
    public Builder setTranscript(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryCase_ = 12;
      query_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [natural language speech audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
     * this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTranscript() {
      if (queryCase_ == 12) {
        queryCase_ = 0;
        query_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [natural language speech audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
     * this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 12;</code>
     *
     * @param value The bytes for transcript to set.
     * @return This builder for chaining.
     */
    public Builder setTranscriptBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryCase_ = 12;
      query_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as input, this field will contain
     * the name of the event.
     * </pre>
     *
     * <code>string trigger_event = 14;</code>
     *
     * @return Whether the triggerEvent field is set.
     */
    @java.lang.Override
    public boolean hasTriggerEvent() {
      return queryCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as input, this field will contain
     * the name of the event.
     * </pre>
     *
     * <code>string trigger_event = 14;</code>
     *
     * @return The triggerEvent.
     */
    @java.lang.Override
    public java.lang.String getTriggerEvent() {
      java.lang.Object ref = "";
      if (queryCase_ == 14) {
        ref = query_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (queryCase_ == 14) {
          query_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as input, this field will contain
     * the name of the event.
     * </pre>
     *
     * <code>string trigger_event = 14;</code>
     *
     * @return The bytes for triggerEvent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTriggerEventBytes() {
      java.lang.Object ref = "";
      if (queryCase_ == 14) {
        ref = query_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (queryCase_ == 14) {
          query_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as input, this field will contain
     * the name of the event.
     * </pre>
     *
     * <code>string trigger_event = 14;</code>
     *
     * @param value The triggerEvent to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerEvent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryCase_ = 14;
      query_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as input, this field will contain
     * the name of the event.
     * </pre>
     *
     * <code>string trigger_event = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTriggerEvent() {
      if (queryCase_ == 14) {
        queryCase_ = 0;
        query_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as input, this field will contain
     * the name of the event.
     * </pre>
     *
     * <code>string trigger_event = 14;</code>
     *
     * @param value The bytes for triggerEvent to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerEventBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryCase_ = 14;
      query_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * The language code specified in the [original
     * request][QueryInput.language_code].
     * </pre>
     *
     * <code>string language_code = 15;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language code specified in the [original
     * request][QueryInput.language_code].
     * </pre>
     *
     * <code>string language_code = 15;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language code specified in the [original
     * request][QueryInput.language_code].
     * </pre>
     *
     * <code>string language_code = 15;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      languageCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language code specified in the [original
     * request][QueryInput.language_code].
     * </pre>
     *
     * <code>string language_code = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {

      languageCode_ = getDefaultInstance().getLanguageCode();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language code specified in the [original
     * request][QueryInput.language_code].
     * </pre>
     *
     * <code>string language_code = 15;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      languageCode_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo fulfillmentInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo.Builder,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfoOrBuilder>
        fulfillmentInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Always present. Information about the fulfillment that triggered this
     * webhook call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo fulfillment_info = 6;
     * </code>
     *
     * @return Whether the fulfillmentInfo field is set.
     */
    public boolean hasFulfillmentInfo() {
      return fulfillmentInfoBuilder_ != null || fulfillmentInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Always present. Information about the fulfillment that triggered this
     * webhook call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo fulfillment_info = 6;
     * </code>
     *
     * @return The fulfillmentInfo.
     */
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo getFulfillmentInfo() {
      if (fulfillmentInfoBuilder_ == null) {
        return fulfillmentInfo_ == null
            ? com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo.getDefaultInstance()
            : fulfillmentInfo_;
      } else {
        return fulfillmentInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Always present. Information about the fulfillment that triggered this
     * webhook call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo fulfillment_info = 6;
     * </code>
     */
    public Builder setFulfillmentInfo(
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo value) {
      if (fulfillmentInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fulfillmentInfo_ = value;
        onChanged();
      } else {
        fulfillmentInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Always present. Information about the fulfillment that triggered this
     * webhook call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo fulfillment_info = 6;
     * </code>
     */
    public Builder setFulfillmentInfo(
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo.Builder builderForValue) {
      if (fulfillmentInfoBuilder_ == null) {
        fulfillmentInfo_ = builderForValue.build();
        onChanged();
      } else {
        fulfillmentInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Always present. Information about the fulfillment that triggered this
     * webhook call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo fulfillment_info = 6;
     * </code>
     */
    public Builder mergeFulfillmentInfo(
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo value) {
      if (fulfillmentInfoBuilder_ == null) {
        if (fulfillmentInfo_ != null) {
          fulfillmentInfo_ =
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo.newBuilder(
                      fulfillmentInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          fulfillmentInfo_ = value;
        }
        onChanged();
      } else {
        fulfillmentInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Always present. Information about the fulfillment that triggered this
     * webhook call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo fulfillment_info = 6;
     * </code>
     */
    public Builder clearFulfillmentInfo() {
      if (fulfillmentInfoBuilder_ == null) {
        fulfillmentInfo_ = null;
        onChanged();
      } else {
        fulfillmentInfo_ = null;
        fulfillmentInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Always present. Information about the fulfillment that triggered this
     * webhook call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo fulfillment_info = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo.Builder
        getFulfillmentInfoBuilder() {

      onChanged();
      return getFulfillmentInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Always present. Information about the fulfillment that triggered this
     * webhook call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo fulfillment_info = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfoOrBuilder
        getFulfillmentInfoOrBuilder() {
      if (fulfillmentInfoBuilder_ != null) {
        return fulfillmentInfoBuilder_.getMessageOrBuilder();
      } else {
        return fulfillmentInfo_ == null
            ? com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo.getDefaultInstance()
            : fulfillmentInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Always present. Information about the fulfillment that triggered this
     * webhook call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo fulfillment_info = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo.Builder,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfoOrBuilder>
        getFulfillmentInfoFieldBuilder() {
      if (fulfillmentInfoBuilder_ == null) {
        fulfillmentInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo,
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo.Builder,
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfoOrBuilder>(
                getFulfillmentInfo(), getParentForChildren(), isClean());
        fulfillmentInfo_ = null;
      }
      return fulfillmentInfoBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo intentInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.Builder,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfoOrBuilder>
        intentInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Information about the last matched intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo intent_info = 3;</code>
     *
     * @return Whether the intentInfo field is set.
     */
    public boolean hasIntentInfo() {
      return intentInfoBuilder_ != null || intentInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Information about the last matched intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo intent_info = 3;</code>
     *
     * @return The intentInfo.
     */
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo getIntentInfo() {
      if (intentInfoBuilder_ == null) {
        return intentInfo_ == null
            ? com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.getDefaultInstance()
            : intentInfo_;
      } else {
        return intentInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the last matched intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo intent_info = 3;</code>
     */
    public Builder setIntentInfo(
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo value) {
      if (intentInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        intentInfo_ = value;
        onChanged();
      } else {
        intentInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the last matched intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo intent_info = 3;</code>
     */
    public Builder setIntentInfo(
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.Builder builderForValue) {
      if (intentInfoBuilder_ == null) {
        intentInfo_ = builderForValue.build();
        onChanged();
      } else {
        intentInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the last matched intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo intent_info = 3;</code>
     */
    public Builder mergeIntentInfo(
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo value) {
      if (intentInfoBuilder_ == null) {
        if (intentInfo_ != null) {
          intentInfo_ =
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.newBuilder(intentInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          intentInfo_ = value;
        }
        onChanged();
      } else {
        intentInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the last matched intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo intent_info = 3;</code>
     */
    public Builder clearIntentInfo() {
      if (intentInfoBuilder_ == null) {
        intentInfo_ = null;
        onChanged();
      } else {
        intentInfo_ = null;
        intentInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the last matched intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo intent_info = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.Builder
        getIntentInfoBuilder() {

      onChanged();
      return getIntentInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information about the last matched intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo intent_info = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfoOrBuilder
        getIntentInfoOrBuilder() {
      if (intentInfoBuilder_ != null) {
        return intentInfoBuilder_.getMessageOrBuilder();
      } else {
        return intentInfo_ == null
            ? com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.getDefaultInstance()
            : intentInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the last matched intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo intent_info = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.Builder,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfoOrBuilder>
        getIntentInfoFieldBuilder() {
      if (intentInfoBuilder_ == null) {
        intentInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo,
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.Builder,
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfoOrBuilder>(
                getIntentInfo(), getParentForChildren(), isClean());
        intentInfo_ = null;
      }
      return intentInfoBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.PageInfo pageInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.PageInfo,
            com.google.cloud.dialogflow.cx.v3.PageInfo.Builder,
            com.google.cloud.dialogflow.cx.v3.PageInfoOrBuilder>
        pageInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Information about page status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo page_info = 4;</code>
     *
     * @return Whether the pageInfo field is set.
     */
    public boolean hasPageInfo() {
      return pageInfoBuilder_ != null || pageInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Information about page status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo page_info = 4;</code>
     *
     * @return The pageInfo.
     */
    public com.google.cloud.dialogflow.cx.v3.PageInfo getPageInfo() {
      if (pageInfoBuilder_ == null) {
        return pageInfo_ == null
            ? com.google.cloud.dialogflow.cx.v3.PageInfo.getDefaultInstance()
            : pageInfo_;
      } else {
        return pageInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about page status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo page_info = 4;</code>
     */
    public Builder setPageInfo(com.google.cloud.dialogflow.cx.v3.PageInfo value) {
      if (pageInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pageInfo_ = value;
        onChanged();
      } else {
        pageInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about page status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo page_info = 4;</code>
     */
    public Builder setPageInfo(com.google.cloud.dialogflow.cx.v3.PageInfo.Builder builderForValue) {
      if (pageInfoBuilder_ == null) {
        pageInfo_ = builderForValue.build();
        onChanged();
      } else {
        pageInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about page status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo page_info = 4;</code>
     */
    public Builder mergePageInfo(com.google.cloud.dialogflow.cx.v3.PageInfo value) {
      if (pageInfoBuilder_ == null) {
        if (pageInfo_ != null) {
          pageInfo_ =
              com.google.cloud.dialogflow.cx.v3.PageInfo.newBuilder(pageInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pageInfo_ = value;
        }
        onChanged();
      } else {
        pageInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about page status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo page_info = 4;</code>
     */
    public Builder clearPageInfo() {
      if (pageInfoBuilder_ == null) {
        pageInfo_ = null;
        onChanged();
      } else {
        pageInfo_ = null;
        pageInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about page status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo page_info = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.PageInfo.Builder getPageInfoBuilder() {

      onChanged();
      return getPageInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information about page status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo page_info = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.PageInfoOrBuilder getPageInfoOrBuilder() {
      if (pageInfoBuilder_ != null) {
        return pageInfoBuilder_.getMessageOrBuilder();
      } else {
        return pageInfo_ == null
            ? com.google.cloud.dialogflow.cx.v3.PageInfo.getDefaultInstance()
            : pageInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information about page status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo page_info = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.PageInfo,
            com.google.cloud.dialogflow.cx.v3.PageInfo.Builder,
            com.google.cloud.dialogflow.cx.v3.PageInfoOrBuilder>
        getPageInfoFieldBuilder() {
      if (pageInfoBuilder_ == null) {
        pageInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.PageInfo,
                com.google.cloud.dialogflow.cx.v3.PageInfo.Builder,
                com.google.cloud.dialogflow.cx.v3.PageInfoOrBuilder>(
                getPageInfo(), getParentForChildren(), isClean());
        pageInfo_ = null;
      }
      return pageInfoBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.SessionInfo sessionInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.SessionInfo,
            com.google.cloud.dialogflow.cx.v3.SessionInfo.Builder,
            com.google.cloud.dialogflow.cx.v3.SessionInfoOrBuilder>
        sessionInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Information about session status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SessionInfo session_info = 5;</code>
     *
     * @return Whether the sessionInfo field is set.
     */
    public boolean hasSessionInfo() {
      return sessionInfoBuilder_ != null || sessionInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Information about session status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SessionInfo session_info = 5;</code>
     *
     * @return The sessionInfo.
     */
    public com.google.cloud.dialogflow.cx.v3.SessionInfo getSessionInfo() {
      if (sessionInfoBuilder_ == null) {
        return sessionInfo_ == null
            ? com.google.cloud.dialogflow.cx.v3.SessionInfo.getDefaultInstance()
            : sessionInfo_;
      } else {
        return sessionInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about session status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SessionInfo session_info = 5;</code>
     */
    public Builder setSessionInfo(com.google.cloud.dialogflow.cx.v3.SessionInfo value) {
      if (sessionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sessionInfo_ = value;
        onChanged();
      } else {
        sessionInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about session status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SessionInfo session_info = 5;</code>
     */
    public Builder setSessionInfo(
        com.google.cloud.dialogflow.cx.v3.SessionInfo.Builder builderForValue) {
      if (sessionInfoBuilder_ == null) {
        sessionInfo_ = builderForValue.build();
        onChanged();
      } else {
        sessionInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about session status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SessionInfo session_info = 5;</code>
     */
    public Builder mergeSessionInfo(com.google.cloud.dialogflow.cx.v3.SessionInfo value) {
      if (sessionInfoBuilder_ == null) {
        if (sessionInfo_ != null) {
          sessionInfo_ =
              com.google.cloud.dialogflow.cx.v3.SessionInfo.newBuilder(sessionInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sessionInfo_ = value;
        }
        onChanged();
      } else {
        sessionInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about session status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SessionInfo session_info = 5;</code>
     */
    public Builder clearSessionInfo() {
      if (sessionInfoBuilder_ == null) {
        sessionInfo_ = null;
        onChanged();
      } else {
        sessionInfo_ = null;
        sessionInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about session status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SessionInfo session_info = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.SessionInfo.Builder getSessionInfoBuilder() {

      onChanged();
      return getSessionInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information about session status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SessionInfo session_info = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.SessionInfoOrBuilder getSessionInfoOrBuilder() {
      if (sessionInfoBuilder_ != null) {
        return sessionInfoBuilder_.getMessageOrBuilder();
      } else {
        return sessionInfo_ == null
            ? com.google.cloud.dialogflow.cx.v3.SessionInfo.getDefaultInstance()
            : sessionInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information about session status.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SessionInfo session_info = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.SessionInfo,
            com.google.cloud.dialogflow.cx.v3.SessionInfo.Builder,
            com.google.cloud.dialogflow.cx.v3.SessionInfoOrBuilder>
        getSessionInfoFieldBuilder() {
      if (sessionInfoBuilder_ == null) {
        sessionInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.SessionInfo,
                com.google.cloud.dialogflow.cx.v3.SessionInfo.Builder,
                com.google.cloud.dialogflow.cx.v3.SessionInfoOrBuilder>(
                getSessionInfo(), getParentForChildren(), isClean());
        sessionInfo_ = null;
      }
      return sessionInfoBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage> messages_ =
        java.util.Collections.emptyList();

    private void ensureMessagesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        messages_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.ResponseMessage>(messages_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.ResponseMessage,
            com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder,
            com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>
        messagesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage> getMessagesList() {
      if (messagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(messages_);
      } else {
        return messagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public int getMessagesCount() {
      if (messagesBuilder_ == null) {
        return messages_.size();
      } else {
        return messagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ResponseMessage getMessages(int index) {
      if (messagesBuilder_ == null) {
        return messages_.get(index);
      } else {
        return messagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public Builder setMessages(int index, com.google.cloud.dialogflow.cx.v3.ResponseMessage value) {
      if (messagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMessagesIsMutable();
        messages_.set(index, value);
        onChanged();
      } else {
        messagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public Builder setMessages(
        int index, com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder builderForValue) {
      if (messagesBuilder_ == null) {
        ensureMessagesIsMutable();
        messages_.set(index, builderForValue.build());
        onChanged();
      } else {
        messagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public Builder addMessages(com.google.cloud.dialogflow.cx.v3.ResponseMessage value) {
      if (messagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMessagesIsMutable();
        messages_.add(value);
        onChanged();
      } else {
        messagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public Builder addMessages(int index, com.google.cloud.dialogflow.cx.v3.ResponseMessage value) {
      if (messagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMessagesIsMutable();
        messages_.add(index, value);
        onChanged();
      } else {
        messagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public Builder addMessages(
        com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder builderForValue) {
      if (messagesBuilder_ == null) {
        ensureMessagesIsMutable();
        messages_.add(builderForValue.build());
        onChanged();
      } else {
        messagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public Builder addMessages(
        int index, com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder builderForValue) {
      if (messagesBuilder_ == null) {
        ensureMessagesIsMutable();
        messages_.add(index, builderForValue.build());
        onChanged();
      } else {
        messagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public Builder addAllMessages(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.ResponseMessage> values) {
      if (messagesBuilder_ == null) {
        ensureMessagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, messages_);
        onChanged();
      } else {
        messagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public Builder clearMessages() {
      if (messagesBuilder_ == null) {
        messages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        messagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public Builder removeMessages(int index) {
      if (messagesBuilder_ == null) {
        ensureMessagesIsMutable();
        messages_.remove(index);
        onChanged();
      } else {
        messagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder getMessagesBuilder(int index) {
      return getMessagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder getMessagesOrBuilder(
        int index) {
      if (messagesBuilder_ == null) {
        return messages_.get(index);
      } else {
        return messagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>
        getMessagesOrBuilderList() {
      if (messagesBuilder_ != null) {
        return messagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(messages_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder addMessagesBuilder() {
      return getMessagesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3.ResponseMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder addMessagesBuilder(int index) {
      return getMessagesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.cx.v3.ResponseMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user. Webhook can
     * choose to append or replace this list in
     * [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 7;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder>
        getMessagesBuilderList() {
      return getMessagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.ResponseMessage,
            com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder,
            com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>
        getMessagesFieldBuilder() {
      if (messagesBuilder_ == null) {
        messagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.ResponseMessage,
                com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder,
                com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>(
                messages_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        messages_ = null;
      }
      return messagesBuilder_;
    }

    private com.google.protobuf.Struct payload_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        payloadBuilder_;
    /**
     *
     *
     * <pre>
     * Custom data set in [QueryParameters.payload][google.cloud.dialogflow.cx.v3.QueryParameters.payload].
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 8;</code>
     *
     * @return Whether the payload field is set.
     */
    public boolean hasPayload() {
      return payloadBuilder_ != null || payload_ != null;
    }
    /**
     *
     *
     * <pre>
     * Custom data set in [QueryParameters.payload][google.cloud.dialogflow.cx.v3.QueryParameters.payload].
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 8;</code>
     *
     * @return The payload.
     */
    public com.google.protobuf.Struct getPayload() {
      if (payloadBuilder_ == null) {
        return payload_ == null ? com.google.protobuf.Struct.getDefaultInstance() : payload_;
      } else {
        return payloadBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Custom data set in [QueryParameters.payload][google.cloud.dialogflow.cx.v3.QueryParameters.payload].
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 8;</code>
     */
    public Builder setPayload(com.google.protobuf.Struct value) {
      if (payloadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        payloadBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom data set in [QueryParameters.payload][google.cloud.dialogflow.cx.v3.QueryParameters.payload].
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 8;</code>
     */
    public Builder setPayload(com.google.protobuf.Struct.Builder builderForValue) {
      if (payloadBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        payloadBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom data set in [QueryParameters.payload][google.cloud.dialogflow.cx.v3.QueryParameters.payload].
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 8;</code>
     */
    public Builder mergePayload(com.google.protobuf.Struct value) {
      if (payloadBuilder_ == null) {
        if (payload_ != null) {
          payload_ =
              com.google.protobuf.Struct.newBuilder(payload_).mergeFrom(value).buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        payloadBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom data set in [QueryParameters.payload][google.cloud.dialogflow.cx.v3.QueryParameters.payload].
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 8;</code>
     */
    public Builder clearPayload() {
      if (payloadBuilder_ == null) {
        payload_ = null;
        onChanged();
      } else {
        payload_ = null;
        payloadBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom data set in [QueryParameters.payload][google.cloud.dialogflow.cx.v3.QueryParameters.payload].
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 8;</code>
     */
    public com.google.protobuf.Struct.Builder getPayloadBuilder() {

      onChanged();
      return getPayloadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Custom data set in [QueryParameters.payload][google.cloud.dialogflow.cx.v3.QueryParameters.payload].
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 8;</code>
     */
    public com.google.protobuf.StructOrBuilder getPayloadOrBuilder() {
      if (payloadBuilder_ != null) {
        return payloadBuilder_.getMessageOrBuilder();
      } else {
        return payload_ == null ? com.google.protobuf.Struct.getDefaultInstance() : payload_;
      }
    }
    /**
     *
     *
     * <pre>
     * Custom data set in [QueryParameters.payload][google.cloud.dialogflow.cx.v3.QueryParameters.payload].
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getPayloadFieldBuilder() {
      if (payloadBuilder_ == null) {
        payloadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getPayload(), getParentForChildren(), isClean());
        payload_ = null;
      }
      return payloadBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        sentimentAnalysisResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult.Builder,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResultOrBuilder>
        sentimentAnalysisResultBuilder_;
    /**
     *
     *
     * <pre>
     * The sentiment analysis result of the current user request. The field is
     * filled when sentiment analysis is configured to be enabled for the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult sentiment_analysis_result = 9;
     * </code>
     *
     * @return Whether the sentimentAnalysisResult field is set.
     */
    public boolean hasSentimentAnalysisResult() {
      return sentimentAnalysisResultBuilder_ != null || sentimentAnalysisResult_ != null;
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result of the current user request. The field is
     * filled when sentiment analysis is configured to be enabled for the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult sentiment_analysis_result = 9;
     * </code>
     *
     * @return The sentimentAnalysisResult.
     */
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
        getSentimentAnalysisResult() {
      if (sentimentAnalysisResultBuilder_ == null) {
        return sentimentAnalysisResult_ == null
            ? com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
                .getDefaultInstance()
            : sentimentAnalysisResult_;
      } else {
        return sentimentAnalysisResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result of the current user request. The field is
     * filled when sentiment analysis is configured to be enabled for the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult sentiment_analysis_result = 9;
     * </code>
     */
    public Builder setSentimentAnalysisResult(
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult value) {
      if (sentimentAnalysisResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sentimentAnalysisResult_ = value;
        onChanged();
      } else {
        sentimentAnalysisResultBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result of the current user request. The field is
     * filled when sentiment analysis is configured to be enabled for the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult sentiment_analysis_result = 9;
     * </code>
     */
    public Builder setSentimentAnalysisResult(
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult.Builder
            builderForValue) {
      if (sentimentAnalysisResultBuilder_ == null) {
        sentimentAnalysisResult_ = builderForValue.build();
        onChanged();
      } else {
        sentimentAnalysisResultBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result of the current user request. The field is
     * filled when sentiment analysis is configured to be enabled for the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult sentiment_analysis_result = 9;
     * </code>
     */
    public Builder mergeSentimentAnalysisResult(
        com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult value) {
      if (sentimentAnalysisResultBuilder_ == null) {
        if (sentimentAnalysisResult_ != null) {
          sentimentAnalysisResult_ =
              com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult.newBuilder(
                      sentimentAnalysisResult_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sentimentAnalysisResult_ = value;
        }
        onChanged();
      } else {
        sentimentAnalysisResultBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result of the current user request. The field is
     * filled when sentiment analysis is configured to be enabled for the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult sentiment_analysis_result = 9;
     * </code>
     */
    public Builder clearSentimentAnalysisResult() {
      if (sentimentAnalysisResultBuilder_ == null) {
        sentimentAnalysisResult_ = null;
        onChanged();
      } else {
        sentimentAnalysisResult_ = null;
        sentimentAnalysisResultBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result of the current user request. The field is
     * filled when sentiment analysis is configured to be enabled for the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult sentiment_analysis_result = 9;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult.Builder
        getSentimentAnalysisResultBuilder() {

      onChanged();
      return getSentimentAnalysisResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result of the current user request. The field is
     * filled when sentiment analysis is configured to be enabled for the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult sentiment_analysis_result = 9;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResultOrBuilder
        getSentimentAnalysisResultOrBuilder() {
      if (sentimentAnalysisResultBuilder_ != null) {
        return sentimentAnalysisResultBuilder_.getMessageOrBuilder();
      } else {
        return sentimentAnalysisResult_ == null
            ? com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
                .getDefaultInstance()
            : sentimentAnalysisResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result of the current user request. The field is
     * filled when sentiment analysis is configured to be enabled for the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult sentiment_analysis_result = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult.Builder,
            com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResultOrBuilder>
        getSentimentAnalysisResultFieldBuilder() {
      if (sentimentAnalysisResultBuilder_ == null) {
        sentimentAnalysisResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult,
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult.Builder,
                com.google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResultOrBuilder>(
                getSentimentAnalysisResult(), getParentForChildren(), isClean());
        sentimentAnalysisResult_ = null;
      }
      return sentimentAnalysisResultBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.WebhookRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.WebhookRequest)
  private static final com.google.cloud.dialogflow.cx.v3.WebhookRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.WebhookRequest();
  }

  public static com.google.cloud.dialogflow.cx.v3.WebhookRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WebhookRequest> PARSER =
      new com.google.protobuf.AbstractParser<WebhookRequest>() {
        @java.lang.Override
        public WebhookRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WebhookRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WebhookRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.WebhookRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
