/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/webhook.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Webhooks host the developer's business logic. During a session, webhooks
 * allow the developer to use the data extracted by Dialogflow's natural
 * language processing to generate dynamic responses, validate collected data,
 * or trigger actions on the backend.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.Webhook}
 */
public final class Webhook extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Webhook)
    WebhookOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Webhook.newBuilder() to construct.
  private Webhook(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Webhook() {
    name_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Webhook();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.WebhookProto
        .internal_static_google_cloud_dialogflow_cx_v3_Webhook_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.WebhookProto
        .internal_static_google_cloud_dialogflow_cx_v3_Webhook_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.Webhook.class,
            com.google.cloud.dialogflow.cx.v3.Webhook.Builder.class);
  }

  public interface GenericWebServiceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Webhook.GenericWebService)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The webhook URI for receiving POST requests. It must use https protocol.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * Required. The webhook URI for receiving POST requests. It must use https protocol.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();

    /**
     *
     *
     * <pre>
     * The user name for HTTP Basic authentication.
     * </pre>
     *
     * <code>string username = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.username is deprecated.
     *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=107
     * @return The username.
     */
    @java.lang.Deprecated
    java.lang.String getUsername();
    /**
     *
     *
     * <pre>
     * The user name for HTTP Basic authentication.
     * </pre>
     *
     * <code>string username = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.username is deprecated.
     *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=107
     * @return The bytes for username.
     */
    @java.lang.Deprecated
    com.google.protobuf.ByteString getUsernameBytes();

    /**
     *
     *
     * <pre>
     * The password for HTTP Basic authentication.
     * </pre>
     *
     * <code>string password = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.password is deprecated.
     *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=110
     * @return The password.
     */
    @java.lang.Deprecated
    java.lang.String getPassword();
    /**
     *
     *
     * <pre>
     * The password for HTTP Basic authentication.
     * </pre>
     *
     * <code>string password = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.password is deprecated.
     *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=110
     * @return The bytes for password.
     */
    @java.lang.Deprecated
    com.google.protobuf.ByteString getPasswordBytes();

    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    int getRequestHeadersCount();
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    boolean containsRequestHeaders(java.lang.String key);
    /** Use {@link #getRequestHeadersMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getRequestHeaders();
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getRequestHeadersMap();
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */

    /* nullable */
    java.lang.String getRequestHeadersOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    java.lang.String getRequestHeadersOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of allowed custom CA certificates (in DER format) for
     * HTTPS verification. This overrides the default SSL trust store. If this
     * is empty or unspecified, Dialogflow will use Google's default trust store
     * to verify certificates.
     * N.B. Make sure the HTTPS server certificates are signed with "subject alt
     * name". For instance a certificate can be self-signed using the following
     * command,
     * ```
     *    openssl x509 -req -days 200 -in example.com.csr &#92;
     *      -signkey example.com.key &#92;
     *      -out example.com.crt &#92;
     *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
     * ```
     * </pre>
     *
     * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the allowedCaCerts.
     */
    java.util.List<com.google.protobuf.ByteString> getAllowedCaCertsList();
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of allowed custom CA certificates (in DER format) for
     * HTTPS verification. This overrides the default SSL trust store. If this
     * is empty or unspecified, Dialogflow will use Google's default trust store
     * to verify certificates.
     * N.B. Make sure the HTTPS server certificates are signed with "subject alt
     * name". For instance a certificate can be self-signed using the following
     * command,
     * ```
     *    openssl x509 -req -days 200 -in example.com.csr &#92;
     *      -signkey example.com.key &#92;
     *      -out example.com.crt &#92;
     *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
     * ```
     * </pre>
     *
     * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of allowedCaCerts.
     */
    int getAllowedCaCertsCount();
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of allowed custom CA certificates (in DER format) for
     * HTTPS verification. This overrides the default SSL trust store. If this
     * is empty or unspecified, Dialogflow will use Google's default trust store
     * to verify certificates.
     * N.B. Make sure the HTTPS server certificates are signed with "subject alt
     * name". For instance a certificate can be self-signed using the following
     * command,
     * ```
     *    openssl x509 -req -days 200 -in example.com.csr &#92;
     *      -signkey example.com.key &#92;
     *      -out example.com.crt &#92;
     *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
     * ```
     * </pre>
     *
     * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The allowedCaCerts at the given index.
     */
    com.google.protobuf.ByteString getAllowedCaCerts(int index);
  }
  /**
   *
   *
   * <pre>
   * Represents configuration for a generic web service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Webhook.GenericWebService}
   */
  public static final class GenericWebService extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Webhook.GenericWebService)
      GenericWebServiceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GenericWebService.newBuilder() to construct.
    private GenericWebService(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GenericWebService() {
      uri_ = "";
      username_ = "";
      password_ = "";
      allowedCaCerts_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GenericWebService();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_Webhook_GenericWebService_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetRequestHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_Webhook_GenericWebService_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.class,
              com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.Builder.class);
    }

    public static final int URI_FIELD_NUMBER = 1;
    private volatile java.lang.Object uri_;
    /**
     *
     *
     * <pre>
     * Required. The webhook URI for receiving POST requests. It must use https protocol.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The webhook URI for receiving POST requests. It must use https protocol.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int USERNAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object username_;
    /**
     *
     *
     * <pre>
     * The user name for HTTP Basic authentication.
     * </pre>
     *
     * <code>string username = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.username is deprecated.
     *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=107
     * @return The username.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.lang.String getUsername() {
      java.lang.Object ref = username_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        username_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The user name for HTTP Basic authentication.
     * </pre>
     *
     * <code>string username = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.username is deprecated.
     *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=107
     * @return The bytes for username.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getUsernameBytes() {
      java.lang.Object ref = username_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        username_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PASSWORD_FIELD_NUMBER = 3;
    private volatile java.lang.Object password_;
    /**
     *
     *
     * <pre>
     * The password for HTTP Basic authentication.
     * </pre>
     *
     * <code>string password = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.password is deprecated.
     *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=110
     * @return The password.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.lang.String getPassword() {
      java.lang.Object ref = password_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        password_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The password for HTTP Basic authentication.
     * </pre>
     *
     * <code>string password = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.password is deprecated.
     *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=110
     * @return The bytes for password.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getPasswordBytes() {
      java.lang.Object ref = password_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        password_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REQUEST_HEADERS_FIELD_NUMBER = 4;

    private static final class RequestHeadersDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.cloud.dialogflow.cx.v3.WebhookProto
                  .internal_static_google_cloud_dialogflow_cx_v3_Webhook_GenericWebService_RequestHeadersEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> requestHeaders_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetRequestHeaders() {
      if (requestHeaders_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            RequestHeadersDefaultEntryHolder.defaultEntry);
      }
      return requestHeaders_;
    }

    public int getRequestHeadersCount() {
      return internalGetRequestHeaders().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    @java.lang.Override
    public boolean containsRequestHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetRequestHeaders().getMap().containsKey(key);
    }
    /** Use {@link #getRequestHeadersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getRequestHeaders() {
      return getRequestHeadersMap();
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getRequestHeadersMap() {
      return internalGetRequestHeaders().getMap();
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getRequestHeadersOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetRequestHeaders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getRequestHeadersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetRequestHeaders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int ALLOWED_CA_CERTS_FIELD_NUMBER = 5;
    private java.util.List<com.google.protobuf.ByteString> allowedCaCerts_;
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of allowed custom CA certificates (in DER format) for
     * HTTPS verification. This overrides the default SSL trust store. If this
     * is empty or unspecified, Dialogflow will use Google's default trust store
     * to verify certificates.
     * N.B. Make sure the HTTPS server certificates are signed with "subject alt
     * name". For instance a certificate can be self-signed using the following
     * command,
     * ```
     *    openssl x509 -req -days 200 -in example.com.csr &#92;
     *      -signkey example.com.key &#92;
     *      -out example.com.crt &#92;
     *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
     * ```
     * </pre>
     *
     * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the allowedCaCerts.
     */
    @java.lang.Override
    public java.util.List<com.google.protobuf.ByteString> getAllowedCaCertsList() {
      return allowedCaCerts_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of allowed custom CA certificates (in DER format) for
     * HTTPS verification. This overrides the default SSL trust store. If this
     * is empty or unspecified, Dialogflow will use Google's default trust store
     * to verify certificates.
     * N.B. Make sure the HTTPS server certificates are signed with "subject alt
     * name". For instance a certificate can be self-signed using the following
     * command,
     * ```
     *    openssl x509 -req -days 200 -in example.com.csr &#92;
     *      -signkey example.com.key &#92;
     *      -out example.com.crt &#92;
     *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
     * ```
     * </pre>
     *
     * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of allowedCaCerts.
     */
    public int getAllowedCaCertsCount() {
      return allowedCaCerts_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of allowed custom CA certificates (in DER format) for
     * HTTPS verification. This overrides the default SSL trust store. If this
     * is empty or unspecified, Dialogflow will use Google's default trust store
     * to verify certificates.
     * N.B. Make sure the HTTPS server certificates are signed with "subject alt
     * name". For instance a certificate can be self-signed using the following
     * command,
     * ```
     *    openssl x509 -req -days 200 -in example.com.csr &#92;
     *      -signkey example.com.key &#92;
     *      -out example.com.crt &#92;
     *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
     * ```
     * </pre>
     *
     * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The allowedCaCerts at the given index.
     */
    public com.google.protobuf.ByteString getAllowedCaCerts(int index) {
      return allowedCaCerts_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, username_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, password_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetRequestHeaders(), RequestHeadersDefaultEntryHolder.defaultEntry, 4);
      for (int i = 0; i < allowedCaCerts_.size(); i++) {
        output.writeBytes(5, allowedCaCerts_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, username_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, password_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetRequestHeaders().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> requestHeaders__ =
            RequestHeadersDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, requestHeaders__);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < allowedCaCerts_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeBytesSizeNoTag(allowedCaCerts_.get(i));
        }
        size += dataSize;
        size += 1 * getAllowedCaCertsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService other =
          (com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService) obj;

      if (!getUri().equals(other.getUri())) return false;
      if (!getUsername().equals(other.getUsername())) return false;
      if (!getPassword().equals(other.getPassword())) return false;
      if (!internalGetRequestHeaders().equals(other.internalGetRequestHeaders())) return false;
      if (!getAllowedCaCertsList().equals(other.getAllowedCaCertsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + URI_FIELD_NUMBER;
      hash = (53 * hash) + getUri().hashCode();
      hash = (37 * hash) + USERNAME_FIELD_NUMBER;
      hash = (53 * hash) + getUsername().hashCode();
      hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
      hash = (53 * hash) + getPassword().hashCode();
      if (!internalGetRequestHeaders().getMap().isEmpty()) {
        hash = (37 * hash) + REQUEST_HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetRequestHeaders().hashCode();
      }
      if (getAllowedCaCertsCount() > 0) {
        hash = (37 * hash) + ALLOWED_CA_CERTS_FIELD_NUMBER;
        hash = (53 * hash) + getAllowedCaCertsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents configuration for a generic web service.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.Webhook.GenericWebService}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Webhook.GenericWebService)
        com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebServiceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_Webhook_GenericWebService_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 4:
            return internalGetRequestHeaders();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 4:
            return internalGetMutableRequestHeaders();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_Webhook_GenericWebService_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.class,
                com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        uri_ = "";

        username_ = "";

        password_ = "";

        internalGetMutableRequestHeaders().clear();
        allowedCaCerts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_Webhook_GenericWebService_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService build() {
        com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService buildPartial() {
        com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService result =
            new com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService(this);
        int from_bitField0_ = bitField0_;
        result.uri_ = uri_;
        result.username_ = username_;
        result.password_ = password_;
        result.requestHeaders_ = internalGetRequestHeaders();
        result.requestHeaders_.makeImmutable();
        if (((bitField0_ & 0x00000002) != 0)) {
          allowedCaCerts_ = java.util.Collections.unmodifiableList(allowedCaCerts_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.allowedCaCerts_ = allowedCaCerts_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.getDefaultInstance())
          return this;
        if (!other.getUri().isEmpty()) {
          uri_ = other.uri_;
          onChanged();
        }
        if (!other.getUsername().isEmpty()) {
          username_ = other.username_;
          onChanged();
        }
        if (!other.getPassword().isEmpty()) {
          password_ = other.password_;
          onChanged();
        }
        internalGetMutableRequestHeaders().mergeFrom(other.internalGetRequestHeaders());
        if (!other.allowedCaCerts_.isEmpty()) {
          if (allowedCaCerts_.isEmpty()) {
            allowedCaCerts_ = other.allowedCaCerts_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureAllowedCaCertsIsMutable();
            allowedCaCerts_.addAll(other.allowedCaCerts_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  uri_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  username_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              case 26:
                {
                  password_ = input.readStringRequireUtf8();

                  break;
                } // case 26
              case 34:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                      requestHeaders__ =
                          input.readMessage(
                              RequestHeadersDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableRequestHeaders()
                      .getMutableMap()
                      .put(requestHeaders__.getKey(), requestHeaders__.getValue());
                  break;
                } // case 34
              case 42:
                {
                  com.google.protobuf.ByteString v = input.readBytes();
                  ensureAllowedCaCertsIsMutable();
                  allowedCaCerts_.add(v);
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * Required. The webhook URI for receiving POST requests. It must use https protocol.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The uri.
       */
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The webhook URI for receiving POST requests. It must use https protocol.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for uri.
       */
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The webhook URI for receiving POST requests. It must use https protocol.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        uri_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The webhook URI for receiving POST requests. It must use https protocol.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {

        uri_ = getDefaultInstance().getUri();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The webhook URI for receiving POST requests. It must use https protocol.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        uri_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object username_ = "";
      /**
       *
       *
       * <pre>
       * The user name for HTTP Basic authentication.
       * </pre>
       *
       * <code>string username = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.username is deprecated.
       *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=107
       * @return The username.
       */
      @java.lang.Deprecated
      public java.lang.String getUsername() {
        java.lang.Object ref = username_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          username_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The user name for HTTP Basic authentication.
       * </pre>
       *
       * <code>string username = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.username is deprecated.
       *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=107
       * @return The bytes for username.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ByteString getUsernameBytes() {
        java.lang.Object ref = username_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          username_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The user name for HTTP Basic authentication.
       * </pre>
       *
       * <code>string username = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.username is deprecated.
       *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=107
       * @param value The username to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setUsername(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        username_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The user name for HTTP Basic authentication.
       * </pre>
       *
       * <code>string username = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.username is deprecated.
       *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=107
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearUsername() {

        username_ = getDefaultInstance().getUsername();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The user name for HTTP Basic authentication.
       * </pre>
       *
       * <code>string username = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.username is deprecated.
       *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=107
       * @param value The bytes for username to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        username_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object password_ = "";
      /**
       *
       *
       * <pre>
       * The password for HTTP Basic authentication.
       * </pre>
       *
       * <code>string password = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.password is deprecated.
       *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=110
       * @return The password.
       */
      @java.lang.Deprecated
      public java.lang.String getPassword() {
        java.lang.Object ref = password_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          password_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The password for HTTP Basic authentication.
       * </pre>
       *
       * <code>string password = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.password is deprecated.
       *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=110
       * @return The bytes for password.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ByteString getPasswordBytes() {
        java.lang.Object ref = password_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          password_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The password for HTTP Basic authentication.
       * </pre>
       *
       * <code>string password = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.password is deprecated.
       *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=110
       * @param value The password to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setPassword(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        password_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The password for HTTP Basic authentication.
       * </pre>
       *
       * <code>string password = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.password is deprecated.
       *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=110
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearPassword() {

        password_ = getDefaultInstance().getPassword();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The password for HTTP Basic authentication.
       * </pre>
       *
       * <code>string password = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.password is deprecated.
       *     See google/cloud/dialogflow/cx/v3/webhook.proto;l=110
       * @param value The bytes for password to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setPasswordBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        password_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> requestHeaders_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetRequestHeaders() {
        if (requestHeaders_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              RequestHeadersDefaultEntryHolder.defaultEntry);
        }
        return requestHeaders_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableRequestHeaders() {
        onChanged();
        ;
        if (requestHeaders_ == null) {
          requestHeaders_ =
              com.google.protobuf.MapField.newMapField(
                  RequestHeadersDefaultEntryHolder.defaultEntry);
        }
        if (!requestHeaders_.isMutable()) {
          requestHeaders_ = requestHeaders_.copy();
        }
        return requestHeaders_;
      }

      public int getRequestHeadersCount() {
        return internalGetRequestHeaders().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with webhook
       * requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      @java.lang.Override
      public boolean containsRequestHeaders(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetRequestHeaders().getMap().containsKey(key);
      }
      /** Use {@link #getRequestHeadersMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getRequestHeaders() {
        return getRequestHeadersMap();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with webhook
       * requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getRequestHeadersMap() {
        return internalGetRequestHeaders().getMap();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with webhook
       * requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      @java.lang.Override
      public java.lang.String getRequestHeadersOrDefault(
          java.lang.String key, java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetRequestHeaders().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with webhook
       * requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      @java.lang.Override
      public java.lang.String getRequestHeadersOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetRequestHeaders().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearRequestHeaders() {
        internalGetMutableRequestHeaders().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with webhook
       * requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      public Builder removeRequestHeaders(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableRequestHeaders().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableRequestHeaders() {
        return internalGetMutableRequestHeaders().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with webhook
       * requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      public Builder putRequestHeaders(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }

        internalGetMutableRequestHeaders().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with webhook
       * requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      public Builder putAllRequestHeaders(
          java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableRequestHeaders().getMutableMap().putAll(values);
        return this;
      }

      private java.util.List<com.google.protobuf.ByteString> allowedCaCerts_ =
          java.util.Collections.emptyList();

      private void ensureAllowedCaCertsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          allowedCaCerts_ =
              new java.util.ArrayList<com.google.protobuf.ByteString>(allowedCaCerts_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies a list of allowed custom CA certificates (in DER format) for
       * HTTPS verification. This overrides the default SSL trust store. If this
       * is empty or unspecified, Dialogflow will use Google's default trust store
       * to verify certificates.
       * N.B. Make sure the HTTPS server certificates are signed with "subject alt
       * name". For instance a certificate can be self-signed using the following
       * command,
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the allowedCaCerts.
       */
      public java.util.List<com.google.protobuf.ByteString> getAllowedCaCertsList() {
        return ((bitField0_ & 0x00000002) != 0)
            ? java.util.Collections.unmodifiableList(allowedCaCerts_)
            : allowedCaCerts_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies a list of allowed custom CA certificates (in DER format) for
       * HTTPS verification. This overrides the default SSL trust store. If this
       * is empty or unspecified, Dialogflow will use Google's default trust store
       * to verify certificates.
       * N.B. Make sure the HTTPS server certificates are signed with "subject alt
       * name". For instance a certificate can be self-signed using the following
       * command,
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of allowedCaCerts.
       */
      public int getAllowedCaCertsCount() {
        return allowedCaCerts_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies a list of allowed custom CA certificates (in DER format) for
       * HTTPS verification. This overrides the default SSL trust store. If this
       * is empty or unspecified, Dialogflow will use Google's default trust store
       * to verify certificates.
       * N.B. Make sure the HTTPS server certificates are signed with "subject alt
       * name". For instance a certificate can be self-signed using the following
       * command,
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The allowedCaCerts at the given index.
       */
      public com.google.protobuf.ByteString getAllowedCaCerts(int index) {
        return allowedCaCerts_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies a list of allowed custom CA certificates (in DER format) for
       * HTTPS verification. This overrides the default SSL trust store. If this
       * is empty or unspecified, Dialogflow will use Google's default trust store
       * to verify certificates.
       * N.B. Make sure the HTTPS server certificates are signed with "subject alt
       * name". For instance a certificate can be self-signed using the following
       * command,
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The allowedCaCerts to set.
       * @return This builder for chaining.
       */
      public Builder setAllowedCaCerts(int index, com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedCaCertsIsMutable();
        allowedCaCerts_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies a list of allowed custom CA certificates (in DER format) for
       * HTTPS verification. This overrides the default SSL trust store. If this
       * is empty or unspecified, Dialogflow will use Google's default trust store
       * to verify certificates.
       * N.B. Make sure the HTTPS server certificates are signed with "subject alt
       * name". For instance a certificate can be self-signed using the following
       * command,
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The allowedCaCerts to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedCaCerts(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedCaCertsIsMutable();
        allowedCaCerts_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies a list of allowed custom CA certificates (in DER format) for
       * HTTPS verification. This overrides the default SSL trust store. If this
       * is empty or unspecified, Dialogflow will use Google's default trust store
       * to verify certificates.
       * N.B. Make sure the HTTPS server certificates are signed with "subject alt
       * name". For instance a certificate can be self-signed using the following
       * command,
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The allowedCaCerts to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllowedCaCerts(
          java.lang.Iterable<? extends com.google.protobuf.ByteString> values) {
        ensureAllowedCaCertsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedCaCerts_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies a list of allowed custom CA certificates (in DER format) for
       * HTTPS verification. This overrides the default SSL trust store. If this
       * is empty or unspecified, Dialogflow will use Google's default trust store
       * to verify certificates.
       * N.B. Make sure the HTTPS server certificates are signed with "subject alt
       * name". For instance a certificate can be self-signed using the following
       * command,
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowedCaCerts() {
        allowedCaCerts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Webhook.GenericWebService)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Webhook.GenericWebService)
    private static final com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService();
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GenericWebService> PARSER =
        new com.google.protobuf.AbstractParser<GenericWebService>() {
          @java.lang.Override
          public GenericWebService parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GenericWebService> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GenericWebService> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ServiceDirectoryConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
     * `Location ID` of the service directory must be the same as the location
     * of the agent.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The service.
     */
    java.lang.String getService();
    /**
     *
     *
     * <pre>
     * Required. The name of [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
     * `Location ID` of the service directory must be the same as the location
     * of the agent.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for service.
     */
    com.google.protobuf.ByteString getServiceBytes();

    /**
     *
     *
     * <pre>
     * Generic Service configuration of this webhook.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 2;
     * </code>
     *
     * @return Whether the genericWebService field is set.
     */
    boolean hasGenericWebService();
    /**
     *
     *
     * <pre>
     * Generic Service configuration of this webhook.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 2;
     * </code>
     *
     * @return The genericWebService.
     */
    com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService getGenericWebService();
    /**
     *
     *
     * <pre>
     * Generic Service configuration of this webhook.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 2;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebServiceOrBuilder
        getGenericWebServiceOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Represents configuration for a [Service
   * Directory](https://cloud.google.com/service-directory) service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig}
   */
  public static final class ServiceDirectoryConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig)
      ServiceDirectoryConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ServiceDirectoryConfig.newBuilder() to construct.
    private ServiceDirectoryConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ServiceDirectoryConfig() {
      service_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ServiceDirectoryConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_Webhook_ServiceDirectoryConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_Webhook_ServiceDirectoryConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig.class,
              com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig.Builder.class);
    }

    public static final int SERVICE_FIELD_NUMBER = 1;
    private volatile java.lang.Object service_;
    /**
     *
     *
     * <pre>
     * Required. The name of [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
     * `Location ID` of the service directory must be the same as the location
     * of the agent.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The service.
     */
    @java.lang.Override
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
     * `Location ID` of the service directory must be the same as the location
     * of the agent.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for service.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GENERIC_WEB_SERVICE_FIELD_NUMBER = 2;
    private com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService genericWebService_;
    /**
     *
     *
     * <pre>
     * Generic Service configuration of this webhook.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 2;
     * </code>
     *
     * @return Whether the genericWebService field is set.
     */
    @java.lang.Override
    public boolean hasGenericWebService() {
      return genericWebService_ != null;
    }
    /**
     *
     *
     * <pre>
     * Generic Service configuration of this webhook.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 2;
     * </code>
     *
     * @return The genericWebService.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService getGenericWebService() {
      return genericWebService_ == null
          ? com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.getDefaultInstance()
          : genericWebService_;
    }
    /**
     *
     *
     * <pre>
     * Generic Service configuration of this webhook.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebServiceOrBuilder
        getGenericWebServiceOrBuilder() {
      return getGenericWebService();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
      }
      if (genericWebService_ != null) {
        output.writeMessage(2, getGenericWebService());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
      }
      if (genericWebService_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getGenericWebService());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig other =
          (com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig) obj;

      if (!getService().equals(other.getService())) return false;
      if (hasGenericWebService() != other.hasGenericWebService()) return false;
      if (hasGenericWebService()) {
        if (!getGenericWebService().equals(other.getGenericWebService())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getService().hashCode();
      if (hasGenericWebService()) {
        hash = (37 * hash) + GENERIC_WEB_SERVICE_FIELD_NUMBER;
        hash = (53 * hash) + getGenericWebService().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig)
        com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_Webhook_ServiceDirectoryConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_Webhook_ServiceDirectoryConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig.class,
                com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        service_ = "";

        if (genericWebServiceBuilder_ == null) {
          genericWebService_ = null;
        } else {
          genericWebService_ = null;
          genericWebServiceBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_Webhook_ServiceDirectoryConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig build() {
        com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig buildPartial() {
        com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig result =
            new com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig(this);
        result.service_ = service_;
        if (genericWebServiceBuilder_ == null) {
          result.genericWebService_ = genericWebService_;
        } else {
          result.genericWebService_ = genericWebServiceBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig
                .getDefaultInstance()) return this;
        if (!other.getService().isEmpty()) {
          service_ = other.service_;
          onChanged();
        }
        if (other.hasGenericWebService()) {
          mergeGenericWebService(other.getGenericWebService());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  service_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getGenericWebServiceFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object service_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of [Service
       * Directory](https://cloud.google.com/service-directory) service.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
       * `Location ID` of the service directory must be the same as the location
       * of the agent.
       * </pre>
       *
       * <code>
       * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The service.
       */
      public java.lang.String getService() {
        java.lang.Object ref = service_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          service_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of [Service
       * Directory](https://cloud.google.com/service-directory) service.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
       * `Location ID` of the service directory must be the same as the location
       * of the agent.
       * </pre>
       *
       * <code>
       * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for service.
       */
      public com.google.protobuf.ByteString getServiceBytes() {
        java.lang.Object ref = service_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          service_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of [Service
       * Directory](https://cloud.google.com/service-directory) service.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
       * `Location ID` of the service directory must be the same as the location
       * of the agent.
       * </pre>
       *
       * <code>
       * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The service to set.
       * @return This builder for chaining.
       */
      public Builder setService(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        service_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of [Service
       * Directory](https://cloud.google.com/service-directory) service.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
       * `Location ID` of the service directory must be the same as the location
       * of the agent.
       * </pre>
       *
       * <code>
       * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearService() {

        service_ = getDefaultInstance().getService();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of [Service
       * Directory](https://cloud.google.com/service-directory) service.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
       * `Location ID` of the service directory must be the same as the location
       * of the agent.
       * </pre>
       *
       * <code>
       * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for service to set.
       * @return This builder for chaining.
       */
      public Builder setServiceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        service_ = value;
        onChanged();
        return this;
      }

      private com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService genericWebService_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService,
              com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.Builder,
              com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebServiceOrBuilder>
          genericWebServiceBuilder_;
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       *
       * @return Whether the genericWebService field is set.
       */
      public boolean hasGenericWebService() {
        return genericWebServiceBuilder_ != null || genericWebService_ != null;
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       *
       * @return The genericWebService.
       */
      public com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService getGenericWebService() {
        if (genericWebServiceBuilder_ == null) {
          return genericWebService_ == null
              ? com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.getDefaultInstance()
              : genericWebService_;
        } else {
          return genericWebServiceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       */
      public Builder setGenericWebService(
          com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService value) {
        if (genericWebServiceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          genericWebService_ = value;
          onChanged();
        } else {
          genericWebServiceBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       */
      public Builder setGenericWebService(
          com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.Builder builderForValue) {
        if (genericWebServiceBuilder_ == null) {
          genericWebService_ = builderForValue.build();
          onChanged();
        } else {
          genericWebServiceBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       */
      public Builder mergeGenericWebService(
          com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService value) {
        if (genericWebServiceBuilder_ == null) {
          if (genericWebService_ != null) {
            genericWebService_ =
                com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.newBuilder(
                        genericWebService_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            genericWebService_ = value;
          }
          onChanged();
        } else {
          genericWebServiceBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       */
      public Builder clearGenericWebService() {
        if (genericWebServiceBuilder_ == null) {
          genericWebService_ = null;
          onChanged();
        } else {
          genericWebService_ = null;
          genericWebServiceBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.Builder
          getGenericWebServiceBuilder() {

        onChanged();
        return getGenericWebServiceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebServiceOrBuilder
          getGenericWebServiceOrBuilder() {
        if (genericWebServiceBuilder_ != null) {
          return genericWebServiceBuilder_.getMessageOrBuilder();
        } else {
          return genericWebService_ == null
              ? com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.getDefaultInstance()
              : genericWebService_;
        }
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService,
              com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.Builder,
              com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebServiceOrBuilder>
          getGenericWebServiceFieldBuilder() {
        if (genericWebServiceBuilder_ == null) {
          genericWebServiceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService,
                  com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.Builder,
                  com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebServiceOrBuilder>(
                  getGenericWebService(), getParentForChildren(), isClean());
          genericWebService_ = null;
        }
        return genericWebServiceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig)
    private static final com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig();
    }

    public static com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ServiceDirectoryConfig> PARSER =
        new com.google.protobuf.AbstractParser<ServiceDirectoryConfig>() {
          @java.lang.Override
          public ServiceDirectoryConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ServiceDirectoryConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ServiceDirectoryConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int webhookCase_ = 0;
  private java.lang.Object webhook_;

  public enum WebhookCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GENERIC_WEB_SERVICE(4),
    SERVICE_DIRECTORY(7),
    WEBHOOK_NOT_SET(0);
    private final int value;

    private WebhookCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static WebhookCase valueOf(int value) {
      return forNumber(value);
    }

    public static WebhookCase forNumber(int value) {
      switch (value) {
        case 4:
          return GENERIC_WEB_SERVICE;
        case 7:
          return SERVICE_DIRECTORY;
        case 0:
          return WEBHOOK_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public WebhookCase getWebhookCase() {
    return WebhookCase.forNumber(webhookCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The unique identifier of the webhook.
   * Required for the [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.UpdateWebhook] method.
   * [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.CreateWebhook] populates the name automatically.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/webhooks/&lt;Webhook ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the webhook.
   * Required for the [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.UpdateWebhook] method.
   * [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.CreateWebhook] populates the name automatically.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/webhooks/&lt;Webhook ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the webhook, unique within the agent.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the webhook, unique within the agent.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GENERIC_WEB_SERVICE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Configuration for a generic web service.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 4;</code>
   *
   * @return Whether the genericWebService field is set.
   */
  @java.lang.Override
  public boolean hasGenericWebService() {
    return webhookCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a generic web service.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 4;</code>
   *
   * @return The genericWebService.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService getGenericWebService() {
    if (webhookCase_ == 4) {
      return (com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService) webhook_;
    }
    return com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for a generic web service.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebServiceOrBuilder
      getGenericWebServiceOrBuilder() {
    if (webhookCase_ == 4) {
      return (com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService) webhook_;
    }
    return com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.getDefaultInstance();
  }

  public static final int SERVICE_DIRECTORY_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Configuration for a [Service
   * Directory](https://cloud.google.com/service-directory) service.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig service_directory = 7;
   * </code>
   *
   * @return Whether the serviceDirectory field is set.
   */
  @java.lang.Override
  public boolean hasServiceDirectory() {
    return webhookCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a [Service
   * Directory](https://cloud.google.com/service-directory) service.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig service_directory = 7;
   * </code>
   *
   * @return The serviceDirectory.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig getServiceDirectory() {
    if (webhookCase_ == 7) {
      return (com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig) webhook_;
    }
    return com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for a [Service
   * Directory](https://cloud.google.com/service-directory) service.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig service_directory = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfigOrBuilder
      getServiceDirectoryOrBuilder() {
    if (webhookCase_ == 7) {
      return (com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig) webhook_;
    }
    return com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig.getDefaultInstance();
  }

  public static final int TIMEOUT_FIELD_NUMBER = 6;
  private com.google.protobuf.Duration timeout_;
  /**
   *
   *
   * <pre>
   * Webhook execution timeout. Execution is considered failed if Dialogflow
   * doesn't receive a response from webhook at the end of the timeout period.
   * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 6;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return timeout_ != null;
  }
  /**
   *
   *
   * <pre>
   * Webhook execution timeout. Execution is considered failed if Dialogflow
   * doesn't receive a response from webhook at the end of the timeout period.
   * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 6;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * Webhook execution timeout. Execution is considered failed if Dialogflow
   * doesn't receive a response from webhook at the end of the timeout period.
   * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return getTimeout();
  }

  public static final int DISABLED_FIELD_NUMBER = 5;
  private boolean disabled_;
  /**
   *
   *
   * <pre>
   * Indicates whether the webhook is disabled.
   * </pre>
   *
   * <code>bool disabled = 5;</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (webhookCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService) webhook_);
    }
    if (disabled_ != false) {
      output.writeBool(5, disabled_);
    }
    if (timeout_ != null) {
      output.writeMessage(6, getTimeout());
    }
    if (webhookCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig) webhook_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (webhookCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService) webhook_);
    }
    if (disabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, disabled_);
    }
    if (timeout_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getTimeout());
    }
    if (webhookCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig) webhook_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Webhook)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.Webhook other =
        (com.google.cloud.dialogflow.cx.v3.Webhook) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (getDisabled() != other.getDisabled()) return false;
    if (!getWebhookCase().equals(other.getWebhookCase())) return false;
    switch (webhookCase_) {
      case 4:
        if (!getGenericWebService().equals(other.getGenericWebService())) return false;
        break;
      case 7:
        if (!getServiceDirectory().equals(other.getServiceDirectory())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    hash = (37 * hash) + DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    switch (webhookCase_) {
      case 4:
        hash = (37 * hash) + GENERIC_WEB_SERVICE_FIELD_NUMBER;
        hash = (53 * hash) + getGenericWebService().hashCode();
        break;
      case 7:
        hash = (37 * hash) + SERVICE_DIRECTORY_FIELD_NUMBER;
        hash = (53 * hash) + getServiceDirectory().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.Webhook parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Webhook parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Webhook parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Webhook parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Webhook parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Webhook parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Webhook parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Webhook parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Webhook parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Webhook parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Webhook parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Webhook parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.Webhook prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Webhooks host the developer's business logic. During a session, webhooks
   * allow the developer to use the data extracted by Dialogflow's natural
   * language processing to generate dynamic responses, validate collected data,
   * or trigger actions on the backend.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Webhook}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Webhook)
      com.google.cloud.dialogflow.cx.v3.WebhookOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_Webhook_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_Webhook_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Webhook.class,
              com.google.cloud.dialogflow.cx.v3.Webhook.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.Webhook.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      if (genericWebServiceBuilder_ != null) {
        genericWebServiceBuilder_.clear();
      }
      if (serviceDirectoryBuilder_ != null) {
        serviceDirectoryBuilder_.clear();
      }
      if (timeoutBuilder_ == null) {
        timeout_ = null;
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }
      disabled_ = false;

      webhookCase_ = 0;
      webhook_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_Webhook_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Webhook getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.Webhook.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Webhook build() {
      com.google.cloud.dialogflow.cx.v3.Webhook result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Webhook buildPartial() {
      com.google.cloud.dialogflow.cx.v3.Webhook result =
          new com.google.cloud.dialogflow.cx.v3.Webhook(this);
      result.name_ = name_;
      result.displayName_ = displayName_;
      if (webhookCase_ == 4) {
        if (genericWebServiceBuilder_ == null) {
          result.webhook_ = webhook_;
        } else {
          result.webhook_ = genericWebServiceBuilder_.build();
        }
      }
      if (webhookCase_ == 7) {
        if (serviceDirectoryBuilder_ == null) {
          result.webhook_ = webhook_;
        } else {
          result.webhook_ = serviceDirectoryBuilder_.build();
        }
      }
      if (timeoutBuilder_ == null) {
        result.timeout_ = timeout_;
      } else {
        result.timeout_ = timeoutBuilder_.build();
      }
      result.disabled_ = disabled_;
      result.webhookCase_ = webhookCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.Webhook) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.Webhook) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.Webhook other) {
      if (other == com.google.cloud.dialogflow.cx.v3.Webhook.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (other.getDisabled() != false) {
        setDisabled(other.getDisabled());
      }
      switch (other.getWebhookCase()) {
        case GENERIC_WEB_SERVICE:
          {
            mergeGenericWebService(other.getGenericWebService());
            break;
          }
        case SERVICE_DIRECTORY:
          {
            mergeServiceDirectory(other.getServiceDirectory());
            break;
          }
        case WEBHOOK_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 34:
              {
                input.readMessage(
                    getGenericWebServiceFieldBuilder().getBuilder(), extensionRegistry);
                webhookCase_ = 4;
                break;
              } // case 34
            case 40:
              {
                disabled_ = input.readBool();

                break;
              } // case 40
            case 50:
              {
                input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getServiceDirectoryFieldBuilder().getBuilder(), extensionRegistry);
                webhookCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int webhookCase_ = 0;
    private java.lang.Object webhook_;

    public WebhookCase getWebhookCase() {
      return WebhookCase.forNumber(webhookCase_);
    }

    public Builder clearWebhook() {
      webhookCase_ = 0;
      webhook_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the webhook.
     * Required for the [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.UpdateWebhook] method.
     * [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.CreateWebhook] populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/webhooks/&lt;Webhook ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the webhook.
     * Required for the [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.UpdateWebhook] method.
     * [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.CreateWebhook] populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/webhooks/&lt;Webhook ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the webhook.
     * Required for the [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.UpdateWebhook] method.
     * [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.CreateWebhook] populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/webhooks/&lt;Webhook ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the webhook.
     * Required for the [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.UpdateWebhook] method.
     * [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.CreateWebhook] populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/webhooks/&lt;Webhook ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the webhook.
     * Required for the [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.UpdateWebhook] method.
     * [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.CreateWebhook] populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/webhooks/&lt;Webhook ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the webhook, unique within the agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the webhook, unique within the agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the webhook, unique within the agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the webhook, unique within the agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the webhook, unique within the agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService,
            com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.Builder,
            com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebServiceOrBuilder>
        genericWebServiceBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     *
     * @return Whether the genericWebService field is set.
     */
    @java.lang.Override
    public boolean hasGenericWebService() {
      return webhookCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     *
     * @return The genericWebService.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService getGenericWebService() {
      if (genericWebServiceBuilder_ == null) {
        if (webhookCase_ == 4) {
          return (com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService) webhook_;
        }
        return com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.getDefaultInstance();
      } else {
        if (webhookCase_ == 4) {
          return genericWebServiceBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     */
    public Builder setGenericWebService(
        com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService value) {
      if (genericWebServiceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webhook_ = value;
        onChanged();
      } else {
        genericWebServiceBuilder_.setMessage(value);
      }
      webhookCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     */
    public Builder setGenericWebService(
        com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.Builder builderForValue) {
      if (genericWebServiceBuilder_ == null) {
        webhook_ = builderForValue.build();
        onChanged();
      } else {
        genericWebServiceBuilder_.setMessage(builderForValue.build());
      }
      webhookCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     */
    public Builder mergeGenericWebService(
        com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService value) {
      if (genericWebServiceBuilder_ == null) {
        if (webhookCase_ == 4
            && webhook_
                != com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService
                    .getDefaultInstance()) {
          webhook_ =
              com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService) webhook_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          webhook_ = value;
        }
        onChanged();
      } else {
        if (webhookCase_ == 4) {
          genericWebServiceBuilder_.mergeFrom(value);
        } else {
          genericWebServiceBuilder_.setMessage(value);
        }
      }
      webhookCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     */
    public Builder clearGenericWebService() {
      if (genericWebServiceBuilder_ == null) {
        if (webhookCase_ == 4) {
          webhookCase_ = 0;
          webhook_ = null;
          onChanged();
        }
      } else {
        if (webhookCase_ == 4) {
          webhookCase_ = 0;
          webhook_ = null;
        }
        genericWebServiceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.Builder
        getGenericWebServiceBuilder() {
      return getGenericWebServiceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebServiceOrBuilder
        getGenericWebServiceOrBuilder() {
      if ((webhookCase_ == 4) && (genericWebServiceBuilder_ != null)) {
        return genericWebServiceBuilder_.getMessageOrBuilder();
      } else {
        if (webhookCase_ == 4) {
          return (com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService) webhook_;
        }
        return com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService,
            com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.Builder,
            com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebServiceOrBuilder>
        getGenericWebServiceFieldBuilder() {
      if (genericWebServiceBuilder_ == null) {
        if (!(webhookCase_ == 4)) {
          webhook_ =
              com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.getDefaultInstance();
        }
        genericWebServiceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService,
                com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.Builder,
                com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebServiceOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3.Webhook.GenericWebService) webhook_,
                getParentForChildren(),
                isClean());
        webhook_ = null;
      }
      webhookCase_ = 4;
      onChanged();
      ;
      return genericWebServiceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig,
            com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig.Builder,
            com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfigOrBuilder>
        serviceDirectoryBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     *
     * @return Whether the serviceDirectory field is set.
     */
    @java.lang.Override
    public boolean hasServiceDirectory() {
      return webhookCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     *
     * @return The serviceDirectory.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig getServiceDirectory() {
      if (serviceDirectoryBuilder_ == null) {
        if (webhookCase_ == 7) {
          return (com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig) webhook_;
        }
        return com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig
            .getDefaultInstance();
      } else {
        if (webhookCase_ == 7) {
          return serviceDirectoryBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     */
    public Builder setServiceDirectory(
        com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig value) {
      if (serviceDirectoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webhook_ = value;
        onChanged();
      } else {
        serviceDirectoryBuilder_.setMessage(value);
      }
      webhookCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     */
    public Builder setServiceDirectory(
        com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig.Builder builderForValue) {
      if (serviceDirectoryBuilder_ == null) {
        webhook_ = builderForValue.build();
        onChanged();
      } else {
        serviceDirectoryBuilder_.setMessage(builderForValue.build());
      }
      webhookCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     */
    public Builder mergeServiceDirectory(
        com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig value) {
      if (serviceDirectoryBuilder_ == null) {
        if (webhookCase_ == 7
            && webhook_
                != com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig
                    .getDefaultInstance()) {
          webhook_ =
              com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig) webhook_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          webhook_ = value;
        }
        onChanged();
      } else {
        if (webhookCase_ == 7) {
          serviceDirectoryBuilder_.mergeFrom(value);
        } else {
          serviceDirectoryBuilder_.setMessage(value);
        }
      }
      webhookCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     */
    public Builder clearServiceDirectory() {
      if (serviceDirectoryBuilder_ == null) {
        if (webhookCase_ == 7) {
          webhookCase_ = 0;
          webhook_ = null;
          onChanged();
        }
      } else {
        if (webhookCase_ == 7) {
          webhookCase_ = 0;
          webhook_ = null;
        }
        serviceDirectoryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig.Builder
        getServiceDirectoryBuilder() {
      return getServiceDirectoryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfigOrBuilder
        getServiceDirectoryOrBuilder() {
      if ((webhookCase_ == 7) && (serviceDirectoryBuilder_ != null)) {
        return serviceDirectoryBuilder_.getMessageOrBuilder();
      } else {
        if (webhookCase_ == 7) {
          return (com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig) webhook_;
        }
        return com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig,
            com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig.Builder,
            com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfigOrBuilder>
        getServiceDirectoryFieldBuilder() {
      if (serviceDirectoryBuilder_ == null) {
        if (!(webhookCase_ == 7)) {
          webhook_ =
              com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig.getDefaultInstance();
        }
        serviceDirectoryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig,
                com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig.Builder,
                com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfigOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig) webhook_,
                getParentForChildren(),
                isClean());
        webhook_ = null;
      }
      webhookCase_ = 7;
      onChanged();
      ;
      return serviceDirectoryBuilder_;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return timeoutBuilder_ != null || timeout_ != null;
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
        onChanged();
      } else {
        timeoutBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
        onChanged();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (timeout_ != null) {
          timeout_ =
              com.google.protobuf.Duration.newBuilder(timeout_).mergeFrom(value).buildPartial();
        } else {
          timeout_ = value;
        }
        onChanged();
      } else {
        timeoutBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder clearTimeout() {
      if (timeoutBuilder_ == null) {
        timeout_ = null;
        onChanged();
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {

      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private boolean disabled_;
    /**
     *
     *
     * <pre>
     * Indicates whether the webhook is disabled.
     * </pre>
     *
     * <code>bool disabled = 5;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the webhook is disabled.
     * </pre>
     *
     * <code>bool disabled = 5;</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the webhook is disabled.
     * </pre>
     *
     * <code>bool disabled = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {

      disabled_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Webhook)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Webhook)
  private static final com.google.cloud.dialogflow.cx.v3.Webhook DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Webhook();
  }

  public static com.google.cloud.dialogflow.cx.v3.Webhook getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Webhook> PARSER =
      new com.google.protobuf.AbstractParser<Webhook>() {
        @java.lang.Override
        public Webhook parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Webhook> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Webhook> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Webhook getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
