/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/test_case.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Transition coverage represents the percentage of all possible page
 * transitions (page-level transition routes and event handlers, excluding
 * transition route groups) present within any of a parent's test cases.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.TransitionCoverage}
 */
public final class TransitionCoverage extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.TransitionCoverage)
    TransitionCoverageOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransitionCoverage.newBuilder() to construct.
  private TransitionCoverage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransitionCoverage() {
    transitions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransitionCoverage();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.TestCaseProto
        .internal_static_google_cloud_dialogflow_cx_v3_TransitionCoverage_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.TestCaseProto
        .internal_static_google_cloud_dialogflow_cx_v3_TransitionCoverage_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.TransitionCoverage.class,
            com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Builder.class);
  }

  public interface TransitionNodeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3.Page]. Only some fields such as name and
     * displayname will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page page = 1;</code>
     *
     * @return Whether the page field is set.
     */
    boolean hasPage();
    /**
     *
     *
     * <pre>
     * Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3.Page]. Only some fields such as name and
     * displayname will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page page = 1;</code>
     *
     * @return The page.
     */
    com.google.cloud.dialogflow.cx.v3.Page getPage();
    /**
     *
     *
     * <pre>
     * Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3.Page]. Only some fields such as name and
     * displayname will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page page = 1;</code>
     */
    com.google.cloud.dialogflow.cx.v3.PageOrBuilder getPageOrBuilder();

    /**
     *
     *
     * <pre>
     * Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3.Flow]. Only some fields such as name and
     * displayname will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Flow flow = 2;</code>
     *
     * @return Whether the flow field is set.
     */
    boolean hasFlow();
    /**
     *
     *
     * <pre>
     * Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3.Flow]. Only some fields such as name and
     * displayname will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Flow flow = 2;</code>
     *
     * @return The flow.
     */
    com.google.cloud.dialogflow.cx.v3.Flow getFlow();
    /**
     *
     *
     * <pre>
     * Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3.Flow]. Only some fields such as name and
     * displayname will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Flow flow = 2;</code>
     */
    com.google.cloud.dialogflow.cx.v3.FlowOrBuilder getFlowOrBuilder();

    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.KindCase
        getKindCase();
  }
  /**
   *
   *
   * <pre>
   * The source or target of a transition.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode}
   */
  public static final class TransitionNode extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode)
      TransitionNodeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TransitionNode.newBuilder() to construct.
    private TransitionNode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TransitionNode() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TransitionNode();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_TransitionCoverage_TransitionNode_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_TransitionCoverage_TransitionNode_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.class,
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.Builder.class);
    }

    private int kindCase_ = 0;
    private java.lang.Object kind_;

    public enum KindCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      PAGE(1),
      FLOW(2),
      KIND_NOT_SET(0);
      private final int value;

      private KindCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static KindCase valueOf(int value) {
        return forNumber(value);
      }

      public static KindCase forNumber(int value) {
        switch (value) {
          case 1:
            return PAGE;
          case 2:
            return FLOW;
          case 0:
            return KIND_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public KindCase getKindCase() {
      return KindCase.forNumber(kindCase_);
    }

    public static final int PAGE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3.Page]. Only some fields such as name and
     * displayname will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page page = 1;</code>
     *
     * @return Whether the page field is set.
     */
    @java.lang.Override
    public boolean hasPage() {
      return kindCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3.Page]. Only some fields such as name and
     * displayname will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page page = 1;</code>
     *
     * @return The page.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Page getPage() {
      if (kindCase_ == 1) {
        return (com.google.cloud.dialogflow.cx.v3.Page) kind_;
      }
      return com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3.Page]. Only some fields such as name and
     * displayname will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page page = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.PageOrBuilder getPageOrBuilder() {
      if (kindCase_ == 1) {
        return (com.google.cloud.dialogflow.cx.v3.Page) kind_;
      }
      return com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance();
    }

    public static final int FLOW_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3.Flow]. Only some fields such as name and
     * displayname will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Flow flow = 2;</code>
     *
     * @return Whether the flow field is set.
     */
    @java.lang.Override
    public boolean hasFlow() {
      return kindCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3.Flow]. Only some fields such as name and
     * displayname will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Flow flow = 2;</code>
     *
     * @return The flow.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Flow getFlow() {
      if (kindCase_ == 2) {
        return (com.google.cloud.dialogflow.cx.v3.Flow) kind_;
      }
      return com.google.cloud.dialogflow.cx.v3.Flow.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3.Flow]. Only some fields such as name and
     * displayname will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Flow flow = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.FlowOrBuilder getFlowOrBuilder() {
      if (kindCase_ == 2) {
        return (com.google.cloud.dialogflow.cx.v3.Flow) kind_;
      }
      return com.google.cloud.dialogflow.cx.v3.Flow.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (kindCase_ == 1) {
        output.writeMessage(1, (com.google.cloud.dialogflow.cx.v3.Page) kind_);
      }
      if (kindCase_ == 2) {
        output.writeMessage(2, (com.google.cloud.dialogflow.cx.v3.Flow) kind_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (kindCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.cloud.dialogflow.cx.v3.Page) kind_);
      }
      if (kindCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.dialogflow.cx.v3.Flow) kind_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode other =
          (com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode) obj;

      if (!getKindCase().equals(other.getKindCase())) return false;
      switch (kindCase_) {
        case 1:
          if (!getPage().equals(other.getPage())) return false;
          break;
        case 2:
          if (!getFlow().equals(other.getFlow())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (kindCase_) {
        case 1:
          hash = (37 * hash) + PAGE_FIELD_NUMBER;
          hash = (53 * hash) + getPage().hashCode();
          break;
        case 2:
          hash = (37 * hash) + FLOW_FIELD_NUMBER;
          hash = (53 * hash) + getFlow().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The source or target of a transition.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode)
        com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNodeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3_TransitionCoverage_TransitionNode_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3_TransitionCoverage_TransitionNode_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.class,
                com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (pageBuilder_ != null) {
          pageBuilder_.clear();
        }
        if (flowBuilder_ != null) {
          flowBuilder_.clear();
        }
        kindCase_ = 0;
        kind_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3_TransitionCoverage_TransitionNode_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode build() {
        com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode buildPartial() {
        com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode result =
            new com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode(this);
        if (kindCase_ == 1) {
          if (pageBuilder_ == null) {
            result.kind_ = kind_;
          } else {
            result.kind_ = pageBuilder_.build();
          }
        }
        if (kindCase_ == 2) {
          if (flowBuilder_ == null) {
            result.kind_ = kind_;
          } else {
            result.kind_ = flowBuilder_.build();
          }
        }
        result.kindCase_ = kindCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode
                .getDefaultInstance()) return this;
        switch (other.getKindCase()) {
          case PAGE:
            {
              mergePage(other.getPage());
              break;
            }
          case FLOW:
            {
              mergeFlow(other.getFlow());
              break;
            }
          case KIND_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getPageFieldBuilder().getBuilder(), extensionRegistry);
                  kindCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getFlowFieldBuilder().getBuilder(), extensionRegistry);
                  kindCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int kindCase_ = 0;
      private java.lang.Object kind_;

      public KindCase getKindCase() {
        return KindCase.forNumber(kindCase_);
      }

      public Builder clearKind() {
        kindCase_ = 0;
        kind_ = null;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Page,
              com.google.cloud.dialogflow.cx.v3.Page.Builder,
              com.google.cloud.dialogflow.cx.v3.PageOrBuilder>
          pageBuilder_;
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3.Page]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page page = 1;</code>
       *
       * @return Whether the page field is set.
       */
      @java.lang.Override
      public boolean hasPage() {
        return kindCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3.Page]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page page = 1;</code>
       *
       * @return The page.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Page getPage() {
        if (pageBuilder_ == null) {
          if (kindCase_ == 1) {
            return (com.google.cloud.dialogflow.cx.v3.Page) kind_;
          }
          return com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance();
        } else {
          if (kindCase_ == 1) {
            return pageBuilder_.getMessage();
          }
          return com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3.Page]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page page = 1;</code>
       */
      public Builder setPage(com.google.cloud.dialogflow.cx.v3.Page value) {
        if (pageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          kind_ = value;
          onChanged();
        } else {
          pageBuilder_.setMessage(value);
        }
        kindCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3.Page]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page page = 1;</code>
       */
      public Builder setPage(com.google.cloud.dialogflow.cx.v3.Page.Builder builderForValue) {
        if (pageBuilder_ == null) {
          kind_ = builderForValue.build();
          onChanged();
        } else {
          pageBuilder_.setMessage(builderForValue.build());
        }
        kindCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3.Page]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page page = 1;</code>
       */
      public Builder mergePage(com.google.cloud.dialogflow.cx.v3.Page value) {
        if (pageBuilder_ == null) {
          if (kindCase_ == 1
              && kind_ != com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance()) {
            kind_ =
                com.google.cloud.dialogflow.cx.v3.Page.newBuilder(
                        (com.google.cloud.dialogflow.cx.v3.Page) kind_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            kind_ = value;
          }
          onChanged();
        } else {
          if (kindCase_ == 1) {
            pageBuilder_.mergeFrom(value);
          } else {
            pageBuilder_.setMessage(value);
          }
        }
        kindCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3.Page]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page page = 1;</code>
       */
      public Builder clearPage() {
        if (pageBuilder_ == null) {
          if (kindCase_ == 1) {
            kindCase_ = 0;
            kind_ = null;
            onChanged();
          }
        } else {
          if (kindCase_ == 1) {
            kindCase_ = 0;
            kind_ = null;
          }
          pageBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3.Page]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page page = 1;</code>
       */
      public com.google.cloud.dialogflow.cx.v3.Page.Builder getPageBuilder() {
        return getPageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3.Page]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page page = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.PageOrBuilder getPageOrBuilder() {
        if ((kindCase_ == 1) && (pageBuilder_ != null)) {
          return pageBuilder_.getMessageOrBuilder();
        } else {
          if (kindCase_ == 1) {
            return (com.google.cloud.dialogflow.cx.v3.Page) kind_;
          }
          return com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3.Page]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page page = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Page,
              com.google.cloud.dialogflow.cx.v3.Page.Builder,
              com.google.cloud.dialogflow.cx.v3.PageOrBuilder>
          getPageFieldBuilder() {
        if (pageBuilder_ == null) {
          if (!(kindCase_ == 1)) {
            kind_ = com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance();
          }
          pageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.Page,
                  com.google.cloud.dialogflow.cx.v3.Page.Builder,
                  com.google.cloud.dialogflow.cx.v3.PageOrBuilder>(
                  (com.google.cloud.dialogflow.cx.v3.Page) kind_,
                  getParentForChildren(),
                  isClean());
          kind_ = null;
        }
        kindCase_ = 1;
        onChanged();
        ;
        return pageBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Flow,
              com.google.cloud.dialogflow.cx.v3.Flow.Builder,
              com.google.cloud.dialogflow.cx.v3.FlowOrBuilder>
          flowBuilder_;
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3.Flow]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Flow flow = 2;</code>
       *
       * @return Whether the flow field is set.
       */
      @java.lang.Override
      public boolean hasFlow() {
        return kindCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3.Flow]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Flow flow = 2;</code>
       *
       * @return The flow.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Flow getFlow() {
        if (flowBuilder_ == null) {
          if (kindCase_ == 2) {
            return (com.google.cloud.dialogflow.cx.v3.Flow) kind_;
          }
          return com.google.cloud.dialogflow.cx.v3.Flow.getDefaultInstance();
        } else {
          if (kindCase_ == 2) {
            return flowBuilder_.getMessage();
          }
          return com.google.cloud.dialogflow.cx.v3.Flow.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3.Flow]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Flow flow = 2;</code>
       */
      public Builder setFlow(com.google.cloud.dialogflow.cx.v3.Flow value) {
        if (flowBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          kind_ = value;
          onChanged();
        } else {
          flowBuilder_.setMessage(value);
        }
        kindCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3.Flow]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Flow flow = 2;</code>
       */
      public Builder setFlow(com.google.cloud.dialogflow.cx.v3.Flow.Builder builderForValue) {
        if (flowBuilder_ == null) {
          kind_ = builderForValue.build();
          onChanged();
        } else {
          flowBuilder_.setMessage(builderForValue.build());
        }
        kindCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3.Flow]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Flow flow = 2;</code>
       */
      public Builder mergeFlow(com.google.cloud.dialogflow.cx.v3.Flow value) {
        if (flowBuilder_ == null) {
          if (kindCase_ == 2
              && kind_ != com.google.cloud.dialogflow.cx.v3.Flow.getDefaultInstance()) {
            kind_ =
                com.google.cloud.dialogflow.cx.v3.Flow.newBuilder(
                        (com.google.cloud.dialogflow.cx.v3.Flow) kind_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            kind_ = value;
          }
          onChanged();
        } else {
          if (kindCase_ == 2) {
            flowBuilder_.mergeFrom(value);
          } else {
            flowBuilder_.setMessage(value);
          }
        }
        kindCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3.Flow]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Flow flow = 2;</code>
       */
      public Builder clearFlow() {
        if (flowBuilder_ == null) {
          if (kindCase_ == 2) {
            kindCase_ = 0;
            kind_ = null;
            onChanged();
          }
        } else {
          if (kindCase_ == 2) {
            kindCase_ = 0;
            kind_ = null;
          }
          flowBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3.Flow]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Flow flow = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3.Flow.Builder getFlowBuilder() {
        return getFlowFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3.Flow]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Flow flow = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.FlowOrBuilder getFlowOrBuilder() {
        if ((kindCase_ == 2) && (flowBuilder_ != null)) {
          return flowBuilder_.getMessageOrBuilder();
        } else {
          if (kindCase_ == 2) {
            return (com.google.cloud.dialogflow.cx.v3.Flow) kind_;
          }
          return com.google.cloud.dialogflow.cx.v3.Flow.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3.Flow]. Only some fields such as name and
       * displayname will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Flow flow = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Flow,
              com.google.cloud.dialogflow.cx.v3.Flow.Builder,
              com.google.cloud.dialogflow.cx.v3.FlowOrBuilder>
          getFlowFieldBuilder() {
        if (flowBuilder_ == null) {
          if (!(kindCase_ == 2)) {
            kind_ = com.google.cloud.dialogflow.cx.v3.Flow.getDefaultInstance();
          }
          flowBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.Flow,
                  com.google.cloud.dialogflow.cx.v3.Flow.Builder,
                  com.google.cloud.dialogflow.cx.v3.FlowOrBuilder>(
                  (com.google.cloud.dialogflow.cx.v3.Flow) kind_,
                  getParentForChildren(),
                  isClean());
          kind_ = null;
        }
        kindCase_ = 2;
        onChanged();
        ;
        return flowBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode)
    private static final com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode();
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TransitionNode> PARSER =
        new com.google.protobuf.AbstractParser<TransitionNode>() {
          @java.lang.Override
          public TransitionNode parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TransitionNode> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TransitionNode> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TransitionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The start node of a transition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source = 1;</code>
     *
     * @return Whether the source field is set.
     */
    boolean hasSource();
    /**
     *
     *
     * <pre>
     * The start node of a transition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source = 1;</code>
     *
     * @return The source.
     */
    com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode getSource();
    /**
     *
     *
     * <pre>
     * The start node of a transition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source = 1;</code>
     */
    com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNodeOrBuilder
        getSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * The index of a transition in the transition list. Starting from 0.
     * </pre>
     *
     * <code>int32 index = 4;</code>
     *
     * @return The index.
     */
    int getIndex();

    /**
     *
     *
     * <pre>
     * The end node of a transition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target = 2;</code>
     *
     * @return Whether the target field is set.
     */
    boolean hasTarget();
    /**
     *
     *
     * <pre>
     * The end node of a transition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target = 2;</code>
     *
     * @return The target.
     */
    com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode getTarget();
    /**
     *
     *
     * <pre>
     * The end node of a transition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target = 2;</code>
     */
    com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNodeOrBuilder
        getTargetOrBuilder();

    /**
     *
     *
     * <pre>
     * Whether or not the transition is covered by at least one of the
     * agent's test cases.
     * </pre>
     *
     * <code>bool covered = 3;</code>
     *
     * @return The covered.
     */
    boolean getCovered();

    /**
     *
     *
     * <pre>
     * Intent route or condition route.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionRoute transition_route = 5;</code>
     *
     * @return Whether the transitionRoute field is set.
     */
    boolean hasTransitionRoute();
    /**
     *
     *
     * <pre>
     * Intent route or condition route.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionRoute transition_route = 5;</code>
     *
     * @return The transitionRoute.
     */
    com.google.cloud.dialogflow.cx.v3.TransitionRoute getTransitionRoute();
    /**
     *
     *
     * <pre>
     * Intent route or condition route.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionRoute transition_route = 5;</code>
     */
    com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder getTransitionRouteOrBuilder();

    /**
     *
     *
     * <pre>
     * Event handler.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.EventHandler event_handler = 6;</code>
     *
     * @return Whether the eventHandler field is set.
     */
    boolean hasEventHandler();
    /**
     *
     *
     * <pre>
     * Event handler.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.EventHandler event_handler = 6;</code>
     *
     * @return The eventHandler.
     */
    com.google.cloud.dialogflow.cx.v3.EventHandler getEventHandler();
    /**
     *
     *
     * <pre>
     * Event handler.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.EventHandler event_handler = 6;</code>
     */
    com.google.cloud.dialogflow.cx.v3.EventHandlerOrBuilder getEventHandlerOrBuilder();

    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.DetailCase
        getDetailCase();
  }
  /**
   *
   *
   * <pre>
   * A transition in a page.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition}
   */
  public static final class Transition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition)
      TransitionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Transition.newBuilder() to construct.
    private Transition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Transition() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Transition();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_TransitionCoverage_Transition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_TransitionCoverage_Transition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.class,
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.Builder.class);
    }

    private int detailCase_ = 0;
    private java.lang.Object detail_;

    public enum DetailCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      TRANSITION_ROUTE(5),
      EVENT_HANDLER(6),
      DETAIL_NOT_SET(0);
      private final int value;

      private DetailCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DetailCase valueOf(int value) {
        return forNumber(value);
      }

      public static DetailCase forNumber(int value) {
        switch (value) {
          case 5:
            return TRANSITION_ROUTE;
          case 6:
            return EVENT_HANDLER;
          case 0:
            return DETAIL_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DetailCase getDetailCase() {
      return DetailCase.forNumber(detailCase_);
    }

    public static final int SOURCE_FIELD_NUMBER = 1;
    private com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source_;
    /**
     *
     *
     * <pre>
     * The start node of a transition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source = 1;</code>
     *
     * @return Whether the source field is set.
     */
    @java.lang.Override
    public boolean hasSource() {
      return source_ != null;
    }
    /**
     *
     *
     * <pre>
     * The start node of a transition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source = 1;</code>
     *
     * @return The source.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode getSource() {
      return source_ == null
          ? com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.getDefaultInstance()
          : source_;
    }
    /**
     *
     *
     * <pre>
     * The start node of a transition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNodeOrBuilder
        getSourceOrBuilder() {
      return getSource();
    }

    public static final int INDEX_FIELD_NUMBER = 4;
    private int index_;
    /**
     *
     *
     * <pre>
     * The index of a transition in the transition list. Starting from 0.
     * </pre>
     *
     * <code>int32 index = 4;</code>
     *
     * @return The index.
     */
    @java.lang.Override
    public int getIndex() {
      return index_;
    }

    public static final int TARGET_FIELD_NUMBER = 2;
    private com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target_;
    /**
     *
     *
     * <pre>
     * The end node of a transition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target = 2;</code>
     *
     * @return Whether the target field is set.
     */
    @java.lang.Override
    public boolean hasTarget() {
      return target_ != null;
    }
    /**
     *
     *
     * <pre>
     * The end node of a transition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target = 2;</code>
     *
     * @return The target.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode getTarget() {
      return target_ == null
          ? com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.getDefaultInstance()
          : target_;
    }
    /**
     *
     *
     * <pre>
     * The end node of a transition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNodeOrBuilder
        getTargetOrBuilder() {
      return getTarget();
    }

    public static final int COVERED_FIELD_NUMBER = 3;
    private boolean covered_;
    /**
     *
     *
     * <pre>
     * Whether or not the transition is covered by at least one of the
     * agent's test cases.
     * </pre>
     *
     * <code>bool covered = 3;</code>
     *
     * @return The covered.
     */
    @java.lang.Override
    public boolean getCovered() {
      return covered_;
    }

    public static final int TRANSITION_ROUTE_FIELD_NUMBER = 5;
    /**
     *
     *
     * <pre>
     * Intent route or condition route.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionRoute transition_route = 5;</code>
     *
     * @return Whether the transitionRoute field is set.
     */
    @java.lang.Override
    public boolean hasTransitionRoute() {
      return detailCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Intent route or condition route.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionRoute transition_route = 5;</code>
     *
     * @return The transitionRoute.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionRoute getTransitionRoute() {
      if (detailCase_ == 5) {
        return (com.google.cloud.dialogflow.cx.v3.TransitionRoute) detail_;
      }
      return com.google.cloud.dialogflow.cx.v3.TransitionRoute.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Intent route or condition route.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TransitionRoute transition_route = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder
        getTransitionRouteOrBuilder() {
      if (detailCase_ == 5) {
        return (com.google.cloud.dialogflow.cx.v3.TransitionRoute) detail_;
      }
      return com.google.cloud.dialogflow.cx.v3.TransitionRoute.getDefaultInstance();
    }

    public static final int EVENT_HANDLER_FIELD_NUMBER = 6;
    /**
     *
     *
     * <pre>
     * Event handler.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.EventHandler event_handler = 6;</code>
     *
     * @return Whether the eventHandler field is set.
     */
    @java.lang.Override
    public boolean hasEventHandler() {
      return detailCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Event handler.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.EventHandler event_handler = 6;</code>
     *
     * @return The eventHandler.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.EventHandler getEventHandler() {
      if (detailCase_ == 6) {
        return (com.google.cloud.dialogflow.cx.v3.EventHandler) detail_;
      }
      return com.google.cloud.dialogflow.cx.v3.EventHandler.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Event handler.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.EventHandler event_handler = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.EventHandlerOrBuilder getEventHandlerOrBuilder() {
      if (detailCase_ == 6) {
        return (com.google.cloud.dialogflow.cx.v3.EventHandler) detail_;
      }
      return com.google.cloud.dialogflow.cx.v3.EventHandler.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (source_ != null) {
        output.writeMessage(1, getSource());
      }
      if (target_ != null) {
        output.writeMessage(2, getTarget());
      }
      if (covered_ != false) {
        output.writeBool(3, covered_);
      }
      if (index_ != 0) {
        output.writeInt32(4, index_);
      }
      if (detailCase_ == 5) {
        output.writeMessage(5, (com.google.cloud.dialogflow.cx.v3.TransitionRoute) detail_);
      }
      if (detailCase_ == 6) {
        output.writeMessage(6, (com.google.cloud.dialogflow.cx.v3.EventHandler) detail_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (source_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSource());
      }
      if (target_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTarget());
      }
      if (covered_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, covered_);
      }
      if (index_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, index_);
      }
      if (detailCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, (com.google.cloud.dialogflow.cx.v3.TransitionRoute) detail_);
      }
      if (detailCase_ == 6) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6, (com.google.cloud.dialogflow.cx.v3.EventHandler) detail_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition other =
          (com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition) obj;

      if (hasSource() != other.hasSource()) return false;
      if (hasSource()) {
        if (!getSource().equals(other.getSource())) return false;
      }
      if (getIndex() != other.getIndex()) return false;
      if (hasTarget() != other.hasTarget()) return false;
      if (hasTarget()) {
        if (!getTarget().equals(other.getTarget())) return false;
      }
      if (getCovered() != other.getCovered()) return false;
      if (!getDetailCase().equals(other.getDetailCase())) return false;
      switch (detailCase_) {
        case 5:
          if (!getTransitionRoute().equals(other.getTransitionRoute())) return false;
          break;
        case 6:
          if (!getEventHandler().equals(other.getEventHandler())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSource()) {
        hash = (37 * hash) + SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getSource().hashCode();
      }
      hash = (37 * hash) + INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getIndex();
      if (hasTarget()) {
        hash = (37 * hash) + TARGET_FIELD_NUMBER;
        hash = (53 * hash) + getTarget().hashCode();
      }
      hash = (37 * hash) + COVERED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCovered());
      switch (detailCase_) {
        case 5:
          hash = (37 * hash) + TRANSITION_ROUTE_FIELD_NUMBER;
          hash = (53 * hash) + getTransitionRoute().hashCode();
          break;
        case 6:
          hash = (37 * hash) + EVENT_HANDLER_FIELD_NUMBER;
          hash = (53 * hash) + getEventHandler().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A transition in a page.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition)
        com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3_TransitionCoverage_Transition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3_TransitionCoverage_Transition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.class,
                com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (sourceBuilder_ == null) {
          source_ = null;
        } else {
          source_ = null;
          sourceBuilder_ = null;
        }
        index_ = 0;

        if (targetBuilder_ == null) {
          target_ = null;
        } else {
          target_ = null;
          targetBuilder_ = null;
        }
        covered_ = false;

        if (transitionRouteBuilder_ != null) {
          transitionRouteBuilder_.clear();
        }
        if (eventHandlerBuilder_ != null) {
          eventHandlerBuilder_.clear();
        }
        detailCase_ = 0;
        detail_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3_TransitionCoverage_Transition_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition build() {
        com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition buildPartial() {
        com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition result =
            new com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition(this);
        if (sourceBuilder_ == null) {
          result.source_ = source_;
        } else {
          result.source_ = sourceBuilder_.build();
        }
        result.index_ = index_;
        if (targetBuilder_ == null) {
          result.target_ = target_;
        } else {
          result.target_ = targetBuilder_.build();
        }
        result.covered_ = covered_;
        if (detailCase_ == 5) {
          if (transitionRouteBuilder_ == null) {
            result.detail_ = detail_;
          } else {
            result.detail_ = transitionRouteBuilder_.build();
          }
        }
        if (detailCase_ == 6) {
          if (eventHandlerBuilder_ == null) {
            result.detail_ = detail_;
          } else {
            result.detail_ = eventHandlerBuilder_.build();
          }
        }
        result.detailCase_ = detailCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.getDefaultInstance())
          return this;
        if (other.hasSource()) {
          mergeSource(other.getSource());
        }
        if (other.getIndex() != 0) {
          setIndex(other.getIndex());
        }
        if (other.hasTarget()) {
          mergeTarget(other.getTarget());
        }
        if (other.getCovered() != false) {
          setCovered(other.getCovered());
        }
        switch (other.getDetailCase()) {
          case TRANSITION_ROUTE:
            {
              mergeTransitionRoute(other.getTransitionRoute());
              break;
            }
          case EVENT_HANDLER:
            {
              mergeEventHandler(other.getEventHandler());
              break;
            }
          case DETAIL_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getSourceFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getTargetFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              case 24:
                {
                  covered_ = input.readBool();

                  break;
                } // case 24
              case 32:
                {
                  index_ = input.readInt32();

                  break;
                } // case 32
              case 42:
                {
                  input.readMessage(
                      getTransitionRouteFieldBuilder().getBuilder(), extensionRegistry);
                  detailCase_ = 5;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getEventHandlerFieldBuilder().getBuilder(), extensionRegistry);
                  detailCase_ = 6;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int detailCase_ = 0;
      private java.lang.Object detail_;

      public DetailCase getDetailCase() {
        return DetailCase.forNumber(detailCase_);
      }

      public Builder clearDetail() {
        detailCase_ = 0;
        detail_ = null;
        onChanged();
        return this;
      }

      private com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode,
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.Builder,
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNodeOrBuilder>
          sourceBuilder_;
      /**
       *
       *
       * <pre>
       * The start node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source = 1;</code>
       *
       * @return Whether the source field is set.
       */
      public boolean hasSource() {
        return sourceBuilder_ != null || source_ != null;
      }
      /**
       *
       *
       * <pre>
       * The start node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source = 1;</code>
       *
       * @return The source.
       */
      public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode getSource() {
        if (sourceBuilder_ == null) {
          return source_ == null
              ? com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode
                  .getDefaultInstance()
              : source_;
        } else {
          return sourceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The start node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source = 1;</code>
       */
      public Builder setSource(
          com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode value) {
        if (sourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          sourceBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The start node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source = 1;</code>
       */
      public Builder setSource(
          com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.Builder
              builderForValue) {
        if (sourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          sourceBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The start node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source = 1;</code>
       */
      public Builder mergeSource(
          com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode value) {
        if (sourceBuilder_ == null) {
          if (source_ != null) {
            source_ =
                com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.newBuilder(
                        source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          sourceBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The start node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source = 1;</code>
       */
      public Builder clearSource() {
        if (sourceBuilder_ == null) {
          source_ = null;
          onChanged();
        } else {
          source_ = null;
          sourceBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The start node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source = 1;</code>
       */
      public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.Builder
          getSourceBuilder() {

        onChanged();
        return getSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The start node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source = 1;</code>
       */
      public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNodeOrBuilder
          getSourceOrBuilder() {
        if (sourceBuilder_ != null) {
          return sourceBuilder_.getMessageOrBuilder();
        } else {
          return source_ == null
              ? com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode
                  .getDefaultInstance()
              : source_;
        }
      }
      /**
       *
       *
       * <pre>
       * The start node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode source = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode,
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.Builder,
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNodeOrBuilder>
          getSourceFieldBuilder() {
        if (sourceBuilder_ == null) {
          sourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode,
                  com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.Builder,
                  com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNodeOrBuilder>(
                  getSource(), getParentForChildren(), isClean());
          source_ = null;
        }
        return sourceBuilder_;
      }

      private int index_;
      /**
       *
       *
       * <pre>
       * The index of a transition in the transition list. Starting from 0.
       * </pre>
       *
       * <code>int32 index = 4;</code>
       *
       * @return The index.
       */
      @java.lang.Override
      public int getIndex() {
        return index_;
      }
      /**
       *
       *
       * <pre>
       * The index of a transition in the transition list. Starting from 0.
       * </pre>
       *
       * <code>int32 index = 4;</code>
       *
       * @param value The index to set.
       * @return This builder for chaining.
       */
      public Builder setIndex(int value) {

        index_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The index of a transition in the transition list. Starting from 0.
       * </pre>
       *
       * <code>int32 index = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIndex() {

        index_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode,
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.Builder,
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNodeOrBuilder>
          targetBuilder_;
      /**
       *
       *
       * <pre>
       * The end node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target = 2;</code>
       *
       * @return Whether the target field is set.
       */
      public boolean hasTarget() {
        return targetBuilder_ != null || target_ != null;
      }
      /**
       *
       *
       * <pre>
       * The end node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target = 2;</code>
       *
       * @return The target.
       */
      public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode getTarget() {
        if (targetBuilder_ == null) {
          return target_ == null
              ? com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode
                  .getDefaultInstance()
              : target_;
        } else {
          return targetBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The end node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target = 2;</code>
       */
      public Builder setTarget(
          com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode value) {
        if (targetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          target_ = value;
          onChanged();
        } else {
          targetBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The end node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target = 2;</code>
       */
      public Builder setTarget(
          com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.Builder
              builderForValue) {
        if (targetBuilder_ == null) {
          target_ = builderForValue.build();
          onChanged();
        } else {
          targetBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The end node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target = 2;</code>
       */
      public Builder mergeTarget(
          com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode value) {
        if (targetBuilder_ == null) {
          if (target_ != null) {
            target_ =
                com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.newBuilder(
                        target_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            target_ = value;
          }
          onChanged();
        } else {
          targetBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The end node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target = 2;</code>
       */
      public Builder clearTarget() {
        if (targetBuilder_ == null) {
          target_ = null;
          onChanged();
        } else {
          target_ = null;
          targetBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The end node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.Builder
          getTargetBuilder() {

        onChanged();
        return getTargetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The end node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNodeOrBuilder
          getTargetOrBuilder() {
        if (targetBuilder_ != null) {
          return targetBuilder_.getMessageOrBuilder();
        } else {
          return target_ == null
              ? com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode
                  .getDefaultInstance()
              : target_;
        }
      }
      /**
       *
       *
       * <pre>
       * The end node of a transition.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode target = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode,
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.Builder,
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNodeOrBuilder>
          getTargetFieldBuilder() {
        if (targetBuilder_ == null) {
          targetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode,
                  com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNode.Builder,
                  com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionNodeOrBuilder>(
                  getTarget(), getParentForChildren(), isClean());
          target_ = null;
        }
        return targetBuilder_;
      }

      private boolean covered_;
      /**
       *
       *
       * <pre>
       * Whether or not the transition is covered by at least one of the
       * agent's test cases.
       * </pre>
       *
       * <code>bool covered = 3;</code>
       *
       * @return The covered.
       */
      @java.lang.Override
      public boolean getCovered() {
        return covered_;
      }
      /**
       *
       *
       * <pre>
       * Whether or not the transition is covered by at least one of the
       * agent's test cases.
       * </pre>
       *
       * <code>bool covered = 3;</code>
       *
       * @param value The covered to set.
       * @return This builder for chaining.
       */
      public Builder setCovered(boolean value) {

        covered_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether or not the transition is covered by at least one of the
       * agent's test cases.
       * </pre>
       *
       * <code>bool covered = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCovered() {

        covered_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.TransitionRoute,
              com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder,
              com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder>
          transitionRouteBuilder_;
      /**
       *
       *
       * <pre>
       * Intent route or condition route.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionRoute transition_route = 5;</code>
       *
       * @return Whether the transitionRoute field is set.
       */
      @java.lang.Override
      public boolean hasTransitionRoute() {
        return detailCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * Intent route or condition route.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionRoute transition_route = 5;</code>
       *
       * @return The transitionRoute.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.TransitionRoute getTransitionRoute() {
        if (transitionRouteBuilder_ == null) {
          if (detailCase_ == 5) {
            return (com.google.cloud.dialogflow.cx.v3.TransitionRoute) detail_;
          }
          return com.google.cloud.dialogflow.cx.v3.TransitionRoute.getDefaultInstance();
        } else {
          if (detailCase_ == 5) {
            return transitionRouteBuilder_.getMessage();
          }
          return com.google.cloud.dialogflow.cx.v3.TransitionRoute.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Intent route or condition route.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionRoute transition_route = 5;</code>
       */
      public Builder setTransitionRoute(com.google.cloud.dialogflow.cx.v3.TransitionRoute value) {
        if (transitionRouteBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          detail_ = value;
          onChanged();
        } else {
          transitionRouteBuilder_.setMessage(value);
        }
        detailCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Intent route or condition route.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionRoute transition_route = 5;</code>
       */
      public Builder setTransitionRoute(
          com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder builderForValue) {
        if (transitionRouteBuilder_ == null) {
          detail_ = builderForValue.build();
          onChanged();
        } else {
          transitionRouteBuilder_.setMessage(builderForValue.build());
        }
        detailCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Intent route or condition route.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionRoute transition_route = 5;</code>
       */
      public Builder mergeTransitionRoute(com.google.cloud.dialogflow.cx.v3.TransitionRoute value) {
        if (transitionRouteBuilder_ == null) {
          if (detailCase_ == 5
              && detail_
                  != com.google.cloud.dialogflow.cx.v3.TransitionRoute.getDefaultInstance()) {
            detail_ =
                com.google.cloud.dialogflow.cx.v3.TransitionRoute.newBuilder(
                        (com.google.cloud.dialogflow.cx.v3.TransitionRoute) detail_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            detail_ = value;
          }
          onChanged();
        } else {
          if (detailCase_ == 5) {
            transitionRouteBuilder_.mergeFrom(value);
          } else {
            transitionRouteBuilder_.setMessage(value);
          }
        }
        detailCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Intent route or condition route.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionRoute transition_route = 5;</code>
       */
      public Builder clearTransitionRoute() {
        if (transitionRouteBuilder_ == null) {
          if (detailCase_ == 5) {
            detailCase_ = 0;
            detail_ = null;
            onChanged();
          }
        } else {
          if (detailCase_ == 5) {
            detailCase_ = 0;
            detail_ = null;
          }
          transitionRouteBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Intent route or condition route.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionRoute transition_route = 5;</code>
       */
      public com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder getTransitionRouteBuilder() {
        return getTransitionRouteFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Intent route or condition route.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionRoute transition_route = 5;</code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder
          getTransitionRouteOrBuilder() {
        if ((detailCase_ == 5) && (transitionRouteBuilder_ != null)) {
          return transitionRouteBuilder_.getMessageOrBuilder();
        } else {
          if (detailCase_ == 5) {
            return (com.google.cloud.dialogflow.cx.v3.TransitionRoute) detail_;
          }
          return com.google.cloud.dialogflow.cx.v3.TransitionRoute.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Intent route or condition route.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.TransitionRoute transition_route = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.TransitionRoute,
              com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder,
              com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder>
          getTransitionRouteFieldBuilder() {
        if (transitionRouteBuilder_ == null) {
          if (!(detailCase_ == 5)) {
            detail_ = com.google.cloud.dialogflow.cx.v3.TransitionRoute.getDefaultInstance();
          }
          transitionRouteBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.TransitionRoute,
                  com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder,
                  com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder>(
                  (com.google.cloud.dialogflow.cx.v3.TransitionRoute) detail_,
                  getParentForChildren(),
                  isClean());
          detail_ = null;
        }
        detailCase_ = 5;
        onChanged();
        ;
        return transitionRouteBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.EventHandler,
              com.google.cloud.dialogflow.cx.v3.EventHandler.Builder,
              com.google.cloud.dialogflow.cx.v3.EventHandlerOrBuilder>
          eventHandlerBuilder_;
      /**
       *
       *
       * <pre>
       * Event handler.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.EventHandler event_handler = 6;</code>
       *
       * @return Whether the eventHandler field is set.
       */
      @java.lang.Override
      public boolean hasEventHandler() {
        return detailCase_ == 6;
      }
      /**
       *
       *
       * <pre>
       * Event handler.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.EventHandler event_handler = 6;</code>
       *
       * @return The eventHandler.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.EventHandler getEventHandler() {
        if (eventHandlerBuilder_ == null) {
          if (detailCase_ == 6) {
            return (com.google.cloud.dialogflow.cx.v3.EventHandler) detail_;
          }
          return com.google.cloud.dialogflow.cx.v3.EventHandler.getDefaultInstance();
        } else {
          if (detailCase_ == 6) {
            return eventHandlerBuilder_.getMessage();
          }
          return com.google.cloud.dialogflow.cx.v3.EventHandler.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Event handler.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.EventHandler event_handler = 6;</code>
       */
      public Builder setEventHandler(com.google.cloud.dialogflow.cx.v3.EventHandler value) {
        if (eventHandlerBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          detail_ = value;
          onChanged();
        } else {
          eventHandlerBuilder_.setMessage(value);
        }
        detailCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Event handler.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.EventHandler event_handler = 6;</code>
       */
      public Builder setEventHandler(
          com.google.cloud.dialogflow.cx.v3.EventHandler.Builder builderForValue) {
        if (eventHandlerBuilder_ == null) {
          detail_ = builderForValue.build();
          onChanged();
        } else {
          eventHandlerBuilder_.setMessage(builderForValue.build());
        }
        detailCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Event handler.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.EventHandler event_handler = 6;</code>
       */
      public Builder mergeEventHandler(com.google.cloud.dialogflow.cx.v3.EventHandler value) {
        if (eventHandlerBuilder_ == null) {
          if (detailCase_ == 6
              && detail_ != com.google.cloud.dialogflow.cx.v3.EventHandler.getDefaultInstance()) {
            detail_ =
                com.google.cloud.dialogflow.cx.v3.EventHandler.newBuilder(
                        (com.google.cloud.dialogflow.cx.v3.EventHandler) detail_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            detail_ = value;
          }
          onChanged();
        } else {
          if (detailCase_ == 6) {
            eventHandlerBuilder_.mergeFrom(value);
          } else {
            eventHandlerBuilder_.setMessage(value);
          }
        }
        detailCase_ = 6;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Event handler.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.EventHandler event_handler = 6;</code>
       */
      public Builder clearEventHandler() {
        if (eventHandlerBuilder_ == null) {
          if (detailCase_ == 6) {
            detailCase_ = 0;
            detail_ = null;
            onChanged();
          }
        } else {
          if (detailCase_ == 6) {
            detailCase_ = 0;
            detail_ = null;
          }
          eventHandlerBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Event handler.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.EventHandler event_handler = 6;</code>
       */
      public com.google.cloud.dialogflow.cx.v3.EventHandler.Builder getEventHandlerBuilder() {
        return getEventHandlerFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Event handler.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.EventHandler event_handler = 6;</code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.EventHandlerOrBuilder getEventHandlerOrBuilder() {
        if ((detailCase_ == 6) && (eventHandlerBuilder_ != null)) {
          return eventHandlerBuilder_.getMessageOrBuilder();
        } else {
          if (detailCase_ == 6) {
            return (com.google.cloud.dialogflow.cx.v3.EventHandler) detail_;
          }
          return com.google.cloud.dialogflow.cx.v3.EventHandler.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Event handler.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.EventHandler event_handler = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.EventHandler,
              com.google.cloud.dialogflow.cx.v3.EventHandler.Builder,
              com.google.cloud.dialogflow.cx.v3.EventHandlerOrBuilder>
          getEventHandlerFieldBuilder() {
        if (eventHandlerBuilder_ == null) {
          if (!(detailCase_ == 6)) {
            detail_ = com.google.cloud.dialogflow.cx.v3.EventHandler.getDefaultInstance();
          }
          eventHandlerBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.EventHandler,
                  com.google.cloud.dialogflow.cx.v3.EventHandler.Builder,
                  com.google.cloud.dialogflow.cx.v3.EventHandlerOrBuilder>(
                  (com.google.cloud.dialogflow.cx.v3.EventHandler) detail_,
                  getParentForChildren(),
                  isClean());
          detail_ = null;
        }
        detailCase_ = 6;
        onChanged();
        ;
        return eventHandlerBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition)
    private static final com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition();
    }

    public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Transition> PARSER =
        new com.google.protobuf.AbstractParser<Transition>() {
          @java.lang.Override
          public Transition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Transition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Transition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int TRANSITIONS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition>
      transitions_;
  /**
   *
   *
   * <pre>
   * The list of Transitions present in the agent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition>
      getTransitionsList() {
    return transitions_;
  }
  /**
   *
   *
   * <pre>
   * The list of Transitions present in the agent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionOrBuilder>
      getTransitionsOrBuilderList() {
    return transitions_;
  }
  /**
   *
   *
   * <pre>
   * The list of Transitions present in the agent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
   * </code>
   */
  @java.lang.Override
  public int getTransitionsCount() {
    return transitions_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of Transitions present in the agent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition getTransitions(int index) {
    return transitions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of Transitions present in the agent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionOrBuilder
      getTransitionsOrBuilder(int index) {
    return transitions_.get(index);
  }

  public static final int COVERAGE_SCORE_FIELD_NUMBER = 2;
  private float coverageScore_;
  /**
   *
   *
   * <pre>
   * The percent of transitions in the agent that are covered.
   * </pre>
   *
   * <code>float coverage_score = 2;</code>
   *
   * @return The coverageScore.
   */
  @java.lang.Override
  public float getCoverageScore() {
    return coverageScore_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < transitions_.size(); i++) {
      output.writeMessage(1, transitions_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(coverageScore_) != 0) {
      output.writeFloat(2, coverageScore_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < transitions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, transitions_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(coverageScore_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, coverageScore_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.TransitionCoverage)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.TransitionCoverage other =
        (com.google.cloud.dialogflow.cx.v3.TransitionCoverage) obj;

    if (!getTransitionsList().equals(other.getTransitionsList())) return false;
    if (java.lang.Float.floatToIntBits(getCoverageScore())
        != java.lang.Float.floatToIntBits(other.getCoverageScore())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getTransitionsCount() > 0) {
      hash = (37 * hash) + TRANSITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getTransitionsList().hashCode();
    }
    hash = (37 * hash) + COVERAGE_SCORE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getCoverageScore());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.TransitionCoverage prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Transition coverage represents the percentage of all possible page
   * transitions (page-level transition routes and event handlers, excluding
   * transition route groups) present within any of a parent's test cases.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.TransitionCoverage}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.TransitionCoverage)
      com.google.cloud.dialogflow.cx.v3.TransitionCoverageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_TransitionCoverage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_TransitionCoverage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.class,
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.TransitionCoverage.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (transitionsBuilder_ == null) {
        transitions_ = java.util.Collections.emptyList();
      } else {
        transitions_ = null;
        transitionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      coverageScore_ = 0F;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_TransitionCoverage_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.TransitionCoverage.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage build() {
      com.google.cloud.dialogflow.cx.v3.TransitionCoverage result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage buildPartial() {
      com.google.cloud.dialogflow.cx.v3.TransitionCoverage result =
          new com.google.cloud.dialogflow.cx.v3.TransitionCoverage(this);
      int from_bitField0_ = bitField0_;
      if (transitionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          transitions_ = java.util.Collections.unmodifiableList(transitions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.transitions_ = transitions_;
      } else {
        result.transitions_ = transitionsBuilder_.build();
      }
      result.coverageScore_ = coverageScore_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.TransitionCoverage) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.TransitionCoverage) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.TransitionCoverage other) {
      if (other == com.google.cloud.dialogflow.cx.v3.TransitionCoverage.getDefaultInstance())
        return this;
      if (transitionsBuilder_ == null) {
        if (!other.transitions_.isEmpty()) {
          if (transitions_.isEmpty()) {
            transitions_ = other.transitions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTransitionsIsMutable();
            transitions_.addAll(other.transitions_);
          }
          onChanged();
        }
      } else {
        if (!other.transitions_.isEmpty()) {
          if (transitionsBuilder_.isEmpty()) {
            transitionsBuilder_.dispose();
            transitionsBuilder_ = null;
            transitions_ = other.transitions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            transitionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTransitionsFieldBuilder()
                    : null;
          } else {
            transitionsBuilder_.addAllMessages(other.transitions_);
          }
        }
      }
      if (other.getCoverageScore() != 0F) {
        setCoverageScore(other.getCoverageScore());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.parser(),
                        extensionRegistry);
                if (transitionsBuilder_ == null) {
                  ensureTransitionsIsMutable();
                  transitions_.add(m);
                } else {
                  transitionsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 21:
              {
                coverageScore_ = input.readFloat();

                break;
              } // case 21
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition>
        transitions_ = java.util.Collections.emptyList();

    private void ensureTransitionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        transitions_ =
            new java.util.ArrayList<
                com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition>(transitions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition,
            com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.Builder,
            com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionOrBuilder>
        transitionsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition>
        getTransitionsList() {
      if (transitionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(transitions_);
      } else {
        return transitionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public int getTransitionsCount() {
      if (transitionsBuilder_ == null) {
        return transitions_.size();
      } else {
        return transitionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition getTransitions(
        int index) {
      if (transitionsBuilder_ == null) {
        return transitions_.get(index);
      } else {
        return transitionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public Builder setTransitions(
        int index, com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition value) {
      if (transitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionsIsMutable();
        transitions_.set(index, value);
        onChanged();
      } else {
        transitionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public Builder setTransitions(
        int index,
        com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.Builder builderForValue) {
      if (transitionsBuilder_ == null) {
        ensureTransitionsIsMutable();
        transitions_.set(index, builderForValue.build());
        onChanged();
      } else {
        transitionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public Builder addTransitions(
        com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition value) {
      if (transitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionsIsMutable();
        transitions_.add(value);
        onChanged();
      } else {
        transitionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public Builder addTransitions(
        int index, com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition value) {
      if (transitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionsIsMutable();
        transitions_.add(index, value);
        onChanged();
      } else {
        transitionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public Builder addTransitions(
        com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.Builder builderForValue) {
      if (transitionsBuilder_ == null) {
        ensureTransitionsIsMutable();
        transitions_.add(builderForValue.build());
        onChanged();
      } else {
        transitionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public Builder addTransitions(
        int index,
        com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.Builder builderForValue) {
      if (transitionsBuilder_ == null) {
        ensureTransitionsIsMutable();
        transitions_.add(index, builderForValue.build());
        onChanged();
      } else {
        transitionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public Builder addAllTransitions(
        java.lang.Iterable<
                ? extends com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition>
            values) {
      if (transitionsBuilder_ == null) {
        ensureTransitionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, transitions_);
        onChanged();
      } else {
        transitionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public Builder clearTransitions() {
      if (transitionsBuilder_ == null) {
        transitions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        transitionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public Builder removeTransitions(int index) {
      if (transitionsBuilder_ == null) {
        ensureTransitionsIsMutable();
        transitions_.remove(index);
        onChanged();
      } else {
        transitionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.Builder
        getTransitionsBuilder(int index) {
      return getTransitionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionOrBuilder
        getTransitionsOrBuilder(int index) {
      if (transitionsBuilder_ == null) {
        return transitions_.get(index);
      } else {
        return transitionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionOrBuilder>
        getTransitionsOrBuilderList() {
      if (transitionsBuilder_ != null) {
        return transitionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(transitions_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.Builder
        addTransitionsBuilder() {
      return getTransitionsFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.Builder
        addTransitionsBuilder(int index) {
      return getTransitionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of Transitions present in the agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition transitions = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.Builder>
        getTransitionsBuilderList() {
      return getTransitionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition,
            com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.Builder,
            com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionOrBuilder>
        getTransitionsFieldBuilder() {
      if (transitionsBuilder_ == null) {
        transitionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition,
                com.google.cloud.dialogflow.cx.v3.TransitionCoverage.Transition.Builder,
                com.google.cloud.dialogflow.cx.v3.TransitionCoverage.TransitionOrBuilder>(
                transitions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        transitions_ = null;
      }
      return transitionsBuilder_;
    }

    private float coverageScore_;
    /**
     *
     *
     * <pre>
     * The percent of transitions in the agent that are covered.
     * </pre>
     *
     * <code>float coverage_score = 2;</code>
     *
     * @return The coverageScore.
     */
    @java.lang.Override
    public float getCoverageScore() {
      return coverageScore_;
    }
    /**
     *
     *
     * <pre>
     * The percent of transitions in the agent that are covered.
     * </pre>
     *
     * <code>float coverage_score = 2;</code>
     *
     * @param value The coverageScore to set.
     * @return This builder for chaining.
     */
    public Builder setCoverageScore(float value) {

      coverageScore_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The percent of transitions in the agent that are covered.
     * </pre>
     *
     * <code>float coverage_score = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCoverageScore() {

      coverageScore_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.TransitionCoverage)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.TransitionCoverage)
  private static final com.google.cloud.dialogflow.cx.v3.TransitionCoverage DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.TransitionCoverage();
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionCoverage getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransitionCoverage> PARSER =
      new com.google.protobuf.AbstractParser<TransitionCoverage>() {
        @java.lang.Override
        public TransitionCoverage parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransitionCoverage> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransitionCoverage> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.TransitionCoverage getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
