/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/test_case.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Represents a result from running a test case in an agent environment.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.TestCaseResult}
 */
public final class TestCaseResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.TestCaseResult)
    TestCaseResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TestCaseResult.newBuilder() to construct.
  private TestCaseResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TestCaseResult() {
    name_ = "";
    environment_ = "";
    conversationTurns_ = java.util.Collections.emptyList();
    testResult_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TestCaseResult();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.TestCaseProto
        .internal_static_google_cloud_dialogflow_cx_v3_TestCaseResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.TestCaseProto
        .internal_static_google_cloud_dialogflow_cx_v3_TestCaseResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.TestCaseResult.class,
            com.google.cloud.dialogflow.cx.v3.TestCaseResult.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name for the test case result. Format:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;/testCases/
   * &lt;TestCase ID&gt;/results/&lt;TestCaseResult ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name for the test case result. Format:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;/testCases/
   * &lt;TestCase ID&gt;/results/&lt;TestCaseResult ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENVIRONMENT_FIELD_NUMBER = 2;
  private volatile java.lang.Object environment_;
  /**
   *
   *
   * <pre>
   * Environment where the test was run. If not set, it indicates the draft
   * environment.
   * </pre>
   *
   * <code>string environment = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The environment.
   */
  @java.lang.Override
  public java.lang.String getEnvironment() {
    java.lang.Object ref = environment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      environment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Environment where the test was run. If not set, it indicates the draft
   * environment.
   * </pre>
   *
   * <code>string environment = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for environment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEnvironmentBytes() {
    java.lang.Object ref = environment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      environment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONVERSATION_TURNS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.dialogflow.cx.v3.ConversationTurn> conversationTurns_;
  /**
   *
   *
   * <pre>
   * The conversation turns uttered during the test case replay in chronological
   * order.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.ConversationTurn>
      getConversationTurnsList() {
    return conversationTurns_;
  }
  /**
   *
   *
   * <pre>
   * The conversation turns uttered during the test case replay in chronological
   * order.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.ConversationTurnOrBuilder>
      getConversationTurnsOrBuilderList() {
    return conversationTurns_;
  }
  /**
   *
   *
   * <pre>
   * The conversation turns uttered during the test case replay in chronological
   * order.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
   */
  @java.lang.Override
  public int getConversationTurnsCount() {
    return conversationTurns_.size();
  }
  /**
   *
   *
   * <pre>
   * The conversation turns uttered during the test case replay in chronological
   * order.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ConversationTurn getConversationTurns(int index) {
    return conversationTurns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The conversation turns uttered during the test case replay in chronological
   * order.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ConversationTurnOrBuilder getConversationTurnsOrBuilder(
      int index) {
    return conversationTurns_.get(index);
  }

  public static final int TEST_RESULT_FIELD_NUMBER = 4;
  private int testResult_;
  /**
   *
   *
   * <pre>
   * Whether the test case passed in the agent environment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.TestResult test_result = 4;</code>
   *
   * @return The enum numeric value on the wire for testResult.
   */
  @java.lang.Override
  public int getTestResultValue() {
    return testResult_;
  }
  /**
   *
   *
   * <pre>
   * Whether the test case passed in the agent environment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.TestResult test_result = 4;</code>
   *
   * @return The testResult.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.TestResult getTestResult() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.cx.v3.TestResult result =
        com.google.cloud.dialogflow.cx.v3.TestResult.valueOf(testResult_);
    return result == null ? com.google.cloud.dialogflow.cx.v3.TestResult.UNRECOGNIZED : result;
  }

  public static final int TEST_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp testTime_;
  /**
   *
   *
   * <pre>
   * The time that the test was run.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp test_time = 5;</code>
   *
   * @return Whether the testTime field is set.
   */
  @java.lang.Override
  public boolean hasTestTime() {
    return testTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time that the test was run.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp test_time = 5;</code>
   *
   * @return The testTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getTestTime() {
    return testTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : testTime_;
  }
  /**
   *
   *
   * <pre>
   * The time that the test was run.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp test_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getTestTimeOrBuilder() {
    return getTestTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(environment_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, environment_);
    }
    for (int i = 0; i < conversationTurns_.size(); i++) {
      output.writeMessage(3, conversationTurns_.get(i));
    }
    if (testResult_
        != com.google.cloud.dialogflow.cx.v3.TestResult.TEST_RESULT_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, testResult_);
    }
    if (testTime_ != null) {
      output.writeMessage(5, getTestTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(environment_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, environment_);
    }
    for (int i = 0; i < conversationTurns_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, conversationTurns_.get(i));
    }
    if (testResult_
        != com.google.cloud.dialogflow.cx.v3.TestResult.TEST_RESULT_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, testResult_);
    }
    if (testTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getTestTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.TestCaseResult)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.TestCaseResult other =
        (com.google.cloud.dialogflow.cx.v3.TestCaseResult) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getEnvironment().equals(other.getEnvironment())) return false;
    if (!getConversationTurnsList().equals(other.getConversationTurnsList())) return false;
    if (testResult_ != other.testResult_) return false;
    if (hasTestTime() != other.hasTestTime()) return false;
    if (hasTestTime()) {
      if (!getTestTime().equals(other.getTestTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ENVIRONMENT_FIELD_NUMBER;
    hash = (53 * hash) + getEnvironment().hashCode();
    if (getConversationTurnsCount() > 0) {
      hash = (37 * hash) + CONVERSATION_TURNS_FIELD_NUMBER;
      hash = (53 * hash) + getConversationTurnsList().hashCode();
    }
    hash = (37 * hash) + TEST_RESULT_FIELD_NUMBER;
    hash = (53 * hash) + testResult_;
    if (hasTestTime()) {
      hash = (37 * hash) + TEST_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getTestTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.TestCaseResult parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.TestCaseResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TestCaseResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.TestCaseResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TestCaseResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.TestCaseResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TestCaseResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.TestCaseResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TestCaseResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.TestCaseResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TestCaseResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.TestCaseResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.TestCaseResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a result from running a test case in an agent environment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.TestCaseResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.TestCaseResult)
      com.google.cloud.dialogflow.cx.v3.TestCaseResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_TestCaseResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_TestCaseResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.TestCaseResult.class,
              com.google.cloud.dialogflow.cx.v3.TestCaseResult.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.TestCaseResult.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      environment_ = "";

      if (conversationTurnsBuilder_ == null) {
        conversationTurns_ = java.util.Collections.emptyList();
      } else {
        conversationTurns_ = null;
        conversationTurnsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      testResult_ = 0;

      if (testTimeBuilder_ == null) {
        testTime_ = null;
      } else {
        testTime_ = null;
        testTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_TestCaseResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TestCaseResult getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TestCaseResult build() {
      com.google.cloud.dialogflow.cx.v3.TestCaseResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TestCaseResult buildPartial() {
      com.google.cloud.dialogflow.cx.v3.TestCaseResult result =
          new com.google.cloud.dialogflow.cx.v3.TestCaseResult(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.environment_ = environment_;
      if (conversationTurnsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          conversationTurns_ = java.util.Collections.unmodifiableList(conversationTurns_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.conversationTurns_ = conversationTurns_;
      } else {
        result.conversationTurns_ = conversationTurnsBuilder_.build();
      }
      result.testResult_ = testResult_;
      if (testTimeBuilder_ == null) {
        result.testTime_ = testTime_;
      } else {
        result.testTime_ = testTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.TestCaseResult) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.TestCaseResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.TestCaseResult other) {
      if (other == com.google.cloud.dialogflow.cx.v3.TestCaseResult.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getEnvironment().isEmpty()) {
        environment_ = other.environment_;
        onChanged();
      }
      if (conversationTurnsBuilder_ == null) {
        if (!other.conversationTurns_.isEmpty()) {
          if (conversationTurns_.isEmpty()) {
            conversationTurns_ = other.conversationTurns_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureConversationTurnsIsMutable();
            conversationTurns_.addAll(other.conversationTurns_);
          }
          onChanged();
        }
      } else {
        if (!other.conversationTurns_.isEmpty()) {
          if (conversationTurnsBuilder_.isEmpty()) {
            conversationTurnsBuilder_.dispose();
            conversationTurnsBuilder_ = null;
            conversationTurns_ = other.conversationTurns_;
            bitField0_ = (bitField0_ & ~0x00000001);
            conversationTurnsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConversationTurnsFieldBuilder()
                    : null;
          } else {
            conversationTurnsBuilder_.addAllMessages(other.conversationTurns_);
          }
        }
      }
      if (other.testResult_ != 0) {
        setTestResultValue(other.getTestResultValue());
      }
      if (other.hasTestTime()) {
        mergeTestTime(other.getTestTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                environment_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                com.google.cloud.dialogflow.cx.v3.ConversationTurn m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.ConversationTurn.parser(),
                        extensionRegistry);
                if (conversationTurnsBuilder_ == null) {
                  ensureConversationTurnsIsMutable();
                  conversationTurns_.add(m);
                } else {
                  conversationTurnsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                testResult_ = input.readEnum();

                break;
              } // case 32
            case 42:
              {
                input.readMessage(getTestTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name for the test case result. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;/testCases/
     * &lt;TestCase ID&gt;/results/&lt;TestCaseResult ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name for the test case result. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;/testCases/
     * &lt;TestCase ID&gt;/results/&lt;TestCaseResult ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name for the test case result. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;/testCases/
     * &lt;TestCase ID&gt;/results/&lt;TestCaseResult ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name for the test case result. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;/testCases/
     * &lt;TestCase ID&gt;/results/&lt;TestCaseResult ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name for the test case result. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;/testCases/
     * &lt;TestCase ID&gt;/results/&lt;TestCaseResult ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object environment_ = "";
    /**
     *
     *
     * <pre>
     * Environment where the test was run. If not set, it indicates the draft
     * environment.
     * </pre>
     *
     * <code>string environment = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The environment.
     */
    public java.lang.String getEnvironment() {
      java.lang.Object ref = environment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        environment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Environment where the test was run. If not set, it indicates the draft
     * environment.
     * </pre>
     *
     * <code>string environment = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for environment.
     */
    public com.google.protobuf.ByteString getEnvironmentBytes() {
      java.lang.Object ref = environment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        environment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Environment where the test was run. If not set, it indicates the draft
     * environment.
     * </pre>
     *
     * <code>string environment = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The environment to set.
     * @return This builder for chaining.
     */
    public Builder setEnvironment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      environment_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Environment where the test was run. If not set, it indicates the draft
     * environment.
     * </pre>
     *
     * <code>string environment = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnvironment() {

      environment_ = getDefaultInstance().getEnvironment();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Environment where the test was run. If not set, it indicates the draft
     * environment.
     * </pre>
     *
     * <code>string environment = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for environment to set.
     * @return This builder for chaining.
     */
    public Builder setEnvironmentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      environment_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3.ConversationTurn> conversationTurns_ =
        java.util.Collections.emptyList();

    private void ensureConversationTurnsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        conversationTurns_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.ConversationTurn>(
                conversationTurns_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.ConversationTurn,
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.Builder,
            com.google.cloud.dialogflow.cx.v3.ConversationTurnOrBuilder>
        conversationTurnsBuilder_;

    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.ConversationTurn>
        getConversationTurnsList() {
      if (conversationTurnsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(conversationTurns_);
      } else {
        return conversationTurnsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public int getConversationTurnsCount() {
      if (conversationTurnsBuilder_ == null) {
        return conversationTurns_.size();
      } else {
        return conversationTurnsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ConversationTurn getConversationTurns(int index) {
      if (conversationTurnsBuilder_ == null) {
        return conversationTurns_.get(index);
      } else {
        return conversationTurnsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public Builder setConversationTurns(
        int index, com.google.cloud.dialogflow.cx.v3.ConversationTurn value) {
      if (conversationTurnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConversationTurnsIsMutable();
        conversationTurns_.set(index, value);
        onChanged();
      } else {
        conversationTurnsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public Builder setConversationTurns(
        int index, com.google.cloud.dialogflow.cx.v3.ConversationTurn.Builder builderForValue) {
      if (conversationTurnsBuilder_ == null) {
        ensureConversationTurnsIsMutable();
        conversationTurns_.set(index, builderForValue.build());
        onChanged();
      } else {
        conversationTurnsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public Builder addConversationTurns(com.google.cloud.dialogflow.cx.v3.ConversationTurn value) {
      if (conversationTurnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConversationTurnsIsMutable();
        conversationTurns_.add(value);
        onChanged();
      } else {
        conversationTurnsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public Builder addConversationTurns(
        int index, com.google.cloud.dialogflow.cx.v3.ConversationTurn value) {
      if (conversationTurnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConversationTurnsIsMutable();
        conversationTurns_.add(index, value);
        onChanged();
      } else {
        conversationTurnsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public Builder addConversationTurns(
        com.google.cloud.dialogflow.cx.v3.ConversationTurn.Builder builderForValue) {
      if (conversationTurnsBuilder_ == null) {
        ensureConversationTurnsIsMutable();
        conversationTurns_.add(builderForValue.build());
        onChanged();
      } else {
        conversationTurnsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public Builder addConversationTurns(
        int index, com.google.cloud.dialogflow.cx.v3.ConversationTurn.Builder builderForValue) {
      if (conversationTurnsBuilder_ == null) {
        ensureConversationTurnsIsMutable();
        conversationTurns_.add(index, builderForValue.build());
        onChanged();
      } else {
        conversationTurnsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public Builder addAllConversationTurns(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.ConversationTurn> values) {
      if (conversationTurnsBuilder_ == null) {
        ensureConversationTurnsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conversationTurns_);
        onChanged();
      } else {
        conversationTurnsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public Builder clearConversationTurns() {
      if (conversationTurnsBuilder_ == null) {
        conversationTurns_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        conversationTurnsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public Builder removeConversationTurns(int index) {
      if (conversationTurnsBuilder_ == null) {
        ensureConversationTurnsIsMutable();
        conversationTurns_.remove(index);
        onChanged();
      } else {
        conversationTurnsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ConversationTurn.Builder getConversationTurnsBuilder(
        int index) {
      return getConversationTurnsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ConversationTurnOrBuilder
        getConversationTurnsOrBuilder(int index) {
      if (conversationTurnsBuilder_ == null) {
        return conversationTurns_.get(index);
      } else {
        return conversationTurnsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.ConversationTurnOrBuilder>
        getConversationTurnsOrBuilderList() {
      if (conversationTurnsBuilder_ != null) {
        return conversationTurnsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(conversationTurns_);
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ConversationTurn.Builder
        addConversationTurnsBuilder() {
      return getConversationTurnsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3.ConversationTurn.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ConversationTurn.Builder addConversationTurnsBuilder(
        int index) {
      return getConversationTurnsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.cx.v3.ConversationTurn.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered during the test case replay in chronological
     * order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ConversationTurn conversation_turns = 3;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.ConversationTurn.Builder>
        getConversationTurnsBuilderList() {
      return getConversationTurnsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.ConversationTurn,
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.Builder,
            com.google.cloud.dialogflow.cx.v3.ConversationTurnOrBuilder>
        getConversationTurnsFieldBuilder() {
      if (conversationTurnsBuilder_ == null) {
        conversationTurnsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.ConversationTurn,
                com.google.cloud.dialogflow.cx.v3.ConversationTurn.Builder,
                com.google.cloud.dialogflow.cx.v3.ConversationTurnOrBuilder>(
                conversationTurns_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        conversationTurns_ = null;
      }
      return conversationTurnsBuilder_;
    }

    private int testResult_ = 0;
    /**
     *
     *
     * <pre>
     * Whether the test case passed in the agent environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TestResult test_result = 4;</code>
     *
     * @return The enum numeric value on the wire for testResult.
     */
    @java.lang.Override
    public int getTestResultValue() {
      return testResult_;
    }
    /**
     *
     *
     * <pre>
     * Whether the test case passed in the agent environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TestResult test_result = 4;</code>
     *
     * @param value The enum numeric value on the wire for testResult to set.
     * @return This builder for chaining.
     */
    public Builder setTestResultValue(int value) {

      testResult_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the test case passed in the agent environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TestResult test_result = 4;</code>
     *
     * @return The testResult.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TestResult getTestResult() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.cx.v3.TestResult result =
          com.google.cloud.dialogflow.cx.v3.TestResult.valueOf(testResult_);
      return result == null ? com.google.cloud.dialogflow.cx.v3.TestResult.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Whether the test case passed in the agent environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TestResult test_result = 4;</code>
     *
     * @param value The testResult to set.
     * @return This builder for chaining.
     */
    public Builder setTestResult(com.google.cloud.dialogflow.cx.v3.TestResult value) {
      if (value == null) {
        throw new NullPointerException();
      }

      testResult_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the test case passed in the agent environment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TestResult test_result = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTestResult() {

      testResult_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp testTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        testTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time that the test was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp test_time = 5;</code>
     *
     * @return Whether the testTime field is set.
     */
    public boolean hasTestTime() {
      return testTimeBuilder_ != null || testTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time that the test was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp test_time = 5;</code>
     *
     * @return The testTime.
     */
    public com.google.protobuf.Timestamp getTestTime() {
      if (testTimeBuilder_ == null) {
        return testTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : testTime_;
      } else {
        return testTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time that the test was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp test_time = 5;</code>
     */
    public Builder setTestTime(com.google.protobuf.Timestamp value) {
      if (testTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        testTime_ = value;
        onChanged();
      } else {
        testTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time that the test was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp test_time = 5;</code>
     */
    public Builder setTestTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (testTimeBuilder_ == null) {
        testTime_ = builderForValue.build();
        onChanged();
      } else {
        testTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time that the test was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp test_time = 5;</code>
     */
    public Builder mergeTestTime(com.google.protobuf.Timestamp value) {
      if (testTimeBuilder_ == null) {
        if (testTime_ != null) {
          testTime_ =
              com.google.protobuf.Timestamp.newBuilder(testTime_).mergeFrom(value).buildPartial();
        } else {
          testTime_ = value;
        }
        onChanged();
      } else {
        testTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time that the test was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp test_time = 5;</code>
     */
    public Builder clearTestTime() {
      if (testTimeBuilder_ == null) {
        testTime_ = null;
        onChanged();
      } else {
        testTime_ = null;
        testTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time that the test was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp test_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getTestTimeBuilder() {

      onChanged();
      return getTestTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time that the test was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp test_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getTestTimeOrBuilder() {
      if (testTimeBuilder_ != null) {
        return testTimeBuilder_.getMessageOrBuilder();
      } else {
        return testTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : testTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time that the test was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp test_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getTestTimeFieldBuilder() {
      if (testTimeBuilder_ == null) {
        testTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getTestTime(), getParentForChildren(), isClean());
        testTime_ = null;
      }
      return testTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.TestCaseResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.TestCaseResult)
  private static final com.google.cloud.dialogflow.cx.v3.TestCaseResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.TestCaseResult();
  }

  public static com.google.cloud.dialogflow.cx.v3.TestCaseResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TestCaseResult> PARSER =
      new com.google.protobuf.AbstractParser<TestCaseResult>() {
        @java.lang.Override
        public TestCaseResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TestCaseResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TestCaseResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.TestCaseResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
