/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/session_entity_type.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Session entity types are referred to as **User** entity types and are
 * entities that are built for an individual user such as favorites,
 * preferences, playlists, and so on.
 * You can redefine a session entity type at the session level to extend or
 * replace a [custom entity type][google.cloud.dialogflow.cx.v3.EntityType] at the user session level (we
 * refer to the entity types defined at the agent level as "custom entity
 * types").
 * Note: session entity types apply to all queries, regardless of the language.
 * For more information about entity types, see the [Dialogflow
 * documentation](https://cloud.google.com/dialogflow/docs/entities-overview).
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.SessionEntityType}
 */
public final class SessionEntityType extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.SessionEntityType)
    SessionEntityTypeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SessionEntityType.newBuilder() to construct.
  private SessionEntityType(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SessionEntityType() {
    name_ = "";
    entityOverrideMode_ = 0;
    entities_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SessionEntityType();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.SessionEntityTypeProto
        .internal_static_google_cloud_dialogflow_cx_v3_SessionEntityType_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.SessionEntityTypeProto
        .internal_static_google_cloud_dialogflow_cx_v3_SessionEntityType_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.SessionEntityType.class,
            com.google.cloud.dialogflow.cx.v3.SessionEntityType.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The types of modifications for the session entity type.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode}
   */
  public enum EntityOverrideMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. This value should be never used.
     * </pre>
     *
     * <code>ENTITY_OVERRIDE_MODE_UNSPECIFIED = 0;</code>
     */
    ENTITY_OVERRIDE_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The collection of session entities overrides the collection of entities
     * in the corresponding custom entity type.
     * </pre>
     *
     * <code>ENTITY_OVERRIDE_MODE_OVERRIDE = 1;</code>
     */
    ENTITY_OVERRIDE_MODE_OVERRIDE(1),
    /**
     *
     *
     * <pre>
     * The collection of session entities extends the collection of entities in
     * the corresponding custom entity type.
     * Note: Even in this override mode calls to `ListSessionEntityTypes`,
     * `GetSessionEntityType`, `CreateSessionEntityType` and
     * `UpdateSessionEntityType` only return the additional entities added in
     * this session entity type. If you want to get the supplemented list,
     * please call [EntityTypes.GetEntityType][google.cloud.dialogflow.cx.v3.EntityTypes.GetEntityType] on the custom entity type
     * and merge.
     * </pre>
     *
     * <code>ENTITY_OVERRIDE_MODE_SUPPLEMENT = 2;</code>
     */
    ENTITY_OVERRIDE_MODE_SUPPLEMENT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. This value should be never used.
     * </pre>
     *
     * <code>ENTITY_OVERRIDE_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int ENTITY_OVERRIDE_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The collection of session entities overrides the collection of entities
     * in the corresponding custom entity type.
     * </pre>
     *
     * <code>ENTITY_OVERRIDE_MODE_OVERRIDE = 1;</code>
     */
    public static final int ENTITY_OVERRIDE_MODE_OVERRIDE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The collection of session entities extends the collection of entities in
     * the corresponding custom entity type.
     * Note: Even in this override mode calls to `ListSessionEntityTypes`,
     * `GetSessionEntityType`, `CreateSessionEntityType` and
     * `UpdateSessionEntityType` only return the additional entities added in
     * this session entity type. If you want to get the supplemented list,
     * please call [EntityTypes.GetEntityType][google.cloud.dialogflow.cx.v3.EntityTypes.GetEntityType] on the custom entity type
     * and merge.
     * </pre>
     *
     * <code>ENTITY_OVERRIDE_MODE_SUPPLEMENT = 2;</code>
     */
    public static final int ENTITY_OVERRIDE_MODE_SUPPLEMENT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EntityOverrideMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EntityOverrideMode forNumber(int value) {
      switch (value) {
        case 0:
          return ENTITY_OVERRIDE_MODE_UNSPECIFIED;
        case 1:
          return ENTITY_OVERRIDE_MODE_OVERRIDE;
        case 2:
          return ENTITY_OVERRIDE_MODE_SUPPLEMENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EntityOverrideMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EntityOverrideMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<EntityOverrideMode>() {
              public EntityOverrideMode findValueByNumber(int number) {
                return EntityOverrideMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SessionEntityType.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final EntityOverrideMode[] VALUES = values();

    public static EntityOverrideMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EntityOverrideMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. The unique identifier of the session entity type.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/agents/&lt;Agent ID&gt;/sessions/&lt;Session ID&gt;/entityTypes/&lt;Entity Type
   * ID&gt;` or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/environments/&lt;Environment ID&gt;/sessions/&lt;Session ID&gt;/entityTypes/&lt;Entity
   * Type ID&gt;`. If `Environment ID` is not specified, we assume default 'draft'
   * environment.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The unique identifier of the session entity type.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/agents/&lt;Agent ID&gt;/sessions/&lt;Session ID&gt;/entityTypes/&lt;Entity Type
   * ID&gt;` or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/environments/&lt;Environment ID&gt;/sessions/&lt;Session ID&gt;/entityTypes/&lt;Entity
   * Type ID&gt;`. If `Environment ID` is not specified, we assume default 'draft'
   * environment.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITY_OVERRIDE_MODE_FIELD_NUMBER = 3;
  private int entityOverrideMode_;
  /**
   *
   *
   * <pre>
   * Required. Indicates whether the additional data should override or supplement the
   * custom entity type definition.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode entity_override_mode = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for entityOverrideMode.
   */
  @java.lang.Override
  public int getEntityOverrideModeValue() {
    return entityOverrideMode_;
  }
  /**
   *
   *
   * <pre>
   * Required. Indicates whether the additional data should override or supplement the
   * custom entity type definition.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode entity_override_mode = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The entityOverrideMode.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode
      getEntityOverrideMode() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode result =
        com.google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode.valueOf(
            entityOverrideMode_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode.UNRECOGNIZED
        : result;
  }

  public static final int ENTITIES_FIELD_NUMBER = 4;
  private java.util.List<com.google.cloud.dialogflow.cx.v3.EntityType.Entity> entities_;
  /**
   *
   *
   * <pre>
   * Required. The collection of entities to override or supplement the custom entity
   * type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.EntityType.Entity> getEntitiesList() {
    return entities_;
  }
  /**
   *
   *
   * <pre>
   * Required. The collection of entities to override or supplement the custom entity
   * type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.EntityType.EntityOrBuilder>
      getEntitiesOrBuilderList() {
    return entities_;
  }
  /**
   *
   *
   * <pre>
   * Required. The collection of entities to override or supplement the custom entity
   * type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getEntitiesCount() {
    return entities_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The collection of entities to override or supplement the custom entity
   * type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.EntityType.Entity getEntities(int index) {
    return entities_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The collection of entities to override or supplement the custom entity
   * type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.EntityType.EntityOrBuilder getEntitiesOrBuilder(
      int index) {
    return entities_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (entityOverrideMode_
        != com.google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode
            .ENTITY_OVERRIDE_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, entityOverrideMode_);
    }
    for (int i = 0; i < entities_.size(); i++) {
      output.writeMessage(4, entities_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (entityOverrideMode_
        != com.google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode
            .ENTITY_OVERRIDE_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, entityOverrideMode_);
    }
    for (int i = 0; i < entities_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, entities_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.SessionEntityType)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.SessionEntityType other =
        (com.google.cloud.dialogflow.cx.v3.SessionEntityType) obj;

    if (!getName().equals(other.getName())) return false;
    if (entityOverrideMode_ != other.entityOverrideMode_) return false;
    if (!getEntitiesList().equals(other.getEntitiesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ENTITY_OVERRIDE_MODE_FIELD_NUMBER;
    hash = (53 * hash) + entityOverrideMode_;
    if (getEntitiesCount() > 0) {
      hash = (37 * hash) + ENTITIES_FIELD_NUMBER;
      hash = (53 * hash) + getEntitiesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.SessionEntityType parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.SessionEntityType parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.SessionEntityType parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.SessionEntityType parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.SessionEntityType parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.SessionEntityType parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.SessionEntityType parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.SessionEntityType parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.SessionEntityType parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.SessionEntityType parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.SessionEntityType parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.SessionEntityType parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.SessionEntityType prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Session entity types are referred to as **User** entity types and are
   * entities that are built for an individual user such as favorites,
   * preferences, playlists, and so on.
   * You can redefine a session entity type at the session level to extend or
   * replace a [custom entity type][google.cloud.dialogflow.cx.v3.EntityType] at the user session level (we
   * refer to the entity types defined at the agent level as "custom entity
   * types").
   * Note: session entity types apply to all queries, regardless of the language.
   * For more information about entity types, see the [Dialogflow
   * documentation](https://cloud.google.com/dialogflow/docs/entities-overview).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.SessionEntityType}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.SessionEntityType)
      com.google.cloud.dialogflow.cx.v3.SessionEntityTypeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SessionEntityTypeProto
          .internal_static_google_cloud_dialogflow_cx_v3_SessionEntityType_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.SessionEntityTypeProto
          .internal_static_google_cloud_dialogflow_cx_v3_SessionEntityType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.SessionEntityType.class,
              com.google.cloud.dialogflow.cx.v3.SessionEntityType.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.SessionEntityType.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      entityOverrideMode_ = 0;

      if (entitiesBuilder_ == null) {
        entities_ = java.util.Collections.emptyList();
      } else {
        entities_ = null;
        entitiesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.SessionEntityTypeProto
          .internal_static_google_cloud_dialogflow_cx_v3_SessionEntityType_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.SessionEntityType getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.SessionEntityType.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.SessionEntityType build() {
      com.google.cloud.dialogflow.cx.v3.SessionEntityType result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.SessionEntityType buildPartial() {
      com.google.cloud.dialogflow.cx.v3.SessionEntityType result =
          new com.google.cloud.dialogflow.cx.v3.SessionEntityType(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.entityOverrideMode_ = entityOverrideMode_;
      if (entitiesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          entities_ = java.util.Collections.unmodifiableList(entities_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.entities_ = entities_;
      } else {
        result.entities_ = entitiesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.SessionEntityType) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.SessionEntityType) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.SessionEntityType other) {
      if (other == com.google.cloud.dialogflow.cx.v3.SessionEntityType.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.entityOverrideMode_ != 0) {
        setEntityOverrideModeValue(other.getEntityOverrideModeValue());
      }
      if (entitiesBuilder_ == null) {
        if (!other.entities_.isEmpty()) {
          if (entities_.isEmpty()) {
            entities_ = other.entities_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureEntitiesIsMutable();
            entities_.addAll(other.entities_);
          }
          onChanged();
        }
      } else {
        if (!other.entities_.isEmpty()) {
          if (entitiesBuilder_.isEmpty()) {
            entitiesBuilder_.dispose();
            entitiesBuilder_ = null;
            entities_ = other.entities_;
            bitField0_ = (bitField0_ & ~0x00000001);
            entitiesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEntitiesFieldBuilder()
                    : null;
          } else {
            entitiesBuilder_.addAllMessages(other.entities_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 24:
              {
                entityOverrideMode_ = input.readEnum();

                break;
              } // case 24
            case 34:
              {
                com.google.cloud.dialogflow.cx.v3.EntityType.Entity m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.EntityType.Entity.parser(),
                        extensionRegistry);
                if (entitiesBuilder_ == null) {
                  ensureEntitiesIsMutable();
                  entities_.add(m);
                } else {
                  entitiesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the session entity type.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/sessions/&lt;Session ID&gt;/entityTypes/&lt;Entity Type
     * ID&gt;` or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/environments/&lt;Environment ID&gt;/sessions/&lt;Session ID&gt;/entityTypes/&lt;Entity
     * Type ID&gt;`. If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the session entity type.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/sessions/&lt;Session ID&gt;/entityTypes/&lt;Entity Type
     * ID&gt;` or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/environments/&lt;Environment ID&gt;/sessions/&lt;Session ID&gt;/entityTypes/&lt;Entity
     * Type ID&gt;`. If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the session entity type.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/sessions/&lt;Session ID&gt;/entityTypes/&lt;Entity Type
     * ID&gt;` or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/environments/&lt;Environment ID&gt;/sessions/&lt;Session ID&gt;/entityTypes/&lt;Entity
     * Type ID&gt;`. If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the session entity type.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/sessions/&lt;Session ID&gt;/entityTypes/&lt;Entity Type
     * ID&gt;` or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/environments/&lt;Environment ID&gt;/sessions/&lt;Session ID&gt;/entityTypes/&lt;Entity
     * Type ID&gt;`. If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the session entity type.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/sessions/&lt;Session ID&gt;/entityTypes/&lt;Entity Type
     * ID&gt;` or `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/environments/&lt;Environment ID&gt;/sessions/&lt;Session ID&gt;/entityTypes/&lt;Entity
     * Type ID&gt;`. If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private int entityOverrideMode_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Indicates whether the additional data should override or supplement the
     * custom entity type definition.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode entity_override_mode = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for entityOverrideMode.
     */
    @java.lang.Override
    public int getEntityOverrideModeValue() {
      return entityOverrideMode_;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates whether the additional data should override or supplement the
     * custom entity type definition.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode entity_override_mode = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for entityOverrideMode to set.
     * @return This builder for chaining.
     */
    public Builder setEntityOverrideModeValue(int value) {

      entityOverrideMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates whether the additional data should override or supplement the
     * custom entity type definition.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode entity_override_mode = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The entityOverrideMode.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode
        getEntityOverrideMode() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode result =
          com.google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode.valueOf(
              entityOverrideMode_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates whether the additional data should override or supplement the
     * custom entity type definition.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode entity_override_mode = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The entityOverrideMode to set.
     * @return This builder for chaining.
     */
    public Builder setEntityOverrideMode(
        com.google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode value) {
      if (value == null) {
        throw new NullPointerException();
      }

      entityOverrideMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates whether the additional data should override or supplement the
     * custom entity type definition.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SessionEntityType.EntityOverrideMode entity_override_mode = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityOverrideMode() {

      entityOverrideMode_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3.EntityType.Entity> entities_ =
        java.util.Collections.emptyList();

    private void ensureEntitiesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        entities_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.EntityType.Entity>(entities_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.EntityType.Entity,
            com.google.cloud.dialogflow.cx.v3.EntityType.Entity.Builder,
            com.google.cloud.dialogflow.cx.v3.EntityType.EntityOrBuilder>
        entitiesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.EntityType.Entity> getEntitiesList() {
      if (entitiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(entities_);
      } else {
        return entitiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getEntitiesCount() {
      if (entitiesBuilder_ == null) {
        return entities_.size();
      } else {
        return entitiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.EntityType.Entity getEntities(int index) {
      if (entitiesBuilder_ == null) {
        return entities_.get(index);
      } else {
        return entitiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setEntities(
        int index, com.google.cloud.dialogflow.cx.v3.EntityType.Entity value) {
      if (entitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntitiesIsMutable();
        entities_.set(index, value);
        onChanged();
      } else {
        entitiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setEntities(
        int index, com.google.cloud.dialogflow.cx.v3.EntityType.Entity.Builder builderForValue) {
      if (entitiesBuilder_ == null) {
        ensureEntitiesIsMutable();
        entities_.set(index, builderForValue.build());
        onChanged();
      } else {
        entitiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addEntities(com.google.cloud.dialogflow.cx.v3.EntityType.Entity value) {
      if (entitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntitiesIsMutable();
        entities_.add(value);
        onChanged();
      } else {
        entitiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addEntities(
        int index, com.google.cloud.dialogflow.cx.v3.EntityType.Entity value) {
      if (entitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntitiesIsMutable();
        entities_.add(index, value);
        onChanged();
      } else {
        entitiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addEntities(
        com.google.cloud.dialogflow.cx.v3.EntityType.Entity.Builder builderForValue) {
      if (entitiesBuilder_ == null) {
        ensureEntitiesIsMutable();
        entities_.add(builderForValue.build());
        onChanged();
      } else {
        entitiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addEntities(
        int index, com.google.cloud.dialogflow.cx.v3.EntityType.Entity.Builder builderForValue) {
      if (entitiesBuilder_ == null) {
        ensureEntitiesIsMutable();
        entities_.add(index, builderForValue.build());
        onChanged();
      } else {
        entitiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllEntities(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.EntityType.Entity> values) {
      if (entitiesBuilder_ == null) {
        ensureEntitiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entities_);
        onChanged();
      } else {
        entitiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearEntities() {
      if (entitiesBuilder_ == null) {
        entities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        entitiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeEntities(int index) {
      if (entitiesBuilder_ == null) {
        ensureEntitiesIsMutable();
        entities_.remove(index);
        onChanged();
      } else {
        entitiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.EntityType.Entity.Builder getEntitiesBuilder(
        int index) {
      return getEntitiesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.EntityType.EntityOrBuilder getEntitiesOrBuilder(
        int index) {
      if (entitiesBuilder_ == null) {
        return entities_.get(index);
      } else {
        return entitiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.EntityType.EntityOrBuilder>
        getEntitiesOrBuilderList() {
      if (entitiesBuilder_ != null) {
        return entitiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(entities_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.EntityType.Entity.Builder addEntitiesBuilder() {
      return getEntitiesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3.EntityType.Entity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.EntityType.Entity.Builder addEntitiesBuilder(
        int index) {
      return getEntitiesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.cx.v3.EntityType.Entity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The collection of entities to override or supplement the custom entity
     * type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.EntityType.Entity.Builder>
        getEntitiesBuilderList() {
      return getEntitiesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.EntityType.Entity,
            com.google.cloud.dialogflow.cx.v3.EntityType.Entity.Builder,
            com.google.cloud.dialogflow.cx.v3.EntityType.EntityOrBuilder>
        getEntitiesFieldBuilder() {
      if (entitiesBuilder_ == null) {
        entitiesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.EntityType.Entity,
                com.google.cloud.dialogflow.cx.v3.EntityType.Entity.Builder,
                com.google.cloud.dialogflow.cx.v3.EntityType.EntityOrBuilder>(
                entities_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        entities_ = null;
      }
      return entitiesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.SessionEntityType)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.SessionEntityType)
  private static final com.google.cloud.dialogflow.cx.v3.SessionEntityType DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.SessionEntityType();
  }

  public static com.google.cloud.dialogflow.cx.v3.SessionEntityType getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SessionEntityType> PARSER =
      new com.google.protobuf.AbstractParser<SessionEntityType>() {
        @java.lang.Override
        public SessionEntityType parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SessionEntityType> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SessionEntityType> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SessionEntityType getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
