/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/experiment.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * The configuration for auto rollout.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.RolloutConfig}
 */
public final class RolloutConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.RolloutConfig)
    RolloutConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RolloutConfig.newBuilder() to construct.
  private RolloutConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RolloutConfig() {
    rolloutSteps_ = java.util.Collections.emptyList();
    rolloutCondition_ = "";
    failureCondition_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RolloutConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.ExperimentProto
        .internal_static_google_cloud_dialogflow_cx_v3_RolloutConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.ExperimentProto
        .internal_static_google_cloud_dialogflow_cx_v3_RolloutConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.RolloutConfig.class,
            com.google.cloud.dialogflow.cx.v3.RolloutConfig.Builder.class);
  }

  public interface RolloutStepOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the rollout step;
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * The name of the rollout step;
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * The percentage of traffic allocated to the flow version of this rollout
     * step. (0%, 100%].
     * </pre>
     *
     * <code>int32 traffic_percent = 2;</code>
     *
     * @return The trafficPercent.
     */
    int getTrafficPercent();

    /**
     *
     *
     * <pre>
     * The minimum time that this step should last. Should be longer than 1
     * hour. If not set, the default minimum duration for each step will be 1
     * hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_duration = 3;</code>
     *
     * @return Whether the minDuration field is set.
     */
    boolean hasMinDuration();
    /**
     *
     *
     * <pre>
     * The minimum time that this step should last. Should be longer than 1
     * hour. If not set, the default minimum duration for each step will be 1
     * hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_duration = 3;</code>
     *
     * @return The minDuration.
     */
    com.google.protobuf.Duration getMinDuration();
    /**
     *
     *
     * <pre>
     * The minimum time that this step should last. Should be longer than 1
     * hour. If not set, the default minimum duration for each step will be 1
     * hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_duration = 3;</code>
     */
    com.google.protobuf.DurationOrBuilder getMinDurationOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A single rollout step with specified traffic allocation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep}
   */
  public static final class RolloutStep extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep)
      RolloutStepOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RolloutStep.newBuilder() to construct.
    private RolloutStep(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RolloutStep() {
      displayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RolloutStep();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_RolloutConfig_RolloutStep_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_RolloutConfig_RolloutStep_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.class,
              com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.Builder.class);
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object displayName_;
    /**
     *
     *
     * <pre>
     * The name of the rollout step;
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the rollout step;
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TRAFFIC_PERCENT_FIELD_NUMBER = 2;
    private int trafficPercent_;
    /**
     *
     *
     * <pre>
     * The percentage of traffic allocated to the flow version of this rollout
     * step. (0%, 100%].
     * </pre>
     *
     * <code>int32 traffic_percent = 2;</code>
     *
     * @return The trafficPercent.
     */
    @java.lang.Override
    public int getTrafficPercent() {
      return trafficPercent_;
    }

    public static final int MIN_DURATION_FIELD_NUMBER = 3;
    private com.google.protobuf.Duration minDuration_;
    /**
     *
     *
     * <pre>
     * The minimum time that this step should last. Should be longer than 1
     * hour. If not set, the default minimum duration for each step will be 1
     * hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_duration = 3;</code>
     *
     * @return Whether the minDuration field is set.
     */
    @java.lang.Override
    public boolean hasMinDuration() {
      return minDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * The minimum time that this step should last. Should be longer than 1
     * hour. If not set, the default minimum duration for each step will be 1
     * hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_duration = 3;</code>
     *
     * @return The minDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getMinDuration() {
      return minDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : minDuration_;
    }
    /**
     *
     *
     * <pre>
     * The minimum time that this step should last. Should be longer than 1
     * hour. If not set, the default minimum duration for each step will be 1
     * hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_duration = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getMinDurationOrBuilder() {
      return getMinDuration();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
      }
      if (trafficPercent_ != 0) {
        output.writeInt32(2, trafficPercent_);
      }
      if (minDuration_ != null) {
        output.writeMessage(3, getMinDuration());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
      }
      if (trafficPercent_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, trafficPercent_);
      }
      if (minDuration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMinDuration());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep other =
          (com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep) obj;

      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (getTrafficPercent() != other.getTrafficPercent()) return false;
      if (hasMinDuration() != other.hasMinDuration()) return false;
      if (hasMinDuration()) {
        if (!getMinDuration().equals(other.getMinDuration())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      hash = (37 * hash) + TRAFFIC_PERCENT_FIELD_NUMBER;
      hash = (53 * hash) + getTrafficPercent();
      if (hasMinDuration()) {
        hash = (37 * hash) + MIN_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getMinDuration().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A single rollout step with specified traffic allocation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep)
        com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStepOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_RolloutConfig_RolloutStep_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_RolloutConfig_RolloutStep_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.class,
                com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        displayName_ = "";

        trafficPercent_ = 0;

        if (minDurationBuilder_ == null) {
          minDuration_ = null;
        } else {
          minDuration_ = null;
          minDurationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_RolloutConfig_RolloutStep_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep build() {
        com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep buildPartial() {
        com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep result =
            new com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep(this);
        result.displayName_ = displayName_;
        result.trafficPercent_ = trafficPercent_;
        if (minDurationBuilder_ == null) {
          result.minDuration_ = minDuration_;
        } else {
          result.minDuration_ = minDurationBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.getDefaultInstance())
          return this;
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          onChanged();
        }
        if (other.getTrafficPercent() != 0) {
          setTrafficPercent(other.getTrafficPercent());
        }
        if (other.hasMinDuration()) {
          mergeMinDuration(other.getMinDuration());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  displayName_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 16:
                {
                  trafficPercent_ = input.readInt32();

                  break;
                } // case 16
              case 26:
                {
                  input.readMessage(getMinDurationFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * The name of the rollout step;
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the rollout step;
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the rollout step;
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        displayName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the rollout step;
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {

        displayName_ = getDefaultInstance().getDisplayName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the rollout step;
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        displayName_ = value;
        onChanged();
        return this;
      }

      private int trafficPercent_;
      /**
       *
       *
       * <pre>
       * The percentage of traffic allocated to the flow version of this rollout
       * step. (0%, 100%].
       * </pre>
       *
       * <code>int32 traffic_percent = 2;</code>
       *
       * @return The trafficPercent.
       */
      @java.lang.Override
      public int getTrafficPercent() {
        return trafficPercent_;
      }
      /**
       *
       *
       * <pre>
       * The percentage of traffic allocated to the flow version of this rollout
       * step. (0%, 100%].
       * </pre>
       *
       * <code>int32 traffic_percent = 2;</code>
       *
       * @param value The trafficPercent to set.
       * @return This builder for chaining.
       */
      public Builder setTrafficPercent(int value) {

        trafficPercent_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The percentage of traffic allocated to the flow version of this rollout
       * step. (0%, 100%].
       * </pre>
       *
       * <code>int32 traffic_percent = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTrafficPercent() {

        trafficPercent_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Duration minDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          minDurationBuilder_;
      /**
       *
       *
       * <pre>
       * The minimum time that this step should last. Should be longer than 1
       * hour. If not set, the default minimum duration for each step will be 1
       * hour.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3;</code>
       *
       * @return Whether the minDuration field is set.
       */
      public boolean hasMinDuration() {
        return minDurationBuilder_ != null || minDuration_ != null;
      }
      /**
       *
       *
       * <pre>
       * The minimum time that this step should last. Should be longer than 1
       * hour. If not set, the default minimum duration for each step will be 1
       * hour.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3;</code>
       *
       * @return The minDuration.
       */
      public com.google.protobuf.Duration getMinDuration() {
        if (minDurationBuilder_ == null) {
          return minDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : minDuration_;
        } else {
          return minDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The minimum time that this step should last. Should be longer than 1
       * hour. If not set, the default minimum duration for each step will be 1
       * hour.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3;</code>
       */
      public Builder setMinDuration(com.google.protobuf.Duration value) {
        if (minDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          minDuration_ = value;
          onChanged();
        } else {
          minDurationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The minimum time that this step should last. Should be longer than 1
       * hour. If not set, the default minimum duration for each step will be 1
       * hour.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3;</code>
       */
      public Builder setMinDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (minDurationBuilder_ == null) {
          minDuration_ = builderForValue.build();
          onChanged();
        } else {
          minDurationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The minimum time that this step should last. Should be longer than 1
       * hour. If not set, the default minimum duration for each step will be 1
       * hour.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3;</code>
       */
      public Builder mergeMinDuration(com.google.protobuf.Duration value) {
        if (minDurationBuilder_ == null) {
          if (minDuration_ != null) {
            minDuration_ =
                com.google.protobuf.Duration.newBuilder(minDuration_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            minDuration_ = value;
          }
          onChanged();
        } else {
          minDurationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The minimum time that this step should last. Should be longer than 1
       * hour. If not set, the default minimum duration for each step will be 1
       * hour.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3;</code>
       */
      public Builder clearMinDuration() {
        if (minDurationBuilder_ == null) {
          minDuration_ = null;
          onChanged();
        } else {
          minDuration_ = null;
          minDurationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The minimum time that this step should last. Should be longer than 1
       * hour. If not set, the default minimum duration for each step will be 1
       * hour.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3;</code>
       */
      public com.google.protobuf.Duration.Builder getMinDurationBuilder() {

        onChanged();
        return getMinDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The minimum time that this step should last. Should be longer than 1
       * hour. If not set, the default minimum duration for each step will be 1
       * hour.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3;</code>
       */
      public com.google.protobuf.DurationOrBuilder getMinDurationOrBuilder() {
        if (minDurationBuilder_ != null) {
          return minDurationBuilder_.getMessageOrBuilder();
        } else {
          return minDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : minDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * The minimum time that this step should last. Should be longer than 1
       * hour. If not set, the default minimum duration for each step will be 1
       * hour.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_duration = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getMinDurationFieldBuilder() {
        if (minDurationBuilder_ == null) {
          minDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getMinDuration(), getParentForChildren(), isClean());
          minDuration_ = null;
        }
        return minDurationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep)
    private static final com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep();
    }

    public static com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RolloutStep> PARSER =
        new com.google.protobuf.AbstractParser<RolloutStep>() {
          @java.lang.Override
          public RolloutStep parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RolloutStep> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RolloutStep> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ROLLOUT_STEPS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep> rolloutSteps_;
  /**
   *
   *
   * <pre>
   * Steps to roll out a flow version. Steps should be sorted by percentage in
   * ascending order.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep>
      getRolloutStepsList() {
    return rolloutSteps_;
  }
  /**
   *
   *
   * <pre>
   * Steps to roll out a flow version. Steps should be sorted by percentage in
   * ascending order.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStepOrBuilder>
      getRolloutStepsOrBuilderList() {
    return rolloutSteps_;
  }
  /**
   *
   *
   * <pre>
   * Steps to roll out a flow version. Steps should be sorted by percentage in
   * ascending order.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
   * </code>
   */
  @java.lang.Override
  public int getRolloutStepsCount() {
    return rolloutSteps_.size();
  }
  /**
   *
   *
   * <pre>
   * Steps to roll out a flow version. Steps should be sorted by percentage in
   * ascending order.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep getRolloutSteps(int index) {
    return rolloutSteps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Steps to roll out a flow version. Steps should be sorted by percentage in
   * ascending order.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStepOrBuilder
      getRolloutStepsOrBuilder(int index) {
    return rolloutSteps_.get(index);
  }

  public static final int ROLLOUT_CONDITION_FIELD_NUMBER = 2;
  private volatile java.lang.Object rolloutCondition_;
  /**
   *
   *
   * <pre>
   * The conditions that are used to evaluate the success of a rollout
   * step. If not specified, all rollout steps will proceed to the next one
   * unless failure conditions are met. E.g. "containment_rate &gt; 60% AND
   * callback_rate &lt; 20%". See the [conditions
   * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
   * </pre>
   *
   * <code>string rollout_condition = 2;</code>
   *
   * @return The rolloutCondition.
   */
  @java.lang.Override
  public java.lang.String getRolloutCondition() {
    java.lang.Object ref = rolloutCondition_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rolloutCondition_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The conditions that are used to evaluate the success of a rollout
   * step. If not specified, all rollout steps will proceed to the next one
   * unless failure conditions are met. E.g. "containment_rate &gt; 60% AND
   * callback_rate &lt; 20%". See the [conditions
   * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
   * </pre>
   *
   * <code>string rollout_condition = 2;</code>
   *
   * @return The bytes for rolloutCondition.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRolloutConditionBytes() {
    java.lang.Object ref = rolloutCondition_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rolloutCondition_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FAILURE_CONDITION_FIELD_NUMBER = 3;
  private volatile java.lang.Object failureCondition_;
  /**
   *
   *
   * <pre>
   * The conditions that are used to evaluate the failure of a rollout
   * step. If not specified, no rollout steps will fail. E.g. "containment_rate
   * &lt; 10% OR average_turn_count &lt; 3". See the [conditions
   * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
   * </pre>
   *
   * <code>string failure_condition = 3;</code>
   *
   * @return The failureCondition.
   */
  @java.lang.Override
  public java.lang.String getFailureCondition() {
    java.lang.Object ref = failureCondition_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      failureCondition_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The conditions that are used to evaluate the failure of a rollout
   * step. If not specified, no rollout steps will fail. E.g. "containment_rate
   * &lt; 10% OR average_turn_count &lt; 3". See the [conditions
   * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
   * </pre>
   *
   * <code>string failure_condition = 3;</code>
   *
   * @return The bytes for failureCondition.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFailureConditionBytes() {
    java.lang.Object ref = failureCondition_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      failureCondition_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < rolloutSteps_.size(); i++) {
      output.writeMessage(1, rolloutSteps_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rolloutCondition_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, rolloutCondition_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(failureCondition_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, failureCondition_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < rolloutSteps_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, rolloutSteps_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rolloutCondition_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, rolloutCondition_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(failureCondition_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, failureCondition_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.RolloutConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.RolloutConfig other =
        (com.google.cloud.dialogflow.cx.v3.RolloutConfig) obj;

    if (!getRolloutStepsList().equals(other.getRolloutStepsList())) return false;
    if (!getRolloutCondition().equals(other.getRolloutCondition())) return false;
    if (!getFailureCondition().equals(other.getFailureCondition())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getRolloutStepsCount() > 0) {
      hash = (37 * hash) + ROLLOUT_STEPS_FIELD_NUMBER;
      hash = (53 * hash) + getRolloutStepsList().hashCode();
    }
    hash = (37 * hash) + ROLLOUT_CONDITION_FIELD_NUMBER;
    hash = (53 * hash) + getRolloutCondition().hashCode();
    hash = (37 * hash) + FAILURE_CONDITION_FIELD_NUMBER;
    hash = (53 * hash) + getFailureCondition().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.RolloutConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.RolloutConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.RolloutConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.RolloutConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.RolloutConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.RolloutConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.RolloutConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.RolloutConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.RolloutConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.RolloutConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.RolloutConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.RolloutConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.RolloutConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The configuration for auto rollout.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.RolloutConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.RolloutConfig)
      com.google.cloud.dialogflow.cx.v3.RolloutConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_RolloutConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_RolloutConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.RolloutConfig.class,
              com.google.cloud.dialogflow.cx.v3.RolloutConfig.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.RolloutConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (rolloutStepsBuilder_ == null) {
        rolloutSteps_ = java.util.Collections.emptyList();
      } else {
        rolloutSteps_ = null;
        rolloutStepsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      rolloutCondition_ = "";

      failureCondition_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_RolloutConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.RolloutConfig getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.RolloutConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.RolloutConfig build() {
      com.google.cloud.dialogflow.cx.v3.RolloutConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.RolloutConfig buildPartial() {
      com.google.cloud.dialogflow.cx.v3.RolloutConfig result =
          new com.google.cloud.dialogflow.cx.v3.RolloutConfig(this);
      int from_bitField0_ = bitField0_;
      if (rolloutStepsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          rolloutSteps_ = java.util.Collections.unmodifiableList(rolloutSteps_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.rolloutSteps_ = rolloutSteps_;
      } else {
        result.rolloutSteps_ = rolloutStepsBuilder_.build();
      }
      result.rolloutCondition_ = rolloutCondition_;
      result.failureCondition_ = failureCondition_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.RolloutConfig) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.RolloutConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.RolloutConfig other) {
      if (other == com.google.cloud.dialogflow.cx.v3.RolloutConfig.getDefaultInstance())
        return this;
      if (rolloutStepsBuilder_ == null) {
        if (!other.rolloutSteps_.isEmpty()) {
          if (rolloutSteps_.isEmpty()) {
            rolloutSteps_ = other.rolloutSteps_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRolloutStepsIsMutable();
            rolloutSteps_.addAll(other.rolloutSteps_);
          }
          onChanged();
        }
      } else {
        if (!other.rolloutSteps_.isEmpty()) {
          if (rolloutStepsBuilder_.isEmpty()) {
            rolloutStepsBuilder_.dispose();
            rolloutStepsBuilder_ = null;
            rolloutSteps_ = other.rolloutSteps_;
            bitField0_ = (bitField0_ & ~0x00000001);
            rolloutStepsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRolloutStepsFieldBuilder()
                    : null;
          } else {
            rolloutStepsBuilder_.addAllMessages(other.rolloutSteps_);
          }
        }
      }
      if (!other.getRolloutCondition().isEmpty()) {
        rolloutCondition_ = other.rolloutCondition_;
        onChanged();
      }
      if (!other.getFailureCondition().isEmpty()) {
        failureCondition_ = other.failureCondition_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.parser(),
                        extensionRegistry);
                if (rolloutStepsBuilder_ == null) {
                  ensureRolloutStepsIsMutable();
                  rolloutSteps_.add(m);
                } else {
                  rolloutStepsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                rolloutCondition_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                failureCondition_ = input.readStringRequireUtf8();

                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep>
        rolloutSteps_ = java.util.Collections.emptyList();

    private void ensureRolloutStepsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        rolloutSteps_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep>(
                rolloutSteps_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep,
            com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.Builder,
            com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStepOrBuilder>
        rolloutStepsBuilder_;

    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep>
        getRolloutStepsList() {
      if (rolloutStepsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rolloutSteps_);
      } else {
        return rolloutStepsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public int getRolloutStepsCount() {
      if (rolloutStepsBuilder_ == null) {
        return rolloutSteps_.size();
      } else {
        return rolloutStepsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep getRolloutSteps(int index) {
      if (rolloutStepsBuilder_ == null) {
        return rolloutSteps_.get(index);
      } else {
        return rolloutStepsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public Builder setRolloutSteps(
        int index, com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep value) {
      if (rolloutStepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRolloutStepsIsMutable();
        rolloutSteps_.set(index, value);
        onChanged();
      } else {
        rolloutStepsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public Builder setRolloutSteps(
        int index,
        com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.Builder builderForValue) {
      if (rolloutStepsBuilder_ == null) {
        ensureRolloutStepsIsMutable();
        rolloutSteps_.set(index, builderForValue.build());
        onChanged();
      } else {
        rolloutStepsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public Builder addRolloutSteps(
        com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep value) {
      if (rolloutStepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRolloutStepsIsMutable();
        rolloutSteps_.add(value);
        onChanged();
      } else {
        rolloutStepsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public Builder addRolloutSteps(
        int index, com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep value) {
      if (rolloutStepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRolloutStepsIsMutable();
        rolloutSteps_.add(index, value);
        onChanged();
      } else {
        rolloutStepsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public Builder addRolloutSteps(
        com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.Builder builderForValue) {
      if (rolloutStepsBuilder_ == null) {
        ensureRolloutStepsIsMutable();
        rolloutSteps_.add(builderForValue.build());
        onChanged();
      } else {
        rolloutStepsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public Builder addRolloutSteps(
        int index,
        com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.Builder builderForValue) {
      if (rolloutStepsBuilder_ == null) {
        ensureRolloutStepsIsMutable();
        rolloutSteps_.add(index, builderForValue.build());
        onChanged();
      } else {
        rolloutStepsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public Builder addAllRolloutSteps(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep>
            values) {
      if (rolloutStepsBuilder_ == null) {
        ensureRolloutStepsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rolloutSteps_);
        onChanged();
      } else {
        rolloutStepsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public Builder clearRolloutSteps() {
      if (rolloutStepsBuilder_ == null) {
        rolloutSteps_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        rolloutStepsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public Builder removeRolloutSteps(int index) {
      if (rolloutStepsBuilder_ == null) {
        ensureRolloutStepsIsMutable();
        rolloutSteps_.remove(index);
        onChanged();
      } else {
        rolloutStepsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.Builder
        getRolloutStepsBuilder(int index) {
      return getRolloutStepsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStepOrBuilder
        getRolloutStepsOrBuilder(int index) {
      if (rolloutStepsBuilder_ == null) {
        return rolloutSteps_.get(index);
      } else {
        return rolloutStepsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStepOrBuilder>
        getRolloutStepsOrBuilderList() {
      if (rolloutStepsBuilder_ != null) {
        return rolloutStepsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rolloutSteps_);
      }
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.Builder
        addRolloutStepsBuilder() {
      return getRolloutStepsFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.Builder
        addRolloutStepsBuilder(int index) {
      return getRolloutStepsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Steps to roll out a flow version. Steps should be sorted by percentage in
     * ascending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep rollout_steps = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.Builder>
        getRolloutStepsBuilderList() {
      return getRolloutStepsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep,
            com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.Builder,
            com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStepOrBuilder>
        getRolloutStepsFieldBuilder() {
      if (rolloutStepsBuilder_ == null) {
        rolloutStepsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep,
                com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.Builder,
                com.google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStepOrBuilder>(
                rolloutSteps_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        rolloutSteps_ = null;
      }
      return rolloutStepsBuilder_;
    }

    private java.lang.Object rolloutCondition_ = "";
    /**
     *
     *
     * <pre>
     * The conditions that are used to evaluate the success of a rollout
     * step. If not specified, all rollout steps will proceed to the next one
     * unless failure conditions are met. E.g. "containment_rate &gt; 60% AND
     * callback_rate &lt; 20%". See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * </pre>
     *
     * <code>string rollout_condition = 2;</code>
     *
     * @return The rolloutCondition.
     */
    public java.lang.String getRolloutCondition() {
      java.lang.Object ref = rolloutCondition_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rolloutCondition_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The conditions that are used to evaluate the success of a rollout
     * step. If not specified, all rollout steps will proceed to the next one
     * unless failure conditions are met. E.g. "containment_rate &gt; 60% AND
     * callback_rate &lt; 20%". See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * </pre>
     *
     * <code>string rollout_condition = 2;</code>
     *
     * @return The bytes for rolloutCondition.
     */
    public com.google.protobuf.ByteString getRolloutConditionBytes() {
      java.lang.Object ref = rolloutCondition_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rolloutCondition_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The conditions that are used to evaluate the success of a rollout
     * step. If not specified, all rollout steps will proceed to the next one
     * unless failure conditions are met. E.g. "containment_rate &gt; 60% AND
     * callback_rate &lt; 20%". See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * </pre>
     *
     * <code>string rollout_condition = 2;</code>
     *
     * @param value The rolloutCondition to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutCondition(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      rolloutCondition_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conditions that are used to evaluate the success of a rollout
     * step. If not specified, all rollout steps will proceed to the next one
     * unless failure conditions are met. E.g. "containment_rate &gt; 60% AND
     * callback_rate &lt; 20%". See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * </pre>
     *
     * <code>string rollout_condition = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRolloutCondition() {

      rolloutCondition_ = getDefaultInstance().getRolloutCondition();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conditions that are used to evaluate the success of a rollout
     * step. If not specified, all rollout steps will proceed to the next one
     * unless failure conditions are met. E.g. "containment_rate &gt; 60% AND
     * callback_rate &lt; 20%". See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * </pre>
     *
     * <code>string rollout_condition = 2;</code>
     *
     * @param value The bytes for rolloutCondition to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutConditionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      rolloutCondition_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object failureCondition_ = "";
    /**
     *
     *
     * <pre>
     * The conditions that are used to evaluate the failure of a rollout
     * step. If not specified, no rollout steps will fail. E.g. "containment_rate
     * &lt; 10% OR average_turn_count &lt; 3". See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * </pre>
     *
     * <code>string failure_condition = 3;</code>
     *
     * @return The failureCondition.
     */
    public java.lang.String getFailureCondition() {
      java.lang.Object ref = failureCondition_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        failureCondition_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The conditions that are used to evaluate the failure of a rollout
     * step. If not specified, no rollout steps will fail. E.g. "containment_rate
     * &lt; 10% OR average_turn_count &lt; 3". See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * </pre>
     *
     * <code>string failure_condition = 3;</code>
     *
     * @return The bytes for failureCondition.
     */
    public com.google.protobuf.ByteString getFailureConditionBytes() {
      java.lang.Object ref = failureCondition_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        failureCondition_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The conditions that are used to evaluate the failure of a rollout
     * step. If not specified, no rollout steps will fail. E.g. "containment_rate
     * &lt; 10% OR average_turn_count &lt; 3". See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * </pre>
     *
     * <code>string failure_condition = 3;</code>
     *
     * @param value The failureCondition to set.
     * @return This builder for chaining.
     */
    public Builder setFailureCondition(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      failureCondition_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conditions that are used to evaluate the failure of a rollout
     * step. If not specified, no rollout steps will fail. E.g. "containment_rate
     * &lt; 10% OR average_turn_count &lt; 3". See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * </pre>
     *
     * <code>string failure_condition = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailureCondition() {

      failureCondition_ = getDefaultInstance().getFailureCondition();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conditions that are used to evaluate the failure of a rollout
     * step. If not specified, no rollout steps will fail. E.g. "containment_rate
     * &lt; 10% OR average_turn_count &lt; 3". See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * </pre>
     *
     * <code>string failure_condition = 3;</code>
     *
     * @param value The bytes for failureCondition to set.
     * @return This builder for chaining.
     */
    public Builder setFailureConditionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      failureCondition_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.RolloutConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.RolloutConfig)
  private static final com.google.cloud.dialogflow.cx.v3.RolloutConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.RolloutConfig();
  }

  public static com.google.cloud.dialogflow.cx.v3.RolloutConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RolloutConfig> PARSER =
      new com.google.protobuf.AbstractParser<RolloutConfig>() {
        @java.lang.Override
        public RolloutConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RolloutConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RolloutConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.RolloutConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
