/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/session.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Represents the parameters of a conversational query.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.QueryParameters}
 */
public final class QueryParameters extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.QueryParameters)
    QueryParametersOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QueryParameters.newBuilder() to construct.
  private QueryParameters(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QueryParameters() {
    timeZone_ = "";
    sessionEntityTypes_ = java.util.Collections.emptyList();
    currentPage_ = "";
    flowVersions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QueryParameters();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_QueryParameters_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 10:
        return internalGetWebhookHeaders();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_QueryParameters_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.QueryParameters.class,
            com.google.cloud.dialogflow.cx.v3.QueryParameters.Builder.class);
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 1;
  private volatile java.lang.Object timeZone_;
  /**
   *
   *
   * <pre>
   * The time zone of this conversational query from the [time zone
   * database](https://www.iana.org/time-zones), e.g., America/New_York,
   * Europe/Paris. If not provided, the time zone specified in the agent is
   * used.
   * </pre>
   *
   * <code>string time_zone = 1;</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The time zone of this conversational query from the [time zone
   * database](https://www.iana.org/time-zones), e.g., America/New_York,
   * Europe/Paris. If not provided, the time zone specified in the agent is
   * used.
   * </pre>
   *
   * <code>string time_zone = 1;</code>
   *
   * @return The bytes for timeZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GEO_LOCATION_FIELD_NUMBER = 2;
  private com.google.type.LatLng geoLocation_;
  /**
   *
   *
   * <pre>
   * The geo location of this conversational query.
   * </pre>
   *
   * <code>.google.type.LatLng geo_location = 2;</code>
   *
   * @return Whether the geoLocation field is set.
   */
  @java.lang.Override
  public boolean hasGeoLocation() {
    return geoLocation_ != null;
  }
  /**
   *
   *
   * <pre>
   * The geo location of this conversational query.
   * </pre>
   *
   * <code>.google.type.LatLng geo_location = 2;</code>
   *
   * @return The geoLocation.
   */
  @java.lang.Override
  public com.google.type.LatLng getGeoLocation() {
    return geoLocation_ == null ? com.google.type.LatLng.getDefaultInstance() : geoLocation_;
  }
  /**
   *
   *
   * <pre>
   * The geo location of this conversational query.
   * </pre>
   *
   * <code>.google.type.LatLng geo_location = 2;</code>
   */
  @java.lang.Override
  public com.google.type.LatLngOrBuilder getGeoLocationOrBuilder() {
    return getGeoLocation();
  }

  public static final int SESSION_ENTITY_TYPES_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.dialogflow.cx.v3.SessionEntityType> sessionEntityTypes_;
  /**
   *
   *
   * <pre>
   * Additional session entity types to replace or extend developer entity types
   * with. The entity synonyms apply to all languages and persist for the
   * session of this query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.SessionEntityType>
      getSessionEntityTypesList() {
    return sessionEntityTypes_;
  }
  /**
   *
   *
   * <pre>
   * Additional session entity types to replace or extend developer entity types
   * with. The entity synonyms apply to all languages and persist for the
   * session of this query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.SessionEntityTypeOrBuilder>
      getSessionEntityTypesOrBuilderList() {
    return sessionEntityTypes_;
  }
  /**
   *
   *
   * <pre>
   * Additional session entity types to replace or extend developer entity types
   * with. The entity synonyms apply to all languages and persist for the
   * session of this query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
   * </code>
   */
  @java.lang.Override
  public int getSessionEntityTypesCount() {
    return sessionEntityTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Additional session entity types to replace or extend developer entity types
   * with. The entity synonyms apply to all languages and persist for the
   * session of this query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SessionEntityType getSessionEntityTypes(int index) {
    return sessionEntityTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Additional session entity types to replace or extend developer entity types
   * with. The entity synonyms apply to all languages and persist for the
   * session of this query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SessionEntityTypeOrBuilder
      getSessionEntityTypesOrBuilder(int index) {
    return sessionEntityTypes_.get(index);
  }

  public static final int PAYLOAD_FIELD_NUMBER = 4;
  private com.google.protobuf.Struct payload_;
  /**
   *
   *
   * <pre>
   * This field can be used to pass custom data into the webhook associated with
   * the agent. Arbitrary JSON objects are supported.
   * Some integrations that query a Dialogflow agent may provide additional
   * information in the payload.
   * In particular, for the Dialogflow Phone Gateway integration, this field has
   * the form:
   * ```
   * {
   *  "telephony": {
   *    "caller_id": "+18558363987"
   *  }
   * }
   * ```
   * </pre>
   *
   * <code>.google.protobuf.Struct payload = 4;</code>
   *
   * @return Whether the payload field is set.
   */
  @java.lang.Override
  public boolean hasPayload() {
    return payload_ != null;
  }
  /**
   *
   *
   * <pre>
   * This field can be used to pass custom data into the webhook associated with
   * the agent. Arbitrary JSON objects are supported.
   * Some integrations that query a Dialogflow agent may provide additional
   * information in the payload.
   * In particular, for the Dialogflow Phone Gateway integration, this field has
   * the form:
   * ```
   * {
   *  "telephony": {
   *    "caller_id": "+18558363987"
   *  }
   * }
   * ```
   * </pre>
   *
   * <code>.google.protobuf.Struct payload = 4;</code>
   *
   * @return The payload.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getPayload() {
    return payload_ == null ? com.google.protobuf.Struct.getDefaultInstance() : payload_;
  }
  /**
   *
   *
   * <pre>
   * This field can be used to pass custom data into the webhook associated with
   * the agent. Arbitrary JSON objects are supported.
   * Some integrations that query a Dialogflow agent may provide additional
   * information in the payload.
   * In particular, for the Dialogflow Phone Gateway integration, this field has
   * the form:
   * ```
   * {
   *  "telephony": {
   *    "caller_id": "+18558363987"
   *  }
   * }
   * ```
   * </pre>
   *
   * <code>.google.protobuf.Struct payload = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getPayloadOrBuilder() {
    return getPayload();
  }

  public static final int PARAMETERS_FIELD_NUMBER = 5;
  private com.google.protobuf.Struct parameters_;
  /**
   *
   *
   * <pre>
   * Additional parameters to be put into [session
   * parameters][SessionInfo.parameters]. To remove a
   * parameter from the session, clients should explicitly set the parameter
   * value to null.
   * You can reference the session parameters in the agent with the following
   * format: $session.params.parameter-id.
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 5;</code>
   *
   * @return Whether the parameters field is set.
   */
  @java.lang.Override
  public boolean hasParameters() {
    return parameters_ != null;
  }
  /**
   *
   *
   * <pre>
   * Additional parameters to be put into [session
   * parameters][SessionInfo.parameters]. To remove a
   * parameter from the session, clients should explicitly set the parameter
   * value to null.
   * You can reference the session parameters in the agent with the following
   * format: $session.params.parameter-id.
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 5;</code>
   *
   * @return The parameters.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getParameters() {
    return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
  }
  /**
   *
   *
   * <pre>
   * Additional parameters to be put into [session
   * parameters][SessionInfo.parameters]. To remove a
   * parameter from the session, clients should explicitly set the parameter
   * value to null.
   * You can reference the session parameters in the agent with the following
   * format: $session.params.parameter-id.
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getParametersOrBuilder() {
    return getParameters();
  }

  public static final int CURRENT_PAGE_FIELD_NUMBER = 6;
  private volatile java.lang.Object currentPage_;
  /**
   *
   *
   * <pre>
   * The unique identifier of the [page][google.cloud.dialogflow.cx.v3.Page] to override the [current
   * page][QueryResult.current_page] in the session.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
   * If `current_page` is specified, the previous state of the session will be
   * ignored by Dialogflow, including the [previous
   * page][QueryResult.current_page] and the [previous session
   * parameters][QueryResult.parameters].
   * In most cases, [current_page][google.cloud.dialogflow.cx.v3.QueryParameters.current_page] and
   * [parameters][google.cloud.dialogflow.cx.v3.QueryParameters.parameters] should be configured together to
   * direct a session to a specific state.
   * </pre>
   *
   * <code>string current_page = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The currentPage.
   */
  @java.lang.Override
  public java.lang.String getCurrentPage() {
    java.lang.Object ref = currentPage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currentPage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the [page][google.cloud.dialogflow.cx.v3.Page] to override the [current
   * page][QueryResult.current_page] in the session.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
   * If `current_page` is specified, the previous state of the session will be
   * ignored by Dialogflow, including the [previous
   * page][QueryResult.current_page] and the [previous session
   * parameters][QueryResult.parameters].
   * In most cases, [current_page][google.cloud.dialogflow.cx.v3.QueryParameters.current_page] and
   * [parameters][google.cloud.dialogflow.cx.v3.QueryParameters.parameters] should be configured together to
   * direct a session to a specific state.
   * </pre>
   *
   * <code>string current_page = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for currentPage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCurrentPageBytes() {
    java.lang.Object ref = currentPage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      currentPage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLE_WEBHOOK_FIELD_NUMBER = 7;
  private boolean disableWebhook_;
  /**
   *
   *
   * <pre>
   * Whether to disable webhook calls for this request.
   * </pre>
   *
   * <code>bool disable_webhook = 7;</code>
   *
   * @return The disableWebhook.
   */
  @java.lang.Override
  public boolean getDisableWebhook() {
    return disableWebhook_;
  }

  public static final int ANALYZE_QUERY_TEXT_SENTIMENT_FIELD_NUMBER = 8;
  private boolean analyzeQueryTextSentiment_;
  /**
   *
   *
   * <pre>
   * Configures whether sentiment analysis should be performed. If not
   * provided, sentiment analysis is not performed.
   * </pre>
   *
   * <code>bool analyze_query_text_sentiment = 8;</code>
   *
   * @return The analyzeQueryTextSentiment.
   */
  @java.lang.Override
  public boolean getAnalyzeQueryTextSentiment() {
    return analyzeQueryTextSentiment_;
  }

  public static final int WEBHOOK_HEADERS_FIELD_NUMBER = 10;

  private static final class WebhookHeadersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dialogflow.cx.v3.SessionProto
                .internal_static_google_cloud_dialogflow_cx_v3_QueryParameters_WebhookHeadersEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> webhookHeaders_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetWebhookHeaders() {
    if (webhookHeaders_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          WebhookHeadersDefaultEntryHolder.defaultEntry);
    }
    return webhookHeaders_;
  }

  public int getWebhookHeadersCount() {
    return internalGetWebhookHeaders().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * This field can be used to pass HTTP headers for a webhook
   * call. These headers will be sent to webhook along with the headers that
   * have been configured through Dialogflow web console. The headers defined
   * within this field will overwrite the headers configured through Dialogflow
   * console if there is a conflict. Header names are case-insensitive.
   * Google's specified headers are not allowed. Including: "Host",
   * "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
   * "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
   * </pre>
   *
   * <code>map&lt;string, string&gt; webhook_headers = 10;</code>
   */
  @java.lang.Override
  public boolean containsWebhookHeaders(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetWebhookHeaders().getMap().containsKey(key);
  }
  /** Use {@link #getWebhookHeadersMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getWebhookHeaders() {
    return getWebhookHeadersMap();
  }
  /**
   *
   *
   * <pre>
   * This field can be used to pass HTTP headers for a webhook
   * call. These headers will be sent to webhook along with the headers that
   * have been configured through Dialogflow web console. The headers defined
   * within this field will overwrite the headers configured through Dialogflow
   * console if there is a conflict. Header names are case-insensitive.
   * Google's specified headers are not allowed. Including: "Host",
   * "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
   * "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
   * </pre>
   *
   * <code>map&lt;string, string&gt; webhook_headers = 10;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getWebhookHeadersMap() {
    return internalGetWebhookHeaders().getMap();
  }
  /**
   *
   *
   * <pre>
   * This field can be used to pass HTTP headers for a webhook
   * call. These headers will be sent to webhook along with the headers that
   * have been configured through Dialogflow web console. The headers defined
   * within this field will overwrite the headers configured through Dialogflow
   * console if there is a conflict. Header names are case-insensitive.
   * Google's specified headers are not allowed. Including: "Host",
   * "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
   * "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
   * </pre>
   *
   * <code>map&lt;string, string&gt; webhook_headers = 10;</code>
   */
  @java.lang.Override
  public java.lang.String getWebhookHeadersOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetWebhookHeaders().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * This field can be used to pass HTTP headers for a webhook
   * call. These headers will be sent to webhook along with the headers that
   * have been configured through Dialogflow web console. The headers defined
   * within this field will overwrite the headers configured through Dialogflow
   * console if there is a conflict. Header names are case-insensitive.
   * Google's specified headers are not allowed. Including: "Host",
   * "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
   * "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
   * </pre>
   *
   * <code>map&lt;string, string&gt; webhook_headers = 10;</code>
   */
  @java.lang.Override
  public java.lang.String getWebhookHeadersOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetWebhookHeaders().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int FLOW_VERSIONS_FIELD_NUMBER = 14;
  private com.google.protobuf.LazyStringList flowVersions_;
  /**
   *
   *
   * <pre>
   * A list of flow versions to override for the request.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
   * If version 1 of flow X is included in this list, the traffic of
   * flow X will go through version 1 regardless of the version configuration in
   * the environment. Each flow can have at most one version specified in this
   * list.
   * </pre>
   *
   * <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return A list containing the flowVersions.
   */
  public com.google.protobuf.ProtocolStringList getFlowVersionsList() {
    return flowVersions_;
  }
  /**
   *
   *
   * <pre>
   * A list of flow versions to override for the request.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
   * If version 1 of flow X is included in this list, the traffic of
   * flow X will go through version 1 regardless of the version configuration in
   * the environment. Each flow can have at most one version specified in this
   * list.
   * </pre>
   *
   * <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The count of flowVersions.
   */
  public int getFlowVersionsCount() {
    return flowVersions_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of flow versions to override for the request.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
   * If version 1 of flow X is included in this list, the traffic of
   * flow X will go through version 1 regardless of the version configuration in
   * the environment. Each flow can have at most one version specified in this
   * list.
   * </pre>
   *
   * <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the element to return.
   * @return The flowVersions at the given index.
   */
  public java.lang.String getFlowVersions(int index) {
    return flowVersions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of flow versions to override for the request.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
   * If version 1 of flow X is included in this list, the traffic of
   * flow X will go through version 1 regardless of the version configuration in
   * the environment. Each flow can have at most one version specified in this
   * list.
   * </pre>
   *
   * <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the flowVersions at the given index.
   */
  public com.google.protobuf.ByteString getFlowVersionsBytes(int index) {
    return flowVersions_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, timeZone_);
    }
    if (geoLocation_ != null) {
      output.writeMessage(2, getGeoLocation());
    }
    for (int i = 0; i < sessionEntityTypes_.size(); i++) {
      output.writeMessage(3, sessionEntityTypes_.get(i));
    }
    if (payload_ != null) {
      output.writeMessage(4, getPayload());
    }
    if (parameters_ != null) {
      output.writeMessage(5, getParameters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentPage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, currentPage_);
    }
    if (disableWebhook_ != false) {
      output.writeBool(7, disableWebhook_);
    }
    if (analyzeQueryTextSentiment_ != false) {
      output.writeBool(8, analyzeQueryTextSentiment_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetWebhookHeaders(), WebhookHeadersDefaultEntryHolder.defaultEntry, 10);
    for (int i = 0; i < flowVersions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, flowVersions_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, timeZone_);
    }
    if (geoLocation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getGeoLocation());
    }
    for (int i = 0; i < sessionEntityTypes_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, sessionEntityTypes_.get(i));
    }
    if (payload_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPayload());
    }
    if (parameters_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getParameters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentPage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, currentPage_);
    }
    if (disableWebhook_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, disableWebhook_);
    }
    if (analyzeQueryTextSentiment_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, analyzeQueryTextSentiment_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetWebhookHeaders().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> webhookHeaders__ =
          WebhookHeadersDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, webhookHeaders__);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < flowVersions_.size(); i++) {
        dataSize += computeStringSizeNoTag(flowVersions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFlowVersionsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.QueryParameters)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.QueryParameters other =
        (com.google.cloud.dialogflow.cx.v3.QueryParameters) obj;

    if (!getTimeZone().equals(other.getTimeZone())) return false;
    if (hasGeoLocation() != other.hasGeoLocation()) return false;
    if (hasGeoLocation()) {
      if (!getGeoLocation().equals(other.getGeoLocation())) return false;
    }
    if (!getSessionEntityTypesList().equals(other.getSessionEntityTypesList())) return false;
    if (hasPayload() != other.hasPayload()) return false;
    if (hasPayload()) {
      if (!getPayload().equals(other.getPayload())) return false;
    }
    if (hasParameters() != other.hasParameters()) return false;
    if (hasParameters()) {
      if (!getParameters().equals(other.getParameters())) return false;
    }
    if (!getCurrentPage().equals(other.getCurrentPage())) return false;
    if (getDisableWebhook() != other.getDisableWebhook()) return false;
    if (getAnalyzeQueryTextSentiment() != other.getAnalyzeQueryTextSentiment()) return false;
    if (!internalGetWebhookHeaders().equals(other.internalGetWebhookHeaders())) return false;
    if (!getFlowVersionsList().equals(other.getFlowVersionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getTimeZone().hashCode();
    if (hasGeoLocation()) {
      hash = (37 * hash) + GEO_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getGeoLocation().hashCode();
    }
    if (getSessionEntityTypesCount() > 0) {
      hash = (37 * hash) + SESSION_ENTITY_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getSessionEntityTypesList().hashCode();
    }
    if (hasPayload()) {
      hash = (37 * hash) + PAYLOAD_FIELD_NUMBER;
      hash = (53 * hash) + getPayload().hashCode();
    }
    if (hasParameters()) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParameters().hashCode();
    }
    hash = (37 * hash) + CURRENT_PAGE_FIELD_NUMBER;
    hash = (53 * hash) + getCurrentPage().hashCode();
    hash = (37 * hash) + DISABLE_WEBHOOK_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableWebhook());
    hash = (37 * hash) + ANALYZE_QUERY_TEXT_SENTIMENT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAnalyzeQueryTextSentiment());
    if (!internalGetWebhookHeaders().getMap().isEmpty()) {
      hash = (37 * hash) + WEBHOOK_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetWebhookHeaders().hashCode();
    }
    if (getFlowVersionsCount() > 0) {
      hash = (37 * hash) + FLOW_VERSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFlowVersionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryParameters parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryParameters parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryParameters parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryParameters parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryParameters parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryParameters parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryParameters parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryParameters parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryParameters parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryParameters parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryParameters parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryParameters parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.QueryParameters prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the parameters of a conversational query.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.QueryParameters}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.QueryParameters)
      com.google.cloud.dialogflow.cx.v3.QueryParametersOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_QueryParameters_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 10:
          return internalGetWebhookHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 10:
          return internalGetMutableWebhookHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_QueryParameters_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.QueryParameters.class,
              com.google.cloud.dialogflow.cx.v3.QueryParameters.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.QueryParameters.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      timeZone_ = "";

      if (geoLocationBuilder_ == null) {
        geoLocation_ = null;
      } else {
        geoLocation_ = null;
        geoLocationBuilder_ = null;
      }
      if (sessionEntityTypesBuilder_ == null) {
        sessionEntityTypes_ = java.util.Collections.emptyList();
      } else {
        sessionEntityTypes_ = null;
        sessionEntityTypesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (payloadBuilder_ == null) {
        payload_ = null;
      } else {
        payload_ = null;
        payloadBuilder_ = null;
      }
      if (parametersBuilder_ == null) {
        parameters_ = null;
      } else {
        parameters_ = null;
        parametersBuilder_ = null;
      }
      currentPage_ = "";

      disableWebhook_ = false;

      analyzeQueryTextSentiment_ = false;

      internalGetMutableWebhookHeaders().clear();
      flowVersions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_QueryParameters_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.QueryParameters getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.QueryParameters.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.QueryParameters build() {
      com.google.cloud.dialogflow.cx.v3.QueryParameters result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.QueryParameters buildPartial() {
      com.google.cloud.dialogflow.cx.v3.QueryParameters result =
          new com.google.cloud.dialogflow.cx.v3.QueryParameters(this);
      int from_bitField0_ = bitField0_;
      result.timeZone_ = timeZone_;
      if (geoLocationBuilder_ == null) {
        result.geoLocation_ = geoLocation_;
      } else {
        result.geoLocation_ = geoLocationBuilder_.build();
      }
      if (sessionEntityTypesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          sessionEntityTypes_ = java.util.Collections.unmodifiableList(sessionEntityTypes_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.sessionEntityTypes_ = sessionEntityTypes_;
      } else {
        result.sessionEntityTypes_ = sessionEntityTypesBuilder_.build();
      }
      if (payloadBuilder_ == null) {
        result.payload_ = payload_;
      } else {
        result.payload_ = payloadBuilder_.build();
      }
      if (parametersBuilder_ == null) {
        result.parameters_ = parameters_;
      } else {
        result.parameters_ = parametersBuilder_.build();
      }
      result.currentPage_ = currentPage_;
      result.disableWebhook_ = disableWebhook_;
      result.analyzeQueryTextSentiment_ = analyzeQueryTextSentiment_;
      result.webhookHeaders_ = internalGetWebhookHeaders();
      result.webhookHeaders_.makeImmutable();
      if (((bitField0_ & 0x00000004) != 0)) {
        flowVersions_ = flowVersions_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.flowVersions_ = flowVersions_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.QueryParameters) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.QueryParameters) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.QueryParameters other) {
      if (other == com.google.cloud.dialogflow.cx.v3.QueryParameters.getDefaultInstance())
        return this;
      if (!other.getTimeZone().isEmpty()) {
        timeZone_ = other.timeZone_;
        onChanged();
      }
      if (other.hasGeoLocation()) {
        mergeGeoLocation(other.getGeoLocation());
      }
      if (sessionEntityTypesBuilder_ == null) {
        if (!other.sessionEntityTypes_.isEmpty()) {
          if (sessionEntityTypes_.isEmpty()) {
            sessionEntityTypes_ = other.sessionEntityTypes_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSessionEntityTypesIsMutable();
            sessionEntityTypes_.addAll(other.sessionEntityTypes_);
          }
          onChanged();
        }
      } else {
        if (!other.sessionEntityTypes_.isEmpty()) {
          if (sessionEntityTypesBuilder_.isEmpty()) {
            sessionEntityTypesBuilder_.dispose();
            sessionEntityTypesBuilder_ = null;
            sessionEntityTypes_ = other.sessionEntityTypes_;
            bitField0_ = (bitField0_ & ~0x00000001);
            sessionEntityTypesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSessionEntityTypesFieldBuilder()
                    : null;
          } else {
            sessionEntityTypesBuilder_.addAllMessages(other.sessionEntityTypes_);
          }
        }
      }
      if (other.hasPayload()) {
        mergePayload(other.getPayload());
      }
      if (other.hasParameters()) {
        mergeParameters(other.getParameters());
      }
      if (!other.getCurrentPage().isEmpty()) {
        currentPage_ = other.currentPage_;
        onChanged();
      }
      if (other.getDisableWebhook() != false) {
        setDisableWebhook(other.getDisableWebhook());
      }
      if (other.getAnalyzeQueryTextSentiment() != false) {
        setAnalyzeQueryTextSentiment(other.getAnalyzeQueryTextSentiment());
      }
      internalGetMutableWebhookHeaders().mergeFrom(other.internalGetWebhookHeaders());
      if (!other.flowVersions_.isEmpty()) {
        if (flowVersions_.isEmpty()) {
          flowVersions_ = other.flowVersions_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureFlowVersionsIsMutable();
          flowVersions_.addAll(other.flowVersions_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                timeZone_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getGeoLocationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                com.google.cloud.dialogflow.cx.v3.SessionEntityType m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.SessionEntityType.parser(),
                        extensionRegistry);
                if (sessionEntityTypesBuilder_ == null) {
                  ensureSessionEntityTypesIsMutable();
                  sessionEntityTypes_.add(m);
                } else {
                  sessionEntityTypesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getPayloadFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getParametersFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                currentPage_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 56:
              {
                disableWebhook_ = input.readBool();

                break;
              } // case 56
            case 64:
              {
                analyzeQueryTextSentiment_ = input.readBool();

                break;
              } // case 64
            case 82:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> webhookHeaders__ =
                    input.readMessage(
                        WebhookHeadersDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableWebhookHeaders()
                    .getMutableMap()
                    .put(webhookHeaders__.getKey(), webhookHeaders__.getValue());
                break;
              } // case 82
            case 114:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureFlowVersionsIsMutable();
                flowVersions_.add(s);
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object timeZone_ = "";
    /**
     *
     *
     * <pre>
     * The time zone of this conversational query from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris. If not provided, the time zone specified in the agent is
     * used.
     * </pre>
     *
     * <code>string time_zone = 1;</code>
     *
     * @return The timeZone.
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The time zone of this conversational query from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris. If not provided, the time zone specified in the agent is
     * used.
     * </pre>
     *
     * <code>string time_zone = 1;</code>
     *
     * @return The bytes for timeZone.
     */
    public com.google.protobuf.ByteString getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The time zone of this conversational query from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris. If not provided, the time zone specified in the agent is
     * used.
     * </pre>
     *
     * <code>string time_zone = 1;</code>
     *
     * @param value The timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      timeZone_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time zone of this conversational query from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris. If not provided, the time zone specified in the agent is
     * used.
     * </pre>
     *
     * <code>string time_zone = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeZone() {

      timeZone_ = getDefaultInstance().getTimeZone();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time zone of this conversational query from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris. If not provided, the time zone specified in the agent is
     * used.
     * </pre>
     *
     * <code>string time_zone = 1;</code>
     *
     * @param value The bytes for timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      timeZone_ = value;
      onChanged();
      return this;
    }

    private com.google.type.LatLng geoLocation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        geoLocationBuilder_;
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     *
     * @return Whether the geoLocation field is set.
     */
    public boolean hasGeoLocation() {
      return geoLocationBuilder_ != null || geoLocation_ != null;
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     *
     * @return The geoLocation.
     */
    public com.google.type.LatLng getGeoLocation() {
      if (geoLocationBuilder_ == null) {
        return geoLocation_ == null ? com.google.type.LatLng.getDefaultInstance() : geoLocation_;
      } else {
        return geoLocationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     */
    public Builder setGeoLocation(com.google.type.LatLng value) {
      if (geoLocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        geoLocation_ = value;
        onChanged();
      } else {
        geoLocationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     */
    public Builder setGeoLocation(com.google.type.LatLng.Builder builderForValue) {
      if (geoLocationBuilder_ == null) {
        geoLocation_ = builderForValue.build();
        onChanged();
      } else {
        geoLocationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     */
    public Builder mergeGeoLocation(com.google.type.LatLng value) {
      if (geoLocationBuilder_ == null) {
        if (geoLocation_ != null) {
          geoLocation_ =
              com.google.type.LatLng.newBuilder(geoLocation_).mergeFrom(value).buildPartial();
        } else {
          geoLocation_ = value;
        }
        onChanged();
      } else {
        geoLocationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     */
    public Builder clearGeoLocation() {
      if (geoLocationBuilder_ == null) {
        geoLocation_ = null;
        onChanged();
      } else {
        geoLocation_ = null;
        geoLocationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     */
    public com.google.type.LatLng.Builder getGeoLocationBuilder() {

      onChanged();
      return getGeoLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     */
    public com.google.type.LatLngOrBuilder getGeoLocationOrBuilder() {
      if (geoLocationBuilder_ != null) {
        return geoLocationBuilder_.getMessageOrBuilder();
      } else {
        return geoLocation_ == null ? com.google.type.LatLng.getDefaultInstance() : geoLocation_;
      }
    }
    /**
     *
     *
     * <pre>
     * The geo location of this conversational query.
     * </pre>
     *
     * <code>.google.type.LatLng geo_location = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        getGeoLocationFieldBuilder() {
      if (geoLocationBuilder_ == null) {
        geoLocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.LatLng,
                com.google.type.LatLng.Builder,
                com.google.type.LatLngOrBuilder>(
                getGeoLocation(), getParentForChildren(), isClean());
        geoLocation_ = null;
      }
      return geoLocationBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3.SessionEntityType>
        sessionEntityTypes_ = java.util.Collections.emptyList();

    private void ensureSessionEntityTypesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        sessionEntityTypes_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.SessionEntityType>(
                sessionEntityTypes_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.SessionEntityType,
            com.google.cloud.dialogflow.cx.v3.SessionEntityType.Builder,
            com.google.cloud.dialogflow.cx.v3.SessionEntityTypeOrBuilder>
        sessionEntityTypesBuilder_;

    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.SessionEntityType>
        getSessionEntityTypesList() {
      if (sessionEntityTypesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(sessionEntityTypes_);
      } else {
        return sessionEntityTypesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public int getSessionEntityTypesCount() {
      if (sessionEntityTypesBuilder_ == null) {
        return sessionEntityTypes_.size();
      } else {
        return sessionEntityTypesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.SessionEntityType getSessionEntityTypes(int index) {
      if (sessionEntityTypesBuilder_ == null) {
        return sessionEntityTypes_.get(index);
      } else {
        return sessionEntityTypesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public Builder setSessionEntityTypes(
        int index, com.google.cloud.dialogflow.cx.v3.SessionEntityType value) {
      if (sessionEntityTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.set(index, value);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public Builder setSessionEntityTypes(
        int index, com.google.cloud.dialogflow.cx.v3.SessionEntityType.Builder builderForValue) {
      if (sessionEntityTypesBuilder_ == null) {
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.set(index, builderForValue.build());
        onChanged();
      } else {
        sessionEntityTypesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public Builder addSessionEntityTypes(
        com.google.cloud.dialogflow.cx.v3.SessionEntityType value) {
      if (sessionEntityTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.add(value);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public Builder addSessionEntityTypes(
        int index, com.google.cloud.dialogflow.cx.v3.SessionEntityType value) {
      if (sessionEntityTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.add(index, value);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public Builder addSessionEntityTypes(
        com.google.cloud.dialogflow.cx.v3.SessionEntityType.Builder builderForValue) {
      if (sessionEntityTypesBuilder_ == null) {
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.add(builderForValue.build());
        onChanged();
      } else {
        sessionEntityTypesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public Builder addSessionEntityTypes(
        int index, com.google.cloud.dialogflow.cx.v3.SessionEntityType.Builder builderForValue) {
      if (sessionEntityTypesBuilder_ == null) {
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.add(index, builderForValue.build());
        onChanged();
      } else {
        sessionEntityTypesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public Builder addAllSessionEntityTypes(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.SessionEntityType> values) {
      if (sessionEntityTypesBuilder_ == null) {
        ensureSessionEntityTypesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sessionEntityTypes_);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public Builder clearSessionEntityTypes() {
      if (sessionEntityTypesBuilder_ == null) {
        sessionEntityTypes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public Builder removeSessionEntityTypes(int index) {
      if (sessionEntityTypesBuilder_ == null) {
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.remove(index);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.SessionEntityType.Builder getSessionEntityTypesBuilder(
        int index) {
      return getSessionEntityTypesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.SessionEntityTypeOrBuilder
        getSessionEntityTypesOrBuilder(int index) {
      if (sessionEntityTypesBuilder_ == null) {
        return sessionEntityTypes_.get(index);
      } else {
        return sessionEntityTypesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.SessionEntityTypeOrBuilder>
        getSessionEntityTypesOrBuilderList() {
      if (sessionEntityTypesBuilder_ != null) {
        return sessionEntityTypesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(sessionEntityTypes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.SessionEntityType.Builder
        addSessionEntityTypesBuilder() {
      return getSessionEntityTypesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3.SessionEntityType.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.SessionEntityType.Builder addSessionEntityTypesBuilder(
        int index) {
      return getSessionEntityTypesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.cx.v3.SessionEntityType.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.SessionEntityType.Builder>
        getSessionEntityTypesBuilderList() {
      return getSessionEntityTypesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.SessionEntityType,
            com.google.cloud.dialogflow.cx.v3.SessionEntityType.Builder,
            com.google.cloud.dialogflow.cx.v3.SessionEntityTypeOrBuilder>
        getSessionEntityTypesFieldBuilder() {
      if (sessionEntityTypesBuilder_ == null) {
        sessionEntityTypesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.SessionEntityType,
                com.google.cloud.dialogflow.cx.v3.SessionEntityType.Builder,
                com.google.cloud.dialogflow.cx.v3.SessionEntityTypeOrBuilder>(
                sessionEntityTypes_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        sessionEntityTypes_ = null;
      }
      return sessionEntityTypesBuilder_;
    }

    private com.google.protobuf.Struct payload_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        payloadBuilder_;
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data into the webhook associated with
     * the agent. Arbitrary JSON objects are supported.
     * Some integrations that query a Dialogflow agent may provide additional
     * information in the payload.
     * In particular, for the Dialogflow Phone Gateway integration, this field has
     * the form:
     * ```
     * {
     *  "telephony": {
     *    "caller_id": "+18558363987"
     *  }
     * }
     * ```
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     *
     * @return Whether the payload field is set.
     */
    public boolean hasPayload() {
      return payloadBuilder_ != null || payload_ != null;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data into the webhook associated with
     * the agent. Arbitrary JSON objects are supported.
     * Some integrations that query a Dialogflow agent may provide additional
     * information in the payload.
     * In particular, for the Dialogflow Phone Gateway integration, this field has
     * the form:
     * ```
     * {
     *  "telephony": {
     *    "caller_id": "+18558363987"
     *  }
     * }
     * ```
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     *
     * @return The payload.
     */
    public com.google.protobuf.Struct getPayload() {
      if (payloadBuilder_ == null) {
        return payload_ == null ? com.google.protobuf.Struct.getDefaultInstance() : payload_;
      } else {
        return payloadBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data into the webhook associated with
     * the agent. Arbitrary JSON objects are supported.
     * Some integrations that query a Dialogflow agent may provide additional
     * information in the payload.
     * In particular, for the Dialogflow Phone Gateway integration, this field has
     * the form:
     * ```
     * {
     *  "telephony": {
     *    "caller_id": "+18558363987"
     *  }
     * }
     * ```
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     */
    public Builder setPayload(com.google.protobuf.Struct value) {
      if (payloadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        payloadBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data into the webhook associated with
     * the agent. Arbitrary JSON objects are supported.
     * Some integrations that query a Dialogflow agent may provide additional
     * information in the payload.
     * In particular, for the Dialogflow Phone Gateway integration, this field has
     * the form:
     * ```
     * {
     *  "telephony": {
     *    "caller_id": "+18558363987"
     *  }
     * }
     * ```
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     */
    public Builder setPayload(com.google.protobuf.Struct.Builder builderForValue) {
      if (payloadBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        payloadBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data into the webhook associated with
     * the agent. Arbitrary JSON objects are supported.
     * Some integrations that query a Dialogflow agent may provide additional
     * information in the payload.
     * In particular, for the Dialogflow Phone Gateway integration, this field has
     * the form:
     * ```
     * {
     *  "telephony": {
     *    "caller_id": "+18558363987"
     *  }
     * }
     * ```
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     */
    public Builder mergePayload(com.google.protobuf.Struct value) {
      if (payloadBuilder_ == null) {
        if (payload_ != null) {
          payload_ =
              com.google.protobuf.Struct.newBuilder(payload_).mergeFrom(value).buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        payloadBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data into the webhook associated with
     * the agent. Arbitrary JSON objects are supported.
     * Some integrations that query a Dialogflow agent may provide additional
     * information in the payload.
     * In particular, for the Dialogflow Phone Gateway integration, this field has
     * the form:
     * ```
     * {
     *  "telephony": {
     *    "caller_id": "+18558363987"
     *  }
     * }
     * ```
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     */
    public Builder clearPayload() {
      if (payloadBuilder_ == null) {
        payload_ = null;
        onChanged();
      } else {
        payload_ = null;
        payloadBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data into the webhook associated with
     * the agent. Arbitrary JSON objects are supported.
     * Some integrations that query a Dialogflow agent may provide additional
     * information in the payload.
     * In particular, for the Dialogflow Phone Gateway integration, this field has
     * the form:
     * ```
     * {
     *  "telephony": {
     *    "caller_id": "+18558363987"
     *  }
     * }
     * ```
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     */
    public com.google.protobuf.Struct.Builder getPayloadBuilder() {

      onChanged();
      return getPayloadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data into the webhook associated with
     * the agent. Arbitrary JSON objects are supported.
     * Some integrations that query a Dialogflow agent may provide additional
     * information in the payload.
     * In particular, for the Dialogflow Phone Gateway integration, this field has
     * the form:
     * ```
     * {
     *  "telephony": {
     *    "caller_id": "+18558363987"
     *  }
     * }
     * ```
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     */
    public com.google.protobuf.StructOrBuilder getPayloadOrBuilder() {
      if (payloadBuilder_ != null) {
        return payloadBuilder_.getMessageOrBuilder();
      } else {
        return payload_ == null ? com.google.protobuf.Struct.getDefaultInstance() : payload_;
      }
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass custom data into the webhook associated with
     * the agent. Arbitrary JSON objects are supported.
     * Some integrations that query a Dialogflow agent may provide additional
     * information in the payload.
     * In particular, for the Dialogflow Phone Gateway integration, this field has
     * the form:
     * ```
     * {
     *  "telephony": {
     *    "caller_id": "+18558363987"
     *  }
     * }
     * ```
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getPayloadFieldBuilder() {
      if (payloadBuilder_ == null) {
        payloadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getPayload(), getParentForChildren(), isClean());
        payload_ = null;
      }
      return payloadBuilder_;
    }

    private com.google.protobuf.Struct parameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        parametersBuilder_;
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into [session
     * parameters][SessionInfo.parameters]. To remove a
     * parameter from the session, clients should explicitly set the parameter
     * value to null.
     * You can reference the session parameters in the agent with the following
     * format: $session.params.parameter-id.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 5;</code>
     *
     * @return Whether the parameters field is set.
     */
    public boolean hasParameters() {
      return parametersBuilder_ != null || parameters_ != null;
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into [session
     * parameters][SessionInfo.parameters]. To remove a
     * parameter from the session, clients should explicitly set the parameter
     * value to null.
     * You can reference the session parameters in the agent with the following
     * format: $session.params.parameter-id.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 5;</code>
     *
     * @return The parameters.
     */
    public com.google.protobuf.Struct getParameters() {
      if (parametersBuilder_ == null) {
        return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
      } else {
        return parametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into [session
     * parameters][SessionInfo.parameters]. To remove a
     * parameter from the session, clients should explicitly set the parameter
     * value to null.
     * You can reference the session parameters in the agent with the following
     * format: $session.params.parameter-id.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 5;</code>
     */
    public Builder setParameters(com.google.protobuf.Struct value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parameters_ = value;
        onChanged();
      } else {
        parametersBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into [session
     * parameters][SessionInfo.parameters]. To remove a
     * parameter from the session, clients should explicitly set the parameter
     * value to null.
     * You can reference the session parameters in the agent with the following
     * format: $session.params.parameter-id.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 5;</code>
     */
    public Builder setParameters(com.google.protobuf.Struct.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        parameters_ = builderForValue.build();
        onChanged();
      } else {
        parametersBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into [session
     * parameters][SessionInfo.parameters]. To remove a
     * parameter from the session, clients should explicitly set the parameter
     * value to null.
     * You can reference the session parameters in the agent with the following
     * format: $session.params.parameter-id.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 5;</code>
     */
    public Builder mergeParameters(com.google.protobuf.Struct value) {
      if (parametersBuilder_ == null) {
        if (parameters_ != null) {
          parameters_ =
              com.google.protobuf.Struct.newBuilder(parameters_).mergeFrom(value).buildPartial();
        } else {
          parameters_ = value;
        }
        onChanged();
      } else {
        parametersBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into [session
     * parameters][SessionInfo.parameters]. To remove a
     * parameter from the session, clients should explicitly set the parameter
     * value to null.
     * You can reference the session parameters in the agent with the following
     * format: $session.params.parameter-id.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 5;</code>
     */
    public Builder clearParameters() {
      if (parametersBuilder_ == null) {
        parameters_ = null;
        onChanged();
      } else {
        parameters_ = null;
        parametersBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into [session
     * parameters][SessionInfo.parameters]. To remove a
     * parameter from the session, clients should explicitly set the parameter
     * value to null.
     * You can reference the session parameters in the agent with the following
     * format: $session.params.parameter-id.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 5;</code>
     */
    public com.google.protobuf.Struct.Builder getParametersBuilder() {

      onChanged();
      return getParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into [session
     * parameters][SessionInfo.parameters]. To remove a
     * parameter from the session, clients should explicitly set the parameter
     * value to null.
     * You can reference the session parameters in the agent with the following
     * format: $session.params.parameter-id.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 5;</code>
     */
    public com.google.protobuf.StructOrBuilder getParametersOrBuilder() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilder();
      } else {
        return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into [session
     * parameters][SessionInfo.parameters]. To remove a
     * parameter from the session, clients should explicitly set the parameter
     * value to null.
     * You can reference the session parameters in the agent with the following
     * format: $session.params.parameter-id.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getParameters(), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private java.lang.Object currentPage_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the [page][google.cloud.dialogflow.cx.v3.Page] to override the [current
     * page][QueryResult.current_page] in the session.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * If `current_page` is specified, the previous state of the session will be
     * ignored by Dialogflow, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters].
     * In most cases, [current_page][google.cloud.dialogflow.cx.v3.QueryParameters.current_page] and
     * [parameters][google.cloud.dialogflow.cx.v3.QueryParameters.parameters] should be configured together to
     * direct a session to a specific state.
     * </pre>
     *
     * <code>string current_page = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The currentPage.
     */
    public java.lang.String getCurrentPage() {
      java.lang.Object ref = currentPage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currentPage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the [page][google.cloud.dialogflow.cx.v3.Page] to override the [current
     * page][QueryResult.current_page] in the session.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * If `current_page` is specified, the previous state of the session will be
     * ignored by Dialogflow, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters].
     * In most cases, [current_page][google.cloud.dialogflow.cx.v3.QueryParameters.current_page] and
     * [parameters][google.cloud.dialogflow.cx.v3.QueryParameters.parameters] should be configured together to
     * direct a session to a specific state.
     * </pre>
     *
     * <code>string current_page = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for currentPage.
     */
    public com.google.protobuf.ByteString getCurrentPageBytes() {
      java.lang.Object ref = currentPage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currentPage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the [page][google.cloud.dialogflow.cx.v3.Page] to override the [current
     * page][QueryResult.current_page] in the session.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * If `current_page` is specified, the previous state of the session will be
     * ignored by Dialogflow, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters].
     * In most cases, [current_page][google.cloud.dialogflow.cx.v3.QueryParameters.current_page] and
     * [parameters][google.cloud.dialogflow.cx.v3.QueryParameters.parameters] should be configured together to
     * direct a session to a specific state.
     * </pre>
     *
     * <code>string current_page = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The currentPage to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentPage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      currentPage_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the [page][google.cloud.dialogflow.cx.v3.Page] to override the [current
     * page][QueryResult.current_page] in the session.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * If `current_page` is specified, the previous state of the session will be
     * ignored by Dialogflow, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters].
     * In most cases, [current_page][google.cloud.dialogflow.cx.v3.QueryParameters.current_page] and
     * [parameters][google.cloud.dialogflow.cx.v3.QueryParameters.parameters] should be configured together to
     * direct a session to a specific state.
     * </pre>
     *
     * <code>string current_page = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrentPage() {

      currentPage_ = getDefaultInstance().getCurrentPage();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the [page][google.cloud.dialogflow.cx.v3.Page] to override the [current
     * page][QueryResult.current_page] in the session.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * If `current_page` is specified, the previous state of the session will be
     * ignored by Dialogflow, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters].
     * In most cases, [current_page][google.cloud.dialogflow.cx.v3.QueryParameters.current_page] and
     * [parameters][google.cloud.dialogflow.cx.v3.QueryParameters.parameters] should be configured together to
     * direct a session to a specific state.
     * </pre>
     *
     * <code>string current_page = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for currentPage to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentPageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      currentPage_ = value;
      onChanged();
      return this;
    }

    private boolean disableWebhook_;
    /**
     *
     *
     * <pre>
     * Whether to disable webhook calls for this request.
     * </pre>
     *
     * <code>bool disable_webhook = 7;</code>
     *
     * @return The disableWebhook.
     */
    @java.lang.Override
    public boolean getDisableWebhook() {
      return disableWebhook_;
    }
    /**
     *
     *
     * <pre>
     * Whether to disable webhook calls for this request.
     * </pre>
     *
     * <code>bool disable_webhook = 7;</code>
     *
     * @param value The disableWebhook to set.
     * @return This builder for chaining.
     */
    public Builder setDisableWebhook(boolean value) {

      disableWebhook_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to disable webhook calls for this request.
     * </pre>
     *
     * <code>bool disable_webhook = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableWebhook() {

      disableWebhook_ = false;
      onChanged();
      return this;
    }

    private boolean analyzeQueryTextSentiment_;
    /**
     *
     *
     * <pre>
     * Configures whether sentiment analysis should be performed. If not
     * provided, sentiment analysis is not performed.
     * </pre>
     *
     * <code>bool analyze_query_text_sentiment = 8;</code>
     *
     * @return The analyzeQueryTextSentiment.
     */
    @java.lang.Override
    public boolean getAnalyzeQueryTextSentiment() {
      return analyzeQueryTextSentiment_;
    }
    /**
     *
     *
     * <pre>
     * Configures whether sentiment analysis should be performed. If not
     * provided, sentiment analysis is not performed.
     * </pre>
     *
     * <code>bool analyze_query_text_sentiment = 8;</code>
     *
     * @param value The analyzeQueryTextSentiment to set.
     * @return This builder for chaining.
     */
    public Builder setAnalyzeQueryTextSentiment(boolean value) {

      analyzeQueryTextSentiment_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures whether sentiment analysis should be performed. If not
     * provided, sentiment analysis is not performed.
     * </pre>
     *
     * <code>bool analyze_query_text_sentiment = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnalyzeQueryTextSentiment() {

      analyzeQueryTextSentiment_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> webhookHeaders_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetWebhookHeaders() {
      if (webhookHeaders_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            WebhookHeadersDefaultEntryHolder.defaultEntry);
      }
      return webhookHeaders_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableWebhookHeaders() {
      onChanged();
      ;
      if (webhookHeaders_ == null) {
        webhookHeaders_ =
            com.google.protobuf.MapField.newMapField(WebhookHeadersDefaultEntryHolder.defaultEntry);
      }
      if (!webhookHeaders_.isMutable()) {
        webhookHeaders_ = webhookHeaders_.copy();
      }
      return webhookHeaders_;
    }

    public int getWebhookHeadersCount() {
      return internalGetWebhookHeaders().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through Dialogflow web console. The headers defined
     * within this field will overwrite the headers configured through Dialogflow
     * console if there is a conflict. Header names are case-insensitive.
     * Google's specified headers are not allowed. Including: "Host",
     * "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
     * "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
     * </pre>
     *
     * <code>map&lt;string, string&gt; webhook_headers = 10;</code>
     */
    @java.lang.Override
    public boolean containsWebhookHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetWebhookHeaders().getMap().containsKey(key);
    }
    /** Use {@link #getWebhookHeadersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getWebhookHeaders() {
      return getWebhookHeadersMap();
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through Dialogflow web console. The headers defined
     * within this field will overwrite the headers configured through Dialogflow
     * console if there is a conflict. Header names are case-insensitive.
     * Google's specified headers are not allowed. Including: "Host",
     * "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
     * "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
     * </pre>
     *
     * <code>map&lt;string, string&gt; webhook_headers = 10;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getWebhookHeadersMap() {
      return internalGetWebhookHeaders().getMap();
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through Dialogflow web console. The headers defined
     * within this field will overwrite the headers configured through Dialogflow
     * console if there is a conflict. Header names are case-insensitive.
     * Google's specified headers are not allowed. Including: "Host",
     * "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
     * "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
     * </pre>
     *
     * <code>map&lt;string, string&gt; webhook_headers = 10;</code>
     */
    @java.lang.Override
    public java.lang.String getWebhookHeadersOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetWebhookHeaders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through Dialogflow web console. The headers defined
     * within this field will overwrite the headers configured through Dialogflow
     * console if there is a conflict. Header names are case-insensitive.
     * Google's specified headers are not allowed. Including: "Host",
     * "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
     * "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
     * </pre>
     *
     * <code>map&lt;string, string&gt; webhook_headers = 10;</code>
     */
    @java.lang.Override
    public java.lang.String getWebhookHeadersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetWebhookHeaders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearWebhookHeaders() {
      internalGetMutableWebhookHeaders().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through Dialogflow web console. The headers defined
     * within this field will overwrite the headers configured through Dialogflow
     * console if there is a conflict. Header names are case-insensitive.
     * Google's specified headers are not allowed. Including: "Host",
     * "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
     * "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
     * </pre>
     *
     * <code>map&lt;string, string&gt; webhook_headers = 10;</code>
     */
    public Builder removeWebhookHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableWebhookHeaders().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableWebhookHeaders() {
      return internalGetMutableWebhookHeaders().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through Dialogflow web console. The headers defined
     * within this field will overwrite the headers configured through Dialogflow
     * console if there is a conflict. Header names are case-insensitive.
     * Google's specified headers are not allowed. Including: "Host",
     * "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
     * "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
     * </pre>
     *
     * <code>map&lt;string, string&gt; webhook_headers = 10;</code>
     */
    public Builder putWebhookHeaders(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableWebhookHeaders().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through Dialogflow web console. The headers defined
     * within this field will overwrite the headers configured through Dialogflow
     * console if there is a conflict. Header names are case-insensitive.
     * Google's specified headers are not allowed. Including: "Host",
     * "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
     * "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
     * </pre>
     *
     * <code>map&lt;string, string&gt; webhook_headers = 10;</code>
     */
    public Builder putAllWebhookHeaders(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableWebhookHeaders().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.LazyStringList flowVersions_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureFlowVersionsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        flowVersions_ = new com.google.protobuf.LazyStringArrayList(flowVersions_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of flow versions to override for the request.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
     * If version 1 of flow X is included in this list, the traffic of
     * flow X will go through version 1 regardless of the version configuration in
     * the environment. Each flow can have at most one version specified in this
     * list.
     * </pre>
     *
     * <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return A list containing the flowVersions.
     */
    public com.google.protobuf.ProtocolStringList getFlowVersionsList() {
      return flowVersions_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of flow versions to override for the request.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
     * If version 1 of flow X is included in this list, the traffic of
     * flow X will go through version 1 regardless of the version configuration in
     * the environment. Each flow can have at most one version specified in this
     * list.
     * </pre>
     *
     * <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The count of flowVersions.
     */
    public int getFlowVersionsCount() {
      return flowVersions_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of flow versions to override for the request.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
     * If version 1 of flow X is included in this list, the traffic of
     * flow X will go through version 1 regardless of the version configuration in
     * the environment. Each flow can have at most one version specified in this
     * list.
     * </pre>
     *
     * <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the element to return.
     * @return The flowVersions at the given index.
     */
    public java.lang.String getFlowVersions(int index) {
      return flowVersions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of flow versions to override for the request.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
     * If version 1 of flow X is included in this list, the traffic of
     * flow X will go through version 1 regardless of the version configuration in
     * the environment. Each flow can have at most one version specified in this
     * list.
     * </pre>
     *
     * <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the flowVersions at the given index.
     */
    public com.google.protobuf.ByteString getFlowVersionsBytes(int index) {
      return flowVersions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of flow versions to override for the request.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
     * If version 1 of flow X is included in this list, the traffic of
     * flow X will go through version 1 regardless of the version configuration in
     * the environment. Each flow can have at most one version specified in this
     * list.
     * </pre>
     *
     * <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index to set the value at.
     * @param value The flowVersions to set.
     * @return This builder for chaining.
     */
    public Builder setFlowVersions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFlowVersionsIsMutable();
      flowVersions_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of flow versions to override for the request.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
     * If version 1 of flow X is included in this list, the traffic of
     * flow X will go through version 1 regardless of the version configuration in
     * the environment. Each flow can have at most one version specified in this
     * list.
     * </pre>
     *
     * <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The flowVersions to add.
     * @return This builder for chaining.
     */
    public Builder addFlowVersions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFlowVersionsIsMutable();
      flowVersions_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of flow versions to override for the request.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
     * If version 1 of flow X is included in this list, the traffic of
     * flow X will go through version 1 regardless of the version configuration in
     * the environment. Each flow can have at most one version specified in this
     * list.
     * </pre>
     *
     * <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param values The flowVersions to add.
     * @return This builder for chaining.
     */
    public Builder addAllFlowVersions(java.lang.Iterable<java.lang.String> values) {
      ensureFlowVersionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, flowVersions_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of flow versions to override for the request.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
     * If version 1 of flow X is included in this list, the traffic of
     * flow X will go through version 1 regardless of the version configuration in
     * the environment. Each flow can have at most one version specified in this
     * list.
     * </pre>
     *
     * <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFlowVersions() {
      flowVersions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of flow versions to override for the request.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
     * If version 1 of flow X is included in this list, the traffic of
     * flow X will go through version 1 regardless of the version configuration in
     * the environment. Each flow can have at most one version specified in this
     * list.
     * </pre>
     *
     * <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes of the flowVersions to add.
     * @return This builder for chaining.
     */
    public Builder addFlowVersionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFlowVersionsIsMutable();
      flowVersions_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.QueryParameters)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.QueryParameters)
  private static final com.google.cloud.dialogflow.cx.v3.QueryParameters DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.QueryParameters();
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryParameters getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QueryParameters> PARSER =
      new com.google.protobuf.AbstractParser<QueryParameters>() {
        @java.lang.Override
        public QueryParameters parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QueryParameters> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QueryParameters> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.QueryParameters getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
