/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/webhook.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Represents page information communicated to and from the webhook.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.PageInfo}
 */
public final class PageInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.PageInfo)
    PageInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PageInfo.newBuilder() to construct.
  private PageInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PageInfo() {
    currentPage_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PageInfo();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.WebhookProto
        .internal_static_google_cloud_dialogflow_cx_v3_PageInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.WebhookProto
        .internal_static_google_cloud_dialogflow_cx_v3_PageInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.PageInfo.class,
            com.google.cloud.dialogflow.cx.v3.PageInfo.Builder.class);
  }

  public interface FormInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.PageInfo.FormInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The parameters contained in the form. Note that the webhook cannot add
     * or remove any form parameter.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
     * </code>
     */
    java.util.List<com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo>
        getParameterInfoList();
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The parameters contained in the form. Note that the webhook cannot add
     * or remove any form parameter.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo getParameterInfo(int index);
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The parameters contained in the form. Note that the webhook cannot add
     * or remove any form parameter.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
     * </code>
     */
    int getParameterInfoCount();
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The parameters contained in the form. Note that the webhook cannot add
     * or remove any form parameter.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfoOrBuilder>
        getParameterInfoOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The parameters contained in the form. Note that the webhook cannot add
     * or remove any form parameter.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfoOrBuilder
        getParameterInfoOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Represents form information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.PageInfo.FormInfo}
   */
  public static final class FormInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.PageInfo.FormInfo)
      FormInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FormInfo.newBuilder() to construct.
    private FormInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FormInfo() {
      parameterInfo_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FormInfo();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_PageInfo_FormInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_PageInfo_FormInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.class,
              com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.Builder.class);
    }

    public interface ParameterInfoOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
       * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The human-readable name of the parameter, unique within the form. This
       * field cannot be modified by the webhook.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The displayName.
       */
      java.lang.String getDisplayName();
      /**
       *
       *
       * <pre>
       * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
       * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The human-readable name of the parameter, unique within the form. This
       * field cannot be modified by the webhook.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The bytes for displayName.
       */
      com.google.protobuf.ByteString getDisplayNameBytes();

      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * Indicates whether the parameter is required. Optional parameters will
       * not trigger prompts; however, they are filled if the user specifies
       * them. Required parameters must be filled before form filling concludes.
       * </pre>
       *
       * <code>bool required = 2;</code>
       *
       * @return The required.
       */
      boolean getRequired();

      /**
       *
       *
       * <pre>
       * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
       * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. The state of the parameter. This field can be set
       * to [INVALID][google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState.INVALID] by
       * the webhook to invalidate the parameter; other values set by the
       * webhook will be ignored.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState state = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      int getStateValue();
      /**
       *
       *
       * <pre>
       * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
       * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. The state of the parameter. This field can be set
       * to [INVALID][google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState.INVALID] by
       * the webhook to invalidate the parameter; other values set by the
       * webhook will be ignored.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState state = 3;
       * </code>
       *
       * @return The state.
       */
      com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState getState();

      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The value of the parameter. This field can be set by the webhook to
       * change the parameter value.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 4;</code>
       *
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The value of the parameter. This field can be set by the webhook to
       * change the parameter value.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 4;</code>
       *
       * @return The value.
       */
      com.google.protobuf.Value getValue();
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The value of the parameter. This field can be set by the webhook to
       * change the parameter value.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 4;</code>
       */
      com.google.protobuf.ValueOrBuilder getValueOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * Indicates if the parameter value was just collected on the last
       * conversation turn.
       * </pre>
       *
       * <code>bool just_collected = 5;</code>
       *
       * @return The justCollected.
       */
      boolean getJustCollected();
    }
    /**
     *
     *
     * <pre>
     * Represents parameter information.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo}
     */
    public static final class ParameterInfo extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo)
        ParameterInfoOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ParameterInfo.newBuilder() to construct.
      private ParameterInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ParameterInfo() {
        displayName_ = "";
        state_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ParameterInfo();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_PageInfo_FormInfo_ParameterInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_PageInfo_FormInfo_ParameterInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.class,
                com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Represents the state of a parameter.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState}
       */
      public enum ParameterState implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Not specified. This value should be never used.
         * </pre>
         *
         * <code>PARAMETER_STATE_UNSPECIFIED = 0;</code>
         */
        PARAMETER_STATE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Indicates that the parameter does not have a value.
         * </pre>
         *
         * <code>EMPTY = 1;</code>
         */
        EMPTY(1),
        /**
         *
         *
         * <pre>
         * Indicates that the parameter value is invalid. This field can be used
         * by the webhook to invalidate the parameter and ask the server to
         * collect it from the user again.
         * </pre>
         *
         * <code>INVALID = 2;</code>
         */
        INVALID(2),
        /**
         *
         *
         * <pre>
         * Indicates that the parameter has a value.
         * </pre>
         *
         * <code>FILLED = 3;</code>
         */
        FILLED(3),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Not specified. This value should be never used.
         * </pre>
         *
         * <code>PARAMETER_STATE_UNSPECIFIED = 0;</code>
         */
        public static final int PARAMETER_STATE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Indicates that the parameter does not have a value.
         * </pre>
         *
         * <code>EMPTY = 1;</code>
         */
        public static final int EMPTY_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Indicates that the parameter value is invalid. This field can be used
         * by the webhook to invalidate the parameter and ask the server to
         * collect it from the user again.
         * </pre>
         *
         * <code>INVALID = 2;</code>
         */
        public static final int INVALID_VALUE = 2;
        /**
         *
         *
         * <pre>
         * Indicates that the parameter has a value.
         * </pre>
         *
         * <code>FILLED = 3;</code>
         */
        public static final int FILLED_VALUE = 3;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ParameterState valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static ParameterState forNumber(int value) {
          switch (value) {
            case 0:
              return PARAMETER_STATE_UNSPECIFIED;
            case 1:
              return EMPTY;
            case 2:
              return INVALID;
            case 3:
              return FILLED;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<ParameterState>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<ParameterState>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<ParameterState>() {
                  public ParameterState findValueByNumber(int number) {
                    return ParameterState.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final ParameterState[] VALUES = values();

        public static ParameterState valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private ParameterState(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState)
      }

      public static final int DISPLAY_NAME_FIELD_NUMBER = 1;
      private volatile java.lang.Object displayName_;
      /**
       *
       *
       * <pre>
       * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
       * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The human-readable name of the parameter, unique within the form. This
       * field cannot be modified by the webhook.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The displayName.
       */
      @java.lang.Override
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
       * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The human-readable name of the parameter, unique within the form. This
       * field cannot be modified by the webhook.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The bytes for displayName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int REQUIRED_FIELD_NUMBER = 2;
      private boolean required_;
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * Indicates whether the parameter is required. Optional parameters will
       * not trigger prompts; however, they are filled if the user specifies
       * them. Required parameters must be filled before form filling concludes.
       * </pre>
       *
       * <code>bool required = 2;</code>
       *
       * @return The required.
       */
      @java.lang.Override
      public boolean getRequired() {
        return required_;
      }

      public static final int STATE_FIELD_NUMBER = 3;
      private int state_;
      /**
       *
       *
       * <pre>
       * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
       * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. The state of the parameter. This field can be set
       * to [INVALID][google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState.INVALID] by
       * the webhook to invalidate the parameter; other values set by the
       * webhook will be ignored.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState state = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
       * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. The state of the parameter. This field can be set
       * to [INVALID][google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState.INVALID] by
       * the webhook to invalidate the parameter; other values set by the
       * webhook will be ignored.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState state = 3;
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState
          getState() {
        @SuppressWarnings("deprecation")
        com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState result =
            com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState
                .valueOf(state_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState
                .UNRECOGNIZED
            : result;
      }

      public static final int VALUE_FIELD_NUMBER = 4;
      private com.google.protobuf.Value value_;
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The value of the parameter. This field can be set by the webhook to
       * change the parameter value.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 4;</code>
       *
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return value_ != null;
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The value of the parameter. This field can be set by the webhook to
       * change the parameter value.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 4;</code>
       *
       * @return The value.
       */
      @java.lang.Override
      public com.google.protobuf.Value getValue() {
        return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The value of the parameter. This field can be set by the webhook to
       * change the parameter value.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 4;</code>
       */
      @java.lang.Override
      public com.google.protobuf.ValueOrBuilder getValueOrBuilder() {
        return getValue();
      }

      public static final int JUST_COLLECTED_FIELD_NUMBER = 5;
      private boolean justCollected_;
      /**
       *
       *
       * <pre>
       * Optional for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * Indicates if the parameter value was just collected on the last
       * conversation turn.
       * </pre>
       *
       * <code>bool just_collected = 5;</code>
       *
       * @return The justCollected.
       */
      @java.lang.Override
      public boolean getJustCollected() {
        return justCollected_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
        }
        if (required_ != false) {
          output.writeBool(2, required_);
        }
        if (state_
            != com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState
                .PARAMETER_STATE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(3, state_);
        }
        if (value_ != null) {
          output.writeMessage(4, getValue());
        }
        if (justCollected_ != false) {
          output.writeBool(5, justCollected_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
        }
        if (required_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, required_);
        }
        if (state_
            != com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState
                .PARAMETER_STATE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
        }
        if (value_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getValue());
        }
        if (justCollected_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, justCollected_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo other =
            (com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo) obj;

        if (!getDisplayName().equals(other.getDisplayName())) return false;
        if (getRequired() != other.getRequired()) return false;
        if (state_ != other.state_) return false;
        if (hasValue() != other.hasValue()) return false;
        if (hasValue()) {
          if (!getValue().equals(other.getValue())) return false;
        }
        if (getJustCollected() != other.getJustCollected()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getDisplayName().hashCode();
        hash = (37 * hash) + REQUIRED_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRequired());
        hash = (37 * hash) + STATE_FIELD_NUMBER;
        hash = (53 * hash) + state_;
        if (hasValue()) {
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getValue().hashCode();
        }
        hash = (37 * hash) + JUST_COLLECTED_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getJustCollected());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Represents parameter information.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo)
          com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfoOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3.WebhookProto
              .internal_static_google_cloud_dialogflow_cx_v3_PageInfo_FormInfo_ParameterInfo_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3.WebhookProto
              .internal_static_google_cloud_dialogflow_cx_v3_PageInfo_FormInfo_ParameterInfo_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.class,
                  com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          displayName_ = "";

          required_ = false;

          state_ = 0;

          if (valueBuilder_ == null) {
            value_ = null;
          } else {
            value_ = null;
            valueBuilder_ = null;
          }
          justCollected_ = false;

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3.WebhookProto
              .internal_static_google_cloud_dialogflow_cx_v3_PageInfo_FormInfo_ParameterInfo_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo build() {
          com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo buildPartial() {
          com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo result =
              new com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo(this);
          result.displayName_ = displayName_;
          result.required_ = required_;
          result.state_ = state_;
          if (valueBuilder_ == null) {
            result.value_ = value_;
          } else {
            result.value_ = valueBuilder_.build();
          }
          result.justCollected_ = justCollected_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo
                  .getDefaultInstance()) return this;
          if (!other.getDisplayName().isEmpty()) {
            displayName_ = other.displayName_;
            onChanged();
          }
          if (other.getRequired() != false) {
            setRequired(other.getRequired());
          }
          if (other.state_ != 0) {
            setStateValue(other.getStateValue());
          }
          if (other.hasValue()) {
            mergeValue(other.getValue());
          }
          if (other.getJustCollected() != false) {
            setJustCollected(other.getJustCollected());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    displayName_ = input.readStringRequireUtf8();

                    break;
                  } // case 10
                case 16:
                  {
                    required_ = input.readBool();

                    break;
                  } // case 16
                case 24:
                  {
                    state_ = input.readEnum();

                    break;
                  } // case 24
                case 34:
                  {
                    input.readMessage(getValueFieldBuilder().getBuilder(), extensionRegistry);

                    break;
                  } // case 34
                case 40:
                  {
                    justCollected_ = input.readBool();

                    break;
                  } // case 40
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private java.lang.Object displayName_ = "";
        /**
         *
         *
         * <pre>
         * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
         * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * The human-readable name of the parameter, unique within the form. This
         * field cannot be modified by the webhook.
         * </pre>
         *
         * <code>string display_name = 1;</code>
         *
         * @return The displayName.
         */
        public java.lang.String getDisplayName() {
          java.lang.Object ref = displayName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            displayName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
         * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * The human-readable name of the parameter, unique within the form. This
         * field cannot be modified by the webhook.
         * </pre>
         *
         * <code>string display_name = 1;</code>
         *
         * @return The bytes for displayName.
         */
        public com.google.protobuf.ByteString getDisplayNameBytes() {
          java.lang.Object ref = displayName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            displayName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
         * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * The human-readable name of the parameter, unique within the form. This
         * field cannot be modified by the webhook.
         * </pre>
         *
         * <code>string display_name = 1;</code>
         *
         * @param value The displayName to set.
         * @return This builder for chaining.
         */
        public Builder setDisplayName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          displayName_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
         * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * The human-readable name of the parameter, unique within the form. This
         * field cannot be modified by the webhook.
         * </pre>
         *
         * <code>string display_name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDisplayName() {

          displayName_ = getDefaultInstance().getDisplayName();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
         * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * The human-readable name of the parameter, unique within the form. This
         * field cannot be modified by the webhook.
         * </pre>
         *
         * <code>string display_name = 1;</code>
         *
         * @param value The bytes for displayName to set.
         * @return This builder for chaining.
         */
        public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          displayName_ = value;
          onChanged();
          return this;
        }

        private boolean required_;
        /**
         *
         *
         * <pre>
         * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * Indicates whether the parameter is required. Optional parameters will
         * not trigger prompts; however, they are filled if the user specifies
         * them. Required parameters must be filled before form filling concludes.
         * </pre>
         *
         * <code>bool required = 2;</code>
         *
         * @return The required.
         */
        @java.lang.Override
        public boolean getRequired() {
          return required_;
        }
        /**
         *
         *
         * <pre>
         * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * Indicates whether the parameter is required. Optional parameters will
         * not trigger prompts; however, they are filled if the user specifies
         * them. Required parameters must be filled before form filling concludes.
         * </pre>
         *
         * <code>bool required = 2;</code>
         *
         * @param value The required to set.
         * @return This builder for chaining.
         */
        public Builder setRequired(boolean value) {

          required_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * Indicates whether the parameter is required. Optional parameters will
         * not trigger prompts; however, they are filled if the user specifies
         * them. Required parameters must be filled before form filling concludes.
         * </pre>
         *
         * <code>bool required = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRequired() {

          required_ = false;
          onChanged();
          return this;
        }

        private int state_ = 0;
        /**
         *
         *
         * <pre>
         * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
         * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. The state of the parameter. This field can be set
         * to [INVALID][google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState.INVALID] by
         * the webhook to invalidate the parameter; other values set by the
         * webhook will be ignored.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState state = 3;
         * </code>
         *
         * @return The enum numeric value on the wire for state.
         */
        @java.lang.Override
        public int getStateValue() {
          return state_;
        }
        /**
         *
         *
         * <pre>
         * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
         * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. The state of the parameter. This field can be set
         * to [INVALID][google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState.INVALID] by
         * the webhook to invalidate the parameter; other values set by the
         * webhook will be ignored.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState state = 3;
         * </code>
         *
         * @param value The enum numeric value on the wire for state to set.
         * @return This builder for chaining.
         */
        public Builder setStateValue(int value) {

          state_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
         * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. The state of the parameter. This field can be set
         * to [INVALID][google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState.INVALID] by
         * the webhook to invalidate the parameter; other values set by the
         * webhook will be ignored.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState state = 3;
         * </code>
         *
         * @return The state.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState
            getState() {
          @SuppressWarnings("deprecation")
          com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState result =
              com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState
                  .valueOf(state_);
          return result == null
              ? com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState
                  .UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
         * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. The state of the parameter. This field can be set
         * to [INVALID][google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState.INVALID] by
         * the webhook to invalidate the parameter; other values set by the
         * webhook will be ignored.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState state = 3;
         * </code>
         *
         * @param value The state to set.
         * @return This builder for chaining.
         */
        public Builder setState(
            com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState
                value) {
          if (value == null) {
            throw new NullPointerException();
          }

          state_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Required for
         * [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. The state of the parameter. This field can be set
         * to [INVALID][google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState.INVALID] by
         * the webhook to invalidate the parameter; other values set by the
         * webhook will be ignored.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState state = 3;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearState() {

          state_ = 0;
          onChanged();
          return this;
        }

        private com.google.protobuf.Value value_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>
            valueBuilder_;
        /**
         *
         *
         * <pre>
         * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * The value of the parameter. This field can be set by the webhook to
         * change the parameter value.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 4;</code>
         *
         * @return Whether the value field is set.
         */
        public boolean hasValue() {
          return valueBuilder_ != null || value_ != null;
        }
        /**
         *
         *
         * <pre>
         * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * The value of the parameter. This field can be set by the webhook to
         * change the parameter value.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 4;</code>
         *
         * @return The value.
         */
        public com.google.protobuf.Value getValue() {
          if (valueBuilder_ == null) {
            return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
          } else {
            return valueBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * The value of the parameter. This field can be set by the webhook to
         * change the parameter value.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 4;</code>
         */
        public Builder setValue(com.google.protobuf.Value value) {
          if (valueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            value_ = value;
            onChanged();
          } else {
            valueBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * The value of the parameter. This field can be set by the webhook to
         * change the parameter value.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 4;</code>
         */
        public Builder setValue(com.google.protobuf.Value.Builder builderForValue) {
          if (valueBuilder_ == null) {
            value_ = builderForValue.build();
            onChanged();
          } else {
            valueBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * The value of the parameter. This field can be set by the webhook to
         * change the parameter value.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 4;</code>
         */
        public Builder mergeValue(com.google.protobuf.Value value) {
          if (valueBuilder_ == null) {
            if (value_ != null) {
              value_ = com.google.protobuf.Value.newBuilder(value_).mergeFrom(value).buildPartial();
            } else {
              value_ = value;
            }
            onChanged();
          } else {
            valueBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * The value of the parameter. This field can be set by the webhook to
         * change the parameter value.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 4;</code>
         */
        public Builder clearValue() {
          if (valueBuilder_ == null) {
            value_ = null;
            onChanged();
          } else {
            value_ = null;
            valueBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * The value of the parameter. This field can be set by the webhook to
         * change the parameter value.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 4;</code>
         */
        public com.google.protobuf.Value.Builder getValueBuilder() {

          onChanged();
          return getValueFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * The value of the parameter. This field can be set by the webhook to
         * change the parameter value.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 4;</code>
         */
        public com.google.protobuf.ValueOrBuilder getValueOrBuilder() {
          if (valueBuilder_ != null) {
            return valueBuilder_.getMessageOrBuilder();
          } else {
            return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * The value of the parameter. This field can be set by the webhook to
         * change the parameter value.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 4;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>
            getValueFieldBuilder() {
          if (valueBuilder_ == null) {
            valueBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Value,
                    com.google.protobuf.Value.Builder,
                    com.google.protobuf.ValueOrBuilder>(
                    getValue(), getParentForChildren(), isClean());
            value_ = null;
          }
          return valueBuilder_;
        }

        private boolean justCollected_;
        /**
         *
         *
         * <pre>
         * Optional for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * Indicates if the parameter value was just collected on the last
         * conversation turn.
         * </pre>
         *
         * <code>bool just_collected = 5;</code>
         *
         * @return The justCollected.
         */
        @java.lang.Override
        public boolean getJustCollected() {
          return justCollected_;
        }
        /**
         *
         *
         * <pre>
         * Optional for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * Indicates if the parameter value was just collected on the last
         * conversation turn.
         * </pre>
         *
         * <code>bool just_collected = 5;</code>
         *
         * @param value The justCollected to set.
         * @return This builder for chaining.
         */
        public Builder setJustCollected(boolean value) {

          justCollected_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
         * Indicates if the parameter value was just collected on the last
         * conversation turn.
         * </pre>
         *
         * <code>bool just_collected = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearJustCollected() {

          justCollected_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo)
      private static final com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo();
      }

      public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ParameterInfo> PARSER =
          new com.google.protobuf.AbstractParser<ParameterInfo>() {
            @java.lang.Override
            public ParameterInfo parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ParameterInfo> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ParameterInfo> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int PARAMETER_INFO_FIELD_NUMBER = 2;
    private java.util.List<com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo>
        parameterInfo_;
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The parameters contained in the form. Note that the webhook cannot add
     * or remove any form parameter.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo>
        getParameterInfoList() {
      return parameterInfo_;
    }
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The parameters contained in the form. Note that the webhook cannot add
     * or remove any form parameter.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfoOrBuilder>
        getParameterInfoOrBuilderList() {
      return parameterInfo_;
    }
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The parameters contained in the form. Note that the webhook cannot add
     * or remove any form parameter.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
     * </code>
     */
    @java.lang.Override
    public int getParameterInfoCount() {
      return parameterInfo_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The parameters contained in the form. Note that the webhook cannot add
     * or remove any form parameter.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo getParameterInfo(
        int index) {
      return parameterInfo_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The parameters contained in the form. Note that the webhook cannot add
     * or remove any form parameter.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfoOrBuilder
        getParameterInfoOrBuilder(int index) {
      return parameterInfo_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < parameterInfo_.size(); i++) {
        output.writeMessage(2, parameterInfo_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < parameterInfo_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, parameterInfo_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo other =
          (com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo) obj;

      if (!getParameterInfoList().equals(other.getParameterInfoList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getParameterInfoCount() > 0) {
        hash = (37 * hash) + PARAMETER_INFO_FIELD_NUMBER;
        hash = (53 * hash) + getParameterInfoList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents form information.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.PageInfo.FormInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.PageInfo.FormInfo)
        com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_PageInfo_FormInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_PageInfo_FormInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.class,
                com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (parameterInfoBuilder_ == null) {
          parameterInfo_ = java.util.Collections.emptyList();
        } else {
          parameterInfo_ = null;
          parameterInfoBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3_PageInfo_FormInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo build() {
        com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo buildPartial() {
        com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo result =
            new com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo(this);
        int from_bitField0_ = bitField0_;
        if (parameterInfoBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            parameterInfo_ = java.util.Collections.unmodifiableList(parameterInfo_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.parameterInfo_ = parameterInfo_;
        } else {
          result.parameterInfo_ = parameterInfoBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo other) {
        if (other == com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.getDefaultInstance())
          return this;
        if (parameterInfoBuilder_ == null) {
          if (!other.parameterInfo_.isEmpty()) {
            if (parameterInfo_.isEmpty()) {
              parameterInfo_ = other.parameterInfo_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureParameterInfoIsMutable();
              parameterInfo_.addAll(other.parameterInfo_);
            }
            onChanged();
          }
        } else {
          if (!other.parameterInfo_.isEmpty()) {
            if (parameterInfoBuilder_.isEmpty()) {
              parameterInfoBuilder_.dispose();
              parameterInfoBuilder_ = null;
              parameterInfo_ = other.parameterInfo_;
              bitField0_ = (bitField0_ & ~0x00000001);
              parameterInfoBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getParameterInfoFieldBuilder()
                      : null;
            } else {
              parameterInfoBuilder_.addAllMessages(other.parameterInfo_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo m =
                      input.readMessage(
                          com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo
                              .parser(),
                          extensionRegistry);
                  if (parameterInfoBuilder_ == null) {
                    ensureParameterInfoIsMutable();
                    parameterInfo_.add(m);
                  } else {
                    parameterInfoBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo>
          parameterInfo_ = java.util.Collections.emptyList();

      private void ensureParameterInfoIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          parameterInfo_ =
              new java.util.ArrayList<
                  com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo>(
                  parameterInfo_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo,
              com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.Builder,
              com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfoOrBuilder>
          parameterInfoBuilder_;

      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo>
          getParameterInfoList() {
        if (parameterInfoBuilder_ == null) {
          return java.util.Collections.unmodifiableList(parameterInfo_);
        } else {
          return parameterInfoBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public int getParameterInfoCount() {
        if (parameterInfoBuilder_ == null) {
          return parameterInfo_.size();
        } else {
          return parameterInfoBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo getParameterInfo(
          int index) {
        if (parameterInfoBuilder_ == null) {
          return parameterInfo_.get(index);
        } else {
          return parameterInfoBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public Builder setParameterInfo(
          int index, com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo value) {
        if (parameterInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParameterInfoIsMutable();
          parameterInfo_.set(index, value);
          onChanged();
        } else {
          parameterInfoBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public Builder setParameterInfo(
          int index,
          com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.Builder
              builderForValue) {
        if (parameterInfoBuilder_ == null) {
          ensureParameterInfoIsMutable();
          parameterInfo_.set(index, builderForValue.build());
          onChanged();
        } else {
          parameterInfoBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public Builder addParameterInfo(
          com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo value) {
        if (parameterInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParameterInfoIsMutable();
          parameterInfo_.add(value);
          onChanged();
        } else {
          parameterInfoBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public Builder addParameterInfo(
          int index, com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo value) {
        if (parameterInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParameterInfoIsMutable();
          parameterInfo_.add(index, value);
          onChanged();
        } else {
          parameterInfoBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public Builder addParameterInfo(
          com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.Builder
              builderForValue) {
        if (parameterInfoBuilder_ == null) {
          ensureParameterInfoIsMutable();
          parameterInfo_.add(builderForValue.build());
          onChanged();
        } else {
          parameterInfoBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public Builder addParameterInfo(
          int index,
          com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.Builder
              builderForValue) {
        if (parameterInfoBuilder_ == null) {
          ensureParameterInfoIsMutable();
          parameterInfo_.add(index, builderForValue.build());
          onChanged();
        } else {
          parameterInfoBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public Builder addAllParameterInfo(
          java.lang.Iterable<
                  ? extends com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo>
              values) {
        if (parameterInfoBuilder_ == null) {
          ensureParameterInfoIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parameterInfo_);
          onChanged();
        } else {
          parameterInfoBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public Builder clearParameterInfo() {
        if (parameterInfoBuilder_ == null) {
          parameterInfo_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          parameterInfoBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public Builder removeParameterInfo(int index) {
        if (parameterInfoBuilder_ == null) {
          ensureParameterInfoIsMutable();
          parameterInfo_.remove(index);
          onChanged();
        } else {
          parameterInfoBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.Builder
          getParameterInfoBuilder(int index) {
        return getParameterInfoFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfoOrBuilder
          getParameterInfoOrBuilder(int index) {
        if (parameterInfoBuilder_ == null) {
          return parameterInfo_.get(index);
        } else {
          return parameterInfoBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfoOrBuilder>
          getParameterInfoOrBuilderList() {
        if (parameterInfoBuilder_ != null) {
          return parameterInfoBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(parameterInfo_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.Builder
          addParameterInfoBuilder() {
        return getParameterInfoFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.Builder
          addParameterInfoBuilder(int index) {
        return getParameterInfoFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
       * The parameters contained in the form. Note that the webhook cannot add
       * or remove any form parameter.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo parameter_info = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.Builder>
          getParameterInfoBuilderList() {
        return getParameterInfoFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo,
              com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.Builder,
              com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfoOrBuilder>
          getParameterInfoFieldBuilder() {
        if (parameterInfoBuilder_ == null) {
          parameterInfoBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo,
                  com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.Builder,
                  com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfoOrBuilder>(
                  parameterInfo_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          parameterInfo_ = null;
        }
        return parameterInfoBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.PageInfo.FormInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.PageInfo.FormInfo)
    private static final com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo();
    }

    public static com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FormInfo> PARSER =
        new com.google.protobuf.AbstractParser<FormInfo>() {
          @java.lang.Override
          public FormInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FormInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FormInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CURRENT_PAGE_FIELD_NUMBER = 1;
  private volatile java.lang.Object currentPage_;
  /**
   *
   *
   * <pre>
   * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
   * The unique identifier of the current page.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
   * </pre>
   *
   * <code>string current_page = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The currentPage.
   */
  @java.lang.Override
  public java.lang.String getCurrentPage() {
    java.lang.Object ref = currentPage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currentPage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
   * The unique identifier of the current page.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
   * </pre>
   *
   * <code>string current_page = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for currentPage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCurrentPageBytes() {
    java.lang.Object ref = currentPage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      currentPage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 4;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
   * The display name of the current page.
   * </pre>
   *
   * <code>string display_name = 4;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
   * The display name of the current page.
   * </pre>
   *
   * <code>string display_name = 4;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FORM_INFO_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo formInfo_;
  /**
   *
   *
   * <pre>
   * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
   * Information about the form.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo form_info = 3;</code>
   *
   * @return Whether the formInfo field is set.
   */
  @java.lang.Override
  public boolean hasFormInfo() {
    return formInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
   * Information about the form.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo form_info = 3;</code>
   *
   * @return The formInfo.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo getFormInfo() {
    return formInfo_ == null
        ? com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.getDefaultInstance()
        : formInfo_;
  }
  /**
   *
   *
   * <pre>
   * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
   * Information about the form.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo form_info = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfoOrBuilder getFormInfoOrBuilder() {
    return getFormInfo();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentPage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, currentPage_);
    }
    if (formInfo_ != null) {
      output.writeMessage(3, getFormInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentPage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, currentPage_);
    }
    if (formInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getFormInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.PageInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.PageInfo other =
        (com.google.cloud.dialogflow.cx.v3.PageInfo) obj;

    if (!getCurrentPage().equals(other.getCurrentPage())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasFormInfo() != other.hasFormInfo()) return false;
    if (hasFormInfo()) {
      if (!getFormInfo().equals(other.getFormInfo())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CURRENT_PAGE_FIELD_NUMBER;
    hash = (53 * hash) + getCurrentPage().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasFormInfo()) {
      hash = (37 * hash) + FORM_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getFormInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.PageInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.PageInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.PageInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.PageInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.PageInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.PageInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.PageInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.PageInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.PageInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.PageInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.PageInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.PageInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.PageInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents page information communicated to and from the webhook.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.PageInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.PageInfo)
      com.google.cloud.dialogflow.cx.v3.PageInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_PageInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_PageInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.PageInfo.class,
              com.google.cloud.dialogflow.cx.v3.PageInfo.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.PageInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      currentPage_ = "";

      displayName_ = "";

      if (formInfoBuilder_ == null) {
        formInfo_ = null;
      } else {
        formInfo_ = null;
        formInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3_PageInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.PageInfo getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.PageInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.PageInfo build() {
      com.google.cloud.dialogflow.cx.v3.PageInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.PageInfo buildPartial() {
      com.google.cloud.dialogflow.cx.v3.PageInfo result =
          new com.google.cloud.dialogflow.cx.v3.PageInfo(this);
      result.currentPage_ = currentPage_;
      result.displayName_ = displayName_;
      if (formInfoBuilder_ == null) {
        result.formInfo_ = formInfo_;
      } else {
        result.formInfo_ = formInfoBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.PageInfo) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.PageInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.PageInfo other) {
      if (other == com.google.cloud.dialogflow.cx.v3.PageInfo.getDefaultInstance()) return this;
      if (!other.getCurrentPage().isEmpty()) {
        currentPage_ = other.currentPage_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.hasFormInfo()) {
        mergeFormInfo(other.getFormInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                currentPage_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 26:
              {
                input.readMessage(getFormInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object currentPage_ = "";
    /**
     *
     *
     * <pre>
     * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The unique identifier of the current page.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string current_page = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The currentPage.
     */
    public java.lang.String getCurrentPage() {
      java.lang.Object ref = currentPage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currentPage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The unique identifier of the current page.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string current_page = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for currentPage.
     */
    public com.google.protobuf.ByteString getCurrentPageBytes() {
      java.lang.Object ref = currentPage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currentPage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The unique identifier of the current page.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string current_page = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The currentPage to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentPage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      currentPage_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The unique identifier of the current page.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string current_page = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrentPage() {

      currentPage_ = getDefaultInstance().getCurrentPage();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The unique identifier of the current page.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string current_page = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for currentPage to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentPageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      currentPage_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The display name of the current page.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The display name of the current page.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The display name of the current page.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The display name of the current page.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Always present for [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * The display name of the current page.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo formInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo,
            com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.Builder,
            com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfoOrBuilder>
        formInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * Information about the form.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo form_info = 3;</code>
     *
     * @return Whether the formInfo field is set.
     */
    public boolean hasFormInfo() {
      return formInfoBuilder_ != null || formInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * Information about the form.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo form_info = 3;</code>
     *
     * @return The formInfo.
     */
    public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo getFormInfo() {
      if (formInfoBuilder_ == null) {
        return formInfo_ == null
            ? com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.getDefaultInstance()
            : formInfo_;
      } else {
        return formInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * Information about the form.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo form_info = 3;</code>
     */
    public Builder setFormInfo(com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo value) {
      if (formInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        formInfo_ = value;
        onChanged();
      } else {
        formInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * Information about the form.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo form_info = 3;</code>
     */
    public Builder setFormInfo(
        com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.Builder builderForValue) {
      if (formInfoBuilder_ == null) {
        formInfo_ = builderForValue.build();
        onChanged();
      } else {
        formInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * Information about the form.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo form_info = 3;</code>
     */
    public Builder mergeFormInfo(com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo value) {
      if (formInfoBuilder_ == null) {
        if (formInfo_ != null) {
          formInfo_ =
              com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.newBuilder(formInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          formInfo_ = value;
        }
        onChanged();
      } else {
        formInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * Information about the form.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo form_info = 3;</code>
     */
    public Builder clearFormInfo() {
      if (formInfoBuilder_ == null) {
        formInfo_ = null;
        onChanged();
      } else {
        formInfo_ = null;
        formInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * Information about the form.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo form_info = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.Builder getFormInfoBuilder() {

      onChanged();
      return getFormInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * Information about the form.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo form_info = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfoOrBuilder getFormInfoOrBuilder() {
      if (formInfoBuilder_ != null) {
        return formInfoBuilder_.getMessageOrBuilder();
      } else {
        return formInfo_ == null
            ? com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.getDefaultInstance()
            : formInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional for both [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
     * Information about the form.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo form_info = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo,
            com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.Builder,
            com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfoOrBuilder>
        getFormInfoFieldBuilder() {
      if (formInfoBuilder_ == null) {
        formInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo,
                com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.Builder,
                com.google.cloud.dialogflow.cx.v3.PageInfo.FormInfoOrBuilder>(
                getFormInfo(), getParentForChildren(), isClean());
        formInfo_ = null;
      }
      return formInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.PageInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.PageInfo)
  private static final com.google.cloud.dialogflow.cx.v3.PageInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.PageInfo();
  }

  public static com.google.cloud.dialogflow.cx.v3.PageInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PageInfo> PARSER =
      new com.google.protobuf.AbstractParser<PageInfo>() {
        @java.lang.Override
        public PageInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PageInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PageInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.PageInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
