/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/page.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * A Dialogflow CX conversation (session) can be described and visualized as a
 * state machine. The states of a CX session are represented by pages.
 * For each flow, you define many pages, where your combined pages can handle a
 * complete conversation on the topics the flow is designed for. At any given
 * moment, exactly one page is the current page, the current page is considered
 * active, and the flow associated with that page is considered active. Every
 * flow has a special start page. When a flow initially becomes active, the
 * start page page becomes the current page. For each conversational turn, the
 * current page will either stay the same or transition to another page.
 * You configure each page to collect information from the end-user that is
 * relevant for the conversational state represented by the page.
 * For more information, see the
 * [Page guide](https://cloud.google.com/dialogflow/cx/docs/concept/page).
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.Page}
 */
public final class Page extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Page)
    PageOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Page.newBuilder() to construct.
  private Page(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Page() {
    name_ = "";
    displayName_ = "";
    transitionRouteGroups_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    transitionRoutes_ = java.util.Collections.emptyList();
    eventHandlers_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Page();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.PageProto
        .internal_static_google_cloud_dialogflow_cx_v3_Page_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.PageProto
        .internal_static_google_cloud_dialogflow_cx_v3_Page_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.Page.class,
            com.google.cloud.dialogflow.cx.v3.Page.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The unique identifier of the page.
   * Required for the [Pages.UpdatePage][google.cloud.dialogflow.cx.v3.Pages.UpdatePage] method. [Pages.CreatePage][google.cloud.dialogflow.cx.v3.Pages.CreatePage]
   * populates the name automatically.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the page.
   * Required for the [Pages.UpdatePage][google.cloud.dialogflow.cx.v3.Pages.UpdatePage] method. [Pages.CreatePage][google.cloud.dialogflow.cx.v3.Pages.CreatePage]
   * populates the name automatically.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the page, unique within the flow.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the page, unique within the flow.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTRY_FULFILLMENT_FIELD_NUMBER = 7;
  private com.google.cloud.dialogflow.cx.v3.Fulfillment entryFulfillment_;
  /**
   *
   *
   * <pre>
   * The fulfillment to call when the session is entering the page.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Fulfillment entry_fulfillment = 7;</code>
   *
   * @return Whether the entryFulfillment field is set.
   */
  @java.lang.Override
  public boolean hasEntryFulfillment() {
    return entryFulfillment_ != null;
  }
  /**
   *
   *
   * <pre>
   * The fulfillment to call when the session is entering the page.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Fulfillment entry_fulfillment = 7;</code>
   *
   * @return The entryFulfillment.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Fulfillment getEntryFulfillment() {
    return entryFulfillment_ == null
        ? com.google.cloud.dialogflow.cx.v3.Fulfillment.getDefaultInstance()
        : entryFulfillment_;
  }
  /**
   *
   *
   * <pre>
   * The fulfillment to call when the session is entering the page.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Fulfillment entry_fulfillment = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder getEntryFulfillmentOrBuilder() {
    return getEntryFulfillment();
  }

  public static final int FORM_FIELD_NUMBER = 4;
  private com.google.cloud.dialogflow.cx.v3.Form form_;
  /**
   *
   *
   * <pre>
   * The form associated with the page, used for collecting parameters
   * relevant to the page.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Form form = 4;</code>
   *
   * @return Whether the form field is set.
   */
  @java.lang.Override
  public boolean hasForm() {
    return form_ != null;
  }
  /**
   *
   *
   * <pre>
   * The form associated with the page, used for collecting parameters
   * relevant to the page.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Form form = 4;</code>
   *
   * @return The form.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Form getForm() {
    return form_ == null ? com.google.cloud.dialogflow.cx.v3.Form.getDefaultInstance() : form_;
  }
  /**
   *
   *
   * <pre>
   * The form associated with the page, used for collecting parameters
   * relevant to the page.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Form form = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.FormOrBuilder getFormOrBuilder() {
    return getForm();
  }

  public static final int TRANSITION_ROUTE_GROUPS_FIELD_NUMBER = 11;
  private com.google.protobuf.LazyStringList transitionRouteGroups_;
  /**
   *
   *
   * <pre>
   * Ordered list of [`TransitionRouteGroups`][google.cloud.dialogflow.cx.v3.TransitionRouteGroup] associated
   * with the page. Transition route groups must be unique within a page.
   * *   If multiple transition routes within a page scope refer to the same
   *     intent, then the precedence order is: page's transition route -&gt; page's
   *     transition route group -&gt; flow's transition routes.
   * *   If multiple transition route groups within a page contain the same
   *     intent, then the first group in the ordered list takes precedence.
   * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`.
   * </pre>
   *
   * <code>repeated string transition_route_groups = 11 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the transitionRouteGroups.
   */
  public com.google.protobuf.ProtocolStringList getTransitionRouteGroupsList() {
    return transitionRouteGroups_;
  }
  /**
   *
   *
   * <pre>
   * Ordered list of [`TransitionRouteGroups`][google.cloud.dialogflow.cx.v3.TransitionRouteGroup] associated
   * with the page. Transition route groups must be unique within a page.
   * *   If multiple transition routes within a page scope refer to the same
   *     intent, then the precedence order is: page's transition route -&gt; page's
   *     transition route group -&gt; flow's transition routes.
   * *   If multiple transition route groups within a page contain the same
   *     intent, then the first group in the ordered list takes precedence.
   * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`.
   * </pre>
   *
   * <code>repeated string transition_route_groups = 11 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of transitionRouteGroups.
   */
  public int getTransitionRouteGroupsCount() {
    return transitionRouteGroups_.size();
  }
  /**
   *
   *
   * <pre>
   * Ordered list of [`TransitionRouteGroups`][google.cloud.dialogflow.cx.v3.TransitionRouteGroup] associated
   * with the page. Transition route groups must be unique within a page.
   * *   If multiple transition routes within a page scope refer to the same
   *     intent, then the precedence order is: page's transition route -&gt; page's
   *     transition route group -&gt; flow's transition routes.
   * *   If multiple transition route groups within a page contain the same
   *     intent, then the first group in the ordered list takes precedence.
   * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`.
   * </pre>
   *
   * <code>repeated string transition_route_groups = 11 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The transitionRouteGroups at the given index.
   */
  public java.lang.String getTransitionRouteGroups(int index) {
    return transitionRouteGroups_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Ordered list of [`TransitionRouteGroups`][google.cloud.dialogflow.cx.v3.TransitionRouteGroup] associated
   * with the page. Transition route groups must be unique within a page.
   * *   If multiple transition routes within a page scope refer to the same
   *     intent, then the precedence order is: page's transition route -&gt; page's
   *     transition route group -&gt; flow's transition routes.
   * *   If multiple transition route groups within a page contain the same
   *     intent, then the first group in the ordered list takes precedence.
   * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`.
   * </pre>
   *
   * <code>repeated string transition_route_groups = 11 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the transitionRouteGroups at the given index.
   */
  public com.google.protobuf.ByteString getTransitionRouteGroupsBytes(int index) {
    return transitionRouteGroups_.getByteString(index);
  }

  public static final int TRANSITION_ROUTES_FIELD_NUMBER = 9;
  private java.util.List<com.google.cloud.dialogflow.cx.v3.TransitionRoute> transitionRoutes_;
  /**
   *
   *
   * <pre>
   * A list of transitions for the transition rules of this page.
   * They route the conversation to another page in the same flow, or another
   * flow.
   * When we are in a certain page, the TransitionRoutes are evalauted in the
   * following order:
   * *   TransitionRoutes defined in the page with intent specified.
   * *   TransitionRoutes defined in the
   *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
   *     specified.
   * *   TransitionRoutes defined in flow with intent specified.
   * *   TransitionRoutes defined in the
   *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
   *     specified.
   * *   TransitionRoutes defined in the page with only condition specified.
   * *   TransitionRoutes defined in the
   *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
   *     condition specified.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.TransitionRoute>
      getTransitionRoutesList() {
    return transitionRoutes_;
  }
  /**
   *
   *
   * <pre>
   * A list of transitions for the transition rules of this page.
   * They route the conversation to another page in the same flow, or another
   * flow.
   * When we are in a certain page, the TransitionRoutes are evalauted in the
   * following order:
   * *   TransitionRoutes defined in the page with intent specified.
   * *   TransitionRoutes defined in the
   *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
   *     specified.
   * *   TransitionRoutes defined in flow with intent specified.
   * *   TransitionRoutes defined in the
   *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
   *     specified.
   * *   TransitionRoutes defined in the page with only condition specified.
   * *   TransitionRoutes defined in the
   *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
   *     condition specified.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder>
      getTransitionRoutesOrBuilderList() {
    return transitionRoutes_;
  }
  /**
   *
   *
   * <pre>
   * A list of transitions for the transition rules of this page.
   * They route the conversation to another page in the same flow, or another
   * flow.
   * When we are in a certain page, the TransitionRoutes are evalauted in the
   * following order:
   * *   TransitionRoutes defined in the page with intent specified.
   * *   TransitionRoutes defined in the
   *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
   *     specified.
   * *   TransitionRoutes defined in flow with intent specified.
   * *   TransitionRoutes defined in the
   *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
   *     specified.
   * *   TransitionRoutes defined in the page with only condition specified.
   * *   TransitionRoutes defined in the
   *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
   *     condition specified.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
   */
  @java.lang.Override
  public int getTransitionRoutesCount() {
    return transitionRoutes_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of transitions for the transition rules of this page.
   * They route the conversation to another page in the same flow, or another
   * flow.
   * When we are in a certain page, the TransitionRoutes are evalauted in the
   * following order:
   * *   TransitionRoutes defined in the page with intent specified.
   * *   TransitionRoutes defined in the
   *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
   *     specified.
   * *   TransitionRoutes defined in flow with intent specified.
   * *   TransitionRoutes defined in the
   *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
   *     specified.
   * *   TransitionRoutes defined in the page with only condition specified.
   * *   TransitionRoutes defined in the
   *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
   *     condition specified.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.TransitionRoute getTransitionRoutes(int index) {
    return transitionRoutes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of transitions for the transition rules of this page.
   * They route the conversation to another page in the same flow, or another
   * flow.
   * When we are in a certain page, the TransitionRoutes are evalauted in the
   * following order:
   * *   TransitionRoutes defined in the page with intent specified.
   * *   TransitionRoutes defined in the
   *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
   *     specified.
   * *   TransitionRoutes defined in flow with intent specified.
   * *   TransitionRoutes defined in the
   *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
   *     specified.
   * *   TransitionRoutes defined in the page with only condition specified.
   * *   TransitionRoutes defined in the
   *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
   *     condition specified.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder getTransitionRoutesOrBuilder(
      int index) {
    return transitionRoutes_.get(index);
  }

  public static final int EVENT_HANDLERS_FIELD_NUMBER = 10;
  private java.util.List<com.google.cloud.dialogflow.cx.v3.EventHandler> eventHandlers_;
  /**
   *
   *
   * <pre>
   * Handlers associated with the page to handle events such as webhook errors,
   * no match or no input.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.EventHandler> getEventHandlersList() {
    return eventHandlers_;
  }
  /**
   *
   *
   * <pre>
   * Handlers associated with the page to handle events such as webhook errors,
   * no match or no input.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.EventHandlerOrBuilder>
      getEventHandlersOrBuilderList() {
    return eventHandlers_;
  }
  /**
   *
   *
   * <pre>
   * Handlers associated with the page to handle events such as webhook errors,
   * no match or no input.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
   */
  @java.lang.Override
  public int getEventHandlersCount() {
    return eventHandlers_.size();
  }
  /**
   *
   *
   * <pre>
   * Handlers associated with the page to handle events such as webhook errors,
   * no match or no input.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.EventHandler getEventHandlers(int index) {
    return eventHandlers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Handlers associated with the page to handle events such as webhook errors,
   * no match or no input.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.EventHandlerOrBuilder getEventHandlersOrBuilder(
      int index) {
    return eventHandlers_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (form_ != null) {
      output.writeMessage(4, getForm());
    }
    if (entryFulfillment_ != null) {
      output.writeMessage(7, getEntryFulfillment());
    }
    for (int i = 0; i < transitionRoutes_.size(); i++) {
      output.writeMessage(9, transitionRoutes_.get(i));
    }
    for (int i = 0; i < eventHandlers_.size(); i++) {
      output.writeMessage(10, eventHandlers_.get(i));
    }
    for (int i = 0; i < transitionRouteGroups_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 11, transitionRouteGroups_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (form_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getForm());
    }
    if (entryFulfillment_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getEntryFulfillment());
    }
    for (int i = 0; i < transitionRoutes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, transitionRoutes_.get(i));
    }
    for (int i = 0; i < eventHandlers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, eventHandlers_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < transitionRouteGroups_.size(); i++) {
        dataSize += computeStringSizeNoTag(transitionRouteGroups_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTransitionRouteGroupsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Page)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.Page other = (com.google.cloud.dialogflow.cx.v3.Page) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasEntryFulfillment() != other.hasEntryFulfillment()) return false;
    if (hasEntryFulfillment()) {
      if (!getEntryFulfillment().equals(other.getEntryFulfillment())) return false;
    }
    if (hasForm() != other.hasForm()) return false;
    if (hasForm()) {
      if (!getForm().equals(other.getForm())) return false;
    }
    if (!getTransitionRouteGroupsList().equals(other.getTransitionRouteGroupsList())) return false;
    if (!getTransitionRoutesList().equals(other.getTransitionRoutesList())) return false;
    if (!getEventHandlersList().equals(other.getEventHandlersList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasEntryFulfillment()) {
      hash = (37 * hash) + ENTRY_FULFILLMENT_FIELD_NUMBER;
      hash = (53 * hash) + getEntryFulfillment().hashCode();
    }
    if (hasForm()) {
      hash = (37 * hash) + FORM_FIELD_NUMBER;
      hash = (53 * hash) + getForm().hashCode();
    }
    if (getTransitionRouteGroupsCount() > 0) {
      hash = (37 * hash) + TRANSITION_ROUTE_GROUPS_FIELD_NUMBER;
      hash = (53 * hash) + getTransitionRouteGroupsList().hashCode();
    }
    if (getTransitionRoutesCount() > 0) {
      hash = (37 * hash) + TRANSITION_ROUTES_FIELD_NUMBER;
      hash = (53 * hash) + getTransitionRoutesList().hashCode();
    }
    if (getEventHandlersCount() > 0) {
      hash = (37 * hash) + EVENT_HANDLERS_FIELD_NUMBER;
      hash = (53 * hash) + getEventHandlersList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.Page parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Page parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Page parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Page parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Page parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Page parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Page parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Page parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Page parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Page parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Page parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Page parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.Page prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Dialogflow CX conversation (session) can be described and visualized as a
   * state machine. The states of a CX session are represented by pages.
   * For each flow, you define many pages, where your combined pages can handle a
   * complete conversation on the topics the flow is designed for. At any given
   * moment, exactly one page is the current page, the current page is considered
   * active, and the flow associated with that page is considered active. Every
   * flow has a special start page. When a flow initially becomes active, the
   * start page page becomes the current page. For each conversational turn, the
   * current page will either stay the same or transition to another page.
   * You configure each page to collect information from the end-user that is
   * relevant for the conversational state represented by the page.
   * For more information, see the
   * [Page guide](https://cloud.google.com/dialogflow/cx/docs/concept/page).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Page}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Page)
      com.google.cloud.dialogflow.cx.v3.PageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3_Page_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3_Page_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Page.class,
              com.google.cloud.dialogflow.cx.v3.Page.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.Page.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      if (entryFulfillmentBuilder_ == null) {
        entryFulfillment_ = null;
      } else {
        entryFulfillment_ = null;
        entryFulfillmentBuilder_ = null;
      }
      if (formBuilder_ == null) {
        form_ = null;
      } else {
        form_ = null;
        formBuilder_ = null;
      }
      transitionRouteGroups_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      if (transitionRoutesBuilder_ == null) {
        transitionRoutes_ = java.util.Collections.emptyList();
      } else {
        transitionRoutes_ = null;
        transitionRoutesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (eventHandlersBuilder_ == null) {
        eventHandlers_ = java.util.Collections.emptyList();
      } else {
        eventHandlers_ = null;
        eventHandlersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3_Page_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Page getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Page build() {
      com.google.cloud.dialogflow.cx.v3.Page result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Page buildPartial() {
      com.google.cloud.dialogflow.cx.v3.Page result =
          new com.google.cloud.dialogflow.cx.v3.Page(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      if (entryFulfillmentBuilder_ == null) {
        result.entryFulfillment_ = entryFulfillment_;
      } else {
        result.entryFulfillment_ = entryFulfillmentBuilder_.build();
      }
      if (formBuilder_ == null) {
        result.form_ = form_;
      } else {
        result.form_ = formBuilder_.build();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        transitionRouteGroups_ = transitionRouteGroups_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.transitionRouteGroups_ = transitionRouteGroups_;
      if (transitionRoutesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          transitionRoutes_ = java.util.Collections.unmodifiableList(transitionRoutes_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.transitionRoutes_ = transitionRoutes_;
      } else {
        result.transitionRoutes_ = transitionRoutesBuilder_.build();
      }
      if (eventHandlersBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          eventHandlers_ = java.util.Collections.unmodifiableList(eventHandlers_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.eventHandlers_ = eventHandlers_;
      } else {
        result.eventHandlers_ = eventHandlersBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.Page) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.Page) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.Page other) {
      if (other == com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.hasEntryFulfillment()) {
        mergeEntryFulfillment(other.getEntryFulfillment());
      }
      if (other.hasForm()) {
        mergeForm(other.getForm());
      }
      if (!other.transitionRouteGroups_.isEmpty()) {
        if (transitionRouteGroups_.isEmpty()) {
          transitionRouteGroups_ = other.transitionRouteGroups_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureTransitionRouteGroupsIsMutable();
          transitionRouteGroups_.addAll(other.transitionRouteGroups_);
        }
        onChanged();
      }
      if (transitionRoutesBuilder_ == null) {
        if (!other.transitionRoutes_.isEmpty()) {
          if (transitionRoutes_.isEmpty()) {
            transitionRoutes_ = other.transitionRoutes_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTransitionRoutesIsMutable();
            transitionRoutes_.addAll(other.transitionRoutes_);
          }
          onChanged();
        }
      } else {
        if (!other.transitionRoutes_.isEmpty()) {
          if (transitionRoutesBuilder_.isEmpty()) {
            transitionRoutesBuilder_.dispose();
            transitionRoutesBuilder_ = null;
            transitionRoutes_ = other.transitionRoutes_;
            bitField0_ = (bitField0_ & ~0x00000002);
            transitionRoutesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTransitionRoutesFieldBuilder()
                    : null;
          } else {
            transitionRoutesBuilder_.addAllMessages(other.transitionRoutes_);
          }
        }
      }
      if (eventHandlersBuilder_ == null) {
        if (!other.eventHandlers_.isEmpty()) {
          if (eventHandlers_.isEmpty()) {
            eventHandlers_ = other.eventHandlers_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureEventHandlersIsMutable();
            eventHandlers_.addAll(other.eventHandlers_);
          }
          onChanged();
        }
      } else {
        if (!other.eventHandlers_.isEmpty()) {
          if (eventHandlersBuilder_.isEmpty()) {
            eventHandlersBuilder_.dispose();
            eventHandlersBuilder_ = null;
            eventHandlers_ = other.eventHandlers_;
            bitField0_ = (bitField0_ & ~0x00000004);
            eventHandlersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEventHandlersFieldBuilder()
                    : null;
          } else {
            eventHandlersBuilder_.addAllMessages(other.eventHandlers_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 34:
              {
                input.readMessage(getFormFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 58:
              {
                input.readMessage(
                    getEntryFulfillmentFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 74:
              {
                com.google.cloud.dialogflow.cx.v3.TransitionRoute m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.TransitionRoute.parser(),
                        extensionRegistry);
                if (transitionRoutesBuilder_ == null) {
                  ensureTransitionRoutesIsMutable();
                  transitionRoutes_.add(m);
                } else {
                  transitionRoutesBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                com.google.cloud.dialogflow.cx.v3.EventHandler m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.EventHandler.parser(), extensionRegistry);
                if (eventHandlersBuilder_ == null) {
                  ensureEventHandlersIsMutable();
                  eventHandlers_.add(m);
                } else {
                  eventHandlersBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTransitionRouteGroupsIsMutable();
                transitionRouteGroups_.add(s);
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the page.
     * Required for the [Pages.UpdatePage][google.cloud.dialogflow.cx.v3.Pages.UpdatePage] method. [Pages.CreatePage][google.cloud.dialogflow.cx.v3.Pages.CreatePage]
     * populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the page.
     * Required for the [Pages.UpdatePage][google.cloud.dialogflow.cx.v3.Pages.UpdatePage] method. [Pages.CreatePage][google.cloud.dialogflow.cx.v3.Pages.CreatePage]
     * populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the page.
     * Required for the [Pages.UpdatePage][google.cloud.dialogflow.cx.v3.Pages.UpdatePage] method. [Pages.CreatePage][google.cloud.dialogflow.cx.v3.Pages.CreatePage]
     * populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the page.
     * Required for the [Pages.UpdatePage][google.cloud.dialogflow.cx.v3.Pages.UpdatePage] method. [Pages.CreatePage][google.cloud.dialogflow.cx.v3.Pages.CreatePage]
     * populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the page.
     * Required for the [Pages.UpdatePage][google.cloud.dialogflow.cx.v3.Pages.UpdatePage] method. [Pages.CreatePage][google.cloud.dialogflow.cx.v3.Pages.CreatePage]
     * populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the page, unique within the flow.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the page, unique within the flow.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the page, unique within the flow.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the page, unique within the flow.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the page, unique within the flow.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.Fulfillment entryFulfillment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Fulfillment,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder,
            com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder>
        entryFulfillmentBuilder_;
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the session is entering the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment entry_fulfillment = 7;</code>
     *
     * @return Whether the entryFulfillment field is set.
     */
    public boolean hasEntryFulfillment() {
      return entryFulfillmentBuilder_ != null || entryFulfillment_ != null;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the session is entering the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment entry_fulfillment = 7;</code>
     *
     * @return The entryFulfillment.
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment getEntryFulfillment() {
      if (entryFulfillmentBuilder_ == null) {
        return entryFulfillment_ == null
            ? com.google.cloud.dialogflow.cx.v3.Fulfillment.getDefaultInstance()
            : entryFulfillment_;
      } else {
        return entryFulfillmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the session is entering the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment entry_fulfillment = 7;</code>
     */
    public Builder setEntryFulfillment(com.google.cloud.dialogflow.cx.v3.Fulfillment value) {
      if (entryFulfillmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entryFulfillment_ = value;
        onChanged();
      } else {
        entryFulfillmentBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the session is entering the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment entry_fulfillment = 7;</code>
     */
    public Builder setEntryFulfillment(
        com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder builderForValue) {
      if (entryFulfillmentBuilder_ == null) {
        entryFulfillment_ = builderForValue.build();
        onChanged();
      } else {
        entryFulfillmentBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the session is entering the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment entry_fulfillment = 7;</code>
     */
    public Builder mergeEntryFulfillment(com.google.cloud.dialogflow.cx.v3.Fulfillment value) {
      if (entryFulfillmentBuilder_ == null) {
        if (entryFulfillment_ != null) {
          entryFulfillment_ =
              com.google.cloud.dialogflow.cx.v3.Fulfillment.newBuilder(entryFulfillment_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entryFulfillment_ = value;
        }
        onChanged();
      } else {
        entryFulfillmentBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the session is entering the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment entry_fulfillment = 7;</code>
     */
    public Builder clearEntryFulfillment() {
      if (entryFulfillmentBuilder_ == null) {
        entryFulfillment_ = null;
        onChanged();
      } else {
        entryFulfillment_ = null;
        entryFulfillmentBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the session is entering the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment entry_fulfillment = 7;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder getEntryFulfillmentBuilder() {

      onChanged();
      return getEntryFulfillmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the session is entering the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment entry_fulfillment = 7;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder getEntryFulfillmentOrBuilder() {
      if (entryFulfillmentBuilder_ != null) {
        return entryFulfillmentBuilder_.getMessageOrBuilder();
      } else {
        return entryFulfillment_ == null
            ? com.google.cloud.dialogflow.cx.v3.Fulfillment.getDefaultInstance()
            : entryFulfillment_;
      }
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the session is entering the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment entry_fulfillment = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Fulfillment,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder,
            com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder>
        getEntryFulfillmentFieldBuilder() {
      if (entryFulfillmentBuilder_ == null) {
        entryFulfillmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Fulfillment,
                com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder,
                com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder>(
                getEntryFulfillment(), getParentForChildren(), isClean());
        entryFulfillment_ = null;
      }
      return entryFulfillmentBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.Form form_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Form,
            com.google.cloud.dialogflow.cx.v3.Form.Builder,
            com.google.cloud.dialogflow.cx.v3.FormOrBuilder>
        formBuilder_;
    /**
     *
     *
     * <pre>
     * The form associated with the page, used for collecting parameters
     * relevant to the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Form form = 4;</code>
     *
     * @return Whether the form field is set.
     */
    public boolean hasForm() {
      return formBuilder_ != null || form_ != null;
    }
    /**
     *
     *
     * <pre>
     * The form associated with the page, used for collecting parameters
     * relevant to the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Form form = 4;</code>
     *
     * @return The form.
     */
    public com.google.cloud.dialogflow.cx.v3.Form getForm() {
      if (formBuilder_ == null) {
        return form_ == null ? com.google.cloud.dialogflow.cx.v3.Form.getDefaultInstance() : form_;
      } else {
        return formBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The form associated with the page, used for collecting parameters
     * relevant to the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Form form = 4;</code>
     */
    public Builder setForm(com.google.cloud.dialogflow.cx.v3.Form value) {
      if (formBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        form_ = value;
        onChanged();
      } else {
        formBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The form associated with the page, used for collecting parameters
     * relevant to the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Form form = 4;</code>
     */
    public Builder setForm(com.google.cloud.dialogflow.cx.v3.Form.Builder builderForValue) {
      if (formBuilder_ == null) {
        form_ = builderForValue.build();
        onChanged();
      } else {
        formBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The form associated with the page, used for collecting parameters
     * relevant to the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Form form = 4;</code>
     */
    public Builder mergeForm(com.google.cloud.dialogflow.cx.v3.Form value) {
      if (formBuilder_ == null) {
        if (form_ != null) {
          form_ =
              com.google.cloud.dialogflow.cx.v3.Form.newBuilder(form_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          form_ = value;
        }
        onChanged();
      } else {
        formBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The form associated with the page, used for collecting parameters
     * relevant to the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Form form = 4;</code>
     */
    public Builder clearForm() {
      if (formBuilder_ == null) {
        form_ = null;
        onChanged();
      } else {
        form_ = null;
        formBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The form associated with the page, used for collecting parameters
     * relevant to the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Form form = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.Form.Builder getFormBuilder() {

      onChanged();
      return getFormFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The form associated with the page, used for collecting parameters
     * relevant to the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Form form = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.FormOrBuilder getFormOrBuilder() {
      if (formBuilder_ != null) {
        return formBuilder_.getMessageOrBuilder();
      } else {
        return form_ == null ? com.google.cloud.dialogflow.cx.v3.Form.getDefaultInstance() : form_;
      }
    }
    /**
     *
     *
     * <pre>
     * The form associated with the page, used for collecting parameters
     * relevant to the page.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Form form = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Form,
            com.google.cloud.dialogflow.cx.v3.Form.Builder,
            com.google.cloud.dialogflow.cx.v3.FormOrBuilder>
        getFormFieldBuilder() {
      if (formBuilder_ == null) {
        formBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Form,
                com.google.cloud.dialogflow.cx.v3.Form.Builder,
                com.google.cloud.dialogflow.cx.v3.FormOrBuilder>(
                getForm(), getParentForChildren(), isClean());
        form_ = null;
      }
      return formBuilder_;
    }

    private com.google.protobuf.LazyStringList transitionRouteGroups_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureTransitionRouteGroupsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        transitionRouteGroups_ =
            new com.google.protobuf.LazyStringArrayList(transitionRouteGroups_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Ordered list of [`TransitionRouteGroups`][google.cloud.dialogflow.cx.v3.TransitionRouteGroup] associated
     * with the page. Transition route groups must be unique within a page.
     * *   If multiple transition routes within a page scope refer to the same
     *     intent, then the precedence order is: page's transition route -&gt; page's
     *     transition route group -&gt; flow's transition routes.
     * *   If multiple transition route groups within a page contain the same
     *     intent, then the first group in the ordered list takes precedence.
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 11 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the transitionRouteGroups.
     */
    public com.google.protobuf.ProtocolStringList getTransitionRouteGroupsList() {
      return transitionRouteGroups_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Ordered list of [`TransitionRouteGroups`][google.cloud.dialogflow.cx.v3.TransitionRouteGroup] associated
     * with the page. Transition route groups must be unique within a page.
     * *   If multiple transition routes within a page scope refer to the same
     *     intent, then the precedence order is: page's transition route -&gt; page's
     *     transition route group -&gt; flow's transition routes.
     * *   If multiple transition route groups within a page contain the same
     *     intent, then the first group in the ordered list takes precedence.
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 11 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of transitionRouteGroups.
     */
    public int getTransitionRouteGroupsCount() {
      return transitionRouteGroups_.size();
    }
    /**
     *
     *
     * <pre>
     * Ordered list of [`TransitionRouteGroups`][google.cloud.dialogflow.cx.v3.TransitionRouteGroup] associated
     * with the page. Transition route groups must be unique within a page.
     * *   If multiple transition routes within a page scope refer to the same
     *     intent, then the precedence order is: page's transition route -&gt; page's
     *     transition route group -&gt; flow's transition routes.
     * *   If multiple transition route groups within a page contain the same
     *     intent, then the first group in the ordered list takes precedence.
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 11 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The transitionRouteGroups at the given index.
     */
    public java.lang.String getTransitionRouteGroups(int index) {
      return transitionRouteGroups_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Ordered list of [`TransitionRouteGroups`][google.cloud.dialogflow.cx.v3.TransitionRouteGroup] associated
     * with the page. Transition route groups must be unique within a page.
     * *   If multiple transition routes within a page scope refer to the same
     *     intent, then the precedence order is: page's transition route -&gt; page's
     *     transition route group -&gt; flow's transition routes.
     * *   If multiple transition route groups within a page contain the same
     *     intent, then the first group in the ordered list takes precedence.
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 11 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the transitionRouteGroups at the given index.
     */
    public com.google.protobuf.ByteString getTransitionRouteGroupsBytes(int index) {
      return transitionRouteGroups_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Ordered list of [`TransitionRouteGroups`][google.cloud.dialogflow.cx.v3.TransitionRouteGroup] associated
     * with the page. Transition route groups must be unique within a page.
     * *   If multiple transition routes within a page scope refer to the same
     *     intent, then the precedence order is: page's transition route -&gt; page's
     *     transition route group -&gt; flow's transition routes.
     * *   If multiple transition route groups within a page contain the same
     *     intent, then the first group in the ordered list takes precedence.
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 11 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The transitionRouteGroups to set.
     * @return This builder for chaining.
     */
    public Builder setTransitionRouteGroups(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTransitionRouteGroupsIsMutable();
      transitionRouteGroups_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of [`TransitionRouteGroups`][google.cloud.dialogflow.cx.v3.TransitionRouteGroup] associated
     * with the page. Transition route groups must be unique within a page.
     * *   If multiple transition routes within a page scope refer to the same
     *     intent, then the precedence order is: page's transition route -&gt; page's
     *     transition route group -&gt; flow's transition routes.
     * *   If multiple transition route groups within a page contain the same
     *     intent, then the first group in the ordered list takes precedence.
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 11 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The transitionRouteGroups to add.
     * @return This builder for chaining.
     */
    public Builder addTransitionRouteGroups(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTransitionRouteGroupsIsMutable();
      transitionRouteGroups_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of [`TransitionRouteGroups`][google.cloud.dialogflow.cx.v3.TransitionRouteGroup] associated
     * with the page. Transition route groups must be unique within a page.
     * *   If multiple transition routes within a page scope refer to the same
     *     intent, then the precedence order is: page's transition route -&gt; page's
     *     transition route group -&gt; flow's transition routes.
     * *   If multiple transition route groups within a page contain the same
     *     intent, then the first group in the ordered list takes precedence.
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 11 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The transitionRouteGroups to add.
     * @return This builder for chaining.
     */
    public Builder addAllTransitionRouteGroups(java.lang.Iterable<java.lang.String> values) {
      ensureTransitionRouteGroupsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, transitionRouteGroups_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of [`TransitionRouteGroups`][google.cloud.dialogflow.cx.v3.TransitionRouteGroup] associated
     * with the page. Transition route groups must be unique within a page.
     * *   If multiple transition routes within a page scope refer to the same
     *     intent, then the precedence order is: page's transition route -&gt; page's
     *     transition route group -&gt; flow's transition routes.
     * *   If multiple transition route groups within a page contain the same
     *     intent, then the first group in the ordered list takes precedence.
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 11 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransitionRouteGroups() {
      transitionRouteGroups_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of [`TransitionRouteGroups`][google.cloud.dialogflow.cx.v3.TransitionRouteGroup] associated
     * with the page. Transition route groups must be unique within a page.
     * *   If multiple transition routes within a page scope refer to the same
     *     intent, then the precedence order is: page's transition route -&gt; page's
     *     transition route group -&gt; flow's transition routes.
     * *   If multiple transition route groups within a page contain the same
     *     intent, then the first group in the ordered list takes precedence.
     * Format:`projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/transitionRouteGroups/&lt;TransitionRouteGroup ID&gt;`.
     * </pre>
     *
     * <code>
     * repeated string transition_route_groups = 11 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the transitionRouteGroups to add.
     * @return This builder for chaining.
     */
    public Builder addTransitionRouteGroupsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTransitionRouteGroupsIsMutable();
      transitionRouteGroups_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3.TransitionRoute> transitionRoutes_ =
        java.util.Collections.emptyList();

    private void ensureTransitionRoutesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        transitionRoutes_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.TransitionRoute>(
                transitionRoutes_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.TransitionRoute,
            com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder,
            com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder>
        transitionRoutesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.TransitionRoute>
        getTransitionRoutesList() {
      if (transitionRoutesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(transitionRoutes_);
      } else {
        return transitionRoutesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public int getTransitionRoutesCount() {
      if (transitionRoutesBuilder_ == null) {
        return transitionRoutes_.size();
      } else {
        return transitionRoutesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.TransitionRoute getTransitionRoutes(int index) {
      if (transitionRoutesBuilder_ == null) {
        return transitionRoutes_.get(index);
      } else {
        return transitionRoutesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public Builder setTransitionRoutes(
        int index, com.google.cloud.dialogflow.cx.v3.TransitionRoute value) {
      if (transitionRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.set(index, value);
        onChanged();
      } else {
        transitionRoutesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public Builder setTransitionRoutes(
        int index, com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder builderForValue) {
      if (transitionRoutesBuilder_ == null) {
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.set(index, builderForValue.build());
        onChanged();
      } else {
        transitionRoutesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public Builder addTransitionRoutes(com.google.cloud.dialogflow.cx.v3.TransitionRoute value) {
      if (transitionRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.add(value);
        onChanged();
      } else {
        transitionRoutesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public Builder addTransitionRoutes(
        int index, com.google.cloud.dialogflow.cx.v3.TransitionRoute value) {
      if (transitionRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.add(index, value);
        onChanged();
      } else {
        transitionRoutesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public Builder addTransitionRoutes(
        com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder builderForValue) {
      if (transitionRoutesBuilder_ == null) {
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.add(builderForValue.build());
        onChanged();
      } else {
        transitionRoutesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public Builder addTransitionRoutes(
        int index, com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder builderForValue) {
      if (transitionRoutesBuilder_ == null) {
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.add(index, builderForValue.build());
        onChanged();
      } else {
        transitionRoutesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public Builder addAllTransitionRoutes(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.TransitionRoute> values) {
      if (transitionRoutesBuilder_ == null) {
        ensureTransitionRoutesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, transitionRoutes_);
        onChanged();
      } else {
        transitionRoutesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public Builder clearTransitionRoutes() {
      if (transitionRoutesBuilder_ == null) {
        transitionRoutes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        transitionRoutesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public Builder removeTransitionRoutes(int index) {
      if (transitionRoutesBuilder_ == null) {
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.remove(index);
        onChanged();
      } else {
        transitionRoutesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder getTransitionRoutesBuilder(
        int index) {
      return getTransitionRoutesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder getTransitionRoutesOrBuilder(
        int index) {
      if (transitionRoutesBuilder_ == null) {
        return transitionRoutes_.get(index);
      } else {
        return transitionRoutesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder>
        getTransitionRoutesOrBuilderList() {
      if (transitionRoutesBuilder_ != null) {
        return transitionRoutesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(transitionRoutes_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder addTransitionRoutesBuilder() {
      return getTransitionRoutesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3.TransitionRoute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder addTransitionRoutesBuilder(
        int index) {
      return getTransitionRoutesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.cx.v3.TransitionRoute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of transitions for the transition rules of this page.
     * They route the conversation to another page in the same flow, or another
     * flow.
     * When we are in a certain page, the TransitionRoutes are evalauted in the
     * following order:
     * *   TransitionRoutes defined in the page with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in flow with intent specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Flow.transition_route_groups] with intent
     *     specified.
     * *   TransitionRoutes defined in the page with only condition specified.
     * *   TransitionRoutes defined in the
     *     [transition route groups][google.cloud.dialogflow.cx.v3.Page.transition_route_groups] with only
     *     condition specified.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 9;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder>
        getTransitionRoutesBuilderList() {
      return getTransitionRoutesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.TransitionRoute,
            com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder,
            com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder>
        getTransitionRoutesFieldBuilder() {
      if (transitionRoutesBuilder_ == null) {
        transitionRoutesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.TransitionRoute,
                com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder,
                com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder>(
                transitionRoutes_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        transitionRoutes_ = null;
      }
      return transitionRoutesBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3.EventHandler> eventHandlers_ =
        java.util.Collections.emptyList();

    private void ensureEventHandlersIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        eventHandlers_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.EventHandler>(eventHandlers_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.EventHandler,
            com.google.cloud.dialogflow.cx.v3.EventHandler.Builder,
            com.google.cloud.dialogflow.cx.v3.EventHandlerOrBuilder>
        eventHandlersBuilder_;

    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.EventHandler> getEventHandlersList() {
      if (eventHandlersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(eventHandlers_);
      } else {
        return eventHandlersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public int getEventHandlersCount() {
      if (eventHandlersBuilder_ == null) {
        return eventHandlers_.size();
      } else {
        return eventHandlersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.EventHandler getEventHandlers(int index) {
      if (eventHandlersBuilder_ == null) {
        return eventHandlers_.get(index);
      } else {
        return eventHandlersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public Builder setEventHandlers(
        int index, com.google.cloud.dialogflow.cx.v3.EventHandler value) {
      if (eventHandlersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventHandlersIsMutable();
        eventHandlers_.set(index, value);
        onChanged();
      } else {
        eventHandlersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public Builder setEventHandlers(
        int index, com.google.cloud.dialogflow.cx.v3.EventHandler.Builder builderForValue) {
      if (eventHandlersBuilder_ == null) {
        ensureEventHandlersIsMutable();
        eventHandlers_.set(index, builderForValue.build());
        onChanged();
      } else {
        eventHandlersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public Builder addEventHandlers(com.google.cloud.dialogflow.cx.v3.EventHandler value) {
      if (eventHandlersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventHandlersIsMutable();
        eventHandlers_.add(value);
        onChanged();
      } else {
        eventHandlersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public Builder addEventHandlers(
        int index, com.google.cloud.dialogflow.cx.v3.EventHandler value) {
      if (eventHandlersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventHandlersIsMutable();
        eventHandlers_.add(index, value);
        onChanged();
      } else {
        eventHandlersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public Builder addEventHandlers(
        com.google.cloud.dialogflow.cx.v3.EventHandler.Builder builderForValue) {
      if (eventHandlersBuilder_ == null) {
        ensureEventHandlersIsMutable();
        eventHandlers_.add(builderForValue.build());
        onChanged();
      } else {
        eventHandlersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public Builder addEventHandlers(
        int index, com.google.cloud.dialogflow.cx.v3.EventHandler.Builder builderForValue) {
      if (eventHandlersBuilder_ == null) {
        ensureEventHandlersIsMutable();
        eventHandlers_.add(index, builderForValue.build());
        onChanged();
      } else {
        eventHandlersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public Builder addAllEventHandlers(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.EventHandler> values) {
      if (eventHandlersBuilder_ == null) {
        ensureEventHandlersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, eventHandlers_);
        onChanged();
      } else {
        eventHandlersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public Builder clearEventHandlers() {
      if (eventHandlersBuilder_ == null) {
        eventHandlers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        eventHandlersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public Builder removeEventHandlers(int index) {
      if (eventHandlersBuilder_ == null) {
        ensureEventHandlersIsMutable();
        eventHandlers_.remove(index);
        onChanged();
      } else {
        eventHandlersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.EventHandler.Builder getEventHandlersBuilder(
        int index) {
      return getEventHandlersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.EventHandlerOrBuilder getEventHandlersOrBuilder(
        int index) {
      if (eventHandlersBuilder_ == null) {
        return eventHandlers_.get(index);
      } else {
        return eventHandlersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.EventHandlerOrBuilder>
        getEventHandlersOrBuilderList() {
      if (eventHandlersBuilder_ != null) {
        return eventHandlersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(eventHandlers_);
      }
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.EventHandler.Builder addEventHandlersBuilder() {
      return getEventHandlersFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3.EventHandler.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.EventHandler.Builder addEventHandlersBuilder(
        int index) {
      return getEventHandlersFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.cx.v3.EventHandler.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Handlers associated with the page to handle events such as webhook errors,
     * no match or no input.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.EventHandler event_handlers = 10;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.EventHandler.Builder>
        getEventHandlersBuilderList() {
      return getEventHandlersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.EventHandler,
            com.google.cloud.dialogflow.cx.v3.EventHandler.Builder,
            com.google.cloud.dialogflow.cx.v3.EventHandlerOrBuilder>
        getEventHandlersFieldBuilder() {
      if (eventHandlersBuilder_ == null) {
        eventHandlersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.EventHandler,
                com.google.cloud.dialogflow.cx.v3.EventHandler.Builder,
                com.google.cloud.dialogflow.cx.v3.EventHandlerOrBuilder>(
                eventHandlers_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        eventHandlers_ = null;
      }
      return eventHandlersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Page)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Page)
  private static final com.google.cloud.dialogflow.cx.v3.Page DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Page();
  }

  public static com.google.cloud.dialogflow.cx.v3.Page getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Page> PARSER =
      new com.google.protobuf.AbstractParser<Page>() {
        @java.lang.Override
        public Page parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Page> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Page> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Page getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
