/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/session.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Represents one match result of [MatchIntent][].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.Match}
 */
public final class Match extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Match)
    MatchOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Match.newBuilder() to construct.
  private Match(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Match() {
    event_ = "";
    resolvedInput_ = "";
    matchType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Match();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_Match_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_Match_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.Match.class,
            com.google.cloud.dialogflow.cx.v3.Match.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of a Match.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3.Match.MatchType}
   */
  public enum MatchType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. Should never be used.
     * </pre>
     *
     * <code>MATCH_TYPE_UNSPECIFIED = 0;</code>
     */
    MATCH_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The query was matched to an intent.
     * </pre>
     *
     * <code>INTENT = 1;</code>
     */
    INTENT(1),
    /**
     *
     *
     * <pre>
     * The query directly triggered an intent.
     * </pre>
     *
     * <code>DIRECT_INTENT = 2;</code>
     */
    DIRECT_INTENT(2),
    /**
     *
     *
     * <pre>
     * The query was used for parameter filling.
     * </pre>
     *
     * <code>PARAMETER_FILLING = 3;</code>
     */
    PARAMETER_FILLING(3),
    /**
     *
     *
     * <pre>
     * No match was found for the query.
     * </pre>
     *
     * <code>NO_MATCH = 4;</code>
     */
    NO_MATCH(4),
    /**
     *
     *
     * <pre>
     * Indicates an empty query.
     * </pre>
     *
     * <code>NO_INPUT = 5;</code>
     */
    NO_INPUT(5),
    /**
     *
     *
     * <pre>
     * The query directly triggered an event.
     * </pre>
     *
     * <code>EVENT = 6;</code>
     */
    EVENT(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. Should never be used.
     * </pre>
     *
     * <code>MATCH_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int MATCH_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The query was matched to an intent.
     * </pre>
     *
     * <code>INTENT = 1;</code>
     */
    public static final int INTENT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The query directly triggered an intent.
     * </pre>
     *
     * <code>DIRECT_INTENT = 2;</code>
     */
    public static final int DIRECT_INTENT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The query was used for parameter filling.
     * </pre>
     *
     * <code>PARAMETER_FILLING = 3;</code>
     */
    public static final int PARAMETER_FILLING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * No match was found for the query.
     * </pre>
     *
     * <code>NO_MATCH = 4;</code>
     */
    public static final int NO_MATCH_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Indicates an empty query.
     * </pre>
     *
     * <code>NO_INPUT = 5;</code>
     */
    public static final int NO_INPUT_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The query directly triggered an event.
     * </pre>
     *
     * <code>EVENT = 6;</code>
     */
    public static final int EVENT_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MatchType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MatchType forNumber(int value) {
      switch (value) {
        case 0:
          return MATCH_TYPE_UNSPECIFIED;
        case 1:
          return INTENT;
        case 2:
          return DIRECT_INTENT;
        case 3:
          return PARAMETER_FILLING;
        case 4:
          return NO_MATCH;
        case 5:
          return NO_INPUT;
        case 6:
          return EVENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MatchType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MatchType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MatchType>() {
          public MatchType findValueByNumber(int number) {
            return MatchType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.Match.getDescriptor().getEnumTypes().get(0);
    }

    private static final MatchType[] VALUES = values();

    public static MatchType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MatchType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.Match.MatchType)
  }

  public static final int INTENT_FIELD_NUMBER = 1;
  private com.google.cloud.dialogflow.cx.v3.Intent intent_;
  /**
   *
   *
   * <pre>
   * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the query. Some, not all fields are filled in
   * this message, including but not limited to: `name` and `display_name`. Only
   * filled for [`INTENT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match type.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 1;</code>
   *
   * @return Whether the intent field is set.
   */
  @java.lang.Override
  public boolean hasIntent() {
    return intent_ != null;
  }
  /**
   *
   *
   * <pre>
   * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the query. Some, not all fields are filled in
   * this message, including but not limited to: `name` and `display_name`. Only
   * filled for [`INTENT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match type.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 1;</code>
   *
   * @return The intent.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Intent getIntent() {
    return intent_ == null
        ? com.google.cloud.dialogflow.cx.v3.Intent.getDefaultInstance()
        : intent_;
  }
  /**
   *
   *
   * <pre>
   * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the query. Some, not all fields are filled in
   * this message, including but not limited to: `name` and `display_name`. Only
   * filled for [`INTENT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match type.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.IntentOrBuilder getIntentOrBuilder() {
    return getIntent();
  }

  public static final int EVENT_FIELD_NUMBER = 6;
  private volatile java.lang.Object event_;
  /**
   *
   *
   * <pre>
   * The event that matched the query. Filled for
   * [`EVENT`][google.cloud.dialogflow.cx.v3.Match.MatchType], [`NO_MATCH`][google.cloud.dialogflow.cx.v3.Match.MatchType] and
   * [`NO_INPUT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match types.
   * </pre>
   *
   * <code>string event = 6;</code>
   *
   * @return The event.
   */
  @java.lang.Override
  public java.lang.String getEvent() {
    java.lang.Object ref = event_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      event_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The event that matched the query. Filled for
   * [`EVENT`][google.cloud.dialogflow.cx.v3.Match.MatchType], [`NO_MATCH`][google.cloud.dialogflow.cx.v3.Match.MatchType] and
   * [`NO_INPUT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match types.
   * </pre>
   *
   * <code>string event = 6;</code>
   *
   * @return The bytes for event.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEventBytes() {
    java.lang.Object ref = event_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      event_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMETERS_FIELD_NUMBER = 2;
  private com.google.protobuf.Struct parameters_;
  /**
   *
   *
   * <pre>
   * The collection of parameters extracted from the query.
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 2;</code>
   *
   * @return Whether the parameters field is set.
   */
  @java.lang.Override
  public boolean hasParameters() {
    return parameters_ != null;
  }
  /**
   *
   *
   * <pre>
   * The collection of parameters extracted from the query.
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 2;</code>
   *
   * @return The parameters.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getParameters() {
    return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
  }
  /**
   *
   *
   * <pre>
   * The collection of parameters extracted from the query.
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getParametersOrBuilder() {
    return getParameters();
  }

  public static final int RESOLVED_INPUT_FIELD_NUMBER = 3;
  private volatile java.lang.Object resolvedInput_;
  /**
   *
   *
   * <pre>
   * Final text input which was matched during MatchIntent. This value can be
   * different from original input sent in request because of spelling
   * correction or other processing.
   * </pre>
   *
   * <code>string resolved_input = 3;</code>
   *
   * @return The resolvedInput.
   */
  @java.lang.Override
  public java.lang.String getResolvedInput() {
    java.lang.Object ref = resolvedInput_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resolvedInput_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Final text input which was matched during MatchIntent. This value can be
   * different from original input sent in request because of spelling
   * correction or other processing.
   * </pre>
   *
   * <code>string resolved_input = 3;</code>
   *
   * @return The bytes for resolvedInput.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResolvedInputBytes() {
    java.lang.Object ref = resolvedInput_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resolvedInput_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MATCH_TYPE_FIELD_NUMBER = 4;
  private int matchType_;
  /**
   *
   *
   * <pre>
   * Type of this [Match][google.cloud.dialogflow.cx.v3.Match].
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Match.MatchType match_type = 4;</code>
   *
   * @return The enum numeric value on the wire for matchType.
   */
  @java.lang.Override
  public int getMatchTypeValue() {
    return matchType_;
  }
  /**
   *
   *
   * <pre>
   * Type of this [Match][google.cloud.dialogflow.cx.v3.Match].
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Match.MatchType match_type = 4;</code>
   *
   * @return The matchType.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Match.MatchType getMatchType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.cx.v3.Match.MatchType result =
        com.google.cloud.dialogflow.cx.v3.Match.MatchType.valueOf(matchType_);
    return result == null ? com.google.cloud.dialogflow.cx.v3.Match.MatchType.UNRECOGNIZED : result;
  }

  public static final int CONFIDENCE_FIELD_NUMBER = 5;
  private float confidence_;
  /**
   *
   *
   * <pre>
   * The confidence of this match. Values range from 0.0 (completely uncertain)
   * to 1.0 (completely certain).
   * This value is for informational purpose only and is only used to help match
   * the best intent within the classification threshold. This value may change
   * for the same end-user expression at any time due to a model retraining or
   * change in implementation.
   * </pre>
   *
   * <code>float confidence = 5;</code>
   *
   * @return The confidence.
   */
  @java.lang.Override
  public float getConfidence() {
    return confidence_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (intent_ != null) {
      output.writeMessage(1, getIntent());
    }
    if (parameters_ != null) {
      output.writeMessage(2, getParameters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resolvedInput_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, resolvedInput_);
    }
    if (matchType_
        != com.google.cloud.dialogflow.cx.v3.Match.MatchType.MATCH_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, matchType_);
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      output.writeFloat(5, confidence_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(event_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, event_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (intent_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getIntent());
    }
    if (parameters_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getParameters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resolvedInput_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, resolvedInput_);
    }
    if (matchType_
        != com.google.cloud.dialogflow.cx.v3.Match.MatchType.MATCH_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, matchType_);
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, confidence_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(event_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, event_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Match)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.Match other = (com.google.cloud.dialogflow.cx.v3.Match) obj;

    if (hasIntent() != other.hasIntent()) return false;
    if (hasIntent()) {
      if (!getIntent().equals(other.getIntent())) return false;
    }
    if (!getEvent().equals(other.getEvent())) return false;
    if (hasParameters() != other.hasParameters()) return false;
    if (hasParameters()) {
      if (!getParameters().equals(other.getParameters())) return false;
    }
    if (!getResolvedInput().equals(other.getResolvedInput())) return false;
    if (matchType_ != other.matchType_) return false;
    if (java.lang.Float.floatToIntBits(getConfidence())
        != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasIntent()) {
      hash = (37 * hash) + INTENT_FIELD_NUMBER;
      hash = (53 * hash) + getIntent().hashCode();
    }
    hash = (37 * hash) + EVENT_FIELD_NUMBER;
    hash = (53 * hash) + getEvent().hashCode();
    if (hasParameters()) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParameters().hashCode();
    }
    hash = (37 * hash) + RESOLVED_INPUT_FIELD_NUMBER;
    hash = (53 * hash) + getResolvedInput().hashCode();
    hash = (37 * hash) + MATCH_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + matchType_;
    hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.Match parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Match parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Match parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Match parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Match parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Match parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Match parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Match parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Match parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Match parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Match parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Match parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.Match prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents one match result of [MatchIntent][].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Match}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Match)
      com.google.cloud.dialogflow.cx.v3.MatchOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_Match_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_Match_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Match.class,
              com.google.cloud.dialogflow.cx.v3.Match.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.Match.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (intentBuilder_ == null) {
        intent_ = null;
      } else {
        intent_ = null;
        intentBuilder_ = null;
      }
      event_ = "";

      if (parametersBuilder_ == null) {
        parameters_ = null;
      } else {
        parameters_ = null;
        parametersBuilder_ = null;
      }
      resolvedInput_ = "";

      matchType_ = 0;

      confidence_ = 0F;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_Match_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Match getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.Match.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Match build() {
      com.google.cloud.dialogflow.cx.v3.Match result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Match buildPartial() {
      com.google.cloud.dialogflow.cx.v3.Match result =
          new com.google.cloud.dialogflow.cx.v3.Match(this);
      if (intentBuilder_ == null) {
        result.intent_ = intent_;
      } else {
        result.intent_ = intentBuilder_.build();
      }
      result.event_ = event_;
      if (parametersBuilder_ == null) {
        result.parameters_ = parameters_;
      } else {
        result.parameters_ = parametersBuilder_.build();
      }
      result.resolvedInput_ = resolvedInput_;
      result.matchType_ = matchType_;
      result.confidence_ = confidence_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.Match) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.Match) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.Match other) {
      if (other == com.google.cloud.dialogflow.cx.v3.Match.getDefaultInstance()) return this;
      if (other.hasIntent()) {
        mergeIntent(other.getIntent());
      }
      if (!other.getEvent().isEmpty()) {
        event_ = other.event_;
        onChanged();
      }
      if (other.hasParameters()) {
        mergeParameters(other.getParameters());
      }
      if (!other.getResolvedInput().isEmpty()) {
        resolvedInput_ = other.resolvedInput_;
        onChanged();
      }
      if (other.matchType_ != 0) {
        setMatchTypeValue(other.getMatchTypeValue());
      }
      if (other.getConfidence() != 0F) {
        setConfidence(other.getConfidence());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getIntentFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getParametersFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                resolvedInput_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 32:
              {
                matchType_ = input.readEnum();

                break;
              } // case 32
            case 45:
              {
                confidence_ = input.readFloat();

                break;
              } // case 45
            case 50:
              {
                event_ = input.readStringRequireUtf8();

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.Intent intent_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Intent,
            com.google.cloud.dialogflow.cx.v3.Intent.Builder,
            com.google.cloud.dialogflow.cx.v3.IntentOrBuilder>
        intentBuilder_;
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the query. Some, not all fields are filled in
     * this message, including but not limited to: `name` and `display_name`. Only
     * filled for [`INTENT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match type.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 1;</code>
     *
     * @return Whether the intent field is set.
     */
    public boolean hasIntent() {
      return intentBuilder_ != null || intent_ != null;
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the query. Some, not all fields are filled in
     * this message, including but not limited to: `name` and `display_name`. Only
     * filled for [`INTENT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match type.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 1;</code>
     *
     * @return The intent.
     */
    public com.google.cloud.dialogflow.cx.v3.Intent getIntent() {
      if (intentBuilder_ == null) {
        return intent_ == null
            ? com.google.cloud.dialogflow.cx.v3.Intent.getDefaultInstance()
            : intent_;
      } else {
        return intentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the query. Some, not all fields are filled in
     * this message, including but not limited to: `name` and `display_name`. Only
     * filled for [`INTENT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match type.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 1;</code>
     */
    public Builder setIntent(com.google.cloud.dialogflow.cx.v3.Intent value) {
      if (intentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        intent_ = value;
        onChanged();
      } else {
        intentBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the query. Some, not all fields are filled in
     * this message, including but not limited to: `name` and `display_name`. Only
     * filled for [`INTENT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match type.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 1;</code>
     */
    public Builder setIntent(com.google.cloud.dialogflow.cx.v3.Intent.Builder builderForValue) {
      if (intentBuilder_ == null) {
        intent_ = builderForValue.build();
        onChanged();
      } else {
        intentBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the query. Some, not all fields are filled in
     * this message, including but not limited to: `name` and `display_name`. Only
     * filled for [`INTENT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match type.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 1;</code>
     */
    public Builder mergeIntent(com.google.cloud.dialogflow.cx.v3.Intent value) {
      if (intentBuilder_ == null) {
        if (intent_ != null) {
          intent_ =
              com.google.cloud.dialogflow.cx.v3.Intent.newBuilder(intent_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          intent_ = value;
        }
        onChanged();
      } else {
        intentBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the query. Some, not all fields are filled in
     * this message, including but not limited to: `name` and `display_name`. Only
     * filled for [`INTENT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match type.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 1;</code>
     */
    public Builder clearIntent() {
      if (intentBuilder_ == null) {
        intent_ = null;
        onChanged();
      } else {
        intent_ = null;
        intentBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the query. Some, not all fields are filled in
     * this message, including but not limited to: `name` and `display_name`. Only
     * filled for [`INTENT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match type.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.Intent.Builder getIntentBuilder() {

      onChanged();
      return getIntentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the query. Some, not all fields are filled in
     * this message, including but not limited to: `name` and `display_name`. Only
     * filled for [`INTENT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match type.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.IntentOrBuilder getIntentOrBuilder() {
      if (intentBuilder_ != null) {
        return intentBuilder_.getMessageOrBuilder();
      } else {
        return intent_ == null
            ? com.google.cloud.dialogflow.cx.v3.Intent.getDefaultInstance()
            : intent_;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the query. Some, not all fields are filled in
     * this message, including but not limited to: `name` and `display_name`. Only
     * filled for [`INTENT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match type.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Intent,
            com.google.cloud.dialogflow.cx.v3.Intent.Builder,
            com.google.cloud.dialogflow.cx.v3.IntentOrBuilder>
        getIntentFieldBuilder() {
      if (intentBuilder_ == null) {
        intentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Intent,
                com.google.cloud.dialogflow.cx.v3.Intent.Builder,
                com.google.cloud.dialogflow.cx.v3.IntentOrBuilder>(
                getIntent(), getParentForChildren(), isClean());
        intent_ = null;
      }
      return intentBuilder_;
    }

    private java.lang.Object event_ = "";
    /**
     *
     *
     * <pre>
     * The event that matched the query. Filled for
     * [`EVENT`][google.cloud.dialogflow.cx.v3.Match.MatchType], [`NO_MATCH`][google.cloud.dialogflow.cx.v3.Match.MatchType] and
     * [`NO_INPUT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match types.
     * </pre>
     *
     * <code>string event = 6;</code>
     *
     * @return The event.
     */
    public java.lang.String getEvent() {
      java.lang.Object ref = event_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        event_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The event that matched the query. Filled for
     * [`EVENT`][google.cloud.dialogflow.cx.v3.Match.MatchType], [`NO_MATCH`][google.cloud.dialogflow.cx.v3.Match.MatchType] and
     * [`NO_INPUT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match types.
     * </pre>
     *
     * <code>string event = 6;</code>
     *
     * @return The bytes for event.
     */
    public com.google.protobuf.ByteString getEventBytes() {
      java.lang.Object ref = event_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        event_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The event that matched the query. Filled for
     * [`EVENT`][google.cloud.dialogflow.cx.v3.Match.MatchType], [`NO_MATCH`][google.cloud.dialogflow.cx.v3.Match.MatchType] and
     * [`NO_INPUT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match types.
     * </pre>
     *
     * <code>string event = 6;</code>
     *
     * @param value The event to set.
     * @return This builder for chaining.
     */
    public Builder setEvent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      event_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The event that matched the query. Filled for
     * [`EVENT`][google.cloud.dialogflow.cx.v3.Match.MatchType], [`NO_MATCH`][google.cloud.dialogflow.cx.v3.Match.MatchType] and
     * [`NO_INPUT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match types.
     * </pre>
     *
     * <code>string event = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEvent() {

      event_ = getDefaultInstance().getEvent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The event that matched the query. Filled for
     * [`EVENT`][google.cloud.dialogflow.cx.v3.Match.MatchType], [`NO_MATCH`][google.cloud.dialogflow.cx.v3.Match.MatchType] and
     * [`NO_INPUT`][google.cloud.dialogflow.cx.v3.Match.MatchType] match types.
     * </pre>
     *
     * <code>string event = 6;</code>
     *
     * @param value The bytes for event to set.
     * @return This builder for chaining.
     */
    public Builder setEventBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      event_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct parameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        parametersBuilder_;
    /**
     *
     *
     * <pre>
     * The collection of parameters extracted from the query.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 2;</code>
     *
     * @return Whether the parameters field is set.
     */
    public boolean hasParameters() {
      return parametersBuilder_ != null || parameters_ != null;
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters extracted from the query.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 2;</code>
     *
     * @return The parameters.
     */
    public com.google.protobuf.Struct getParameters() {
      if (parametersBuilder_ == null) {
        return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
      } else {
        return parametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters extracted from the query.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 2;</code>
     */
    public Builder setParameters(com.google.protobuf.Struct value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parameters_ = value;
        onChanged();
      } else {
        parametersBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters extracted from the query.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 2;</code>
     */
    public Builder setParameters(com.google.protobuf.Struct.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        parameters_ = builderForValue.build();
        onChanged();
      } else {
        parametersBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters extracted from the query.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 2;</code>
     */
    public Builder mergeParameters(com.google.protobuf.Struct value) {
      if (parametersBuilder_ == null) {
        if (parameters_ != null) {
          parameters_ =
              com.google.protobuf.Struct.newBuilder(parameters_).mergeFrom(value).buildPartial();
        } else {
          parameters_ = value;
        }
        onChanged();
      } else {
        parametersBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters extracted from the query.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 2;</code>
     */
    public Builder clearParameters() {
      if (parametersBuilder_ == null) {
        parameters_ = null;
        onChanged();
      } else {
        parameters_ = null;
        parametersBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters extracted from the query.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 2;</code>
     */
    public com.google.protobuf.Struct.Builder getParametersBuilder() {

      onChanged();
      return getParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters extracted from the query.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 2;</code>
     */
    public com.google.protobuf.StructOrBuilder getParametersOrBuilder() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilder();
      } else {
        return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of parameters extracted from the query.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getParameters(), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private java.lang.Object resolvedInput_ = "";
    /**
     *
     *
     * <pre>
     * Final text input which was matched during MatchIntent. This value can be
     * different from original input sent in request because of spelling
     * correction or other processing.
     * </pre>
     *
     * <code>string resolved_input = 3;</code>
     *
     * @return The resolvedInput.
     */
    public java.lang.String getResolvedInput() {
      java.lang.Object ref = resolvedInput_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resolvedInput_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Final text input which was matched during MatchIntent. This value can be
     * different from original input sent in request because of spelling
     * correction or other processing.
     * </pre>
     *
     * <code>string resolved_input = 3;</code>
     *
     * @return The bytes for resolvedInput.
     */
    public com.google.protobuf.ByteString getResolvedInputBytes() {
      java.lang.Object ref = resolvedInput_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resolvedInput_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Final text input which was matched during MatchIntent. This value can be
     * different from original input sent in request because of spelling
     * correction or other processing.
     * </pre>
     *
     * <code>string resolved_input = 3;</code>
     *
     * @param value The resolvedInput to set.
     * @return This builder for chaining.
     */
    public Builder setResolvedInput(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      resolvedInput_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Final text input which was matched during MatchIntent. This value can be
     * different from original input sent in request because of spelling
     * correction or other processing.
     * </pre>
     *
     * <code>string resolved_input = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResolvedInput() {

      resolvedInput_ = getDefaultInstance().getResolvedInput();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Final text input which was matched during MatchIntent. This value can be
     * different from original input sent in request because of spelling
     * correction or other processing.
     * </pre>
     *
     * <code>string resolved_input = 3;</code>
     *
     * @param value The bytes for resolvedInput to set.
     * @return This builder for chaining.
     */
    public Builder setResolvedInputBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      resolvedInput_ = value;
      onChanged();
      return this;
    }

    private int matchType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of this [Match][google.cloud.dialogflow.cx.v3.Match].
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Match.MatchType match_type = 4;</code>
     *
     * @return The enum numeric value on the wire for matchType.
     */
    @java.lang.Override
    public int getMatchTypeValue() {
      return matchType_;
    }
    /**
     *
     *
     * <pre>
     * Type of this [Match][google.cloud.dialogflow.cx.v3.Match].
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Match.MatchType match_type = 4;</code>
     *
     * @param value The enum numeric value on the wire for matchType to set.
     * @return This builder for chaining.
     */
    public Builder setMatchTypeValue(int value) {

      matchType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of this [Match][google.cloud.dialogflow.cx.v3.Match].
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Match.MatchType match_type = 4;</code>
     *
     * @return The matchType.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Match.MatchType getMatchType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.cx.v3.Match.MatchType result =
          com.google.cloud.dialogflow.cx.v3.Match.MatchType.valueOf(matchType_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3.Match.MatchType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of this [Match][google.cloud.dialogflow.cx.v3.Match].
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Match.MatchType match_type = 4;</code>
     *
     * @param value The matchType to set.
     * @return This builder for chaining.
     */
    public Builder setMatchType(com.google.cloud.dialogflow.cx.v3.Match.MatchType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      matchType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of this [Match][google.cloud.dialogflow.cx.v3.Match].
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Match.MatchType match_type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMatchType() {

      matchType_ = 0;
      onChanged();
      return this;
    }

    private float confidence_;
    /**
     *
     *
     * <pre>
     * The confidence of this match. Values range from 0.0 (completely uncertain)
     * to 1.0 (completely certain).
     * This value is for informational purpose only and is only used to help match
     * the best intent within the classification threshold. This value may change
     * for the same end-user expression at any time due to a model retraining or
     * change in implementation.
     * </pre>
     *
     * <code>float confidence = 5;</code>
     *
     * @return The confidence.
     */
    @java.lang.Override
    public float getConfidence() {
      return confidence_;
    }
    /**
     *
     *
     * <pre>
     * The confidence of this match. Values range from 0.0 (completely uncertain)
     * to 1.0 (completely certain).
     * This value is for informational purpose only and is only used to help match
     * the best intent within the classification threshold. This value may change
     * for the same end-user expression at any time due to a model retraining or
     * change in implementation.
     * </pre>
     *
     * <code>float confidence = 5;</code>
     *
     * @param value The confidence to set.
     * @return This builder for chaining.
     */
    public Builder setConfidence(float value) {

      confidence_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The confidence of this match. Values range from 0.0 (completely uncertain)
     * to 1.0 (completely certain).
     * This value is for informational purpose only and is only used to help match
     * the best intent within the classification threshold. This value may change
     * for the same end-user expression at any time due to a model retraining or
     * change in implementation.
     * </pre>
     *
     * <code>float confidence = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfidence() {

      confidence_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Match)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Match)
  private static final com.google.cloud.dialogflow.cx.v3.Match DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Match();
  }

  public static com.google.cloud.dialogflow.cx.v3.Match getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Match> PARSER =
      new com.google.protobuf.AbstractParser<Match>() {
        @java.lang.Override
        public Match parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Match> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Match> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Match getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
