/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/audio_config.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Instructs the speech recognizer on how to process the audio content.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.InputAudioConfig}
 */
public final class InputAudioConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.InputAudioConfig)
    InputAudioConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InputAudioConfig.newBuilder() to construct.
  private InputAudioConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InputAudioConfig() {
    audioEncoding_ = 0;
    phraseHints_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    model_ = "";
    modelVariant_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InputAudioConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.AudioConfigProto
        .internal_static_google_cloud_dialogflow_cx_v3_InputAudioConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.AudioConfigProto
        .internal_static_google_cloud_dialogflow_cx_v3_InputAudioConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.InputAudioConfig.class,
            com.google.cloud.dialogflow.cx.v3.InputAudioConfig.Builder.class);
  }

  public static final int AUDIO_ENCODING_FIELD_NUMBER = 1;
  private int audioEncoding_;
  /**
   *
   *
   * <pre>
   * Required. Audio encoding of the audio content to process.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for audioEncoding.
   */
  @java.lang.Override
  public int getAudioEncodingValue() {
    return audioEncoding_;
  }
  /**
   *
   *
   * <pre>
   * Required. Audio encoding of the audio content to process.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The audioEncoding.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.AudioEncoding getAudioEncoding() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.cx.v3.AudioEncoding result =
        com.google.cloud.dialogflow.cx.v3.AudioEncoding.valueOf(audioEncoding_);
    return result == null ? com.google.cloud.dialogflow.cx.v3.AudioEncoding.UNRECOGNIZED : result;
  }

  public static final int SAMPLE_RATE_HERTZ_FIELD_NUMBER = 2;
  private int sampleRateHertz_;
  /**
   *
   *
   * <pre>
   * Sample rate (in Hertz) of the audio content sent in the query.
   * Refer to
   * [Cloud Speech API
   * documentation](https://cloud.google.com/speech-to-text/docs/basics) for
   * more details.
   * </pre>
   *
   * <code>int32 sample_rate_hertz = 2;</code>
   *
   * @return The sampleRateHertz.
   */
  @java.lang.Override
  public int getSampleRateHertz() {
    return sampleRateHertz_;
  }

  public static final int ENABLE_WORD_INFO_FIELD_NUMBER = 13;
  private boolean enableWordInfo_;
  /**
   *
   *
   * <pre>
   * Optional. If `true`, Dialogflow returns [SpeechWordInfo][google.cloud.dialogflow.cx.v3.SpeechWordInfo] in
   * [StreamingRecognitionResult][google.cloud.dialogflow.cx.v3.StreamingRecognitionResult] with information about the recognized speech
   * words, e.g. start and end time offsets. If false or unspecified, Speech
   * doesn't return any word-level information.
   * </pre>
   *
   * <code>bool enable_word_info = 13;</code>
   *
   * @return The enableWordInfo.
   */
  @java.lang.Override
  public boolean getEnableWordInfo() {
    return enableWordInfo_;
  }

  public static final int PHRASE_HINTS_FIELD_NUMBER = 4;
  private com.google.protobuf.LazyStringList phraseHints_;
  /**
   *
   *
   * <pre>
   * Optional. A list of strings containing words and phrases that the speech
   * recognizer should recognize with higher likelihood.
   * See [the Cloud Speech
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
   * for more details.
   * </pre>
   *
   * <code>repeated string phrase_hints = 4;</code>
   *
   * @return A list containing the phraseHints.
   */
  public com.google.protobuf.ProtocolStringList getPhraseHintsList() {
    return phraseHints_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of strings containing words and phrases that the speech
   * recognizer should recognize with higher likelihood.
   * See [the Cloud Speech
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
   * for more details.
   * </pre>
   *
   * <code>repeated string phrase_hints = 4;</code>
   *
   * @return The count of phraseHints.
   */
  public int getPhraseHintsCount() {
    return phraseHints_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of strings containing words and phrases that the speech
   * recognizer should recognize with higher likelihood.
   * See [the Cloud Speech
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
   * for more details.
   * </pre>
   *
   * <code>repeated string phrase_hints = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The phraseHints at the given index.
   */
  public java.lang.String getPhraseHints(int index) {
    return phraseHints_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of strings containing words and phrases that the speech
   * recognizer should recognize with higher likelihood.
   * See [the Cloud Speech
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
   * for more details.
   * </pre>
   *
   * <code>repeated string phrase_hints = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the phraseHints at the given index.
   */
  public com.google.protobuf.ByteString getPhraseHintsBytes(int index) {
    return phraseHints_.getByteString(index);
  }

  public static final int MODEL_FIELD_NUMBER = 7;
  private volatile java.lang.Object model_;
  /**
   *
   *
   * <pre>
   * Optional. Which Speech model to select for the given request. Select the
   * model best suited to your domain to get best results. If a model is not
   * explicitly specified, then we auto-select a model based on the parameters
   * in the InputAudioConfig.
   * If enhanced speech model is enabled for the agent and an enhanced
   * version of the specified model for the language does not exist, then the
   * speech is recognized using the standard version of the specified model.
   * Refer to
   * [Cloud Speech API
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
   * for more details.
   * </pre>
   *
   * <code>string model = 7;</code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Which Speech model to select for the given request. Select the
   * model best suited to your domain to get best results. If a model is not
   * explicitly specified, then we auto-select a model based on the parameters
   * in the InputAudioConfig.
   * If enhanced speech model is enabled for the agent and an enhanced
   * version of the specified model for the language does not exist, then the
   * speech is recognized using the standard version of the specified model.
   * Refer to
   * [Cloud Speech API
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
   * for more details.
   * </pre>
   *
   * <code>string model = 7;</code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_VARIANT_FIELD_NUMBER = 10;
  private int modelVariant_;
  /**
   *
   *
   * <pre>
   * Optional. Which variant of the [Speech model][google.cloud.dialogflow.cx.v3.InputAudioConfig.model] to use.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SpeechModelVariant model_variant = 10;</code>
   *
   * @return The enum numeric value on the wire for modelVariant.
   */
  @java.lang.Override
  public int getModelVariantValue() {
    return modelVariant_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Which variant of the [Speech model][google.cloud.dialogflow.cx.v3.InputAudioConfig.model] to use.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SpeechModelVariant model_variant = 10;</code>
   *
   * @return The modelVariant.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SpeechModelVariant getModelVariant() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.cx.v3.SpeechModelVariant result =
        com.google.cloud.dialogflow.cx.v3.SpeechModelVariant.valueOf(modelVariant_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3.SpeechModelVariant.UNRECOGNIZED
        : result;
  }

  public static final int SINGLE_UTTERANCE_FIELD_NUMBER = 8;
  private boolean singleUtterance_;
  /**
   *
   *
   * <pre>
   * Optional. If `false` (default), recognition does not cease until the
   * client closes the stream.
   * If `true`, the recognizer will detect a single spoken utterance in input
   * audio. Recognition ceases when it detects the audio's voice has
   * stopped or paused. In this case, once a detected intent is received, the
   * client should close the stream and start a new request with a new stream as
   * needed.
   * Note: This setting is relevant only for streaming methods.
   * </pre>
   *
   * <code>bool single_utterance = 8;</code>
   *
   * @return The singleUtterance.
   */
  @java.lang.Override
  public boolean getSingleUtterance() {
    return singleUtterance_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (audioEncoding_
        != com.google.cloud.dialogflow.cx.v3.AudioEncoding.AUDIO_ENCODING_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, audioEncoding_);
    }
    if (sampleRateHertz_ != 0) {
      output.writeInt32(2, sampleRateHertz_);
    }
    for (int i = 0; i < phraseHints_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, phraseHints_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, model_);
    }
    if (singleUtterance_ != false) {
      output.writeBool(8, singleUtterance_);
    }
    if (modelVariant_
        != com.google.cloud.dialogflow.cx.v3.SpeechModelVariant.SPEECH_MODEL_VARIANT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, modelVariant_);
    }
    if (enableWordInfo_ != false) {
      output.writeBool(13, enableWordInfo_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (audioEncoding_
        != com.google.cloud.dialogflow.cx.v3.AudioEncoding.AUDIO_ENCODING_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, audioEncoding_);
    }
    if (sampleRateHertz_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, sampleRateHertz_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < phraseHints_.size(); i++) {
        dataSize += computeStringSizeNoTag(phraseHints_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPhraseHintsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, model_);
    }
    if (singleUtterance_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, singleUtterance_);
    }
    if (modelVariant_
        != com.google.cloud.dialogflow.cx.v3.SpeechModelVariant.SPEECH_MODEL_VARIANT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, modelVariant_);
    }
    if (enableWordInfo_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, enableWordInfo_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.InputAudioConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.InputAudioConfig other =
        (com.google.cloud.dialogflow.cx.v3.InputAudioConfig) obj;

    if (audioEncoding_ != other.audioEncoding_) return false;
    if (getSampleRateHertz() != other.getSampleRateHertz()) return false;
    if (getEnableWordInfo() != other.getEnableWordInfo()) return false;
    if (!getPhraseHintsList().equals(other.getPhraseHintsList())) return false;
    if (!getModel().equals(other.getModel())) return false;
    if (modelVariant_ != other.modelVariant_) return false;
    if (getSingleUtterance() != other.getSingleUtterance()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + AUDIO_ENCODING_FIELD_NUMBER;
    hash = (53 * hash) + audioEncoding_;
    hash = (37 * hash) + SAMPLE_RATE_HERTZ_FIELD_NUMBER;
    hash = (53 * hash) + getSampleRateHertz();
    hash = (37 * hash) + ENABLE_WORD_INFO_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableWordInfo());
    if (getPhraseHintsCount() > 0) {
      hash = (37 * hash) + PHRASE_HINTS_FIELD_NUMBER;
      hash = (53 * hash) + getPhraseHintsList().hashCode();
    }
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    hash = (37 * hash) + MODEL_VARIANT_FIELD_NUMBER;
    hash = (53 * hash) + modelVariant_;
    hash = (37 * hash) + SINGLE_UTTERANCE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSingleUtterance());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.InputAudioConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.InputAudioConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.InputAudioConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.InputAudioConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.InputAudioConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.InputAudioConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.InputAudioConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.InputAudioConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.InputAudioConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.InputAudioConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.InputAudioConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.InputAudioConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.InputAudioConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Instructs the speech recognizer on how to process the audio content.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.InputAudioConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.InputAudioConfig)
      com.google.cloud.dialogflow.cx.v3.InputAudioConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.AudioConfigProto
          .internal_static_google_cloud_dialogflow_cx_v3_InputAudioConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.AudioConfigProto
          .internal_static_google_cloud_dialogflow_cx_v3_InputAudioConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.InputAudioConfig.class,
              com.google.cloud.dialogflow.cx.v3.InputAudioConfig.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.InputAudioConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      audioEncoding_ = 0;

      sampleRateHertz_ = 0;

      enableWordInfo_ = false;

      phraseHints_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      model_ = "";

      modelVariant_ = 0;

      singleUtterance_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.AudioConfigProto
          .internal_static_google_cloud_dialogflow_cx_v3_InputAudioConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.InputAudioConfig getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.InputAudioConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.InputAudioConfig build() {
      com.google.cloud.dialogflow.cx.v3.InputAudioConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.InputAudioConfig buildPartial() {
      com.google.cloud.dialogflow.cx.v3.InputAudioConfig result =
          new com.google.cloud.dialogflow.cx.v3.InputAudioConfig(this);
      int from_bitField0_ = bitField0_;
      result.audioEncoding_ = audioEncoding_;
      result.sampleRateHertz_ = sampleRateHertz_;
      result.enableWordInfo_ = enableWordInfo_;
      if (((bitField0_ & 0x00000001) != 0)) {
        phraseHints_ = phraseHints_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.phraseHints_ = phraseHints_;
      result.model_ = model_;
      result.modelVariant_ = modelVariant_;
      result.singleUtterance_ = singleUtterance_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.InputAudioConfig) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.InputAudioConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.InputAudioConfig other) {
      if (other == com.google.cloud.dialogflow.cx.v3.InputAudioConfig.getDefaultInstance())
        return this;
      if (other.audioEncoding_ != 0) {
        setAudioEncodingValue(other.getAudioEncodingValue());
      }
      if (other.getSampleRateHertz() != 0) {
        setSampleRateHertz(other.getSampleRateHertz());
      }
      if (other.getEnableWordInfo() != false) {
        setEnableWordInfo(other.getEnableWordInfo());
      }
      if (!other.phraseHints_.isEmpty()) {
        if (phraseHints_.isEmpty()) {
          phraseHints_ = other.phraseHints_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensurePhraseHintsIsMutable();
          phraseHints_.addAll(other.phraseHints_);
        }
        onChanged();
      }
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        onChanged();
      }
      if (other.modelVariant_ != 0) {
        setModelVariantValue(other.getModelVariantValue());
      }
      if (other.getSingleUtterance() != false) {
        setSingleUtterance(other.getSingleUtterance());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                audioEncoding_ = input.readEnum();

                break;
              } // case 8
            case 16:
              {
                sampleRateHertz_ = input.readInt32();

                break;
              } // case 16
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePhraseHintsIsMutable();
                phraseHints_.add(s);
                break;
              } // case 34
            case 58:
              {
                model_ = input.readStringRequireUtf8();

                break;
              } // case 58
            case 64:
              {
                singleUtterance_ = input.readBool();

                break;
              } // case 64
            case 80:
              {
                modelVariant_ = input.readEnum();

                break;
              } // case 80
            case 104:
              {
                enableWordInfo_ = input.readBool();

                break;
              } // case 104
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int audioEncoding_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Audio encoding of the audio content to process.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for audioEncoding.
     */
    @java.lang.Override
    public int getAudioEncodingValue() {
      return audioEncoding_;
    }
    /**
     *
     *
     * <pre>
     * Required. Audio encoding of the audio content to process.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for audioEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setAudioEncodingValue(int value) {

      audioEncoding_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Audio encoding of the audio content to process.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The audioEncoding.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.AudioEncoding getAudioEncoding() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.cx.v3.AudioEncoding result =
          com.google.cloud.dialogflow.cx.v3.AudioEncoding.valueOf(audioEncoding_);
      return result == null ? com.google.cloud.dialogflow.cx.v3.AudioEncoding.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Audio encoding of the audio content to process.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The audioEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setAudioEncoding(com.google.cloud.dialogflow.cx.v3.AudioEncoding value) {
      if (value == null) {
        throw new NullPointerException();
      }

      audioEncoding_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Audio encoding of the audio content to process.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudioEncoding() {

      audioEncoding_ = 0;
      onChanged();
      return this;
    }

    private int sampleRateHertz_;
    /**
     *
     *
     * <pre>
     * Sample rate (in Hertz) of the audio content sent in the query.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics) for
     * more details.
     * </pre>
     *
     * <code>int32 sample_rate_hertz = 2;</code>
     *
     * @return The sampleRateHertz.
     */
    @java.lang.Override
    public int getSampleRateHertz() {
      return sampleRateHertz_;
    }
    /**
     *
     *
     * <pre>
     * Sample rate (in Hertz) of the audio content sent in the query.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics) for
     * more details.
     * </pre>
     *
     * <code>int32 sample_rate_hertz = 2;</code>
     *
     * @param value The sampleRateHertz to set.
     * @return This builder for chaining.
     */
    public Builder setSampleRateHertz(int value) {

      sampleRateHertz_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sample rate (in Hertz) of the audio content sent in the query.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics) for
     * more details.
     * </pre>
     *
     * <code>int32 sample_rate_hertz = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSampleRateHertz() {

      sampleRateHertz_ = 0;
      onChanged();
      return this;
    }

    private boolean enableWordInfo_;
    /**
     *
     *
     * <pre>
     * Optional. If `true`, Dialogflow returns [SpeechWordInfo][google.cloud.dialogflow.cx.v3.SpeechWordInfo] in
     * [StreamingRecognitionResult][google.cloud.dialogflow.cx.v3.StreamingRecognitionResult] with information about the recognized speech
     * words, e.g. start and end time offsets. If false or unspecified, Speech
     * doesn't return any word-level information.
     * </pre>
     *
     * <code>bool enable_word_info = 13;</code>
     *
     * @return The enableWordInfo.
     */
    @java.lang.Override
    public boolean getEnableWordInfo() {
      return enableWordInfo_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `true`, Dialogflow returns [SpeechWordInfo][google.cloud.dialogflow.cx.v3.SpeechWordInfo] in
     * [StreamingRecognitionResult][google.cloud.dialogflow.cx.v3.StreamingRecognitionResult] with information about the recognized speech
     * words, e.g. start and end time offsets. If false or unspecified, Speech
     * doesn't return any word-level information.
     * </pre>
     *
     * <code>bool enable_word_info = 13;</code>
     *
     * @param value The enableWordInfo to set.
     * @return This builder for chaining.
     */
    public Builder setEnableWordInfo(boolean value) {

      enableWordInfo_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `true`, Dialogflow returns [SpeechWordInfo][google.cloud.dialogflow.cx.v3.SpeechWordInfo] in
     * [StreamingRecognitionResult][google.cloud.dialogflow.cx.v3.StreamingRecognitionResult] with information about the recognized speech
     * words, e.g. start and end time offsets. If false or unspecified, Speech
     * doesn't return any word-level information.
     * </pre>
     *
     * <code>bool enable_word_info = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableWordInfo() {

      enableWordInfo_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList phraseHints_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensurePhraseHintsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        phraseHints_ = new com.google.protobuf.LazyStringArrayList(phraseHints_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated string phrase_hints = 4;</code>
     *
     * @return A list containing the phraseHints.
     */
    public com.google.protobuf.ProtocolStringList getPhraseHintsList() {
      return phraseHints_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated string phrase_hints = 4;</code>
     *
     * @return The count of phraseHints.
     */
    public int getPhraseHintsCount() {
      return phraseHints_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated string phrase_hints = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The phraseHints at the given index.
     */
    public java.lang.String getPhraseHints(int index) {
      return phraseHints_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated string phrase_hints = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the phraseHints at the given index.
     */
    public com.google.protobuf.ByteString getPhraseHintsBytes(int index) {
      return phraseHints_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated string phrase_hints = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The phraseHints to set.
     * @return This builder for chaining.
     */
    public Builder setPhraseHints(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePhraseHintsIsMutable();
      phraseHints_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated string phrase_hints = 4;</code>
     *
     * @param value The phraseHints to add.
     * @return This builder for chaining.
     */
    public Builder addPhraseHints(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePhraseHintsIsMutable();
      phraseHints_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated string phrase_hints = 4;</code>
     *
     * @param values The phraseHints to add.
     * @return This builder for chaining.
     */
    public Builder addAllPhraseHints(java.lang.Iterable<java.lang.String> values) {
      ensurePhraseHintsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, phraseHints_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated string phrase_hints = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPhraseHints() {
      phraseHints_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated string phrase_hints = 4;</code>
     *
     * @param value The bytes of the phraseHints to add.
     * @return This builder for chaining.
     */
    public Builder addPhraseHintsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePhraseHintsIsMutable();
      phraseHints_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Which Speech model to select for the given request. Select the
     * model best suited to your domain to get best results. If a model is not
     * explicitly specified, then we auto-select a model based on the parameters
     * in the InputAudioConfig.
     * If enhanced speech model is enabled for the agent and an enhanced
     * version of the specified model for the language does not exist, then the
     * speech is recognized using the standard version of the specified model.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
     * for more details.
     * </pre>
     *
     * <code>string model = 7;</code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Which Speech model to select for the given request. Select the
     * model best suited to your domain to get best results. If a model is not
     * explicitly specified, then we auto-select a model based on the parameters
     * in the InputAudioConfig.
     * If enhanced speech model is enabled for the agent and an enhanced
     * version of the specified model for the language does not exist, then the
     * speech is recognized using the standard version of the specified model.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
     * for more details.
     * </pre>
     *
     * <code>string model = 7;</code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Which Speech model to select for the given request. Select the
     * model best suited to your domain to get best results. If a model is not
     * explicitly specified, then we auto-select a model based on the parameters
     * in the InputAudioConfig.
     * If enhanced speech model is enabled for the agent and an enhanced
     * version of the specified model for the language does not exist, then the
     * speech is recognized using the standard version of the specified model.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
     * for more details.
     * </pre>
     *
     * <code>string model = 7;</code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      model_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Which Speech model to select for the given request. Select the
     * model best suited to your domain to get best results. If a model is not
     * explicitly specified, then we auto-select a model based on the parameters
     * in the InputAudioConfig.
     * If enhanced speech model is enabled for the agent and an enhanced
     * version of the specified model for the language does not exist, then the
     * speech is recognized using the standard version of the specified model.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
     * for more details.
     * </pre>
     *
     * <code>string model = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {

      model_ = getDefaultInstance().getModel();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Which Speech model to select for the given request. Select the
     * model best suited to your domain to get best results. If a model is not
     * explicitly specified, then we auto-select a model based on the parameters
     * in the InputAudioConfig.
     * If enhanced speech model is enabled for the agent and an enhanced
     * version of the specified model for the language does not exist, then the
     * speech is recognized using the standard version of the specified model.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
     * for more details.
     * </pre>
     *
     * <code>string model = 7;</code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      model_ = value;
      onChanged();
      return this;
    }

    private int modelVariant_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Which variant of the [Speech model][google.cloud.dialogflow.cx.v3.InputAudioConfig.model] to use.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechModelVariant model_variant = 10;</code>
     *
     * @return The enum numeric value on the wire for modelVariant.
     */
    @java.lang.Override
    public int getModelVariantValue() {
      return modelVariant_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Which variant of the [Speech model][google.cloud.dialogflow.cx.v3.InputAudioConfig.model] to use.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechModelVariant model_variant = 10;</code>
     *
     * @param value The enum numeric value on the wire for modelVariant to set.
     * @return This builder for chaining.
     */
    public Builder setModelVariantValue(int value) {

      modelVariant_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Which variant of the [Speech model][google.cloud.dialogflow.cx.v3.InputAudioConfig.model] to use.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechModelVariant model_variant = 10;</code>
     *
     * @return The modelVariant.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.SpeechModelVariant getModelVariant() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.cx.v3.SpeechModelVariant result =
          com.google.cloud.dialogflow.cx.v3.SpeechModelVariant.valueOf(modelVariant_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3.SpeechModelVariant.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Which variant of the [Speech model][google.cloud.dialogflow.cx.v3.InputAudioConfig.model] to use.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechModelVariant model_variant = 10;</code>
     *
     * @param value The modelVariant to set.
     * @return This builder for chaining.
     */
    public Builder setModelVariant(com.google.cloud.dialogflow.cx.v3.SpeechModelVariant value) {
      if (value == null) {
        throw new NullPointerException();
      }

      modelVariant_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Which variant of the [Speech model][google.cloud.dialogflow.cx.v3.InputAudioConfig.model] to use.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechModelVariant model_variant = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelVariant() {

      modelVariant_ = 0;
      onChanged();
      return this;
    }

    private boolean singleUtterance_;
    /**
     *
     *
     * <pre>
     * Optional. If `false` (default), recognition does not cease until the
     * client closes the stream.
     * If `true`, the recognizer will detect a single spoken utterance in input
     * audio. Recognition ceases when it detects the audio's voice has
     * stopped or paused. In this case, once a detected intent is received, the
     * client should close the stream and start a new request with a new stream as
     * needed.
     * Note: This setting is relevant only for streaming methods.
     * </pre>
     *
     * <code>bool single_utterance = 8;</code>
     *
     * @return The singleUtterance.
     */
    @java.lang.Override
    public boolean getSingleUtterance() {
      return singleUtterance_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `false` (default), recognition does not cease until the
     * client closes the stream.
     * If `true`, the recognizer will detect a single spoken utterance in input
     * audio. Recognition ceases when it detects the audio's voice has
     * stopped or paused. In this case, once a detected intent is received, the
     * client should close the stream and start a new request with a new stream as
     * needed.
     * Note: This setting is relevant only for streaming methods.
     * </pre>
     *
     * <code>bool single_utterance = 8;</code>
     *
     * @param value The singleUtterance to set.
     * @return This builder for chaining.
     */
    public Builder setSingleUtterance(boolean value) {

      singleUtterance_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `false` (default), recognition does not cease until the
     * client closes the stream.
     * If `true`, the recognizer will detect a single spoken utterance in input
     * audio. Recognition ceases when it detects the audio's voice has
     * stopped or paused. In this case, once a detected intent is received, the
     * client should close the stream and start a new request with a new stream as
     * needed.
     * Note: This setting is relevant only for streaming methods.
     * </pre>
     *
     * <code>bool single_utterance = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSingleUtterance() {

      singleUtterance_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.InputAudioConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.InputAudioConfig)
  private static final com.google.cloud.dialogflow.cx.v3.InputAudioConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.InputAudioConfig();
  }

  public static com.google.cloud.dialogflow.cx.v3.InputAudioConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InputAudioConfig> PARSER =
      new com.google.protobuf.AbstractParser<InputAudioConfig>() {
        @java.lang.Override
        public InputAudioConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InputAudioConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InputAudioConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.InputAudioConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
