/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/flow.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * The request message for [Flows.ImportFlow][google.cloud.dialogflow.cx.v3.Flows.ImportFlow].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.ImportFlowRequest}
 */
public final class ImportFlowRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.ImportFlowRequest)
    ImportFlowRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportFlowRequest.newBuilder() to construct.
  private ImportFlowRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportFlowRequest() {
    parent_ = "";
    importOption_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportFlowRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.FlowProto
        .internal_static_google_cloud_dialogflow_cx_v3_ImportFlowRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.FlowProto
        .internal_static_google_cloud_dialogflow_cx_v3_ImportFlowRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.class,
            com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Import option.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption}
   */
  public enum ImportOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. Treated as `KEEP`.
     * </pre>
     *
     * <code>IMPORT_OPTION_UNSPECIFIED = 0;</code>
     */
    IMPORT_OPTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Always respect settings in exported flow content. It may cause a
     * import failure if some settings (e.g. custom NLU) are not supported in
     * the agent to import into.
     * </pre>
     *
     * <code>KEEP = 1;</code>
     */
    KEEP(1),
    /**
     *
     *
     * <pre>
     * Fallback to default settings if some settings are not supported in the
     * agent to import into. E.g. Standard NLU will be used if custom NLU is
     * not available.
     * </pre>
     *
     * <code>FALLBACK = 2;</code>
     */
    FALLBACK(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. Treated as `KEEP`.
     * </pre>
     *
     * <code>IMPORT_OPTION_UNSPECIFIED = 0;</code>
     */
    public static final int IMPORT_OPTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Always respect settings in exported flow content. It may cause a
     * import failure if some settings (e.g. custom NLU) are not supported in
     * the agent to import into.
     * </pre>
     *
     * <code>KEEP = 1;</code>
     */
    public static final int KEEP_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Fallback to default settings if some settings are not supported in the
     * agent to import into. E.g. Standard NLU will be used if custom NLU is
     * not available.
     * </pre>
     *
     * <code>FALLBACK = 2;</code>
     */
    public static final int FALLBACK_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ImportOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ImportOption forNumber(int value) {
      switch (value) {
        case 0:
          return IMPORT_OPTION_UNSPECIFIED;
        case 1:
          return KEEP;
        case 2:
          return FALLBACK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ImportOption> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ImportOption> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ImportOption>() {
          public ImportOption findValueByNumber(int number) {
            return ImportOption.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ImportOption[] VALUES = values();

    public static ImportOption valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ImportOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption)
  }

  private int flowCase_ = 0;
  private java.lang.Object flow_;

  public enum FlowCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    FLOW_URI(2),
    FLOW_CONTENT(3),
    FLOW_NOT_SET(0);
    private final int value;

    private FlowCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FlowCase valueOf(int value) {
      return forNumber(value);
    }

    public static FlowCase forNumber(int value) {
      switch (value) {
        case 2:
          return FLOW_URI;
        case 3:
          return FLOW_CONTENT;
        case 0:
          return FLOW_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FlowCase getFlowCase() {
    return FlowCase.forNumber(flowCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. The agent to import the flow into.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The agent to import the flow into.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FLOW_URI_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to import flow from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string flow_uri = 2;</code>
   *
   * @return Whether the flowUri field is set.
   */
  public boolean hasFlowUri() {
    return flowCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to import flow from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string flow_uri = 2;</code>
   *
   * @return The flowUri.
   */
  public java.lang.String getFlowUri() {
    java.lang.Object ref = "";
    if (flowCase_ == 2) {
      ref = flow_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (flowCase_ == 2) {
        flow_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to import flow from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string flow_uri = 2;</code>
   *
   * @return The bytes for flowUri.
   */
  public com.google.protobuf.ByteString getFlowUriBytes() {
    java.lang.Object ref = "";
    if (flowCase_ == 2) {
      ref = flow_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (flowCase_ == 2) {
        flow_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FLOW_CONTENT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Uncompressed raw byte content for flow.
   * </pre>
   *
   * <code>bytes flow_content = 3;</code>
   *
   * @return Whether the flowContent field is set.
   */
  @java.lang.Override
  public boolean hasFlowContent() {
    return flowCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Uncompressed raw byte content for flow.
   * </pre>
   *
   * <code>bytes flow_content = 3;</code>
   *
   * @return The flowContent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFlowContent() {
    if (flowCase_ == 3) {
      return (com.google.protobuf.ByteString) flow_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int IMPORT_OPTION_FIELD_NUMBER = 4;
  private int importOption_;
  /**
   *
   *
   * <pre>
   * Flow import mode. If not specified, `KEEP` is assumed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption import_option = 4;</code>
   *
   * @return The enum numeric value on the wire for importOption.
   */
  @java.lang.Override
  public int getImportOptionValue() {
    return importOption_;
  }
  /**
   *
   *
   * <pre>
   * Flow import mode. If not specified, `KEEP` is assumed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption import_option = 4;</code>
   *
   * @return The importOption.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption getImportOption() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption result =
        com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption.valueOf(importOption_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (flowCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, flow_);
    }
    if (flowCase_ == 3) {
      output.writeBytes(3, (com.google.protobuf.ByteString) flow_);
    }
    if (importOption_
        != com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption
            .IMPORT_OPTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, importOption_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (flowCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, flow_);
    }
    if (flowCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              3, (com.google.protobuf.ByteString) flow_);
    }
    if (importOption_
        != com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption
            .IMPORT_OPTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, importOption_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.ImportFlowRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.ImportFlowRequest other =
        (com.google.cloud.dialogflow.cx.v3.ImportFlowRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (importOption_ != other.importOption_) return false;
    if (!getFlowCase().equals(other.getFlowCase())) return false;
    switch (flowCase_) {
      case 2:
        if (!getFlowUri().equals(other.getFlowUri())) return false;
        break;
      case 3:
        if (!getFlowContent().equals(other.getFlowContent())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + IMPORT_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + importOption_;
    switch (flowCase_) {
      case 2:
        hash = (37 * hash) + FLOW_URI_FIELD_NUMBER;
        hash = (53 * hash) + getFlowUri().hashCode();
        break;
      case 3:
        hash = (37 * hash) + FLOW_CONTENT_FIELD_NUMBER;
        hash = (53 * hash) + getFlowContent().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.ImportFlowRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.ImportFlowRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.ImportFlowRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.ImportFlowRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.ImportFlowRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.ImportFlowRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.ImportFlowRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.ImportFlowRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.ImportFlowRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.ImportFlowRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.ImportFlowRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.ImportFlowRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.ImportFlowRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for [Flows.ImportFlow][google.cloud.dialogflow.cx.v3.Flows.ImportFlow].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.ImportFlowRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.ImportFlowRequest)
      com.google.cloud.dialogflow.cx.v3.ImportFlowRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.FlowProto
          .internal_static_google_cloud_dialogflow_cx_v3_ImportFlowRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.FlowProto
          .internal_static_google_cloud_dialogflow_cx_v3_ImportFlowRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.class,
              com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      importOption_ = 0;

      flowCase_ = 0;
      flow_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.FlowProto
          .internal_static_google_cloud_dialogflow_cx_v3_ImportFlowRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ImportFlowRequest getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ImportFlowRequest build() {
      com.google.cloud.dialogflow.cx.v3.ImportFlowRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ImportFlowRequest buildPartial() {
      com.google.cloud.dialogflow.cx.v3.ImportFlowRequest result =
          new com.google.cloud.dialogflow.cx.v3.ImportFlowRequest(this);
      result.parent_ = parent_;
      if (flowCase_ == 2) {
        result.flow_ = flow_;
      }
      if (flowCase_ == 3) {
        result.flow_ = flow_;
      }
      result.importOption_ = importOption_;
      result.flowCase_ = flowCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.ImportFlowRequest) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.ImportFlowRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.ImportFlowRequest other) {
      if (other == com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (other.importOption_ != 0) {
        setImportOptionValue(other.getImportOptionValue());
      }
      switch (other.getFlowCase()) {
        case FLOW_URI:
          {
            flowCase_ = 2;
            flow_ = other.flow_;
            onChanged();
            break;
          }
        case FLOW_CONTENT:
          {
            setFlowContent(other.getFlowContent());
            break;
          }
        case FLOW_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                flowCase_ = 2;
                flow_ = s;
                break;
              } // case 18
            case 26:
              {
                flow_ = input.readBytes();
                flowCase_ = 3;
                break;
              } // case 26
            case 32:
              {
                importOption_ = input.readEnum();

                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int flowCase_ = 0;
    private java.lang.Object flow_;

    public FlowCase getFlowCase() {
      return FlowCase.forNumber(flowCase_);
    }

    public Builder clearFlow() {
      flowCase_ = 0;
      flow_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The agent to import the flow into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The agent to import the flow into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The agent to import the flow into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The agent to import the flow into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The agent to import the flow into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import flow from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string flow_uri = 2;</code>
     *
     * @return Whether the flowUri field is set.
     */
    @java.lang.Override
    public boolean hasFlowUri() {
      return flowCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import flow from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string flow_uri = 2;</code>
     *
     * @return The flowUri.
     */
    @java.lang.Override
    public java.lang.String getFlowUri() {
      java.lang.Object ref = "";
      if (flowCase_ == 2) {
        ref = flow_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (flowCase_ == 2) {
          flow_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import flow from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string flow_uri = 2;</code>
     *
     * @return The bytes for flowUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFlowUriBytes() {
      java.lang.Object ref = "";
      if (flowCase_ == 2) {
        ref = flow_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (flowCase_ == 2) {
          flow_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import flow from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string flow_uri = 2;</code>
     *
     * @param value The flowUri to set.
     * @return This builder for chaining.
     */
    public Builder setFlowUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      flowCase_ = 2;
      flow_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import flow from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string flow_uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFlowUri() {
      if (flowCase_ == 2) {
        flowCase_ = 0;
        flow_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
     * to import flow from. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string flow_uri = 2;</code>
     *
     * @param value The bytes for flowUri to set.
     * @return This builder for chaining.
     */
    public Builder setFlowUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      flowCase_ = 2;
      flow_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Uncompressed raw byte content for flow.
     * </pre>
     *
     * <code>bytes flow_content = 3;</code>
     *
     * @return Whether the flowContent field is set.
     */
    public boolean hasFlowContent() {
      return flowCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed raw byte content for flow.
     * </pre>
     *
     * <code>bytes flow_content = 3;</code>
     *
     * @return The flowContent.
     */
    public com.google.protobuf.ByteString getFlowContent() {
      if (flowCase_ == 3) {
        return (com.google.protobuf.ByteString) flow_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed raw byte content for flow.
     * </pre>
     *
     * <code>bytes flow_content = 3;</code>
     *
     * @param value The flowContent to set.
     * @return This builder for chaining.
     */
    public Builder setFlowContent(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      flowCase_ = 3;
      flow_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uncompressed raw byte content for flow.
     * </pre>
     *
     * <code>bytes flow_content = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFlowContent() {
      if (flowCase_ == 3) {
        flowCase_ = 0;
        flow_ = null;
        onChanged();
      }
      return this;
    }

    private int importOption_ = 0;
    /**
     *
     *
     * <pre>
     * Flow import mode. If not specified, `KEEP` is assumed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption import_option = 4;</code>
     *
     * @return The enum numeric value on the wire for importOption.
     */
    @java.lang.Override
    public int getImportOptionValue() {
      return importOption_;
    }
    /**
     *
     *
     * <pre>
     * Flow import mode. If not specified, `KEEP` is assumed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption import_option = 4;</code>
     *
     * @param value The enum numeric value on the wire for importOption to set.
     * @return This builder for chaining.
     */
    public Builder setImportOptionValue(int value) {

      importOption_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Flow import mode. If not specified, `KEEP` is assumed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption import_option = 4;</code>
     *
     * @return The importOption.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption getImportOption() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption result =
          com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption.valueOf(importOption_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Flow import mode. If not specified, `KEEP` is assumed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption import_option = 4;</code>
     *
     * @param value The importOption to set.
     * @return This builder for chaining.
     */
    public Builder setImportOption(
        com.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption value) {
      if (value == null) {
        throw new NullPointerException();
      }

      importOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Flow import mode. If not specified, `KEEP` is assumed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.ImportFlowRequest.ImportOption import_option = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportOption() {

      importOption_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.ImportFlowRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.ImportFlowRequest)
  private static final com.google.cloud.dialogflow.cx.v3.ImportFlowRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.ImportFlowRequest();
  }

  public static com.google.cloud.dialogflow.cx.v3.ImportFlowRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportFlowRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportFlowRequest>() {
        @java.lang.Override
        public ImportFlowRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportFlowRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportFlowRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ImportFlowRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
