/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/fulfillment.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * A fulfillment can do one or more of the following actions at the same time:
 *   * Generate rich message responses.
 *   * Set parameter values.
 *   * Call the webhook.
 * Fulfillments can be called at various stages in the [Page][google.cloud.dialogflow.cx.v3.Page] or
 * [Form][google.cloud.dialogflow.cx.v3.Form] lifecycle. For example, when a [DetectIntentRequest][google.cloud.dialogflow.cx.v3.DetectIntentRequest] drives a
 * session to enter a new page, the page's entry fulfillment can add a static
 * response to the [QueryResult][google.cloud.dialogflow.cx.v3.QueryResult] in the returning [DetectIntentResponse][google.cloud.dialogflow.cx.v3.DetectIntentResponse],
 * call the webhook (for example, to load user data from a database), or both.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.Fulfillment}
 */
public final class Fulfillment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Fulfillment)
    FulfillmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Fulfillment.newBuilder() to construct.
  private Fulfillment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Fulfillment() {
    messages_ = java.util.Collections.emptyList();
    webhook_ = "";
    tag_ = "";
    setParameterActions_ = java.util.Collections.emptyList();
    conditionalCases_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Fulfillment();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
        .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
        .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.Fulfillment.class,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder.class);
  }

  public interface SetParameterActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Display name of the parameter.
     * </pre>
     *
     * <code>string parameter = 1;</code>
     *
     * @return The parameter.
     */
    java.lang.String getParameter();
    /**
     *
     *
     * <pre>
     * Display name of the parameter.
     * </pre>
     *
     * <code>string parameter = 1;</code>
     *
     * @return The bytes for parameter.
     */
    com.google.protobuf.ByteString getParameterBytes();

    /**
     *
     *
     * <pre>
     * The new value of the parameter. A null value clears the parameter.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2;</code>
     *
     * @return Whether the value field is set.
     */
    boolean hasValue();
    /**
     *
     *
     * <pre>
     * The new value of the parameter. A null value clears the parameter.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2;</code>
     *
     * @return The value.
     */
    com.google.protobuf.Value getValue();
    /**
     *
     *
     * <pre>
     * The new value of the parameter. A null value clears the parameter.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2;</code>
     */
    com.google.protobuf.ValueOrBuilder getValueOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Setting a parameter value.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction}
   */
  public static final class SetParameterAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction)
      SetParameterActionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SetParameterAction.newBuilder() to construct.
    private SetParameterAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SetParameterAction() {
      parameter_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SetParameterAction();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_SetParameterAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_SetParameterAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.class,
              com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.Builder.class);
    }

    public static final int PARAMETER_FIELD_NUMBER = 1;
    private volatile java.lang.Object parameter_;
    /**
     *
     *
     * <pre>
     * Display name of the parameter.
     * </pre>
     *
     * <code>string parameter = 1;</code>
     *
     * @return The parameter.
     */
    @java.lang.Override
    public java.lang.String getParameter() {
      java.lang.Object ref = parameter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parameter_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name of the parameter.
     * </pre>
     *
     * <code>string parameter = 1;</code>
     *
     * @return The bytes for parameter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getParameterBytes() {
      java.lang.Object ref = parameter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parameter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private com.google.protobuf.Value value_;
    /**
     *
     *
     * <pre>
     * The new value of the parameter. A null value clears the parameter.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2;</code>
     *
     * @return Whether the value field is set.
     */
    @java.lang.Override
    public boolean hasValue() {
      return value_ != null;
    }
    /**
     *
     *
     * <pre>
     * The new value of the parameter. A null value clears the parameter.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public com.google.protobuf.Value getValue() {
      return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
    }
    /**
     *
     *
     * <pre>
     * The new value of the parameter. A null value clears the parameter.
     * </pre>
     *
     * <code>.google.protobuf.Value value = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.ValueOrBuilder getValueOrBuilder() {
      return getValue();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parameter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parameter_);
      }
      if (value_ != null) {
        output.writeMessage(2, getValue());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parameter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parameter_);
      }
      if (value_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getValue());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction other =
          (com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction) obj;

      if (!getParameter().equals(other.getParameter())) return false;
      if (hasValue() != other.hasValue()) return false;
      if (hasValue()) {
        if (!getValue().equals(other.getValue())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARAMETER_FIELD_NUMBER;
      hash = (53 * hash) + getParameter().hashCode();
      if (hasValue()) {
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValue().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Setting a parameter value.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction)
        com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_SetParameterAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_SetParameterAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.class,
                com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        parameter_ = "";

        if (valueBuilder_ == null) {
          value_ = null;
        } else {
          value_ = null;
          valueBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_SetParameterAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction build() {
        com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction buildPartial() {
        com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction result =
            new com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction(this);
        result.parameter_ = parameter_;
        if (valueBuilder_ == null) {
          result.value_ = value_;
        } else {
          result.value_ = valueBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction
                .getDefaultInstance()) return this;
        if (!other.getParameter().isEmpty()) {
          parameter_ = other.parameter_;
          onChanged();
        }
        if (other.hasValue()) {
          mergeValue(other.getValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  parameter_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getValueFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object parameter_ = "";
      /**
       *
       *
       * <pre>
       * Display name of the parameter.
       * </pre>
       *
       * <code>string parameter = 1;</code>
       *
       * @return The parameter.
       */
      public java.lang.String getParameter() {
        java.lang.Object ref = parameter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parameter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Display name of the parameter.
       * </pre>
       *
       * <code>string parameter = 1;</code>
       *
       * @return The bytes for parameter.
       */
      public com.google.protobuf.ByteString getParameterBytes() {
        java.lang.Object ref = parameter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parameter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Display name of the parameter.
       * </pre>
       *
       * <code>string parameter = 1;</code>
       *
       * @param value The parameter to set.
       * @return This builder for chaining.
       */
      public Builder setParameter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        parameter_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display name of the parameter.
       * </pre>
       *
       * <code>string parameter = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParameter() {

        parameter_ = getDefaultInstance().getParameter();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display name of the parameter.
       * </pre>
       *
       * <code>string parameter = 1;</code>
       *
       * @param value The bytes for parameter to set.
       * @return This builder for chaining.
       */
      public Builder setParameterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        parameter_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.Value value_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder,
              com.google.protobuf.ValueOrBuilder>
          valueBuilder_;
      /**
       *
       *
       * <pre>
       * The new value of the parameter. A null value clears the parameter.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2;</code>
       *
       * @return Whether the value field is set.
       */
      public boolean hasValue() {
        return valueBuilder_ != null || value_ != null;
      }
      /**
       *
       *
       * <pre>
       * The new value of the parameter. A null value clears the parameter.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2;</code>
       *
       * @return The value.
       */
      public com.google.protobuf.Value getValue() {
        if (valueBuilder_ == null) {
          return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
        } else {
          return valueBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The new value of the parameter. A null value clears the parameter.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2;</code>
       */
      public Builder setValue(com.google.protobuf.Value value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
          onChanged();
        } else {
          valueBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The new value of the parameter. A null value clears the parameter.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2;</code>
       */
      public Builder setValue(com.google.protobuf.Value.Builder builderForValue) {
        if (valueBuilder_ == null) {
          value_ = builderForValue.build();
          onChanged();
        } else {
          valueBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The new value of the parameter. A null value clears the parameter.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2;</code>
       */
      public Builder mergeValue(com.google.protobuf.Value value) {
        if (valueBuilder_ == null) {
          if (value_ != null) {
            value_ = com.google.protobuf.Value.newBuilder(value_).mergeFrom(value).buildPartial();
          } else {
            value_ = value;
          }
          onChanged();
        } else {
          valueBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The new value of the parameter. A null value clears the parameter.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2;</code>
       */
      public Builder clearValue() {
        if (valueBuilder_ == null) {
          value_ = null;
          onChanged();
        } else {
          value_ = null;
          valueBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The new value of the parameter. A null value clears the parameter.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2;</code>
       */
      public com.google.protobuf.Value.Builder getValueBuilder() {

        onChanged();
        return getValueFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The new value of the parameter. A null value clears the parameter.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2;</code>
       */
      public com.google.protobuf.ValueOrBuilder getValueOrBuilder() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilder();
        } else {
          return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
        }
      }
      /**
       *
       *
       * <pre>
       * The new value of the parameter. A null value clears the parameter.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder,
              com.google.protobuf.ValueOrBuilder>
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Value,
                  com.google.protobuf.Value.Builder,
                  com.google.protobuf.ValueOrBuilder>(
                  getValue(), getParentForChildren(), isClean());
          value_ = null;
        }
        return valueBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction)
    private static final com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction();
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SetParameterAction> PARSER =
        new com.google.protobuf.AbstractParser<SetParameterAction>() {
          @java.lang.Override
          public SetParameterAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SetParameterAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SetParameterAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConditionalCasesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of cascading if-else conditions.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
     * </code>
     */
    java.util.List<com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case>
        getCasesList();
    /**
     *
     *
     * <pre>
     * A list of cascading if-else conditions.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case getCases(int index);
    /**
     *
     *
     * <pre>
     * A list of cascading if-else conditions.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
     * </code>
     */
    int getCasesCount();
    /**
     *
     *
     * <pre>
     * A list of cascading if-else conditions.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.CaseOrBuilder>
        getCasesOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of cascading if-else conditions.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.CaseOrBuilder getCasesOrBuilder(
        int index);
  }
  /**
   *
   *
   * <pre>
   * A list of cascading if-else conditions. Cases are mutually exclusive.
   * The first one with a matching condition is selected, all the rest ignored.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases}
   */
  public static final class ConditionalCases extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases)
      ConditionalCasesOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConditionalCases.newBuilder() to construct.
    private ConditionalCases(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConditionalCases() {
      cases_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConditionalCases();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_ConditionalCases_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_ConditionalCases_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.class,
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder.class);
    }

    public interface CaseOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The condition to activate and select this case. Empty means the
       * condition is always true. The condition is evaluated against [form
       * parameters][Form.parameters] or [session
       * parameters][SessionInfo.parameters].
       * See the [conditions
       * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The condition.
       */
      java.lang.String getCondition();
      /**
       *
       *
       * <pre>
       * The condition to activate and select this case. Empty means the
       * condition is always true. The condition is evaluated against [form
       * parameters][Form.parameters] or [session
       * parameters][SessionInfo.parameters].
       * See the [conditions
       * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The bytes for condition.
       */
      com.google.protobuf.ByteString getConditionBytes();

      /**
       *
       *
       * <pre>
       * A list of case content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
       * </code>
       */
      java.util.List<
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent>
          getCaseContentList();
      /**
       *
       *
       * <pre>
       * A list of case content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
       * </code>
       */
      com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
          getCaseContent(int index);
      /**
       *
       *
       * <pre>
       * A list of case content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
       * </code>
       */
      int getCaseContentCount();
      /**
       *
       *
       * <pre>
       * A list of case content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                      .CaseContentOrBuilder>
          getCaseContentOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of case content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
       * </code>
       */
      com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContentOrBuilder
          getCaseContentOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Each case has a Boolean condition. When it is evaluated to be True, the
     * corresponding messages will be selected and evaluated recursively.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case}
     */
    public static final class Case extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case)
        CaseOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Case.newBuilder() to construct.
      private Case(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Case() {
        condition_ = "";
        caseContent_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Case();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_ConditionalCases_Case_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_ConditionalCases_Case_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.class,
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.Builder.class);
      }

      public interface CaseContentOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Returned message.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.ResponseMessage message = 1;</code>
         *
         * @return Whether the message field is set.
         */
        boolean hasMessage();
        /**
         *
         *
         * <pre>
         * Returned message.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.ResponseMessage message = 1;</code>
         *
         * @return The message.
         */
        com.google.cloud.dialogflow.cx.v3.ResponseMessage getMessage();
        /**
         *
         *
         * <pre>
         * Returned message.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.ResponseMessage message = 1;</code>
         */
        com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder getMessageOrBuilder();

        /**
         *
         *
         * <pre>
         * Additional cases to be evaluated.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases additional_cases = 2;
         * </code>
         *
         * @return Whether the additionalCases field is set.
         */
        boolean hasAdditionalCases();
        /**
         *
         *
         * <pre>
         * Additional cases to be evaluated.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases additional_cases = 2;
         * </code>
         *
         * @return The additionalCases.
         */
        com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases getAdditionalCases();
        /**
         *
         *
         * <pre>
         * Additional cases to be evaluated.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases additional_cases = 2;
         * </code>
         */
        com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCasesOrBuilder
            getAdditionalCasesOrBuilder();

        public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                .CasesOrMessageCase
            getCasesOrMessageCase();
      }
      /**
       *
       *
       * <pre>
       * The list of messages or conditional cases to activate for this case.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent}
       */
      public static final class CaseContent extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent)
          CaseContentOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use CaseContent.newBuilder() to construct.
        private CaseContent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private CaseContent() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new CaseContent();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
          return this.unknownFields;
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_ConditionalCases_Case_CaseContent_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_ConditionalCases_Case_CaseContent_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                      .class,
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                      .Builder.class);
        }

        private int casesOrMessageCase_ = 0;
        private java.lang.Object casesOrMessage_;

        public enum CasesOrMessageCase
            implements
                com.google.protobuf.Internal.EnumLite,
                com.google.protobuf.AbstractMessage.InternalOneOfEnum {
          MESSAGE(1),
          ADDITIONAL_CASES(2),
          CASESORMESSAGE_NOT_SET(0);
          private final int value;

          private CasesOrMessageCase(int value) {
            this.value = value;
          }
          /**
           * @param value The number of the enum to look for.
           * @return The enum associated with the given number.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static CasesOrMessageCase valueOf(int value) {
            return forNumber(value);
          }

          public static CasesOrMessageCase forNumber(int value) {
            switch (value) {
              case 1:
                return MESSAGE;
              case 2:
                return ADDITIONAL_CASES;
              case 0:
                return CASESORMESSAGE_NOT_SET;
              default:
                return null;
            }
          }

          public int getNumber() {
            return this.value;
          }
        };

        public CasesOrMessageCase getCasesOrMessageCase() {
          return CasesOrMessageCase.forNumber(casesOrMessageCase_);
        }

        public static final int MESSAGE_FIELD_NUMBER = 1;
        /**
         *
         *
         * <pre>
         * Returned message.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.ResponseMessage message = 1;</code>
         *
         * @return Whether the message field is set.
         */
        @java.lang.Override
        public boolean hasMessage() {
          return casesOrMessageCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * Returned message.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.ResponseMessage message = 1;</code>
         *
         * @return The message.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.ResponseMessage getMessage() {
          if (casesOrMessageCase_ == 1) {
            return (com.google.cloud.dialogflow.cx.v3.ResponseMessage) casesOrMessage_;
          }
          return com.google.cloud.dialogflow.cx.v3.ResponseMessage.getDefaultInstance();
        }
        /**
         *
         *
         * <pre>
         * Returned message.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.ResponseMessage message = 1;</code>
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder getMessageOrBuilder() {
          if (casesOrMessageCase_ == 1) {
            return (com.google.cloud.dialogflow.cx.v3.ResponseMessage) casesOrMessage_;
          }
          return com.google.cloud.dialogflow.cx.v3.ResponseMessage.getDefaultInstance();
        }

        public static final int ADDITIONAL_CASES_FIELD_NUMBER = 2;
        /**
         *
         *
         * <pre>
         * Additional cases to be evaluated.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases additional_cases = 2;
         * </code>
         *
         * @return Whether the additionalCases field is set.
         */
        @java.lang.Override
        public boolean hasAdditionalCases() {
          return casesOrMessageCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Additional cases to be evaluated.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases additional_cases = 2;
         * </code>
         *
         * @return The additionalCases.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases getAdditionalCases() {
          if (casesOrMessageCase_ == 2) {
            return (com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases) casesOrMessage_;
          }
          return com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases
              .getDefaultInstance();
        }
        /**
         *
         *
         * <pre>
         * Additional cases to be evaluated.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases additional_cases = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCasesOrBuilder
            getAdditionalCasesOrBuilder() {
          if (casesOrMessageCase_ == 2) {
            return (com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases) casesOrMessage_;
          }
          return com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases
              .getDefaultInstance();
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (casesOrMessageCase_ == 1) {
            output.writeMessage(
                1, (com.google.cloud.dialogflow.cx.v3.ResponseMessage) casesOrMessage_);
          }
          if (casesOrMessageCase_ == 2) {
            output.writeMessage(
                2,
                (com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases) casesOrMessage_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (casesOrMessageCase_ == 1) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    1, (com.google.cloud.dialogflow.cx.v3.ResponseMessage) casesOrMessage_);
          }
          if (casesOrMessageCase_ == 2) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    2,
                    (com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases)
                        casesOrMessage_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent)) {
            return super.equals(obj);
          }
          com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent other =
              (com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent) obj;

          if (!getCasesOrMessageCase().equals(other.getCasesOrMessageCase())) return false;
          switch (casesOrMessageCase_) {
            case 1:
              if (!getMessage().equals(other.getMessage())) return false;
              break;
            case 2:
              if (!getAdditionalCases().equals(other.getAdditionalCases())) return false;
              break;
            case 0:
            default:
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          switch (casesOrMessageCase_) {
            case 1:
              hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
              hash = (53 * hash) + getMessage().hashCode();
              break;
            case 2:
              hash = (37 * hash) + ADDITIONAL_CASES_FIELD_NUMBER;
              hash = (53 * hash) + getAdditionalCases().hashCode();
              break;
            case 0:
            default:
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContent
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContent
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContent
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContent
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContent
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContent
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContent
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContent
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContent
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContent
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContent
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContent
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * The list of messages or conditional cases to activate for this case.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent)
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContentOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
                .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_ConditionalCases_Case_CaseContent_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
                .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_ConditionalCases_Case_CaseContent_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                        .class,
                    com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                        .Builder.class);
          }

          // Construct using
          // com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            if (messageBuilder_ != null) {
              messageBuilder_.clear();
            }
            if (additionalCasesBuilder_ != null) {
              additionalCasesBuilder_.clear();
            }
            casesOrMessageCase_ = 0;
            casesOrMessage_ = null;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
                .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_ConditionalCases_Case_CaseContent_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
              getDefaultInstanceForType() {
            return com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
              build() {
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
              buildPartial() {
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent result =
                new com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent(
                    this);
            if (casesOrMessageCase_ == 1) {
              if (messageBuilder_ == null) {
                result.casesOrMessage_ = casesOrMessage_;
              } else {
                result.casesOrMessage_ = messageBuilder_.build();
              }
            }
            if (casesOrMessageCase_ == 2) {
              if (additionalCasesBuilder_ == null) {
                result.casesOrMessage_ = casesOrMessage_;
              } else {
                result.casesOrMessage_ = additionalCasesBuilder_.build();
              }
            }
            result.casesOrMessageCase_ = casesOrMessageCase_;
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent) {
              return mergeFrom(
                  (com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                  other) {
            if (other
                == com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                    .getDefaultInstance()) return this;
            switch (other.getCasesOrMessageCase()) {
              case MESSAGE:
                {
                  mergeMessage(other.getMessage());
                  break;
                }
              case ADDITIONAL_CASES:
                {
                  mergeAdditionalCases(other.getAdditionalCases());
                  break;
                }
              case CASESORMESSAGE_NOT_SET:
                {
                  break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(getMessageFieldBuilder().getBuilder(), extensionRegistry);
                      casesOrMessageCase_ = 1;
                      break;
                    } // case 10
                  case 18:
                    {
                      input.readMessage(
                          getAdditionalCasesFieldBuilder().getBuilder(), extensionRegistry);
                      casesOrMessageCase_ = 2;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int casesOrMessageCase_ = 0;
          private java.lang.Object casesOrMessage_;

          public CasesOrMessageCase getCasesOrMessageCase() {
            return CasesOrMessageCase.forNumber(casesOrMessageCase_);
          }

          public Builder clearCasesOrMessage() {
            casesOrMessageCase_ = 0;
            casesOrMessage_ = null;
            onChanged();
            return this;
          }

          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.ResponseMessage,
                  com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder,
                  com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>
              messageBuilder_;
          /**
           *
           *
           * <pre>
           * Returned message.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.ResponseMessage message = 1;</code>
           *
           * @return Whether the message field is set.
           */
          @java.lang.Override
          public boolean hasMessage() {
            return casesOrMessageCase_ == 1;
          }
          /**
           *
           *
           * <pre>
           * Returned message.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.ResponseMessage message = 1;</code>
           *
           * @return The message.
           */
          @java.lang.Override
          public com.google.cloud.dialogflow.cx.v3.ResponseMessage getMessage() {
            if (messageBuilder_ == null) {
              if (casesOrMessageCase_ == 1) {
                return (com.google.cloud.dialogflow.cx.v3.ResponseMessage) casesOrMessage_;
              }
              return com.google.cloud.dialogflow.cx.v3.ResponseMessage.getDefaultInstance();
            } else {
              if (casesOrMessageCase_ == 1) {
                return messageBuilder_.getMessage();
              }
              return com.google.cloud.dialogflow.cx.v3.ResponseMessage.getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * Returned message.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.ResponseMessage message = 1;</code>
           */
          public Builder setMessage(com.google.cloud.dialogflow.cx.v3.ResponseMessage value) {
            if (messageBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              casesOrMessage_ = value;
              onChanged();
            } else {
              messageBuilder_.setMessage(value);
            }
            casesOrMessageCase_ = 1;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Returned message.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.ResponseMessage message = 1;</code>
           */
          public Builder setMessage(
              com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder builderForValue) {
            if (messageBuilder_ == null) {
              casesOrMessage_ = builderForValue.build();
              onChanged();
            } else {
              messageBuilder_.setMessage(builderForValue.build());
            }
            casesOrMessageCase_ = 1;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Returned message.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.ResponseMessage message = 1;</code>
           */
          public Builder mergeMessage(com.google.cloud.dialogflow.cx.v3.ResponseMessage value) {
            if (messageBuilder_ == null) {
              if (casesOrMessageCase_ == 1
                  && casesOrMessage_
                      != com.google.cloud.dialogflow.cx.v3.ResponseMessage.getDefaultInstance()) {
                casesOrMessage_ =
                    com.google.cloud.dialogflow.cx.v3.ResponseMessage.newBuilder(
                            (com.google.cloud.dialogflow.cx.v3.ResponseMessage) casesOrMessage_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                casesOrMessage_ = value;
              }
              onChanged();
            } else {
              if (casesOrMessageCase_ == 1) {
                messageBuilder_.mergeFrom(value);
              } else {
                messageBuilder_.setMessage(value);
              }
            }
            casesOrMessageCase_ = 1;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Returned message.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.ResponseMessage message = 1;</code>
           */
          public Builder clearMessage() {
            if (messageBuilder_ == null) {
              if (casesOrMessageCase_ == 1) {
                casesOrMessageCase_ = 0;
                casesOrMessage_ = null;
                onChanged();
              }
            } else {
              if (casesOrMessageCase_ == 1) {
                casesOrMessageCase_ = 0;
                casesOrMessage_ = null;
              }
              messageBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Returned message.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.ResponseMessage message = 1;</code>
           */
          public com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder getMessageBuilder() {
            return getMessageFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Returned message.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.ResponseMessage message = 1;</code>
           */
          @java.lang.Override
          public com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder getMessageOrBuilder() {
            if ((casesOrMessageCase_ == 1) && (messageBuilder_ != null)) {
              return messageBuilder_.getMessageOrBuilder();
            } else {
              if (casesOrMessageCase_ == 1) {
                return (com.google.cloud.dialogflow.cx.v3.ResponseMessage) casesOrMessage_;
              }
              return com.google.cloud.dialogflow.cx.v3.ResponseMessage.getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * Returned message.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.ResponseMessage message = 1;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.ResponseMessage,
                  com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder,
                  com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>
              getMessageFieldBuilder() {
            if (messageBuilder_ == null) {
              if (!(casesOrMessageCase_ == 1)) {
                casesOrMessage_ =
                    com.google.cloud.dialogflow.cx.v3.ResponseMessage.getDefaultInstance();
              }
              messageBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.dialogflow.cx.v3.ResponseMessage,
                      com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder,
                      com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>(
                      (com.google.cloud.dialogflow.cx.v3.ResponseMessage) casesOrMessage_,
                      getParentForChildren(),
                      isClean());
              casesOrMessage_ = null;
            }
            casesOrMessageCase_ = 1;
            onChanged();
            ;
            return messageBuilder_;
          }

          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases,
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder,
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCasesOrBuilder>
              additionalCasesBuilder_;
          /**
           *
           *
           * <pre>
           * Additional cases to be evaluated.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases additional_cases = 2;
           * </code>
           *
           * @return Whether the additionalCases field is set.
           */
          @java.lang.Override
          public boolean hasAdditionalCases() {
            return casesOrMessageCase_ == 2;
          }
          /**
           *
           *
           * <pre>
           * Additional cases to be evaluated.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases additional_cases = 2;
           * </code>
           *
           * @return The additionalCases.
           */
          @java.lang.Override
          public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases
              getAdditionalCases() {
            if (additionalCasesBuilder_ == null) {
              if (casesOrMessageCase_ == 2) {
                return (com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases)
                    casesOrMessage_;
              }
              return com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases
                  .getDefaultInstance();
            } else {
              if (casesOrMessageCase_ == 2) {
                return additionalCasesBuilder_.getMessage();
              }
              return com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases
                  .getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * Additional cases to be evaluated.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases additional_cases = 2;
           * </code>
           */
          public Builder setAdditionalCases(
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases value) {
            if (additionalCasesBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              casesOrMessage_ = value;
              onChanged();
            } else {
              additionalCasesBuilder_.setMessage(value);
            }
            casesOrMessageCase_ = 2;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Additional cases to be evaluated.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases additional_cases = 2;
           * </code>
           */
          public Builder setAdditionalCases(
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder
                  builderForValue) {
            if (additionalCasesBuilder_ == null) {
              casesOrMessage_ = builderForValue.build();
              onChanged();
            } else {
              additionalCasesBuilder_.setMessage(builderForValue.build());
            }
            casesOrMessageCase_ = 2;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Additional cases to be evaluated.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases additional_cases = 2;
           * </code>
           */
          public Builder mergeAdditionalCases(
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases value) {
            if (additionalCasesBuilder_ == null) {
              if (casesOrMessageCase_ == 2
                  && casesOrMessage_
                      != com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases
                          .getDefaultInstance()) {
                casesOrMessage_ =
                    com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.newBuilder(
                            (com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases)
                                casesOrMessage_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                casesOrMessage_ = value;
              }
              onChanged();
            } else {
              if (casesOrMessageCase_ == 2) {
                additionalCasesBuilder_.mergeFrom(value);
              } else {
                additionalCasesBuilder_.setMessage(value);
              }
            }
            casesOrMessageCase_ = 2;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Additional cases to be evaluated.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases additional_cases = 2;
           * </code>
           */
          public Builder clearAdditionalCases() {
            if (additionalCasesBuilder_ == null) {
              if (casesOrMessageCase_ == 2) {
                casesOrMessageCase_ = 0;
                casesOrMessage_ = null;
                onChanged();
              }
            } else {
              if (casesOrMessageCase_ == 2) {
                casesOrMessageCase_ = 0;
                casesOrMessage_ = null;
              }
              additionalCasesBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Additional cases to be evaluated.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases additional_cases = 2;
           * </code>
           */
          public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder
              getAdditionalCasesBuilder() {
            return getAdditionalCasesFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Additional cases to be evaluated.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases additional_cases = 2;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCasesOrBuilder
              getAdditionalCasesOrBuilder() {
            if ((casesOrMessageCase_ == 2) && (additionalCasesBuilder_ != null)) {
              return additionalCasesBuilder_.getMessageOrBuilder();
            } else {
              if (casesOrMessageCase_ == 2) {
                return (com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases)
                    casesOrMessage_;
              }
              return com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases
                  .getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * Additional cases to be evaluated.
           * </pre>
           *
           * <code>.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases additional_cases = 2;
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases,
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder,
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCasesOrBuilder>
              getAdditionalCasesFieldBuilder() {
            if (additionalCasesBuilder_ == null) {
              if (!(casesOrMessageCase_ == 2)) {
                casesOrMessage_ =
                    com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases
                        .getDefaultInstance();
              }
              additionalCasesBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases,
                      com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder,
                      com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCasesOrBuilder>(
                      (com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases)
                          casesOrMessage_,
                      getParentForChildren(),
                      isClean());
              casesOrMessage_ = null;
            }
            casesOrMessageCase_ = 2;
            onChanged();
            ;
            return additionalCasesBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent)
        private static final com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContent
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent();
        }

        public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContent
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<CaseContent> PARSER =
            new com.google.protobuf.AbstractParser<CaseContent>() {
              @java.lang.Override
              public CaseContent parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<CaseContent> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<CaseContent> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int CONDITION_FIELD_NUMBER = 1;
      private volatile java.lang.Object condition_;
      /**
       *
       *
       * <pre>
       * The condition to activate and select this case. Empty means the
       * condition is always true. The condition is evaluated against [form
       * parameters][Form.parameters] or [session
       * parameters][SessionInfo.parameters].
       * See the [conditions
       * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The condition.
       */
      @java.lang.Override
      public java.lang.String getCondition() {
        java.lang.Object ref = condition_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          condition_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The condition to activate and select this case. Empty means the
       * condition is always true. The condition is evaluated against [form
       * parameters][Form.parameters] or [session
       * parameters][SessionInfo.parameters].
       * See the [conditions
       * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The bytes for condition.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getConditionBytes() {
        java.lang.Object ref = condition_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          condition_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CASE_CONTENT_FIELD_NUMBER = 2;
      private java.util.List<
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent>
          caseContent_;
      /**
       *
       *
       * <pre>
       * A list of case content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent>
          getCaseContentList() {
        return caseContent_;
      }
      /**
       *
       *
       * <pre>
       * A list of case content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                      .CaseContentOrBuilder>
          getCaseContentOrBuilderList() {
        return caseContent_;
      }
      /**
       *
       *
       * <pre>
       * A list of case content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
       * </code>
       */
      @java.lang.Override
      public int getCaseContentCount() {
        return caseContent_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of case content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
          getCaseContent(int index) {
        return caseContent_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of case content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
              .CaseContentOrBuilder
          getCaseContentOrBuilder(int index) {
        return caseContent_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, condition_);
        }
        for (int i = 0; i < caseContent_.size(); i++) {
          output.writeMessage(2, caseContent_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, condition_);
        }
        for (int i = 0; i < caseContent_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, caseContent_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case other =
            (com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case) obj;

        if (!getCondition().equals(other.getCondition())) return false;
        if (!getCaseContentList().equals(other.getCaseContentList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CONDITION_FIELD_NUMBER;
        hash = (53 * hash) + getCondition().hashCode();
        if (getCaseContentCount() > 0) {
          hash = (37 * hash) + CASE_CONTENT_FIELD_NUMBER;
          hash = (53 * hash) + getCaseContentList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Each case has a Boolean condition. When it is evaluated to be True, the
       * corresponding messages will be selected and evaluated recursively.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case)
          com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.CaseOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_ConditionalCases_Case_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_ConditionalCases_Case_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.class,
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          condition_ = "";

          if (caseContentBuilder_ == null) {
            caseContent_ = java.util.Collections.emptyList();
          } else {
            caseContent_ = null;
            caseContentBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_ConditionalCases_Case_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case build() {
          com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case buildPartial() {
          com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case result =
              new com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case(this);
          int from_bitField0_ = bitField0_;
          result.condition_ = condition_;
          if (caseContentBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              caseContent_ = java.util.Collections.unmodifiableList(caseContent_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.caseContent_ = caseContent_;
          } else {
            result.caseContent_ = caseContentBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                  .getDefaultInstance()) return this;
          if (!other.getCondition().isEmpty()) {
            condition_ = other.condition_;
            onChanged();
          }
          if (caseContentBuilder_ == null) {
            if (!other.caseContent_.isEmpty()) {
              if (caseContent_.isEmpty()) {
                caseContent_ = other.caseContent_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureCaseContentIsMutable();
                caseContent_.addAll(other.caseContent_);
              }
              onChanged();
            }
          } else {
            if (!other.caseContent_.isEmpty()) {
              if (caseContentBuilder_.isEmpty()) {
                caseContentBuilder_.dispose();
                caseContentBuilder_ = null;
                caseContent_ = other.caseContent_;
                bitField0_ = (bitField0_ & ~0x00000001);
                caseContentBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getCaseContentFieldBuilder()
                        : null;
              } else {
                caseContentBuilder_.addAllMessages(other.caseContent_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    condition_ = input.readStringRequireUtf8();

                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                        m =
                            input.readMessage(
                                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                                    .CaseContent.parser(),
                                extensionRegistry);
                    if (caseContentBuilder_ == null) {
                      ensureCaseContentIsMutable();
                      caseContent_.add(m);
                    } else {
                      caseContentBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object condition_ = "";
        /**
         *
         *
         * <pre>
         * The condition to activate and select this case. Empty means the
         * condition is always true. The condition is evaluated against [form
         * parameters][Form.parameters] or [session
         * parameters][SessionInfo.parameters].
         * See the [conditions
         * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @return The condition.
         */
        public java.lang.String getCondition() {
          java.lang.Object ref = condition_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            condition_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The condition to activate and select this case. Empty means the
         * condition is always true. The condition is evaluated against [form
         * parameters][Form.parameters] or [session
         * parameters][SessionInfo.parameters].
         * See the [conditions
         * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @return The bytes for condition.
         */
        public com.google.protobuf.ByteString getConditionBytes() {
          java.lang.Object ref = condition_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            condition_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The condition to activate and select this case. Empty means the
         * condition is always true. The condition is evaluated against [form
         * parameters][Form.parameters] or [session
         * parameters][SessionInfo.parameters].
         * See the [conditions
         * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @param value The condition to set.
         * @return This builder for chaining.
         */
        public Builder setCondition(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          condition_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The condition to activate and select this case. Empty means the
         * condition is always true. The condition is evaluated against [form
         * parameters][Form.parameters] or [session
         * parameters][SessionInfo.parameters].
         * See the [conditions
         * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCondition() {

          condition_ = getDefaultInstance().getCondition();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The condition to activate and select this case. Empty means the
         * condition is always true. The condition is evaluated against [form
         * parameters][Form.parameters] or [session
         * parameters][SessionInfo.parameters].
         * See the [conditions
         * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @param value The bytes for condition to set.
         * @return This builder for chaining.
         */
        public Builder setConditionBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          condition_ = value;
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent>
            caseContent_ = java.util.Collections.emptyList();

        private void ensureCaseContentIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            caseContent_ =
                new java.util.ArrayList<
                    com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                        .CaseContent>(caseContent_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent,
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                    .Builder,
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                    .CaseContentOrBuilder>
            caseContentBuilder_;

        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent>
            getCaseContentList() {
          if (caseContentBuilder_ == null) {
            return java.util.Collections.unmodifiableList(caseContent_);
          } else {
            return caseContentBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public int getCaseContentCount() {
          if (caseContentBuilder_ == null) {
            return caseContent_.size();
          } else {
            return caseContentBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
            getCaseContent(int index) {
          if (caseContentBuilder_ == null) {
            return caseContent_.get(index);
          } else {
            return caseContentBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public Builder setCaseContent(
            int index,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent value) {
          if (caseContentBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCaseContentIsMutable();
            caseContent_.set(index, value);
            onChanged();
          } else {
            caseContentBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public Builder setCaseContent(
            int index,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent.Builder
                builderForValue) {
          if (caseContentBuilder_ == null) {
            ensureCaseContentIsMutable();
            caseContent_.set(index, builderForValue.build());
            onChanged();
          } else {
            caseContentBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public Builder addCaseContent(
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent value) {
          if (caseContentBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCaseContentIsMutable();
            caseContent_.add(value);
            onChanged();
          } else {
            caseContentBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public Builder addCaseContent(
            int index,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent value) {
          if (caseContentBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCaseContentIsMutable();
            caseContent_.add(index, value);
            onChanged();
          } else {
            caseContentBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public Builder addCaseContent(
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent.Builder
                builderForValue) {
          if (caseContentBuilder_ == null) {
            ensureCaseContentIsMutable();
            caseContent_.add(builderForValue.build());
            onChanged();
          } else {
            caseContentBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public Builder addCaseContent(
            int index,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent.Builder
                builderForValue) {
          if (caseContentBuilder_ == null) {
            ensureCaseContentIsMutable();
            caseContent_.add(index, builderForValue.build());
            onChanged();
          } else {
            caseContentBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public Builder addAllCaseContent(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                            .CaseContent>
                values) {
          if (caseContentBuilder_ == null) {
            ensureCaseContentIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, caseContent_);
            onChanged();
          } else {
            caseContentBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public Builder clearCaseContent() {
          if (caseContentBuilder_ == null) {
            caseContent_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            caseContentBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public Builder removeCaseContent(int index) {
          if (caseContentBuilder_ == null) {
            ensureCaseContentIsMutable();
            caseContent_.remove(index);
            onChanged();
          } else {
            caseContentBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                .Builder
            getCaseContentBuilder(int index) {
          return getCaseContentFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                .CaseContentOrBuilder
            getCaseContentOrBuilder(int index) {
          if (caseContentBuilder_ == null) {
            return caseContent_.get(index);
          } else {
            return caseContentBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                        .CaseContentOrBuilder>
            getCaseContentOrBuilderList() {
          if (caseContentBuilder_ != null) {
            return caseContentBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(caseContent_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                .Builder
            addCaseContentBuilder() {
          return getCaseContentFieldBuilder()
              .addBuilder(
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                .Builder
            addCaseContentBuilder(int index) {
          return getCaseContentFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of case content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent case_content = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                    .Builder>
            getCaseContentBuilderList() {
          return getCaseContentFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent,
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                    .Builder,
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                    .CaseContentOrBuilder>
            getCaseContentFieldBuilder() {
          if (caseContentBuilder_ == null) {
            caseContentBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent,
                    com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.CaseContent
                        .Builder,
                    com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                        .CaseContentOrBuilder>(
                    caseContent_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            caseContent_ = null;
          }
          return caseContentBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case)
      private static final com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case();
      }

      public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Case> PARSER =
          new com.google.protobuf.AbstractParser<Case>() {
            @java.lang.Override
            public Case parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Case> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Case> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int CASES_FIELD_NUMBER = 1;
    private java.util.List<com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case>
        cases_;
    /**
     *
     *
     * <pre>
     * A list of cascading if-else conditions.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case>
        getCasesList() {
      return cases_;
    }
    /**
     *
     *
     * <pre>
     * A list of cascading if-else conditions.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.CaseOrBuilder>
        getCasesOrBuilderList() {
      return cases_;
    }
    /**
     *
     *
     * <pre>
     * A list of cascading if-else conditions.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
     * </code>
     */
    @java.lang.Override
    public int getCasesCount() {
      return cases_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of cascading if-else conditions.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case getCases(int index) {
      return cases_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of cascading if-else conditions.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.CaseOrBuilder
        getCasesOrBuilder(int index) {
      return cases_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < cases_.size(); i++) {
        output.writeMessage(1, cases_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < cases_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, cases_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases other =
          (com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases) obj;

      if (!getCasesList().equals(other.getCasesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getCasesCount() > 0) {
        hash = (37 * hash) + CASES_FIELD_NUMBER;
        hash = (53 * hash) + getCasesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A list of cascading if-else conditions. Cases are mutually exclusive.
     * The first one with a matching condition is selected, all the rest ignored.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases)
        com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCasesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_ConditionalCases_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_ConditionalCases_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.class,
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (casesBuilder_ == null) {
          cases_ = java.util.Collections.emptyList();
        } else {
          cases_ = null;
          casesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_ConditionalCases_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases build() {
        com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases buildPartial() {
        com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases result =
            new com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases(this);
        int from_bitField0_ = bitField0_;
        if (casesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            cases_ = java.util.Collections.unmodifiableList(cases_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.cases_ = cases_;
        } else {
          result.cases_ = casesBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.getDefaultInstance())
          return this;
        if (casesBuilder_ == null) {
          if (!other.cases_.isEmpty()) {
            if (cases_.isEmpty()) {
              cases_ = other.cases_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureCasesIsMutable();
              cases_.addAll(other.cases_);
            }
            onChanged();
          }
        } else {
          if (!other.cases_.isEmpty()) {
            if (casesBuilder_.isEmpty()) {
              casesBuilder_.dispose();
              casesBuilder_ = null;
              cases_ = other.cases_;
              bitField0_ = (bitField0_ & ~0x00000001);
              casesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getCasesFieldBuilder()
                      : null;
            } else {
              casesBuilder_.addAllMessages(other.cases_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case m =
                      input.readMessage(
                          com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                              .parser(),
                          extensionRegistry);
                  if (casesBuilder_ == null) {
                    ensureCasesIsMutable();
                    cases_.add(m);
                  } else {
                    casesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case>
          cases_ = java.util.Collections.emptyList();

      private void ensureCasesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          cases_ =
              new java.util.ArrayList<
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case>(cases_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case,
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.Builder,
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.CaseOrBuilder>
          casesBuilder_;

      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case>
          getCasesList() {
        if (casesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(cases_);
        } else {
          return casesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public int getCasesCount() {
        if (casesBuilder_ == null) {
          return cases_.size();
        } else {
          return casesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case getCases(
          int index) {
        if (casesBuilder_ == null) {
          return cases_.get(index);
        } else {
          return casesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public Builder setCases(
          int index, com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case value) {
        if (casesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCasesIsMutable();
          cases_.set(index, value);
          onChanged();
        } else {
          casesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public Builder setCases(
          int index,
          com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.Builder
              builderForValue) {
        if (casesBuilder_ == null) {
          ensureCasesIsMutable();
          cases_.set(index, builderForValue.build());
          onChanged();
        } else {
          casesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public Builder addCases(
          com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case value) {
        if (casesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCasesIsMutable();
          cases_.add(value);
          onChanged();
        } else {
          casesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public Builder addCases(
          int index, com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case value) {
        if (casesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCasesIsMutable();
          cases_.add(index, value);
          onChanged();
        } else {
          casesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public Builder addCases(
          com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.Builder
              builderForValue) {
        if (casesBuilder_ == null) {
          ensureCasesIsMutable();
          cases_.add(builderForValue.build());
          onChanged();
        } else {
          casesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public Builder addCases(
          int index,
          com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.Builder
              builderForValue) {
        if (casesBuilder_ == null) {
          ensureCasesIsMutable();
          cases_.add(index, builderForValue.build());
          onChanged();
        } else {
          casesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public Builder addAllCases(
          java.lang.Iterable<
                  ? extends com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case>
              values) {
        if (casesBuilder_ == null) {
          ensureCasesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cases_);
          onChanged();
        } else {
          casesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public Builder clearCases() {
        if (casesBuilder_ == null) {
          cases_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          casesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public Builder removeCases(int index) {
        if (casesBuilder_ == null) {
          ensureCasesIsMutable();
          cases_.remove(index);
          onChanged();
        } else {
          casesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.Builder
          getCasesBuilder(int index) {
        return getCasesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.CaseOrBuilder
          getCasesOrBuilder(int index) {
        if (casesBuilder_ == null) {
          return cases_.get(index);
        } else {
          return casesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.CaseOrBuilder>
          getCasesOrBuilderList() {
        if (casesBuilder_ != null) {
          return casesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(cases_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.Builder
          addCasesBuilder() {
        return getCasesFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.Builder
          addCasesBuilder(int index) {
        return getCasesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of cascading if-else conditions.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case cases = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.Builder>
          getCasesBuilderList() {
        return getCasesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case,
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.Builder,
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.CaseOrBuilder>
          getCasesFieldBuilder() {
        if (casesBuilder_ == null) {
          casesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case,
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Case.Builder,
                  com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.CaseOrBuilder>(
                  cases_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          cases_ = null;
        }
        return casesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases)
    private static final com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases();
    }

    public static com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConditionalCases> PARSER =
        new com.google.protobuf.AbstractParser<ConditionalCases>() {
          @java.lang.Override
          public ConditionalCases parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConditionalCases> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConditionalCases> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int MESSAGES_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage> messages_;
  /**
   *
   *
   * <pre>
   * The list of rich message responses to present to the user.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage> getMessagesList() {
    return messages_;
  }
  /**
   *
   *
   * <pre>
   * The list of rich message responses to present to the user.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>
      getMessagesOrBuilderList() {
    return messages_;
  }
  /**
   *
   *
   * <pre>
   * The list of rich message responses to present to the user.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
   */
  @java.lang.Override
  public int getMessagesCount() {
    return messages_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of rich message responses to present to the user.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ResponseMessage getMessages(int index) {
    return messages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of rich message responses to present to the user.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder getMessagesOrBuilder(
      int index) {
    return messages_.get(index);
  }

  public static final int WEBHOOK_FIELD_NUMBER = 2;
  private volatile java.lang.Object webhook_;
  /**
   *
   *
   * <pre>
   * The webhook to call.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/webhooks/&lt;Webhook ID&gt;`.
   * </pre>
   *
   * <code>string webhook = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The webhook.
   */
  @java.lang.Override
  public java.lang.String getWebhook() {
    java.lang.Object ref = webhook_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      webhook_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The webhook to call.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/webhooks/&lt;Webhook ID&gt;`.
   * </pre>
   *
   * <code>string webhook = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for webhook.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWebhookBytes() {
    java.lang.Object ref = webhook_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      webhook_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RETURN_PARTIAL_RESPONSES_FIELD_NUMBER = 8;
  private boolean returnPartialResponses_;
  /**
   *
   *
   * <pre>
   * Whether Dialogflow should return currently queued fulfillment response
   * messages in streaming APIs. If a webhook is specified, it happens before
   * Dialogflow invokes webhook.
   * Warning:
   * 1) This flag only affects streaming API. Responses are still queued
   * and returned once in non-streaming API.
   * 2) The flag can be enabled in any fulfillment but only the first 3 partial
   * responses will be returned. You may only want to apply it to fulfillments
   * that have slow webhooks.
   * </pre>
   *
   * <code>bool return_partial_responses = 8;</code>
   *
   * @return The returnPartialResponses.
   */
  @java.lang.Override
  public boolean getReturnPartialResponses() {
    return returnPartialResponses_;
  }

  public static final int TAG_FIELD_NUMBER = 3;
  private volatile java.lang.Object tag_;
  /**
   *
   *
   * <pre>
   * The value of this field will be populated in the [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]
   * `fulfillmentInfo.tag` field by Dialogflow when the associated webhook is
   * called.
   * The tag is typically used by the webhook service to identify which
   * fulfillment is being called, but it could be used for other purposes.
   * This field is required if `webhook` is specified.
   * </pre>
   *
   * <code>string tag = 3;</code>
   *
   * @return The tag.
   */
  @java.lang.Override
  public java.lang.String getTag() {
    java.lang.Object ref = tag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The value of this field will be populated in the [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]
   * `fulfillmentInfo.tag` field by Dialogflow when the associated webhook is
   * called.
   * The tag is typically used by the webhook service to identify which
   * fulfillment is being called, but it could be used for other purposes.
   * This field is required if `webhook` is specified.
   * </pre>
   *
   * <code>string tag = 3;</code>
   *
   * @return The bytes for tag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTagBytes() {
    java.lang.Object ref = tag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SET_PARAMETER_ACTIONS_FIELD_NUMBER = 4;
  private java.util.List<com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction>
      setParameterActions_;
  /**
   *
   *
   * <pre>
   * Set parameter values before executing the webhook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction>
      getSetParameterActionsList() {
    return setParameterActions_;
  }
  /**
   *
   *
   * <pre>
   * Set parameter values before executing the webhook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterActionOrBuilder>
      getSetParameterActionsOrBuilderList() {
    return setParameterActions_;
  }
  /**
   *
   *
   * <pre>
   * Set parameter values before executing the webhook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
   * </code>
   */
  @java.lang.Override
  public int getSetParameterActionsCount() {
    return setParameterActions_.size();
  }
  /**
   *
   *
   * <pre>
   * Set parameter values before executing the webhook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction getSetParameterActions(
      int index) {
    return setParameterActions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Set parameter values before executing the webhook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterActionOrBuilder
      getSetParameterActionsOrBuilder(int index) {
    return setParameterActions_.get(index);
  }

  public static final int CONDITIONAL_CASES_FIELD_NUMBER = 5;
  private java.util.List<com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases>
      conditionalCases_;
  /**
   *
   *
   * <pre>
   * Conditional cases for this fulfillment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases>
      getConditionalCasesList() {
    return conditionalCases_;
  }
  /**
   *
   *
   * <pre>
   * Conditional cases for this fulfillment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCasesOrBuilder>
      getConditionalCasesOrBuilderList() {
    return conditionalCases_;
  }
  /**
   *
   *
   * <pre>
   * Conditional cases for this fulfillment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
   * </code>
   */
  @java.lang.Override
  public int getConditionalCasesCount() {
    return conditionalCases_.size();
  }
  /**
   *
   *
   * <pre>
   * Conditional cases for this fulfillment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases getConditionalCases(
      int index) {
    return conditionalCases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Conditional cases for this fulfillment.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCasesOrBuilder
      getConditionalCasesOrBuilder(int index) {
    return conditionalCases_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < messages_.size(); i++) {
      output.writeMessage(1, messages_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(webhook_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, webhook_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tag_);
    }
    for (int i = 0; i < setParameterActions_.size(); i++) {
      output.writeMessage(4, setParameterActions_.get(i));
    }
    for (int i = 0; i < conditionalCases_.size(); i++) {
      output.writeMessage(5, conditionalCases_.get(i));
    }
    if (returnPartialResponses_ != false) {
      output.writeBool(8, returnPartialResponses_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < messages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, messages_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(webhook_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, webhook_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, tag_);
    }
    for (int i = 0; i < setParameterActions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, setParameterActions_.get(i));
    }
    for (int i = 0; i < conditionalCases_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, conditionalCases_.get(i));
    }
    if (returnPartialResponses_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, returnPartialResponses_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Fulfillment)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.Fulfillment other =
        (com.google.cloud.dialogflow.cx.v3.Fulfillment) obj;

    if (!getMessagesList().equals(other.getMessagesList())) return false;
    if (!getWebhook().equals(other.getWebhook())) return false;
    if (getReturnPartialResponses() != other.getReturnPartialResponses()) return false;
    if (!getTag().equals(other.getTag())) return false;
    if (!getSetParameterActionsList().equals(other.getSetParameterActionsList())) return false;
    if (!getConditionalCasesList().equals(other.getConditionalCasesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getMessagesCount() > 0) {
      hash = (37 * hash) + MESSAGES_FIELD_NUMBER;
      hash = (53 * hash) + getMessagesList().hashCode();
    }
    hash = (37 * hash) + WEBHOOK_FIELD_NUMBER;
    hash = (53 * hash) + getWebhook().hashCode();
    hash = (37 * hash) + RETURN_PARTIAL_RESPONSES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReturnPartialResponses());
    hash = (37 * hash) + TAG_FIELD_NUMBER;
    hash = (53 * hash) + getTag().hashCode();
    if (getSetParameterActionsCount() > 0) {
      hash = (37 * hash) + SET_PARAMETER_ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSetParameterActionsList().hashCode();
    }
    if (getConditionalCasesCount() > 0) {
      hash = (37 * hash) + CONDITIONAL_CASES_FIELD_NUMBER;
      hash = (53 * hash) + getConditionalCasesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.Fulfillment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Fulfillment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Fulfillment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Fulfillment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Fulfillment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Fulfillment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Fulfillment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Fulfillment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Fulfillment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Fulfillment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Fulfillment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Fulfillment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.Fulfillment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A fulfillment can do one or more of the following actions at the same time:
   *   * Generate rich message responses.
   *   * Set parameter values.
   *   * Call the webhook.
   * Fulfillments can be called at various stages in the [Page][google.cloud.dialogflow.cx.v3.Page] or
   * [Form][google.cloud.dialogflow.cx.v3.Form] lifecycle. For example, when a [DetectIntentRequest][google.cloud.dialogflow.cx.v3.DetectIntentRequest] drives a
   * session to enter a new page, the page's entry fulfillment can add a static
   * response to the [QueryResult][google.cloud.dialogflow.cx.v3.QueryResult] in the returning [DetectIntentResponse][google.cloud.dialogflow.cx.v3.DetectIntentResponse],
   * call the webhook (for example, to load user data from a database), or both.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Fulfillment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Fulfillment)
      com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Fulfillment.class,
              com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.Fulfillment.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (messagesBuilder_ == null) {
        messages_ = java.util.Collections.emptyList();
      } else {
        messages_ = null;
        messagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      webhook_ = "";

      returnPartialResponses_ = false;

      tag_ = "";

      if (setParameterActionsBuilder_ == null) {
        setParameterActions_ = java.util.Collections.emptyList();
      } else {
        setParameterActions_ = null;
        setParameterActionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (conditionalCasesBuilder_ == null) {
        conditionalCases_ = java.util.Collections.emptyList();
      } else {
        conditionalCases_ = null;
        conditionalCasesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.FulfillmentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Fulfillment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Fulfillment getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.Fulfillment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Fulfillment build() {
      com.google.cloud.dialogflow.cx.v3.Fulfillment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Fulfillment buildPartial() {
      com.google.cloud.dialogflow.cx.v3.Fulfillment result =
          new com.google.cloud.dialogflow.cx.v3.Fulfillment(this);
      int from_bitField0_ = bitField0_;
      if (messagesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          messages_ = java.util.Collections.unmodifiableList(messages_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.messages_ = messages_;
      } else {
        result.messages_ = messagesBuilder_.build();
      }
      result.webhook_ = webhook_;
      result.returnPartialResponses_ = returnPartialResponses_;
      result.tag_ = tag_;
      if (setParameterActionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          setParameterActions_ = java.util.Collections.unmodifiableList(setParameterActions_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.setParameterActions_ = setParameterActions_;
      } else {
        result.setParameterActions_ = setParameterActionsBuilder_.build();
      }
      if (conditionalCasesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          conditionalCases_ = java.util.Collections.unmodifiableList(conditionalCases_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.conditionalCases_ = conditionalCases_;
      } else {
        result.conditionalCases_ = conditionalCasesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.Fulfillment) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.Fulfillment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.Fulfillment other) {
      if (other == com.google.cloud.dialogflow.cx.v3.Fulfillment.getDefaultInstance()) return this;
      if (messagesBuilder_ == null) {
        if (!other.messages_.isEmpty()) {
          if (messages_.isEmpty()) {
            messages_ = other.messages_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureMessagesIsMutable();
            messages_.addAll(other.messages_);
          }
          onChanged();
        }
      } else {
        if (!other.messages_.isEmpty()) {
          if (messagesBuilder_.isEmpty()) {
            messagesBuilder_.dispose();
            messagesBuilder_ = null;
            messages_ = other.messages_;
            bitField0_ = (bitField0_ & ~0x00000001);
            messagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMessagesFieldBuilder()
                    : null;
          } else {
            messagesBuilder_.addAllMessages(other.messages_);
          }
        }
      }
      if (!other.getWebhook().isEmpty()) {
        webhook_ = other.webhook_;
        onChanged();
      }
      if (other.getReturnPartialResponses() != false) {
        setReturnPartialResponses(other.getReturnPartialResponses());
      }
      if (!other.getTag().isEmpty()) {
        tag_ = other.tag_;
        onChanged();
      }
      if (setParameterActionsBuilder_ == null) {
        if (!other.setParameterActions_.isEmpty()) {
          if (setParameterActions_.isEmpty()) {
            setParameterActions_ = other.setParameterActions_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSetParameterActionsIsMutable();
            setParameterActions_.addAll(other.setParameterActions_);
          }
          onChanged();
        }
      } else {
        if (!other.setParameterActions_.isEmpty()) {
          if (setParameterActionsBuilder_.isEmpty()) {
            setParameterActionsBuilder_.dispose();
            setParameterActionsBuilder_ = null;
            setParameterActions_ = other.setParameterActions_;
            bitField0_ = (bitField0_ & ~0x00000002);
            setParameterActionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSetParameterActionsFieldBuilder()
                    : null;
          } else {
            setParameterActionsBuilder_.addAllMessages(other.setParameterActions_);
          }
        }
      }
      if (conditionalCasesBuilder_ == null) {
        if (!other.conditionalCases_.isEmpty()) {
          if (conditionalCases_.isEmpty()) {
            conditionalCases_ = other.conditionalCases_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureConditionalCasesIsMutable();
            conditionalCases_.addAll(other.conditionalCases_);
          }
          onChanged();
        }
      } else {
        if (!other.conditionalCases_.isEmpty()) {
          if (conditionalCasesBuilder_.isEmpty()) {
            conditionalCasesBuilder_.dispose();
            conditionalCasesBuilder_ = null;
            conditionalCases_ = other.conditionalCases_;
            bitField0_ = (bitField0_ & ~0x00000004);
            conditionalCasesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConditionalCasesFieldBuilder()
                    : null;
          } else {
            conditionalCasesBuilder_.addAllMessages(other.conditionalCases_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.dialogflow.cx.v3.ResponseMessage m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.ResponseMessage.parser(),
                        extensionRegistry);
                if (messagesBuilder_ == null) {
                  ensureMessagesIsMutable();
                  messages_.add(m);
                } else {
                  messagesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                webhook_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                tag_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.parser(),
                        extensionRegistry);
                if (setParameterActionsBuilder_ == null) {
                  ensureSetParameterActionsIsMutable();
                  setParameterActions_.add(m);
                } else {
                  setParameterActionsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.parser(),
                        extensionRegistry);
                if (conditionalCasesBuilder_ == null) {
                  ensureConditionalCasesIsMutable();
                  conditionalCases_.add(m);
                } else {
                  conditionalCasesBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 64:
              {
                returnPartialResponses_ = input.readBool();

                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage> messages_ =
        java.util.Collections.emptyList();

    private void ensureMessagesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        messages_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.ResponseMessage>(messages_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.ResponseMessage,
            com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder,
            com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>
        messagesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage> getMessagesList() {
      if (messagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(messages_);
      } else {
        return messagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public int getMessagesCount() {
      if (messagesBuilder_ == null) {
        return messages_.size();
      } else {
        return messagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ResponseMessage getMessages(int index) {
      if (messagesBuilder_ == null) {
        return messages_.get(index);
      } else {
        return messagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public Builder setMessages(int index, com.google.cloud.dialogflow.cx.v3.ResponseMessage value) {
      if (messagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMessagesIsMutable();
        messages_.set(index, value);
        onChanged();
      } else {
        messagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public Builder setMessages(
        int index, com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder builderForValue) {
      if (messagesBuilder_ == null) {
        ensureMessagesIsMutable();
        messages_.set(index, builderForValue.build());
        onChanged();
      } else {
        messagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public Builder addMessages(com.google.cloud.dialogflow.cx.v3.ResponseMessage value) {
      if (messagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMessagesIsMutable();
        messages_.add(value);
        onChanged();
      } else {
        messagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public Builder addMessages(int index, com.google.cloud.dialogflow.cx.v3.ResponseMessage value) {
      if (messagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMessagesIsMutable();
        messages_.add(index, value);
        onChanged();
      } else {
        messagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public Builder addMessages(
        com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder builderForValue) {
      if (messagesBuilder_ == null) {
        ensureMessagesIsMutable();
        messages_.add(builderForValue.build());
        onChanged();
      } else {
        messagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public Builder addMessages(
        int index, com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder builderForValue) {
      if (messagesBuilder_ == null) {
        ensureMessagesIsMutable();
        messages_.add(index, builderForValue.build());
        onChanged();
      } else {
        messagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public Builder addAllMessages(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.ResponseMessage> values) {
      if (messagesBuilder_ == null) {
        ensureMessagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, messages_);
        onChanged();
      } else {
        messagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public Builder clearMessages() {
      if (messagesBuilder_ == null) {
        messages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        messagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public Builder removeMessages(int index) {
      if (messagesBuilder_ == null) {
        ensureMessagesIsMutable();
        messages_.remove(index);
        onChanged();
      } else {
        messagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder getMessagesBuilder(int index) {
      return getMessagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder getMessagesOrBuilder(
        int index) {
      if (messagesBuilder_ == null) {
        return messages_.get(index);
      } else {
        return messagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>
        getMessagesOrBuilderList() {
      if (messagesBuilder_ != null) {
        return messagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(messages_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder addMessagesBuilder() {
      return getMessagesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3.ResponseMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder addMessagesBuilder(int index) {
      return getMessagesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.cx.v3.ResponseMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of rich message responses to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder>
        getMessagesBuilderList() {
      return getMessagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.ResponseMessage,
            com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder,
            com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>
        getMessagesFieldBuilder() {
      if (messagesBuilder_ == null) {
        messagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.ResponseMessage,
                com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder,
                com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>(
                messages_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        messages_ = null;
      }
      return messagesBuilder_;
    }

    private java.lang.Object webhook_ = "";
    /**
     *
     *
     * <pre>
     * The webhook to call.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/webhooks/&lt;Webhook ID&gt;`.
     * </pre>
     *
     * <code>string webhook = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The webhook.
     */
    public java.lang.String getWebhook() {
      java.lang.Object ref = webhook_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        webhook_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The webhook to call.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/webhooks/&lt;Webhook ID&gt;`.
     * </pre>
     *
     * <code>string webhook = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for webhook.
     */
    public com.google.protobuf.ByteString getWebhookBytes() {
      java.lang.Object ref = webhook_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        webhook_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The webhook to call.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/webhooks/&lt;Webhook ID&gt;`.
     * </pre>
     *
     * <code>string webhook = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The webhook to set.
     * @return This builder for chaining.
     */
    public Builder setWebhook(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      webhook_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The webhook to call.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/webhooks/&lt;Webhook ID&gt;`.
     * </pre>
     *
     * <code>string webhook = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWebhook() {

      webhook_ = getDefaultInstance().getWebhook();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The webhook to call.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/webhooks/&lt;Webhook ID&gt;`.
     * </pre>
     *
     * <code>string webhook = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for webhook to set.
     * @return This builder for chaining.
     */
    public Builder setWebhookBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      webhook_ = value;
      onChanged();
      return this;
    }

    private boolean returnPartialResponses_;
    /**
     *
     *
     * <pre>
     * Whether Dialogflow should return currently queued fulfillment response
     * messages in streaming APIs. If a webhook is specified, it happens before
     * Dialogflow invokes webhook.
     * Warning:
     * 1) This flag only affects streaming API. Responses are still queued
     * and returned once in non-streaming API.
     * 2) The flag can be enabled in any fulfillment but only the first 3 partial
     * responses will be returned. You may only want to apply it to fulfillments
     * that have slow webhooks.
     * </pre>
     *
     * <code>bool return_partial_responses = 8;</code>
     *
     * @return The returnPartialResponses.
     */
    @java.lang.Override
    public boolean getReturnPartialResponses() {
      return returnPartialResponses_;
    }
    /**
     *
     *
     * <pre>
     * Whether Dialogflow should return currently queued fulfillment response
     * messages in streaming APIs. If a webhook is specified, it happens before
     * Dialogflow invokes webhook.
     * Warning:
     * 1) This flag only affects streaming API. Responses are still queued
     * and returned once in non-streaming API.
     * 2) The flag can be enabled in any fulfillment but only the first 3 partial
     * responses will be returned. You may only want to apply it to fulfillments
     * that have slow webhooks.
     * </pre>
     *
     * <code>bool return_partial_responses = 8;</code>
     *
     * @param value The returnPartialResponses to set.
     * @return This builder for chaining.
     */
    public Builder setReturnPartialResponses(boolean value) {

      returnPartialResponses_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether Dialogflow should return currently queued fulfillment response
     * messages in streaming APIs. If a webhook is specified, it happens before
     * Dialogflow invokes webhook.
     * Warning:
     * 1) This flag only affects streaming API. Responses are still queued
     * and returned once in non-streaming API.
     * 2) The flag can be enabled in any fulfillment but only the first 3 partial
     * responses will be returned. You may only want to apply it to fulfillments
     * that have slow webhooks.
     * </pre>
     *
     * <code>bool return_partial_responses = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReturnPartialResponses() {

      returnPartialResponses_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object tag_ = "";
    /**
     *
     *
     * <pre>
     * The value of this field will be populated in the [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]
     * `fulfillmentInfo.tag` field by Dialogflow when the associated webhook is
     * called.
     * The tag is typically used by the webhook service to identify which
     * fulfillment is being called, but it could be used for other purposes.
     * This field is required if `webhook` is specified.
     * </pre>
     *
     * <code>string tag = 3;</code>
     *
     * @return The tag.
     */
    public java.lang.String getTag() {
      java.lang.Object ref = tag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The value of this field will be populated in the [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]
     * `fulfillmentInfo.tag` field by Dialogflow when the associated webhook is
     * called.
     * The tag is typically used by the webhook service to identify which
     * fulfillment is being called, but it could be used for other purposes.
     * This field is required if `webhook` is specified.
     * </pre>
     *
     * <code>string tag = 3;</code>
     *
     * @return The bytes for tag.
     */
    public com.google.protobuf.ByteString getTagBytes() {
      java.lang.Object ref = tag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The value of this field will be populated in the [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]
     * `fulfillmentInfo.tag` field by Dialogflow when the associated webhook is
     * called.
     * The tag is typically used by the webhook service to identify which
     * fulfillment is being called, but it could be used for other purposes.
     * This field is required if `webhook` is specified.
     * </pre>
     *
     * <code>string tag = 3;</code>
     *
     * @param value The tag to set.
     * @return This builder for chaining.
     */
    public Builder setTag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      tag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of this field will be populated in the [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]
     * `fulfillmentInfo.tag` field by Dialogflow when the associated webhook is
     * called.
     * The tag is typically used by the webhook service to identify which
     * fulfillment is being called, but it could be used for other purposes.
     * This field is required if `webhook` is specified.
     * </pre>
     *
     * <code>string tag = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTag() {

      tag_ = getDefaultInstance().getTag();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of this field will be populated in the [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]
     * `fulfillmentInfo.tag` field by Dialogflow when the associated webhook is
     * called.
     * The tag is typically used by the webhook service to identify which
     * fulfillment is being called, but it could be used for other purposes.
     * This field is required if `webhook` is specified.
     * </pre>
     *
     * <code>string tag = 3;</code>
     *
     * @param value The bytes for tag to set.
     * @return This builder for chaining.
     */
    public Builder setTagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      tag_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction>
        setParameterActions_ = java.util.Collections.emptyList();

    private void ensureSetParameterActionsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        setParameterActions_ =
            new java.util.ArrayList<
                com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction>(
                setParameterActions_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.Builder,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterActionOrBuilder>
        setParameterActionsBuilder_;

    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction>
        getSetParameterActionsList() {
      if (setParameterActionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(setParameterActions_);
      } else {
        return setParameterActionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public int getSetParameterActionsCount() {
      if (setParameterActionsBuilder_ == null) {
        return setParameterActions_.size();
      } else {
        return setParameterActionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction getSetParameterActions(
        int index) {
      if (setParameterActionsBuilder_ == null) {
        return setParameterActions_.get(index);
      } else {
        return setParameterActionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public Builder setSetParameterActions(
        int index, com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction value) {
      if (setParameterActionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSetParameterActionsIsMutable();
        setParameterActions_.set(index, value);
        onChanged();
      } else {
        setParameterActionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public Builder setSetParameterActions(
        int index,
        com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.Builder builderForValue) {
      if (setParameterActionsBuilder_ == null) {
        ensureSetParameterActionsIsMutable();
        setParameterActions_.set(index, builderForValue.build());
        onChanged();
      } else {
        setParameterActionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public Builder addSetParameterActions(
        com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction value) {
      if (setParameterActionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSetParameterActionsIsMutable();
        setParameterActions_.add(value);
        onChanged();
      } else {
        setParameterActionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public Builder addSetParameterActions(
        int index, com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction value) {
      if (setParameterActionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSetParameterActionsIsMutable();
        setParameterActions_.add(index, value);
        onChanged();
      } else {
        setParameterActionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public Builder addSetParameterActions(
        com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.Builder builderForValue) {
      if (setParameterActionsBuilder_ == null) {
        ensureSetParameterActionsIsMutable();
        setParameterActions_.add(builderForValue.build());
        onChanged();
      } else {
        setParameterActionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public Builder addSetParameterActions(
        int index,
        com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.Builder builderForValue) {
      if (setParameterActionsBuilder_ == null) {
        ensureSetParameterActionsIsMutable();
        setParameterActions_.add(index, builderForValue.build());
        onChanged();
      } else {
        setParameterActionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public Builder addAllSetParameterActions(
        java.lang.Iterable<
                ? extends com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction>
            values) {
      if (setParameterActionsBuilder_ == null) {
        ensureSetParameterActionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, setParameterActions_);
        onChanged();
      } else {
        setParameterActionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public Builder clearSetParameterActions() {
      if (setParameterActionsBuilder_ == null) {
        setParameterActions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        setParameterActionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public Builder removeSetParameterActions(int index) {
      if (setParameterActionsBuilder_ == null) {
        ensureSetParameterActionsIsMutable();
        setParameterActions_.remove(index);
        onChanged();
      } else {
        setParameterActionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.Builder
        getSetParameterActionsBuilder(int index) {
      return getSetParameterActionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterActionOrBuilder
        getSetParameterActionsOrBuilder(int index) {
      if (setParameterActionsBuilder_ == null) {
        return setParameterActions_.get(index);
      } else {
        return setParameterActionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterActionOrBuilder>
        getSetParameterActionsOrBuilderList() {
      if (setParameterActionsBuilder_ != null) {
        return setParameterActionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(setParameterActions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.Builder
        addSetParameterActionsBuilder() {
      return getSetParameterActionsFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.Builder
        addSetParameterActionsBuilder(int index) {
      return getSetParameterActionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set parameter values before executing the webhook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.Builder>
        getSetParameterActionsBuilderList() {
      return getSetParameterActionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.Builder,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterActionOrBuilder>
        getSetParameterActionsFieldBuilder() {
      if (setParameterActionsBuilder_ == null) {
        setParameterActionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction,
                com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction.Builder,
                com.google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterActionOrBuilder>(
                setParameterActions_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        setParameterActions_ = null;
      }
      return setParameterActionsBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases>
        conditionalCases_ = java.util.Collections.emptyList();

    private void ensureConditionalCasesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        conditionalCases_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases>(
                conditionalCases_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCasesOrBuilder>
        conditionalCasesBuilder_;

    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases>
        getConditionalCasesList() {
      if (conditionalCasesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(conditionalCases_);
      } else {
        return conditionalCasesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public int getConditionalCasesCount() {
      if (conditionalCasesBuilder_ == null) {
        return conditionalCases_.size();
      } else {
        return conditionalCasesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases getConditionalCases(
        int index) {
      if (conditionalCasesBuilder_ == null) {
        return conditionalCases_.get(index);
      } else {
        return conditionalCasesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public Builder setConditionalCases(
        int index, com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases value) {
      if (conditionalCasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionalCasesIsMutable();
        conditionalCases_.set(index, value);
        onChanged();
      } else {
        conditionalCasesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public Builder setConditionalCases(
        int index,
        com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder builderForValue) {
      if (conditionalCasesBuilder_ == null) {
        ensureConditionalCasesIsMutable();
        conditionalCases_.set(index, builderForValue.build());
        onChanged();
      } else {
        conditionalCasesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public Builder addConditionalCases(
        com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases value) {
      if (conditionalCasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionalCasesIsMutable();
        conditionalCases_.add(value);
        onChanged();
      } else {
        conditionalCasesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public Builder addConditionalCases(
        int index, com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases value) {
      if (conditionalCasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionalCasesIsMutable();
        conditionalCases_.add(index, value);
        onChanged();
      } else {
        conditionalCasesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public Builder addConditionalCases(
        com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder builderForValue) {
      if (conditionalCasesBuilder_ == null) {
        ensureConditionalCasesIsMutable();
        conditionalCases_.add(builderForValue.build());
        onChanged();
      } else {
        conditionalCasesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public Builder addConditionalCases(
        int index,
        com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder builderForValue) {
      if (conditionalCasesBuilder_ == null) {
        ensureConditionalCasesIsMutable();
        conditionalCases_.add(index, builderForValue.build());
        onChanged();
      } else {
        conditionalCasesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public Builder addAllConditionalCases(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases>
            values) {
      if (conditionalCasesBuilder_ == null) {
        ensureConditionalCasesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditionalCases_);
        onChanged();
      } else {
        conditionalCasesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public Builder clearConditionalCases() {
      if (conditionalCasesBuilder_ == null) {
        conditionalCases_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        conditionalCasesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public Builder removeConditionalCases(int index) {
      if (conditionalCasesBuilder_ == null) {
        ensureConditionalCasesIsMutable();
        conditionalCases_.remove(index);
        onChanged();
      } else {
        conditionalCasesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder
        getConditionalCasesBuilder(int index) {
      return getConditionalCasesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCasesOrBuilder
        getConditionalCasesOrBuilder(int index) {
      if (conditionalCasesBuilder_ == null) {
        return conditionalCases_.get(index);
      } else {
        return conditionalCasesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCasesOrBuilder>
        getConditionalCasesOrBuilderList() {
      if (conditionalCasesBuilder_ != null) {
        return conditionalCasesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(conditionalCases_);
      }
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder
        addConditionalCasesBuilder() {
      return getConditionalCasesFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder
        addConditionalCasesBuilder(int index) {
      return getConditionalCasesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Conditional cases for this fulfillment.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder>
        getConditionalCasesBuilderList() {
      return getConditionalCasesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCasesOrBuilder>
        getConditionalCasesFieldBuilder() {
      if (conditionalCasesBuilder_ == null) {
        conditionalCasesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases,
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases.Builder,
                com.google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCasesOrBuilder>(
                conditionalCases_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        conditionalCases_ = null;
      }
      return conditionalCasesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Fulfillment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Fulfillment)
  private static final com.google.cloud.dialogflow.cx.v3.Fulfillment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Fulfillment();
  }

  public static com.google.cloud.dialogflow.cx.v3.Fulfillment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Fulfillment> PARSER =
      new com.google.protobuf.AbstractParser<Fulfillment>() {
        @java.lang.Override
        public Fulfillment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Fulfillment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Fulfillment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Fulfillment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
