/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/experiment.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Represents an experiment in an environment.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.Experiment}
 */
public final class Experiment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Experiment)
    ExperimentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Experiment.newBuilder() to construct.
  private Experiment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Experiment() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    state_ = 0;
    rolloutFailureReason_ = "";
    variantsHistory_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Experiment();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.ExperimentProto
        .internal_static_google_cloud_dialogflow_cx_v3_Experiment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.ExperimentProto
        .internal_static_google_cloud_dialogflow_cx_v3_Experiment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.Experiment.class,
            com.google.cloud.dialogflow.cx.v3.Experiment.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The state of the experiment.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3.Experiment.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * State unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The experiment is created but not started yet.
     * </pre>
     *
     * <code>DRAFT = 1;</code>
     */
    DRAFT(1),
    /**
     *
     *
     * <pre>
     * The experiment is running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The experiment is done.
     * </pre>
     *
     * <code>DONE = 3;</code>
     */
    DONE(3),
    /**
     *
     *
     * <pre>
     * The experiment with auto-rollout enabled has failed.
     * </pre>
     *
     * <code>ROLLOUT_FAILED = 4;</code>
     */
    ROLLOUT_FAILED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * State unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The experiment is created but not started yet.
     * </pre>
     *
     * <code>DRAFT = 1;</code>
     */
    public static final int DRAFT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The experiment is running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The experiment is done.
     * </pre>
     *
     * <code>DONE = 3;</code>
     */
    public static final int DONE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The experiment with auto-rollout enabled has failed.
     * </pre>
     *
     * <code>ROLLOUT_FAILED = 4;</code>
     */
    public static final int ROLLOUT_FAILED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return DRAFT;
        case 2:
          return RUNNING;
        case 3:
          return DONE;
        case 4:
          return ROLLOUT_FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.Experiment.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.Experiment.State)
  }

  public interface DefinitionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Experiment.Definition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The condition defines which subset of sessions are selected for
     * this experiment. If not specified, all sessions are eligible. E.g.
     * "query_input.language_code=en" See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * </pre>
     *
     * <code>string condition = 1;</code>
     *
     * @return The condition.
     */
    java.lang.String getCondition();
    /**
     *
     *
     * <pre>
     * The condition defines which subset of sessions are selected for
     * this experiment. If not specified, all sessions are eligible. E.g.
     * "query_input.language_code=en" See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * </pre>
     *
     * <code>string condition = 1;</code>
     *
     * @return The bytes for condition.
     */
    com.google.protobuf.ByteString getConditionBytes();

    /**
     *
     *
     * <pre>
     * The flow versions as the variants of this experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.VersionVariants version_variants = 2;</code>
     *
     * @return Whether the versionVariants field is set.
     */
    boolean hasVersionVariants();
    /**
     *
     *
     * <pre>
     * The flow versions as the variants of this experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.VersionVariants version_variants = 2;</code>
     *
     * @return The versionVariants.
     */
    com.google.cloud.dialogflow.cx.v3.VersionVariants getVersionVariants();
    /**
     *
     *
     * <pre>
     * The flow versions as the variants of this experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.VersionVariants version_variants = 2;</code>
     */
    com.google.cloud.dialogflow.cx.v3.VersionVariantsOrBuilder getVersionVariantsOrBuilder();

    public com.google.cloud.dialogflow.cx.v3.Experiment.Definition.VariantsCase getVariantsCase();
  }
  /**
   *
   *
   * <pre>
   * Definition of the experiment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Experiment.Definition}
   */
  public static final class Definition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Experiment.Definition)
      DefinitionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Definition.newBuilder() to construct.
    private Definition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Definition() {
      condition_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Definition();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Definition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Definition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Experiment.Definition.class,
              com.google.cloud.dialogflow.cx.v3.Experiment.Definition.Builder.class);
    }

    private int variantsCase_ = 0;
    private java.lang.Object variants_;

    public enum VariantsCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      VERSION_VARIANTS(2),
      VARIANTS_NOT_SET(0);
      private final int value;

      private VariantsCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static VariantsCase valueOf(int value) {
        return forNumber(value);
      }

      public static VariantsCase forNumber(int value) {
        switch (value) {
          case 2:
            return VERSION_VARIANTS;
          case 0:
            return VARIANTS_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public VariantsCase getVariantsCase() {
      return VariantsCase.forNumber(variantsCase_);
    }

    public static final int CONDITION_FIELD_NUMBER = 1;
    private volatile java.lang.Object condition_;
    /**
     *
     *
     * <pre>
     * The condition defines which subset of sessions are selected for
     * this experiment. If not specified, all sessions are eligible. E.g.
     * "query_input.language_code=en" See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * </pre>
     *
     * <code>string condition = 1;</code>
     *
     * @return The condition.
     */
    @java.lang.Override
    public java.lang.String getCondition() {
      java.lang.Object ref = condition_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        condition_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The condition defines which subset of sessions are selected for
     * this experiment. If not specified, all sessions are eligible. E.g.
     * "query_input.language_code=en" See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * </pre>
     *
     * <code>string condition = 1;</code>
     *
     * @return The bytes for condition.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getConditionBytes() {
      java.lang.Object ref = condition_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        condition_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VERSION_VARIANTS_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The flow versions as the variants of this experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.VersionVariants version_variants = 2;</code>
     *
     * @return Whether the versionVariants field is set.
     */
    @java.lang.Override
    public boolean hasVersionVariants() {
      return variantsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The flow versions as the variants of this experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.VersionVariants version_variants = 2;</code>
     *
     * @return The versionVariants.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.VersionVariants getVersionVariants() {
      if (variantsCase_ == 2) {
        return (com.google.cloud.dialogflow.cx.v3.VersionVariants) variants_;
      }
      return com.google.cloud.dialogflow.cx.v3.VersionVariants.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The flow versions as the variants of this experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.VersionVariants version_variants = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.VersionVariantsOrBuilder
        getVersionVariantsOrBuilder() {
      if (variantsCase_ == 2) {
        return (com.google.cloud.dialogflow.cx.v3.VersionVariants) variants_;
      }
      return com.google.cloud.dialogflow.cx.v3.VersionVariants.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, condition_);
      }
      if (variantsCase_ == 2) {
        output.writeMessage(2, (com.google.cloud.dialogflow.cx.v3.VersionVariants) variants_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, condition_);
      }
      if (variantsCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.dialogflow.cx.v3.VersionVariants) variants_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Experiment.Definition)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.Experiment.Definition other =
          (com.google.cloud.dialogflow.cx.v3.Experiment.Definition) obj;

      if (!getCondition().equals(other.getCondition())) return false;
      if (!getVariantsCase().equals(other.getVariantsCase())) return false;
      switch (variantsCase_) {
        case 2:
          if (!getVersionVariants().equals(other.getVersionVariants())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + getCondition().hashCode();
      switch (variantsCase_) {
        case 2:
          hash = (37 * hash) + VERSION_VARIANTS_FIELD_NUMBER;
          hash = (53 * hash) + getVersionVariants().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Definition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Definition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Definition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Definition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Definition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Definition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Definition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Definition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Definition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Definition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Definition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Definition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.Experiment.Definition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Definition of the experiment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.Experiment.Definition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Experiment.Definition)
        com.google.cloud.dialogflow.cx.v3.Experiment.DefinitionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Definition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Definition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Experiment.Definition.class,
                com.google.cloud.dialogflow.cx.v3.Experiment.Definition.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3.Experiment.Definition.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        condition_ = "";

        if (versionVariantsBuilder_ != null) {
          versionVariantsBuilder_.clear();
        }
        variantsCase_ = 0;
        variants_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Definition_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Experiment.Definition getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.Experiment.Definition.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Experiment.Definition build() {
        com.google.cloud.dialogflow.cx.v3.Experiment.Definition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Experiment.Definition buildPartial() {
        com.google.cloud.dialogflow.cx.v3.Experiment.Definition result =
            new com.google.cloud.dialogflow.cx.v3.Experiment.Definition(this);
        result.condition_ = condition_;
        if (variantsCase_ == 2) {
          if (versionVariantsBuilder_ == null) {
            result.variants_ = variants_;
          } else {
            result.variants_ = versionVariantsBuilder_.build();
          }
        }
        result.variantsCase_ = variantsCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.Experiment.Definition) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3.Experiment.Definition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.Experiment.Definition other) {
        if (other == com.google.cloud.dialogflow.cx.v3.Experiment.Definition.getDefaultInstance())
          return this;
        if (!other.getCondition().isEmpty()) {
          condition_ = other.condition_;
          onChanged();
        }
        switch (other.getVariantsCase()) {
          case VERSION_VARIANTS:
            {
              mergeVersionVariants(other.getVersionVariants());
              break;
            }
          case VARIANTS_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  condition_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getVersionVariantsFieldBuilder().getBuilder(), extensionRegistry);
                  variantsCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int variantsCase_ = 0;
      private java.lang.Object variants_;

      public VariantsCase getVariantsCase() {
        return VariantsCase.forNumber(variantsCase_);
      }

      public Builder clearVariants() {
        variantsCase_ = 0;
        variants_ = null;
        onChanged();
        return this;
      }

      private java.lang.Object condition_ = "";
      /**
       *
       *
       * <pre>
       * The condition defines which subset of sessions are selected for
       * this experiment. If not specified, all sessions are eligible. E.g.
       * "query_input.language_code=en" See the [conditions
       * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The condition.
       */
      public java.lang.String getCondition() {
        java.lang.Object ref = condition_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          condition_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The condition defines which subset of sessions are selected for
       * this experiment. If not specified, all sessions are eligible. E.g.
       * "query_input.language_code=en" See the [conditions
       * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The bytes for condition.
       */
      public com.google.protobuf.ByteString getConditionBytes() {
        java.lang.Object ref = condition_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          condition_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The condition defines which subset of sessions are selected for
       * this experiment. If not specified, all sessions are eligible. E.g.
       * "query_input.language_code=en" See the [conditions
       * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @param value The condition to set.
       * @return This builder for chaining.
       */
      public Builder setCondition(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        condition_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The condition defines which subset of sessions are selected for
       * this experiment. If not specified, all sessions are eligible. E.g.
       * "query_input.language_code=en" See the [conditions
       * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCondition() {

        condition_ = getDefaultInstance().getCondition();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The condition defines which subset of sessions are selected for
       * this experiment. If not specified, all sessions are eligible. E.g.
       * "query_input.language_code=en" See the [conditions
       * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @param value The bytes for condition to set.
       * @return This builder for chaining.
       */
      public Builder setConditionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        condition_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.VersionVariants,
              com.google.cloud.dialogflow.cx.v3.VersionVariants.Builder,
              com.google.cloud.dialogflow.cx.v3.VersionVariantsOrBuilder>
          versionVariantsBuilder_;
      /**
       *
       *
       * <pre>
       * The flow versions as the variants of this experiment.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.VersionVariants version_variants = 2;</code>
       *
       * @return Whether the versionVariants field is set.
       */
      @java.lang.Override
      public boolean hasVersionVariants() {
        return variantsCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The flow versions as the variants of this experiment.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.VersionVariants version_variants = 2;</code>
       *
       * @return The versionVariants.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.VersionVariants getVersionVariants() {
        if (versionVariantsBuilder_ == null) {
          if (variantsCase_ == 2) {
            return (com.google.cloud.dialogflow.cx.v3.VersionVariants) variants_;
          }
          return com.google.cloud.dialogflow.cx.v3.VersionVariants.getDefaultInstance();
        } else {
          if (variantsCase_ == 2) {
            return versionVariantsBuilder_.getMessage();
          }
          return com.google.cloud.dialogflow.cx.v3.VersionVariants.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The flow versions as the variants of this experiment.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.VersionVariants version_variants = 2;</code>
       */
      public Builder setVersionVariants(com.google.cloud.dialogflow.cx.v3.VersionVariants value) {
        if (versionVariantsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          variants_ = value;
          onChanged();
        } else {
          versionVariantsBuilder_.setMessage(value);
        }
        variantsCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The flow versions as the variants of this experiment.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.VersionVariants version_variants = 2;</code>
       */
      public Builder setVersionVariants(
          com.google.cloud.dialogflow.cx.v3.VersionVariants.Builder builderForValue) {
        if (versionVariantsBuilder_ == null) {
          variants_ = builderForValue.build();
          onChanged();
        } else {
          versionVariantsBuilder_.setMessage(builderForValue.build());
        }
        variantsCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The flow versions as the variants of this experiment.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.VersionVariants version_variants = 2;</code>
       */
      public Builder mergeVersionVariants(com.google.cloud.dialogflow.cx.v3.VersionVariants value) {
        if (versionVariantsBuilder_ == null) {
          if (variantsCase_ == 2
              && variants_
                  != com.google.cloud.dialogflow.cx.v3.VersionVariants.getDefaultInstance()) {
            variants_ =
                com.google.cloud.dialogflow.cx.v3.VersionVariants.newBuilder(
                        (com.google.cloud.dialogflow.cx.v3.VersionVariants) variants_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            variants_ = value;
          }
          onChanged();
        } else {
          if (variantsCase_ == 2) {
            versionVariantsBuilder_.mergeFrom(value);
          } else {
            versionVariantsBuilder_.setMessage(value);
          }
        }
        variantsCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The flow versions as the variants of this experiment.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.VersionVariants version_variants = 2;</code>
       */
      public Builder clearVersionVariants() {
        if (versionVariantsBuilder_ == null) {
          if (variantsCase_ == 2) {
            variantsCase_ = 0;
            variants_ = null;
            onChanged();
          }
        } else {
          if (variantsCase_ == 2) {
            variantsCase_ = 0;
            variants_ = null;
          }
          versionVariantsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The flow versions as the variants of this experiment.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.VersionVariants version_variants = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3.VersionVariants.Builder getVersionVariantsBuilder() {
        return getVersionVariantsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The flow versions as the variants of this experiment.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.VersionVariants version_variants = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.VersionVariantsOrBuilder
          getVersionVariantsOrBuilder() {
        if ((variantsCase_ == 2) && (versionVariantsBuilder_ != null)) {
          return versionVariantsBuilder_.getMessageOrBuilder();
        } else {
          if (variantsCase_ == 2) {
            return (com.google.cloud.dialogflow.cx.v3.VersionVariants) variants_;
          }
          return com.google.cloud.dialogflow.cx.v3.VersionVariants.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The flow versions as the variants of this experiment.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.VersionVariants version_variants = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.VersionVariants,
              com.google.cloud.dialogflow.cx.v3.VersionVariants.Builder,
              com.google.cloud.dialogflow.cx.v3.VersionVariantsOrBuilder>
          getVersionVariantsFieldBuilder() {
        if (versionVariantsBuilder_ == null) {
          if (!(variantsCase_ == 2)) {
            variants_ = com.google.cloud.dialogflow.cx.v3.VersionVariants.getDefaultInstance();
          }
          versionVariantsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.VersionVariants,
                  com.google.cloud.dialogflow.cx.v3.VersionVariants.Builder,
                  com.google.cloud.dialogflow.cx.v3.VersionVariantsOrBuilder>(
                  (com.google.cloud.dialogflow.cx.v3.VersionVariants) variants_,
                  getParentForChildren(),
                  isClean());
          variants_ = null;
        }
        variantsCase_ = 2;
        onChanged();
        ;
        return versionVariantsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Experiment.Definition)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Experiment.Definition)
    private static final com.google.cloud.dialogflow.cx.v3.Experiment.Definition DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Experiment.Definition();
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Definition getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Definition> PARSER =
        new com.google.protobuf.AbstractParser<Definition>() {
          @java.lang.Override
          public Definition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Definition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Definition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Experiment.Definition getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Experiment.Result)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Version variants and metrics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
     * </code>
     */
    java.util.List<com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics>
        getVersionMetricsList();
    /**
     *
     *
     * <pre>
     * Version variants and metrics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics getVersionMetrics(int index);
    /**
     *
     *
     * <pre>
     * Version variants and metrics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
     * </code>
     */
    int getVersionMetricsCount();
    /**
     *
     *
     * <pre>
     * Version variants and metrics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetricsOrBuilder>
        getVersionMetricsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Version variants and metrics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetricsOrBuilder
        getVersionMetricsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * The last time the experiment's stats data was updated. Will have default
     * value if stats have never been computed for this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 2;</code>
     *
     * @return Whether the lastUpdateTime field is set.
     */
    boolean hasLastUpdateTime();
    /**
     *
     *
     * <pre>
     * The last time the experiment's stats data was updated. Will have default
     * value if stats have never been computed for this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 2;</code>
     *
     * @return The lastUpdateTime.
     */
    com.google.protobuf.Timestamp getLastUpdateTime();
    /**
     *
     *
     * <pre>
     * The last time the experiment's stats data was updated. Will have default
     * value if stats have never been computed for this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The inference result which includes an objective metric to optimize and the
   * confidence interval.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Experiment.Result}
   */
  public static final class Result extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Experiment.Result)
      ResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Result.newBuilder() to construct.
    private Result(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Result() {
      versionMetrics_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Result();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Experiment.Result.class,
              com.google.cloud.dialogflow.cx.v3.Experiment.Result.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Types of ratio-based metric for Dialogflow experiment.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType}
     */
    public enum MetricType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Metric unspecified.
       * </pre>
       *
       * <code>METRIC_UNSPECIFIED = 0;</code>
       */
      METRIC_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Percentage of contained sessions without user calling back in 24 hours.
       * </pre>
       *
       * <code>CONTAINED_SESSION_NO_CALLBACK_RATE = 1;</code>
       */
      CONTAINED_SESSION_NO_CALLBACK_RATE(1),
      /**
       *
       *
       * <pre>
       * Percentage of sessions that were handed to a human agent.
       * </pre>
       *
       * <code>LIVE_AGENT_HANDOFF_RATE = 2;</code>
       */
      LIVE_AGENT_HANDOFF_RATE(2),
      /**
       *
       *
       * <pre>
       * Percentage of sessions with the same user calling back.
       * </pre>
       *
       * <code>CALLBACK_SESSION_RATE = 3;</code>
       */
      CALLBACK_SESSION_RATE(3),
      /**
       *
       *
       * <pre>
       * Percentage of sessions where user hung up.
       * </pre>
       *
       * <code>ABANDONED_SESSION_RATE = 4;</code>
       */
      ABANDONED_SESSION_RATE(4),
      /**
       *
       *
       * <pre>
       * Percentage of sessions reached Dialogflow 'END_PAGE' or
       * 'END_SESSION'.
       * </pre>
       *
       * <code>SESSION_END_RATE = 5;</code>
       */
      SESSION_END_RATE(5),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Metric unspecified.
       * </pre>
       *
       * <code>METRIC_UNSPECIFIED = 0;</code>
       */
      public static final int METRIC_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Percentage of contained sessions without user calling back in 24 hours.
       * </pre>
       *
       * <code>CONTAINED_SESSION_NO_CALLBACK_RATE = 1;</code>
       */
      public static final int CONTAINED_SESSION_NO_CALLBACK_RATE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Percentage of sessions that were handed to a human agent.
       * </pre>
       *
       * <code>LIVE_AGENT_HANDOFF_RATE = 2;</code>
       */
      public static final int LIVE_AGENT_HANDOFF_RATE_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Percentage of sessions with the same user calling back.
       * </pre>
       *
       * <code>CALLBACK_SESSION_RATE = 3;</code>
       */
      public static final int CALLBACK_SESSION_RATE_VALUE = 3;
      /**
       *
       *
       * <pre>
       * Percentage of sessions where user hung up.
       * </pre>
       *
       * <code>ABANDONED_SESSION_RATE = 4;</code>
       */
      public static final int ABANDONED_SESSION_RATE_VALUE = 4;
      /**
       *
       *
       * <pre>
       * Percentage of sessions reached Dialogflow 'END_PAGE' or
       * 'END_SESSION'.
       * </pre>
       *
       * <code>SESSION_END_RATE = 5;</code>
       */
      public static final int SESSION_END_RATE_VALUE = 5;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static MetricType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static MetricType forNumber(int value) {
        switch (value) {
          case 0:
            return METRIC_UNSPECIFIED;
          case 1:
            return CONTAINED_SESSION_NO_CALLBACK_RATE;
          case 2:
            return LIVE_AGENT_HANDOFF_RATE;
          case 3:
            return CALLBACK_SESSION_RATE;
          case 4:
            return ABANDONED_SESSION_RATE;
          case 5:
            return SESSION_END_RATE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<MetricType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<MetricType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<MetricType>() {
            public MetricType findValueByNumber(int number) {
              return MetricType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.Experiment.Result.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final MetricType[] VALUES = values();

      public static MetricType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private MetricType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType)
    }

    /**
     *
     *
     * <pre>
     * Types of count-based metric for Dialogflow experiment.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.dialogflow.cx.v3.Experiment.Result.CountType}
     */
    public enum CountType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Count type unspecified.
       * </pre>
       *
       * <code>COUNT_TYPE_UNSPECIFIED = 0;</code>
       */
      COUNT_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Total number of occurrences of a 'NO_MATCH'.
       * </pre>
       *
       * <code>TOTAL_NO_MATCH_COUNT = 1;</code>
       */
      TOTAL_NO_MATCH_COUNT(1),
      /**
       *
       *
       * <pre>
       * Total number of turn counts.
       * </pre>
       *
       * <code>TOTAL_TURN_COUNT = 2;</code>
       */
      TOTAL_TURN_COUNT(2),
      /**
       *
       *
       * <pre>
       * Average turn count in a session.
       * </pre>
       *
       * <code>AVERAGE_TURN_COUNT = 3;</code>
       */
      AVERAGE_TURN_COUNT(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Count type unspecified.
       * </pre>
       *
       * <code>COUNT_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int COUNT_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Total number of occurrences of a 'NO_MATCH'.
       * </pre>
       *
       * <code>TOTAL_NO_MATCH_COUNT = 1;</code>
       */
      public static final int TOTAL_NO_MATCH_COUNT_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Total number of turn counts.
       * </pre>
       *
       * <code>TOTAL_TURN_COUNT = 2;</code>
       */
      public static final int TOTAL_TURN_COUNT_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Average turn count in a session.
       * </pre>
       *
       * <code>AVERAGE_TURN_COUNT = 3;</code>
       */
      public static final int AVERAGE_TURN_COUNT_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static CountType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static CountType forNumber(int value) {
        switch (value) {
          case 0:
            return COUNT_TYPE_UNSPECIFIED;
          case 1:
            return TOTAL_NO_MATCH_COUNT;
          case 2:
            return TOTAL_TURN_COUNT;
          case 3:
            return AVERAGE_TURN_COUNT;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<CountType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<CountType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<CountType>() {
            public CountType findValueByNumber(int number) {
              return CountType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.Experiment.Result.getDescriptor()
            .getEnumTypes()
            .get(1);
      }

      private static final CountType[] VALUES = values();

      public static CountType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private CountType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.Experiment.Result.CountType)
    }

    public interface ConfidenceIntervalOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The confidence level used to construct the interval, i.e. there is X%
       * chance that the true value is within this interval.
       * </pre>
       *
       * <code>double confidence_level = 1;</code>
       *
       * @return The confidenceLevel.
       */
      double getConfidenceLevel();

      /**
       *
       *
       * <pre>
       * The percent change between an experiment metric's value and the value
       * for its control.
       * </pre>
       *
       * <code>double ratio = 2;</code>
       *
       * @return The ratio.
       */
      double getRatio();

      /**
       *
       *
       * <pre>
       * Lower bound of the interval.
       * </pre>
       *
       * <code>double lower_bound = 3;</code>
       *
       * @return The lowerBound.
       */
      double getLowerBound();

      /**
       *
       *
       * <pre>
       * Upper bound of the interval.
       * </pre>
       *
       * <code>double upper_bound = 4;</code>
       *
       * @return The upperBound.
       */
      double getUpperBound();
    }
    /**
     *
     *
     * <pre>
     * A confidence interval is a range of possible values for the experiment
     * objective you are trying to measure.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval}
     */
    public static final class ConfidenceInterval extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval)
        ConfidenceIntervalOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ConfidenceInterval.newBuilder() to construct.
      private ConfidenceInterval(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ConfidenceInterval() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ConfidenceInterval();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_ConfidenceInterval_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_ConfidenceInterval_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval.class,
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval.Builder
                    .class);
      }

      public static final int CONFIDENCE_LEVEL_FIELD_NUMBER = 1;
      private double confidenceLevel_;
      /**
       *
       *
       * <pre>
       * The confidence level used to construct the interval, i.e. there is X%
       * chance that the true value is within this interval.
       * </pre>
       *
       * <code>double confidence_level = 1;</code>
       *
       * @return The confidenceLevel.
       */
      @java.lang.Override
      public double getConfidenceLevel() {
        return confidenceLevel_;
      }

      public static final int RATIO_FIELD_NUMBER = 2;
      private double ratio_;
      /**
       *
       *
       * <pre>
       * The percent change between an experiment metric's value and the value
       * for its control.
       * </pre>
       *
       * <code>double ratio = 2;</code>
       *
       * @return The ratio.
       */
      @java.lang.Override
      public double getRatio() {
        return ratio_;
      }

      public static final int LOWER_BOUND_FIELD_NUMBER = 3;
      private double lowerBound_;
      /**
       *
       *
       * <pre>
       * Lower bound of the interval.
       * </pre>
       *
       * <code>double lower_bound = 3;</code>
       *
       * @return The lowerBound.
       */
      @java.lang.Override
      public double getLowerBound() {
        return lowerBound_;
      }

      public static final int UPPER_BOUND_FIELD_NUMBER = 4;
      private double upperBound_;
      /**
       *
       *
       * <pre>
       * Upper bound of the interval.
       * </pre>
       *
       * <code>double upper_bound = 4;</code>
       *
       * @return The upperBound.
       */
      @java.lang.Override
      public double getUpperBound() {
        return upperBound_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (java.lang.Double.doubleToRawLongBits(confidenceLevel_) != 0) {
          output.writeDouble(1, confidenceLevel_);
        }
        if (java.lang.Double.doubleToRawLongBits(ratio_) != 0) {
          output.writeDouble(2, ratio_);
        }
        if (java.lang.Double.doubleToRawLongBits(lowerBound_) != 0) {
          output.writeDouble(3, lowerBound_);
        }
        if (java.lang.Double.doubleToRawLongBits(upperBound_) != 0) {
          output.writeDouble(4, upperBound_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (java.lang.Double.doubleToRawLongBits(confidenceLevel_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, confidenceLevel_);
        }
        if (java.lang.Double.doubleToRawLongBits(ratio_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, ratio_);
        }
        if (java.lang.Double.doubleToRawLongBits(lowerBound_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, lowerBound_);
        }
        if (java.lang.Double.doubleToRawLongBits(upperBound_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(4, upperBound_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval other =
            (com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval) obj;

        if (java.lang.Double.doubleToLongBits(getConfidenceLevel())
            != java.lang.Double.doubleToLongBits(other.getConfidenceLevel())) return false;
        if (java.lang.Double.doubleToLongBits(getRatio())
            != java.lang.Double.doubleToLongBits(other.getRatio())) return false;
        if (java.lang.Double.doubleToLongBits(getLowerBound())
            != java.lang.Double.doubleToLongBits(other.getLowerBound())) return false;
        if (java.lang.Double.doubleToLongBits(getUpperBound())
            != java.lang.Double.doubleToLongBits(other.getUpperBound())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CONFIDENCE_LEVEL_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getConfidenceLevel()));
        hash = (37 * hash) + RATIO_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getRatio()));
        hash = (37 * hash) + LOWER_BOUND_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getLowerBound()));
        hash = (37 * hash) + UPPER_BOUND_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getUpperBound()));
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A confidence interval is a range of possible values for the experiment
       * objective you are trying to measure.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval)
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceIntervalOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3.ExperimentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_ConfidenceInterval_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3.ExperimentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_ConfidenceInterval_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval.class,
                  com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          confidenceLevel_ = 0D;

          ratio_ = 0D;

          lowerBound_ = 0D;

          upperBound_ = 0D;

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3.ExperimentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_ConfidenceInterval_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval build() {
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval result =
              new com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval(this);
          result.confidenceLevel_ = confidenceLevel_;
          result.ratio_ = ratio_;
          result.lowerBound_ = lowerBound_;
          result.upperBound_ = upperBound_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
                  .getDefaultInstance()) return this;
          if (other.getConfidenceLevel() != 0D) {
            setConfidenceLevel(other.getConfidenceLevel());
          }
          if (other.getRatio() != 0D) {
            setRatio(other.getRatio());
          }
          if (other.getLowerBound() != 0D) {
            setLowerBound(other.getLowerBound());
          }
          if (other.getUpperBound() != 0D) {
            setUpperBound(other.getUpperBound());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 9:
                  {
                    confidenceLevel_ = input.readDouble();

                    break;
                  } // case 9
                case 17:
                  {
                    ratio_ = input.readDouble();

                    break;
                  } // case 17
                case 25:
                  {
                    lowerBound_ = input.readDouble();

                    break;
                  } // case 25
                case 33:
                  {
                    upperBound_ = input.readDouble();

                    break;
                  } // case 33
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private double confidenceLevel_;
        /**
         *
         *
         * <pre>
         * The confidence level used to construct the interval, i.e. there is X%
         * chance that the true value is within this interval.
         * </pre>
         *
         * <code>double confidence_level = 1;</code>
         *
         * @return The confidenceLevel.
         */
        @java.lang.Override
        public double getConfidenceLevel() {
          return confidenceLevel_;
        }
        /**
         *
         *
         * <pre>
         * The confidence level used to construct the interval, i.e. there is X%
         * chance that the true value is within this interval.
         * </pre>
         *
         * <code>double confidence_level = 1;</code>
         *
         * @param value The confidenceLevel to set.
         * @return This builder for chaining.
         */
        public Builder setConfidenceLevel(double value) {

          confidenceLevel_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The confidence level used to construct the interval, i.e. there is X%
         * chance that the true value is within this interval.
         * </pre>
         *
         * <code>double confidence_level = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearConfidenceLevel() {

          confidenceLevel_ = 0D;
          onChanged();
          return this;
        }

        private double ratio_;
        /**
         *
         *
         * <pre>
         * The percent change between an experiment metric's value and the value
         * for its control.
         * </pre>
         *
         * <code>double ratio = 2;</code>
         *
         * @return The ratio.
         */
        @java.lang.Override
        public double getRatio() {
          return ratio_;
        }
        /**
         *
         *
         * <pre>
         * The percent change between an experiment metric's value and the value
         * for its control.
         * </pre>
         *
         * <code>double ratio = 2;</code>
         *
         * @param value The ratio to set.
         * @return This builder for chaining.
         */
        public Builder setRatio(double value) {

          ratio_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The percent change between an experiment metric's value and the value
         * for its control.
         * </pre>
         *
         * <code>double ratio = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRatio() {

          ratio_ = 0D;
          onChanged();
          return this;
        }

        private double lowerBound_;
        /**
         *
         *
         * <pre>
         * Lower bound of the interval.
         * </pre>
         *
         * <code>double lower_bound = 3;</code>
         *
         * @return The lowerBound.
         */
        @java.lang.Override
        public double getLowerBound() {
          return lowerBound_;
        }
        /**
         *
         *
         * <pre>
         * Lower bound of the interval.
         * </pre>
         *
         * <code>double lower_bound = 3;</code>
         *
         * @param value The lowerBound to set.
         * @return This builder for chaining.
         */
        public Builder setLowerBound(double value) {

          lowerBound_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Lower bound of the interval.
         * </pre>
         *
         * <code>double lower_bound = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLowerBound() {

          lowerBound_ = 0D;
          onChanged();
          return this;
        }

        private double upperBound_;
        /**
         *
         *
         * <pre>
         * Upper bound of the interval.
         * </pre>
         *
         * <code>double upper_bound = 4;</code>
         *
         * @return The upperBound.
         */
        @java.lang.Override
        public double getUpperBound() {
          return upperBound_;
        }
        /**
         *
         *
         * <pre>
         * Upper bound of the interval.
         * </pre>
         *
         * <code>double upper_bound = 4;</code>
         *
         * @param value The upperBound to set.
         * @return This builder for chaining.
         */
        public Builder setUpperBound(double value) {

          upperBound_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Upper bound of the interval.
         * </pre>
         *
         * <code>double upper_bound = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUpperBound() {

          upperBound_ = 0D;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval)
      private static final com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval();
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ConfidenceInterval> PARSER =
          new com.google.protobuf.AbstractParser<ConfidenceInterval>() {
            @java.lang.Override
            public ConfidenceInterval parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ConfidenceInterval> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ConfidenceInterval> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface MetricOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Experiment.Result.Metric)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Ratio-based metric type. Only one of type or count_type is specified in
       * each Metric.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType type = 1;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      int getTypeValue();
      /**
       *
       *
       * <pre>
       * Ratio-based metric type. Only one of type or count_type is specified in
       * each Metric.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType type = 1;</code>
       *
       * @return The type.
       */
      com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType getType();

      /**
       *
       *
       * <pre>
       * Count-based metric type. Only one of type or count_type is specified in
       * each Metric.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType count_type = 5;</code>
       *
       * @return The enum numeric value on the wire for countType.
       */
      int getCountTypeValue();
      /**
       *
       *
       * <pre>
       * Count-based metric type. Only one of type or count_type is specified in
       * each Metric.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType count_type = 5;</code>
       *
       * @return The countType.
       */
      com.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType getCountType();

      /**
       *
       *
       * <pre>
       * Ratio value of a metric.
       * </pre>
       *
       * <code>double ratio = 2;</code>
       *
       * @return Whether the ratio field is set.
       */
      boolean hasRatio();
      /**
       *
       *
       * <pre>
       * Ratio value of a metric.
       * </pre>
       *
       * <code>double ratio = 2;</code>
       *
       * @return The ratio.
       */
      double getRatio();

      /**
       *
       *
       * <pre>
       * Count value of a metric.
       * </pre>
       *
       * <code>double count = 4;</code>
       *
       * @return Whether the count field is set.
       */
      boolean hasCount();
      /**
       *
       *
       * <pre>
       * Count value of a metric.
       * </pre>
       *
       * <code>double count = 4;</code>
       *
       * @return The count.
       */
      double getCount();

      /**
       *
       *
       * <pre>
       * The probability that the treatment is better than all other treatments
       * in the experiment
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval confidence_interval = 3;
       * </code>
       *
       * @return Whether the confidenceInterval field is set.
       */
      boolean hasConfidenceInterval();
      /**
       *
       *
       * <pre>
       * The probability that the treatment is better than all other treatments
       * in the experiment
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval confidence_interval = 3;
       * </code>
       *
       * @return The confidenceInterval.
       */
      com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          getConfidenceInterval();
      /**
       *
       *
       * <pre>
       * The probability that the treatment is better than all other treatments
       * in the experiment
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval confidence_interval = 3;
       * </code>
       */
      com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceIntervalOrBuilder
          getConfidenceIntervalOrBuilder();

      public com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.ValueCase getValueCase();
    }
    /**
     *
     *
     * <pre>
     * Metric and corresponding confidence intervals.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.Experiment.Result.Metric}
     */
    public static final class Metric extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Experiment.Result.Metric)
        MetricOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Metric.newBuilder() to construct.
      private Metric(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Metric() {
        type_ = 0;
        countType_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Metric();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_Metric_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_Metric_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.class,
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.Builder.class);
      }

      private int valueCase_ = 0;
      private java.lang.Object value_;

      public enum ValueCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        RATIO(2),
        COUNT(4),
        VALUE_NOT_SET(0);
        private final int value;

        private ValueCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ValueCase valueOf(int value) {
          return forNumber(value);
        }

        public static ValueCase forNumber(int value) {
          switch (value) {
            case 2:
              return RATIO;
            case 4:
              return COUNT;
            case 0:
              return VALUE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public ValueCase getValueCase() {
        return ValueCase.forNumber(valueCase_);
      }

      public static final int TYPE_FIELD_NUMBER = 1;
      private int type_;
      /**
       *
       *
       * <pre>
       * Ratio-based metric type. Only one of type or count_type is specified in
       * each Metric.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType type = 1;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * Ratio-based metric type. Only one of type or count_type is specified in
       * each Metric.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType type = 1;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType getType() {
        @SuppressWarnings("deprecation")
        com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType result =
            com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType.valueOf(type_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType.UNRECOGNIZED
            : result;
      }

      public static final int COUNT_TYPE_FIELD_NUMBER = 5;
      private int countType_;
      /**
       *
       *
       * <pre>
       * Count-based metric type. Only one of type or count_type is specified in
       * each Metric.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType count_type = 5;</code>
       *
       * @return The enum numeric value on the wire for countType.
       */
      @java.lang.Override
      public int getCountTypeValue() {
        return countType_;
      }
      /**
       *
       *
       * <pre>
       * Count-based metric type. Only one of type or count_type is specified in
       * each Metric.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType count_type = 5;</code>
       *
       * @return The countType.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType getCountType() {
        @SuppressWarnings("deprecation")
        com.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType result =
            com.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType.valueOf(countType_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType.UNRECOGNIZED
            : result;
      }

      public static final int RATIO_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * Ratio value of a metric.
       * </pre>
       *
       * <code>double ratio = 2;</code>
       *
       * @return Whether the ratio field is set.
       */
      @java.lang.Override
      public boolean hasRatio() {
        return valueCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Ratio value of a metric.
       * </pre>
       *
       * <code>double ratio = 2;</code>
       *
       * @return The ratio.
       */
      @java.lang.Override
      public double getRatio() {
        if (valueCase_ == 2) {
          return (java.lang.Double) value_;
        }
        return 0D;
      }

      public static final int COUNT_FIELD_NUMBER = 4;
      /**
       *
       *
       * <pre>
       * Count value of a metric.
       * </pre>
       *
       * <code>double count = 4;</code>
       *
       * @return Whether the count field is set.
       */
      @java.lang.Override
      public boolean hasCount() {
        return valueCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Count value of a metric.
       * </pre>
       *
       * <code>double count = 4;</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public double getCount() {
        if (valueCase_ == 4) {
          return (java.lang.Double) value_;
        }
        return 0D;
      }

      public static final int CONFIDENCE_INTERVAL_FIELD_NUMBER = 3;
      private com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          confidenceInterval_;
      /**
       *
       *
       * <pre>
       * The probability that the treatment is better than all other treatments
       * in the experiment
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval confidence_interval = 3;
       * </code>
       *
       * @return Whether the confidenceInterval field is set.
       */
      @java.lang.Override
      public boolean hasConfidenceInterval() {
        return confidenceInterval_ != null;
      }
      /**
       *
       *
       * <pre>
       * The probability that the treatment is better than all other treatments
       * in the experiment
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval confidence_interval = 3;
       * </code>
       *
       * @return The confidenceInterval.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
          getConfidenceInterval() {
        return confidenceInterval_ == null
            ? com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
                .getDefaultInstance()
            : confidenceInterval_;
      }
      /**
       *
       *
       * <pre>
       * The probability that the treatment is better than all other treatments
       * in the experiment
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval confidence_interval = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceIntervalOrBuilder
          getConfidenceIntervalOrBuilder() {
        return getConfidenceInterval();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (type_
            != com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType.METRIC_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(1, type_);
        }
        if (valueCase_ == 2) {
          output.writeDouble(2, (double) ((java.lang.Double) value_));
        }
        if (confidenceInterval_ != null) {
          output.writeMessage(3, getConfidenceInterval());
        }
        if (valueCase_ == 4) {
          output.writeDouble(4, (double) ((java.lang.Double) value_));
        }
        if (countType_
            != com.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType.COUNT_TYPE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(5, countType_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (type_
            != com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType.METRIC_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
        }
        if (valueCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeDoubleSize(
                  2, (double) ((java.lang.Double) value_));
        }
        if (confidenceInterval_ != null) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(3, getConfidenceInterval());
        }
        if (valueCase_ == 4) {
          size +=
              com.google.protobuf.CodedOutputStream.computeDoubleSize(
                  4, (double) ((java.lang.Double) value_));
        }
        if (countType_
            != com.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType.COUNT_TYPE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, countType_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric other =
            (com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric) obj;

        if (type_ != other.type_) return false;
        if (countType_ != other.countType_) return false;
        if (hasConfidenceInterval() != other.hasConfidenceInterval()) return false;
        if (hasConfidenceInterval()) {
          if (!getConfidenceInterval().equals(other.getConfidenceInterval())) return false;
        }
        if (!getValueCase().equals(other.getValueCase())) return false;
        switch (valueCase_) {
          case 2:
            if (java.lang.Double.doubleToLongBits(getRatio())
                != java.lang.Double.doubleToLongBits(other.getRatio())) return false;
            break;
          case 4:
            if (java.lang.Double.doubleToLongBits(getCount())
                != java.lang.Double.doubleToLongBits(other.getCount())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + type_;
        hash = (37 * hash) + COUNT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + countType_;
        if (hasConfidenceInterval()) {
          hash = (37 * hash) + CONFIDENCE_INTERVAL_FIELD_NUMBER;
          hash = (53 * hash) + getConfidenceInterval().hashCode();
        }
        switch (valueCase_) {
          case 2:
            hash = (37 * hash) + RATIO_FIELD_NUMBER;
            hash =
                (53 * hash)
                    + com.google.protobuf.Internal.hashLong(
                        java.lang.Double.doubleToLongBits(getRatio()));
            break;
          case 4:
            hash = (37 * hash) + COUNT_FIELD_NUMBER;
            hash =
                (53 * hash)
                    + com.google.protobuf.Internal.hashLong(
                        java.lang.Double.doubleToLongBits(getCount()));
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Metric and corresponding confidence intervals.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.cx.v3.Experiment.Result.Metric}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Experiment.Result.Metric)
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3.ExperimentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_Metric_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3.ExperimentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_Metric_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.class,
                  com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.Builder.class);
        }

        // Construct using com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          type_ = 0;

          countType_ = 0;

          if (confidenceIntervalBuilder_ == null) {
            confidenceInterval_ = null;
          } else {
            confidenceInterval_ = null;
            confidenceIntervalBuilder_ = null;
          }
          valueCase_ = 0;
          value_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3.ExperimentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_Metric_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric build() {
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric buildPartial() {
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric result =
              new com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric(this);
          result.type_ = type_;
          result.countType_ = countType_;
          if (valueCase_ == 2) {
            result.value_ = value_;
          }
          if (valueCase_ == 4) {
            result.value_ = value_;
          }
          if (confidenceIntervalBuilder_ == null) {
            result.confidenceInterval_ = confidenceInterval_;
          } else {
            result.confidenceInterval_ = confidenceIntervalBuilder_.build();
          }
          result.valueCase_ = valueCase_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric) {
            return mergeFrom((com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.getDefaultInstance())
            return this;
          if (other.type_ != 0) {
            setTypeValue(other.getTypeValue());
          }
          if (other.countType_ != 0) {
            setCountTypeValue(other.getCountTypeValue());
          }
          if (other.hasConfidenceInterval()) {
            mergeConfidenceInterval(other.getConfidenceInterval());
          }
          switch (other.getValueCase()) {
            case RATIO:
              {
                setRatio(other.getRatio());
                break;
              }
            case COUNT:
              {
                setCount(other.getCount());
                break;
              }
            case VALUE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    type_ = input.readEnum();

                    break;
                  } // case 8
                case 17:
                  {
                    value_ = input.readDouble();
                    valueCase_ = 2;
                    break;
                  } // case 17
                case 26:
                  {
                    input.readMessage(
                        getConfidenceIntervalFieldBuilder().getBuilder(), extensionRegistry);

                    break;
                  } // case 26
                case 33:
                  {
                    value_ = input.readDouble();
                    valueCase_ = 4;
                    break;
                  } // case 33
                case 40:
                  {
                    countType_ = input.readEnum();

                    break;
                  } // case 40
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int valueCase_ = 0;
        private java.lang.Object value_;

        public ValueCase getValueCase() {
          return ValueCase.forNumber(valueCase_);
        }

        public Builder clearValue() {
          valueCase_ = 0;
          value_ = null;
          onChanged();
          return this;
        }

        private int type_ = 0;
        /**
         *
         *
         * <pre>
         * Ratio-based metric type. Only one of type or count_type is specified in
         * each Metric.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType type = 1;</code>
         *
         * @return The enum numeric value on the wire for type.
         */
        @java.lang.Override
        public int getTypeValue() {
          return type_;
        }
        /**
         *
         *
         * <pre>
         * Ratio-based metric type. Only one of type or count_type is specified in
         * each Metric.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType type = 1;</code>
         *
         * @param value The enum numeric value on the wire for type to set.
         * @return This builder for chaining.
         */
        public Builder setTypeValue(int value) {

          type_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Ratio-based metric type. Only one of type or count_type is specified in
         * each Metric.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType type = 1;</code>
         *
         * @return The type.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType getType() {
          @SuppressWarnings("deprecation")
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType result =
              com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType.valueOf(type_);
          return result == null
              ? com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Ratio-based metric type. Only one of type or count_type is specified in
         * each Metric.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType type = 1;</code>
         *
         * @param value The type to set.
         * @return This builder for chaining.
         */
        public Builder setType(
            com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType value) {
          if (value == null) {
            throw new NullPointerException();
          }

          type_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Ratio-based metric type. Only one of type or count_type is specified in
         * each Metric.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType type = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearType() {

          type_ = 0;
          onChanged();
          return this;
        }

        private int countType_ = 0;
        /**
         *
         *
         * <pre>
         * Count-based metric type. Only one of type or count_type is specified in
         * each Metric.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType count_type = 5;</code>
         *
         * @return The enum numeric value on the wire for countType.
         */
        @java.lang.Override
        public int getCountTypeValue() {
          return countType_;
        }
        /**
         *
         *
         * <pre>
         * Count-based metric type. Only one of type or count_type is specified in
         * each Metric.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType count_type = 5;</code>
         *
         * @param value The enum numeric value on the wire for countType to set.
         * @return This builder for chaining.
         */
        public Builder setCountTypeValue(int value) {

          countType_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Count-based metric type. Only one of type or count_type is specified in
         * each Metric.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType count_type = 5;</code>
         *
         * @return The countType.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType getCountType() {
          @SuppressWarnings("deprecation")
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType result =
              com.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType.valueOf(countType_);
          return result == null
              ? com.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Count-based metric type. Only one of type or count_type is specified in
         * each Metric.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType count_type = 5;</code>
         *
         * @param value The countType to set.
         * @return This builder for chaining.
         */
        public Builder setCountType(
            com.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType value) {
          if (value == null) {
            throw new NullPointerException();
          }

          countType_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Count-based metric type. Only one of type or count_type is specified in
         * each Metric.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result.CountType count_type = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCountType() {

          countType_ = 0;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Ratio value of a metric.
         * </pre>
         *
         * <code>double ratio = 2;</code>
         *
         * @return Whether the ratio field is set.
         */
        public boolean hasRatio() {
          return valueCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Ratio value of a metric.
         * </pre>
         *
         * <code>double ratio = 2;</code>
         *
         * @return The ratio.
         */
        public double getRatio() {
          if (valueCase_ == 2) {
            return (java.lang.Double) value_;
          }
          return 0D;
        }
        /**
         *
         *
         * <pre>
         * Ratio value of a metric.
         * </pre>
         *
         * <code>double ratio = 2;</code>
         *
         * @param value The ratio to set.
         * @return This builder for chaining.
         */
        public Builder setRatio(double value) {
          valueCase_ = 2;
          value_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Ratio value of a metric.
         * </pre>
         *
         * <code>double ratio = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRatio() {
          if (valueCase_ == 2) {
            valueCase_ = 0;
            value_ = null;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Count value of a metric.
         * </pre>
         *
         * <code>double count = 4;</code>
         *
         * @return Whether the count field is set.
         */
        public boolean hasCount() {
          return valueCase_ == 4;
        }
        /**
         *
         *
         * <pre>
         * Count value of a metric.
         * </pre>
         *
         * <code>double count = 4;</code>
         *
         * @return The count.
         */
        public double getCount() {
          if (valueCase_ == 4) {
            return (java.lang.Double) value_;
          }
          return 0D;
        }
        /**
         *
         *
         * <pre>
         * Count value of a metric.
         * </pre>
         *
         * <code>double count = 4;</code>
         *
         * @param value The count to set.
         * @return This builder for chaining.
         */
        public Builder setCount(double value) {
          valueCase_ = 4;
          value_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Count value of a metric.
         * </pre>
         *
         * <code>double count = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCount() {
          if (valueCase_ == 4) {
            valueCase_ = 0;
            value_ = null;
            onChanged();
          }
          return this;
        }

        private com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
            confidenceInterval_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval,
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval.Builder,
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceIntervalOrBuilder>
            confidenceIntervalBuilder_;
        /**
         *
         *
         * <pre>
         * The probability that the treatment is better than all other treatments
         * in the experiment
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval confidence_interval = 3;
         * </code>
         *
         * @return Whether the confidenceInterval field is set.
         */
        public boolean hasConfidenceInterval() {
          return confidenceIntervalBuilder_ != null || confidenceInterval_ != null;
        }
        /**
         *
         *
         * <pre>
         * The probability that the treatment is better than all other treatments
         * in the experiment
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval confidence_interval = 3;
         * </code>
         *
         * @return The confidenceInterval.
         */
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
            getConfidenceInterval() {
          if (confidenceIntervalBuilder_ == null) {
            return confidenceInterval_ == null
                ? com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
                    .getDefaultInstance()
                : confidenceInterval_;
          } else {
            return confidenceIntervalBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The probability that the treatment is better than all other treatments
         * in the experiment
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval confidence_interval = 3;
         * </code>
         */
        public Builder setConfidenceInterval(
            com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval value) {
          if (confidenceIntervalBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            confidenceInterval_ = value;
            onChanged();
          } else {
            confidenceIntervalBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The probability that the treatment is better than all other treatments
         * in the experiment
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval confidence_interval = 3;
         * </code>
         */
        public Builder setConfidenceInterval(
            com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval.Builder
                builderForValue) {
          if (confidenceIntervalBuilder_ == null) {
            confidenceInterval_ = builderForValue.build();
            onChanged();
          } else {
            confidenceIntervalBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The probability that the treatment is better than all other treatments
         * in the experiment
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval confidence_interval = 3;
         * </code>
         */
        public Builder mergeConfidenceInterval(
            com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval value) {
          if (confidenceIntervalBuilder_ == null) {
            if (confidenceInterval_ != null) {
              confidenceInterval_ =
                  com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval.newBuilder(
                          confidenceInterval_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              confidenceInterval_ = value;
            }
            onChanged();
          } else {
            confidenceIntervalBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The probability that the treatment is better than all other treatments
         * in the experiment
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval confidence_interval = 3;
         * </code>
         */
        public Builder clearConfidenceInterval() {
          if (confidenceIntervalBuilder_ == null) {
            confidenceInterval_ = null;
            onChanged();
          } else {
            confidenceInterval_ = null;
            confidenceIntervalBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The probability that the treatment is better than all other treatments
         * in the experiment
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval confidence_interval = 3;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval.Builder
            getConfidenceIntervalBuilder() {

          onChanged();
          return getConfidenceIntervalFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The probability that the treatment is better than all other treatments
         * in the experiment
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval confidence_interval = 3;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceIntervalOrBuilder
            getConfidenceIntervalOrBuilder() {
          if (confidenceIntervalBuilder_ != null) {
            return confidenceIntervalBuilder_.getMessageOrBuilder();
          } else {
            return confidenceInterval_ == null
                ? com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
                    .getDefaultInstance()
                : confidenceInterval_;
          }
        }
        /**
         *
         *
         * <pre>
         * The probability that the treatment is better than all other treatments
         * in the experiment
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval confidence_interval = 3;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval,
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval.Builder,
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceIntervalOrBuilder>
            getConfidenceIntervalFieldBuilder() {
          if (confidenceIntervalBuilder_ == null) {
            confidenceIntervalBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval,
                    com.google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval.Builder,
                    com.google.cloud.dialogflow.cx.v3.Experiment.Result
                        .ConfidenceIntervalOrBuilder>(
                    getConfidenceInterval(), getParentForChildren(), isClean());
            confidenceInterval_ = null;
          }
          return confidenceIntervalBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Experiment.Result.Metric)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Experiment.Result.Metric)
      private static final com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric();
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Metric> PARSER =
          new com.google.protobuf.AbstractParser<Metric>() {
            @java.lang.Override
            public Metric parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Metric> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Metric> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface VersionMetricsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The name of the flow [Version][google.cloud.dialogflow.cx.v3.Version].
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/agents/&lt;Agent ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
       * </pre>
       *
       * <code>string version = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The version.
       */
      java.lang.String getVersion();
      /**
       *
       *
       * <pre>
       * The name of the flow [Version][google.cloud.dialogflow.cx.v3.Version].
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/agents/&lt;Agent ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
       * </pre>
       *
       * <code>string version = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for version.
       */
      com.google.protobuf.ByteString getVersionBytes();

      /**
       *
       *
       * <pre>
       * The metrics and corresponding confidence intervals in the inference
       * result.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;</code>
       */
      java.util.List<com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric> getMetricsList();
      /**
       *
       *
       * <pre>
       * The metrics and corresponding confidence intervals in the inference
       * result.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;</code>
       */
      com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric getMetrics(int index);
      /**
       *
       *
       * <pre>
       * The metrics and corresponding confidence intervals in the inference
       * result.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;</code>
       */
      int getMetricsCount();
      /**
       *
       *
       * <pre>
       * The metrics and corresponding confidence intervals in the inference
       * result.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;</code>
       */
      java.util.List<? extends com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricOrBuilder>
          getMetricsOrBuilderList();
      /**
       *
       *
       * <pre>
       * The metrics and corresponding confidence intervals in the inference
       * result.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;</code>
       */
      com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricOrBuilder getMetricsOrBuilder(
          int index);

      /**
       *
       *
       * <pre>
       * Number of sessions that were allocated to this version.
       * </pre>
       *
       * <code>int32 session_count = 3;</code>
       *
       * @return The sessionCount.
       */
      int getSessionCount();
    }
    /**
     *
     *
     * <pre>
     * Version variant and associated metrics.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics}
     */
    public static final class VersionMetrics extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics)
        VersionMetricsOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use VersionMetrics.newBuilder() to construct.
      private VersionMetrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private VersionMetrics() {
        version_ = "";
        metrics_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new VersionMetrics();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_VersionMetrics_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_VersionMetrics_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.class,
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.Builder.class);
      }

      public static final int VERSION_FIELD_NUMBER = 1;
      private volatile java.lang.Object version_;
      /**
       *
       *
       * <pre>
       * The name of the flow [Version][google.cloud.dialogflow.cx.v3.Version].
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/agents/&lt;Agent ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
       * </pre>
       *
       * <code>string version = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The version.
       */
      @java.lang.Override
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          version_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the flow [Version][google.cloud.dialogflow.cx.v3.Version].
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/agents/&lt;Agent ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
       * </pre>
       *
       * <code>string version = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for version.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int METRICS_FIELD_NUMBER = 2;
      private java.util.List<com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric> metrics_;
      /**
       *
       *
       * <pre>
       * The metrics and corresponding confidence intervals in the inference
       * result.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric>
          getMetricsList() {
        return metrics_;
      }
      /**
       *
       *
       * <pre>
       * The metrics and corresponding confidence intervals in the inference
       * result.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;</code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricOrBuilder>
          getMetricsOrBuilderList() {
        return metrics_;
      }
      /**
       *
       *
       * <pre>
       * The metrics and corresponding confidence intervals in the inference
       * result.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;</code>
       */
      @java.lang.Override
      public int getMetricsCount() {
        return metrics_.size();
      }
      /**
       *
       *
       * <pre>
       * The metrics and corresponding confidence intervals in the inference
       * result.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric getMetrics(int index) {
        return metrics_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The metrics and corresponding confidence intervals in the inference
       * result.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricOrBuilder
          getMetricsOrBuilder(int index) {
        return metrics_.get(index);
      }

      public static final int SESSION_COUNT_FIELD_NUMBER = 3;
      private int sessionCount_;
      /**
       *
       *
       * <pre>
       * Number of sessions that were allocated to this version.
       * </pre>
       *
       * <code>int32 session_count = 3;</code>
       *
       * @return The sessionCount.
       */
      @java.lang.Override
      public int getSessionCount() {
        return sessionCount_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, version_);
        }
        for (int i = 0; i < metrics_.size(); i++) {
          output.writeMessage(2, metrics_.get(i));
        }
        if (sessionCount_ != 0) {
          output.writeInt32(3, sessionCount_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, version_);
        }
        for (int i = 0; i < metrics_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, metrics_.get(i));
        }
        if (sessionCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, sessionCount_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics other =
            (com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics) obj;

        if (!getVersion().equals(other.getVersion())) return false;
        if (!getMetricsList().equals(other.getMetricsList())) return false;
        if (getSessionCount() != other.getSessionCount()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getVersion().hashCode();
        if (getMetricsCount() > 0) {
          hash = (37 * hash) + METRICS_FIELD_NUMBER;
          hash = (53 * hash) + getMetricsList().hashCode();
        }
        hash = (37 * hash) + SESSION_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getSessionCount();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Version variant and associated metrics.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics)
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetricsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3.ExperimentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_VersionMetrics_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3.ExperimentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_VersionMetrics_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.class,
                  com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          version_ = "";

          if (metricsBuilder_ == null) {
            metrics_ = java.util.Collections.emptyList();
          } else {
            metrics_ = null;
            metricsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          sessionCount_ = 0;

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3.ExperimentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_VersionMetrics_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics build() {
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics buildPartial() {
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics result =
              new com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics(this);
          int from_bitField0_ = bitField0_;
          result.version_ = version_;
          if (metricsBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              metrics_ = java.util.Collections.unmodifiableList(metrics_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.metrics_ = metrics_;
          } else {
            result.metrics_ = metricsBuilder_.build();
          }
          result.sessionCount_ = sessionCount_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics
                  .getDefaultInstance()) return this;
          if (!other.getVersion().isEmpty()) {
            version_ = other.version_;
            onChanged();
          }
          if (metricsBuilder_ == null) {
            if (!other.metrics_.isEmpty()) {
              if (metrics_.isEmpty()) {
                metrics_ = other.metrics_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureMetricsIsMutable();
                metrics_.addAll(other.metrics_);
              }
              onChanged();
            }
          } else {
            if (!other.metrics_.isEmpty()) {
              if (metricsBuilder_.isEmpty()) {
                metricsBuilder_.dispose();
                metricsBuilder_ = null;
                metrics_ = other.metrics_;
                bitField0_ = (bitField0_ & ~0x00000001);
                metricsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getMetricsFieldBuilder()
                        : null;
              } else {
                metricsBuilder_.addAllMessages(other.metrics_);
              }
            }
          }
          if (other.getSessionCount() != 0) {
            setSessionCount(other.getSessionCount());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    version_ = input.readStringRequireUtf8();

                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric m =
                        input.readMessage(
                            com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.parser(),
                            extensionRegistry);
                    if (metricsBuilder_ == null) {
                      ensureMetricsIsMutable();
                      metrics_.add(m);
                    } else {
                      metricsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                case 24:
                  {
                    sessionCount_ = input.readInt32();

                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object version_ = "";
        /**
         *
         *
         * <pre>
         * The name of the flow [Version][google.cloud.dialogflow.cx.v3.Version].
         * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/agents/&lt;Agent ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
         * </pre>
         *
         * <code>string version = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The version.
         */
        public java.lang.String getVersion() {
          java.lang.Object ref = version_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            version_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the flow [Version][google.cloud.dialogflow.cx.v3.Version].
         * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/agents/&lt;Agent ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
         * </pre>
         *
         * <code>string version = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The bytes for version.
         */
        public com.google.protobuf.ByteString getVersionBytes() {
          java.lang.Object ref = version_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            version_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the flow [Version][google.cloud.dialogflow.cx.v3.Version].
         * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/agents/&lt;Agent ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
         * </pre>
         *
         * <code>string version = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The version to set.
         * @return This builder for chaining.
         */
        public Builder setVersion(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          version_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the flow [Version][google.cloud.dialogflow.cx.v3.Version].
         * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/agents/&lt;Agent ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
         * </pre>
         *
         * <code>string version = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearVersion() {

          version_ = getDefaultInstance().getVersion();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the flow [Version][google.cloud.dialogflow.cx.v3.Version].
         * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/agents/&lt;Agent ID&gt;/flows/&lt;Flow ID&gt;/versions/&lt;Version ID&gt;`.
         * </pre>
         *
         * <code>string version = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The bytes for version to set.
         * @return This builder for chaining.
         */
        public Builder setVersionBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          version_ = value;
          onChanged();
          return this;
        }

        private java.util.List<com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric>
            metrics_ = java.util.Collections.emptyList();

        private void ensureMetricsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            metrics_ =
                new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric>(
                    metrics_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric,
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.Builder,
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricOrBuilder>
            metricsBuilder_;

        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public java.util.List<com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric>
            getMetricsList() {
          if (metricsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(metrics_);
          } else {
            return metricsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public int getMetricsCount() {
          if (metricsBuilder_ == null) {
            return metrics_.size();
          } else {
            return metricsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric getMetrics(int index) {
          if (metricsBuilder_ == null) {
            return metrics_.get(index);
          } else {
            return metricsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public Builder setMetrics(
            int index, com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric value) {
          if (metricsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMetricsIsMutable();
            metrics_.set(index, value);
            onChanged();
          } else {
            metricsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public Builder setMetrics(
            int index,
            com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.Builder builderForValue) {
          if (metricsBuilder_ == null) {
            ensureMetricsIsMutable();
            metrics_.set(index, builderForValue.build());
            onChanged();
          } else {
            metricsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public Builder addMetrics(
            com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric value) {
          if (metricsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMetricsIsMutable();
            metrics_.add(value);
            onChanged();
          } else {
            metricsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public Builder addMetrics(
            int index, com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric value) {
          if (metricsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMetricsIsMutable();
            metrics_.add(index, value);
            onChanged();
          } else {
            metricsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public Builder addMetrics(
            com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.Builder builderForValue) {
          if (metricsBuilder_ == null) {
            ensureMetricsIsMutable();
            metrics_.add(builderForValue.build());
            onChanged();
          } else {
            metricsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public Builder addMetrics(
            int index,
            com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.Builder builderForValue) {
          if (metricsBuilder_ == null) {
            ensureMetricsIsMutable();
            metrics_.add(index, builderForValue.build());
            onChanged();
          } else {
            metricsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public Builder addAllMetrics(
            java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric>
                values) {
          if (metricsBuilder_ == null) {
            ensureMetricsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
            onChanged();
          } else {
            metricsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public Builder clearMetrics() {
          if (metricsBuilder_ == null) {
            metrics_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            metricsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public Builder removeMetrics(int index) {
          if (metricsBuilder_ == null) {
            ensureMetricsIsMutable();
            metrics_.remove(index);
            onChanged();
          } else {
            metricsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.Builder getMetricsBuilder(
            int index) {
          return getMetricsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricOrBuilder
            getMetricsOrBuilder(int index) {
          if (metricsBuilder_ == null) {
            return metrics_.get(index);
          } else {
            return metricsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public java.util.List<
                ? extends com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricOrBuilder>
            getMetricsOrBuilderList() {
          if (metricsBuilder_ != null) {
            return metricsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(metrics_);
          }
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.Builder
            addMetricsBuilder() {
          return getMetricsFieldBuilder()
              .addBuilder(
                  com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.Builder addMetricsBuilder(
            int index) {
          return getMetricsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * The metrics and corresponding confidence intervals in the inference
         * result.
         * </pre>
         *
         * <code>repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.Metric metrics = 2;
         * </code>
         */
        public java.util.List<com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.Builder>
            getMetricsBuilderList() {
          return getMetricsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric,
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.Builder,
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricOrBuilder>
            getMetricsFieldBuilder() {
          if (metricsBuilder_ == null) {
            metricsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric,
                    com.google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.Builder,
                    com.google.cloud.dialogflow.cx.v3.Experiment.Result.MetricOrBuilder>(
                    metrics_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
            metrics_ = null;
          }
          return metricsBuilder_;
        }

        private int sessionCount_;
        /**
         *
         *
         * <pre>
         * Number of sessions that were allocated to this version.
         * </pre>
         *
         * <code>int32 session_count = 3;</code>
         *
         * @return The sessionCount.
         */
        @java.lang.Override
        public int getSessionCount() {
          return sessionCount_;
        }
        /**
         *
         *
         * <pre>
         * Number of sessions that were allocated to this version.
         * </pre>
         *
         * <code>int32 session_count = 3;</code>
         *
         * @param value The sessionCount to set.
         * @return This builder for chaining.
         */
        public Builder setSessionCount(int value) {

          sessionCount_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of sessions that were allocated to this version.
         * </pre>
         *
         * <code>int32 session_count = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSessionCount() {

          sessionCount_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics)
      private static final com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics();
      }

      public static com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<VersionMetrics> PARSER =
          new com.google.protobuf.AbstractParser<VersionMetrics>() {
            @java.lang.Override
            public VersionMetrics parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<VersionMetrics> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<VersionMetrics> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int VERSION_METRICS_FIELD_NUMBER = 1;
    private java.util.List<com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics>
        versionMetrics_;
    /**
     *
     *
     * <pre>
     * Version variants and metrics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics>
        getVersionMetricsList() {
      return versionMetrics_;
    }
    /**
     *
     *
     * <pre>
     * Version variants and metrics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetricsOrBuilder>
        getVersionMetricsOrBuilderList() {
      return versionMetrics_;
    }
    /**
     *
     *
     * <pre>
     * Version variants and metrics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
     * </code>
     */
    @java.lang.Override
    public int getVersionMetricsCount() {
      return versionMetrics_.size();
    }
    /**
     *
     *
     * <pre>
     * Version variants and metrics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics getVersionMetrics(
        int index) {
      return versionMetrics_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Version variants and metrics.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetricsOrBuilder
        getVersionMetricsOrBuilder(int index) {
      return versionMetrics_.get(index);
    }

    public static final int LAST_UPDATE_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp lastUpdateTime_;
    /**
     *
     *
     * <pre>
     * The last time the experiment's stats data was updated. Will have default
     * value if stats have never been computed for this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 2;</code>
     *
     * @return Whether the lastUpdateTime field is set.
     */
    @java.lang.Override
    public boolean hasLastUpdateTime() {
      return lastUpdateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The last time the experiment's stats data was updated. Will have default
     * value if stats have never been computed for this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 2;</code>
     *
     * @return The lastUpdateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getLastUpdateTime() {
      return lastUpdateTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : lastUpdateTime_;
    }
    /**
     *
     *
     * <pre>
     * The last time the experiment's stats data was updated. Will have default
     * value if stats have never been computed for this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
      return getLastUpdateTime();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < versionMetrics_.size(); i++) {
        output.writeMessage(1, versionMetrics_.get(i));
      }
      if (lastUpdateTime_ != null) {
        output.writeMessage(2, getLastUpdateTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < versionMetrics_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, versionMetrics_.get(i));
      }
      if (lastUpdateTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLastUpdateTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Experiment.Result)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.Experiment.Result other =
          (com.google.cloud.dialogflow.cx.v3.Experiment.Result) obj;

      if (!getVersionMetricsList().equals(other.getVersionMetricsList())) return false;
      if (hasLastUpdateTime() != other.hasLastUpdateTime()) return false;
      if (hasLastUpdateTime()) {
        if (!getLastUpdateTime().equals(other.getLastUpdateTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getVersionMetricsCount() > 0) {
        hash = (37 * hash) + VERSION_METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getVersionMetricsList().hashCode();
      }
      if (hasLastUpdateTime()) {
        hash = (37 * hash) + LAST_UPDATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getLastUpdateTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Result parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Result parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Result parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Result parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Result parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Result parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Result parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Result parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Result parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Result parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Result parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Result parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.Experiment.Result prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The inference result which includes an objective metric to optimize and the
     * confidence interval.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.Experiment.Result}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Experiment.Result)
        com.google.cloud.dialogflow.cx.v3.Experiment.ResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.class,
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3.Experiment.Result.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (versionMetricsBuilder_ == null) {
          versionMetrics_ = java.util.Collections.emptyList();
        } else {
          versionMetrics_ = null;
          versionMetricsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (lastUpdateTimeBuilder_ == null) {
          lastUpdateTime_ = null;
        } else {
          lastUpdateTime_ = null;
          lastUpdateTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Experiment_Result_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.Experiment.Result.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result build() {
        com.google.cloud.dialogflow.cx.v3.Experiment.Result result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result buildPartial() {
        com.google.cloud.dialogflow.cx.v3.Experiment.Result result =
            new com.google.cloud.dialogflow.cx.v3.Experiment.Result(this);
        int from_bitField0_ = bitField0_;
        if (versionMetricsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            versionMetrics_ = java.util.Collections.unmodifiableList(versionMetrics_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.versionMetrics_ = versionMetrics_;
        } else {
          result.versionMetrics_ = versionMetricsBuilder_.build();
        }
        if (lastUpdateTimeBuilder_ == null) {
          result.lastUpdateTime_ = lastUpdateTime_;
        } else {
          result.lastUpdateTime_ = lastUpdateTimeBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.Experiment.Result) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3.Experiment.Result) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.Experiment.Result other) {
        if (other == com.google.cloud.dialogflow.cx.v3.Experiment.Result.getDefaultInstance())
          return this;
        if (versionMetricsBuilder_ == null) {
          if (!other.versionMetrics_.isEmpty()) {
            if (versionMetrics_.isEmpty()) {
              versionMetrics_ = other.versionMetrics_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureVersionMetricsIsMutable();
              versionMetrics_.addAll(other.versionMetrics_);
            }
            onChanged();
          }
        } else {
          if (!other.versionMetrics_.isEmpty()) {
            if (versionMetricsBuilder_.isEmpty()) {
              versionMetricsBuilder_.dispose();
              versionMetricsBuilder_ = null;
              versionMetrics_ = other.versionMetrics_;
              bitField0_ = (bitField0_ & ~0x00000001);
              versionMetricsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getVersionMetricsFieldBuilder()
                      : null;
            } else {
              versionMetricsBuilder_.addAllMessages(other.versionMetrics_);
            }
          }
        }
        if (other.hasLastUpdateTime()) {
          mergeLastUpdateTime(other.getLastUpdateTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics m =
                      input.readMessage(
                          com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics
                              .parser(),
                          extensionRegistry);
                  if (versionMetricsBuilder_ == null) {
                    ensureVersionMetricsIsMutable();
                    versionMetrics_.add(m);
                  } else {
                    versionMetricsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getLastUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics>
          versionMetrics_ = java.util.Collections.emptyList();

      private void ensureVersionMetricsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          versionMetrics_ =
              new java.util.ArrayList<
                  com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics>(
                  versionMetrics_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics,
              com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.Builder,
              com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetricsOrBuilder>
          versionMetricsBuilder_;

      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics>
          getVersionMetricsList() {
        if (versionMetricsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(versionMetrics_);
        } else {
          return versionMetricsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public int getVersionMetricsCount() {
        if (versionMetricsBuilder_ == null) {
          return versionMetrics_.size();
        } else {
          return versionMetricsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics getVersionMetrics(
          int index) {
        if (versionMetricsBuilder_ == null) {
          return versionMetrics_.get(index);
        } else {
          return versionMetricsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public Builder setVersionMetrics(
          int index, com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics value) {
        if (versionMetricsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureVersionMetricsIsMutable();
          versionMetrics_.set(index, value);
          onChanged();
        } else {
          versionMetricsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public Builder setVersionMetrics(
          int index,
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.Builder
              builderForValue) {
        if (versionMetricsBuilder_ == null) {
          ensureVersionMetricsIsMutable();
          versionMetrics_.set(index, builderForValue.build());
          onChanged();
        } else {
          versionMetricsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public Builder addVersionMetrics(
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics value) {
        if (versionMetricsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureVersionMetricsIsMutable();
          versionMetrics_.add(value);
          onChanged();
        } else {
          versionMetricsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public Builder addVersionMetrics(
          int index, com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics value) {
        if (versionMetricsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureVersionMetricsIsMutable();
          versionMetrics_.add(index, value);
          onChanged();
        } else {
          versionMetricsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public Builder addVersionMetrics(
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.Builder
              builderForValue) {
        if (versionMetricsBuilder_ == null) {
          ensureVersionMetricsIsMutable();
          versionMetrics_.add(builderForValue.build());
          onChanged();
        } else {
          versionMetricsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public Builder addVersionMetrics(
          int index,
          com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.Builder
              builderForValue) {
        if (versionMetricsBuilder_ == null) {
          ensureVersionMetricsIsMutable();
          versionMetrics_.add(index, builderForValue.build());
          onChanged();
        } else {
          versionMetricsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public Builder addAllVersionMetrics(
          java.lang.Iterable<
                  ? extends com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics>
              values) {
        if (versionMetricsBuilder_ == null) {
          ensureVersionMetricsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, versionMetrics_);
          onChanged();
        } else {
          versionMetricsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public Builder clearVersionMetrics() {
        if (versionMetricsBuilder_ == null) {
          versionMetrics_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          versionMetricsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public Builder removeVersionMetrics(int index) {
        if (versionMetricsBuilder_ == null) {
          ensureVersionMetricsIsMutable();
          versionMetrics_.remove(index);
          onChanged();
        } else {
          versionMetricsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.Builder
          getVersionMetricsBuilder(int index) {
        return getVersionMetricsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetricsOrBuilder
          getVersionMetricsOrBuilder(int index) {
        if (versionMetricsBuilder_ == null) {
          return versionMetrics_.get(index);
        } else {
          return versionMetricsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetricsOrBuilder>
          getVersionMetricsOrBuilderList() {
        if (versionMetricsBuilder_ != null) {
          return versionMetricsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(versionMetrics_);
        }
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.Builder
          addVersionMetricsBuilder() {
        return getVersionMetricsFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.Builder
          addVersionMetricsBuilder(int index) {
        return getVersionMetricsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Version variants and metrics.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics version_metrics = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.Builder>
          getVersionMetricsBuilderList() {
        return getVersionMetricsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics,
              com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.Builder,
              com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetricsOrBuilder>
          getVersionMetricsFieldBuilder() {
        if (versionMetricsBuilder_ == null) {
          versionMetricsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics,
                  com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.Builder,
                  com.google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetricsOrBuilder>(
                  versionMetrics_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          versionMetrics_ = null;
        }
        return versionMetricsBuilder_;
      }

      private com.google.protobuf.Timestamp lastUpdateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          lastUpdateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The last time the experiment's stats data was updated. Will have default
       * value if stats have never been computed for this experiment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_update_time = 2;</code>
       *
       * @return Whether the lastUpdateTime field is set.
       */
      public boolean hasLastUpdateTime() {
        return lastUpdateTimeBuilder_ != null || lastUpdateTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * The last time the experiment's stats data was updated. Will have default
       * value if stats have never been computed for this experiment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_update_time = 2;</code>
       *
       * @return The lastUpdateTime.
       */
      public com.google.protobuf.Timestamp getLastUpdateTime() {
        if (lastUpdateTimeBuilder_ == null) {
          return lastUpdateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastUpdateTime_;
        } else {
          return lastUpdateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The last time the experiment's stats data was updated. Will have default
       * value if stats have never been computed for this experiment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_update_time = 2;</code>
       */
      public Builder setLastUpdateTime(com.google.protobuf.Timestamp value) {
        if (lastUpdateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastUpdateTime_ = value;
          onChanged();
        } else {
          lastUpdateTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time the experiment's stats data was updated. Will have default
       * value if stats have never been computed for this experiment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_update_time = 2;</code>
       */
      public Builder setLastUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (lastUpdateTimeBuilder_ == null) {
          lastUpdateTime_ = builderForValue.build();
          onChanged();
        } else {
          lastUpdateTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time the experiment's stats data was updated. Will have default
       * value if stats have never been computed for this experiment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_update_time = 2;</code>
       */
      public Builder mergeLastUpdateTime(com.google.protobuf.Timestamp value) {
        if (lastUpdateTimeBuilder_ == null) {
          if (lastUpdateTime_ != null) {
            lastUpdateTime_ =
                com.google.protobuf.Timestamp.newBuilder(lastUpdateTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            lastUpdateTime_ = value;
          }
          onChanged();
        } else {
          lastUpdateTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time the experiment's stats data was updated. Will have default
       * value if stats have never been computed for this experiment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_update_time = 2;</code>
       */
      public Builder clearLastUpdateTime() {
        if (lastUpdateTimeBuilder_ == null) {
          lastUpdateTime_ = null;
          onChanged();
        } else {
          lastUpdateTime_ = null;
          lastUpdateTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time the experiment's stats data was updated. Will have default
       * value if stats have never been computed for this experiment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_update_time = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getLastUpdateTimeBuilder() {

        onChanged();
        return getLastUpdateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The last time the experiment's stats data was updated. Will have default
       * value if stats have never been computed for this experiment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_update_time = 2;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
        if (lastUpdateTimeBuilder_ != null) {
          return lastUpdateTimeBuilder_.getMessageOrBuilder();
        } else {
          return lastUpdateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastUpdateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The last time the experiment's stats data was updated. Will have default
       * value if stats have never been computed for this experiment.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_update_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getLastUpdateTimeFieldBuilder() {
        if (lastUpdateTimeBuilder_ == null) {
          lastUpdateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getLastUpdateTime(), getParentForChildren(), isClean());
          lastUpdateTime_ = null;
        }
        return lastUpdateTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Experiment.Result)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Experiment.Result)
    private static final com.google.cloud.dialogflow.cx.v3.Experiment.Result DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Experiment.Result();
    }

    public static com.google.cloud.dialogflow.cx.v3.Experiment.Result getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Result> PARSER =
        new com.google.protobuf.AbstractParser<Result>() {
          @java.lang.Override
          public Result parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Result> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Result> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Experiment.Result getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The name of the experiment.
   * Format: projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/environments/&lt;Environment ID&gt;/experiments/&lt;Experiment ID&gt;..
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the experiment.
   * Format: projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/environments/&lt;Environment ID&gt;/experiments/&lt;Experiment ID&gt;..
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the experiment (unique in an environment). Limit
   * of 64 characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the experiment (unique in an environment). Limit
   * of 64 characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * The human-readable description of the experiment.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The human-readable description of the experiment.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_;
  /**
   *
   *
   * <pre>
   * The current state of the experiment.
   * Transition triggered by Experiments.StartExperiment: DRAFT-&gt;RUNNING.
   * Transition triggered by Experiments.CancelExperiment: DRAFT-&gt;DONE or
   * RUNNING-&gt;DONE.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Experiment.State state = 4;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * The current state of the experiment.
   * Transition triggered by Experiments.StartExperiment: DRAFT-&gt;RUNNING.
   * Transition triggered by Experiments.CancelExperiment: DRAFT-&gt;DONE or
   * RUNNING-&gt;DONE.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Experiment.State state = 4;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Experiment.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.cx.v3.Experiment.State result =
        com.google.cloud.dialogflow.cx.v3.Experiment.State.valueOf(state_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3.Experiment.State.UNRECOGNIZED
        : result;
  }

  public static final int DEFINITION_FIELD_NUMBER = 5;
  private com.google.cloud.dialogflow.cx.v3.Experiment.Definition definition_;
  /**
   *
   *
   * <pre>
   * The definition of the experiment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Experiment.Definition definition = 5;</code>
   *
   * @return Whether the definition field is set.
   */
  @java.lang.Override
  public boolean hasDefinition() {
    return definition_ != null;
  }
  /**
   *
   *
   * <pre>
   * The definition of the experiment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Experiment.Definition definition = 5;</code>
   *
   * @return The definition.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Experiment.Definition getDefinition() {
    return definition_ == null
        ? com.google.cloud.dialogflow.cx.v3.Experiment.Definition.getDefaultInstance()
        : definition_;
  }
  /**
   *
   *
   * <pre>
   * The definition of the experiment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Experiment.Definition definition = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Experiment.DefinitionOrBuilder getDefinitionOrBuilder() {
    return getDefinition();
  }

  public static final int ROLLOUT_CONFIG_FIELD_NUMBER = 14;
  private com.google.cloud.dialogflow.cx.v3.RolloutConfig rolloutConfig_;
  /**
   *
   *
   * <pre>
   * The configuration for auto rollout. If set, there should be exactly two
   * variants in the experiment (control variant being the default version of
   * the flow), the traffic allocation for the non-control variant will
   * gradually increase to 100% when conditions are met, and eventually
   * replace the control variant to become the default version of the flow.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.RolloutConfig rollout_config = 14;</code>
   *
   * @return Whether the rolloutConfig field is set.
   */
  @java.lang.Override
  public boolean hasRolloutConfig() {
    return rolloutConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The configuration for auto rollout. If set, there should be exactly two
   * variants in the experiment (control variant being the default version of
   * the flow), the traffic allocation for the non-control variant will
   * gradually increase to 100% when conditions are met, and eventually
   * replace the control variant to become the default version of the flow.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.RolloutConfig rollout_config = 14;</code>
   *
   * @return The rolloutConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.RolloutConfig getRolloutConfig() {
    return rolloutConfig_ == null
        ? com.google.cloud.dialogflow.cx.v3.RolloutConfig.getDefaultInstance()
        : rolloutConfig_;
  }
  /**
   *
   *
   * <pre>
   * The configuration for auto rollout. If set, there should be exactly two
   * variants in the experiment (control variant being the default version of
   * the flow), the traffic allocation for the non-control variant will
   * gradually increase to 100% when conditions are met, and eventually
   * replace the control variant to become the default version of the flow.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.RolloutConfig rollout_config = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.RolloutConfigOrBuilder getRolloutConfigOrBuilder() {
    return getRolloutConfig();
  }

  public static final int ROLLOUT_STATE_FIELD_NUMBER = 15;
  private com.google.cloud.dialogflow.cx.v3.RolloutState rolloutState_;
  /**
   *
   *
   * <pre>
   * State of the auto rollout process.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.RolloutState rollout_state = 15;</code>
   *
   * @return Whether the rolloutState field is set.
   */
  @java.lang.Override
  public boolean hasRolloutState() {
    return rolloutState_ != null;
  }
  /**
   *
   *
   * <pre>
   * State of the auto rollout process.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.RolloutState rollout_state = 15;</code>
   *
   * @return The rolloutState.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.RolloutState getRolloutState() {
    return rolloutState_ == null
        ? com.google.cloud.dialogflow.cx.v3.RolloutState.getDefaultInstance()
        : rolloutState_;
  }
  /**
   *
   *
   * <pre>
   * State of the auto rollout process.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.RolloutState rollout_state = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.RolloutStateOrBuilder getRolloutStateOrBuilder() {
    return getRolloutState();
  }

  public static final int ROLLOUT_FAILURE_REASON_FIELD_NUMBER = 16;
  private volatile java.lang.Object rolloutFailureReason_;
  /**
   *
   *
   * <pre>
   * The reason why rollout has failed. Should only be set when state is
   * ROLLOUT_FAILED.
   * </pre>
   *
   * <code>string rollout_failure_reason = 16;</code>
   *
   * @return The rolloutFailureReason.
   */
  @java.lang.Override
  public java.lang.String getRolloutFailureReason() {
    java.lang.Object ref = rolloutFailureReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rolloutFailureReason_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The reason why rollout has failed. Should only be set when state is
   * ROLLOUT_FAILED.
   * </pre>
   *
   * <code>string rollout_failure_reason = 16;</code>
   *
   * @return The bytes for rolloutFailureReason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRolloutFailureReasonBytes() {
    java.lang.Object ref = rolloutFailureReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rolloutFailureReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESULT_FIELD_NUMBER = 6;
  private com.google.cloud.dialogflow.cx.v3.Experiment.Result result_;
  /**
   *
   *
   * <pre>
   * Inference result of the experiment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result result = 6;</code>
   *
   * @return Whether the result field is set.
   */
  @java.lang.Override
  public boolean hasResult() {
    return result_ != null;
  }
  /**
   *
   *
   * <pre>
   * Inference result of the experiment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result result = 6;</code>
   *
   * @return The result.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Experiment.Result getResult() {
    return result_ == null
        ? com.google.cloud.dialogflow.cx.v3.Experiment.Result.getDefaultInstance()
        : result_;
  }
  /**
   *
   *
   * <pre>
   * Inference result of the experiment.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result result = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Experiment.ResultOrBuilder getResultOrBuilder() {
    return getResult();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Creation time of this experiment.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Creation time of this experiment.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Creation time of this experiment.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int START_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Start time of this experiment.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 8;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Start time of this experiment.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 8;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Start time of this experiment.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * End time of this experiment.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 9;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * End time of this experiment.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 9;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * End time of this experiment.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  public static final int LAST_UPDATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp lastUpdateTime_;
  /**
   *
   *
   * <pre>
   * Last update time of this experiment.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 10;</code>
   *
   * @return Whether the lastUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasLastUpdateTime() {
    return lastUpdateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Last update time of this experiment.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 10;</code>
   *
   * @return The lastUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastUpdateTime() {
    return lastUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastUpdateTime_;
  }
  /**
   *
   *
   * <pre>
   * Last update time of this experiment.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_update_time = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
    return getLastUpdateTime();
  }

  public static final int EXPERIMENT_LENGTH_FIELD_NUMBER = 11;
  private com.google.protobuf.Duration experimentLength_;
  /**
   *
   *
   * <pre>
   * Maximum number of days to run the experiment/rollout. If auto-rollout is
   * not enabled, default value and maximum will be 30 days. If auto-rollout is
   * enabled, default value and maximum will be 6 days.
   * </pre>
   *
   * <code>.google.protobuf.Duration experiment_length = 11;</code>
   *
   * @return Whether the experimentLength field is set.
   */
  @java.lang.Override
  public boolean hasExperimentLength() {
    return experimentLength_ != null;
  }
  /**
   *
   *
   * <pre>
   * Maximum number of days to run the experiment/rollout. If auto-rollout is
   * not enabled, default value and maximum will be 30 days. If auto-rollout is
   * enabled, default value and maximum will be 6 days.
   * </pre>
   *
   * <code>.google.protobuf.Duration experiment_length = 11;</code>
   *
   * @return The experimentLength.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getExperimentLength() {
    return experimentLength_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : experimentLength_;
  }
  /**
   *
   *
   * <pre>
   * Maximum number of days to run the experiment/rollout. If auto-rollout is
   * not enabled, default value and maximum will be 30 days. If auto-rollout is
   * enabled, default value and maximum will be 6 days.
   * </pre>
   *
   * <code>.google.protobuf.Duration experiment_length = 11;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getExperimentLengthOrBuilder() {
    return getExperimentLength();
  }

  public static final int VARIANTS_HISTORY_FIELD_NUMBER = 12;
  private java.util.List<com.google.cloud.dialogflow.cx.v3.VariantsHistory> variantsHistory_;
  /**
   *
   *
   * <pre>
   * The history of updates to the experiment variants.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.VariantsHistory>
      getVariantsHistoryList() {
    return variantsHistory_;
  }
  /**
   *
   *
   * <pre>
   * The history of updates to the experiment variants.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.VariantsHistoryOrBuilder>
      getVariantsHistoryOrBuilderList() {
    return variantsHistory_;
  }
  /**
   *
   *
   * <pre>
   * The history of updates to the experiment variants.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
   */
  @java.lang.Override
  public int getVariantsHistoryCount() {
    return variantsHistory_.size();
  }
  /**
   *
   *
   * <pre>
   * The history of updates to the experiment variants.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.VariantsHistory getVariantsHistory(int index) {
    return variantsHistory_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The history of updates to the experiment variants.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.VariantsHistoryOrBuilder getVariantsHistoryOrBuilder(
      int index) {
    return variantsHistory_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (state_
        != com.google.cloud.dialogflow.cx.v3.Experiment.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (definition_ != null) {
      output.writeMessage(5, getDefinition());
    }
    if (result_ != null) {
      output.writeMessage(6, getResult());
    }
    if (createTime_ != null) {
      output.writeMessage(7, getCreateTime());
    }
    if (startTime_ != null) {
      output.writeMessage(8, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(9, getEndTime());
    }
    if (lastUpdateTime_ != null) {
      output.writeMessage(10, getLastUpdateTime());
    }
    if (experimentLength_ != null) {
      output.writeMessage(11, getExperimentLength());
    }
    for (int i = 0; i < variantsHistory_.size(); i++) {
      output.writeMessage(12, variantsHistory_.get(i));
    }
    if (rolloutConfig_ != null) {
      output.writeMessage(14, getRolloutConfig());
    }
    if (rolloutState_ != null) {
      output.writeMessage(15, getRolloutState());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rolloutFailureReason_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, rolloutFailureReason_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (state_
        != com.google.cloud.dialogflow.cx.v3.Experiment.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (definition_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDefinition());
    }
    if (result_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getResult());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getEndTime());
    }
    if (lastUpdateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getLastUpdateTime());
    }
    if (experimentLength_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getExperimentLength());
    }
    for (int i = 0; i < variantsHistory_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, variantsHistory_.get(i));
    }
    if (rolloutConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getRolloutConfig());
    }
    if (rolloutState_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getRolloutState());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rolloutFailureReason_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, rolloutFailureReason_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Experiment)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.Experiment other =
        (com.google.cloud.dialogflow.cx.v3.Experiment) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (state_ != other.state_) return false;
    if (hasDefinition() != other.hasDefinition()) return false;
    if (hasDefinition()) {
      if (!getDefinition().equals(other.getDefinition())) return false;
    }
    if (hasRolloutConfig() != other.hasRolloutConfig()) return false;
    if (hasRolloutConfig()) {
      if (!getRolloutConfig().equals(other.getRolloutConfig())) return false;
    }
    if (hasRolloutState() != other.hasRolloutState()) return false;
    if (hasRolloutState()) {
      if (!getRolloutState().equals(other.getRolloutState())) return false;
    }
    if (!getRolloutFailureReason().equals(other.getRolloutFailureReason())) return false;
    if (hasResult() != other.hasResult()) return false;
    if (hasResult()) {
      if (!getResult().equals(other.getResult())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasLastUpdateTime() != other.hasLastUpdateTime()) return false;
    if (hasLastUpdateTime()) {
      if (!getLastUpdateTime().equals(other.getLastUpdateTime())) return false;
    }
    if (hasExperimentLength() != other.hasExperimentLength()) return false;
    if (hasExperimentLength()) {
      if (!getExperimentLength().equals(other.getExperimentLength())) return false;
    }
    if (!getVariantsHistoryList().equals(other.getVariantsHistoryList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasDefinition()) {
      hash = (37 * hash) + DEFINITION_FIELD_NUMBER;
      hash = (53 * hash) + getDefinition().hashCode();
    }
    if (hasRolloutConfig()) {
      hash = (37 * hash) + ROLLOUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRolloutConfig().hashCode();
    }
    if (hasRolloutState()) {
      hash = (37 * hash) + ROLLOUT_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getRolloutState().hashCode();
    }
    hash = (37 * hash) + ROLLOUT_FAILURE_REASON_FIELD_NUMBER;
    hash = (53 * hash) + getRolloutFailureReason().hashCode();
    if (hasResult()) {
      hash = (37 * hash) + RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getResult().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasLastUpdateTime()) {
      hash = (37 * hash) + LAST_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastUpdateTime().hashCode();
    }
    if (hasExperimentLength()) {
      hash = (37 * hash) + EXPERIMENT_LENGTH_FIELD_NUMBER;
      hash = (53 * hash) + getExperimentLength().hashCode();
    }
    if (getVariantsHistoryCount() > 0) {
      hash = (37 * hash) + VARIANTS_HISTORY_FIELD_NUMBER;
      hash = (53 * hash) + getVariantsHistoryList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.Experiment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Experiment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Experiment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Experiment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Experiment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Experiment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Experiment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Experiment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Experiment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Experiment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Experiment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Experiment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.Experiment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents an experiment in an environment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Experiment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Experiment)
      com.google.cloud.dialogflow.cx.v3.ExperimentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Experiment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Experiment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Experiment.class,
              com.google.cloud.dialogflow.cx.v3.Experiment.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.Experiment.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      description_ = "";

      state_ = 0;

      if (definitionBuilder_ == null) {
        definition_ = null;
      } else {
        definition_ = null;
        definitionBuilder_ = null;
      }
      if (rolloutConfigBuilder_ == null) {
        rolloutConfig_ = null;
      } else {
        rolloutConfig_ = null;
        rolloutConfigBuilder_ = null;
      }
      if (rolloutStateBuilder_ == null) {
        rolloutState_ = null;
      } else {
        rolloutState_ = null;
        rolloutStateBuilder_ = null;
      }
      rolloutFailureReason_ = "";

      if (resultBuilder_ == null) {
        result_ = null;
      } else {
        result_ = null;
        resultBuilder_ = null;
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTime_ = null;
      } else {
        lastUpdateTime_ = null;
        lastUpdateTimeBuilder_ = null;
      }
      if (experimentLengthBuilder_ == null) {
        experimentLength_ = null;
      } else {
        experimentLength_ = null;
        experimentLengthBuilder_ = null;
      }
      if (variantsHistoryBuilder_ == null) {
        variantsHistory_ = java.util.Collections.emptyList();
      } else {
        variantsHistory_ = null;
        variantsHistoryBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Experiment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Experiment getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.Experiment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Experiment build() {
      com.google.cloud.dialogflow.cx.v3.Experiment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Experiment buildPartial() {
      com.google.cloud.dialogflow.cx.v3.Experiment result =
          new com.google.cloud.dialogflow.cx.v3.Experiment(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      result.description_ = description_;
      result.state_ = state_;
      if (definitionBuilder_ == null) {
        result.definition_ = definition_;
      } else {
        result.definition_ = definitionBuilder_.build();
      }
      if (rolloutConfigBuilder_ == null) {
        result.rolloutConfig_ = rolloutConfig_;
      } else {
        result.rolloutConfig_ = rolloutConfigBuilder_.build();
      }
      if (rolloutStateBuilder_ == null) {
        result.rolloutState_ = rolloutState_;
      } else {
        result.rolloutState_ = rolloutStateBuilder_.build();
      }
      result.rolloutFailureReason_ = rolloutFailureReason_;
      if (resultBuilder_ == null) {
        result.result_ = result_;
      } else {
        result.result_ = resultBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      if (lastUpdateTimeBuilder_ == null) {
        result.lastUpdateTime_ = lastUpdateTime_;
      } else {
        result.lastUpdateTime_ = lastUpdateTimeBuilder_.build();
      }
      if (experimentLengthBuilder_ == null) {
        result.experimentLength_ = experimentLength_;
      } else {
        result.experimentLength_ = experimentLengthBuilder_.build();
      }
      if (variantsHistoryBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          variantsHistory_ = java.util.Collections.unmodifiableList(variantsHistory_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.variantsHistory_ = variantsHistory_;
      } else {
        result.variantsHistory_ = variantsHistoryBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.Experiment) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.Experiment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.Experiment other) {
      if (other == com.google.cloud.dialogflow.cx.v3.Experiment.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasDefinition()) {
        mergeDefinition(other.getDefinition());
      }
      if (other.hasRolloutConfig()) {
        mergeRolloutConfig(other.getRolloutConfig());
      }
      if (other.hasRolloutState()) {
        mergeRolloutState(other.getRolloutState());
      }
      if (!other.getRolloutFailureReason().isEmpty()) {
        rolloutFailureReason_ = other.rolloutFailureReason_;
        onChanged();
      }
      if (other.hasResult()) {
        mergeResult(other.getResult());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasLastUpdateTime()) {
        mergeLastUpdateTime(other.getLastUpdateTime());
      }
      if (other.hasExperimentLength()) {
        mergeExperimentLength(other.getExperimentLength());
      }
      if (variantsHistoryBuilder_ == null) {
        if (!other.variantsHistory_.isEmpty()) {
          if (variantsHistory_.isEmpty()) {
            variantsHistory_ = other.variantsHistory_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureVariantsHistoryIsMutable();
            variantsHistory_.addAll(other.variantsHistory_);
          }
          onChanged();
        }
      } else {
        if (!other.variantsHistory_.isEmpty()) {
          if (variantsHistoryBuilder_.isEmpty()) {
            variantsHistoryBuilder_.dispose();
            variantsHistoryBuilder_ = null;
            variantsHistory_ = other.variantsHistory_;
            bitField0_ = (bitField0_ & ~0x00000001);
            variantsHistoryBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVariantsHistoryFieldBuilder()
                    : null;
          } else {
            variantsHistoryBuilder_.addAllMessages(other.variantsHistory_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 32:
              {
                state_ = input.readEnum();

                break;
              } // case 32
            case 42:
              {
                input.readMessage(getDefinitionFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                input.readMessage(getResultFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 66:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            case 74:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 74
            case 82:
              {
                input.readMessage(getLastUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getExperimentLengthFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 90
            case 98:
              {
                com.google.cloud.dialogflow.cx.v3.VariantsHistory m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.VariantsHistory.parser(),
                        extensionRegistry);
                if (variantsHistoryBuilder_ == null) {
                  ensureVariantsHistoryIsMutable();
                  variantsHistory_.add(m);
                } else {
                  variantsHistoryBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 114:
              {
                input.readMessage(getRolloutConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 114
            case 122:
              {
                input.readMessage(getRolloutStateFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 122
            case 130:
              {
                rolloutFailureReason_ = input.readStringRequireUtf8();

                break;
              } // case 130
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the experiment.
     * Format: projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/environments/&lt;Environment ID&gt;/experiments/&lt;Experiment ID&gt;..
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the experiment.
     * Format: projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/environments/&lt;Environment ID&gt;/experiments/&lt;Experiment ID&gt;..
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the experiment.
     * Format: projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/environments/&lt;Environment ID&gt;/experiments/&lt;Experiment ID&gt;..
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the experiment.
     * Format: projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/environments/&lt;Environment ID&gt;/experiments/&lt;Experiment ID&gt;..
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the experiment.
     * Format: projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/environments/&lt;Environment ID&gt;/experiments/&lt;Experiment ID&gt;..
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the experiment (unique in an environment). Limit
     * of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the experiment (unique in an environment). Limit
     * of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the experiment (unique in an environment). Limit
     * of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the experiment (unique in an environment). Limit
     * of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the experiment (unique in an environment). Limit
     * of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The human-readable description of the experiment.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human-readable description of the experiment.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human-readable description of the experiment.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human-readable description of the experiment.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human-readable description of the experiment.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The current state of the experiment.
     * Transition triggered by Experiments.StartExperiment: DRAFT-&gt;RUNNING.
     * Transition triggered by Experiments.CancelExperiment: DRAFT-&gt;DONE or
     * RUNNING-&gt;DONE.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.State state = 4;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The current state of the experiment.
     * Transition triggered by Experiments.StartExperiment: DRAFT-&gt;RUNNING.
     * Transition triggered by Experiments.CancelExperiment: DRAFT-&gt;DONE or
     * RUNNING-&gt;DONE.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.State state = 4;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current state of the experiment.
     * Transition triggered by Experiments.StartExperiment: DRAFT-&gt;RUNNING.
     * Transition triggered by Experiments.CancelExperiment: DRAFT-&gt;DONE or
     * RUNNING-&gt;DONE.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.State state = 4;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Experiment.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.cx.v3.Experiment.State result =
          com.google.cloud.dialogflow.cx.v3.Experiment.State.valueOf(state_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3.Experiment.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The current state of the experiment.
     * Transition triggered by Experiments.StartExperiment: DRAFT-&gt;RUNNING.
     * Transition triggered by Experiments.CancelExperiment: DRAFT-&gt;DONE or
     * RUNNING-&gt;DONE.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.State state = 4;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.dialogflow.cx.v3.Experiment.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current state of the experiment.
     * Transition triggered by Experiments.StartExperiment: DRAFT-&gt;RUNNING.
     * Transition triggered by Experiments.CancelExperiment: DRAFT-&gt;DONE or
     * RUNNING-&gt;DONE.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.State state = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.Experiment.Definition definition_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Experiment.Definition,
            com.google.cloud.dialogflow.cx.v3.Experiment.Definition.Builder,
            com.google.cloud.dialogflow.cx.v3.Experiment.DefinitionOrBuilder>
        definitionBuilder_;
    /**
     *
     *
     * <pre>
     * The definition of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Definition definition = 5;</code>
     *
     * @return Whether the definition field is set.
     */
    public boolean hasDefinition() {
      return definitionBuilder_ != null || definition_ != null;
    }
    /**
     *
     *
     * <pre>
     * The definition of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Definition definition = 5;</code>
     *
     * @return The definition.
     */
    public com.google.cloud.dialogflow.cx.v3.Experiment.Definition getDefinition() {
      if (definitionBuilder_ == null) {
        return definition_ == null
            ? com.google.cloud.dialogflow.cx.v3.Experiment.Definition.getDefaultInstance()
            : definition_;
      } else {
        return definitionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The definition of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Definition definition = 5;</code>
     */
    public Builder setDefinition(com.google.cloud.dialogflow.cx.v3.Experiment.Definition value) {
      if (definitionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        definition_ = value;
        onChanged();
      } else {
        definitionBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The definition of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Definition definition = 5;</code>
     */
    public Builder setDefinition(
        com.google.cloud.dialogflow.cx.v3.Experiment.Definition.Builder builderForValue) {
      if (definitionBuilder_ == null) {
        definition_ = builderForValue.build();
        onChanged();
      } else {
        definitionBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The definition of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Definition definition = 5;</code>
     */
    public Builder mergeDefinition(com.google.cloud.dialogflow.cx.v3.Experiment.Definition value) {
      if (definitionBuilder_ == null) {
        if (definition_ != null) {
          definition_ =
              com.google.cloud.dialogflow.cx.v3.Experiment.Definition.newBuilder(definition_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          definition_ = value;
        }
        onChanged();
      } else {
        definitionBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The definition of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Definition definition = 5;</code>
     */
    public Builder clearDefinition() {
      if (definitionBuilder_ == null) {
        definition_ = null;
        onChanged();
      } else {
        definition_ = null;
        definitionBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The definition of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Definition definition = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.Experiment.Definition.Builder getDefinitionBuilder() {

      onChanged();
      return getDefinitionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The definition of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Definition definition = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.Experiment.DefinitionOrBuilder
        getDefinitionOrBuilder() {
      if (definitionBuilder_ != null) {
        return definitionBuilder_.getMessageOrBuilder();
      } else {
        return definition_ == null
            ? com.google.cloud.dialogflow.cx.v3.Experiment.Definition.getDefaultInstance()
            : definition_;
      }
    }
    /**
     *
     *
     * <pre>
     * The definition of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Definition definition = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Experiment.Definition,
            com.google.cloud.dialogflow.cx.v3.Experiment.Definition.Builder,
            com.google.cloud.dialogflow.cx.v3.Experiment.DefinitionOrBuilder>
        getDefinitionFieldBuilder() {
      if (definitionBuilder_ == null) {
        definitionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Experiment.Definition,
                com.google.cloud.dialogflow.cx.v3.Experiment.Definition.Builder,
                com.google.cloud.dialogflow.cx.v3.Experiment.DefinitionOrBuilder>(
                getDefinition(), getParentForChildren(), isClean());
        definition_ = null;
      }
      return definitionBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.RolloutConfig rolloutConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.RolloutConfig,
            com.google.cloud.dialogflow.cx.v3.RolloutConfig.Builder,
            com.google.cloud.dialogflow.cx.v3.RolloutConfigOrBuilder>
        rolloutConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The configuration for auto rollout. If set, there should be exactly two
     * variants in the experiment (control variant being the default version of
     * the flow), the traffic allocation for the non-control variant will
     * gradually increase to 100% when conditions are met, and eventually
     * replace the control variant to become the default version of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutConfig rollout_config = 14;</code>
     *
     * @return Whether the rolloutConfig field is set.
     */
    public boolean hasRolloutConfig() {
      return rolloutConfigBuilder_ != null || rolloutConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * The configuration for auto rollout. If set, there should be exactly two
     * variants in the experiment (control variant being the default version of
     * the flow), the traffic allocation for the non-control variant will
     * gradually increase to 100% when conditions are met, and eventually
     * replace the control variant to become the default version of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutConfig rollout_config = 14;</code>
     *
     * @return The rolloutConfig.
     */
    public com.google.cloud.dialogflow.cx.v3.RolloutConfig getRolloutConfig() {
      if (rolloutConfigBuilder_ == null) {
        return rolloutConfig_ == null
            ? com.google.cloud.dialogflow.cx.v3.RolloutConfig.getDefaultInstance()
            : rolloutConfig_;
      } else {
        return rolloutConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for auto rollout. If set, there should be exactly two
     * variants in the experiment (control variant being the default version of
     * the flow), the traffic allocation for the non-control variant will
     * gradually increase to 100% when conditions are met, and eventually
     * replace the control variant to become the default version of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutConfig rollout_config = 14;</code>
     */
    public Builder setRolloutConfig(com.google.cloud.dialogflow.cx.v3.RolloutConfig value) {
      if (rolloutConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rolloutConfig_ = value;
        onChanged();
      } else {
        rolloutConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for auto rollout. If set, there should be exactly two
     * variants in the experiment (control variant being the default version of
     * the flow), the traffic allocation for the non-control variant will
     * gradually increase to 100% when conditions are met, and eventually
     * replace the control variant to become the default version of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutConfig rollout_config = 14;</code>
     */
    public Builder setRolloutConfig(
        com.google.cloud.dialogflow.cx.v3.RolloutConfig.Builder builderForValue) {
      if (rolloutConfigBuilder_ == null) {
        rolloutConfig_ = builderForValue.build();
        onChanged();
      } else {
        rolloutConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for auto rollout. If set, there should be exactly two
     * variants in the experiment (control variant being the default version of
     * the flow), the traffic allocation for the non-control variant will
     * gradually increase to 100% when conditions are met, and eventually
     * replace the control variant to become the default version of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutConfig rollout_config = 14;</code>
     */
    public Builder mergeRolloutConfig(com.google.cloud.dialogflow.cx.v3.RolloutConfig value) {
      if (rolloutConfigBuilder_ == null) {
        if (rolloutConfig_ != null) {
          rolloutConfig_ =
              com.google.cloud.dialogflow.cx.v3.RolloutConfig.newBuilder(rolloutConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          rolloutConfig_ = value;
        }
        onChanged();
      } else {
        rolloutConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for auto rollout. If set, there should be exactly two
     * variants in the experiment (control variant being the default version of
     * the flow), the traffic allocation for the non-control variant will
     * gradually increase to 100% when conditions are met, and eventually
     * replace the control variant to become the default version of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutConfig rollout_config = 14;</code>
     */
    public Builder clearRolloutConfig() {
      if (rolloutConfigBuilder_ == null) {
        rolloutConfig_ = null;
        onChanged();
      } else {
        rolloutConfig_ = null;
        rolloutConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for auto rollout. If set, there should be exactly two
     * variants in the experiment (control variant being the default version of
     * the flow), the traffic allocation for the non-control variant will
     * gradually increase to 100% when conditions are met, and eventually
     * replace the control variant to become the default version of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutConfig rollout_config = 14;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.RolloutConfig.Builder getRolloutConfigBuilder() {

      onChanged();
      return getRolloutConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The configuration for auto rollout. If set, there should be exactly two
     * variants in the experiment (control variant being the default version of
     * the flow), the traffic allocation for the non-control variant will
     * gradually increase to 100% when conditions are met, and eventually
     * replace the control variant to become the default version of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutConfig rollout_config = 14;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.RolloutConfigOrBuilder getRolloutConfigOrBuilder() {
      if (rolloutConfigBuilder_ != null) {
        return rolloutConfigBuilder_.getMessageOrBuilder();
      } else {
        return rolloutConfig_ == null
            ? com.google.cloud.dialogflow.cx.v3.RolloutConfig.getDefaultInstance()
            : rolloutConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for auto rollout. If set, there should be exactly two
     * variants in the experiment (control variant being the default version of
     * the flow), the traffic allocation for the non-control variant will
     * gradually increase to 100% when conditions are met, and eventually
     * replace the control variant to become the default version of the flow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutConfig rollout_config = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.RolloutConfig,
            com.google.cloud.dialogflow.cx.v3.RolloutConfig.Builder,
            com.google.cloud.dialogflow.cx.v3.RolloutConfigOrBuilder>
        getRolloutConfigFieldBuilder() {
      if (rolloutConfigBuilder_ == null) {
        rolloutConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.RolloutConfig,
                com.google.cloud.dialogflow.cx.v3.RolloutConfig.Builder,
                com.google.cloud.dialogflow.cx.v3.RolloutConfigOrBuilder>(
                getRolloutConfig(), getParentForChildren(), isClean());
        rolloutConfig_ = null;
      }
      return rolloutConfigBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.RolloutState rolloutState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.RolloutState,
            com.google.cloud.dialogflow.cx.v3.RolloutState.Builder,
            com.google.cloud.dialogflow.cx.v3.RolloutStateOrBuilder>
        rolloutStateBuilder_;
    /**
     *
     *
     * <pre>
     * State of the auto rollout process.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutState rollout_state = 15;</code>
     *
     * @return Whether the rolloutState field is set.
     */
    public boolean hasRolloutState() {
      return rolloutStateBuilder_ != null || rolloutState_ != null;
    }
    /**
     *
     *
     * <pre>
     * State of the auto rollout process.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutState rollout_state = 15;</code>
     *
     * @return The rolloutState.
     */
    public com.google.cloud.dialogflow.cx.v3.RolloutState getRolloutState() {
      if (rolloutStateBuilder_ == null) {
        return rolloutState_ == null
            ? com.google.cloud.dialogflow.cx.v3.RolloutState.getDefaultInstance()
            : rolloutState_;
      } else {
        return rolloutStateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * State of the auto rollout process.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutState rollout_state = 15;</code>
     */
    public Builder setRolloutState(com.google.cloud.dialogflow.cx.v3.RolloutState value) {
      if (rolloutStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rolloutState_ = value;
        onChanged();
      } else {
        rolloutStateBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * State of the auto rollout process.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutState rollout_state = 15;</code>
     */
    public Builder setRolloutState(
        com.google.cloud.dialogflow.cx.v3.RolloutState.Builder builderForValue) {
      if (rolloutStateBuilder_ == null) {
        rolloutState_ = builderForValue.build();
        onChanged();
      } else {
        rolloutStateBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * State of the auto rollout process.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutState rollout_state = 15;</code>
     */
    public Builder mergeRolloutState(com.google.cloud.dialogflow.cx.v3.RolloutState value) {
      if (rolloutStateBuilder_ == null) {
        if (rolloutState_ != null) {
          rolloutState_ =
              com.google.cloud.dialogflow.cx.v3.RolloutState.newBuilder(rolloutState_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          rolloutState_ = value;
        }
        onChanged();
      } else {
        rolloutStateBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * State of the auto rollout process.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutState rollout_state = 15;</code>
     */
    public Builder clearRolloutState() {
      if (rolloutStateBuilder_ == null) {
        rolloutState_ = null;
        onChanged();
      } else {
        rolloutState_ = null;
        rolloutStateBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * State of the auto rollout process.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutState rollout_state = 15;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.RolloutState.Builder getRolloutStateBuilder() {

      onChanged();
      return getRolloutStateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * State of the auto rollout process.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutState rollout_state = 15;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.RolloutStateOrBuilder getRolloutStateOrBuilder() {
      if (rolloutStateBuilder_ != null) {
        return rolloutStateBuilder_.getMessageOrBuilder();
      } else {
        return rolloutState_ == null
            ? com.google.cloud.dialogflow.cx.v3.RolloutState.getDefaultInstance()
            : rolloutState_;
      }
    }
    /**
     *
     *
     * <pre>
     * State of the auto rollout process.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.RolloutState rollout_state = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.RolloutState,
            com.google.cloud.dialogflow.cx.v3.RolloutState.Builder,
            com.google.cloud.dialogflow.cx.v3.RolloutStateOrBuilder>
        getRolloutStateFieldBuilder() {
      if (rolloutStateBuilder_ == null) {
        rolloutStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.RolloutState,
                com.google.cloud.dialogflow.cx.v3.RolloutState.Builder,
                com.google.cloud.dialogflow.cx.v3.RolloutStateOrBuilder>(
                getRolloutState(), getParentForChildren(), isClean());
        rolloutState_ = null;
      }
      return rolloutStateBuilder_;
    }

    private java.lang.Object rolloutFailureReason_ = "";
    /**
     *
     *
     * <pre>
     * The reason why rollout has failed. Should only be set when state is
     * ROLLOUT_FAILED.
     * </pre>
     *
     * <code>string rollout_failure_reason = 16;</code>
     *
     * @return The rolloutFailureReason.
     */
    public java.lang.String getRolloutFailureReason() {
      java.lang.Object ref = rolloutFailureReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rolloutFailureReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The reason why rollout has failed. Should only be set when state is
     * ROLLOUT_FAILED.
     * </pre>
     *
     * <code>string rollout_failure_reason = 16;</code>
     *
     * @return The bytes for rolloutFailureReason.
     */
    public com.google.protobuf.ByteString getRolloutFailureReasonBytes() {
      java.lang.Object ref = rolloutFailureReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rolloutFailureReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The reason why rollout has failed. Should only be set when state is
     * ROLLOUT_FAILED.
     * </pre>
     *
     * <code>string rollout_failure_reason = 16;</code>
     *
     * @param value The rolloutFailureReason to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutFailureReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      rolloutFailureReason_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The reason why rollout has failed. Should only be set when state is
     * ROLLOUT_FAILED.
     * </pre>
     *
     * <code>string rollout_failure_reason = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRolloutFailureReason() {

      rolloutFailureReason_ = getDefaultInstance().getRolloutFailureReason();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The reason why rollout has failed. Should only be set when state is
     * ROLLOUT_FAILED.
     * </pre>
     *
     * <code>string rollout_failure_reason = 16;</code>
     *
     * @param value The bytes for rolloutFailureReason to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutFailureReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      rolloutFailureReason_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.Experiment.Result result_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Experiment.Result,
            com.google.cloud.dialogflow.cx.v3.Experiment.Result.Builder,
            com.google.cloud.dialogflow.cx.v3.Experiment.ResultOrBuilder>
        resultBuilder_;
    /**
     *
     *
     * <pre>
     * Inference result of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result result = 6;</code>
     *
     * @return Whether the result field is set.
     */
    public boolean hasResult() {
      return resultBuilder_ != null || result_ != null;
    }
    /**
     *
     *
     * <pre>
     * Inference result of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result result = 6;</code>
     *
     * @return The result.
     */
    public com.google.cloud.dialogflow.cx.v3.Experiment.Result getResult() {
      if (resultBuilder_ == null) {
        return result_ == null
            ? com.google.cloud.dialogflow.cx.v3.Experiment.Result.getDefaultInstance()
            : result_;
      } else {
        return resultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Inference result of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result result = 6;</code>
     */
    public Builder setResult(com.google.cloud.dialogflow.cx.v3.Experiment.Result value) {
      if (resultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        resultBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Inference result of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result result = 6;</code>
     */
    public Builder setResult(
        com.google.cloud.dialogflow.cx.v3.Experiment.Result.Builder builderForValue) {
      if (resultBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        resultBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Inference result of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result result = 6;</code>
     */
    public Builder mergeResult(com.google.cloud.dialogflow.cx.v3.Experiment.Result value) {
      if (resultBuilder_ == null) {
        if (result_ != null) {
          result_ =
              com.google.cloud.dialogflow.cx.v3.Experiment.Result.newBuilder(result_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        resultBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Inference result of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result result = 6;</code>
     */
    public Builder clearResult() {
      if (resultBuilder_ == null) {
        result_ = null;
        onChanged();
      } else {
        result_ = null;
        resultBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Inference result of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result result = 6;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.Experiment.Result.Builder getResultBuilder() {

      onChanged();
      return getResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Inference result of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result result = 6;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.Experiment.ResultOrBuilder getResultOrBuilder() {
      if (resultBuilder_ != null) {
        return resultBuilder_.getMessageOrBuilder();
      } else {
        return result_ == null
            ? com.google.cloud.dialogflow.cx.v3.Experiment.Result.getDefaultInstance()
            : result_;
      }
    }
    /**
     *
     *
     * <pre>
     * Inference result of the experiment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Experiment.Result result = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Experiment.Result,
            com.google.cloud.dialogflow.cx.v3.Experiment.Result.Builder,
            com.google.cloud.dialogflow.cx.v3.Experiment.ResultOrBuilder>
        getResultFieldBuilder() {
      if (resultBuilder_ == null) {
        resultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Experiment.Result,
                com.google.cloud.dialogflow.cx.v3.Experiment.Result.Builder,
                com.google.cloud.dialogflow.cx.v3.Experiment.ResultOrBuilder>(
                getResult(), getParentForChildren(), isClean());
        result_ = null;
      }
      return resultBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Creation time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Creation time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Creation time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Creation time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Creation time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Creation time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Creation time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Creation time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Creation time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Start time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Start time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Start time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8;</code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Start time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Start time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * End time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * End time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * End time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9;</code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * End time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * End time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastUpdateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Last update time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 10;</code>
     *
     * @return Whether the lastUpdateTime field is set.
     */
    public boolean hasLastUpdateTime() {
      return lastUpdateTimeBuilder_ != null || lastUpdateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Last update time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 10;</code>
     *
     * @return The lastUpdateTime.
     */
    public com.google.protobuf.Timestamp getLastUpdateTime() {
      if (lastUpdateTimeBuilder_ == null) {
        return lastUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastUpdateTime_;
      } else {
        return lastUpdateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Last update time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 10;</code>
     */
    public Builder setLastUpdateTime(com.google.protobuf.Timestamp value) {
      if (lastUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastUpdateTime_ = value;
        onChanged();
      } else {
        lastUpdateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Last update time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 10;</code>
     */
    public Builder setLastUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTime_ = builderForValue.build();
        onChanged();
      } else {
        lastUpdateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Last update time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 10;</code>
     */
    public Builder mergeLastUpdateTime(com.google.protobuf.Timestamp value) {
      if (lastUpdateTimeBuilder_ == null) {
        if (lastUpdateTime_ != null) {
          lastUpdateTime_ =
              com.google.protobuf.Timestamp.newBuilder(lastUpdateTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          lastUpdateTime_ = value;
        }
        onChanged();
      } else {
        lastUpdateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Last update time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 10;</code>
     */
    public Builder clearLastUpdateTime() {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTime_ = null;
        onChanged();
      } else {
        lastUpdateTime_ = null;
        lastUpdateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Last update time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getLastUpdateTimeBuilder() {

      onChanged();
      return getLastUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Last update time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 10;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
      if (lastUpdateTimeBuilder_ != null) {
        return lastUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastUpdateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Last update time of this experiment.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_update_time = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastUpdateTimeFieldBuilder() {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastUpdateTime(), getParentForChildren(), isClean());
        lastUpdateTime_ = null;
      }
      return lastUpdateTimeBuilder_;
    }

    private com.google.protobuf.Duration experimentLength_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        experimentLengthBuilder_;
    /**
     *
     *
     * <pre>
     * Maximum number of days to run the experiment/rollout. If auto-rollout is
     * not enabled, default value and maximum will be 30 days. If auto-rollout is
     * enabled, default value and maximum will be 6 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration experiment_length = 11;</code>
     *
     * @return Whether the experimentLength field is set.
     */
    public boolean hasExperimentLength() {
      return experimentLengthBuilder_ != null || experimentLength_ != null;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of days to run the experiment/rollout. If auto-rollout is
     * not enabled, default value and maximum will be 30 days. If auto-rollout is
     * enabled, default value and maximum will be 6 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration experiment_length = 11;</code>
     *
     * @return The experimentLength.
     */
    public com.google.protobuf.Duration getExperimentLength() {
      if (experimentLengthBuilder_ == null) {
        return experimentLength_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : experimentLength_;
      } else {
        return experimentLengthBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Maximum number of days to run the experiment/rollout. If auto-rollout is
     * not enabled, default value and maximum will be 30 days. If auto-rollout is
     * enabled, default value and maximum will be 6 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration experiment_length = 11;</code>
     */
    public Builder setExperimentLength(com.google.protobuf.Duration value) {
      if (experimentLengthBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        experimentLength_ = value;
        onChanged();
      } else {
        experimentLengthBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of days to run the experiment/rollout. If auto-rollout is
     * not enabled, default value and maximum will be 30 days. If auto-rollout is
     * enabled, default value and maximum will be 6 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration experiment_length = 11;</code>
     */
    public Builder setExperimentLength(com.google.protobuf.Duration.Builder builderForValue) {
      if (experimentLengthBuilder_ == null) {
        experimentLength_ = builderForValue.build();
        onChanged();
      } else {
        experimentLengthBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of days to run the experiment/rollout. If auto-rollout is
     * not enabled, default value and maximum will be 30 days. If auto-rollout is
     * enabled, default value and maximum will be 6 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration experiment_length = 11;</code>
     */
    public Builder mergeExperimentLength(com.google.protobuf.Duration value) {
      if (experimentLengthBuilder_ == null) {
        if (experimentLength_ != null) {
          experimentLength_ =
              com.google.protobuf.Duration.newBuilder(experimentLength_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          experimentLength_ = value;
        }
        onChanged();
      } else {
        experimentLengthBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of days to run the experiment/rollout. If auto-rollout is
     * not enabled, default value and maximum will be 30 days. If auto-rollout is
     * enabled, default value and maximum will be 6 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration experiment_length = 11;</code>
     */
    public Builder clearExperimentLength() {
      if (experimentLengthBuilder_ == null) {
        experimentLength_ = null;
        onChanged();
      } else {
        experimentLength_ = null;
        experimentLengthBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of days to run the experiment/rollout. If auto-rollout is
     * not enabled, default value and maximum will be 30 days. If auto-rollout is
     * enabled, default value and maximum will be 6 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration experiment_length = 11;</code>
     */
    public com.google.protobuf.Duration.Builder getExperimentLengthBuilder() {

      onChanged();
      return getExperimentLengthFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Maximum number of days to run the experiment/rollout. If auto-rollout is
     * not enabled, default value and maximum will be 30 days. If auto-rollout is
     * enabled, default value and maximum will be 6 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration experiment_length = 11;</code>
     */
    public com.google.protobuf.DurationOrBuilder getExperimentLengthOrBuilder() {
      if (experimentLengthBuilder_ != null) {
        return experimentLengthBuilder_.getMessageOrBuilder();
      } else {
        return experimentLength_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : experimentLength_;
      }
    }
    /**
     *
     *
     * <pre>
     * Maximum number of days to run the experiment/rollout. If auto-rollout is
     * not enabled, default value and maximum will be 30 days. If auto-rollout is
     * enabled, default value and maximum will be 6 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration experiment_length = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getExperimentLengthFieldBuilder() {
      if (experimentLengthBuilder_ == null) {
        experimentLengthBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getExperimentLength(), getParentForChildren(), isClean());
        experimentLength_ = null;
      }
      return experimentLengthBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3.VariantsHistory> variantsHistory_ =
        java.util.Collections.emptyList();

    private void ensureVariantsHistoryIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        variantsHistory_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.VariantsHistory>(
                variantsHistory_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.VariantsHistory,
            com.google.cloud.dialogflow.cx.v3.VariantsHistory.Builder,
            com.google.cloud.dialogflow.cx.v3.VariantsHistoryOrBuilder>
        variantsHistoryBuilder_;

    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.VariantsHistory>
        getVariantsHistoryList() {
      if (variantsHistoryBuilder_ == null) {
        return java.util.Collections.unmodifiableList(variantsHistory_);
      } else {
        return variantsHistoryBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public int getVariantsHistoryCount() {
      if (variantsHistoryBuilder_ == null) {
        return variantsHistory_.size();
      } else {
        return variantsHistoryBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.VariantsHistory getVariantsHistory(int index) {
      if (variantsHistoryBuilder_ == null) {
        return variantsHistory_.get(index);
      } else {
        return variantsHistoryBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public Builder setVariantsHistory(
        int index, com.google.cloud.dialogflow.cx.v3.VariantsHistory value) {
      if (variantsHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVariantsHistoryIsMutable();
        variantsHistory_.set(index, value);
        onChanged();
      } else {
        variantsHistoryBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public Builder setVariantsHistory(
        int index, com.google.cloud.dialogflow.cx.v3.VariantsHistory.Builder builderForValue) {
      if (variantsHistoryBuilder_ == null) {
        ensureVariantsHistoryIsMutable();
        variantsHistory_.set(index, builderForValue.build());
        onChanged();
      } else {
        variantsHistoryBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public Builder addVariantsHistory(com.google.cloud.dialogflow.cx.v3.VariantsHistory value) {
      if (variantsHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVariantsHistoryIsMutable();
        variantsHistory_.add(value);
        onChanged();
      } else {
        variantsHistoryBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public Builder addVariantsHistory(
        int index, com.google.cloud.dialogflow.cx.v3.VariantsHistory value) {
      if (variantsHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVariantsHistoryIsMutable();
        variantsHistory_.add(index, value);
        onChanged();
      } else {
        variantsHistoryBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public Builder addVariantsHistory(
        com.google.cloud.dialogflow.cx.v3.VariantsHistory.Builder builderForValue) {
      if (variantsHistoryBuilder_ == null) {
        ensureVariantsHistoryIsMutable();
        variantsHistory_.add(builderForValue.build());
        onChanged();
      } else {
        variantsHistoryBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public Builder addVariantsHistory(
        int index, com.google.cloud.dialogflow.cx.v3.VariantsHistory.Builder builderForValue) {
      if (variantsHistoryBuilder_ == null) {
        ensureVariantsHistoryIsMutable();
        variantsHistory_.add(index, builderForValue.build());
        onChanged();
      } else {
        variantsHistoryBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public Builder addAllVariantsHistory(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.VariantsHistory> values) {
      if (variantsHistoryBuilder_ == null) {
        ensureVariantsHistoryIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, variantsHistory_);
        onChanged();
      } else {
        variantsHistoryBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public Builder clearVariantsHistory() {
      if (variantsHistoryBuilder_ == null) {
        variantsHistory_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        variantsHistoryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public Builder removeVariantsHistory(int index) {
      if (variantsHistoryBuilder_ == null) {
        ensureVariantsHistoryIsMutable();
        variantsHistory_.remove(index);
        onChanged();
      } else {
        variantsHistoryBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.VariantsHistory.Builder getVariantsHistoryBuilder(
        int index) {
      return getVariantsHistoryFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.VariantsHistoryOrBuilder getVariantsHistoryOrBuilder(
        int index) {
      if (variantsHistoryBuilder_ == null) {
        return variantsHistory_.get(index);
      } else {
        return variantsHistoryBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.VariantsHistoryOrBuilder>
        getVariantsHistoryOrBuilderList() {
      if (variantsHistoryBuilder_ != null) {
        return variantsHistoryBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(variantsHistory_);
      }
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.VariantsHistory.Builder addVariantsHistoryBuilder() {
      return getVariantsHistoryFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3.VariantsHistory.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.VariantsHistory.Builder addVariantsHistoryBuilder(
        int index) {
      return getVariantsHistoryFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.cx.v3.VariantsHistory.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The history of updates to the experiment variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VariantsHistory variants_history = 12;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.VariantsHistory.Builder>
        getVariantsHistoryBuilderList() {
      return getVariantsHistoryFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.VariantsHistory,
            com.google.cloud.dialogflow.cx.v3.VariantsHistory.Builder,
            com.google.cloud.dialogflow.cx.v3.VariantsHistoryOrBuilder>
        getVariantsHistoryFieldBuilder() {
      if (variantsHistoryBuilder_ == null) {
        variantsHistoryBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.VariantsHistory,
                com.google.cloud.dialogflow.cx.v3.VariantsHistory.Builder,
                com.google.cloud.dialogflow.cx.v3.VariantsHistoryOrBuilder>(
                variantsHistory_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        variantsHistory_ = null;
      }
      return variantsHistoryBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Experiment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Experiment)
  private static final com.google.cloud.dialogflow.cx.v3.Experiment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Experiment();
  }

  public static com.google.cloud.dialogflow.cx.v3.Experiment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Experiment> PARSER =
      new com.google.protobuf.AbstractParser<Experiment>() {
        @java.lang.Override
        public Experiment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Experiment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Experiment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Experiment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
