/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/page.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * An event handler specifies an [event][google.cloud.dialogflow.cx.v3.EventHandler.event] that can be handled
 * during a session. When the specified event happens, the following actions are
 * taken in order:
 * *   If there is a
 * [`trigger_fulfillment`][google.cloud.dialogflow.cx.v3.EventHandler.trigger_fulfillment] associated with
 * the event, it will be called.
 * *   If there is a [`target_page`][google.cloud.dialogflow.cx.v3.EventHandler.target_page] associated
 * with the event, the session will transition into the specified page.
 * *   If there is a [`target_flow`][google.cloud.dialogflow.cx.v3.EventHandler.target_flow] associated
 * with the event, the session will transition into the specified flow.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.EventHandler}
 */
public final class EventHandler extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.EventHandler)
    EventHandlerOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EventHandler.newBuilder() to construct.
  private EventHandler(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EventHandler() {
    name_ = "";
    event_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EventHandler();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.PageProto
        .internal_static_google_cloud_dialogflow_cx_v3_EventHandler_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.PageProto
        .internal_static_google_cloud_dialogflow_cx_v3_EventHandler_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.EventHandler.class,
            com.google.cloud.dialogflow.cx.v3.EventHandler.Builder.class);
  }

  private int targetCase_ = 0;
  private java.lang.Object target_;

  public enum TargetCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TARGET_PAGE(2),
    TARGET_FLOW(3),
    TARGET_NOT_SET(0);
    private final int value;

    private TargetCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TargetCase valueOf(int value) {
      return forNumber(value);
    }

    public static TargetCase forNumber(int value) {
      switch (value) {
        case 2:
          return TARGET_PAGE;
        case 3:
          return TARGET_FLOW;
        case 0:
          return TARGET_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TargetCase getTargetCase() {
    return TargetCase.forNumber(targetCase_);
  }

  public static final int NAME_FIELD_NUMBER = 6;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The unique identifier of this event handler.
   * </pre>
   *
   * <code>string name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The unique identifier of this event handler.
   * </pre>
   *
   * <code>string name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVENT_FIELD_NUMBER = 4;
  private volatile java.lang.Object event_;
  /**
   *
   *
   * <pre>
   * Required. The name of the event to handle.
   * </pre>
   *
   * <code>string event = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The event.
   */
  @java.lang.Override
  public java.lang.String getEvent() {
    java.lang.Object ref = event_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      event_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the event to handle.
   * </pre>
   *
   * <code>string event = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for event.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEventBytes() {
    java.lang.Object ref = event_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      event_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRIGGER_FULFILLMENT_FIELD_NUMBER = 5;
  private com.google.cloud.dialogflow.cx.v3.Fulfillment triggerFulfillment_;
  /**
   *
   *
   * <pre>
   * The fulfillment to call when the event occurs.
   * Handling webhook errors with a fulfillment enabled with webhook could
   * cause infinite loop. It is invalid to specify such fulfillment for a
   * handler handling webhooks.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 5;</code>
   *
   * @return Whether the triggerFulfillment field is set.
   */
  @java.lang.Override
  public boolean hasTriggerFulfillment() {
    return triggerFulfillment_ != null;
  }
  /**
   *
   *
   * <pre>
   * The fulfillment to call when the event occurs.
   * Handling webhook errors with a fulfillment enabled with webhook could
   * cause infinite loop. It is invalid to specify such fulfillment for a
   * handler handling webhooks.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 5;</code>
   *
   * @return The triggerFulfillment.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Fulfillment getTriggerFulfillment() {
    return triggerFulfillment_ == null
        ? com.google.cloud.dialogflow.cx.v3.Fulfillment.getDefaultInstance()
        : triggerFulfillment_;
  }
  /**
   *
   *
   * <pre>
   * The fulfillment to call when the event occurs.
   * Handling webhook errors with a fulfillment enabled with webhook could
   * cause infinite loop. It is invalid to specify such fulfillment for a
   * handler handling webhooks.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder getTriggerFulfillmentOrBuilder() {
    return getTriggerFulfillment();
  }

  public static final int TARGET_PAGE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The target page to transition to.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
   * </pre>
   *
   * <code>string target_page = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the targetPage field is set.
   */
  public boolean hasTargetPage() {
    return targetCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The target page to transition to.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
   * </pre>
   *
   * <code>string target_page = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The targetPage.
   */
  public java.lang.String getTargetPage() {
    java.lang.Object ref = "";
    if (targetCase_ == 2) {
      ref = target_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (targetCase_ == 2) {
        target_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The target page to transition to.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
   * </pre>
   *
   * <code>string target_page = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for targetPage.
   */
  public com.google.protobuf.ByteString getTargetPageBytes() {
    java.lang.Object ref = "";
    if (targetCase_ == 2) {
      ref = target_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (targetCase_ == 2) {
        target_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_FLOW_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The target flow to transition to.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;`.
   * </pre>
   *
   * <code>string target_flow = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the targetFlow field is set.
   */
  public boolean hasTargetFlow() {
    return targetCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The target flow to transition to.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;`.
   * </pre>
   *
   * <code>string target_flow = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The targetFlow.
   */
  public java.lang.String getTargetFlow() {
    java.lang.Object ref = "";
    if (targetCase_ == 3) {
      ref = target_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (targetCase_ == 3) {
        target_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The target flow to transition to.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;`.
   * </pre>
   *
   * <code>string target_flow = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for targetFlow.
   */
  public com.google.protobuf.ByteString getTargetFlowBytes() {
    java.lang.Object ref = "";
    if (targetCase_ == 3) {
      ref = target_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (targetCase_ == 3) {
        target_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (targetCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, target_);
    }
    if (targetCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, target_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(event_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, event_);
    }
    if (triggerFulfillment_ != null) {
      output.writeMessage(5, getTriggerFulfillment());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, name_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (targetCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, target_);
    }
    if (targetCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, target_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(event_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, event_);
    }
    if (triggerFulfillment_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getTriggerFulfillment());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, name_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.EventHandler)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.EventHandler other =
        (com.google.cloud.dialogflow.cx.v3.EventHandler) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getEvent().equals(other.getEvent())) return false;
    if (hasTriggerFulfillment() != other.hasTriggerFulfillment()) return false;
    if (hasTriggerFulfillment()) {
      if (!getTriggerFulfillment().equals(other.getTriggerFulfillment())) return false;
    }
    if (!getTargetCase().equals(other.getTargetCase())) return false;
    switch (targetCase_) {
      case 2:
        if (!getTargetPage().equals(other.getTargetPage())) return false;
        break;
      case 3:
        if (!getTargetFlow().equals(other.getTargetFlow())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + EVENT_FIELD_NUMBER;
    hash = (53 * hash) + getEvent().hashCode();
    if (hasTriggerFulfillment()) {
      hash = (37 * hash) + TRIGGER_FULFILLMENT_FIELD_NUMBER;
      hash = (53 * hash) + getTriggerFulfillment().hashCode();
    }
    switch (targetCase_) {
      case 2:
        hash = (37 * hash) + TARGET_PAGE_FIELD_NUMBER;
        hash = (53 * hash) + getTargetPage().hashCode();
        break;
      case 3:
        hash = (37 * hash) + TARGET_FLOW_FIELD_NUMBER;
        hash = (53 * hash) + getTargetFlow().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.EventHandler parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.EventHandler parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.EventHandler parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.EventHandler parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.EventHandler parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.EventHandler parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.EventHandler parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.EventHandler parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.EventHandler parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.EventHandler parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.EventHandler parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.EventHandler parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.EventHandler prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An event handler specifies an [event][google.cloud.dialogflow.cx.v3.EventHandler.event] that can be handled
   * during a session. When the specified event happens, the following actions are
   * taken in order:
   * *   If there is a
   * [`trigger_fulfillment`][google.cloud.dialogflow.cx.v3.EventHandler.trigger_fulfillment] associated with
   * the event, it will be called.
   * *   If there is a [`target_page`][google.cloud.dialogflow.cx.v3.EventHandler.target_page] associated
   * with the event, the session will transition into the specified page.
   * *   If there is a [`target_flow`][google.cloud.dialogflow.cx.v3.EventHandler.target_flow] associated
   * with the event, the session will transition into the specified flow.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.EventHandler}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.EventHandler)
      com.google.cloud.dialogflow.cx.v3.EventHandlerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3_EventHandler_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3_EventHandler_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.EventHandler.class,
              com.google.cloud.dialogflow.cx.v3.EventHandler.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.EventHandler.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      event_ = "";

      if (triggerFulfillmentBuilder_ == null) {
        triggerFulfillment_ = null;
      } else {
        triggerFulfillment_ = null;
        triggerFulfillmentBuilder_ = null;
      }
      targetCase_ = 0;
      target_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3_EventHandler_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.EventHandler getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.EventHandler.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.EventHandler build() {
      com.google.cloud.dialogflow.cx.v3.EventHandler result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.EventHandler buildPartial() {
      com.google.cloud.dialogflow.cx.v3.EventHandler result =
          new com.google.cloud.dialogflow.cx.v3.EventHandler(this);
      result.name_ = name_;
      result.event_ = event_;
      if (triggerFulfillmentBuilder_ == null) {
        result.triggerFulfillment_ = triggerFulfillment_;
      } else {
        result.triggerFulfillment_ = triggerFulfillmentBuilder_.build();
      }
      if (targetCase_ == 2) {
        result.target_ = target_;
      }
      if (targetCase_ == 3) {
        result.target_ = target_;
      }
      result.targetCase_ = targetCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.EventHandler) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.EventHandler) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.EventHandler other) {
      if (other == com.google.cloud.dialogflow.cx.v3.EventHandler.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getEvent().isEmpty()) {
        event_ = other.event_;
        onChanged();
      }
      if (other.hasTriggerFulfillment()) {
        mergeTriggerFulfillment(other.getTriggerFulfillment());
      }
      switch (other.getTargetCase()) {
        case TARGET_PAGE:
          {
            targetCase_ = 2;
            target_ = other.target_;
            onChanged();
            break;
          }
        case TARGET_FLOW:
          {
            targetCase_ = 3;
            target_ = other.target_;
            onChanged();
            break;
          }
        case TARGET_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                targetCase_ = 2;
                target_ = s;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                targetCase_ = 3;
                target_ = s;
                break;
              } // case 26
            case 34:
              {
                event_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getTriggerFulfillmentFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int targetCase_ = 0;
    private java.lang.Object target_;

    public TargetCase getTargetCase() {
      return TargetCase.forNumber(targetCase_);
    }

    public Builder clearTarget() {
      targetCase_ = 0;
      target_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this event handler.
     * </pre>
     *
     * <code>string name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this event handler.
     * </pre>
     *
     * <code>string name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this event handler.
     * </pre>
     *
     * <code>string name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this event handler.
     * </pre>
     *
     * <code>string name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this event handler.
     * </pre>
     *
     * <code>string name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object event_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the event to handle.
     * </pre>
     *
     * <code>string event = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The event.
     */
    public java.lang.String getEvent() {
      java.lang.Object ref = event_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        event_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the event to handle.
     * </pre>
     *
     * <code>string event = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for event.
     */
    public com.google.protobuf.ByteString getEventBytes() {
      java.lang.Object ref = event_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        event_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the event to handle.
     * </pre>
     *
     * <code>string event = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The event to set.
     * @return This builder for chaining.
     */
    public Builder setEvent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      event_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the event to handle.
     * </pre>
     *
     * <code>string event = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEvent() {

      event_ = getDefaultInstance().getEvent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the event to handle.
     * </pre>
     *
     * <code>string event = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for event to set.
     * @return This builder for chaining.
     */
    public Builder setEventBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      event_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.Fulfillment triggerFulfillment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Fulfillment,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder,
            com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder>
        triggerFulfillmentBuilder_;
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the event occurs.
     * Handling webhook errors with a fulfillment enabled with webhook could
     * cause infinite loop. It is invalid to specify such fulfillment for a
     * handler handling webhooks.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 5;</code>
     *
     * @return Whether the triggerFulfillment field is set.
     */
    public boolean hasTriggerFulfillment() {
      return triggerFulfillmentBuilder_ != null || triggerFulfillment_ != null;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the event occurs.
     * Handling webhook errors with a fulfillment enabled with webhook could
     * cause infinite loop. It is invalid to specify such fulfillment for a
     * handler handling webhooks.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 5;</code>
     *
     * @return The triggerFulfillment.
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment getTriggerFulfillment() {
      if (triggerFulfillmentBuilder_ == null) {
        return triggerFulfillment_ == null
            ? com.google.cloud.dialogflow.cx.v3.Fulfillment.getDefaultInstance()
            : triggerFulfillment_;
      } else {
        return triggerFulfillmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the event occurs.
     * Handling webhook errors with a fulfillment enabled with webhook could
     * cause infinite loop. It is invalid to specify such fulfillment for a
     * handler handling webhooks.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 5;</code>
     */
    public Builder setTriggerFulfillment(com.google.cloud.dialogflow.cx.v3.Fulfillment value) {
      if (triggerFulfillmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        triggerFulfillment_ = value;
        onChanged();
      } else {
        triggerFulfillmentBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the event occurs.
     * Handling webhook errors with a fulfillment enabled with webhook could
     * cause infinite loop. It is invalid to specify such fulfillment for a
     * handler handling webhooks.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 5;</code>
     */
    public Builder setTriggerFulfillment(
        com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder builderForValue) {
      if (triggerFulfillmentBuilder_ == null) {
        triggerFulfillment_ = builderForValue.build();
        onChanged();
      } else {
        triggerFulfillmentBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the event occurs.
     * Handling webhook errors with a fulfillment enabled with webhook could
     * cause infinite loop. It is invalid to specify such fulfillment for a
     * handler handling webhooks.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 5;</code>
     */
    public Builder mergeTriggerFulfillment(com.google.cloud.dialogflow.cx.v3.Fulfillment value) {
      if (triggerFulfillmentBuilder_ == null) {
        if (triggerFulfillment_ != null) {
          triggerFulfillment_ =
              com.google.cloud.dialogflow.cx.v3.Fulfillment.newBuilder(triggerFulfillment_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          triggerFulfillment_ = value;
        }
        onChanged();
      } else {
        triggerFulfillmentBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the event occurs.
     * Handling webhook errors with a fulfillment enabled with webhook could
     * cause infinite loop. It is invalid to specify such fulfillment for a
     * handler handling webhooks.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 5;</code>
     */
    public Builder clearTriggerFulfillment() {
      if (triggerFulfillmentBuilder_ == null) {
        triggerFulfillment_ = null;
        onChanged();
      } else {
        triggerFulfillment_ = null;
        triggerFulfillmentBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the event occurs.
     * Handling webhook errors with a fulfillment enabled with webhook could
     * cause infinite loop. It is invalid to specify such fulfillment for a
     * handler handling webhooks.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder getTriggerFulfillmentBuilder() {

      onChanged();
      return getTriggerFulfillmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the event occurs.
     * Handling webhook errors with a fulfillment enabled with webhook could
     * cause infinite loop. It is invalid to specify such fulfillment for a
     * handler handling webhooks.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder getTriggerFulfillmentOrBuilder() {
      if (triggerFulfillmentBuilder_ != null) {
        return triggerFulfillmentBuilder_.getMessageOrBuilder();
      } else {
        return triggerFulfillment_ == null
            ? com.google.cloud.dialogflow.cx.v3.Fulfillment.getDefaultInstance()
            : triggerFulfillment_;
      }
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the event occurs.
     * Handling webhook errors with a fulfillment enabled with webhook could
     * cause infinite loop. It is invalid to specify such fulfillment for a
     * handler handling webhooks.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Fulfillment,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder,
            com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder>
        getTriggerFulfillmentFieldBuilder() {
      if (triggerFulfillmentBuilder_ == null) {
        triggerFulfillmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Fulfillment,
                com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder,
                com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder>(
                getTriggerFulfillment(), getParentForChildren(), isClean());
        triggerFulfillment_ = null;
      }
      return triggerFulfillmentBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string target_page = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the targetPage field is set.
     */
    @java.lang.Override
    public boolean hasTargetPage() {
      return targetCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string target_page = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The targetPage.
     */
    @java.lang.Override
    public java.lang.String getTargetPage() {
      java.lang.Object ref = "";
      if (targetCase_ == 2) {
        ref = target_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (targetCase_ == 2) {
          target_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string target_page = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for targetPage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTargetPageBytes() {
      java.lang.Object ref = "";
      if (targetCase_ == 2) {
        ref = target_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (targetCase_ == 2) {
          target_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string target_page = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The targetPage to set.
     * @return This builder for chaining.
     */
    public Builder setTargetPage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetCase_ = 2;
      target_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string target_page = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetPage() {
      if (targetCase_ == 2) {
        targetCase_ = 0;
        target_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string target_page = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for targetPage to set.
     * @return This builder for chaining.
     */
    public Builder setTargetPageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetCase_ = 2;
      target_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the targetFlow field is set.
     */
    @java.lang.Override
    public boolean hasTargetFlow() {
      return targetCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The targetFlow.
     */
    @java.lang.Override
    public java.lang.String getTargetFlow() {
      java.lang.Object ref = "";
      if (targetCase_ == 3) {
        ref = target_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (targetCase_ == 3) {
          target_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for targetFlow.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTargetFlowBytes() {
      java.lang.Object ref = "";
      if (targetCase_ == 3) {
        ref = target_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (targetCase_ == 3) {
          target_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The targetFlow to set.
     * @return This builder for chaining.
     */
    public Builder setTargetFlow(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetCase_ = 3;
      target_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetFlow() {
      if (targetCase_ == 3) {
        targetCase_ = 0;
        target_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for targetFlow to set.
     * @return This builder for chaining.
     */
    public Builder setTargetFlowBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetCase_ = 3;
      target_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.EventHandler)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.EventHandler)
  private static final com.google.cloud.dialogflow.cx.v3.EventHandler DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.EventHandler();
  }

  public static com.google.cloud.dialogflow.cx.v3.EventHandler getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EventHandler> PARSER =
      new com.google.protobuf.AbstractParser<EventHandler>() {
        @java.lang.Override
        public EventHandler parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EventHandler> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EventHandler> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.EventHandler getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
