/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/agent.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Agents are best described as Natural Language Understanding (NLU) modules
 * that transform user requests into actionable data. You can include agents
 * in your app, product, or service to determine user intent and respond to the
 * user in a natural way.
 * After you create an agent, you can add [Intents][google.cloud.dialogflow.cx.v3.Intent],
 * [Entity Types][google.cloud.dialogflow.cx.v3.EntityType], [Flows][google.cloud.dialogflow.cx.v3.Flow], [Fulfillments][google.cloud.dialogflow.cx.v3.Fulfillment],
 * [Webhooks][google.cloud.dialogflow.cx.v3.Webhook], and so on to manage the conversation flows..
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.Agent}
 */
public final class Agent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Agent)
    AgentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Agent.newBuilder() to construct.
  private Agent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Agent() {
    name_ = "";
    displayName_ = "";
    defaultLanguageCode_ = "";
    supportedLanguageCodes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    timeZone_ = "";
    description_ = "";
    avatarUri_ = "";
    startFlow_ = "";
    securitySettings_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Agent();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.AgentProto
        .internal_static_google_cloud_dialogflow_cx_v3_Agent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.AgentProto
        .internal_static_google_cloud_dialogflow_cx_v3_Agent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.Agent.class,
            com.google.cloud.dialogflow.cx.v3.Agent.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The unique identifier of the agent.
   * Required for the [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent] method. [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent]
   * populates the name automatically.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the agent.
   * Required for the [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent] method. [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent]
   * populates the name automatically.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the agent, unique within the location.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the agent, unique within the location.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_LANGUAGE_CODE_FIELD_NUMBER = 3;
  private volatile java.lang.Object defaultLanguageCode_;
  /**
   *
   *
   * <pre>
   * Required. Immutable. The default language of the agent as a language tag.
   * See [Language
   * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
   * for a list of the currently supported language codes.
   * This field cannot be set by the [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent] method.
   * </pre>
   *
   * <code>
   * string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The defaultLanguageCode.
   */
  @java.lang.Override
  public java.lang.String getDefaultLanguageCode() {
    java.lang.Object ref = defaultLanguageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultLanguageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The default language of the agent as a language tag.
   * See [Language
   * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
   * for a list of the currently supported language codes.
   * This field cannot be set by the [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent] method.
   * </pre>
   *
   * <code>
   * string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for defaultLanguageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultLanguageCodeBytes() {
    java.lang.Object ref = defaultLanguageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultLanguageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUPPORTED_LANGUAGE_CODES_FIELD_NUMBER = 4;
  private com.google.protobuf.LazyStringList supportedLanguageCodes_;
  /**
   *
   *
   * <pre>
   * The list of all languages supported by the agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4;</code>
   *
   * @return A list containing the supportedLanguageCodes.
   */
  public com.google.protobuf.ProtocolStringList getSupportedLanguageCodesList() {
    return supportedLanguageCodes_;
  }
  /**
   *
   *
   * <pre>
   * The list of all languages supported by the agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4;</code>
   *
   * @return The count of supportedLanguageCodes.
   */
  public int getSupportedLanguageCodesCount() {
    return supportedLanguageCodes_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of all languages supported by the agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The supportedLanguageCodes at the given index.
   */
  public java.lang.String getSupportedLanguageCodes(int index) {
    return supportedLanguageCodes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of all languages supported by the agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the supportedLanguageCodes at the given index.
   */
  public com.google.protobuf.ByteString getSupportedLanguageCodesBytes(int index) {
    return supportedLanguageCodes_.getByteString(index);
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 5;
  private volatile java.lang.Object timeZone_;
  /**
   *
   *
   * <pre>
   * Required. The time zone of the agent from the [time zone
   * database](https://www.iana.org/time-zones), e.g., America/New_York,
   * Europe/Paris.
   * </pre>
   *
   * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The time zone of the agent from the [time zone
   * database](https://www.iana.org/time-zones), e.g., America/New_York,
   * Europe/Paris.
   * </pre>
   *
   * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for timeZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 6;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * The description of the agent. The maximum length is 500 characters. If
   * exceeded, the request is rejected.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of the agent. The maximum length is 500 characters. If
   * exceeded, the request is rejected.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AVATAR_URI_FIELD_NUMBER = 7;
  private volatile java.lang.Object avatarUri_;
  /**
   *
   *
   * <pre>
   * The URI of the agent's avatar. Avatars are used throughout the Dialogflow
   * console and in the self-hosted [Web
   * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
   * integration.
   * </pre>
   *
   * <code>string avatar_uri = 7;</code>
   *
   * @return The avatarUri.
   */
  @java.lang.Override
  public java.lang.String getAvatarUri() {
    java.lang.Object ref = avatarUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      avatarUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI of the agent's avatar. Avatars are used throughout the Dialogflow
   * console and in the self-hosted [Web
   * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
   * integration.
   * </pre>
   *
   * <code>string avatar_uri = 7;</code>
   *
   * @return The bytes for avatarUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAvatarUriBytes() {
    java.lang.Object ref = avatarUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      avatarUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SPEECH_TO_TEXT_SETTINGS_FIELD_NUMBER = 13;
  private com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speechToTextSettings_;
  /**
   *
   *
   * <pre>
   * Speech recognition related settings.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;</code>
   *
   * @return Whether the speechToTextSettings field is set.
   */
  @java.lang.Override
  public boolean hasSpeechToTextSettings() {
    return speechToTextSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Speech recognition related settings.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;</code>
   *
   * @return The speechToTextSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings getSpeechToTextSettings() {
    return speechToTextSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.getDefaultInstance()
        : speechToTextSettings_;
  }
  /**
   *
   *
   * <pre>
   * Speech recognition related settings.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SpeechToTextSettingsOrBuilder
      getSpeechToTextSettingsOrBuilder() {
    return getSpeechToTextSettings();
  }

  public static final int START_FLOW_FIELD_NUMBER = 16;
  private volatile java.lang.Object startFlow_;
  /**
   *
   *
   * <pre>
   * Immutable. Name of the start flow in this agent. A start flow will be automatically
   * created when the agent is created, and can only be deleted by deleting the
   * agent.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;`.
   * </pre>
   *
   * <code>
   * string start_flow = 16 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The startFlow.
   */
  @java.lang.Override
  public java.lang.String getStartFlow() {
    java.lang.Object ref = startFlow_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      startFlow_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Name of the start flow in this agent. A start flow will be automatically
   * created when the agent is created, and can only be deleted by deleting the
   * agent.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;`.
   * </pre>
   *
   * <code>
   * string start_flow = 16 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for startFlow.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStartFlowBytes() {
    java.lang.Object ref = startFlow_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      startFlow_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECURITY_SETTINGS_FIELD_NUMBER = 17;
  private volatile java.lang.Object securitySettings_;
  /**
   *
   *
   * <pre>
   * Name of the [SecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettings] reference for the agent.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/securitySettings/&lt;Security Settings ID&gt;`.
   * </pre>
   *
   * <code>string security_settings = 17 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The securitySettings.
   */
  @java.lang.Override
  public java.lang.String getSecuritySettings() {
    java.lang.Object ref = securitySettings_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      securitySettings_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the [SecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettings] reference for the agent.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/securitySettings/&lt;Security Settings ID&gt;`.
   * </pre>
   *
   * <code>string security_settings = 17 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for securitySettings.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSecuritySettingsBytes() {
    java.lang.Object ref = securitySettings_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      securitySettings_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_STACKDRIVER_LOGGING_FIELD_NUMBER = 18;
  private boolean enableStackdriverLogging_;
  /**
   *
   *
   * <pre>
   * Indicates if stackdriver logging is enabled for the agent.
   * Please use [agent.advanced_settings][google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings]
   * instead.
   * </pre>
   *
   * <code>bool enable_stackdriver_logging = 18 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.cx.v3.Agent.enable_stackdriver_logging is deprecated. See
   *     google/cloud/dialogflow/cx/v3/agent.proto;l=245
   * @return The enableStackdriverLogging.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getEnableStackdriverLogging() {
    return enableStackdriverLogging_;
  }

  public static final int ENABLE_SPELL_CORRECTION_FIELD_NUMBER = 20;
  private boolean enableSpellCorrection_;
  /**
   *
   *
   * <pre>
   * Indicates if automatic spell correction is enabled in detect intent
   * requests.
   * </pre>
   *
   * <code>bool enable_spell_correction = 20;</code>
   *
   * @return The enableSpellCorrection.
   */
  @java.lang.Override
  public boolean getEnableSpellCorrection() {
    return enableSpellCorrection_;
  }

  public static final int LOCKED_FIELD_NUMBER = 27;
  private boolean locked_;
  /**
   *
   *
   * <pre>
   * Indicates whether the agent is locked for changes. If the agent is locked,
   * modifications to the agent will be rejected except for [RestoreAgent][].
   * </pre>
   *
   * <code>bool locked = 27;</code>
   *
   * @return The locked.
   */
  @java.lang.Override
  public boolean getLocked() {
    return locked_;
  }

  public static final int ADVANCED_SETTINGS_FIELD_NUMBER = 22;
  private com.google.cloud.dialogflow.cx.v3.AdvancedSettings advancedSettings_;
  /**
   *
   *
   * <pre>
   * Hierarchical advanced settings for this agent. The settings exposed at the
   * lower level overrides the settings exposed at the higher level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
   *
   * @return Whether the advancedSettings field is set.
   */
  @java.lang.Override
  public boolean hasAdvancedSettings() {
    return advancedSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Hierarchical advanced settings for this agent. The settings exposed at the
   * lower level overrides the settings exposed at the higher level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
   *
   * @return The advancedSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.AdvancedSettings getAdvancedSettings() {
    return advancedSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.AdvancedSettings.getDefaultInstance()
        : advancedSettings_;
  }
  /**
   *
   *
   * <pre>
   * Hierarchical advanced settings for this agent. The settings exposed at the
   * lower level overrides the settings exposed at the higher level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder
      getAdvancedSettingsOrBuilder() {
    return getAdvancedSettings();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultLanguageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, defaultLanguageCode_);
    }
    for (int i = 0; i < supportedLanguageCodes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 4, supportedLanguageCodes_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, timeZone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(avatarUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, avatarUri_);
    }
    if (speechToTextSettings_ != null) {
      output.writeMessage(13, getSpeechToTextSettings());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startFlow_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, startFlow_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(securitySettings_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, securitySettings_);
    }
    if (enableStackdriverLogging_ != false) {
      output.writeBool(18, enableStackdriverLogging_);
    }
    if (enableSpellCorrection_ != false) {
      output.writeBool(20, enableSpellCorrection_);
    }
    if (advancedSettings_ != null) {
      output.writeMessage(22, getAdvancedSettings());
    }
    if (locked_ != false) {
      output.writeBool(27, locked_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultLanguageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, defaultLanguageCode_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < supportedLanguageCodes_.size(); i++) {
        dataSize += computeStringSizeNoTag(supportedLanguageCodes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSupportedLanguageCodesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, timeZone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(avatarUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, avatarUri_);
    }
    if (speechToTextSettings_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, getSpeechToTextSettings());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startFlow_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, startFlow_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(securitySettings_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, securitySettings_);
    }
    if (enableStackdriverLogging_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(18, enableStackdriverLogging_);
    }
    if (enableSpellCorrection_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(20, enableSpellCorrection_);
    }
    if (advancedSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getAdvancedSettings());
    }
    if (locked_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(27, locked_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Agent)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.Agent other = (com.google.cloud.dialogflow.cx.v3.Agent) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDefaultLanguageCode().equals(other.getDefaultLanguageCode())) return false;
    if (!getSupportedLanguageCodesList().equals(other.getSupportedLanguageCodesList()))
      return false;
    if (!getTimeZone().equals(other.getTimeZone())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getAvatarUri().equals(other.getAvatarUri())) return false;
    if (hasSpeechToTextSettings() != other.hasSpeechToTextSettings()) return false;
    if (hasSpeechToTextSettings()) {
      if (!getSpeechToTextSettings().equals(other.getSpeechToTextSettings())) return false;
    }
    if (!getStartFlow().equals(other.getStartFlow())) return false;
    if (!getSecuritySettings().equals(other.getSecuritySettings())) return false;
    if (getEnableStackdriverLogging() != other.getEnableStackdriverLogging()) return false;
    if (getEnableSpellCorrection() != other.getEnableSpellCorrection()) return false;
    if (getLocked() != other.getLocked()) return false;
    if (hasAdvancedSettings() != other.hasAdvancedSettings()) return false;
    if (hasAdvancedSettings()) {
      if (!getAdvancedSettings().equals(other.getAdvancedSettings())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DEFAULT_LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultLanguageCode().hashCode();
    if (getSupportedLanguageCodesCount() > 0) {
      hash = (37 * hash) + SUPPORTED_LANGUAGE_CODES_FIELD_NUMBER;
      hash = (53 * hash) + getSupportedLanguageCodesList().hashCode();
    }
    hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getTimeZone().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + AVATAR_URI_FIELD_NUMBER;
    hash = (53 * hash) + getAvatarUri().hashCode();
    if (hasSpeechToTextSettings()) {
      hash = (37 * hash) + SPEECH_TO_TEXT_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getSpeechToTextSettings().hashCode();
    }
    hash = (37 * hash) + START_FLOW_FIELD_NUMBER;
    hash = (53 * hash) + getStartFlow().hashCode();
    hash = (37 * hash) + SECURITY_SETTINGS_FIELD_NUMBER;
    hash = (53 * hash) + getSecuritySettings().hashCode();
    hash = (37 * hash) + ENABLE_STACKDRIVER_LOGGING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableStackdriverLogging());
    hash = (37 * hash) + ENABLE_SPELL_CORRECTION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableSpellCorrection());
    hash = (37 * hash) + LOCKED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getLocked());
    if (hasAdvancedSettings()) {
      hash = (37 * hash) + ADVANCED_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getAdvancedSettings().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.Agent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Agents are best described as Natural Language Understanding (NLU) modules
   * that transform user requests into actionable data. You can include agents
   * in your app, product, or service to determine user intent and respond to the
   * user in a natural way.
   * After you create an agent, you can add [Intents][google.cloud.dialogflow.cx.v3.Intent],
   * [Entity Types][google.cloud.dialogflow.cx.v3.EntityType], [Flows][google.cloud.dialogflow.cx.v3.Flow], [Fulfillments][google.cloud.dialogflow.cx.v3.Fulfillment],
   * [Webhooks][google.cloud.dialogflow.cx.v3.Webhook], and so on to manage the conversation flows..
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Agent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Agent)
      com.google.cloud.dialogflow.cx.v3.AgentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Agent.class,
              com.google.cloud.dialogflow.cx.v3.Agent.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.Agent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      defaultLanguageCode_ = "";

      supportedLanguageCodes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      timeZone_ = "";

      description_ = "";

      avatarUri_ = "";

      if (speechToTextSettingsBuilder_ == null) {
        speechToTextSettings_ = null;
      } else {
        speechToTextSettings_ = null;
        speechToTextSettingsBuilder_ = null;
      }
      startFlow_ = "";

      securitySettings_ = "";

      enableStackdriverLogging_ = false;

      enableSpellCorrection_ = false;

      locked_ = false;

      if (advancedSettingsBuilder_ == null) {
        advancedSettings_ = null;
      } else {
        advancedSettings_ = null;
        advancedSettingsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Agent getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.Agent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Agent build() {
      com.google.cloud.dialogflow.cx.v3.Agent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Agent buildPartial() {
      com.google.cloud.dialogflow.cx.v3.Agent result =
          new com.google.cloud.dialogflow.cx.v3.Agent(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      result.defaultLanguageCode_ = defaultLanguageCode_;
      if (((bitField0_ & 0x00000001) != 0)) {
        supportedLanguageCodes_ = supportedLanguageCodes_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.supportedLanguageCodes_ = supportedLanguageCodes_;
      result.timeZone_ = timeZone_;
      result.description_ = description_;
      result.avatarUri_ = avatarUri_;
      if (speechToTextSettingsBuilder_ == null) {
        result.speechToTextSettings_ = speechToTextSettings_;
      } else {
        result.speechToTextSettings_ = speechToTextSettingsBuilder_.build();
      }
      result.startFlow_ = startFlow_;
      result.securitySettings_ = securitySettings_;
      result.enableStackdriverLogging_ = enableStackdriverLogging_;
      result.enableSpellCorrection_ = enableSpellCorrection_;
      result.locked_ = locked_;
      if (advancedSettingsBuilder_ == null) {
        result.advancedSettings_ = advancedSettings_;
      } else {
        result.advancedSettings_ = advancedSettingsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.Agent) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.Agent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.Agent other) {
      if (other == com.google.cloud.dialogflow.cx.v3.Agent.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getDefaultLanguageCode().isEmpty()) {
        defaultLanguageCode_ = other.defaultLanguageCode_;
        onChanged();
      }
      if (!other.supportedLanguageCodes_.isEmpty()) {
        if (supportedLanguageCodes_.isEmpty()) {
          supportedLanguageCodes_ = other.supportedLanguageCodes_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureSupportedLanguageCodesIsMutable();
          supportedLanguageCodes_.addAll(other.supportedLanguageCodes_);
        }
        onChanged();
      }
      if (!other.getTimeZone().isEmpty()) {
        timeZone_ = other.timeZone_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (!other.getAvatarUri().isEmpty()) {
        avatarUri_ = other.avatarUri_;
        onChanged();
      }
      if (other.hasSpeechToTextSettings()) {
        mergeSpeechToTextSettings(other.getSpeechToTextSettings());
      }
      if (!other.getStartFlow().isEmpty()) {
        startFlow_ = other.startFlow_;
        onChanged();
      }
      if (!other.getSecuritySettings().isEmpty()) {
        securitySettings_ = other.securitySettings_;
        onChanged();
      }
      if (other.getEnableStackdriverLogging() != false) {
        setEnableStackdriverLogging(other.getEnableStackdriverLogging());
      }
      if (other.getEnableSpellCorrection() != false) {
        setEnableSpellCorrection(other.getEnableSpellCorrection());
      }
      if (other.getLocked() != false) {
        setLocked(other.getLocked());
      }
      if (other.hasAdvancedSettings()) {
        mergeAdvancedSettings(other.getAdvancedSettings());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                defaultLanguageCode_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSupportedLanguageCodesIsMutable();
                supportedLanguageCodes_.add(s);
                break;
              } // case 34
            case 42:
              {
                timeZone_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 58:
              {
                avatarUri_ = input.readStringRequireUtf8();

                break;
              } // case 58
            case 106:
              {
                input.readMessage(
                    getSpeechToTextSettingsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 106
            case 130:
              {
                startFlow_ = input.readStringRequireUtf8();

                break;
              } // case 130
            case 138:
              {
                securitySettings_ = input.readStringRequireUtf8();

                break;
              } // case 138
            case 144:
              {
                enableStackdriverLogging_ = input.readBool();

                break;
              } // case 144
            case 160:
              {
                enableSpellCorrection_ = input.readBool();

                break;
              } // case 160
            case 178:
              {
                input.readMessage(
                    getAdvancedSettingsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 178
            case 216:
              {
                locked_ = input.readBool();

                break;
              } // case 216
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the agent.
     * Required for the [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent] method. [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent]
     * populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the agent.
     * Required for the [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent] method. [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent]
     * populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the agent.
     * Required for the [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent] method. [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent]
     * populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the agent.
     * Required for the [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent] method. [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent]
     * populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the agent.
     * Required for the [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent] method. [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent]
     * populates the name automatically.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the agent, unique within the location.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the agent, unique within the location.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the agent, unique within the location.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the agent, unique within the location.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the agent, unique within the location.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object defaultLanguageCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. The default language of the agent as a language tag.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     * This field cannot be set by the [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent] method.
     * </pre>
     *
     * <code>
     * string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The defaultLanguageCode.
     */
    public java.lang.String getDefaultLanguageCode() {
      java.lang.Object ref = defaultLanguageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultLanguageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The default language of the agent as a language tag.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     * This field cannot be set by the [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent] method.
     * </pre>
     *
     * <code>
     * string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for defaultLanguageCode.
     */
    public com.google.protobuf.ByteString getDefaultLanguageCodeBytes() {
      java.lang.Object ref = defaultLanguageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The default language of the agent as a language tag.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     * This field cannot be set by the [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent] method.
     * </pre>
     *
     * <code>
     * string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The defaultLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      defaultLanguageCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The default language of the agent as a language tag.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     * This field cannot be set by the [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent] method.
     * </pre>
     *
     * <code>
     * string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultLanguageCode() {

      defaultLanguageCode_ = getDefaultInstance().getDefaultLanguageCode();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The default language of the agent as a language tag.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     * This field cannot be set by the [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent] method.
     * </pre>
     *
     * <code>
     * string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for defaultLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      defaultLanguageCode_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList supportedLanguageCodes_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureSupportedLanguageCodesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        supportedLanguageCodes_ =
            new com.google.protobuf.LazyStringArrayList(supportedLanguageCodes_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @return A list containing the supportedLanguageCodes.
     */
    public com.google.protobuf.ProtocolStringList getSupportedLanguageCodesList() {
      return supportedLanguageCodes_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @return The count of supportedLanguageCodes.
     */
    public int getSupportedLanguageCodesCount() {
      return supportedLanguageCodes_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The supportedLanguageCodes at the given index.
     */
    public java.lang.String getSupportedLanguageCodes(int index) {
      return supportedLanguageCodes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the supportedLanguageCodes at the given index.
     */
    public com.google.protobuf.ByteString getSupportedLanguageCodesBytes(int index) {
      return supportedLanguageCodes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The supportedLanguageCodes to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedLanguageCodes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedLanguageCodesIsMutable();
      supportedLanguageCodes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param value The supportedLanguageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedLanguageCodes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedLanguageCodesIsMutable();
      supportedLanguageCodes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param values The supportedLanguageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedLanguageCodes(java.lang.Iterable<java.lang.String> values) {
      ensureSupportedLanguageCodesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, supportedLanguageCodes_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSupportedLanguageCodes() {
      supportedLanguageCodes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param value The bytes of the supportedLanguageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedLanguageCodesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSupportedLanguageCodesIsMutable();
      supportedLanguageCodes_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object timeZone_ = "";
    /**
     *
     *
     * <pre>
     * Required. The time zone of the agent from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The timeZone.
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of the agent from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for timeZone.
     */
    public com.google.protobuf.ByteString getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of the agent from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      timeZone_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of the agent from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeZone() {

      timeZone_ = getDefaultInstance().getTimeZone();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of the agent from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      timeZone_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the agent. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the agent. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the agent. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the agent. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the agent. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object avatarUri_ = "";
    /**
     *
     *
     * <pre>
     * The URI of the agent's avatar. Avatars are used throughout the Dialogflow
     * console and in the self-hosted [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7;</code>
     *
     * @return The avatarUri.
     */
    public java.lang.String getAvatarUri() {
      java.lang.Object ref = avatarUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        avatarUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the agent's avatar. Avatars are used throughout the Dialogflow
     * console and in the self-hosted [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7;</code>
     *
     * @return The bytes for avatarUri.
     */
    public com.google.protobuf.ByteString getAvatarUriBytes() {
      java.lang.Object ref = avatarUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        avatarUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the agent's avatar. Avatars are used throughout the Dialogflow
     * console and in the self-hosted [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7;</code>
     *
     * @param value The avatarUri to set.
     * @return This builder for chaining.
     */
    public Builder setAvatarUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      avatarUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the agent's avatar. Avatars are used throughout the Dialogflow
     * console and in the self-hosted [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvatarUri() {

      avatarUri_ = getDefaultInstance().getAvatarUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the agent's avatar. Avatars are used throughout the Dialogflow
     * console and in the self-hosted [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7;</code>
     *
     * @param value The bytes for avatarUri to set.
     * @return This builder for chaining.
     */
    public Builder setAvatarUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      avatarUri_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speechToTextSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings,
            com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.SpeechToTextSettingsOrBuilder>
        speechToTextSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     *
     * @return Whether the speechToTextSettings field is set.
     */
    public boolean hasSpeechToTextSettings() {
      return speechToTextSettingsBuilder_ != null || speechToTextSettings_ != null;
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     *
     * @return The speechToTextSettings.
     */
    public com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings getSpeechToTextSettings() {
      if (speechToTextSettingsBuilder_ == null) {
        return speechToTextSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.getDefaultInstance()
            : speechToTextSettings_;
      } else {
        return speechToTextSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     */
    public Builder setSpeechToTextSettings(
        com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings value) {
      if (speechToTextSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        speechToTextSettings_ = value;
        onChanged();
      } else {
        speechToTextSettingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     */
    public Builder setSpeechToTextSettings(
        com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.Builder builderForValue) {
      if (speechToTextSettingsBuilder_ == null) {
        speechToTextSettings_ = builderForValue.build();
        onChanged();
      } else {
        speechToTextSettingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     */
    public Builder mergeSpeechToTextSettings(
        com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings value) {
      if (speechToTextSettingsBuilder_ == null) {
        if (speechToTextSettings_ != null) {
          speechToTextSettings_ =
              com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.newBuilder(
                      speechToTextSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          speechToTextSettings_ = value;
        }
        onChanged();
      } else {
        speechToTextSettingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     */
    public Builder clearSpeechToTextSettings() {
      if (speechToTextSettingsBuilder_ == null) {
        speechToTextSettings_ = null;
        onChanged();
      } else {
        speechToTextSettings_ = null;
        speechToTextSettingsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.Builder
        getSpeechToTextSettingsBuilder() {

      onChanged();
      return getSpeechToTextSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.SpeechToTextSettingsOrBuilder
        getSpeechToTextSettingsOrBuilder() {
      if (speechToTextSettingsBuilder_ != null) {
        return speechToTextSettingsBuilder_.getMessageOrBuilder();
      } else {
        return speechToTextSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.getDefaultInstance()
            : speechToTextSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings,
            com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.SpeechToTextSettingsOrBuilder>
        getSpeechToTextSettingsFieldBuilder() {
      if (speechToTextSettingsBuilder_ == null) {
        speechToTextSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings,
                com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.Builder,
                com.google.cloud.dialogflow.cx.v3.SpeechToTextSettingsOrBuilder>(
                getSpeechToTextSettings(), getParentForChildren(), isClean());
        speechToTextSettings_ = null;
      }
      return speechToTextSettingsBuilder_;
    }

    private java.lang.Object startFlow_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Name of the start flow in this agent. A start flow will be automatically
     * created when the agent is created, and can only be deleted by deleting the
     * agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>
     * string start_flow = 16 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The startFlow.
     */
    public java.lang.String getStartFlow() {
      java.lang.Object ref = startFlow_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        startFlow_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the start flow in this agent. A start flow will be automatically
     * created when the agent is created, and can only be deleted by deleting the
     * agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>
     * string start_flow = 16 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for startFlow.
     */
    public com.google.protobuf.ByteString getStartFlowBytes() {
      java.lang.Object ref = startFlow_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        startFlow_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the start flow in this agent. A start flow will be automatically
     * created when the agent is created, and can only be deleted by deleting the
     * agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>
     * string start_flow = 16 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The startFlow to set.
     * @return This builder for chaining.
     */
    public Builder setStartFlow(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      startFlow_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the start flow in this agent. A start flow will be automatically
     * created when the agent is created, and can only be deleted by deleting the
     * agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>
     * string start_flow = 16 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartFlow() {

      startFlow_ = getDefaultInstance().getStartFlow();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the start flow in this agent. A start flow will be automatically
     * created when the agent is created, and can only be deleted by deleting the
     * agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;`.
     * </pre>
     *
     * <code>
     * string start_flow = 16 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for startFlow to set.
     * @return This builder for chaining.
     */
    public Builder setStartFlowBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      startFlow_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object securitySettings_ = "";
    /**
     *
     *
     * <pre>
     * Name of the [SecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettings] reference for the agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/securitySettings/&lt;Security Settings ID&gt;`.
     * </pre>
     *
     * <code>string security_settings = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The securitySettings.
     */
    public java.lang.String getSecuritySettings() {
      java.lang.Object ref = securitySettings_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        securitySettings_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the [SecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettings] reference for the agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/securitySettings/&lt;Security Settings ID&gt;`.
     * </pre>
     *
     * <code>string security_settings = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for securitySettings.
     */
    public com.google.protobuf.ByteString getSecuritySettingsBytes() {
      java.lang.Object ref = securitySettings_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        securitySettings_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the [SecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettings] reference for the agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/securitySettings/&lt;Security Settings ID&gt;`.
     * </pre>
     *
     * <code>string security_settings = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The securitySettings to set.
     * @return This builder for chaining.
     */
    public Builder setSecuritySettings(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      securitySettings_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the [SecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettings] reference for the agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/securitySettings/&lt;Security Settings ID&gt;`.
     * </pre>
     *
     * <code>string security_settings = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecuritySettings() {

      securitySettings_ = getDefaultInstance().getSecuritySettings();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the [SecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettings] reference for the agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/securitySettings/&lt;Security Settings ID&gt;`.
     * </pre>
     *
     * <code>string security_settings = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for securitySettings to set.
     * @return This builder for chaining.
     */
    public Builder setSecuritySettingsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      securitySettings_ = value;
      onChanged();
      return this;
    }

    private boolean enableStackdriverLogging_;
    /**
     *
     *
     * <pre>
     * Indicates if stackdriver logging is enabled for the agent.
     * Please use [agent.advanced_settings][google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings]
     * instead.
     * </pre>
     *
     * <code>bool enable_stackdriver_logging = 18 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.Agent.enable_stackdriver_logging is deprecated. See
     *     google/cloud/dialogflow/cx/v3/agent.proto;l=245
     * @return The enableStackdriverLogging.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getEnableStackdriverLogging() {
      return enableStackdriverLogging_;
    }
    /**
     *
     *
     * <pre>
     * Indicates if stackdriver logging is enabled for the agent.
     * Please use [agent.advanced_settings][google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings]
     * instead.
     * </pre>
     *
     * <code>bool enable_stackdriver_logging = 18 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.Agent.enable_stackdriver_logging is deprecated. See
     *     google/cloud/dialogflow/cx/v3/agent.proto;l=245
     * @param value The enableStackdriverLogging to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setEnableStackdriverLogging(boolean value) {

      enableStackdriverLogging_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates if stackdriver logging is enabled for the agent.
     * Please use [agent.advanced_settings][google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings]
     * instead.
     * </pre>
     *
     * <code>bool enable_stackdriver_logging = 18 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.Agent.enable_stackdriver_logging is deprecated. See
     *     google/cloud/dialogflow/cx/v3/agent.proto;l=245
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearEnableStackdriverLogging() {

      enableStackdriverLogging_ = false;
      onChanged();
      return this;
    }

    private boolean enableSpellCorrection_;
    /**
     *
     *
     * <pre>
     * Indicates if automatic spell correction is enabled in detect intent
     * requests.
     * </pre>
     *
     * <code>bool enable_spell_correction = 20;</code>
     *
     * @return The enableSpellCorrection.
     */
    @java.lang.Override
    public boolean getEnableSpellCorrection() {
      return enableSpellCorrection_;
    }
    /**
     *
     *
     * <pre>
     * Indicates if automatic spell correction is enabled in detect intent
     * requests.
     * </pre>
     *
     * <code>bool enable_spell_correction = 20;</code>
     *
     * @param value The enableSpellCorrection to set.
     * @return This builder for chaining.
     */
    public Builder setEnableSpellCorrection(boolean value) {

      enableSpellCorrection_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates if automatic spell correction is enabled in detect intent
     * requests.
     * </pre>
     *
     * <code>bool enable_spell_correction = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableSpellCorrection() {

      enableSpellCorrection_ = false;
      onChanged();
      return this;
    }

    private boolean locked_;
    /**
     *
     *
     * <pre>
     * Indicates whether the agent is locked for changes. If the agent is locked,
     * modifications to the agent will be rejected except for [RestoreAgent][].
     * </pre>
     *
     * <code>bool locked = 27;</code>
     *
     * @return The locked.
     */
    @java.lang.Override
    public boolean getLocked() {
      return locked_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the agent is locked for changes. If the agent is locked,
     * modifications to the agent will be rejected except for [RestoreAgent][].
     * </pre>
     *
     * <code>bool locked = 27;</code>
     *
     * @param value The locked to set.
     * @return This builder for chaining.
     */
    public Builder setLocked(boolean value) {

      locked_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the agent is locked for changes. If the agent is locked,
     * modifications to the agent will be rejected except for [RestoreAgent][].
     * </pre>
     *
     * <code>bool locked = 27;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocked() {

      locked_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.AdvancedSettings advancedSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder>
        advancedSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     *
     * @return Whether the advancedSettings field is set.
     */
    public boolean hasAdvancedSettings() {
      return advancedSettingsBuilder_ != null || advancedSettings_ != null;
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     *
     * @return The advancedSettings.
     */
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettings getAdvancedSettings() {
      if (advancedSettingsBuilder_ == null) {
        return advancedSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.AdvancedSettings.getDefaultInstance()
            : advancedSettings_;
      } else {
        return advancedSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     */
    public Builder setAdvancedSettings(com.google.cloud.dialogflow.cx.v3.AdvancedSettings value) {
      if (advancedSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        advancedSettings_ = value;
        onChanged();
      } else {
        advancedSettingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     */
    public Builder setAdvancedSettings(
        com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder builderForValue) {
      if (advancedSettingsBuilder_ == null) {
        advancedSettings_ = builderForValue.build();
        onChanged();
      } else {
        advancedSettingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     */
    public Builder mergeAdvancedSettings(com.google.cloud.dialogflow.cx.v3.AdvancedSettings value) {
      if (advancedSettingsBuilder_ == null) {
        if (advancedSettings_ != null) {
          advancedSettings_ =
              com.google.cloud.dialogflow.cx.v3.AdvancedSettings.newBuilder(advancedSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          advancedSettings_ = value;
        }
        onChanged();
      } else {
        advancedSettingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     */
    public Builder clearAdvancedSettings() {
      if (advancedSettingsBuilder_ == null) {
        advancedSettings_ = null;
        onChanged();
      } else {
        advancedSettings_ = null;
        advancedSettingsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder getAdvancedSettingsBuilder() {

      onChanged();
      return getAdvancedSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder
        getAdvancedSettingsOrBuilder() {
      if (advancedSettingsBuilder_ != null) {
        return advancedSettingsBuilder_.getMessageOrBuilder();
      } else {
        return advancedSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.AdvancedSettings.getDefaultInstance()
            : advancedSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder>
        getAdvancedSettingsFieldBuilder() {
      if (advancedSettingsBuilder_ == null) {
        advancedSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.AdvancedSettings,
                com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder,
                com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder>(
                getAdvancedSettings(), getParentForChildren(), isClean());
        advancedSettings_ = null;
      }
      return advancedSettingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Agent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Agent)
  private static final com.google.cloud.dialogflow.cx.v3.Agent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Agent();
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Agent> PARSER =
      new com.google.protobuf.AbstractParser<Agent>() {
        @java.lang.Override
        public Agent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Agent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Agent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Agent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
