/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/advanced_settings.proto

package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Hierarchical advanced settings for agent/flow/page/fulfillment/parameter.
 * Settings exposed at lower level overrides the settings exposed at higher
 * level. Overriding occurs at the sub-setting level. For example, the
 * playback_interruption_settings at fulfillment level only overrides the
 * playback_interruption_settings at the agent level, leaving other settings
 * at the agent level unchanged.
 * DTMF settings does not override each other. DTMF settings set at different
 * levels define DTMF detections running in parallel.
 * Hierarchy: Agent-&gt;Flow-&gt;Page-&gt;Fulfillment/Parameter.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.AdvancedSettings}
 */
public final class AdvancedSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.AdvancedSettings)
    AdvancedSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AdvancedSettings.newBuilder() to construct.
  private AdvancedSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AdvancedSettings() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AdvancedSettings();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.AdvancedSettingsProto
        .internal_static_google_cloud_dialogflow_cx_v3_AdvancedSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.AdvancedSettingsProto
        .internal_static_google_cloud_dialogflow_cx_v3_AdvancedSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings.class,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder.class);
  }

  public interface LoggingSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If true, StackDriver logging is currently enabled.
     * </pre>
     *
     * <code>bool enable_stackdriver_logging = 2;</code>
     *
     * @return The enableStackdriverLogging.
     */
    boolean getEnableStackdriverLogging();

    /**
     *
     *
     * <pre>
     * If true, DF Interaction logging is currently enabled.
     * </pre>
     *
     * <code>bool enable_interaction_logging = 3;</code>
     *
     * @return The enableInteractionLogging.
     */
    boolean getEnableInteractionLogging();
  }
  /**
   *
   *
   * <pre>
   * Define behaviors on logging.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings}
   */
  public static final class LoggingSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings)
      LoggingSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LoggingSettings.newBuilder() to construct.
    private LoggingSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LoggingSettings() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LoggingSettings();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3_AdvancedSettings_LoggingSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3_AdvancedSettings_LoggingSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings.class,
              com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings.Builder.class);
    }

    public static final int ENABLE_STACKDRIVER_LOGGING_FIELD_NUMBER = 2;
    private boolean enableStackdriverLogging_;
    /**
     *
     *
     * <pre>
     * If true, StackDriver logging is currently enabled.
     * </pre>
     *
     * <code>bool enable_stackdriver_logging = 2;</code>
     *
     * @return The enableStackdriverLogging.
     */
    @java.lang.Override
    public boolean getEnableStackdriverLogging() {
      return enableStackdriverLogging_;
    }

    public static final int ENABLE_INTERACTION_LOGGING_FIELD_NUMBER = 3;
    private boolean enableInteractionLogging_;
    /**
     *
     *
     * <pre>
     * If true, DF Interaction logging is currently enabled.
     * </pre>
     *
     * <code>bool enable_interaction_logging = 3;</code>
     *
     * @return The enableInteractionLogging.
     */
    @java.lang.Override
    public boolean getEnableInteractionLogging() {
      return enableInteractionLogging_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enableStackdriverLogging_ != false) {
        output.writeBool(2, enableStackdriverLogging_);
      }
      if (enableInteractionLogging_ != false) {
        output.writeBool(3, enableInteractionLogging_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enableStackdriverLogging_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, enableStackdriverLogging_);
      }
      if (enableInteractionLogging_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, enableInteractionLogging_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings other =
          (com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings) obj;

      if (getEnableStackdriverLogging() != other.getEnableStackdriverLogging()) return false;
      if (getEnableInteractionLogging() != other.getEnableInteractionLogging()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLE_STACKDRIVER_LOGGING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableStackdriverLogging());
      hash = (37 * hash) + ENABLE_INTERACTION_LOGGING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableInteractionLogging());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Define behaviors on logging.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings)
        com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3_AdvancedSettings_LoggingSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3_AdvancedSettings_LoggingSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings.class,
                com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        enableStackdriverLogging_ = false;

        enableInteractionLogging_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3_AdvancedSettings_LoggingSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings build() {
        com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings buildPartial() {
        com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings result =
            new com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings(this);
        result.enableStackdriverLogging_ = enableStackdriverLogging_;
        result.enableInteractionLogging_ = enableInteractionLogging_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings
                .getDefaultInstance()) return this;
        if (other.getEnableStackdriverLogging() != false) {
          setEnableStackdriverLogging(other.getEnableStackdriverLogging());
        }
        if (other.getEnableInteractionLogging() != false) {
          setEnableInteractionLogging(other.getEnableInteractionLogging());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 16:
                {
                  enableStackdriverLogging_ = input.readBool();

                  break;
                } // case 16
              case 24:
                {
                  enableInteractionLogging_ = input.readBool();

                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private boolean enableStackdriverLogging_;
      /**
       *
       *
       * <pre>
       * If true, StackDriver logging is currently enabled.
       * </pre>
       *
       * <code>bool enable_stackdriver_logging = 2;</code>
       *
       * @return The enableStackdriverLogging.
       */
      @java.lang.Override
      public boolean getEnableStackdriverLogging() {
        return enableStackdriverLogging_;
      }
      /**
       *
       *
       * <pre>
       * If true, StackDriver logging is currently enabled.
       * </pre>
       *
       * <code>bool enable_stackdriver_logging = 2;</code>
       *
       * @param value The enableStackdriverLogging to set.
       * @return This builder for chaining.
       */
      public Builder setEnableStackdriverLogging(boolean value) {

        enableStackdriverLogging_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true, StackDriver logging is currently enabled.
       * </pre>
       *
       * <code>bool enable_stackdriver_logging = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableStackdriverLogging() {

        enableStackdriverLogging_ = false;
        onChanged();
        return this;
      }

      private boolean enableInteractionLogging_;
      /**
       *
       *
       * <pre>
       * If true, DF Interaction logging is currently enabled.
       * </pre>
       *
       * <code>bool enable_interaction_logging = 3;</code>
       *
       * @return The enableInteractionLogging.
       */
      @java.lang.Override
      public boolean getEnableInteractionLogging() {
        return enableInteractionLogging_;
      }
      /**
       *
       *
       * <pre>
       * If true, DF Interaction logging is currently enabled.
       * </pre>
       *
       * <code>bool enable_interaction_logging = 3;</code>
       *
       * @param value The enableInteractionLogging to set.
       * @return This builder for chaining.
       */
      public Builder setEnableInteractionLogging(boolean value) {

        enableInteractionLogging_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true, DF Interaction logging is currently enabled.
       * </pre>
       *
       * <code>bool enable_interaction_logging = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableInteractionLogging() {

        enableInteractionLogging_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings)
    private static final com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings();
    }

    public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LoggingSettings> PARSER =
        new com.google.protobuf.AbstractParser<LoggingSettings>() {
          @java.lang.Override
          public LoggingSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LoggingSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LoggingSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int LOGGING_SETTINGS_FIELD_NUMBER = 6;
  private com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings loggingSettings_;
  /**
   *
   *
   * <pre>
   * Settings for logging.
   * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
   * and speech logging.
   * Exposed at the following levels:
   * - Agent level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings logging_settings = 6;
   * </code>
   *
   * @return Whether the loggingSettings field is set.
   */
  @java.lang.Override
  public boolean hasLoggingSettings() {
    return loggingSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings for logging.
   * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
   * and speech logging.
   * Exposed at the following levels:
   * - Agent level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings logging_settings = 6;
   * </code>
   *
   * @return The loggingSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings getLoggingSettings() {
    return loggingSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings.getDefaultInstance()
        : loggingSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings for logging.
   * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
   * and speech logging.
   * Exposed at the following levels:
   * - Agent level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings logging_settings = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettingsOrBuilder
      getLoggingSettingsOrBuilder() {
    return getLoggingSettings();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (loggingSettings_ != null) {
      output.writeMessage(6, getLoggingSettings());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (loggingSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getLoggingSettings());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.AdvancedSettings)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.AdvancedSettings other =
        (com.google.cloud.dialogflow.cx.v3.AdvancedSettings) obj;

    if (hasLoggingSettings() != other.hasLoggingSettings()) return false;
    if (hasLoggingSettings()) {
      if (!getLoggingSettings().equals(other.getLoggingSettings())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasLoggingSettings()) {
      hash = (37 * hash) + LOGGING_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getLoggingSettings().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.AdvancedSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Hierarchical advanced settings for agent/flow/page/fulfillment/parameter.
   * Settings exposed at lower level overrides the settings exposed at higher
   * level. Overriding occurs at the sub-setting level. For example, the
   * playback_interruption_settings at fulfillment level only overrides the
   * playback_interruption_settings at the agent level, leaving other settings
   * at the agent level unchanged.
   * DTMF settings does not override each other. DTMF settings set at different
   * levels define DTMF detections running in parallel.
   * Hierarchy: Agent-&gt;Flow-&gt;Page-&gt;Fulfillment/Parameter.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.AdvancedSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.AdvancedSettings)
      com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3_AdvancedSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3_AdvancedSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.AdvancedSettings.class,
              com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.AdvancedSettings.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (loggingSettingsBuilder_ == null) {
        loggingSettings_ = null;
      } else {
        loggingSettings_ = null;
        loggingSettingsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3_AdvancedSettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettings getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.AdvancedSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettings build() {
      com.google.cloud.dialogflow.cx.v3.AdvancedSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettings buildPartial() {
      com.google.cloud.dialogflow.cx.v3.AdvancedSettings result =
          new com.google.cloud.dialogflow.cx.v3.AdvancedSettings(this);
      if (loggingSettingsBuilder_ == null) {
        result.loggingSettings_ = loggingSettings_;
      } else {
        result.loggingSettings_ = loggingSettingsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.AdvancedSettings) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.AdvancedSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.AdvancedSettings other) {
      if (other == com.google.cloud.dialogflow.cx.v3.AdvancedSettings.getDefaultInstance())
        return this;
      if (other.hasLoggingSettings()) {
        mergeLoggingSettings(other.getLoggingSettings());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 50:
              {
                input.readMessage(getLoggingSettingsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings loggingSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettingsOrBuilder>
        loggingSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     *
     * @return Whether the loggingSettings field is set.
     */
    public boolean hasLoggingSettings() {
      return loggingSettingsBuilder_ != null || loggingSettings_ != null;
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     *
     * @return The loggingSettings.
     */
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings getLoggingSettings() {
      if (loggingSettingsBuilder_ == null) {
        return loggingSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings
                .getDefaultInstance()
            : loggingSettings_;
      } else {
        return loggingSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public Builder setLoggingSettings(
        com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings value) {
      if (loggingSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        loggingSettings_ = value;
        onChanged();
      } else {
        loggingSettingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public Builder setLoggingSettings(
        com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings.Builder
            builderForValue) {
      if (loggingSettingsBuilder_ == null) {
        loggingSettings_ = builderForValue.build();
        onChanged();
      } else {
        loggingSettingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public Builder mergeLoggingSettings(
        com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings value) {
      if (loggingSettingsBuilder_ == null) {
        if (loggingSettings_ != null) {
          loggingSettings_ =
              com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings.newBuilder(
                      loggingSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          loggingSettings_ = value;
        }
        onChanged();
      } else {
        loggingSettingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public Builder clearLoggingSettings() {
      if (loggingSettingsBuilder_ == null) {
        loggingSettings_ = null;
        onChanged();
      } else {
        loggingSettings_ = null;
        loggingSettingsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings.Builder
        getLoggingSettingsBuilder() {

      onChanged();
      return getLoggingSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettingsOrBuilder
        getLoggingSettingsOrBuilder() {
      if (loggingSettingsBuilder_ != null) {
        return loggingSettingsBuilder_.getMessageOrBuilder();
      } else {
        return loggingSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings
                .getDefaultInstance()
            : loggingSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettingsOrBuilder>
        getLoggingSettingsFieldBuilder() {
      if (loggingSettingsBuilder_ == null) {
        loggingSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings,
                com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings.Builder,
                com.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettingsOrBuilder>(
                getLoggingSettings(), getParentForChildren(), isClean());
        loggingSettings_ = null;
      }
      return loggingSettingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.AdvancedSettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.AdvancedSettings)
  private static final com.google.cloud.dialogflow.cx.v3.AdvancedSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.AdvancedSettings();
  }

  public static com.google.cloud.dialogflow.cx.v3.AdvancedSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdvancedSettings> PARSER =
      new com.google.protobuf.AbstractParser<AdvancedSettings>() {
        @java.lang.Override
        public AdvancedSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AdvancedSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdvancedSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.AdvancedSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
