/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RagFileName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RAG_CORPUS_RAG_FILE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/ragCorpora/{rag_corpus}/ragFiles/{rag_file}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String ragCorpus;
    private final String ragFile;

    @Deprecated
    protected RagFileName() {
        this.project = null;
        this.location = null;
        this.ragCorpus = null;
        this.ragFile = null;
    }

    private RagFileName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.ragCorpus = (String)Preconditions.checkNotNull((Object)builder.getRagCorpus());
        this.ragFile = (String)Preconditions.checkNotNull((Object)builder.getRagFile());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRagCorpus() {
        return this.ragCorpus;
    }

    public String getRagFile() {
        return this.ragFile;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RagFileName of(String project, String location, String ragCorpus, String ragFile) {
        return RagFileName.newBuilder().setProject(project).setLocation(location).setRagCorpus(ragCorpus).setRagFile(ragFile).build();
    }

    public static String format(String project, String location, String ragCorpus, String ragFile) {
        return RagFileName.newBuilder().setProject(project).setLocation(location).setRagCorpus(ragCorpus).setRagFile(ragFile).build().toString();
    }

    public static RagFileName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RAG_CORPUS_RAG_FILE.validatedMatch(formattedString, "RagFileName.parse: formattedString not in valid format");
        return RagFileName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("rag_corpus"), (String)matchMap.get("rag_file"));
    }

    public static List<RagFileName> parseList(List<String> formattedStrings) {
        ArrayList<RagFileName> list = new ArrayList<RagFileName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RagFileName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RagFileName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RagFileName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RAG_CORPUS_RAG_FILE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RagFileName ragFileName = this;
            synchronized (ragFileName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.ragCorpus != null) {
                        fieldMapBuilder.put((Object)"rag_corpus", (Object)this.ragCorpus);
                    }
                    if (this.ragFile != null) {
                        fieldMapBuilder.put((Object)"rag_file", (Object)this.ragFile);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RAG_CORPUS_RAG_FILE.instantiate(new String[]{"project", this.project, "location", this.location, "rag_corpus", this.ragCorpus, "rag_file", this.ragFile});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RagFileName that = (RagFileName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.ragCorpus, that.ragCorpus) && Objects.equals(this.ragFile, that.ragFile);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.ragCorpus);
        h *= 1000003;
        return h ^= Objects.hashCode(this.ragFile);
    }

    public static class Builder {
        private String project;
        private String location;
        private String ragCorpus;
        private String ragFile;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRagCorpus() {
            return this.ragCorpus;
        }

        public String getRagFile() {
            return this.ragFile;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRagCorpus(String ragCorpus) {
            this.ragCorpus = ragCorpus;
            return this;
        }

        public Builder setRagFile(String ragFile) {
            this.ragFile = ragFile;
            return this;
        }

        private Builder(RagFileName ragFileName) {
            this.project = ragFileName.project;
            this.location = ragFileName.location;
            this.ragCorpus = ragFileName.ragCorpus;
            this.ragFile = ragFileName.ragFile;
        }

        public RagFileName build() {
            return new RagFileName(this);
        }
    }
}

