/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CachedContentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CACHED_CONTENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/cachedContents/{cached_content}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cachedContent;

    @Deprecated
    protected CachedContentName() {
        this.project = null;
        this.location = null;
        this.cachedContent = null;
    }

    private CachedContentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cachedContent = (String)Preconditions.checkNotNull((Object)builder.getCachedContent());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCachedContent() {
        return this.cachedContent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CachedContentName of(String project, String location, String cachedContent) {
        return CachedContentName.newBuilder().setProject(project).setLocation(location).setCachedContent(cachedContent).build();
    }

    public static String format(String project, String location, String cachedContent) {
        return CachedContentName.newBuilder().setProject(project).setLocation(location).setCachedContent(cachedContent).build().toString();
    }

    public static CachedContentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CACHED_CONTENT.validatedMatch(formattedString, "CachedContentName.parse: formattedString not in valid format");
        return CachedContentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cached_content"));
    }

    public static List<CachedContentName> parseList(List<String> formattedStrings) {
        ArrayList<CachedContentName> list = new ArrayList<CachedContentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CachedContentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CachedContentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CachedContentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CACHED_CONTENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CachedContentName cachedContentName = this;
            synchronized (cachedContentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cachedContent != null) {
                        fieldMapBuilder.put((Object)"cached_content", (Object)this.cachedContent);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CACHED_CONTENT.instantiate(new String[]{"project", this.project, "location", this.location, "cached_content", this.cachedContent});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CachedContentName that = (CachedContentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cachedContent, that.cachedContent);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cachedContent);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cachedContent;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCachedContent() {
            return this.cachedContent;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCachedContent(String cachedContent) {
            this.cachedContent = cachedContent;
            return this;
        }

        private Builder(CachedContentName cachedContentName) {
            this.project = cachedContentName.project;
            this.location = cachedContentName.location;
            this.cachedContent = cachedContentName.cachedContent;
        }

        public CachedContentName build() {
            return new CachedContentName(this);
        }
    }
}

