/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/vertex_rag_data.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A RagFile contains user data for chunking, embedding and indexing.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagFile}
 */
public final class RagFile extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RagFile)
    RagFileOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RagFile.newBuilder() to construct.
  private RagFile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RagFile() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    ragFileType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RagFile();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1beta1_RagFile_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1beta1_RagFile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.RagFile.class,
            com.google.cloud.aiplatform.v1beta1.RagFile.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of the RagFile.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.RagFile.RagFileType}
   */
  public enum RagFileType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * RagFile type is unspecified.
     * </pre>
     *
     * <code>RAG_FILE_TYPE_UNSPECIFIED = 0;</code>
     */
    RAG_FILE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * RagFile type is TXT.
     * </pre>
     *
     * <code>RAG_FILE_TYPE_TXT = 1;</code>
     */
    RAG_FILE_TYPE_TXT(1),
    /**
     *
     *
     * <pre>
     * RagFile type is PDF.
     * </pre>
     *
     * <code>RAG_FILE_TYPE_PDF = 2;</code>
     */
    RAG_FILE_TYPE_PDF(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * RagFile type is unspecified.
     * </pre>
     *
     * <code>RAG_FILE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int RAG_FILE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * RagFile type is TXT.
     * </pre>
     *
     * <code>RAG_FILE_TYPE_TXT = 1;</code>
     */
    public static final int RAG_FILE_TYPE_TXT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * RagFile type is PDF.
     * </pre>
     *
     * <code>RAG_FILE_TYPE_PDF = 2;</code>
     */
    public static final int RAG_FILE_TYPE_PDF_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RagFileType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RagFileType forNumber(int value) {
      switch (value) {
        case 0:
          return RAG_FILE_TYPE_UNSPECIFIED;
        case 1:
          return RAG_FILE_TYPE_TXT;
        case 2:
          return RAG_FILE_TYPE_PDF;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RagFileType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RagFileType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RagFileType>() {
          public RagFileType findValueByNumber(int number) {
            return RagFileType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.RagFile.getDescriptor().getEnumTypes().get(0);
    }

    private static final RagFileType[] VALUES = values();

    public static RagFileType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RagFileType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.RagFile.RagFileType)
  }

  private int bitField0_;
  private int ragFileSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object ragFileSource_;

  public enum RagFileSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_SOURCE(8),
    GOOGLE_DRIVE_SOURCE(9),
    DIRECT_UPLOAD_SOURCE(10),
    SLACK_SOURCE(11),
    JIRA_SOURCE(12),
    SHARE_POINT_SOURCES(14),
    RAGFILESOURCE_NOT_SET(0);
    private final int value;

    private RagFileSourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RagFileSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static RagFileSourceCase forNumber(int value) {
      switch (value) {
        case 8:
          return GCS_SOURCE;
        case 9:
          return GOOGLE_DRIVE_SOURCE;
        case 10:
          return DIRECT_UPLOAD_SOURCE;
        case 11:
          return SLACK_SOURCE;
        case 12:
          return JIRA_SOURCE;
        case 14:
          return SHARE_POINT_SOURCES;
        case 0:
          return RAGFILESOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RagFileSourceCase getRagFileSourceCase() {
    return RagFileSourceCase.forNumber(ragFileSourceCase_);
  }

  public static final int GCS_SOURCE_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Output only. Google Cloud Storage location of the RagFile.
   * It does not support wildcards in the Cloud Storage uri for now.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the gcsSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsSource() {
    return ragFileSourceCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Output only. Google Cloud Storage location of the RagFile.
   * It does not support wildcards in the Cloud Storage uri for now.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The gcsSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource() {
    if (ragFileSourceCase_ == 8) {
      return (com.google.cloud.aiplatform.v1beta1.GcsSource) ragFileSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Google Cloud Storage location of the RagFile.
   * It does not support wildcards in the Cloud Storage uri for now.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
    if (ragFileSourceCase_ == 8) {
      return (com.google.cloud.aiplatform.v1beta1.GcsSource) ragFileSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
  }

  public static final int GOOGLE_DRIVE_SOURCE_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Output only. Google Drive location. Supports importing individual files
   * as well as Google Drive folders.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the googleDriveSource field is set.
   */
  @java.lang.Override
  public boolean hasGoogleDriveSource() {
    return ragFileSourceCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Output only. Google Drive location. Supports importing individual files
   * as well as Google Drive folders.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The googleDriveSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource getGoogleDriveSource() {
    if (ragFileSourceCase_ == 9) {
      return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) ragFileSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Google Drive location. Supports importing individual files
   * as well as Google Drive folders.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder
      getGoogleDriveSourceOrBuilder() {
    if (ragFileSourceCase_ == 9) {
      return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) ragFileSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
  }

  public static final int DIRECT_UPLOAD_SOURCE_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Output only. The RagFile is encapsulated and uploaded in the
   * UploadRagFile request.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DirectUploadSource direct_upload_source = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the directUploadSource field is set.
   */
  @java.lang.Override
  public boolean hasDirectUploadSource() {
    return ragFileSourceCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Output only. The RagFile is encapsulated and uploaded in the
   * UploadRagFile request.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DirectUploadSource direct_upload_source = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The directUploadSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DirectUploadSource getDirectUploadSource() {
    if (ragFileSourceCase_ == 10) {
      return (com.google.cloud.aiplatform.v1beta1.DirectUploadSource) ragFileSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.DirectUploadSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. The RagFile is encapsulated and uploaded in the
   * UploadRagFile request.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.DirectUploadSource direct_upload_source = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.DirectUploadSourceOrBuilder
      getDirectUploadSourceOrBuilder() {
    if (ragFileSourceCase_ == 10) {
      return (com.google.cloud.aiplatform.v1beta1.DirectUploadSource) ragFileSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.DirectUploadSource.getDefaultInstance();
  }

  public static final int SLACK_SOURCE_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * The RagFile is imported from a Slack channel.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 11;</code>
   *
   * @return Whether the slackSource field is set.
   */
  @java.lang.Override
  public boolean hasSlackSource() {
    return ragFileSourceCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * The RagFile is imported from a Slack channel.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 11;</code>
   *
   * @return The slackSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SlackSource getSlackSource() {
    if (ragFileSourceCase_ == 11) {
      return (com.google.cloud.aiplatform.v1beta1.SlackSource) ragFileSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The RagFile is imported from a Slack channel.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder getSlackSourceOrBuilder() {
    if (ragFileSourceCase_ == 11) {
      return (com.google.cloud.aiplatform.v1beta1.SlackSource) ragFileSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
  }

  public static final int JIRA_SOURCE_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * The RagFile is imported from a Jira query.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 12;</code>
   *
   * @return Whether the jiraSource field is set.
   */
  @java.lang.Override
  public boolean hasJiraSource() {
    return ragFileSourceCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * The RagFile is imported from a Jira query.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 12;</code>
   *
   * @return The jiraSource.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JiraSource getJiraSource() {
    if (ragFileSourceCase_ == 12) {
      return (com.google.cloud.aiplatform.v1beta1.JiraSource) ragFileSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The RagFile is imported from a Jira query.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder getJiraSourceOrBuilder() {
    if (ragFileSourceCase_ == 12) {
      return (com.google.cloud.aiplatform.v1beta1.JiraSource) ragFileSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
  }

  public static final int SHARE_POINT_SOURCES_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * The RagFile is imported from a SharePoint source.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 14;</code>
   *
   * @return Whether the sharePointSources field is set.
   */
  @java.lang.Override
  public boolean hasSharePointSources() {
    return ragFileSourceCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * The RagFile is imported from a SharePoint source.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 14;</code>
   *
   * @return The sharePointSources.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SharePointSources getSharePointSources() {
    if (ragFileSourceCase_ == 14) {
      return (com.google.cloud.aiplatform.v1beta1.SharePointSources) ragFileSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The RagFile is imported from a SharePoint source.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SharePointSourcesOrBuilder
      getSharePointSourcesOrBuilder() {
    if (ragFileSourceCase_ == 14) {
      return (com.google.cloud.aiplatform.v1beta1.SharePointSources) ragFileSource_;
    }
    return com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the RagFile.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the RagFile.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The display name of the RagFile.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the RagFile.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The description of the RagFile.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The description of the RagFile.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SIZE_BYTES_FIELD_NUMBER = 4;
  private long sizeBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The size of the RagFile in bytes.
   * </pre>
   *
   * <code>int64 size_bytes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The sizeBytes.
   */
  @java.lang.Override
  public long getSizeBytes() {
    return sizeBytes_;
  }

  public static final int RAG_FILE_TYPE_FIELD_NUMBER = 5;
  private int ragFileType_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The type of the RagFile.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFile.RagFileType rag_file_type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for ragFileType.
   */
  @java.lang.Override
  public int getRagFileTypeValue() {
    return ragFileType_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The type of the RagFile.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFile.RagFileType rag_file_type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The ragFileType.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagFile.RagFileType getRagFileType() {
    com.google.cloud.aiplatform.v1beta1.RagFile.RagFileType result =
        com.google.cloud.aiplatform.v1beta1.RagFile.RagFileType.forNumber(ragFileType_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.RagFile.RagFileType.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this RagFile was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this RagFile was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this RagFile was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this RagFile was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this RagFile was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this RagFile was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int FILE_STATUS_FIELD_NUMBER = 13;
  private com.google.cloud.aiplatform.v1beta1.FileStatus fileStatus_;
  /**
   *
   *
   * <pre>
   * Output only. State of the RagFile.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FileStatus file_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the fileStatus field is set.
   */
  @java.lang.Override
  public boolean hasFileStatus() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the RagFile.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FileStatus file_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The fileStatus.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FileStatus getFileStatus() {
    return fileStatus_ == null
        ? com.google.cloud.aiplatform.v1beta1.FileStatus.getDefaultInstance()
        : fileStatus_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the RagFile.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.FileStatus file_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FileStatusOrBuilder getFileStatusOrBuilder() {
    return fileStatus_ == null
        ? com.google.cloud.aiplatform.v1beta1.FileStatus.getDefaultInstance()
        : fileStatus_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (sizeBytes_ != 0L) {
      output.writeInt64(4, sizeBytes_);
    }
    if (ragFileType_
        != com.google.cloud.aiplatform.v1beta1.RagFile.RagFileType.RAG_FILE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, ragFileType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getUpdateTime());
    }
    if (ragFileSourceCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.aiplatform.v1beta1.GcsSource) ragFileSource_);
    }
    if (ragFileSourceCase_ == 9) {
      output.writeMessage(
          9, (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) ragFileSource_);
    }
    if (ragFileSourceCase_ == 10) {
      output.writeMessage(
          10, (com.google.cloud.aiplatform.v1beta1.DirectUploadSource) ragFileSource_);
    }
    if (ragFileSourceCase_ == 11) {
      output.writeMessage(11, (com.google.cloud.aiplatform.v1beta1.SlackSource) ragFileSource_);
    }
    if (ragFileSourceCase_ == 12) {
      output.writeMessage(12, (com.google.cloud.aiplatform.v1beta1.JiraSource) ragFileSource_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(13, getFileStatus());
    }
    if (ragFileSourceCase_ == 14) {
      output.writeMessage(
          14, (com.google.cloud.aiplatform.v1beta1.SharePointSources) ragFileSource_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (sizeBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, sizeBytes_);
    }
    if (ragFileType_
        != com.google.cloud.aiplatform.v1beta1.RagFile.RagFileType.RAG_FILE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, ragFileType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateTime());
    }
    if (ragFileSourceCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.aiplatform.v1beta1.GcsSource) ragFileSource_);
    }
    if (ragFileSourceCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) ragFileSource_);
    }
    if (ragFileSourceCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.aiplatform.v1beta1.DirectUploadSource) ragFileSource_);
    }
    if (ragFileSourceCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.aiplatform.v1beta1.SlackSource) ragFileSource_);
    }
    if (ragFileSourceCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.aiplatform.v1beta1.JiraSource) ragFileSource_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getFileStatus());
    }
    if (ragFileSourceCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.cloud.aiplatform.v1beta1.SharePointSources) ragFileSource_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RagFile)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.RagFile other =
        (com.google.cloud.aiplatform.v1beta1.RagFile) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (getSizeBytes() != other.getSizeBytes()) return false;
    if (ragFileType_ != other.ragFileType_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasFileStatus() != other.hasFileStatus()) return false;
    if (hasFileStatus()) {
      if (!getFileStatus().equals(other.getFileStatus())) return false;
    }
    if (!getRagFileSourceCase().equals(other.getRagFileSourceCase())) return false;
    switch (ragFileSourceCase_) {
      case 8:
        if (!getGcsSource().equals(other.getGcsSource())) return false;
        break;
      case 9:
        if (!getGoogleDriveSource().equals(other.getGoogleDriveSource())) return false;
        break;
      case 10:
        if (!getDirectUploadSource().equals(other.getDirectUploadSource())) return false;
        break;
      case 11:
        if (!getSlackSource().equals(other.getSlackSource())) return false;
        break;
      case 12:
        if (!getJiraSource().equals(other.getJiraSource())) return false;
        break;
      case 14:
        if (!getSharePointSources().equals(other.getSharePointSources())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + SIZE_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSizeBytes());
    hash = (37 * hash) + RAG_FILE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + ragFileType_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasFileStatus()) {
      hash = (37 * hash) + FILE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getFileStatus().hashCode();
    }
    switch (ragFileSourceCase_) {
      case 8:
        hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsSource().hashCode();
        break;
      case 9:
        hash = (37 * hash) + GOOGLE_DRIVE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGoogleDriveSource().hashCode();
        break;
      case 10:
        hash = (37 * hash) + DIRECT_UPLOAD_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getDirectUploadSource().hashCode();
        break;
      case 11:
        hash = (37 * hash) + SLACK_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getSlackSource().hashCode();
        break;
      case 12:
        hash = (37 * hash) + JIRA_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getJiraSource().hashCode();
        break;
      case 14:
        hash = (37 * hash) + SHARE_POINT_SOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getSharePointSources().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFile parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFile parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFile parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFile parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFile parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFile parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFile parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFile parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFile parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.RagFile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A RagFile contains user data for chunking, embedding and indexing.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RagFile}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RagFile)
      com.google.cloud.aiplatform.v1beta1.RagFileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagFile_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagFile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RagFile.class,
              com.google.cloud.aiplatform.v1beta1.RagFile.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.RagFile.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getFileStatusFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gcsSourceBuilder_ != null) {
        gcsSourceBuilder_.clear();
      }
      if (googleDriveSourceBuilder_ != null) {
        googleDriveSourceBuilder_.clear();
      }
      if (directUploadSourceBuilder_ != null) {
        directUploadSourceBuilder_.clear();
      }
      if (slackSourceBuilder_ != null) {
        slackSourceBuilder_.clear();
      }
      if (jiraSourceBuilder_ != null) {
        jiraSourceBuilder_.clear();
      }
      if (sharePointSourcesBuilder_ != null) {
        sharePointSourcesBuilder_.clear();
      }
      name_ = "";
      displayName_ = "";
      description_ = "";
      sizeBytes_ = 0L;
      ragFileType_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      fileStatus_ = null;
      if (fileStatusBuilder_ != null) {
        fileStatusBuilder_.dispose();
        fileStatusBuilder_ = null;
      }
      ragFileSourceCase_ = 0;
      ragFileSource_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1beta1_RagFile_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagFile getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.RagFile.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagFile build() {
      com.google.cloud.aiplatform.v1beta1.RagFile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagFile buildPartial() {
      com.google.cloud.aiplatform.v1beta1.RagFile result =
          new com.google.cloud.aiplatform.v1beta1.RagFile(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.RagFile result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.sizeBytes_ = sizeBytes_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.ragFileType_ = ragFileType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.fileStatus_ = fileStatusBuilder_ == null ? fileStatus_ : fileStatusBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.RagFile result) {
      result.ragFileSourceCase_ = ragFileSourceCase_;
      result.ragFileSource_ = this.ragFileSource_;
      if (ragFileSourceCase_ == 8 && gcsSourceBuilder_ != null) {
        result.ragFileSource_ = gcsSourceBuilder_.build();
      }
      if (ragFileSourceCase_ == 9 && googleDriveSourceBuilder_ != null) {
        result.ragFileSource_ = googleDriveSourceBuilder_.build();
      }
      if (ragFileSourceCase_ == 10 && directUploadSourceBuilder_ != null) {
        result.ragFileSource_ = directUploadSourceBuilder_.build();
      }
      if (ragFileSourceCase_ == 11 && slackSourceBuilder_ != null) {
        result.ragFileSource_ = slackSourceBuilder_.build();
      }
      if (ragFileSourceCase_ == 12 && jiraSourceBuilder_ != null) {
        result.ragFileSource_ = jiraSourceBuilder_.build();
      }
      if (ragFileSourceCase_ == 14 && sharePointSourcesBuilder_ != null) {
        result.ragFileSource_ = sharePointSourcesBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.RagFile) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.RagFile) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.RagFile other) {
      if (other == com.google.cloud.aiplatform.v1beta1.RagFile.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.getSizeBytes() != 0L) {
        setSizeBytes(other.getSizeBytes());
      }
      if (other.ragFileType_ != 0) {
        setRagFileTypeValue(other.getRagFileTypeValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasFileStatus()) {
        mergeFileStatus(other.getFileStatus());
      }
      switch (other.getRagFileSourceCase()) {
        case GCS_SOURCE:
          {
            mergeGcsSource(other.getGcsSource());
            break;
          }
        case GOOGLE_DRIVE_SOURCE:
          {
            mergeGoogleDriveSource(other.getGoogleDriveSource());
            break;
          }
        case DIRECT_UPLOAD_SOURCE:
          {
            mergeDirectUploadSource(other.getDirectUploadSource());
            break;
          }
        case SLACK_SOURCE:
          {
            mergeSlackSource(other.getSlackSource());
            break;
          }
        case JIRA_SOURCE:
          {
            mergeJiraSource(other.getJiraSource());
            break;
          }
        case SHARE_POINT_SOURCES:
          {
            mergeSharePointSources(other.getSharePointSources());
            break;
          }
        case RAGFILESOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 26
            case 32:
              {
                sizeBytes_ = input.readInt64();
                bitField0_ |= 0x00000200;
                break;
              } // case 32
            case 40:
              {
                ragFileType_ = input.readEnum();
                bitField0_ |= 0x00000400;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                ragFileSourceCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getGoogleDriveSourceFieldBuilder().getBuilder(), extensionRegistry);
                ragFileSourceCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getDirectUploadSourceFieldBuilder().getBuilder(), extensionRegistry);
                ragFileSourceCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getSlackSourceFieldBuilder().getBuilder(), extensionRegistry);
                ragFileSourceCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getJiraSourceFieldBuilder().getBuilder(), extensionRegistry);
                ragFileSourceCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getFileStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getSharePointSourcesFieldBuilder().getBuilder(), extensionRegistry);
                ragFileSourceCase_ = 14;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int ragFileSourceCase_ = 0;
    private java.lang.Object ragFileSource_;

    public RagFileSourceCase getRagFileSourceCase() {
      return RagFileSourceCase.forNumber(ragFileSourceCase_);
    }

    public Builder clearRagFileSource() {
      ragFileSourceCase_ = 0;
      ragFileSource_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsSource,
            com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
        gcsSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Google Cloud Storage location of the RagFile.
     * It does not support wildcards in the Cloud Storage uri for now.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return ragFileSourceCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Cloud Storage location of the RagFile.
     * It does not support wildcards in the Cloud Storage uri for now.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (ragFileSourceCase_ == 8) {
          return (com.google.cloud.aiplatform.v1beta1.GcsSource) ragFileSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
      } else {
        if (ragFileSourceCase_ == 8) {
          return gcsSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Cloud Storage location of the RagFile.
     * It does not support wildcards in the Cloud Storage uri for now.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGcsSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ragFileSource_ = value;
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(value);
      }
      ragFileSourceCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Cloud Storage location of the RagFile.
     * It does not support wildcards in the Cloud Storage uri for now.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGcsSource(
        com.google.cloud.aiplatform.v1beta1.GcsSource.Builder builderForValue) {
      if (gcsSourceBuilder_ == null) {
        ragFileSource_ = builderForValue.build();
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(builderForValue.build());
      }
      ragFileSourceCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Cloud Storage location of the RagFile.
     * It does not support wildcards in the Cloud Storage uri for now.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeGcsSource(com.google.cloud.aiplatform.v1beta1.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (ragFileSourceCase_ == 8
            && ragFileSource_
                != com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance()) {
          ragFileSource_ =
              com.google.cloud.aiplatform.v1beta1.GcsSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GcsSource) ragFileSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          ragFileSource_ = value;
        }
        onChanged();
      } else {
        if (ragFileSourceCase_ == 8) {
          gcsSourceBuilder_.mergeFrom(value);
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
      }
      ragFileSourceCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Cloud Storage location of the RagFile.
     * It does not support wildcards in the Cloud Storage uri for now.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (ragFileSourceCase_ == 8) {
          ragFileSourceCase_ = 0;
          ragFileSource_ = null;
          onChanged();
        }
      } else {
        if (ragFileSourceCase_ == 8) {
          ragFileSourceCase_ = 0;
          ragFileSource_ = null;
        }
        gcsSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Cloud Storage location of the RagFile.
     * It does not support wildcards in the Cloud Storage uri for now.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsSource.Builder getGcsSourceBuilder() {
      return getGcsSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Cloud Storage location of the RagFile.
     * It does not support wildcards in the Cloud Storage uri for now.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
      if ((ragFileSourceCase_ == 8) && (gcsSourceBuilder_ != null)) {
        return gcsSourceBuilder_.getMessageOrBuilder();
      } else {
        if (ragFileSourceCase_ == 8) {
          return (com.google.cloud.aiplatform.v1beta1.GcsSource) ragFileSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Cloud Storage location of the RagFile.
     * It does not support wildcards in the Cloud Storage uri for now.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsSource,
            com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>
        getGcsSourceFieldBuilder() {
      if (gcsSourceBuilder_ == null) {
        if (!(ragFileSourceCase_ == 8)) {
          ragFileSource_ = com.google.cloud.aiplatform.v1beta1.GcsSource.getDefaultInstance();
        }
        gcsSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsSource,
                com.google.cloud.aiplatform.v1beta1.GcsSource.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GcsSource) ragFileSource_,
                getParentForChildren(),
                isClean());
        ragFileSource_ = null;
      }
      ragFileSourceCase_ = 8;
      onChanged();
      return gcsSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder>
        googleDriveSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Google Drive location. Supports importing individual files
     * as well as Google Drive folders.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the googleDriveSource field is set.
     */
    @java.lang.Override
    public boolean hasGoogleDriveSource() {
      return ragFileSourceCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Drive location. Supports importing individual files
     * as well as Google Drive folders.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The googleDriveSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource getGoogleDriveSource() {
      if (googleDriveSourceBuilder_ == null) {
        if (ragFileSourceCase_ == 9) {
          return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) ragFileSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
      } else {
        if (ragFileSourceCase_ == 9) {
          return googleDriveSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Drive location. Supports importing individual files
     * as well as Google Drive folders.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGoogleDriveSource(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource value) {
      if (googleDriveSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ragFileSource_ = value;
        onChanged();
      } else {
        googleDriveSourceBuilder_.setMessage(value);
      }
      ragFileSourceCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Drive location. Supports importing individual files
     * as well as Google Drive folders.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGoogleDriveSource(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder builderForValue) {
      if (googleDriveSourceBuilder_ == null) {
        ragFileSource_ = builderForValue.build();
        onChanged();
      } else {
        googleDriveSourceBuilder_.setMessage(builderForValue.build());
      }
      ragFileSourceCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Drive location. Supports importing individual files
     * as well as Google Drive folders.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeGoogleDriveSource(
        com.google.cloud.aiplatform.v1beta1.GoogleDriveSource value) {
      if (googleDriveSourceBuilder_ == null) {
        if (ragFileSourceCase_ == 9
            && ragFileSource_
                != com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance()) {
          ragFileSource_ =
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) ragFileSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          ragFileSource_ = value;
        }
        onChanged();
      } else {
        if (ragFileSourceCase_ == 9) {
          googleDriveSourceBuilder_.mergeFrom(value);
        } else {
          googleDriveSourceBuilder_.setMessage(value);
        }
      }
      ragFileSourceCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Drive location. Supports importing individual files
     * as well as Google Drive folders.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearGoogleDriveSource() {
      if (googleDriveSourceBuilder_ == null) {
        if (ragFileSourceCase_ == 9) {
          ragFileSourceCase_ = 0;
          ragFileSource_ = null;
          onChanged();
        }
      } else {
        if (ragFileSourceCase_ == 9) {
          ragFileSourceCase_ = 0;
          ragFileSource_ = null;
        }
        googleDriveSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Drive location. Supports importing individual files
     * as well as Google Drive folders.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder
        getGoogleDriveSourceBuilder() {
      return getGoogleDriveSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Drive location. Supports importing individual files
     * as well as Google Drive folders.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder
        getGoogleDriveSourceOrBuilder() {
      if ((ragFileSourceCase_ == 9) && (googleDriveSourceBuilder_ != null)) {
        return googleDriveSourceBuilder_.getMessageOrBuilder();
      } else {
        if (ragFileSourceCase_ == 9) {
          return (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) ragFileSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Google Drive location. Supports importing individual files
     * as well as Google Drive folders.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder,
            com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder>
        getGoogleDriveSourceFieldBuilder() {
      if (googleDriveSourceBuilder_ == null) {
        if (!(ragFileSourceCase_ == 9)) {
          ragFileSource_ =
              com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.getDefaultInstance();
        }
        googleDriveSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource,
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSource.Builder,
                com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.GoogleDriveSource) ragFileSource_,
                getParentForChildren(),
                isClean());
        ragFileSource_ = null;
      }
      ragFileSourceCase_ = 9;
      onChanged();
      return googleDriveSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DirectUploadSource,
            com.google.cloud.aiplatform.v1beta1.DirectUploadSource.Builder,
            com.google.cloud.aiplatform.v1beta1.DirectUploadSourceOrBuilder>
        directUploadSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The RagFile is encapsulated and uploaded in the
     * UploadRagFile request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DirectUploadSource direct_upload_source = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the directUploadSource field is set.
     */
    @java.lang.Override
    public boolean hasDirectUploadSource() {
      return ragFileSourceCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Output only. The RagFile is encapsulated and uploaded in the
     * UploadRagFile request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DirectUploadSource direct_upload_source = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The directUploadSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DirectUploadSource getDirectUploadSource() {
      if (directUploadSourceBuilder_ == null) {
        if (ragFileSourceCase_ == 10) {
          return (com.google.cloud.aiplatform.v1beta1.DirectUploadSource) ragFileSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.DirectUploadSource.getDefaultInstance();
      } else {
        if (ragFileSourceCase_ == 10) {
          return directUploadSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.DirectUploadSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The RagFile is encapsulated and uploaded in the
     * UploadRagFile request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DirectUploadSource direct_upload_source = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDirectUploadSource(
        com.google.cloud.aiplatform.v1beta1.DirectUploadSource value) {
      if (directUploadSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ragFileSource_ = value;
        onChanged();
      } else {
        directUploadSourceBuilder_.setMessage(value);
      }
      ragFileSourceCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The RagFile is encapsulated and uploaded in the
     * UploadRagFile request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DirectUploadSource direct_upload_source = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDirectUploadSource(
        com.google.cloud.aiplatform.v1beta1.DirectUploadSource.Builder builderForValue) {
      if (directUploadSourceBuilder_ == null) {
        ragFileSource_ = builderForValue.build();
        onChanged();
      } else {
        directUploadSourceBuilder_.setMessage(builderForValue.build());
      }
      ragFileSourceCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The RagFile is encapsulated and uploaded in the
     * UploadRagFile request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DirectUploadSource direct_upload_source = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDirectUploadSource(
        com.google.cloud.aiplatform.v1beta1.DirectUploadSource value) {
      if (directUploadSourceBuilder_ == null) {
        if (ragFileSourceCase_ == 10
            && ragFileSource_
                != com.google.cloud.aiplatform.v1beta1.DirectUploadSource.getDefaultInstance()) {
          ragFileSource_ =
              com.google.cloud.aiplatform.v1beta1.DirectUploadSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.DirectUploadSource) ragFileSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          ragFileSource_ = value;
        }
        onChanged();
      } else {
        if (ragFileSourceCase_ == 10) {
          directUploadSourceBuilder_.mergeFrom(value);
        } else {
          directUploadSourceBuilder_.setMessage(value);
        }
      }
      ragFileSourceCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The RagFile is encapsulated and uploaded in the
     * UploadRagFile request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DirectUploadSource direct_upload_source = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDirectUploadSource() {
      if (directUploadSourceBuilder_ == null) {
        if (ragFileSourceCase_ == 10) {
          ragFileSourceCase_ = 0;
          ragFileSource_ = null;
          onChanged();
        }
      } else {
        if (ragFileSourceCase_ == 10) {
          ragFileSourceCase_ = 0;
          ragFileSource_ = null;
        }
        directUploadSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The RagFile is encapsulated and uploaded in the
     * UploadRagFile request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DirectUploadSource direct_upload_source = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.DirectUploadSource.Builder
        getDirectUploadSourceBuilder() {
      return getDirectUploadSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The RagFile is encapsulated and uploaded in the
     * UploadRagFile request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DirectUploadSource direct_upload_source = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.DirectUploadSourceOrBuilder
        getDirectUploadSourceOrBuilder() {
      if ((ragFileSourceCase_ == 10) && (directUploadSourceBuilder_ != null)) {
        return directUploadSourceBuilder_.getMessageOrBuilder();
      } else {
        if (ragFileSourceCase_ == 10) {
          return (com.google.cloud.aiplatform.v1beta1.DirectUploadSource) ragFileSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.DirectUploadSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The RagFile is encapsulated and uploaded in the
     * UploadRagFile request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.DirectUploadSource direct_upload_source = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.DirectUploadSource,
            com.google.cloud.aiplatform.v1beta1.DirectUploadSource.Builder,
            com.google.cloud.aiplatform.v1beta1.DirectUploadSourceOrBuilder>
        getDirectUploadSourceFieldBuilder() {
      if (directUploadSourceBuilder_ == null) {
        if (!(ragFileSourceCase_ == 10)) {
          ragFileSource_ =
              com.google.cloud.aiplatform.v1beta1.DirectUploadSource.getDefaultInstance();
        }
        directUploadSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DirectUploadSource,
                com.google.cloud.aiplatform.v1beta1.DirectUploadSource.Builder,
                com.google.cloud.aiplatform.v1beta1.DirectUploadSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.DirectUploadSource) ragFileSource_,
                getParentForChildren(),
                isClean());
        ragFileSource_ = null;
      }
      ragFileSourceCase_ = 10;
      onChanged();
      return directUploadSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SlackSource,
            com.google.cloud.aiplatform.v1beta1.SlackSource.Builder,
            com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder>
        slackSourceBuilder_;
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Slack channel.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 11;</code>
     *
     * @return Whether the slackSource field is set.
     */
    @java.lang.Override
    public boolean hasSlackSource() {
      return ragFileSourceCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Slack channel.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 11;</code>
     *
     * @return The slackSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SlackSource getSlackSource() {
      if (slackSourceBuilder_ == null) {
        if (ragFileSourceCase_ == 11) {
          return (com.google.cloud.aiplatform.v1beta1.SlackSource) ragFileSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
      } else {
        if (ragFileSourceCase_ == 11) {
          return slackSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Slack channel.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 11;</code>
     */
    public Builder setSlackSource(com.google.cloud.aiplatform.v1beta1.SlackSource value) {
      if (slackSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ragFileSource_ = value;
        onChanged();
      } else {
        slackSourceBuilder_.setMessage(value);
      }
      ragFileSourceCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Slack channel.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 11;</code>
     */
    public Builder setSlackSource(
        com.google.cloud.aiplatform.v1beta1.SlackSource.Builder builderForValue) {
      if (slackSourceBuilder_ == null) {
        ragFileSource_ = builderForValue.build();
        onChanged();
      } else {
        slackSourceBuilder_.setMessage(builderForValue.build());
      }
      ragFileSourceCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Slack channel.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 11;</code>
     */
    public Builder mergeSlackSource(com.google.cloud.aiplatform.v1beta1.SlackSource value) {
      if (slackSourceBuilder_ == null) {
        if (ragFileSourceCase_ == 11
            && ragFileSource_
                != com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance()) {
          ragFileSource_ =
              com.google.cloud.aiplatform.v1beta1.SlackSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.SlackSource) ragFileSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          ragFileSource_ = value;
        }
        onChanged();
      } else {
        if (ragFileSourceCase_ == 11) {
          slackSourceBuilder_.mergeFrom(value);
        } else {
          slackSourceBuilder_.setMessage(value);
        }
      }
      ragFileSourceCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Slack channel.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 11;</code>
     */
    public Builder clearSlackSource() {
      if (slackSourceBuilder_ == null) {
        if (ragFileSourceCase_ == 11) {
          ragFileSourceCase_ = 0;
          ragFileSource_ = null;
          onChanged();
        }
      } else {
        if (ragFileSourceCase_ == 11) {
          ragFileSourceCase_ = 0;
          ragFileSource_ = null;
        }
        slackSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Slack channel.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 11;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SlackSource.Builder getSlackSourceBuilder() {
      return getSlackSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Slack channel.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 11;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder getSlackSourceOrBuilder() {
      if ((ragFileSourceCase_ == 11) && (slackSourceBuilder_ != null)) {
        return slackSourceBuilder_.getMessageOrBuilder();
      } else {
        if (ragFileSourceCase_ == 11) {
          return (com.google.cloud.aiplatform.v1beta1.SlackSource) ragFileSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Slack channel.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SlackSource,
            com.google.cloud.aiplatform.v1beta1.SlackSource.Builder,
            com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder>
        getSlackSourceFieldBuilder() {
      if (slackSourceBuilder_ == null) {
        if (!(ragFileSourceCase_ == 11)) {
          ragFileSource_ = com.google.cloud.aiplatform.v1beta1.SlackSource.getDefaultInstance();
        }
        slackSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SlackSource,
                com.google.cloud.aiplatform.v1beta1.SlackSource.Builder,
                com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.SlackSource) ragFileSource_,
                getParentForChildren(),
                isClean());
        ragFileSource_ = null;
      }
      ragFileSourceCase_ = 11;
      onChanged();
      return slackSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.JiraSource,
            com.google.cloud.aiplatform.v1beta1.JiraSource.Builder,
            com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder>
        jiraSourceBuilder_;
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Jira query.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 12;</code>
     *
     * @return Whether the jiraSource field is set.
     */
    @java.lang.Override
    public boolean hasJiraSource() {
      return ragFileSourceCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Jira query.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 12;</code>
     *
     * @return The jiraSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JiraSource getJiraSource() {
      if (jiraSourceBuilder_ == null) {
        if (ragFileSourceCase_ == 12) {
          return (com.google.cloud.aiplatform.v1beta1.JiraSource) ragFileSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
      } else {
        if (ragFileSourceCase_ == 12) {
          return jiraSourceBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Jira query.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 12;</code>
     */
    public Builder setJiraSource(com.google.cloud.aiplatform.v1beta1.JiraSource value) {
      if (jiraSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ragFileSource_ = value;
        onChanged();
      } else {
        jiraSourceBuilder_.setMessage(value);
      }
      ragFileSourceCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Jira query.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 12;</code>
     */
    public Builder setJiraSource(
        com.google.cloud.aiplatform.v1beta1.JiraSource.Builder builderForValue) {
      if (jiraSourceBuilder_ == null) {
        ragFileSource_ = builderForValue.build();
        onChanged();
      } else {
        jiraSourceBuilder_.setMessage(builderForValue.build());
      }
      ragFileSourceCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Jira query.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 12;</code>
     */
    public Builder mergeJiraSource(com.google.cloud.aiplatform.v1beta1.JiraSource value) {
      if (jiraSourceBuilder_ == null) {
        if (ragFileSourceCase_ == 12
            && ragFileSource_
                != com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance()) {
          ragFileSource_ =
              com.google.cloud.aiplatform.v1beta1.JiraSource.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.JiraSource) ragFileSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          ragFileSource_ = value;
        }
        onChanged();
      } else {
        if (ragFileSourceCase_ == 12) {
          jiraSourceBuilder_.mergeFrom(value);
        } else {
          jiraSourceBuilder_.setMessage(value);
        }
      }
      ragFileSourceCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Jira query.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 12;</code>
     */
    public Builder clearJiraSource() {
      if (jiraSourceBuilder_ == null) {
        if (ragFileSourceCase_ == 12) {
          ragFileSourceCase_ = 0;
          ragFileSource_ = null;
          onChanged();
        }
      } else {
        if (ragFileSourceCase_ == 12) {
          ragFileSourceCase_ = 0;
          ragFileSource_ = null;
        }
        jiraSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Jira query.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 12;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.JiraSource.Builder getJiraSourceBuilder() {
      return getJiraSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Jira query.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 12;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder getJiraSourceOrBuilder() {
      if ((ragFileSourceCase_ == 12) && (jiraSourceBuilder_ != null)) {
        return jiraSourceBuilder_.getMessageOrBuilder();
      } else {
        if (ragFileSourceCase_ == 12) {
          return (com.google.cloud.aiplatform.v1beta1.JiraSource) ragFileSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a Jira query.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.JiraSource,
            com.google.cloud.aiplatform.v1beta1.JiraSource.Builder,
            com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder>
        getJiraSourceFieldBuilder() {
      if (jiraSourceBuilder_ == null) {
        if (!(ragFileSourceCase_ == 12)) {
          ragFileSource_ = com.google.cloud.aiplatform.v1beta1.JiraSource.getDefaultInstance();
        }
        jiraSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.JiraSource,
                com.google.cloud.aiplatform.v1beta1.JiraSource.Builder,
                com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.JiraSource) ragFileSource_,
                getParentForChildren(),
                isClean());
        ragFileSource_ = null;
      }
      ragFileSourceCase_ = 12;
      onChanged();
      return jiraSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SharePointSources,
            com.google.cloud.aiplatform.v1beta1.SharePointSources.Builder,
            com.google.cloud.aiplatform.v1beta1.SharePointSourcesOrBuilder>
        sharePointSourcesBuilder_;
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a SharePoint source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 14;</code>
     *
     * @return Whether the sharePointSources field is set.
     */
    @java.lang.Override
    public boolean hasSharePointSources() {
      return ragFileSourceCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a SharePoint source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 14;</code>
     *
     * @return The sharePointSources.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SharePointSources getSharePointSources() {
      if (sharePointSourcesBuilder_ == null) {
        if (ragFileSourceCase_ == 14) {
          return (com.google.cloud.aiplatform.v1beta1.SharePointSources) ragFileSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance();
      } else {
        if (ragFileSourceCase_ == 14) {
          return sharePointSourcesBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a SharePoint source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 14;</code>
     */
    public Builder setSharePointSources(
        com.google.cloud.aiplatform.v1beta1.SharePointSources value) {
      if (sharePointSourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ragFileSource_ = value;
        onChanged();
      } else {
        sharePointSourcesBuilder_.setMessage(value);
      }
      ragFileSourceCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a SharePoint source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 14;</code>
     */
    public Builder setSharePointSources(
        com.google.cloud.aiplatform.v1beta1.SharePointSources.Builder builderForValue) {
      if (sharePointSourcesBuilder_ == null) {
        ragFileSource_ = builderForValue.build();
        onChanged();
      } else {
        sharePointSourcesBuilder_.setMessage(builderForValue.build());
      }
      ragFileSourceCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a SharePoint source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 14;</code>
     */
    public Builder mergeSharePointSources(
        com.google.cloud.aiplatform.v1beta1.SharePointSources value) {
      if (sharePointSourcesBuilder_ == null) {
        if (ragFileSourceCase_ == 14
            && ragFileSource_
                != com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance()) {
          ragFileSource_ =
              com.google.cloud.aiplatform.v1beta1.SharePointSources.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.SharePointSources) ragFileSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          ragFileSource_ = value;
        }
        onChanged();
      } else {
        if (ragFileSourceCase_ == 14) {
          sharePointSourcesBuilder_.mergeFrom(value);
        } else {
          sharePointSourcesBuilder_.setMessage(value);
        }
      }
      ragFileSourceCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a SharePoint source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 14;</code>
     */
    public Builder clearSharePointSources() {
      if (sharePointSourcesBuilder_ == null) {
        if (ragFileSourceCase_ == 14) {
          ragFileSourceCase_ = 0;
          ragFileSource_ = null;
          onChanged();
        }
      } else {
        if (ragFileSourceCase_ == 14) {
          ragFileSourceCase_ = 0;
          ragFileSource_ = null;
        }
        sharePointSourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a SharePoint source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 14;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.SharePointSources.Builder
        getSharePointSourcesBuilder() {
      return getSharePointSourcesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a SharePoint source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 14;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SharePointSourcesOrBuilder
        getSharePointSourcesOrBuilder() {
      if ((ragFileSourceCase_ == 14) && (sharePointSourcesBuilder_ != null)) {
        return sharePointSourcesBuilder_.getMessageOrBuilder();
      } else {
        if (ragFileSourceCase_ == 14) {
          return (com.google.cloud.aiplatform.v1beta1.SharePointSources) ragFileSource_;
        }
        return com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The RagFile is imported from a SharePoint source.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SharePointSources,
            com.google.cloud.aiplatform.v1beta1.SharePointSources.Builder,
            com.google.cloud.aiplatform.v1beta1.SharePointSourcesOrBuilder>
        getSharePointSourcesFieldBuilder() {
      if (sharePointSourcesBuilder_ == null) {
        if (!(ragFileSourceCase_ == 14)) {
          ragFileSource_ =
              com.google.cloud.aiplatform.v1beta1.SharePointSources.getDefaultInstance();
        }
        sharePointSourcesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SharePointSources,
                com.google.cloud.aiplatform.v1beta1.SharePointSources.Builder,
                com.google.cloud.aiplatform.v1beta1.SharePointSourcesOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.SharePointSources) ragFileSource_,
                getParentForChildren(),
                isClean());
        ragFileSource_ = null;
      }
      ragFileSourceCase_ = 14;
      onChanged();
      return sharePointSourcesBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the RagFile.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the RagFile.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the RagFile.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the RagFile.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the RagFile.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the RagFile.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the RagFile.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the RagFile.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the RagFile.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the RagFile.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The description of the RagFile.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the RagFile.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the RagFile.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the RagFile.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the RagFile.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private long sizeBytes_;
    /**
     *
     *
     * <pre>
     * Output only. The size of the RagFile in bytes.
     * </pre>
     *
     * <code>int64 size_bytes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The sizeBytes.
     */
    @java.lang.Override
    public long getSizeBytes() {
      return sizeBytes_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The size of the RagFile in bytes.
     * </pre>
     *
     * <code>int64 size_bytes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The sizeBytes to set.
     * @return This builder for chaining.
     */
    public Builder setSizeBytes(long value) {

      sizeBytes_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The size of the RagFile in bytes.
     * </pre>
     *
     * <code>int64 size_bytes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSizeBytes() {
      bitField0_ = (bitField0_ & ~0x00000200);
      sizeBytes_ = 0L;
      onChanged();
      return this;
    }

    private int ragFileType_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The type of the RagFile.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFile.RagFileType rag_file_type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for ragFileType.
     */
    @java.lang.Override
    public int getRagFileTypeValue() {
      return ragFileType_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of the RagFile.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFile.RagFileType rag_file_type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for ragFileType to set.
     * @return This builder for chaining.
     */
    public Builder setRagFileTypeValue(int value) {
      ragFileType_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of the RagFile.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFile.RagFileType rag_file_type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The ragFileType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RagFile.RagFileType getRagFileType() {
      com.google.cloud.aiplatform.v1beta1.RagFile.RagFileType result =
          com.google.cloud.aiplatform.v1beta1.RagFile.RagFileType.forNumber(ragFileType_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.RagFile.RagFileType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of the RagFile.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFile.RagFileType rag_file_type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The ragFileType to set.
     * @return This builder for chaining.
     */
    public Builder setRagFileType(com.google.cloud.aiplatform.v1beta1.RagFile.RagFileType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      ragFileType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of the RagFile.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RagFile.RagFileType rag_file_type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRagFileType() {
      bitField0_ = (bitField0_ & ~0x00000400);
      ragFileType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00001000);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagFile was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.FileStatus fileStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FileStatus,
            com.google.cloud.aiplatform.v1beta1.FileStatus.Builder,
            com.google.cloud.aiplatform.v1beta1.FileStatusOrBuilder>
        fileStatusBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. State of the RagFile.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FileStatus file_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the fileStatus field is set.
     */
    public boolean hasFileStatus() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the RagFile.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FileStatus file_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The fileStatus.
     */
    public com.google.cloud.aiplatform.v1beta1.FileStatus getFileStatus() {
      if (fileStatusBuilder_ == null) {
        return fileStatus_ == null
            ? com.google.cloud.aiplatform.v1beta1.FileStatus.getDefaultInstance()
            : fileStatus_;
      } else {
        return fileStatusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the RagFile.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FileStatus file_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFileStatus(com.google.cloud.aiplatform.v1beta1.FileStatus value) {
      if (fileStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fileStatus_ = value;
      } else {
        fileStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the RagFile.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FileStatus file_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFileStatus(
        com.google.cloud.aiplatform.v1beta1.FileStatus.Builder builderForValue) {
      if (fileStatusBuilder_ == null) {
        fileStatus_ = builderForValue.build();
      } else {
        fileStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the RagFile.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FileStatus file_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeFileStatus(com.google.cloud.aiplatform.v1beta1.FileStatus value) {
      if (fileStatusBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && fileStatus_ != null
            && fileStatus_ != com.google.cloud.aiplatform.v1beta1.FileStatus.getDefaultInstance()) {
          getFileStatusBuilder().mergeFrom(value);
        } else {
          fileStatus_ = value;
        }
      } else {
        fileStatusBuilder_.mergeFrom(value);
      }
      if (fileStatus_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the RagFile.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FileStatus file_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearFileStatus() {
      bitField0_ = (bitField0_ & ~0x00002000);
      fileStatus_ = null;
      if (fileStatusBuilder_ != null) {
        fileStatusBuilder_.dispose();
        fileStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the RagFile.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FileStatus file_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FileStatus.Builder getFileStatusBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getFileStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the RagFile.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FileStatus file_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.FileStatusOrBuilder getFileStatusOrBuilder() {
      if (fileStatusBuilder_ != null) {
        return fileStatusBuilder_.getMessageOrBuilder();
      } else {
        return fileStatus_ == null
            ? com.google.cloud.aiplatform.v1beta1.FileStatus.getDefaultInstance()
            : fileStatus_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the RagFile.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.FileStatus file_status = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.FileStatus,
            com.google.cloud.aiplatform.v1beta1.FileStatus.Builder,
            com.google.cloud.aiplatform.v1beta1.FileStatusOrBuilder>
        getFileStatusFieldBuilder() {
      if (fileStatusBuilder_ == null) {
        fileStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.FileStatus,
                com.google.cloud.aiplatform.v1beta1.FileStatus.Builder,
                com.google.cloud.aiplatform.v1beta1.FileStatusOrBuilder>(
                getFileStatus(), getParentForChildren(), isClean());
        fileStatus_ = null;
      }
      return fileStatusBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RagFile)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RagFile)
  private static final com.google.cloud.aiplatform.v1beta1.RagFile DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RagFile();
  }

  public static com.google.cloud.aiplatform.v1beta1.RagFile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RagFile> PARSER =
      new com.google.protobuf.AbstractParser<RagFile>() {
        @java.lang.Override
        public RagFile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RagFile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RagFile> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RagFile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
