/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/publisher_model.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A Model Garden Publisher Model.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.PublisherModel}
 */
public final class PublisherModel extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PublisherModel)
    PublisherModelOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PublisherModel.newBuilder() to construct.
  private PublisherModel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PublisherModel() {
    name_ = "";
    versionId_ = "";
    openSourceCategory_ = 0;
    frameworks_ = com.google.protobuf.LazyStringArrayList.emptyList();
    launchStage_ = 0;
    versionState_ = 0;
    publisherModelTemplate_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PublisherModel();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
        .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
        .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.class,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * An enum representing the open source category of a PublisherModel.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory}
   */
  public enum OpenSourceCategory implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The open source category is unspecified, which should not be used.
     * </pre>
     *
     * <code>OPEN_SOURCE_CATEGORY_UNSPECIFIED = 0;</code>
     */
    OPEN_SOURCE_CATEGORY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is not open sourced.
     * </pre>
     *
     * <code>PROPRIETARY = 1;</code>
     */
    PROPRIETARY(1),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a Google-owned open source model
     * w/ Google checkpoint.
     * </pre>
     *
     * <code>GOOGLE_OWNED_OSS_WITH_GOOGLE_CHECKPOINT = 2;</code>
     */
    GOOGLE_OWNED_OSS_WITH_GOOGLE_CHECKPOINT(2),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a 3p-owned open source model w/
     * Google checkpoint.
     * </pre>
     *
     * <code>THIRD_PARTY_OWNED_OSS_WITH_GOOGLE_CHECKPOINT = 3;</code>
     */
    THIRD_PARTY_OWNED_OSS_WITH_GOOGLE_CHECKPOINT(3),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a Google-owned pure open source
     * model.
     * </pre>
     *
     * <code>GOOGLE_OWNED_OSS = 4;</code>
     */
    GOOGLE_OWNED_OSS(4),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a 3p-owned pure open source model.
     * </pre>
     *
     * <code>THIRD_PARTY_OWNED_OSS = 5;</code>
     */
    THIRD_PARTY_OWNED_OSS(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The open source category is unspecified, which should not be used.
     * </pre>
     *
     * <code>OPEN_SOURCE_CATEGORY_UNSPECIFIED = 0;</code>
     */
    public static final int OPEN_SOURCE_CATEGORY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is not open sourced.
     * </pre>
     *
     * <code>PROPRIETARY = 1;</code>
     */
    public static final int PROPRIETARY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a Google-owned open source model
     * w/ Google checkpoint.
     * </pre>
     *
     * <code>GOOGLE_OWNED_OSS_WITH_GOOGLE_CHECKPOINT = 2;</code>
     */
    public static final int GOOGLE_OWNED_OSS_WITH_GOOGLE_CHECKPOINT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a 3p-owned open source model w/
     * Google checkpoint.
     * </pre>
     *
     * <code>THIRD_PARTY_OWNED_OSS_WITH_GOOGLE_CHECKPOINT = 3;</code>
     */
    public static final int THIRD_PARTY_OWNED_OSS_WITH_GOOGLE_CHECKPOINT_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a Google-owned pure open source
     * model.
     * </pre>
     *
     * <code>GOOGLE_OWNED_OSS = 4;</code>
     */
    public static final int GOOGLE_OWNED_OSS_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is a 3p-owned pure open source model.
     * </pre>
     *
     * <code>THIRD_PARTY_OWNED_OSS = 5;</code>
     */
    public static final int THIRD_PARTY_OWNED_OSS_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OpenSourceCategory valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static OpenSourceCategory forNumber(int value) {
      switch (value) {
        case 0:
          return OPEN_SOURCE_CATEGORY_UNSPECIFIED;
        case 1:
          return PROPRIETARY;
        case 2:
          return GOOGLE_OWNED_OSS_WITH_GOOGLE_CHECKPOINT;
        case 3:
          return THIRD_PARTY_OWNED_OSS_WITH_GOOGLE_CHECKPOINT;
        case 4:
          return GOOGLE_OWNED_OSS;
        case 5:
          return THIRD_PARTY_OWNED_OSS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<OpenSourceCategory>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<OpenSourceCategory>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<OpenSourceCategory>() {
              public OpenSourceCategory findValueByNumber(int number) {
                return OpenSourceCategory.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PublisherModel.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final OpenSourceCategory[] VALUES = values();

    public static OpenSourceCategory valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private OpenSourceCategory(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory)
  }

  /**
   *
   *
   * <pre>
   * An enum representing the launch stage of a PublisherModel.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage}
   */
  public enum LaunchStage implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The model launch stage is unspecified.
     * </pre>
     *
     * <code>LAUNCH_STAGE_UNSPECIFIED = 0;</code>
     */
    LAUNCH_STAGE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at Experimental launch stage,
     * available to a small set of customers.
     * </pre>
     *
     * <code>EXPERIMENTAL = 1;</code>
     */
    EXPERIMENTAL(1),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at Private Preview launch stage,
     * only available to a small set of customers, although a larger set of
     * customers than an Experimental launch. Previews are the first launch
     * stage used to get feedback from customers.
     * </pre>
     *
     * <code>PRIVATE_PREVIEW = 2;</code>
     */
    PRIVATE_PREVIEW(2),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at Public Preview launch stage,
     * available to all customers, although not supported for production
     * workloads.
     * </pre>
     *
     * <code>PUBLIC_PREVIEW = 3;</code>
     */
    PUBLIC_PREVIEW(3),
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at GA launch stage, available to
     * all customers and ready for production workload.
     * </pre>
     *
     * <code>GA = 4;</code>
     */
    GA(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The model launch stage is unspecified.
     * </pre>
     *
     * <code>LAUNCH_STAGE_UNSPECIFIED = 0;</code>
     */
    public static final int LAUNCH_STAGE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at Experimental launch stage,
     * available to a small set of customers.
     * </pre>
     *
     * <code>EXPERIMENTAL = 1;</code>
     */
    public static final int EXPERIMENTAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at Private Preview launch stage,
     * only available to a small set of customers, although a larger set of
     * customers than an Experimental launch. Previews are the first launch
     * stage used to get feedback from customers.
     * </pre>
     *
     * <code>PRIVATE_PREVIEW = 2;</code>
     */
    public static final int PRIVATE_PREVIEW_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at Public Preview launch stage,
     * available to all customers, although not supported for production
     * workloads.
     * </pre>
     *
     * <code>PUBLIC_PREVIEW = 3;</code>
     */
    public static final int PUBLIC_PREVIEW_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Used to indicate the PublisherModel is at GA launch stage, available to
     * all customers and ready for production workload.
     * </pre>
     *
     * <code>GA = 4;</code>
     */
    public static final int GA_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LaunchStage valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LaunchStage forNumber(int value) {
      switch (value) {
        case 0:
          return LAUNCH_STAGE_UNSPECIFIED;
        case 1:
          return EXPERIMENTAL;
        case 2:
          return PRIVATE_PREVIEW;
        case 3:
          return PUBLIC_PREVIEW;
        case 4:
          return GA;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LaunchStage> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LaunchStage> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<LaunchStage>() {
          public LaunchStage findValueByNumber(int number) {
            return LaunchStage.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PublisherModel.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final LaunchStage[] VALUES = values();

    public static LaunchStage valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LaunchStage(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage)
  }

  /**
   *
   *
   * <pre>
   * An enum representing the state of the PublicModelVersion.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.PublisherModel.VersionState}
   */
  public enum VersionState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The version state is unspecified.
     * </pre>
     *
     * <code>VERSION_STATE_UNSPECIFIED = 0;</code>
     */
    VERSION_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Used to indicate the version is stable.
     * </pre>
     *
     * <code>VERSION_STATE_STABLE = 1;</code>
     */
    VERSION_STATE_STABLE(1),
    /**
     *
     *
     * <pre>
     * Used to indicate the version is unstable.
     * </pre>
     *
     * <code>VERSION_STATE_UNSTABLE = 2;</code>
     */
    VERSION_STATE_UNSTABLE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The version state is unspecified.
     * </pre>
     *
     * <code>VERSION_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int VERSION_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Used to indicate the version is stable.
     * </pre>
     *
     * <code>VERSION_STATE_STABLE = 1;</code>
     */
    public static final int VERSION_STATE_STABLE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Used to indicate the version is unstable.
     * </pre>
     *
     * <code>VERSION_STATE_UNSTABLE = 2;</code>
     */
    public static final int VERSION_STATE_UNSTABLE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VersionState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VersionState forNumber(int value) {
      switch (value) {
        case 0:
          return VERSION_STATE_UNSPECIFIED;
        case 1:
          return VERSION_STATE_STABLE;
        case 2:
          return VERSION_STATE_UNSTABLE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VersionState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VersionState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<VersionState>() {
          public VersionState findValueByNumber(int number) {
            return VersionState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PublisherModel.getDescriptor()
          .getEnumTypes()
          .get(2);
    }

    private static final VersionState[] VALUES = values();

    public static VersionState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VersionState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.PublisherModel.VersionState)
  }

  public interface ResourceReferenceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The URI of the resource.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return Whether the uri field is set.
     */
    boolean hasUri();
    /**
     *
     *
     * <pre>
     * The URI of the resource.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * The URI of the resource.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();

    /**
     *
     *
     * <pre>
     * The resource name of the Google Cloud resource.
     * </pre>
     *
     * <code>string resource_name = 2;</code>
     *
     * @return Whether the resourceName field is set.
     */
    boolean hasResourceName();
    /**
     *
     *
     * <pre>
     * The resource name of the Google Cloud resource.
     * </pre>
     *
     * <code>string resource_name = 2;</code>
     *
     * @return The resourceName.
     */
    java.lang.String getResourceName();
    /**
     *
     *
     * <pre>
     * The resource name of the Google Cloud resource.
     * </pre>
     *
     * <code>string resource_name = 2;</code>
     *
     * @return The bytes for resourceName.
     */
    com.google.protobuf.ByteString getResourceNameBytes();

    /**
     *
     *
     * <pre>
     * Use case (CUJ) of the resource.
     * </pre>
     *
     * <code>string use_case = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.use_case is
     *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=48
     * @return Whether the useCase field is set.
     */
    @java.lang.Deprecated
    boolean hasUseCase();
    /**
     *
     *
     * <pre>
     * Use case (CUJ) of the resource.
     * </pre>
     *
     * <code>string use_case = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.use_case is
     *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=48
     * @return The useCase.
     */
    @java.lang.Deprecated
    java.lang.String getUseCase();
    /**
     *
     *
     * <pre>
     * Use case (CUJ) of the resource.
     * </pre>
     *
     * <code>string use_case = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.use_case is
     *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=48
     * @return The bytes for useCase.
     */
    @java.lang.Deprecated
    com.google.protobuf.ByteString getUseCaseBytes();

    /**
     *
     *
     * <pre>
     * Description of the resource.
     * </pre>
     *
     * <code>string description = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.description is
     *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=51
     * @return Whether the description field is set.
     */
    @java.lang.Deprecated
    boolean hasDescription();
    /**
     *
     *
     * <pre>
     * Description of the resource.
     * </pre>
     *
     * <code>string description = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.description is
     *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=51
     * @return The description.
     */
    @java.lang.Deprecated
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * Description of the resource.
     * </pre>
     *
     * <code>string description = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.description is
     *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=51
     * @return The bytes for description.
     */
    @java.lang.Deprecated
    com.google.protobuf.ByteString getDescriptionBytes();

    com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.ReferenceCase
        getReferenceCase();
  }
  /**
   *
   *
   * <pre>
   * Reference to a resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference}
   */
  public static final class ResourceReference extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference)
      ResourceReferenceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ResourceReference.newBuilder() to construct.
    private ResourceReference(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ResourceReference() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ResourceReference();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_ResourceReference_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_ResourceReference_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.class,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.Builder.class);
    }

    private int referenceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object reference_;

    public enum ReferenceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      URI(1),
      RESOURCE_NAME(2),
      @java.lang.Deprecated
      USE_CASE(3),
      @java.lang.Deprecated
      DESCRIPTION(4),
      REFERENCE_NOT_SET(0);
      private final int value;

      private ReferenceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ReferenceCase valueOf(int value) {
        return forNumber(value);
      }

      public static ReferenceCase forNumber(int value) {
        switch (value) {
          case 1:
            return URI;
          case 2:
            return RESOURCE_NAME;
          case 3:
            return USE_CASE;
          case 4:
            return DESCRIPTION;
          case 0:
            return REFERENCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ReferenceCase getReferenceCase() {
      return ReferenceCase.forNumber(referenceCase_);
    }

    public static final int URI_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * The URI of the resource.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return Whether the uri field is set.
     */
    public boolean hasUri() {
      return referenceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The URI of the resource.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = "";
      if (referenceCase_ == 1) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (referenceCase_ == 1) {
          reference_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the resource.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = "";
      if (referenceCase_ == 1) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (referenceCase_ == 1) {
          reference_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOURCE_NAME_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The resource name of the Google Cloud resource.
     * </pre>
     *
     * <code>string resource_name = 2;</code>
     *
     * @return Whether the resourceName field is set.
     */
    public boolean hasResourceName() {
      return referenceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Google Cloud resource.
     * </pre>
     *
     * <code>string resource_name = 2;</code>
     *
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = "";
      if (referenceCase_ == 2) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (referenceCase_ == 2) {
          reference_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Google Cloud resource.
     * </pre>
     *
     * <code>string resource_name = 2;</code>
     *
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString getResourceNameBytes() {
      java.lang.Object ref = "";
      if (referenceCase_ == 2) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (referenceCase_ == 2) {
          reference_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int USE_CASE_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Use case (CUJ) of the resource.
     * </pre>
     *
     * <code>string use_case = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.use_case is
     *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=48
     * @return Whether the useCase field is set.
     */
    @java.lang.Deprecated
    public boolean hasUseCase() {
      return referenceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Use case (CUJ) of the resource.
     * </pre>
     *
     * <code>string use_case = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.use_case is
     *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=48
     * @return The useCase.
     */
    @java.lang.Deprecated
    public java.lang.String getUseCase() {
      java.lang.Object ref = "";
      if (referenceCase_ == 3) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (referenceCase_ == 3) {
          reference_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Use case (CUJ) of the resource.
     * </pre>
     *
     * <code>string use_case = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.use_case is
     *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=48
     * @return The bytes for useCase.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getUseCaseBytes() {
      java.lang.Object ref = "";
      if (referenceCase_ == 3) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (referenceCase_ == 3) {
          reference_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Description of the resource.
     * </pre>
     *
     * <code>string description = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.description is
     *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=51
     * @return Whether the description field is set.
     */
    @java.lang.Deprecated
    public boolean hasDescription() {
      return referenceCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Description of the resource.
     * </pre>
     *
     * <code>string description = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.description is
     *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=51
     * @return The description.
     */
    @java.lang.Deprecated
    public java.lang.String getDescription() {
      java.lang.Object ref = "";
      if (referenceCase_ == 4) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (referenceCase_ == 4) {
          reference_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the resource.
     * </pre>
     *
     * <code>string description = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.description is
     *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=51
     * @return The bytes for description.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = "";
      if (referenceCase_ == 4) {
        ref = reference_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (referenceCase_ == 4) {
          reference_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (referenceCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, reference_);
      }
      if (referenceCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, reference_);
      }
      if (referenceCase_ == 3) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, reference_);
      }
      if (referenceCase_ == 4) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, reference_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (referenceCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, reference_);
      }
      if (referenceCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, reference_);
      }
      if (referenceCase_ == 3) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, reference_);
      }
      if (referenceCase_ == 4) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, reference_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference other =
          (com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference) obj;

      if (!getReferenceCase().equals(other.getReferenceCase())) return false;
      switch (referenceCase_) {
        case 1:
          if (!getUri().equals(other.getUri())) return false;
          break;
        case 2:
          if (!getResourceName().equals(other.getResourceName())) return false;
          break;
        case 3:
          if (!getUseCase().equals(other.getUseCase())) return false;
          break;
        case 4:
          if (!getDescription().equals(other.getDescription())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (referenceCase_) {
        case 1:
          hash = (37 * hash) + URI_FIELD_NUMBER;
          hash = (53 * hash) + getUri().hashCode();
          break;
        case 2:
          hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getResourceName().hashCode();
          break;
        case 3:
          hash = (37 * hash) + USE_CASE_FIELD_NUMBER;
          hash = (53 * hash) + getUseCase().hashCode();
          break;
        case 4:
          hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
          hash = (53 * hash) + getDescription().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Reference to a resource.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference)
        com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_ResourceReference_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_ResourceReference_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.class,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        referenceCase_ = 0;
        reference_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_ResourceReference_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference build() {
        com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference buildPartial() {
        com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference result =
            new com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference result) {
        result.referenceCase_ = referenceCase_;
        result.reference_ = this.reference_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
                .getDefaultInstance()) return this;
        switch (other.getReferenceCase()) {
          case URI:
            {
              referenceCase_ = 1;
              reference_ = other.reference_;
              onChanged();
              break;
            }
          case RESOURCE_NAME:
            {
              referenceCase_ = 2;
              reference_ = other.reference_;
              onChanged();
              break;
            }
          case USE_CASE:
            {
              referenceCase_ = 3;
              reference_ = other.reference_;
              onChanged();
              break;
            }
          case DESCRIPTION:
            {
              referenceCase_ = 4;
              reference_ = other.reference_;
              onChanged();
              break;
            }
          case REFERENCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  referenceCase_ = 1;
                  reference_ = s;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  referenceCase_ = 2;
                  reference_ = s;
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  referenceCase_ = 3;
                  reference_ = s;
                  break;
                } // case 26
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  referenceCase_ = 4;
                  reference_ = s;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int referenceCase_ = 0;
      private java.lang.Object reference_;

      public ReferenceCase getReferenceCase() {
        return ReferenceCase.forNumber(referenceCase_);
      }

      public Builder clearReference() {
        referenceCase_ = 0;
        reference_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * The URI of the resource.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return Whether the uri field is set.
       */
      @java.lang.Override
      public boolean hasUri() {
        return referenceCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * The URI of the resource.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The uri.
       */
      @java.lang.Override
      public java.lang.String getUri() {
        java.lang.Object ref = "";
        if (referenceCase_ == 1) {
          ref = reference_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (referenceCase_ == 1) {
            reference_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The URI of the resource.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The bytes for uri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = "";
        if (referenceCase_ == 1) {
          ref = reference_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (referenceCase_ == 1) {
            reference_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The URI of the resource.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        referenceCase_ = 1;
        reference_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The URI of the resource.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {
        if (referenceCase_ == 1) {
          referenceCase_ = 0;
          reference_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The URI of the resource.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        referenceCase_ = 1;
        reference_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The resource name of the Google Cloud resource.
       * </pre>
       *
       * <code>string resource_name = 2;</code>
       *
       * @return Whether the resourceName field is set.
       */
      @java.lang.Override
      public boolean hasResourceName() {
        return referenceCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Google Cloud resource.
       * </pre>
       *
       * <code>string resource_name = 2;</code>
       *
       * @return The resourceName.
       */
      @java.lang.Override
      public java.lang.String getResourceName() {
        java.lang.Object ref = "";
        if (referenceCase_ == 2) {
          ref = reference_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (referenceCase_ == 2) {
            reference_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Google Cloud resource.
       * </pre>
       *
       * <code>string resource_name = 2;</code>
       *
       * @return The bytes for resourceName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getResourceNameBytes() {
        java.lang.Object ref = "";
        if (referenceCase_ == 2) {
          ref = reference_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (referenceCase_ == 2) {
            reference_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Google Cloud resource.
       * </pre>
       *
       * <code>string resource_name = 2;</code>
       *
       * @param value The resourceName to set.
       * @return This builder for chaining.
       */
      public Builder setResourceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        referenceCase_ = 2;
        reference_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Google Cloud resource.
       * </pre>
       *
       * <code>string resource_name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceName() {
        if (referenceCase_ == 2) {
          referenceCase_ = 0;
          reference_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the Google Cloud resource.
       * </pre>
       *
       * <code>string resource_name = 2;</code>
       *
       * @param value The bytes for resourceName to set.
       * @return This builder for chaining.
       */
      public Builder setResourceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        referenceCase_ = 2;
        reference_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Use case (CUJ) of the resource.
       * </pre>
       *
       * <code>string use_case = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.use_case is
       *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=48
       * @return Whether the useCase field is set.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public boolean hasUseCase() {
        return referenceCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Use case (CUJ) of the resource.
       * </pre>
       *
       * <code>string use_case = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.use_case is
       *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=48
       * @return The useCase.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public java.lang.String getUseCase() {
        java.lang.Object ref = "";
        if (referenceCase_ == 3) {
          ref = reference_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (referenceCase_ == 3) {
            reference_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Use case (CUJ) of the resource.
       * </pre>
       *
       * <code>string use_case = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.use_case is
       *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=48
       * @return The bytes for useCase.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.protobuf.ByteString getUseCaseBytes() {
        java.lang.Object ref = "";
        if (referenceCase_ == 3) {
          ref = reference_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (referenceCase_ == 3) {
            reference_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Use case (CUJ) of the resource.
       * </pre>
       *
       * <code>string use_case = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.use_case is
       *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=48
       * @param value The useCase to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setUseCase(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        referenceCase_ = 3;
        reference_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Use case (CUJ) of the resource.
       * </pre>
       *
       * <code>string use_case = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.use_case is
       *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=48
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearUseCase() {
        if (referenceCase_ == 3) {
          referenceCase_ = 0;
          reference_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Use case (CUJ) of the resource.
       * </pre>
       *
       * <code>string use_case = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.use_case is
       *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=48
       * @param value The bytes for useCase to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setUseCaseBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        referenceCase_ = 3;
        reference_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Description of the resource.
       * </pre>
       *
       * <code>string description = 4 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.description is
       *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=51
       * @return Whether the description field is set.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public boolean hasDescription() {
        return referenceCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Description of the resource.
       * </pre>
       *
       * <code>string description = 4 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.description is
       *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=51
       * @return The description.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public java.lang.String getDescription() {
        java.lang.Object ref = "";
        if (referenceCase_ == 4) {
          ref = reference_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (referenceCase_ == 4) {
            reference_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Description of the resource.
       * </pre>
       *
       * <code>string description = 4 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.description is
       *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=51
       * @return The bytes for description.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = "";
        if (referenceCase_ == 4) {
          ref = reference_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (referenceCase_ == 4) {
            reference_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Description of the resource.
       * </pre>
       *
       * <code>string description = 4 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.description is
       *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=51
       * @param value The description to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        referenceCase_ = 4;
        reference_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description of the resource.
       * </pre>
       *
       * <code>string description = 4 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.description is
       *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=51
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearDescription() {
        if (referenceCase_ == 4) {
          referenceCase_ = 0;
          reference_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description of the resource.
       * </pre>
       *
       * <code>string description = 4 [deprecated = true];</code>
       *
       * @deprecated google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.description is
       *     deprecated. See google/cloud/aiplatform/v1beta1/publisher_model.proto;l=51
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        referenceCase_ = 4;
        reference_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference)
    private static final com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference();
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ResourceReference> PARSER =
        new com.google.protobuf.AbstractParser<ResourceReference>() {
          @java.lang.Override
          public ResourceReference parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ResourceReference> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ResourceReference> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ParentOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PublisherModel.Parent)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The display name of the parent. E.g., LaMDA, T5, Vision API,
     * Natural Language API.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * Required. The display name of the parent. E.g., LaMDA, T5, Vision API,
     * Natural Language API.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud resource name or the URI reference.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the reference field is set.
     */
    boolean hasReference();
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud resource name or the URI reference.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The reference.
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference getReference();
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud resource name or the URI reference.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder
        getReferenceOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The information about the parent of a model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PublisherModel.Parent}
   */
  public static final class Parent extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PublisherModel.Parent)
      ParentOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Parent.newBuilder() to construct.
    private Parent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Parent() {
      displayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Parent();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_Parent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_Parent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.class,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.Builder.class);
    }

    private int bitField0_;
    public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the parent. E.g., LaMDA, T5, Vision API,
     * Natural Language API.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the parent. E.g., LaMDA, T5, Vision API,
     * Natural Language API.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REFERENCE_FIELD_NUMBER = 2;
    private com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference_;
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud resource name or the URI reference.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the reference field is set.
     */
    @java.lang.Override
    public boolean hasReference() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud resource name or the URI reference.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The reference.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference getReference() {
      return reference_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
              .getDefaultInstance()
          : reference_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Cloud resource name or the URI reference.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder
        getReferenceOrBuilder() {
      return reference_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
              .getDefaultInstance()
          : reference_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getReference());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getReference());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent other =
          (com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent) obj;

      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (hasReference() != other.hasReference()) return false;
      if (hasReference()) {
        if (!getReference().equals(other.getReference())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      if (hasReference()) {
        hash = (37 * hash) + REFERENCE_FIELD_NUMBER;
        hash = (53 * hash) + getReference().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The information about the parent of a model.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.PublisherModel.Parent}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PublisherModel.Parent)
        com.google.cloud.aiplatform.v1beta1.PublisherModel.ParentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_Parent_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_Parent_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.class,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getReferenceFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        displayName_ = "";
        reference_ = null;
        if (referenceBuilder_ != null) {
          referenceBuilder_.dispose();
          referenceBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_Parent_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent build() {
        com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent buildPartial() {
        com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent result =
            new com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.displayName_ = displayName_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.reference_ = referenceBuilder_ == null ? reference_ : referenceBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent other) {
        if (other == com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.getDefaultInstance())
          return this;
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasReference()) {
          mergeReference(other.getReference());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  displayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getReferenceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * Required. The display name of the parent. E.g., LaMDA, T5, Vision API,
       * Natural Language API.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The display name of the parent. E.g., LaMDA, T5, Vision API,
       * Natural Language API.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The display name of the parent. E.g., LaMDA, T5, Vision API,
       * Natural Language API.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The display name of the parent. E.g., LaMDA, T5, Vision API,
       * Natural Language API.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {
        displayName_ = getDefaultInstance().getDisplayName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The display name of the parent. E.g., LaMDA, T5, Vision API,
       * Natural Language API.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder>
          referenceBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. The Google Cloud resource name or the URI reference.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the reference field is set.
       */
      public boolean hasReference() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The Google Cloud resource name or the URI reference.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The reference.
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference getReference() {
        if (referenceBuilder_ == null) {
          return reference_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
                  .getDefaultInstance()
              : reference_;
        } else {
          return referenceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The Google Cloud resource name or the URI reference.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setReference(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference value) {
        if (referenceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          reference_ = value;
        } else {
          referenceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Google Cloud resource name or the URI reference.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setReference(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.Builder
              builderForValue) {
        if (referenceBuilder_ == null) {
          reference_ = builderForValue.build();
        } else {
          referenceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Google Cloud resource name or the URI reference.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeReference(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference value) {
        if (referenceBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && reference_ != null
              && reference_
                  != com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
                      .getDefaultInstance()) {
            getReferenceBuilder().mergeFrom(value);
          } else {
            reference_ = value;
          }
        } else {
          referenceBuilder_.mergeFrom(value);
        }
        if (reference_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Google Cloud resource name or the URI reference.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearReference() {
        bitField0_ = (bitField0_ & ~0x00000002);
        reference_ = null;
        if (referenceBuilder_ != null) {
          referenceBuilder_.dispose();
          referenceBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Google Cloud resource name or the URI reference.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.Builder
          getReferenceBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getReferenceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. The Google Cloud resource name or the URI reference.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder
          getReferenceOrBuilder() {
        if (referenceBuilder_ != null) {
          return referenceBuilder_.getMessageOrBuilder();
        } else {
          return reference_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
                  .getDefaultInstance()
              : reference_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The Google Cloud resource name or the URI reference.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder>
          getReferenceFieldBuilder() {
        if (referenceBuilder_ == null) {
          referenceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.Builder,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder>(
                  getReference(), getParentForChildren(), isClean());
          reference_ = null;
        }
        return referenceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PublisherModel.Parent)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PublisherModel.Parent)
    private static final com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent();
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Parent> PARSER =
        new com.google.protobuf.AbstractParser<Parent>() {
          @java.lang.Override
          public Parent parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Parent> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Parent> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DocumentationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PublisherModel.Documentation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
     * NODE.JS, etc..
     * </pre>
     *
     * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The title.
     */
    java.lang.String getTitle();
    /**
     *
     *
     * <pre>
     * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
     * NODE.JS, etc..
     * </pre>
     *
     * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for title.
     */
    com.google.protobuf.ByteString getTitleBytes();

    /**
     *
     *
     * <pre>
     * Required. Content of this piece of document (in Markdown format).
     * </pre>
     *
     * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The content.
     */
    java.lang.String getContent();
    /**
     *
     *
     * <pre>
     * Required. Content of this piece of document (in Markdown format).
     * </pre>
     *
     * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for content.
     */
    com.google.protobuf.ByteString getContentBytes();
  }
  /**
   *
   *
   * <pre>
   * A named piece of documentation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PublisherModel.Documentation}
   */
  public static final class Documentation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PublisherModel.Documentation)
      DocumentationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Documentation.newBuilder() to construct.
    private Documentation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Documentation() {
      title_ = "";
      content_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Documentation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_Documentation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_Documentation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation.class,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation.Builder.class);
    }

    public static final int TITLE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object title_ = "";
    /**
     *
     *
     * <pre>
     * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
     * NODE.JS, etc..
     * </pre>
     *
     * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The title.
     */
    @java.lang.Override
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
     * NODE.JS, etc..
     * </pre>
     *
     * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for title.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTENT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object content_ = "";
    /**
     *
     *
     * <pre>
     * Required. Content of this piece of document (in Markdown format).
     * </pre>
     *
     * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The content.
     */
    @java.lang.Override
    public java.lang.String getContent() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        content_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Content of this piece of document (in Markdown format).
     * </pre>
     *
     * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for content.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContentBytes() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        content_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, title_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, content_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, title_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, content_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation other =
          (com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation) obj;

      if (!getTitle().equals(other.getTitle())) return false;
      if (!getContent().equals(other.getContent())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TITLE_FIELD_NUMBER;
      hash = (53 * hash) + getTitle().hashCode();
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A named piece of documentation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.PublisherModel.Documentation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PublisherModel.Documentation)
        com.google.cloud.aiplatform.v1beta1.PublisherModel.DocumentationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_Documentation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_Documentation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation.class,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        title_ = "";
        content_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_Documentation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation build() {
        com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation buildPartial() {
        com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation result =
            new com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.title_ = title_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.content_ = content_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation
                .getDefaultInstance()) return this;
        if (!other.getTitle().isEmpty()) {
          title_ = other.title_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getContent().isEmpty()) {
          content_ = other.content_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  title_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  content_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object title_ = "";
      /**
       *
       *
       * <pre>
       * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
       * NODE.JS, etc..
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
       * NODE.JS, etc..
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
       * NODE.JS, etc..
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The title to set.
       * @return This builder for chaining.
       */
      public Builder setTitle(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        title_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
       * NODE.JS, etc..
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTitle() {
        title_ = getDefaultInstance().getTitle();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK &amp; SAMPLES, JAVA,
       * NODE.JS, etc..
       * </pre>
       *
       * <code>string title = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for title to set.
       * @return This builder for chaining.
       */
      public Builder setTitleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        title_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object content_ = "";
      /**
       *
       *
       * <pre>
       * Required. Content of this piece of document (in Markdown format).
       * </pre>
       *
       * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The content.
       */
      public java.lang.String getContent() {
        java.lang.Object ref = content_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          content_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Content of this piece of document (in Markdown format).
       * </pre>
       *
       * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for content.
       */
      public com.google.protobuf.ByteString getContentBytes() {
        java.lang.Object ref = content_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          content_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Content of this piece of document (in Markdown format).
       * </pre>
       *
       * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The content to set.
       * @return This builder for chaining.
       */
      public Builder setContent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Content of this piece of document (in Markdown format).
       * </pre>
       *
       * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContent() {
        content_ = getDefaultInstance().getContent();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Content of this piece of document (in Markdown format).
       * </pre>
       *
       * <code>string content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for content to set.
       * @return This builder for chaining.
       */
      public Builder setContentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        content_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PublisherModel.Documentation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PublisherModel.Documentation)
    private static final com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation();
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Documentation> PARSER =
        new com.google.protobuf.AbstractParser<Documentation>() {
          @java.lang.Override
          public Documentation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Documentation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Documentation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CallToActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. To view Rest API docs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the viewRestApi field is set.
     */
    boolean hasViewRestApi();
    /**
     *
     *
     * <pre>
     * Optional. To view Rest API docs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The viewRestApi.
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi getViewRestApi();
    /**
     *
     *
     * <pre>
     * Optional. To view Rest API docs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApiOrBuilder
        getViewRestApiOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Open notebook of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openNotebook field is set.
     */
    boolean hasOpenNotebook();
    /**
     *
     *
     * <pre>
     * Optional. Open notebook of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openNotebook.
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenNotebook();
    /**
     *
     *
     * <pre>
     * Optional. Open notebook of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenNotebookOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Open notebooks of the PublisherModel.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks open_notebooks = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openNotebooks field is set.
     */
    boolean hasOpenNotebooks();
    /**
     *
     *
     * <pre>
     * Optional. Open notebooks of the PublisherModel.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks open_notebooks = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openNotebooks.
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
        getOpenNotebooks();
    /**
     *
     *
     * <pre>
     * Optional. Open notebooks of the PublisherModel.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks open_notebooks = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooksOrBuilder
        getOpenNotebooksOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Create application using the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the createApplication field is set.
     */
    boolean hasCreateApplication();
    /**
     *
     *
     * <pre>
     * Optional. Create application using the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The createApplication.
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
        getCreateApplication();
    /**
     *
     *
     * <pre>
     * Optional. Create application using the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getCreateApplicationOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openFineTuningPipeline field is set.
     */
    boolean hasOpenFineTuningPipeline();
    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openFineTuningPipeline.
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenFineTuningPipeline();
    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenFineTuningPipelineOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipelines of the PublisherModel.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines open_fine_tuning_pipelines = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openFineTuningPipelines field is set.
     */
    boolean hasOpenFineTuningPipelines();
    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipelines of the PublisherModel.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines open_fine_tuning_pipelines = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openFineTuningPipelines.
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
        getOpenFineTuningPipelines();
    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipelines of the PublisherModel.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines open_fine_tuning_pipelines = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelinesOrBuilder
        getOpenFineTuningPipelinesOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Open prompt-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openPromptTuningPipeline field is set.
     */
    boolean hasOpenPromptTuningPipeline();
    /**
     *
     *
     * <pre>
     * Optional. Open prompt-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openPromptTuningPipeline.
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenPromptTuningPipeline();
    /**
     *
     *
     * <pre>
     * Optional. Open prompt-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenPromptTuningPipelineOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Open Genie / Playground.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openGenie field is set.
     */
    boolean hasOpenGenie();
    /**
     *
     *
     * <pre>
     * Optional. Open Genie / Playground.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openGenie.
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenGenie();
    /**
     *
     *
     * <pre>
     * Optional. Open Genie / Playground.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenGenieOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Deploy the PublisherModel to Vertex Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the deploy field is set.
     */
    boolean hasDeploy();
    /**
     *
     *
     * <pre>
     * Optional. Deploy the PublisherModel to Vertex Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The deploy.
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy getDeploy();
    /**
     *
     *
     * <pre>
     * Optional. Deploy the PublisherModel to Vertex Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployOrBuilder
        getDeployOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Multiple setups to deploy the PublisherModel to Vertex
     * Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex multi_deploy_vertex = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the multiDeployVertex field is set.
     */
    boolean hasMultiDeployVertex();
    /**
     *
     *
     * <pre>
     * Optional. Multiple setups to deploy the PublisherModel to Vertex
     * Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex multi_deploy_vertex = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The multiDeployVertex.
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
        getMultiDeployVertex();
    /**
     *
     *
     * <pre>
     * Optional. Multiple setups to deploy the PublisherModel to Vertex
     * Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex multi_deploy_vertex = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertexOrBuilder
        getMultiDeployVertexOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Deploy PublisherModel to Google Kubernetes Engine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deploy_gke = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the deployGke field is set.
     */
    boolean hasDeployGke();
    /**
     *
     *
     * <pre>
     * Optional. Deploy PublisherModel to Google Kubernetes Engine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deploy_gke = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The deployGke.
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke getDeployGke();
    /**
     *
     *
     * <pre>
     * Optional. Deploy PublisherModel to Google Kubernetes Engine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deploy_gke = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGkeOrBuilder
        getDeployGkeOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Open in Generation AI Studio.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openGenerationAiStudio field is set.
     */
    boolean hasOpenGenerationAiStudio();
    /**
     *
     *
     * <pre>
     * Optional. Open in Generation AI Studio.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openGenerationAiStudio.
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenGenerationAiStudio();
    /**
     *
     *
     * <pre>
     * Optional. Open in Generation AI Studio.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenGenerationAiStudioOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Request for access.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the requestAccess field is set.
     */
    boolean hasRequestAccess();
    /**
     *
     *
     * <pre>
     * Optional. Request for access.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The requestAccess.
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
        getRequestAccess();
    /**
     *
     *
     * <pre>
     * Optional. Request for access.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getRequestAccessOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Open evaluation pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_evaluation_pipeline = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openEvaluationPipeline field is set.
     */
    boolean hasOpenEvaluationPipeline();
    /**
     *
     *
     * <pre>
     * Optional. Open evaluation pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_evaluation_pipeline = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openEvaluationPipeline.
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
        getOpenEvaluationPipeline();
    /**
     *
     *
     * <pre>
     * Optional. Open evaluation pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_evaluation_pipeline = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenEvaluationPipelineOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Actions could take on this Publisher Model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction}
   */
  public static final class CallToAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction)
      CallToActionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CallToAction.newBuilder() to construct.
    private CallToAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CallToAction() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CallToAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.class,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Builder.class);
    }

    public interface RegionalResourceReferencesOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      int getReferencesCount();
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      boolean containsReferences(java.lang.String key);
      /** Use {@link #getReferencesMap()} instead. */
      @java.lang.Deprecated
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
          getReferences();
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
          getReferencesMap();
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      /* nullable */
      com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference getReferencesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference defaultValue);
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference getReferencesOrThrow(
          java.lang.String key);

      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      java.lang.String getTitle();
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      com.google.protobuf.ByteString getTitleBytes();

      /**
       *
       *
       * <pre>
       * Optional. Title of the resource.
       * </pre>
       *
       * <code>optional string resource_title = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the resourceTitle field is set.
       */
      boolean hasResourceTitle();
      /**
       *
       *
       * <pre>
       * Optional. Title of the resource.
       * </pre>
       *
       * <code>optional string resource_title = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The resourceTitle.
       */
      java.lang.String getResourceTitle();
      /**
       *
       *
       * <pre>
       * Optional. Title of the resource.
       * </pre>
       *
       * <code>optional string resource_title = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for resourceTitle.
       */
      com.google.protobuf.ByteString getResourceTitleBytes();

      /**
       *
       *
       * <pre>
       * Optional. Use case (CUJ) of the resource.
       * </pre>
       *
       * <code>optional string resource_use_case = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the resourceUseCase field is set.
       */
      boolean hasResourceUseCase();
      /**
       *
       *
       * <pre>
       * Optional. Use case (CUJ) of the resource.
       * </pre>
       *
       * <code>optional string resource_use_case = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The resourceUseCase.
       */
      java.lang.String getResourceUseCase();
      /**
       *
       *
       * <pre>
       * Optional. Use case (CUJ) of the resource.
       * </pre>
       *
       * <code>optional string resource_use_case = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The bytes for resourceUseCase.
       */
      com.google.protobuf.ByteString getResourceUseCaseBytes();

      /**
       *
       *
       * <pre>
       * Optional. Description of the resource.
       * </pre>
       *
       * <code>optional string resource_description = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the resourceDescription field is set.
       */
      boolean hasResourceDescription();
      /**
       *
       *
       * <pre>
       * Optional. Description of the resource.
       * </pre>
       *
       * <code>optional string resource_description = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The resourceDescription.
       */
      java.lang.String getResourceDescription();
      /**
       *
       *
       * <pre>
       * Optional. Description of the resource.
       * </pre>
       *
       * <code>optional string resource_description = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The bytes for resourceDescription.
       */
      com.google.protobuf.ByteString getResourceDescriptionBytes();
    }
    /**
     *
     *
     * <pre>
     * The regional resource name or the URI. Key is region, e.g.,
     * us-central1, europe-west2, global, etc..
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences}
     */
    public static final class RegionalResourceReferences
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences)
        RegionalResourceReferencesOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use RegionalResourceReferences.newBuilder() to construct.
      private RegionalResourceReferences(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private RegionalResourceReferences() {
        title_ = "";
        resourceTitle_ = "";
        resourceUseCase_ = "";
        resourceDescription_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new RegionalResourceReferences();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_RegionalResourceReferences_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      @java.lang.Override
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 1:
            return internalGetReferences();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_RegionalResourceReferences_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences.class,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences.Builder.class);
      }

      private int bitField0_;
      public static final int REFERENCES_FIELD_NUMBER = 1;

      private static final class ReferencesDefaultEntryHolder {
        static final com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
            defaultEntry =
                com.google.protobuf.MapEntry
                    .<java.lang.String,
                        com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
                        newDefaultInstance(
                            com.google.cloud.aiplatform.v1beta1.PublisherModelProto
                                .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_RegionalResourceReferences_ReferencesEntry_descriptor,
                            com.google.protobuf.WireFormat.FieldType.STRING,
                            "",
                            com.google.protobuf.WireFormat.FieldType.MESSAGE,
                            com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
                                .getDefaultInstance());
      }

      @SuppressWarnings("serial")
      private com.google.protobuf.MapField<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
          references_;

      private com.google.protobuf.MapField<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
          internalGetReferences() {
        if (references_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              ReferencesDefaultEntryHolder.defaultEntry);
        }
        return references_;
      }

      public int getReferencesCount() {
        return internalGetReferences().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public boolean containsReferences(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetReferences().getMap().containsKey(key);
      }
      /** Use {@link #getReferencesMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
          getReferences() {
        return getReferencesMap();
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
          getReferencesMap() {
        return internalGetReferences().getMap();
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
          getReferencesOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
            map = internalGetReferences().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
          getReferencesOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
            map = internalGetReferences().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public static final int TITLE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object title_ = "";
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      @java.lang.Override
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int RESOURCE_TITLE_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object resourceTitle_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Title of the resource.
       * </pre>
       *
       * <code>optional string resource_title = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the resourceTitle field is set.
       */
      @java.lang.Override
      public boolean hasResourceTitle() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Title of the resource.
       * </pre>
       *
       * <code>optional string resource_title = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The resourceTitle.
       */
      @java.lang.Override
      public java.lang.String getResourceTitle() {
        java.lang.Object ref = resourceTitle_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceTitle_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Title of the resource.
       * </pre>
       *
       * <code>optional string resource_title = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for resourceTitle.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getResourceTitleBytes() {
        java.lang.Object ref = resourceTitle_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceTitle_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int RESOURCE_USE_CASE_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object resourceUseCase_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Use case (CUJ) of the resource.
       * </pre>
       *
       * <code>optional string resource_use_case = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the resourceUseCase field is set.
       */
      @java.lang.Override
      public boolean hasResourceUseCase() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Use case (CUJ) of the resource.
       * </pre>
       *
       * <code>optional string resource_use_case = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The resourceUseCase.
       */
      @java.lang.Override
      public java.lang.String getResourceUseCase() {
        java.lang.Object ref = resourceUseCase_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceUseCase_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Use case (CUJ) of the resource.
       * </pre>
       *
       * <code>optional string resource_use_case = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The bytes for resourceUseCase.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getResourceUseCaseBytes() {
        java.lang.Object ref = resourceUseCase_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceUseCase_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int RESOURCE_DESCRIPTION_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private volatile java.lang.Object resourceDescription_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Description of the resource.
       * </pre>
       *
       * <code>optional string resource_description = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the resourceDescription field is set.
       */
      @java.lang.Override
      public boolean hasResourceDescription() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Description of the resource.
       * </pre>
       *
       * <code>optional string resource_description = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The resourceDescription.
       */
      @java.lang.Override
      public java.lang.String getResourceDescription() {
        java.lang.Object ref = resourceDescription_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceDescription_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Description of the resource.
       * </pre>
       *
       * <code>optional string resource_description = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The bytes for resourceDescription.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getResourceDescriptionBytes() {
        java.lang.Object ref = resourceDescription_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceDescription_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
            output, internalGetReferences(), ReferencesDefaultEntryHolder.defaultEntry, 1);
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, title_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, resourceTitle_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, resourceUseCase_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, resourceDescription_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (java.util.Map.Entry<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
            entry : internalGetReferences().getMap().entrySet()) {
          com.google.protobuf.MapEntry<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
              references__ =
                  ReferencesDefaultEntryHolder.defaultEntry
                      .newBuilderForType()
                      .setKey(entry.getKey())
                      .setValue(entry.getValue())
                      .build();
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, references__);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, title_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, resourceTitle_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, resourceUseCase_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, resourceDescription_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .RegionalResourceReferences)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
            other =
                (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                        .RegionalResourceReferences)
                    obj;

        if (!internalGetReferences().equals(other.internalGetReferences())) return false;
        if (!getTitle().equals(other.getTitle())) return false;
        if (hasResourceTitle() != other.hasResourceTitle()) return false;
        if (hasResourceTitle()) {
          if (!getResourceTitle().equals(other.getResourceTitle())) return false;
        }
        if (hasResourceUseCase() != other.hasResourceUseCase()) return false;
        if (hasResourceUseCase()) {
          if (!getResourceUseCase().equals(other.getResourceUseCase())) return false;
        }
        if (hasResourceDescription() != other.hasResourceDescription()) return false;
        if (hasResourceDescription()) {
          if (!getResourceDescription().equals(other.getResourceDescription())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (!internalGetReferences().getMap().isEmpty()) {
          hash = (37 * hash) + REFERENCES_FIELD_NUMBER;
          hash = (53 * hash) + internalGetReferences().hashCode();
        }
        hash = (37 * hash) + TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getTitle().hashCode();
        if (hasResourceTitle()) {
          hash = (37 * hash) + RESOURCE_TITLE_FIELD_NUMBER;
          hash = (53 * hash) + getResourceTitle().hashCode();
        }
        if (hasResourceUseCase()) {
          hash = (37 * hash) + RESOURCE_USE_CASE_FIELD_NUMBER;
          hash = (53 * hash) + getResourceUseCase().hashCode();
        }
        if (hasResourceDescription()) {
          hash = (37 * hash) + RESOURCE_DESCRIPTION_FIELD_NUMBER;
          hash = (53 * hash) + getResourceDescription().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The regional resource name or the URI. Key is region, e.g.,
       * us-central1, europe-west2, global, etc..
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences)
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_RegionalResourceReferences_descriptor;
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
            int number) {
          switch (number) {
            case 1:
              return internalGetReferences();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapFieldReflectionAccessor
            internalGetMutableMapFieldReflection(int number) {
          switch (number) {
            case 1:
              return internalGetMutableReferences();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_RegionalResourceReferences_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.class,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          internalGetMutableReferences().clear();
          title_ = "";
          resourceTitle_ = "";
          resourceUseCase_ = "";
          resourceDescription_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_RegionalResourceReferences_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .RegionalResourceReferences
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .RegionalResourceReferences
            build() {
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .RegionalResourceReferences
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              result =
                  new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.references_ =
                internalGetReferences().build(ReferencesDefaultEntryHolder.defaultEntry);
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.title_ = title_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.resourceTitle_ = resourceTitle_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.resourceUseCase_ = resourceUseCase_;
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.resourceDescription_ = resourceDescription_;
            to_bitField0_ |= 0x00000004;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                        .RegionalResourceReferences)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()) return this;
          internalGetMutableReferences().mergeFrom(other.internalGetReferences());
          bitField0_ |= 0x00000001;
          if (!other.getTitle().isEmpty()) {
            title_ = other.title_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (other.hasResourceTitle()) {
            resourceTitle_ = other.resourceTitle_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (other.hasResourceUseCase()) {
            resourceUseCase_ = other.resourceUseCase_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          if (other.hasResourceDescription()) {
            resourceDescription_ = other.resourceDescription_;
            bitField0_ |= 0x00000010;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.protobuf.MapEntry<
                            java.lang.String,
                            com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
                        references__ =
                            input.readMessage(
                                ReferencesDefaultEntryHolder.defaultEntry.getParserForType(),
                                extensionRegistry);
                    internalGetMutableReferences()
                        .ensureBuilderMap()
                        .put(references__.getKey(), references__.getValue());
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    title_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    resourceTitle_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 34:
                  {
                    resourceUseCase_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                case 42:
                  {
                    resourceDescription_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private static final class ReferencesConverter
            implements com.google.protobuf.MapFieldBuilder.Converter<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference> {
          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference build(
              com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder val) {
            if (val
                instanceof com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference) {
              return (com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference) val;
            }
            return ((com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.Builder)
                    val)
                .build();
          }

          @java.lang.Override
          public com.google.protobuf.MapEntry<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
              defaultEntry() {
            return ReferencesDefaultEntryHolder.defaultEntry;
          }
        };

        private static final ReferencesConverter referencesConverter = new ReferencesConverter();

        private com.google.protobuf.MapFieldBuilder<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.Builder>
            references_;

        private com.google.protobuf.MapFieldBuilder<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.Builder>
            internalGetReferences() {
          if (references_ == null) {
            return new com.google.protobuf.MapFieldBuilder<>(referencesConverter);
          }
          return references_;
        }

        private com.google.protobuf.MapFieldBuilder<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.Builder>
            internalGetMutableReferences() {
          if (references_ == null) {
            references_ = new com.google.protobuf.MapFieldBuilder<>(referencesConverter);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return references_;
        }

        public int getReferencesCount() {
          return internalGetReferences().ensureBuilderMap().size();
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public boolean containsReferences(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          return internalGetReferences().ensureBuilderMap().containsKey(key);
        }
        /** Use {@link #getReferencesMap()} instead. */
        @java.lang.Override
        @java.lang.Deprecated
        public java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
            getReferences() {
          return getReferencesMap();
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
            getReferencesMap() {
          return internalGetReferences().getImmutableMap();
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public /* nullable */ com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
            getReferencesOrDefault(
                java.lang.String key,
                /* nullable */
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference defaultValue) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder>
              map = internalGetMutableReferences().ensureBuilderMap();
          return map.containsKey(key) ? referencesConverter.build(map.get(key)) : defaultValue;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference
            getReferencesOrThrow(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder>
              map = internalGetMutableReferences().ensureBuilderMap();
          if (!map.containsKey(key)) {
            throw new java.lang.IllegalArgumentException();
          }
          return referencesConverter.build(map.get(key));
        }

        public Builder clearReferences() {
          bitField0_ = (bitField0_ & ~0x00000001);
          internalGetMutableReferences().clear();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder removeReferences(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          internalGetMutableReferences().ensureBuilderMap().remove(key);
          return this;
        }
        /** Use alternate mutation accessors instead. */
        @java.lang.Deprecated
        public java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
            getMutableReferences() {
          bitField0_ |= 0x00000001;
          return internalGetMutableReferences().ensureMessageMap();
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder putReferences(
            java.lang.String key,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference value) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          if (value == null) {
            throw new NullPointerException("map value");
          }
          internalGetMutableReferences().ensureBuilderMap().put(key, value);
          bitField0_ |= 0x00000001;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder putAllReferences(
            java.util.Map<
                    java.lang.String,
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
                values) {
          for (java.util.Map.Entry<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference>
              e : values.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) {
              throw new NullPointerException();
            }
          }
          internalGetMutableReferences().ensureBuilderMap().putAll(values);
          bitField0_ |= 0x00000001;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference&gt; references = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.Builder
            putReferencesBuilderIfAbsent(java.lang.String key) {
          java.util.Map<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder>
              builderMap = internalGetMutableReferences().ensureBuilderMap();
          com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReferenceOrBuilder entry =
              builderMap.get(key);
          if (entry == null) {
            entry =
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.newBuilder();
            builderMap.put(key, entry);
          }
          if (entry
              instanceof com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference) {
            entry =
                ((com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference) entry)
                    .toBuilder();
            builderMap.put(key, entry);
          }
          return (com.google.cloud.aiplatform.v1beta1.PublisherModel.ResourceReference.Builder)
              entry;
        }

        private java.lang.Object title_ = "";
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The title.
         */
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for title.
         */
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The title to set.
         * @return This builder for chaining.
         */
        public Builder setTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          title_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTitle() {
          title_ = getDefaultInstance().getTitle();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for title to set.
         * @return This builder for chaining.
         */
        public Builder setTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          title_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.lang.Object resourceTitle_ = "";
        /**
         *
         *
         * <pre>
         * Optional. Title of the resource.
         * </pre>
         *
         * <code>optional string resource_title = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the resourceTitle field is set.
         */
        public boolean hasResourceTitle() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. Title of the resource.
         * </pre>
         *
         * <code>optional string resource_title = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The resourceTitle.
         */
        public java.lang.String getResourceTitle() {
          java.lang.Object ref = resourceTitle_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            resourceTitle_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Title of the resource.
         * </pre>
         *
         * <code>optional string resource_title = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The bytes for resourceTitle.
         */
        public com.google.protobuf.ByteString getResourceTitleBytes() {
          java.lang.Object ref = resourceTitle_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            resourceTitle_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Title of the resource.
         * </pre>
         *
         * <code>optional string resource_title = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The resourceTitle to set.
         * @return This builder for chaining.
         */
        public Builder setResourceTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          resourceTitle_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Title of the resource.
         * </pre>
         *
         * <code>optional string resource_title = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearResourceTitle() {
          resourceTitle_ = getDefaultInstance().getResourceTitle();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Title of the resource.
         * </pre>
         *
         * <code>optional string resource_title = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The bytes for resourceTitle to set.
         * @return This builder for chaining.
         */
        public Builder setResourceTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          resourceTitle_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.lang.Object resourceUseCase_ = "";
        /**
         *
         *
         * <pre>
         * Optional. Use case (CUJ) of the resource.
         * </pre>
         *
         * <code>optional string resource_use_case = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the resourceUseCase field is set.
         */
        public boolean hasResourceUseCase() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. Use case (CUJ) of the resource.
         * </pre>
         *
         * <code>optional string resource_use_case = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The resourceUseCase.
         */
        public java.lang.String getResourceUseCase() {
          java.lang.Object ref = resourceUseCase_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            resourceUseCase_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Use case (CUJ) of the resource.
         * </pre>
         *
         * <code>optional string resource_use_case = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The bytes for resourceUseCase.
         */
        public com.google.protobuf.ByteString getResourceUseCaseBytes() {
          java.lang.Object ref = resourceUseCase_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            resourceUseCase_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Use case (CUJ) of the resource.
         * </pre>
         *
         * <code>optional string resource_use_case = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The resourceUseCase to set.
         * @return This builder for chaining.
         */
        public Builder setResourceUseCase(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          resourceUseCase_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Use case (CUJ) of the resource.
         * </pre>
         *
         * <code>optional string resource_use_case = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearResourceUseCase() {
          resourceUseCase_ = getDefaultInstance().getResourceUseCase();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Use case (CUJ) of the resource.
         * </pre>
         *
         * <code>optional string resource_use_case = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The bytes for resourceUseCase to set.
         * @return This builder for chaining.
         */
        public Builder setResourceUseCaseBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          resourceUseCase_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        private java.lang.Object resourceDescription_ = "";
        /**
         *
         *
         * <pre>
         * Optional. Description of the resource.
         * </pre>
         *
         * <code>optional string resource_description = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the resourceDescription field is set.
         */
        public boolean hasResourceDescription() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. Description of the resource.
         * </pre>
         *
         * <code>optional string resource_description = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The resourceDescription.
         */
        public java.lang.String getResourceDescription() {
          java.lang.Object ref = resourceDescription_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            resourceDescription_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Description of the resource.
         * </pre>
         *
         * <code>optional string resource_description = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The bytes for resourceDescription.
         */
        public com.google.protobuf.ByteString getResourceDescriptionBytes() {
          java.lang.Object ref = resourceDescription_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            resourceDescription_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Description of the resource.
         * </pre>
         *
         * <code>optional string resource_description = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The resourceDescription to set.
         * @return This builder for chaining.
         */
        public Builder setResourceDescription(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          resourceDescription_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Description of the resource.
         * </pre>
         *
         * <code>optional string resource_description = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearResourceDescription() {
          resourceDescription_ = getDefaultInstance().getResourceDescription();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Description of the resource.
         * </pre>
         *
         * <code>optional string resource_description = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The bytes for resourceDescription to set.
         * @return This builder for chaining.
         */
        public Builder setResourceDescriptionBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          resourceDescription_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences)
      private static final com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .RegionalResourceReferences();
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<RegionalResourceReferences> PARSER =
          new com.google.protobuf.AbstractParser<RegionalResourceReferences>() {
            @java.lang.Override
            public RegionalResourceReferences parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<RegionalResourceReferences> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<RegionalResourceReferences> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ViewRestApiOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation>
          getDocumentationsList();
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation getDocumentations(int index);
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      int getDocumentationsCount();
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.aiplatform.v1beta1.PublisherModel.DocumentationOrBuilder>
          getDocumentationsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.PublisherModel.DocumentationOrBuilder
          getDocumentationsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * Required. The title of the view rest API.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      java.lang.String getTitle();
      /**
       *
       *
       * <pre>
       * Required. The title of the view rest API.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      com.google.protobuf.ByteString getTitleBytes();
    }
    /**
     *
     *
     * <pre>
     * Rest API docs.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi}
     */
    public static final class ViewRestApi extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi)
        ViewRestApiOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ViewRestApi.newBuilder() to construct.
      private ViewRestApi(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ViewRestApi() {
        documentations_ = java.util.Collections.emptyList();
        title_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ViewRestApi();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_ViewRestApi_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_ViewRestApi_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi.class,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi.Builder
                    .class);
      }

      public static final int DOCUMENTATIONS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation>
          documentations_;
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation>
          getDocumentationsList() {
        return documentations_;
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.aiplatform.v1beta1.PublisherModel.DocumentationOrBuilder>
          getDocumentationsOrBuilderList() {
        return documentations_;
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public int getDocumentationsCount() {
        return documentations_.size();
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation getDocumentations(
          int index) {
        return documentations_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.DocumentationOrBuilder
          getDocumentationsOrBuilder(int index) {
        return documentations_.get(index);
      }

      public static final int TITLE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object title_ = "";
      /**
       *
       *
       * <pre>
       * Required. The title of the view rest API.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      @java.lang.Override
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The title of the view rest API.
       * </pre>
       *
       * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < documentations_.size(); i++) {
          output.writeMessage(1, documentations_.get(i));
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, title_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < documentations_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(1, documentations_.get(i));
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, title_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi other =
            (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi) obj;

        if (!getDocumentationsList().equals(other.getDocumentationsList())) return false;
        if (!getTitle().equals(other.getTitle())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getDocumentationsCount() > 0) {
          hash = (37 * hash) + DOCUMENTATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getDocumentationsList().hashCode();
        }
        hash = (37 * hash) + TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getTitle().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Rest API docs.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi)
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApiOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_ViewRestApi_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_ViewRestApi_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi.class,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (documentationsBuilder_ == null) {
            documentations_ = java.util.Collections.emptyList();
          } else {
            documentations_ = null;
            documentationsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          title_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_ViewRestApi_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi build() {
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi result =
              new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi result) {
          if (documentationsBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              documentations_ = java.util.Collections.unmodifiableList(documentations_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.documentations_ = documentations_;
          } else {
            result.documentations_ = documentationsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.title_ = title_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
                  .getDefaultInstance()) return this;
          if (documentationsBuilder_ == null) {
            if (!other.documentations_.isEmpty()) {
              if (documentations_.isEmpty()) {
                documentations_ = other.documentations_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureDocumentationsIsMutable();
                documentations_.addAll(other.documentations_);
              }
              onChanged();
            }
          } else {
            if (!other.documentations_.isEmpty()) {
              if (documentationsBuilder_.isEmpty()) {
                documentationsBuilder_.dispose();
                documentationsBuilder_ = null;
                documentations_ = other.documentations_;
                bitField0_ = (bitField0_ & ~0x00000001);
                documentationsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDocumentationsFieldBuilder()
                        : null;
              } else {
                documentationsBuilder_.addAllMessages(other.documentations_);
              }
            }
          }
          if (!other.getTitle().isEmpty()) {
            title_ = other.title_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation m =
                        input.readMessage(
                            com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation
                                .parser(),
                            extensionRegistry);
                    if (documentationsBuilder_ == null) {
                      ensureDocumentationsIsMutable();
                      documentations_.add(m);
                    } else {
                      documentationsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 10
                case 18:
                  {
                    title_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.util.List<com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation>
            documentations_ = java.util.Collections.emptyList();

        private void ensureDocumentationsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            documentations_ =
                new java.util.ArrayList<
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation>(
                    documentations_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation.Builder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.DocumentationOrBuilder>
            documentationsBuilder_;

        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation>
            getDocumentationsList() {
          if (documentationsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(documentations_);
          } else {
            return documentationsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public int getDocumentationsCount() {
          if (documentationsBuilder_ == null) {
            return documentations_.size();
          } else {
            return documentationsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation getDocumentations(
            int index) {
          if (documentationsBuilder_ == null) {
            return documentations_.get(index);
          } else {
            return documentationsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setDocumentations(
            int index, com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation value) {
          if (documentationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDocumentationsIsMutable();
            documentations_.set(index, value);
            onChanged();
          } else {
            documentationsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setDocumentations(
            int index,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation.Builder
                builderForValue) {
          if (documentationsBuilder_ == null) {
            ensureDocumentationsIsMutable();
            documentations_.set(index, builderForValue.build());
            onChanged();
          } else {
            documentationsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addDocumentations(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation value) {
          if (documentationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDocumentationsIsMutable();
            documentations_.add(value);
            onChanged();
          } else {
            documentationsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addDocumentations(
            int index, com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation value) {
          if (documentationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDocumentationsIsMutable();
            documentations_.add(index, value);
            onChanged();
          } else {
            documentationsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addDocumentations(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation.Builder
                builderForValue) {
          if (documentationsBuilder_ == null) {
            ensureDocumentationsIsMutable();
            documentations_.add(builderForValue.build());
            onChanged();
          } else {
            documentationsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addDocumentations(
            int index,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation.Builder
                builderForValue) {
          if (documentationsBuilder_ == null) {
            ensureDocumentationsIsMutable();
            documentations_.add(index, builderForValue.build());
            onChanged();
          } else {
            documentationsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addAllDocumentations(
            java.lang.Iterable<
                    ? extends com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation>
                values) {
          if (documentationsBuilder_ == null) {
            ensureDocumentationsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, documentations_);
            onChanged();
          } else {
            documentationsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearDocumentations() {
          if (documentationsBuilder_ == null) {
            documentations_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            documentationsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder removeDocumentations(int index) {
          if (documentationsBuilder_ == null) {
            ensureDocumentationsIsMutable();
            documentations_.remove(index);
            onChanged();
          } else {
            documentationsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation.Builder
            getDocumentationsBuilder(int index) {
          return getDocumentationsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.DocumentationOrBuilder
            getDocumentationsOrBuilder(int index) {
          if (documentationsBuilder_ == null) {
            return documentations_.get(index);
          } else {
            return documentationsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                ? extends com.google.cloud.aiplatform.v1beta1.PublisherModel.DocumentationOrBuilder>
            getDocumentationsOrBuilderList() {
          if (documentationsBuilder_ != null) {
            return documentationsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(documentations_);
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation.Builder
            addDocumentationsBuilder() {
          return getDocumentationsFieldBuilder()
              .addBuilder(
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation.Builder
            addDocumentationsBuilder(int index) {
          return getDocumentationsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.Documentation documentations = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation.Builder>
            getDocumentationsBuilderList() {
          return getDocumentationsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation.Builder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.DocumentationOrBuilder>
            getDocumentationsFieldBuilder() {
          if (documentationsBuilder_ == null) {
            documentationsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation,
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.Documentation.Builder,
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.DocumentationOrBuilder>(
                    documentations_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            documentations_ = null;
          }
          return documentationsBuilder_;
        }

        private java.lang.Object title_ = "";
        /**
         *
         *
         * <pre>
         * Required. The title of the view rest API.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The title.
         */
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the view rest API.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for title.
         */
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the view rest API.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The title to set.
         * @return This builder for chaining.
         */
        public Builder setTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          title_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the view rest API.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTitle() {
          title_ = getDefaultInstance().getTitle();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the view rest API.
         * </pre>
         *
         * <code>string title = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for title to set.
         * @return This builder for chaining.
         */
        public Builder setTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          title_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi)
      private static final com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .ViewRestApi
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi();
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ViewRestApi> PARSER =
          new com.google.protobuf.AbstractParser<ViewRestApi>() {
            @java.lang.Override
            public ViewRestApi parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ViewRestApi> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ViewRestApi> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface OpenNotebooksOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Regional resource references to notebooks.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences>
          getNotebooksList();
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to notebooks.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
          getNotebooks(int index);
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to notebooks.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      int getNotebooksCount();
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to notebooks.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>
          getNotebooksOrBuilderList();
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to notebooks.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getNotebooksOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Open notebooks.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks}
     */
    public static final class OpenNotebooks extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks)
        OpenNotebooksOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use OpenNotebooks.newBuilder() to construct.
      private OpenNotebooks(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private OpenNotebooks() {
        notebooks_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new OpenNotebooks();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_OpenNotebooks_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_OpenNotebooks_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks.class,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
                    .Builder.class);
      }

      public static final int NOTEBOOKS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences>
          notebooks_;
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to notebooks.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences>
          getNotebooksList() {
        return notebooks_;
      }
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to notebooks.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>
          getNotebooksOrBuilderList() {
        return notebooks_;
      }
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to notebooks.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public int getNotebooksCount() {
        return notebooks_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to notebooks.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          getNotebooks(int index) {
        return notebooks_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to notebooks.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getNotebooksOrBuilder(int index) {
        return notebooks_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < notebooks_.size(); i++) {
          output.writeMessage(1, notebooks_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < notebooks_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, notebooks_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks other =
            (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks) obj;

        if (!getNotebooksList().equals(other.getNotebooksList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getNotebooksCount() > 0) {
          hash = (37 * hash) + NOTEBOOKS_FIELD_NUMBER;
          hash = (53 * hash) + getNotebooksList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Open notebooks.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks)
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooksOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_OpenNotebooks_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_OpenNotebooks_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
                      .class,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (notebooksBuilder_ == null) {
            notebooks_ = java.util.Collections.emptyList();
          } else {
            notebooks_ = null;
            notebooksBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_OpenNotebooks_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
            build() {
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks result =
              new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks(
                  this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks result) {
          if (notebooksBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              notebooks_ = java.util.Collections.unmodifiableList(notebooks_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.notebooks_ = notebooks_;
          } else {
            result.notebooks_ = notebooksBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks result) {
          int from_bitField0_ = bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
                  .getDefaultInstance()) return this;
          if (notebooksBuilder_ == null) {
            if (!other.notebooks_.isEmpty()) {
              if (notebooks_.isEmpty()) {
                notebooks_ = other.notebooks_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureNotebooksIsMutable();
                notebooks_.addAll(other.notebooks_);
              }
              onChanged();
            }
          } else {
            if (!other.notebooks_.isEmpty()) {
              if (notebooksBuilder_.isEmpty()) {
                notebooksBuilder_.dispose();
                notebooksBuilder_ = null;
                notebooks_ = other.notebooks_;
                bitField0_ = (bitField0_ & ~0x00000001);
                notebooksBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getNotebooksFieldBuilder()
                        : null;
              } else {
                notebooksBuilder_.addAllMessages(other.notebooks_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                            .RegionalResourceReferences
                        m =
                            input.readMessage(
                                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                                    .RegionalResourceReferences.parser(),
                                extensionRegistry);
                    if (notebooksBuilder_ == null) {
                      ensureNotebooksIsMutable();
                      notebooks_.add(m);
                    } else {
                      notebooksBuilder_.addMessage(m);
                    }
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.util.List<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences>
            notebooks_ = java.util.Collections.emptyList();

        private void ensureNotebooksIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            notebooks_ =
                new java.util.ArrayList<
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                        .RegionalResourceReferences>(notebooks_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences.Builder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferencesOrBuilder>
            notebooksBuilder_;

        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences>
            getNotebooksList() {
          if (notebooksBuilder_ == null) {
            return java.util.Collections.unmodifiableList(notebooks_);
          } else {
            return notebooksBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public int getNotebooksCount() {
          if (notebooksBuilder_ == null) {
            return notebooks_.size();
          } else {
            return notebooksBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .RegionalResourceReferences
            getNotebooks(int index) {
          if (notebooksBuilder_ == null) {
            return notebooks_.get(index);
          } else {
            return notebooksBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setNotebooks(
            int index,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences
                value) {
          if (notebooksBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureNotebooksIsMutable();
            notebooks_.set(index, value);
            onChanged();
          } else {
            notebooksBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setNotebooks(
            int index,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences.Builder
                builderForValue) {
          if (notebooksBuilder_ == null) {
            ensureNotebooksIsMutable();
            notebooks_.set(index, builderForValue.build());
            onChanged();
          } else {
            notebooksBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addNotebooks(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences
                value) {
          if (notebooksBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureNotebooksIsMutable();
            notebooks_.add(value);
            onChanged();
          } else {
            notebooksBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addNotebooks(
            int index,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences
                value) {
          if (notebooksBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureNotebooksIsMutable();
            notebooks_.add(index, value);
            onChanged();
          } else {
            notebooksBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addNotebooks(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences.Builder
                builderForValue) {
          if (notebooksBuilder_ == null) {
            ensureNotebooksIsMutable();
            notebooks_.add(builderForValue.build());
            onChanged();
          } else {
            notebooksBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addNotebooks(
            int index,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences.Builder
                builderForValue) {
          if (notebooksBuilder_ == null) {
            ensureNotebooksIsMutable();
            notebooks_.add(index, builderForValue.build());
            onChanged();
          } else {
            notebooksBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addAllNotebooks(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                            .RegionalResourceReferences>
                values) {
          if (notebooksBuilder_ == null) {
            ensureNotebooksIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, notebooks_);
            onChanged();
          } else {
            notebooksBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearNotebooks() {
          if (notebooksBuilder_ == null) {
            notebooks_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            notebooksBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder removeNotebooks(int index) {
          if (notebooksBuilder_ == null) {
            ensureNotebooksIsMutable();
            notebooks_.remove(index);
            onChanged();
          } else {
            notebooksBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .RegionalResourceReferences.Builder
            getNotebooksBuilder(int index) {
          return getNotebooksFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .RegionalResourceReferencesOrBuilder
            getNotebooksOrBuilder(int index) {
          if (notebooksBuilder_ == null) {
            return notebooks_.get(index);
          } else {
            return notebooksBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                        .RegionalResourceReferencesOrBuilder>
            getNotebooksOrBuilderList() {
          if (notebooksBuilder_ != null) {
            return notebooksBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(notebooks_);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .RegionalResourceReferences.Builder
            addNotebooksBuilder() {
          return getNotebooksFieldBuilder()
              .addBuilder(
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .RegionalResourceReferences.Builder
            addNotebooksBuilder(int index) {
          return getNotebooksFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to notebooks.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences notebooks = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences.Builder>
            getNotebooksBuilderList() {
          return getNotebooksFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences.Builder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferencesOrBuilder>
            getNotebooksFieldBuilder() {
          if (notebooksBuilder_ == null) {
            notebooksBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                        .RegionalResourceReferences,
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                        .RegionalResourceReferences.Builder,
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                        .RegionalResourceReferencesOrBuilder>(
                    notebooks_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            notebooks_ = null;
          }
          return notebooksBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks)
      private static final com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenNotebooks
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks();
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<OpenNotebooks> PARSER =
          new com.google.protobuf.AbstractParser<OpenNotebooks>() {
            @java.lang.Override
            public OpenNotebooks parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<OpenNotebooks> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<OpenNotebooks> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface OpenFineTuningPipelinesOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Regional resource references to fine tuning pipelines.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences>
          getFineTuningPipelinesList();
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to fine tuning pipelines.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
          getFineTuningPipelines(int index);
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to fine tuning pipelines.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      int getFineTuningPipelinesCount();
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to fine tuning pipelines.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>
          getFineTuningPipelinesOrBuilderList();
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to fine tuning pipelines.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getFineTuningPipelinesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Open fine tuning pipelines.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines}
     */
    public static final class OpenFineTuningPipelines extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines)
        OpenFineTuningPipelinesOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use OpenFineTuningPipelines.newBuilder() to construct.
      private OpenFineTuningPipelines(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private OpenFineTuningPipelines() {
        fineTuningPipelines_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new OpenFineTuningPipelines();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_OpenFineTuningPipelines_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_OpenFineTuningPipelines_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .OpenFineTuningPipelines.class,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .OpenFineTuningPipelines.Builder.class);
      }

      public static final int FINE_TUNING_PIPELINES_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences>
          fineTuningPipelines_;
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to fine tuning pipelines.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences>
          getFineTuningPipelinesList() {
        return fineTuningPipelines_;
      }
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to fine tuning pipelines.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>
          getFineTuningPipelinesOrBuilderList() {
        return fineTuningPipelines_;
      }
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to fine tuning pipelines.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public int getFineTuningPipelinesCount() {
        return fineTuningPipelines_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to fine tuning pipelines.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          getFineTuningPipelines(int index) {
        return fineTuningPipelines_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. Regional resource references to fine tuning pipelines.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getFineTuningPipelinesOrBuilder(int index) {
        return fineTuningPipelines_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < fineTuningPipelines_.size(); i++) {
          output.writeMessage(1, fineTuningPipelines_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < fineTuningPipelines_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1, fineTuningPipelines_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .OpenFineTuningPipelines)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
            other =
                (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                        .OpenFineTuningPipelines)
                    obj;

        if (!getFineTuningPipelinesList().equals(other.getFineTuningPipelinesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getFineTuningPipelinesCount() > 0) {
          hash = (37 * hash) + FINE_TUNING_PIPELINES_FIELD_NUMBER;
          hash = (53 * hash) + getFineTuningPipelinesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Open fine tuning pipelines.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines)
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelinesOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_OpenFineTuningPipelines_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_OpenFineTuningPipelines_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .OpenFineTuningPipelines.class,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .OpenFineTuningPipelines.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (fineTuningPipelinesBuilder_ == null) {
            fineTuningPipelines_ = java.util.Collections.emptyList();
          } else {
            fineTuningPipelines_ = null;
            fineTuningPipelinesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_OpenFineTuningPipelines_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .OpenFineTuningPipelines
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .OpenFineTuningPipelines
            build() {
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .OpenFineTuningPipelines
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
              result =
                  new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .OpenFineTuningPipelines(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
                result) {
          if (fineTuningPipelinesBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              fineTuningPipelines_ = java.util.Collections.unmodifiableList(fineTuningPipelines_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.fineTuningPipelines_ = fineTuningPipelines_;
          } else {
            result.fineTuningPipelines_ = fineTuningPipelinesBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
                result) {
          int from_bitField0_ = bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .OpenFineTuningPipelines) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                        .OpenFineTuningPipelines)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .OpenFineTuningPipelines.getDefaultInstance()) return this;
          if (fineTuningPipelinesBuilder_ == null) {
            if (!other.fineTuningPipelines_.isEmpty()) {
              if (fineTuningPipelines_.isEmpty()) {
                fineTuningPipelines_ = other.fineTuningPipelines_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureFineTuningPipelinesIsMutable();
                fineTuningPipelines_.addAll(other.fineTuningPipelines_);
              }
              onChanged();
            }
          } else {
            if (!other.fineTuningPipelines_.isEmpty()) {
              if (fineTuningPipelinesBuilder_.isEmpty()) {
                fineTuningPipelinesBuilder_.dispose();
                fineTuningPipelinesBuilder_ = null;
                fineTuningPipelines_ = other.fineTuningPipelines_;
                bitField0_ = (bitField0_ & ~0x00000001);
                fineTuningPipelinesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getFineTuningPipelinesFieldBuilder()
                        : null;
              } else {
                fineTuningPipelinesBuilder_.addAllMessages(other.fineTuningPipelines_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                            .RegionalResourceReferences
                        m =
                            input.readMessage(
                                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                                    .RegionalResourceReferences.parser(),
                                extensionRegistry);
                    if (fineTuningPipelinesBuilder_ == null) {
                      ensureFineTuningPipelinesIsMutable();
                      fineTuningPipelines_.add(m);
                    } else {
                      fineTuningPipelinesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.util.List<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences>
            fineTuningPipelines_ = java.util.Collections.emptyList();

        private void ensureFineTuningPipelinesIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            fineTuningPipelines_ =
                new java.util.ArrayList<
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                        .RegionalResourceReferences>(fineTuningPipelines_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences.Builder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferencesOrBuilder>
            fineTuningPipelinesBuilder_;

        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences>
            getFineTuningPipelinesList() {
          if (fineTuningPipelinesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(fineTuningPipelines_);
          } else {
            return fineTuningPipelinesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public int getFineTuningPipelinesCount() {
          if (fineTuningPipelinesBuilder_ == null) {
            return fineTuningPipelines_.size();
          } else {
            return fineTuningPipelinesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .RegionalResourceReferences
            getFineTuningPipelines(int index) {
          if (fineTuningPipelinesBuilder_ == null) {
            return fineTuningPipelines_.get(index);
          } else {
            return fineTuningPipelinesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setFineTuningPipelines(
            int index,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences
                value) {
          if (fineTuningPipelinesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureFineTuningPipelinesIsMutable();
            fineTuningPipelines_.set(index, value);
            onChanged();
          } else {
            fineTuningPipelinesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setFineTuningPipelines(
            int index,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences.Builder
                builderForValue) {
          if (fineTuningPipelinesBuilder_ == null) {
            ensureFineTuningPipelinesIsMutable();
            fineTuningPipelines_.set(index, builderForValue.build());
            onChanged();
          } else {
            fineTuningPipelinesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addFineTuningPipelines(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences
                value) {
          if (fineTuningPipelinesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureFineTuningPipelinesIsMutable();
            fineTuningPipelines_.add(value);
            onChanged();
          } else {
            fineTuningPipelinesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addFineTuningPipelines(
            int index,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences
                value) {
          if (fineTuningPipelinesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureFineTuningPipelinesIsMutable();
            fineTuningPipelines_.add(index, value);
            onChanged();
          } else {
            fineTuningPipelinesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addFineTuningPipelines(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences.Builder
                builderForValue) {
          if (fineTuningPipelinesBuilder_ == null) {
            ensureFineTuningPipelinesIsMutable();
            fineTuningPipelines_.add(builderForValue.build());
            onChanged();
          } else {
            fineTuningPipelinesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addFineTuningPipelines(
            int index,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences.Builder
                builderForValue) {
          if (fineTuningPipelinesBuilder_ == null) {
            ensureFineTuningPipelinesIsMutable();
            fineTuningPipelines_.add(index, builderForValue.build());
            onChanged();
          } else {
            fineTuningPipelinesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder addAllFineTuningPipelines(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                            .RegionalResourceReferences>
                values) {
          if (fineTuningPipelinesBuilder_ == null) {
            ensureFineTuningPipelinesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fineTuningPipelines_);
            onChanged();
          } else {
            fineTuningPipelinesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearFineTuningPipelines() {
          if (fineTuningPipelinesBuilder_ == null) {
            fineTuningPipelines_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            fineTuningPipelinesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder removeFineTuningPipelines(int index) {
          if (fineTuningPipelinesBuilder_ == null) {
            ensureFineTuningPipelinesIsMutable();
            fineTuningPipelines_.remove(index);
            onChanged();
          } else {
            fineTuningPipelinesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .RegionalResourceReferences.Builder
            getFineTuningPipelinesBuilder(int index) {
          return getFineTuningPipelinesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .RegionalResourceReferencesOrBuilder
            getFineTuningPipelinesOrBuilder(int index) {
          if (fineTuningPipelinesBuilder_ == null) {
            return fineTuningPipelines_.get(index);
          } else {
            return fineTuningPipelinesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                        .RegionalResourceReferencesOrBuilder>
            getFineTuningPipelinesOrBuilderList() {
          if (fineTuningPipelinesBuilder_ != null) {
            return fineTuningPipelinesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(fineTuningPipelines_);
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .RegionalResourceReferences.Builder
            addFineTuningPipelinesBuilder() {
          return getFineTuningPipelinesFieldBuilder()
              .addBuilder(
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .RegionalResourceReferences.Builder
            addFineTuningPipelinesBuilder(int index) {
          return getFineTuningPipelinesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Required. Regional resource references to fine tuning pipelines.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences fine_tuning_pipelines = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public java.util.List<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences.Builder>
            getFineTuningPipelinesBuilderList() {
          return getFineTuningPipelinesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferences.Builder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .RegionalResourceReferencesOrBuilder>
            getFineTuningPipelinesFieldBuilder() {
          if (fineTuningPipelinesBuilder_ == null) {
            fineTuningPipelinesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                        .RegionalResourceReferences,
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                        .RegionalResourceReferences.Builder,
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                        .RegionalResourceReferencesOrBuilder>(
                    fineTuningPipelines_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            fineTuningPipelines_ = null;
          }
          return fineTuningPipelinesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines)
      private static final com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                .OpenFineTuningPipelines();
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<OpenFineTuningPipelines> PARSER =
          new com.google.protobuf.AbstractParser<OpenFineTuningPipelines>() {
            @java.lang.Override
            public OpenFineTuningPipelines parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<OpenFineTuningPipelines> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<OpenFineTuningPipelines> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface DeployVertexOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. One click deployment configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.List<com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy>
          getMultiDeployVertexList();
      /**
       *
       *
       * <pre>
       * Optional. One click deployment configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy getMultiDeployVertex(
          int index);
      /**
       *
       *
       * <pre>
       * Optional. One click deployment configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      int getMultiDeployVertexCount();
      /**
       *
       *
       * <pre>
       * Optional. One click deployment configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployOrBuilder>
          getMultiDeployVertexOrBuilderList();
      /**
       *
       *
       * <pre>
       * Optional. One click deployment configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployOrBuilder
          getMultiDeployVertexOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Multiple setups to deploy the PublisherModel.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex}
     */
    public static final class DeployVertex extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex)
        DeployVertexOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DeployVertex.newBuilder() to construct.
      private DeployVertex(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DeployVertex() {
        multiDeployVertex_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DeployVertex();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_DeployVertex_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_DeployVertex_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex.class,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex.Builder
                    .class);
      }

      public static final int MULTI_DEPLOY_VERTEX_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy>
          multiDeployVertex_;
      /**
       *
       *
       * <pre>
       * Optional. One click deployment configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy>
          getMultiDeployVertexList() {
        return multiDeployVertex_;
      }
      /**
       *
       *
       * <pre>
       * Optional. One click deployment configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployOrBuilder>
          getMultiDeployVertexOrBuilderList() {
        return multiDeployVertex_;
      }
      /**
       *
       *
       * <pre>
       * Optional. One click deployment configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public int getMultiDeployVertexCount() {
        return multiDeployVertex_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. One click deployment configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          getMultiDeployVertex(int index) {
        return multiDeployVertex_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. One click deployment configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployOrBuilder
          getMultiDeployVertexOrBuilder(int index) {
        return multiDeployVertex_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < multiDeployVertex_.size(); i++) {
          output.writeMessage(1, multiDeployVertex_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < multiDeployVertex_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1, multiDeployVertex_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex other =
            (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex) obj;

        if (!getMultiDeployVertexList().equals(other.getMultiDeployVertexList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getMultiDeployVertexCount() > 0) {
          hash = (37 * hash) + MULTI_DEPLOY_VERTEX_FIELD_NUMBER;
          hash = (53 * hash) + getMultiDeployVertexList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Multiple setups to deploy the PublisherModel.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex)
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertexOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_DeployVertex_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_DeployVertex_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
                      .class,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (multiDeployVertexBuilder_ == null) {
            multiDeployVertex_ = java.util.Collections.emptyList();
          } else {
            multiDeployVertex_ = null;
            multiDeployVertexBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_DeployVertex_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
            build() {
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex result =
              new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex(
                  this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex result) {
          if (multiDeployVertexBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              multiDeployVertex_ = java.util.Collections.unmodifiableList(multiDeployVertex_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.multiDeployVertex_ = multiDeployVertex_;
          } else {
            result.multiDeployVertex_ = multiDeployVertexBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex result) {
          int from_bitField0_ = bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
                  .getDefaultInstance()) return this;
          if (multiDeployVertexBuilder_ == null) {
            if (!other.multiDeployVertex_.isEmpty()) {
              if (multiDeployVertex_.isEmpty()) {
                multiDeployVertex_ = other.multiDeployVertex_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureMultiDeployVertexIsMutable();
                multiDeployVertex_.addAll(other.multiDeployVertex_);
              }
              onChanged();
            }
          } else {
            if (!other.multiDeployVertex_.isEmpty()) {
              if (multiDeployVertexBuilder_.isEmpty()) {
                multiDeployVertexBuilder_.dispose();
                multiDeployVertexBuilder_ = null;
                multiDeployVertex_ = other.multiDeployVertex_;
                bitField0_ = (bitField0_ & ~0x00000001);
                multiDeployVertexBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getMultiDeployVertexFieldBuilder()
                        : null;
              } else {
                multiDeployVertexBuilder_.addAllMessages(other.multiDeployVertex_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy m =
                        input.readMessage(
                            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                                .parser(),
                            extensionRegistry);
                    if (multiDeployVertexBuilder_ == null) {
                      ensureMultiDeployVertexIsMutable();
                      multiDeployVertex_.add(m);
                    } else {
                      multiDeployVertexBuilder_.addMessage(m);
                    }
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.util.List<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy>
            multiDeployVertex_ = java.util.Collections.emptyList();

        private void ensureMultiDeployVertexIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            multiDeployVertex_ =
                new java.util.ArrayList<
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy>(
                    multiDeployVertex_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployOrBuilder>
            multiDeployVertexBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy>
            getMultiDeployVertexList() {
          if (multiDeployVertexBuilder_ == null) {
            return java.util.Collections.unmodifiableList(multiDeployVertex_);
          } else {
            return multiDeployVertexBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public int getMultiDeployVertexCount() {
          if (multiDeployVertexBuilder_ == null) {
            return multiDeployVertex_.size();
          } else {
            return multiDeployVertexBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
            getMultiDeployVertex(int index) {
          if (multiDeployVertexBuilder_ == null) {
            return multiDeployVertex_.get(index);
          } else {
            return multiDeployVertexBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setMultiDeployVertex(
            int index,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy value) {
          if (multiDeployVertexBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMultiDeployVertexIsMutable();
            multiDeployVertex_.set(index, value);
            onChanged();
          } else {
            multiDeployVertexBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setMultiDeployVertex(
            int index,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder
                builderForValue) {
          if (multiDeployVertexBuilder_ == null) {
            ensureMultiDeployVertexIsMutable();
            multiDeployVertex_.set(index, builderForValue.build());
            onChanged();
          } else {
            multiDeployVertexBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addMultiDeployVertex(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy value) {
          if (multiDeployVertexBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMultiDeployVertexIsMutable();
            multiDeployVertex_.add(value);
            onChanged();
          } else {
            multiDeployVertexBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addMultiDeployVertex(
            int index,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy value) {
          if (multiDeployVertexBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMultiDeployVertexIsMutable();
            multiDeployVertex_.add(index, value);
            onChanged();
          } else {
            multiDeployVertexBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addMultiDeployVertex(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder
                builderForValue) {
          if (multiDeployVertexBuilder_ == null) {
            ensureMultiDeployVertexIsMutable();
            multiDeployVertex_.add(builderForValue.build());
            onChanged();
          } else {
            multiDeployVertexBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addMultiDeployVertex(
            int index,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder
                builderForValue) {
          if (multiDeployVertexBuilder_ == null) {
            ensureMultiDeployVertexIsMutable();
            multiDeployVertex_.add(index, builderForValue.build());
            onChanged();
          } else {
            multiDeployVertexBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addAllMultiDeployVertex(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy>
                values) {
          if (multiDeployVertexBuilder_ == null) {
            ensureMultiDeployVertexIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, multiDeployVertex_);
            onChanged();
          } else {
            multiDeployVertexBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearMultiDeployVertex() {
          if (multiDeployVertexBuilder_ == null) {
            multiDeployVertex_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            multiDeployVertexBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder removeMultiDeployVertex(int index) {
          if (multiDeployVertexBuilder_ == null) {
            ensureMultiDeployVertexIsMutable();
            multiDeployVertex_.remove(index);
            onChanged();
          } else {
            multiDeployVertexBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder
            getMultiDeployVertexBuilder(int index) {
          return getMultiDeployVertexFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployOrBuilder
            getMultiDeployVertexOrBuilder(int index) {
          if (multiDeployVertexBuilder_ == null) {
            return multiDeployVertex_.get(index);
          } else {
            return multiDeployVertexBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployOrBuilder>
            getMultiDeployVertexOrBuilderList() {
          if (multiDeployVertexBuilder_ != null) {
            return multiDeployVertexBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(multiDeployVertex_);
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder
            addMultiDeployVertexBuilder() {
          return getMultiDeployVertexFieldBuilder()
              .addBuilder(
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder
            addMultiDeployVertexBuilder(int index) {
          return getMultiDeployVertexFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Optional. One click deployment configurations.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy multi_deploy_vertex = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder>
            getMultiDeployVertexBuilderList() {
          return getMultiDeployVertexFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployOrBuilder>
            getMultiDeployVertexFieldBuilder() {
          if (multiDeployVertexBuilder_ == null) {
            multiDeployVertexBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy,
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder,
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                        .DeployOrBuilder>(
                    multiDeployVertex_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            multiDeployVertex_ = null;
          }
          return multiDeployVertexBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex)
      private static final com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .DeployVertex
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex();
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DeployVertex> PARSER =
          new com.google.protobuf.AbstractParser<DeployVertex>() {
            @java.lang.Override
            public DeployVertex parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DeployVertex> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DeployVertex> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface DeployOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * A description of resources that are dedicated to the DeployedModel,
       * and that need a higher degree of manual configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 5;</code>
       *
       * @return Whether the dedicatedResources field is set.
       */
      boolean hasDedicatedResources();
      /**
       *
       *
       * <pre>
       * A description of resources that are dedicated to the DeployedModel,
       * and that need a higher degree of manual configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 5;</code>
       *
       * @return The dedicatedResources.
       */
      com.google.cloud.aiplatform.v1beta1.DedicatedResources getDedicatedResources();
      /**
       *
       *
       * <pre>
       * A description of resources that are dedicated to the DeployedModel,
       * and that need a higher degree of manual configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 5;</code>
       */
      com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder
          getDedicatedResourcesOrBuilder();

      /**
       *
       *
       * <pre>
       * A description of resources that to large degree are decided by Vertex
       * AI, and require only a modest additional configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 6;</code>
       *
       * @return Whether the automaticResources field is set.
       */
      boolean hasAutomaticResources();
      /**
       *
       *
       * <pre>
       * A description of resources that to large degree are decided by Vertex
       * AI, and require only a modest additional configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 6;</code>
       *
       * @return The automaticResources.
       */
      com.google.cloud.aiplatform.v1beta1.AutomaticResources getAutomaticResources();
      /**
       *
       *
       * <pre>
       * A description of resources that to large degree are decided by Vertex
       * AI, and require only a modest additional configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 6;</code>
       */
      com.google.cloud.aiplatform.v1beta1.AutomaticResourcesOrBuilder
          getAutomaticResourcesOrBuilder();

      /**
       *
       *
       * <pre>
       * The resource name of the shared DeploymentResourcePool to deploy on.
       * Format:
       * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
       * </pre>
       *
       * <code>string shared_resources = 7;</code>
       *
       * @return Whether the sharedResources field is set.
       */
      boolean hasSharedResources();
      /**
       *
       *
       * <pre>
       * The resource name of the shared DeploymentResourcePool to deploy on.
       * Format:
       * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
       * </pre>
       *
       * <code>string shared_resources = 7;</code>
       *
       * @return The sharedResources.
       */
      java.lang.String getSharedResources();
      /**
       *
       *
       * <pre>
       * The resource name of the shared DeploymentResourcePool to deploy on.
       * Format:
       * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
       * </pre>
       *
       * <code>string shared_resources = 7;</code>
       *
       * @return The bytes for sharedResources.
       */
      com.google.protobuf.ByteString getSharedResourcesBytes();

      /**
       *
       *
       * <pre>
       * Optional. Default model display name.
       * </pre>
       *
       * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The modelDisplayName.
       */
      java.lang.String getModelDisplayName();
      /**
       *
       *
       * <pre>
       * Optional. Default model display name.
       * </pre>
       *
       * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for modelDisplayName.
       */
      com.google.protobuf.ByteString getModelDisplayNameBytes();

      /**
       *
       *
       * <pre>
       * Optional. Large model reference. When this is set, model_artifact_spec
       * is not needed.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the largeModelReference field is set.
       */
      boolean hasLargeModelReference();
      /**
       *
       *
       * <pre>
       * Optional. Large model reference. When this is set, model_artifact_spec
       * is not needed.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The largeModelReference.
       */
      com.google.cloud.aiplatform.v1beta1.LargeModelReference getLargeModelReference();
      /**
       *
       *
       * <pre>
       * Optional. Large model reference. When this is set, model_artifact_spec
       * is not needed.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.LargeModelReferenceOrBuilder
          getLargeModelReferenceOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying this Model in Vertex AI. Not present for Large Models.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the containerSpec field is set.
       */
      boolean hasContainerSpec();
      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying this Model in Vertex AI. Not present for Large Models.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The containerSpec.
       */
      com.google.cloud.aiplatform.v1beta1.ModelContainerSpec getContainerSpec();
      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying this Model in Vertex AI. Not present for Large Models.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder getContainerSpecOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. The path to the directory containing the Model artifact and
       * any of its supporting files.
       * </pre>
       *
       * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The artifactUri.
       */
      java.lang.String getArtifactUri();
      /**
       *
       *
       * <pre>
       * Optional. The path to the directory containing the Model artifact and
       * any of its supporting files.
       * </pre>
       *
       * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for artifactUri.
       */
      com.google.protobuf.ByteString getArtifactUriBytes();

      /**
       *
       *
       * <pre>
       * Optional. The name of the deploy task (e.g., "text to image
       * generation").
       * </pre>
       *
       * <code>optional string deploy_task_name = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the deployTaskName field is set.
       */
      boolean hasDeployTaskName();
      /**
       *
       *
       * <pre>
       * Optional. The name of the deploy task (e.g., "text to image
       * generation").
       * </pre>
       *
       * <code>optional string deploy_task_name = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The deployTaskName.
       */
      java.lang.String getDeployTaskName();
      /**
       *
       *
       * <pre>
       * Optional. The name of the deploy task (e.g., "text to image
       * generation").
       * </pre>
       *
       * <code>optional string deploy_task_name = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The bytes for deployTaskName.
       */
      com.google.protobuf.ByteString getDeployTaskNameBytes();

      /**
       *
       *
       * <pre>
       * Optional. Metadata information about this deployment config.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata deploy_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the deployMetadata field is set.
       */
      boolean hasDeployMetadata();
      /**
       *
       *
       * <pre>
       * Optional. Metadata information about this deployment config.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata deploy_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The deployMetadata.
       */
      com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
          getDeployMetadata();
      /**
       *
       *
       * <pre>
       * Optional. Metadata information about this deployment config.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata deploy_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadataOrBuilder
          getDeployMetadataOrBuilder();

      /**
       *
       *
       * <pre>
       * Required. The title of the regional resource reference.
       * </pre>
       *
       * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      java.lang.String getTitle();
      /**
       *
       *
       * <pre>
       * Required. The title of the regional resource reference.
       * </pre>
       *
       * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      com.google.protobuf.ByteString getTitleBytes();

      /**
       *
       *
       * <pre>
       * Optional. The signed URI for ephemeral Cloud Storage access to model
       * artifact.
       * </pre>
       *
       * <code>string public_artifact_uri = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The publicArtifactUri.
       */
      java.lang.String getPublicArtifactUri();
      /**
       *
       *
       * <pre>
       * Optional. The signed URI for ephemeral Cloud Storage access to model
       * artifact.
       * </pre>
       *
       * <code>string public_artifact_uri = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for publicArtifactUri.
       */
      com.google.protobuf.ByteString getPublicArtifactUriBytes();

      com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.PredictionResourcesCase
          getPredictionResourcesCase();
    }
    /**
     *
     *
     * <pre>
     * Model metadata that is needed for UploadModel or
     * DeployModel/CreateEndpoint requests.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy}
     */
    public static final class Deploy extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy)
        DeployOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Deploy.newBuilder() to construct.
      private Deploy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Deploy() {
        modelDisplayName_ = "";
        artifactUri_ = "";
        deployTaskName_ = "";
        title_ = "";
        publicArtifactUri_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Deploy();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_Deploy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_Deploy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.class,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder
                    .class);
      }

      public interface DeployMetadataOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Optional. Labels for the deployment config. For managing deployment
         * config like verifying, source of deployment config, etc.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        int getLabelsCount();
        /**
         *
         *
         * <pre>
         * Optional. Labels for the deployment config. For managing deployment
         * config like verifying, source of deployment config, etc.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        boolean containsLabels(java.lang.String key);
        /** Use {@link #getLabelsMap()} instead. */
        @java.lang.Deprecated
        java.util.Map<java.lang.String, java.lang.String> getLabels();
        /**
         *
         *
         * <pre>
         * Optional. Labels for the deployment config. For managing deployment
         * config like verifying, source of deployment config, etc.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
        /**
         *
         *
         * <pre>
         * Optional. Labels for the deployment config. For managing deployment
         * config like verifying, source of deployment config, etc.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        /* nullable */
        java.lang.String getLabelsOrDefault(
            java.lang.String key,
            /* nullable */
            java.lang.String defaultValue);
        /**
         *
         *
         * <pre>
         * Optional. Labels for the deployment config. For managing deployment
         * config like verifying, source of deployment config, etc.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        java.lang.String getLabelsOrThrow(java.lang.String key);

        /**
         *
         *
         * <pre>
         * Optional. Sample request for deployed endpoint.
         * </pre>
         *
         * <code>string sample_request = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The sampleRequest.
         */
        java.lang.String getSampleRequest();
        /**
         *
         *
         * <pre>
         * Optional. Sample request for deployed endpoint.
         * </pre>
         *
         * <code>string sample_request = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for sampleRequest.
         */
        com.google.protobuf.ByteString getSampleRequestBytes();
      }
      /**
       *
       *
       * <pre>
       * Metadata information about the deployment for managing deployment
       * config.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata}
       */
      public static final class DeployMetadata extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata)
          DeployMetadataOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use DeployMetadata.newBuilder() to construct.
        private DeployMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private DeployMetadata() {
          sampleRequest_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new DeployMetadata();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_Deploy_DeployMetadata_descriptor;
        }

        @SuppressWarnings({"rawtypes"})
        @java.lang.Override
        protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
            int number) {
          switch (number) {
            case 1:
              return internalGetLabels();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_Deploy_DeployMetadata_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                      .DeployMetadata.class,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                      .DeployMetadata.Builder.class);
        }

        public static final int LABELS_FIELD_NUMBER = 1;

        private static final class LabelsDefaultEntryHolder {
          static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
              defaultEntry =
                  com.google.protobuf.MapEntry
                      .<java.lang.String, java.lang.String>newDefaultInstance(
                          com.google.cloud.aiplatform.v1beta1.PublisherModelProto
                              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_Deploy_DeployMetadata_LabelsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "");
        }

        @SuppressWarnings("serial")
        private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
            internalGetLabels() {
          if (labels_ == null) {
            return com.google.protobuf.MapField.emptyMapField(
                LabelsDefaultEntryHolder.defaultEntry);
          }
          return labels_;
        }

        public int getLabelsCount() {
          return internalGetLabels().getMap().size();
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels for the deployment config. For managing deployment
         * config like verifying, source of deployment config, etc.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public boolean containsLabels(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          return internalGetLabels().getMap().containsKey(key);
        }
        /** Use {@link #getLabelsMap()} instead. */
        @java.lang.Override
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String> getLabels() {
          return getLabelsMap();
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels for the deployment config. For managing deployment
         * config like verifying, source of deployment config, etc.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
          return internalGetLabels().getMap();
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels for the deployment config. For managing deployment
         * config like verifying, source of deployment config, etc.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public /* nullable */ java.lang.String getLabelsOrDefault(
            java.lang.String key,
            /* nullable */
            java.lang.String defaultValue) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
          return map.containsKey(key) ? map.get(key) : defaultValue;
        }
        /**
         *
         *
         * <pre>
         * Optional. Labels for the deployment config. For managing deployment
         * config like verifying, source of deployment config, etc.
         * </pre>
         *
         * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public java.lang.String getLabelsOrThrow(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
          if (!map.containsKey(key)) {
            throw new java.lang.IllegalArgumentException();
          }
          return map.get(key);
        }

        public static final int SAMPLE_REQUEST_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object sampleRequest_ = "";
        /**
         *
         *
         * <pre>
         * Optional. Sample request for deployed endpoint.
         * </pre>
         *
         * <code>string sample_request = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The sampleRequest.
         */
        @java.lang.Override
        public java.lang.String getSampleRequest() {
          java.lang.Object ref = sampleRequest_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            sampleRequest_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Sample request for deployed endpoint.
         * </pre>
         *
         * <code>string sample_request = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for sampleRequest.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getSampleRequestBytes() {
          java.lang.Object ref = sampleRequest_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            sampleRequest_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
              output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 1);
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sampleRequest_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sampleRequest_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
              internalGetLabels().getMap().entrySet()) {
            com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                LabelsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, labels__);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sampleRequest_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sampleRequest_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                  .DeployMetadata)) {
            return super.equals(obj);
          }
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
              other =
                  (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                          .DeployMetadata)
                      obj;

          if (!internalGetLabels().equals(other.internalGetLabels())) return false;
          if (!getSampleRequest().equals(other.getSampleRequest())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (!internalGetLabels().getMap().isEmpty()) {
            hash = (37 * hash) + LABELS_FIELD_NUMBER;
            hash = (53 * hash) + internalGetLabels().hashCode();
          }
          hash = (37 * hash) + SAMPLE_REQUEST_FIELD_NUMBER;
          hash = (53 * hash) + getSampleRequest().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Metadata information about the deployment for managing deployment
         * config.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata)
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadataOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
                .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_Deploy_DeployMetadata_descriptor;
          }

          @SuppressWarnings({"rawtypes"})
          protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
              int number) {
            switch (number) {
              case 1:
                return internalGetLabels();
              default:
                throw new RuntimeException("Invalid map field number: " + number);
            }
          }

          @SuppressWarnings({"rawtypes"})
          protected com.google.protobuf.MapFieldReflectionAccessor
              internalGetMutableMapFieldReflection(int number) {
            switch (number) {
              case 1:
                return internalGetMutableLabels();
              default:
                throw new RuntimeException("Invalid map field number: " + number);
            }
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
                .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_Deploy_DeployMetadata_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                        .DeployMetadata.class,
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                        .DeployMetadata.Builder.class);
          }

          // Construct using
          // com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            internalGetMutableLabels().clear();
            sampleRequest_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
                .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_Deploy_DeployMetadata_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                  .DeployMetadata
              getDefaultInstanceForType() {
            return com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                  .DeployMetadata
              build() {
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                  .DeployMetadata
              buildPartial() {
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
                result =
                    new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                        .DeployMetadata(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.labels_ = internalGetLabels();
              result.labels_.makeImmutable();
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.sampleRequest_ = sampleRequest_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                    .DeployMetadata) {
              return mergeFrom(
                  (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                          .DeployMetadata)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
                  other) {
            if (other
                == com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                    .DeployMetadata.getDefaultInstance()) return this;
            internalGetMutableLabels().mergeFrom(other.internalGetLabels());
            bitField0_ |= 0x00000001;
            if (!other.getSampleRequest().isEmpty()) {
              sampleRequest_ = other.sampleRequest_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                          input.readMessage(
                              LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                      internalGetMutableLabels()
                          .getMutableMap()
                          .put(labels__.getKey(), labels__.getValue());
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      sampleRequest_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

          private com.google.protobuf.MapField<java.lang.String, java.lang.String>
              internalGetLabels() {
            if (labels_ == null) {
              return com.google.protobuf.MapField.emptyMapField(
                  LabelsDefaultEntryHolder.defaultEntry);
            }
            return labels_;
          }

          private com.google.protobuf.MapField<java.lang.String, java.lang.String>
              internalGetMutableLabels() {
            if (labels_ == null) {
              labels_ =
                  com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            if (!labels_.isMutable()) {
              labels_ = labels_.copy();
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return labels_;
          }

          public int getLabelsCount() {
            return internalGetLabels().getMap().size();
          }
          /**
           *
           *
           * <pre>
           * Optional. Labels for the deployment config. For managing deployment
           * config like verifying, source of deployment config, etc.
           * </pre>
           *
           * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          @java.lang.Override
          public boolean containsLabels(java.lang.String key) {
            if (key == null) {
              throw new NullPointerException("map key");
            }
            return internalGetLabels().getMap().containsKey(key);
          }
          /** Use {@link #getLabelsMap()} instead. */
          @java.lang.Override
          @java.lang.Deprecated
          public java.util.Map<java.lang.String, java.lang.String> getLabels() {
            return getLabelsMap();
          }
          /**
           *
           *
           * <pre>
           * Optional. Labels for the deployment config. For managing deployment
           * config like verifying, source of deployment config, etc.
           * </pre>
           *
           * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          @java.lang.Override
          public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
            return internalGetLabels().getMap();
          }
          /**
           *
           *
           * <pre>
           * Optional. Labels for the deployment config. For managing deployment
           * config like verifying, source of deployment config, etc.
           * </pre>
           *
           * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          @java.lang.Override
          public /* nullable */ java.lang.String getLabelsOrDefault(
              java.lang.String key,
              /* nullable */
              java.lang.String defaultValue) {
            if (key == null) {
              throw new NullPointerException("map key");
            }
            java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
            return map.containsKey(key) ? map.get(key) : defaultValue;
          }
          /**
           *
           *
           * <pre>
           * Optional. Labels for the deployment config. For managing deployment
           * config like verifying, source of deployment config, etc.
           * </pre>
           *
           * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          @java.lang.Override
          public java.lang.String getLabelsOrThrow(java.lang.String key) {
            if (key == null) {
              throw new NullPointerException("map key");
            }
            java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
            if (!map.containsKey(key)) {
              throw new java.lang.IllegalArgumentException();
            }
            return map.get(key);
          }

          public Builder clearLabels() {
            bitField0_ = (bitField0_ & ~0x00000001);
            internalGetMutableLabels().getMutableMap().clear();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. Labels for the deployment config. For managing deployment
           * config like verifying, source of deployment config, etc.
           * </pre>
           *
           * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder removeLabels(java.lang.String key) {
            if (key == null) {
              throw new NullPointerException("map key");
            }
            internalGetMutableLabels().getMutableMap().remove(key);
            return this;
          }
          /** Use alternate mutation accessors instead. */
          @java.lang.Deprecated
          public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
            bitField0_ |= 0x00000001;
            return internalGetMutableLabels().getMutableMap();
          }
          /**
           *
           *
           * <pre>
           * Optional. Labels for the deployment config. For managing deployment
           * config like verifying, source of deployment config, etc.
           * </pre>
           *
           * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder putLabels(java.lang.String key, java.lang.String value) {
            if (key == null) {
              throw new NullPointerException("map key");
            }
            if (value == null) {
              throw new NullPointerException("map value");
            }
            internalGetMutableLabels().getMutableMap().put(key, value);
            bitField0_ |= 0x00000001;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. Labels for the deployment config. For managing deployment
           * config like verifying, source of deployment config, etc.
           * </pre>
           *
           * <code>map&lt;string, string&gt; labels = 1 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
            internalGetMutableLabels().getMutableMap().putAll(values);
            bitField0_ |= 0x00000001;
            return this;
          }

          private java.lang.Object sampleRequest_ = "";
          /**
           *
           *
           * <pre>
           * Optional. Sample request for deployed endpoint.
           * </pre>
           *
           * <code>string sample_request = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The sampleRequest.
           */
          public java.lang.String getSampleRequest() {
            java.lang.Object ref = sampleRequest_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              sampleRequest_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. Sample request for deployed endpoint.
           * </pre>
           *
           * <code>string sample_request = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The bytes for sampleRequest.
           */
          public com.google.protobuf.ByteString getSampleRequestBytes() {
            java.lang.Object ref = sampleRequest_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              sampleRequest_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. Sample request for deployed endpoint.
           * </pre>
           *
           * <code>string sample_request = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The sampleRequest to set.
           * @return This builder for chaining.
           */
          public Builder setSampleRequest(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            sampleRequest_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. Sample request for deployed endpoint.
           * </pre>
           *
           * <code>string sample_request = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearSampleRequest() {
            sampleRequest_ = getDefaultInstance().getSampleRequest();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. Sample request for deployed endpoint.
           * </pre>
           *
           * <code>string sample_request = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The bytes for sampleRequest to set.
           * @return This builder for chaining.
           */
          public Builder setSampleRequestBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            sampleRequest_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata)
        private static final com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                  .DeployMetadata();
        }

        public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<DeployMetadata> PARSER =
            new com.google.protobuf.AbstractParser<DeployMetadata>() {
              @java.lang.Override
              public DeployMetadata parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<DeployMetadata> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<DeployMetadata> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      private int predictionResourcesCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object predictionResources_;

      public enum PredictionResourcesCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        DEDICATED_RESOURCES(5),
        AUTOMATIC_RESOURCES(6),
        SHARED_RESOURCES(7),
        PREDICTIONRESOURCES_NOT_SET(0);
        private final int value;

        private PredictionResourcesCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static PredictionResourcesCase valueOf(int value) {
          return forNumber(value);
        }

        public static PredictionResourcesCase forNumber(int value) {
          switch (value) {
            case 5:
              return DEDICATED_RESOURCES;
            case 6:
              return AUTOMATIC_RESOURCES;
            case 7:
              return SHARED_RESOURCES;
            case 0:
              return PREDICTIONRESOURCES_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public PredictionResourcesCase getPredictionResourcesCase() {
        return PredictionResourcesCase.forNumber(predictionResourcesCase_);
      }

      public static final int DEDICATED_RESOURCES_FIELD_NUMBER = 5;
      /**
       *
       *
       * <pre>
       * A description of resources that are dedicated to the DeployedModel,
       * and that need a higher degree of manual configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 5;</code>
       *
       * @return Whether the dedicatedResources field is set.
       */
      @java.lang.Override
      public boolean hasDedicatedResources() {
        return predictionResourcesCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * A description of resources that are dedicated to the DeployedModel,
       * and that need a higher degree of manual configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 5;</code>
       *
       * @return The dedicatedResources.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.DedicatedResources getDedicatedResources() {
        if (predictionResourcesCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.DedicatedResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * A description of resources that are dedicated to the DeployedModel,
       * and that need a higher degree of manual configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 5;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder
          getDedicatedResourcesOrBuilder() {
        if (predictionResourcesCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.DedicatedResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance();
      }

      public static final int AUTOMATIC_RESOURCES_FIELD_NUMBER = 6;
      /**
       *
       *
       * <pre>
       * A description of resources that to large degree are decided by Vertex
       * AI, and require only a modest additional configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 6;</code>
       *
       * @return Whether the automaticResources field is set.
       */
      @java.lang.Override
      public boolean hasAutomaticResources() {
        return predictionResourcesCase_ == 6;
      }
      /**
       *
       *
       * <pre>
       * A description of resources that to large degree are decided by Vertex
       * AI, and require only a modest additional configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 6;</code>
       *
       * @return The automaticResources.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AutomaticResources getAutomaticResources() {
        if (predictionResourcesCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.AutomaticResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1beta1.AutomaticResources.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * A description of resources that to large degree are decided by Vertex
       * AI, and require only a modest additional configuration.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 6;</code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.AutomaticResourcesOrBuilder
          getAutomaticResourcesOrBuilder() {
        if (predictionResourcesCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.AutomaticResources) predictionResources_;
        }
        return com.google.cloud.aiplatform.v1beta1.AutomaticResources.getDefaultInstance();
      }

      public static final int SHARED_RESOURCES_FIELD_NUMBER = 7;
      /**
       *
       *
       * <pre>
       * The resource name of the shared DeploymentResourcePool to deploy on.
       * Format:
       * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
       * </pre>
       *
       * <code>string shared_resources = 7;</code>
       *
       * @return Whether the sharedResources field is set.
       */
      public boolean hasSharedResources() {
        return predictionResourcesCase_ == 7;
      }
      /**
       *
       *
       * <pre>
       * The resource name of the shared DeploymentResourcePool to deploy on.
       * Format:
       * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
       * </pre>
       *
       * <code>string shared_resources = 7;</code>
       *
       * @return The sharedResources.
       */
      public java.lang.String getSharedResources() {
        java.lang.Object ref = "";
        if (predictionResourcesCase_ == 7) {
          ref = predictionResources_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (predictionResourcesCase_ == 7) {
            predictionResources_ = s;
          }
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of the shared DeploymentResourcePool to deploy on.
       * Format:
       * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
       * </pre>
       *
       * <code>string shared_resources = 7;</code>
       *
       * @return The bytes for sharedResources.
       */
      public com.google.protobuf.ByteString getSharedResourcesBytes() {
        java.lang.Object ref = "";
        if (predictionResourcesCase_ == 7) {
          ref = predictionResources_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (predictionResourcesCase_ == 7) {
            predictionResources_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int MODEL_DISPLAY_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object modelDisplayName_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Default model display name.
       * </pre>
       *
       * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The modelDisplayName.
       */
      @java.lang.Override
      public java.lang.String getModelDisplayName() {
        java.lang.Object ref = modelDisplayName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelDisplayName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Default model display name.
       * </pre>
       *
       * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for modelDisplayName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getModelDisplayNameBytes() {
        java.lang.Object ref = modelDisplayName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int LARGE_MODEL_REFERENCE_FIELD_NUMBER = 2;
      private com.google.cloud.aiplatform.v1beta1.LargeModelReference largeModelReference_;
      /**
       *
       *
       * <pre>
       * Optional. Large model reference. When this is set, model_artifact_spec
       * is not needed.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the largeModelReference field is set.
       */
      @java.lang.Override
      public boolean hasLargeModelReference() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Large model reference. When this is set, model_artifact_spec
       * is not needed.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The largeModelReference.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.LargeModelReference getLargeModelReference() {
        return largeModelReference_ == null
            ? com.google.cloud.aiplatform.v1beta1.LargeModelReference.getDefaultInstance()
            : largeModelReference_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Large model reference. When this is set, model_artifact_spec
       * is not needed.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.LargeModelReferenceOrBuilder
          getLargeModelReferenceOrBuilder() {
        return largeModelReference_ == null
            ? com.google.cloud.aiplatform.v1beta1.LargeModelReference.getDefaultInstance()
            : largeModelReference_;
      }

      public static final int CONTAINER_SPEC_FIELD_NUMBER = 3;
      private com.google.cloud.aiplatform.v1beta1.ModelContainerSpec containerSpec_;
      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying this Model in Vertex AI. Not present for Large Models.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the containerSpec field is set.
       */
      @java.lang.Override
      public boolean hasContainerSpec() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying this Model in Vertex AI. Not present for Large Models.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The containerSpec.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec getContainerSpec() {
        return containerSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance()
            : containerSpec_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The specification of the container that is to be used when
       * deploying this Model in Vertex AI. Not present for Large Models.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder
          getContainerSpecOrBuilder() {
        return containerSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance()
            : containerSpec_;
      }

      public static final int ARTIFACT_URI_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object artifactUri_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The path to the directory containing the Model artifact and
       * any of its supporting files.
       * </pre>
       *
       * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The artifactUri.
       */
      @java.lang.Override
      public java.lang.String getArtifactUri() {
        java.lang.Object ref = artifactUri_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          artifactUri_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The path to the directory containing the Model artifact and
       * any of its supporting files.
       * </pre>
       *
       * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for artifactUri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getArtifactUriBytes() {
        java.lang.Object ref = artifactUri_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          artifactUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DEPLOY_TASK_NAME_FIELD_NUMBER = 10;

      @SuppressWarnings("serial")
      private volatile java.lang.Object deployTaskName_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The name of the deploy task (e.g., "text to image
       * generation").
       * </pre>
       *
       * <code>optional string deploy_task_name = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the deployTaskName field is set.
       */
      @java.lang.Override
      public boolean hasDeployTaskName() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of the deploy task (e.g., "text to image
       * generation").
       * </pre>
       *
       * <code>optional string deploy_task_name = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The deployTaskName.
       */
      @java.lang.Override
      public java.lang.String getDeployTaskName() {
        java.lang.Object ref = deployTaskName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          deployTaskName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of the deploy task (e.g., "text to image
       * generation").
       * </pre>
       *
       * <code>optional string deploy_task_name = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The bytes for deployTaskName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDeployTaskNameBytes() {
        java.lang.Object ref = deployTaskName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          deployTaskName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DEPLOY_METADATA_FIELD_NUMBER = 11;
      private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
          deployMetadata_;
      /**
       *
       *
       * <pre>
       * Optional. Metadata information about this deployment config.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata deploy_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the deployMetadata field is set.
       */
      @java.lang.Override
      public boolean hasDeployMetadata() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Metadata information about this deployment config.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata deploy_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The deployMetadata.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
          getDeployMetadata() {
        return deployMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
                .getDefaultInstance()
            : deployMetadata_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Metadata information about this deployment config.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata deploy_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
              .DeployMetadataOrBuilder
          getDeployMetadataOrBuilder() {
        return deployMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
                .getDefaultInstance()
            : deployMetadata_;
      }

      public static final int TITLE_FIELD_NUMBER = 8;

      @SuppressWarnings("serial")
      private volatile java.lang.Object title_ = "";
      /**
       *
       *
       * <pre>
       * Required. The title of the regional resource reference.
       * </pre>
       *
       * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The title.
       */
      @java.lang.Override
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The title of the regional resource reference.
       * </pre>
       *
       * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for title.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int PUBLIC_ARTIFACT_URI_FIELD_NUMBER = 9;

      @SuppressWarnings("serial")
      private volatile java.lang.Object publicArtifactUri_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The signed URI for ephemeral Cloud Storage access to model
       * artifact.
       * </pre>
       *
       * <code>string public_artifact_uri = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The publicArtifactUri.
       */
      @java.lang.Override
      public java.lang.String getPublicArtifactUri() {
        java.lang.Object ref = publicArtifactUri_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          publicArtifactUri_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The signed URI for ephemeral Cloud Storage access to model
       * artifact.
       * </pre>
       *
       * <code>string public_artifact_uri = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for publicArtifactUri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getPublicArtifactUriBytes() {
        java.lang.Object ref = publicArtifactUri_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          publicArtifactUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDisplayName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, modelDisplayName_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getLargeModelReference());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(3, getContainerSpec());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactUri_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, artifactUri_);
        }
        if (predictionResourcesCase_ == 5) {
          output.writeMessage(
              5, (com.google.cloud.aiplatform.v1beta1.DedicatedResources) predictionResources_);
        }
        if (predictionResourcesCase_ == 6) {
          output.writeMessage(
              6, (com.google.cloud.aiplatform.v1beta1.AutomaticResources) predictionResources_);
        }
        if (predictionResourcesCase_ == 7) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 7, predictionResources_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 8, title_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicArtifactUri_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 9, publicArtifactUri_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 10, deployTaskName_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          output.writeMessage(11, getDeployMetadata());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDisplayName_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, modelDisplayName_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLargeModelReference());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getContainerSpec());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(artifactUri_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, artifactUri_);
        }
        if (predictionResourcesCase_ == 5) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  5, (com.google.cloud.aiplatform.v1beta1.DedicatedResources) predictionResources_);
        }
        if (predictionResourcesCase_ == 6) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  6, (com.google.cloud.aiplatform.v1beta1.AutomaticResources) predictionResources_);
        }
        if (predictionResourcesCase_ == 7) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, predictionResources_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, title_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicArtifactUri_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, publicArtifactUri_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, deployTaskName_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getDeployMetadata());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy other =
            (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy) obj;

        if (!getModelDisplayName().equals(other.getModelDisplayName())) return false;
        if (hasLargeModelReference() != other.hasLargeModelReference()) return false;
        if (hasLargeModelReference()) {
          if (!getLargeModelReference().equals(other.getLargeModelReference())) return false;
        }
        if (hasContainerSpec() != other.hasContainerSpec()) return false;
        if (hasContainerSpec()) {
          if (!getContainerSpec().equals(other.getContainerSpec())) return false;
        }
        if (!getArtifactUri().equals(other.getArtifactUri())) return false;
        if (hasDeployTaskName() != other.hasDeployTaskName()) return false;
        if (hasDeployTaskName()) {
          if (!getDeployTaskName().equals(other.getDeployTaskName())) return false;
        }
        if (hasDeployMetadata() != other.hasDeployMetadata()) return false;
        if (hasDeployMetadata()) {
          if (!getDeployMetadata().equals(other.getDeployMetadata())) return false;
        }
        if (!getTitle().equals(other.getTitle())) return false;
        if (!getPublicArtifactUri().equals(other.getPublicArtifactUri())) return false;
        if (!getPredictionResourcesCase().equals(other.getPredictionResourcesCase())) return false;
        switch (predictionResourcesCase_) {
          case 5:
            if (!getDedicatedResources().equals(other.getDedicatedResources())) return false;
            break;
          case 6:
            if (!getAutomaticResources().equals(other.getAutomaticResources())) return false;
            break;
          case 7:
            if (!getSharedResources().equals(other.getSharedResources())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MODEL_DISPLAY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getModelDisplayName().hashCode();
        if (hasLargeModelReference()) {
          hash = (37 * hash) + LARGE_MODEL_REFERENCE_FIELD_NUMBER;
          hash = (53 * hash) + getLargeModelReference().hashCode();
        }
        if (hasContainerSpec()) {
          hash = (37 * hash) + CONTAINER_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getContainerSpec().hashCode();
        }
        hash = (37 * hash) + ARTIFACT_URI_FIELD_NUMBER;
        hash = (53 * hash) + getArtifactUri().hashCode();
        if (hasDeployTaskName()) {
          hash = (37 * hash) + DEPLOY_TASK_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getDeployTaskName().hashCode();
        }
        if (hasDeployMetadata()) {
          hash = (37 * hash) + DEPLOY_METADATA_FIELD_NUMBER;
          hash = (53 * hash) + getDeployMetadata().hashCode();
        }
        hash = (37 * hash) + TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getTitle().hashCode();
        hash = (37 * hash) + PUBLIC_ARTIFACT_URI_FIELD_NUMBER;
        hash = (53 * hash) + getPublicArtifactUri().hashCode();
        switch (predictionResourcesCase_) {
          case 5:
            hash = (37 * hash) + DEDICATED_RESOURCES_FIELD_NUMBER;
            hash = (53 * hash) + getDedicatedResources().hashCode();
            break;
          case 6:
            hash = (37 * hash) + AUTOMATIC_RESOURCES_FIELD_NUMBER;
            hash = (53 * hash) + getAutomaticResources().hashCode();
            break;
          case 7:
            hash = (37 * hash) + SHARED_RESOURCES_FIELD_NUMBER;
            hash = (53 * hash) + getSharedResources().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Model metadata that is needed for UploadModel or
       * DeployModel/CreateEndpoint requests.
       * </pre>
       *
       * Protobuf type {@code google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy)
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_Deploy_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_Deploy_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.class,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLargeModelReferenceFieldBuilder();
            getContainerSpecFieldBuilder();
            getDeployMetadataFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (dedicatedResourcesBuilder_ != null) {
            dedicatedResourcesBuilder_.clear();
          }
          if (automaticResourcesBuilder_ != null) {
            automaticResourcesBuilder_.clear();
          }
          modelDisplayName_ = "";
          largeModelReference_ = null;
          if (largeModelReferenceBuilder_ != null) {
            largeModelReferenceBuilder_.dispose();
            largeModelReferenceBuilder_ = null;
          }
          containerSpec_ = null;
          if (containerSpecBuilder_ != null) {
            containerSpecBuilder_.dispose();
            containerSpecBuilder_ = null;
          }
          artifactUri_ = "";
          deployTaskName_ = "";
          deployMetadata_ = null;
          if (deployMetadataBuilder_ != null) {
            deployMetadataBuilder_.dispose();
            deployMetadataBuilder_ = null;
          }
          title_ = "";
          publicArtifactUri_ = "";
          predictionResourcesCase_ = 0;
          predictionResources_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_Deploy_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy build() {
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy result =
              new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.modelDisplayName_ = modelDisplayName_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.largeModelReference_ =
                largeModelReferenceBuilder_ == null
                    ? largeModelReference_
                    : largeModelReferenceBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.containerSpec_ =
                containerSpecBuilder_ == null ? containerSpec_ : containerSpecBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000040) != 0)) {
            result.artifactUri_ = artifactUri_;
          }
          if (((from_bitField0_ & 0x00000080) != 0)) {
            result.deployTaskName_ = deployTaskName_;
            to_bitField0_ |= 0x00000004;
          }
          if (((from_bitField0_ & 0x00000100) != 0)) {
            result.deployMetadata_ =
                deployMetadataBuilder_ == null ? deployMetadata_ : deployMetadataBuilder_.build();
            to_bitField0_ |= 0x00000008;
          }
          if (((from_bitField0_ & 0x00000200) != 0)) {
            result.title_ = title_;
          }
          if (((from_bitField0_ & 0x00000400) != 0)) {
            result.publicArtifactUri_ = publicArtifactUri_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        private void buildPartialOneofs(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy result) {
          result.predictionResourcesCase_ = predictionResourcesCase_;
          result.predictionResources_ = this.predictionResources_;
          if (predictionResourcesCase_ == 5 && dedicatedResourcesBuilder_ != null) {
            result.predictionResources_ = dedicatedResourcesBuilder_.build();
          }
          if (predictionResourcesCase_ == 6 && automaticResourcesBuilder_ != null) {
            result.predictionResources_ = automaticResourcesBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                  .getDefaultInstance()) return this;
          if (!other.getModelDisplayName().isEmpty()) {
            modelDisplayName_ = other.modelDisplayName_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          if (other.hasLargeModelReference()) {
            mergeLargeModelReference(other.getLargeModelReference());
          }
          if (other.hasContainerSpec()) {
            mergeContainerSpec(other.getContainerSpec());
          }
          if (!other.getArtifactUri().isEmpty()) {
            artifactUri_ = other.artifactUri_;
            bitField0_ |= 0x00000040;
            onChanged();
          }
          if (other.hasDeployTaskName()) {
            deployTaskName_ = other.deployTaskName_;
            bitField0_ |= 0x00000080;
            onChanged();
          }
          if (other.hasDeployMetadata()) {
            mergeDeployMetadata(other.getDeployMetadata());
          }
          if (!other.getTitle().isEmpty()) {
            title_ = other.title_;
            bitField0_ |= 0x00000200;
            onChanged();
          }
          if (!other.getPublicArtifactUri().isEmpty()) {
            publicArtifactUri_ = other.publicArtifactUri_;
            bitField0_ |= 0x00000400;
            onChanged();
          }
          switch (other.getPredictionResourcesCase()) {
            case DEDICATED_RESOURCES:
              {
                mergeDedicatedResources(other.getDedicatedResources());
                break;
              }
            case AUTOMATIC_RESOURCES:
              {
                mergeAutomaticResources(other.getAutomaticResources());
                break;
              }
            case SHARED_RESOURCES:
              {
                predictionResourcesCase_ = 7;
                predictionResources_ = other.predictionResources_;
                onChanged();
                break;
              }
            case PREDICTIONRESOURCES_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    modelDisplayName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getLargeModelReferenceFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(
                        getContainerSpecFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000020;
                    break;
                  } // case 26
                case 34:
                  {
                    artifactUri_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000040;
                    break;
                  } // case 34
                case 42:
                  {
                    input.readMessage(
                        getDedicatedResourcesFieldBuilder().getBuilder(), extensionRegistry);
                    predictionResourcesCase_ = 5;
                    break;
                  } // case 42
                case 50:
                  {
                    input.readMessage(
                        getAutomaticResourcesFieldBuilder().getBuilder(), extensionRegistry);
                    predictionResourcesCase_ = 6;
                    break;
                  } // case 50
                case 58:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    predictionResourcesCase_ = 7;
                    predictionResources_ = s;
                    break;
                  } // case 58
                case 66:
                  {
                    title_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000200;
                    break;
                  } // case 66
                case 74:
                  {
                    publicArtifactUri_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000400;
                    break;
                  } // case 74
                case 82:
                  {
                    deployTaskName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000080;
                    break;
                  } // case 82
                case 90:
                  {
                    input.readMessage(
                        getDeployMetadataFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000100;
                    break;
                  } // case 90
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int predictionResourcesCase_ = 0;
        private java.lang.Object predictionResources_;

        public PredictionResourcesCase getPredictionResourcesCase() {
          return PredictionResourcesCase.forNumber(predictionResourcesCase_);
        }

        public Builder clearPredictionResources() {
          predictionResourcesCase_ = 0;
          predictionResources_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DedicatedResources,
                com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder,
                com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder>
            dedicatedResourcesBuilder_;
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 5;</code>
         *
         * @return Whether the dedicatedResources field is set.
         */
        @java.lang.Override
        public boolean hasDedicatedResources() {
          return predictionResourcesCase_ == 5;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 5;</code>
         *
         * @return The dedicatedResources.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.DedicatedResources getDedicatedResources() {
          if (dedicatedResourcesBuilder_ == null) {
            if (predictionResourcesCase_ == 5) {
              return (com.google.cloud.aiplatform.v1beta1.DedicatedResources) predictionResources_;
            }
            return com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance();
          } else {
            if (predictionResourcesCase_ == 5) {
              return dedicatedResourcesBuilder_.getMessage();
            }
            return com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 5;</code>
         */
        public Builder setDedicatedResources(
            com.google.cloud.aiplatform.v1beta1.DedicatedResources value) {
          if (dedicatedResourcesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            predictionResources_ = value;
            onChanged();
          } else {
            dedicatedResourcesBuilder_.setMessage(value);
          }
          predictionResourcesCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 5;</code>
         */
        public Builder setDedicatedResources(
            com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder builderForValue) {
          if (dedicatedResourcesBuilder_ == null) {
            predictionResources_ = builderForValue.build();
            onChanged();
          } else {
            dedicatedResourcesBuilder_.setMessage(builderForValue.build());
          }
          predictionResourcesCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 5;</code>
         */
        public Builder mergeDedicatedResources(
            com.google.cloud.aiplatform.v1beta1.DedicatedResources value) {
          if (dedicatedResourcesBuilder_ == null) {
            if (predictionResourcesCase_ == 5
                && predictionResources_
                    != com.google.cloud.aiplatform.v1beta1.DedicatedResources
                        .getDefaultInstance()) {
              predictionResources_ =
                  com.google.cloud.aiplatform.v1beta1.DedicatedResources.newBuilder(
                          (com.google.cloud.aiplatform.v1beta1.DedicatedResources)
                              predictionResources_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              predictionResources_ = value;
            }
            onChanged();
          } else {
            if (predictionResourcesCase_ == 5) {
              dedicatedResourcesBuilder_.mergeFrom(value);
            } else {
              dedicatedResourcesBuilder_.setMessage(value);
            }
          }
          predictionResourcesCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 5;</code>
         */
        public Builder clearDedicatedResources() {
          if (dedicatedResourcesBuilder_ == null) {
            if (predictionResourcesCase_ == 5) {
              predictionResourcesCase_ = 0;
              predictionResources_ = null;
              onChanged();
            }
          } else {
            if (predictionResourcesCase_ == 5) {
              predictionResourcesCase_ = 0;
              predictionResources_ = null;
            }
            dedicatedResourcesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 5;</code>
         */
        public com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder
            getDedicatedResourcesBuilder() {
          return getDedicatedResourcesFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 5;</code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder
            getDedicatedResourcesOrBuilder() {
          if ((predictionResourcesCase_ == 5) && (dedicatedResourcesBuilder_ != null)) {
            return dedicatedResourcesBuilder_.getMessageOrBuilder();
          } else {
            if (predictionResourcesCase_ == 5) {
              return (com.google.cloud.aiplatform.v1beta1.DedicatedResources) predictionResources_;
            }
            return com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A description of resources that are dedicated to the DeployedModel,
         * and that need a higher degree of manual configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.DedicatedResources dedicated_resources = 5;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.DedicatedResources,
                com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder,
                com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder>
            getDedicatedResourcesFieldBuilder() {
          if (dedicatedResourcesBuilder_ == null) {
            if (!(predictionResourcesCase_ == 5)) {
              predictionResources_ =
                  com.google.cloud.aiplatform.v1beta1.DedicatedResources.getDefaultInstance();
            }
            dedicatedResourcesBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.DedicatedResources,
                    com.google.cloud.aiplatform.v1beta1.DedicatedResources.Builder,
                    com.google.cloud.aiplatform.v1beta1.DedicatedResourcesOrBuilder>(
                    (com.google.cloud.aiplatform.v1beta1.DedicatedResources) predictionResources_,
                    getParentForChildren(),
                    isClean());
            predictionResources_ = null;
          }
          predictionResourcesCase_ = 5;
          onChanged();
          return dedicatedResourcesBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AutomaticResources,
                com.google.cloud.aiplatform.v1beta1.AutomaticResources.Builder,
                com.google.cloud.aiplatform.v1beta1.AutomaticResourcesOrBuilder>
            automaticResourcesBuilder_;
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 6;</code>
         *
         * @return Whether the automaticResources field is set.
         */
        @java.lang.Override
        public boolean hasAutomaticResources() {
          return predictionResourcesCase_ == 6;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 6;</code>
         *
         * @return The automaticResources.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.AutomaticResources getAutomaticResources() {
          if (automaticResourcesBuilder_ == null) {
            if (predictionResourcesCase_ == 6) {
              return (com.google.cloud.aiplatform.v1beta1.AutomaticResources) predictionResources_;
            }
            return com.google.cloud.aiplatform.v1beta1.AutomaticResources.getDefaultInstance();
          } else {
            if (predictionResourcesCase_ == 6) {
              return automaticResourcesBuilder_.getMessage();
            }
            return com.google.cloud.aiplatform.v1beta1.AutomaticResources.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 6;</code>
         */
        public Builder setAutomaticResources(
            com.google.cloud.aiplatform.v1beta1.AutomaticResources value) {
          if (automaticResourcesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            predictionResources_ = value;
            onChanged();
          } else {
            automaticResourcesBuilder_.setMessage(value);
          }
          predictionResourcesCase_ = 6;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 6;</code>
         */
        public Builder setAutomaticResources(
            com.google.cloud.aiplatform.v1beta1.AutomaticResources.Builder builderForValue) {
          if (automaticResourcesBuilder_ == null) {
            predictionResources_ = builderForValue.build();
            onChanged();
          } else {
            automaticResourcesBuilder_.setMessage(builderForValue.build());
          }
          predictionResourcesCase_ = 6;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 6;</code>
         */
        public Builder mergeAutomaticResources(
            com.google.cloud.aiplatform.v1beta1.AutomaticResources value) {
          if (automaticResourcesBuilder_ == null) {
            if (predictionResourcesCase_ == 6
                && predictionResources_
                    != com.google.cloud.aiplatform.v1beta1.AutomaticResources
                        .getDefaultInstance()) {
              predictionResources_ =
                  com.google.cloud.aiplatform.v1beta1.AutomaticResources.newBuilder(
                          (com.google.cloud.aiplatform.v1beta1.AutomaticResources)
                              predictionResources_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              predictionResources_ = value;
            }
            onChanged();
          } else {
            if (predictionResourcesCase_ == 6) {
              automaticResourcesBuilder_.mergeFrom(value);
            } else {
              automaticResourcesBuilder_.setMessage(value);
            }
          }
          predictionResourcesCase_ = 6;
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 6;</code>
         */
        public Builder clearAutomaticResources() {
          if (automaticResourcesBuilder_ == null) {
            if (predictionResourcesCase_ == 6) {
              predictionResourcesCase_ = 0;
              predictionResources_ = null;
              onChanged();
            }
          } else {
            if (predictionResourcesCase_ == 6) {
              predictionResourcesCase_ = 0;
              predictionResources_ = null;
            }
            automaticResourcesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 6;</code>
         */
        public com.google.cloud.aiplatform.v1beta1.AutomaticResources.Builder
            getAutomaticResourcesBuilder() {
          return getAutomaticResourcesFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 6;</code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.AutomaticResourcesOrBuilder
            getAutomaticResourcesOrBuilder() {
          if ((predictionResourcesCase_ == 6) && (automaticResourcesBuilder_ != null)) {
            return automaticResourcesBuilder_.getMessageOrBuilder();
          } else {
            if (predictionResourcesCase_ == 6) {
              return (com.google.cloud.aiplatform.v1beta1.AutomaticResources) predictionResources_;
            }
            return com.google.cloud.aiplatform.v1beta1.AutomaticResources.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * A description of resources that to large degree are decided by Vertex
         * AI, and require only a modest additional configuration.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1beta1.AutomaticResources automatic_resources = 6;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AutomaticResources,
                com.google.cloud.aiplatform.v1beta1.AutomaticResources.Builder,
                com.google.cloud.aiplatform.v1beta1.AutomaticResourcesOrBuilder>
            getAutomaticResourcesFieldBuilder() {
          if (automaticResourcesBuilder_ == null) {
            if (!(predictionResourcesCase_ == 6)) {
              predictionResources_ =
                  com.google.cloud.aiplatform.v1beta1.AutomaticResources.getDefaultInstance();
            }
            automaticResourcesBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.AutomaticResources,
                    com.google.cloud.aiplatform.v1beta1.AutomaticResources.Builder,
                    com.google.cloud.aiplatform.v1beta1.AutomaticResourcesOrBuilder>(
                    (com.google.cloud.aiplatform.v1beta1.AutomaticResources) predictionResources_,
                    getParentForChildren(),
                    isClean());
            predictionResources_ = null;
          }
          predictionResourcesCase_ = 6;
          onChanged();
          return automaticResourcesBuilder_;
        }

        /**
         *
         *
         * <pre>
         * The resource name of the shared DeploymentResourcePool to deploy on.
         * Format:
         * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
         * </pre>
         *
         * <code>string shared_resources = 7;</code>
         *
         * @return Whether the sharedResources field is set.
         */
        @java.lang.Override
        public boolean hasSharedResources() {
          return predictionResourcesCase_ == 7;
        }
        /**
         *
         *
         * <pre>
         * The resource name of the shared DeploymentResourcePool to deploy on.
         * Format:
         * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
         * </pre>
         *
         * <code>string shared_resources = 7;</code>
         *
         * @return The sharedResources.
         */
        @java.lang.Override
        public java.lang.String getSharedResources() {
          java.lang.Object ref = "";
          if (predictionResourcesCase_ == 7) {
            ref = predictionResources_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (predictionResourcesCase_ == 7) {
              predictionResources_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The resource name of the shared DeploymentResourcePool to deploy on.
         * Format:
         * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
         * </pre>
         *
         * <code>string shared_resources = 7;</code>
         *
         * @return The bytes for sharedResources.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getSharedResourcesBytes() {
          java.lang.Object ref = "";
          if (predictionResourcesCase_ == 7) {
            ref = predictionResources_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (predictionResourcesCase_ == 7) {
              predictionResources_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The resource name of the shared DeploymentResourcePool to deploy on.
         * Format:
         * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
         * </pre>
         *
         * <code>string shared_resources = 7;</code>
         *
         * @param value The sharedResources to set.
         * @return This builder for chaining.
         */
        public Builder setSharedResources(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          predictionResourcesCase_ = 7;
          predictionResources_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The resource name of the shared DeploymentResourcePool to deploy on.
         * Format:
         * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
         * </pre>
         *
         * <code>string shared_resources = 7;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSharedResources() {
          if (predictionResourcesCase_ == 7) {
            predictionResourcesCase_ = 0;
            predictionResources_ = null;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The resource name of the shared DeploymentResourcePool to deploy on.
         * Format:
         * `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
         * </pre>
         *
         * <code>string shared_resources = 7;</code>
         *
         * @param value The bytes for sharedResources to set.
         * @return This builder for chaining.
         */
        public Builder setSharedResourcesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          predictionResourcesCase_ = 7;
          predictionResources_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object modelDisplayName_ = "";
        /**
         *
         *
         * <pre>
         * Optional. Default model display name.
         * </pre>
         *
         * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The modelDisplayName.
         */
        public java.lang.String getModelDisplayName() {
          java.lang.Object ref = modelDisplayName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            modelDisplayName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Default model display name.
         * </pre>
         *
         * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for modelDisplayName.
         */
        public com.google.protobuf.ByteString getModelDisplayNameBytes() {
          java.lang.Object ref = modelDisplayName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            modelDisplayName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Default model display name.
         * </pre>
         *
         * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The modelDisplayName to set.
         * @return This builder for chaining.
         */
        public Builder setModelDisplayName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          modelDisplayName_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Default model display name.
         * </pre>
         *
         * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearModelDisplayName() {
          modelDisplayName_ = getDefaultInstance().getModelDisplayName();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Default model display name.
         * </pre>
         *
         * <code>string model_display_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for modelDisplayName to set.
         * @return This builder for chaining.
         */
        public Builder setModelDisplayNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          modelDisplayName_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        private com.google.cloud.aiplatform.v1beta1.LargeModelReference largeModelReference_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.LargeModelReference,
                com.google.cloud.aiplatform.v1beta1.LargeModelReference.Builder,
                com.google.cloud.aiplatform.v1beta1.LargeModelReferenceOrBuilder>
            largeModelReferenceBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the largeModelReference field is set.
         */
        public boolean hasLargeModelReference() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The largeModelReference.
         */
        public com.google.cloud.aiplatform.v1beta1.LargeModelReference getLargeModelReference() {
          if (largeModelReferenceBuilder_ == null) {
            return largeModelReference_ == null
                ? com.google.cloud.aiplatform.v1beta1.LargeModelReference.getDefaultInstance()
                : largeModelReference_;
          } else {
            return largeModelReferenceBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setLargeModelReference(
            com.google.cloud.aiplatform.v1beta1.LargeModelReference value) {
          if (largeModelReferenceBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            largeModelReference_ = value;
          } else {
            largeModelReferenceBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setLargeModelReference(
            com.google.cloud.aiplatform.v1beta1.LargeModelReference.Builder builderForValue) {
          if (largeModelReferenceBuilder_ == null) {
            largeModelReference_ = builderForValue.build();
          } else {
            largeModelReferenceBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeLargeModelReference(
            com.google.cloud.aiplatform.v1beta1.LargeModelReference value) {
          if (largeModelReferenceBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0)
                && largeModelReference_ != null
                && largeModelReference_
                    != com.google.cloud.aiplatform.v1beta1.LargeModelReference
                        .getDefaultInstance()) {
              getLargeModelReferenceBuilder().mergeFrom(value);
            } else {
              largeModelReference_ = value;
            }
          } else {
            largeModelReferenceBuilder_.mergeFrom(value);
          }
          if (largeModelReference_ != null) {
            bitField0_ |= 0x00000010;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearLargeModelReference() {
          bitField0_ = (bitField0_ & ~0x00000010);
          largeModelReference_ = null;
          if (largeModelReferenceBuilder_ != null) {
            largeModelReferenceBuilder_.dispose();
            largeModelReferenceBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.LargeModelReference.Builder
            getLargeModelReferenceBuilder() {
          bitField0_ |= 0x00000010;
          onChanged();
          return getLargeModelReferenceFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.LargeModelReferenceOrBuilder
            getLargeModelReferenceOrBuilder() {
          if (largeModelReferenceBuilder_ != null) {
            return largeModelReferenceBuilder_.getMessageOrBuilder();
          } else {
            return largeModelReference_ == null
                ? com.google.cloud.aiplatform.v1beta1.LargeModelReference.getDefaultInstance()
                : largeModelReference_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Large model reference. When this is set, model_artifact_spec
         * is not needed.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.LargeModelReference large_model_reference = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.LargeModelReference,
                com.google.cloud.aiplatform.v1beta1.LargeModelReference.Builder,
                com.google.cloud.aiplatform.v1beta1.LargeModelReferenceOrBuilder>
            getLargeModelReferenceFieldBuilder() {
          if (largeModelReferenceBuilder_ == null) {
            largeModelReferenceBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.LargeModelReference,
                    com.google.cloud.aiplatform.v1beta1.LargeModelReference.Builder,
                    com.google.cloud.aiplatform.v1beta1.LargeModelReferenceOrBuilder>(
                    getLargeModelReference(), getParentForChildren(), isClean());
            largeModelReference_ = null;
          }
          return largeModelReferenceBuilder_;
        }

        private com.google.cloud.aiplatform.v1beta1.ModelContainerSpec containerSpec_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelContainerSpec,
                com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder>
            containerSpecBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the containerSpec field is set.
         */
        public boolean hasContainerSpec() {
          return ((bitField0_ & 0x00000020) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The containerSpec.
         */
        public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec getContainerSpec() {
          if (containerSpecBuilder_ == null) {
            return containerSpec_ == null
                ? com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance()
                : containerSpec_;
          } else {
            return containerSpecBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setContainerSpec(
            com.google.cloud.aiplatform.v1beta1.ModelContainerSpec value) {
          if (containerSpecBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            containerSpec_ = value;
          } else {
            containerSpecBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setContainerSpec(
            com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder builderForValue) {
          if (containerSpecBuilder_ == null) {
            containerSpec_ = builderForValue.build();
          } else {
            containerSpecBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeContainerSpec(
            com.google.cloud.aiplatform.v1beta1.ModelContainerSpec value) {
          if (containerSpecBuilder_ == null) {
            if (((bitField0_ & 0x00000020) != 0)
                && containerSpec_ != null
                && containerSpec_
                    != com.google.cloud.aiplatform.v1beta1.ModelContainerSpec
                        .getDefaultInstance()) {
              getContainerSpecBuilder().mergeFrom(value);
            } else {
              containerSpec_ = value;
            }
          } else {
            containerSpecBuilder_.mergeFrom(value);
          }
          if (containerSpec_ != null) {
            bitField0_ |= 0x00000020;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearContainerSpec() {
          bitField0_ = (bitField0_ & ~0x00000020);
          containerSpec_ = null;
          if (containerSpecBuilder_ != null) {
            containerSpecBuilder_.dispose();
            containerSpecBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder
            getContainerSpecBuilder() {
          bitField0_ |= 0x00000020;
          onChanged();
          return getContainerSpecFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder
            getContainerSpecOrBuilder() {
          if (containerSpecBuilder_ != null) {
            return containerSpecBuilder_.getMessageOrBuilder();
          } else {
            return containerSpec_ == null
                ? com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.getDefaultInstance()
                : containerSpec_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The specification of the container that is to be used when
         * deploying this Model in Vertex AI. Not present for Large Models.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1beta1.ModelContainerSpec container_spec = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelContainerSpec,
                com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder>
            getContainerSpecFieldBuilder() {
          if (containerSpecBuilder_ == null) {
            containerSpecBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.ModelContainerSpec,
                    com.google.cloud.aiplatform.v1beta1.ModelContainerSpec.Builder,
                    com.google.cloud.aiplatform.v1beta1.ModelContainerSpecOrBuilder>(
                    getContainerSpec(), getParentForChildren(), isClean());
            containerSpec_ = null;
          }
          return containerSpecBuilder_;
        }

        private java.lang.Object artifactUri_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The path to the directory containing the Model artifact and
         * any of its supporting files.
         * </pre>
         *
         * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The artifactUri.
         */
        public java.lang.String getArtifactUri() {
          java.lang.Object ref = artifactUri_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            artifactUri_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The path to the directory containing the Model artifact and
         * any of its supporting files.
         * </pre>
         *
         * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for artifactUri.
         */
        public com.google.protobuf.ByteString getArtifactUriBytes() {
          java.lang.Object ref = artifactUri_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            artifactUri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The path to the directory containing the Model artifact and
         * any of its supporting files.
         * </pre>
         *
         * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The artifactUri to set.
         * @return This builder for chaining.
         */
        public Builder setArtifactUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          artifactUri_ = value;
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The path to the directory containing the Model artifact and
         * any of its supporting files.
         * </pre>
         *
         * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearArtifactUri() {
          artifactUri_ = getDefaultInstance().getArtifactUri();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The path to the directory containing the Model artifact and
         * any of its supporting files.
         * </pre>
         *
         * <code>string artifact_uri = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for artifactUri to set.
         * @return This builder for chaining.
         */
        public Builder setArtifactUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          artifactUri_ = value;
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }

        private java.lang.Object deployTaskName_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The name of the deploy task (e.g., "text to image
         * generation").
         * </pre>
         *
         * <code>optional string deploy_task_name = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the deployTaskName field is set.
         */
        public boolean hasDeployTaskName() {
          return ((bitField0_ & 0x00000080) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. The name of the deploy task (e.g., "text to image
         * generation").
         * </pre>
         *
         * <code>optional string deploy_task_name = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The deployTaskName.
         */
        public java.lang.String getDeployTaskName() {
          java.lang.Object ref = deployTaskName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            deployTaskName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The name of the deploy task (e.g., "text to image
         * generation").
         * </pre>
         *
         * <code>optional string deploy_task_name = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The bytes for deployTaskName.
         */
        public com.google.protobuf.ByteString getDeployTaskNameBytes() {
          java.lang.Object ref = deployTaskName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            deployTaskName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The name of the deploy task (e.g., "text to image
         * generation").
         * </pre>
         *
         * <code>optional string deploy_task_name = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The deployTaskName to set.
         * @return This builder for chaining.
         */
        public Builder setDeployTaskName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          deployTaskName_ = value;
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The name of the deploy task (e.g., "text to image
         * generation").
         * </pre>
         *
         * <code>optional string deploy_task_name = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDeployTaskName() {
          deployTaskName_ = getDefaultInstance().getDeployTaskName();
          bitField0_ = (bitField0_ & ~0x00000080);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The name of the deploy task (e.g., "text to image
         * generation").
         * </pre>
         *
         * <code>optional string deploy_task_name = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The bytes for deployTaskName to set.
         * @return This builder for chaining.
         */
        public Builder setDeployTaskNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          deployTaskName_ = value;
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }

        private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadata
            deployMetadata_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                    .DeployMetadata,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                    .DeployMetadata.Builder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                    .DeployMetadataOrBuilder>
            deployMetadataBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. Metadata information about this deployment config.
         * </pre>
         *
         * <code>
         * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata deploy_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the deployMetadata field is set.
         */
        public boolean hasDeployMetadata() {
          return ((bitField0_ & 0x00000100) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. Metadata information about this deployment config.
         * </pre>
         *
         * <code>
         * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata deploy_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The deployMetadata.
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
            getDeployMetadata() {
          if (deployMetadataBuilder_ == null) {
            return deployMetadata_ == null
                ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                    .DeployMetadata.getDefaultInstance()
                : deployMetadata_;
          } else {
            return deployMetadataBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Metadata information about this deployment config.
         * </pre>
         *
         * <code>
         * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata deploy_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setDeployMetadata(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
                value) {
          if (deployMetadataBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            deployMetadata_ = value;
          } else {
            deployMetadataBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000100;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Metadata information about this deployment config.
         * </pre>
         *
         * <code>
         * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata deploy_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setDeployMetadata(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
                    .Builder
                builderForValue) {
          if (deployMetadataBuilder_ == null) {
            deployMetadata_ = builderForValue.build();
          } else {
            deployMetadataBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000100;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Metadata information about this deployment config.
         * </pre>
         *
         * <code>
         * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata deploy_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeDeployMetadata(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
                value) {
          if (deployMetadataBuilder_ == null) {
            if (((bitField0_ & 0x00000100) != 0)
                && deployMetadata_ != null
                && deployMetadata_
                    != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                        .DeployMetadata.getDefaultInstance()) {
              getDeployMetadataBuilder().mergeFrom(value);
            } else {
              deployMetadata_ = value;
            }
          } else {
            deployMetadataBuilder_.mergeFrom(value);
          }
          if (deployMetadata_ != null) {
            bitField0_ |= 0x00000100;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Metadata information about this deployment config.
         * </pre>
         *
         * <code>
         * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata deploy_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearDeployMetadata() {
          bitField0_ = (bitField0_ & ~0x00000100);
          deployMetadata_ = null;
          if (deployMetadataBuilder_ != null) {
            deployMetadataBuilder_.dispose();
            deployMetadataBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Metadata information about this deployment config.
         * </pre>
         *
         * <code>
         * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata deploy_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata
                .Builder
            getDeployMetadataBuilder() {
          bitField0_ |= 0x00000100;
          onChanged();
          return getDeployMetadataFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. Metadata information about this deployment config.
         * </pre>
         *
         * <code>
         * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata deploy_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                .DeployMetadataOrBuilder
            getDeployMetadataOrBuilder() {
          if (deployMetadataBuilder_ != null) {
            return deployMetadataBuilder_.getMessageOrBuilder();
          } else {
            return deployMetadata_ == null
                ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                    .DeployMetadata.getDefaultInstance()
                : deployMetadata_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Metadata information about this deployment config.
         * </pre>
         *
         * <code>
         * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.DeployMetadata deploy_metadata = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                    .DeployMetadata,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                    .DeployMetadata.Builder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                    .DeployMetadataOrBuilder>
            getDeployMetadataFieldBuilder() {
          if (deployMetadataBuilder_ == null) {
            deployMetadataBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                        .DeployMetadata,
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                        .DeployMetadata.Builder,
                    com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                        .DeployMetadataOrBuilder>(
                    getDeployMetadata(), getParentForChildren(), isClean());
            deployMetadata_ = null;
          }
          return deployMetadataBuilder_;
        }

        private java.lang.Object title_ = "";
        /**
         *
         *
         * <pre>
         * Required. The title of the regional resource reference.
         * </pre>
         *
         * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The title.
         */
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the regional resource reference.
         * </pre>
         *
         * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for title.
         */
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the regional resource reference.
         * </pre>
         *
         * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The title to set.
         * @return This builder for chaining.
         */
        public Builder setTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          title_ = value;
          bitField0_ |= 0x00000200;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the regional resource reference.
         * </pre>
         *
         * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTitle() {
          title_ = getDefaultInstance().getTitle();
          bitField0_ = (bitField0_ & ~0x00000200);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The title of the regional resource reference.
         * </pre>
         *
         * <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for title to set.
         * @return This builder for chaining.
         */
        public Builder setTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          title_ = value;
          bitField0_ |= 0x00000200;
          onChanged();
          return this;
        }

        private java.lang.Object publicArtifactUri_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The signed URI for ephemeral Cloud Storage access to model
         * artifact.
         * </pre>
         *
         * <code>string public_artifact_uri = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The publicArtifactUri.
         */
        public java.lang.String getPublicArtifactUri() {
          java.lang.Object ref = publicArtifactUri_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            publicArtifactUri_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The signed URI for ephemeral Cloud Storage access to model
         * artifact.
         * </pre>
         *
         * <code>string public_artifact_uri = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for publicArtifactUri.
         */
        public com.google.protobuf.ByteString getPublicArtifactUriBytes() {
          java.lang.Object ref = publicArtifactUri_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            publicArtifactUri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The signed URI for ephemeral Cloud Storage access to model
         * artifact.
         * </pre>
         *
         * <code>string public_artifact_uri = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The publicArtifactUri to set.
         * @return This builder for chaining.
         */
        public Builder setPublicArtifactUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          publicArtifactUri_ = value;
          bitField0_ |= 0x00000400;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The signed URI for ephemeral Cloud Storage access to model
         * artifact.
         * </pre>
         *
         * <code>string public_artifact_uri = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPublicArtifactUri() {
          publicArtifactUri_ = getDefaultInstance().getPublicArtifactUri();
          bitField0_ = (bitField0_ & ~0x00000400);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The signed URI for ephemeral Cloud Storage access to model
         * artifact.
         * </pre>
         *
         * <code>string public_artifact_uri = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for publicArtifactUri to set.
         * @return This builder for chaining.
         */
        public Builder setPublicArtifactUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          publicArtifactUri_ = value;
          bitField0_ |= 0x00000400;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy)
      private static final com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy();
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Deploy> PARSER =
          new com.google.protobuf.AbstractParser<Deploy>() {
            @java.lang.Override
            public Deploy parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Deploy> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Deploy> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface DeployGkeOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. GKE deployment configuration in yaml format.
       * </pre>
       *
       * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the gkeYamlConfigs.
       */
      java.util.List<java.lang.String> getGkeYamlConfigsList();
      /**
       *
       *
       * <pre>
       * Optional. GKE deployment configuration in yaml format.
       * </pre>
       *
       * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of gkeYamlConfigs.
       */
      int getGkeYamlConfigsCount();
      /**
       *
       *
       * <pre>
       * Optional. GKE deployment configuration in yaml format.
       * </pre>
       *
       * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The gkeYamlConfigs at the given index.
       */
      java.lang.String getGkeYamlConfigs(int index);
      /**
       *
       *
       * <pre>
       * Optional. GKE deployment configuration in yaml format.
       * </pre>
       *
       * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the gkeYamlConfigs at the given index.
       */
      com.google.protobuf.ByteString getGkeYamlConfigsBytes(int index);
    }
    /**
     *
     *
     * <pre>
     * Configurations for PublisherModel GKE deployment
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke}
     */
    public static final class DeployGke extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke)
        DeployGkeOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DeployGke.newBuilder() to construct.
      private DeployGke(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DeployGke() {
        gkeYamlConfigs_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DeployGke();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_DeployGke_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_DeployGke_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke.class,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke.Builder
                    .class);
      }

      public static final int GKE_YAML_CONFIGS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList gkeYamlConfigs_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Optional. GKE deployment configuration in yaml format.
       * </pre>
       *
       * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the gkeYamlConfigs.
       */
      public com.google.protobuf.ProtocolStringList getGkeYamlConfigsList() {
        return gkeYamlConfigs_;
      }
      /**
       *
       *
       * <pre>
       * Optional. GKE deployment configuration in yaml format.
       * </pre>
       *
       * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of gkeYamlConfigs.
       */
      public int getGkeYamlConfigsCount() {
        return gkeYamlConfigs_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. GKE deployment configuration in yaml format.
       * </pre>
       *
       * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The gkeYamlConfigs at the given index.
       */
      public java.lang.String getGkeYamlConfigs(int index) {
        return gkeYamlConfigs_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. GKE deployment configuration in yaml format.
       * </pre>
       *
       * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the gkeYamlConfigs at the given index.
       */
      public com.google.protobuf.ByteString getGkeYamlConfigsBytes(int index) {
        return gkeYamlConfigs_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < gkeYamlConfigs_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gkeYamlConfigs_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < gkeYamlConfigs_.size(); i++) {
            dataSize += computeStringSizeNoTag(gkeYamlConfigs_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getGkeYamlConfigsList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke other =
            (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke) obj;

        if (!getGkeYamlConfigsList().equals(other.getGkeYamlConfigsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getGkeYamlConfigsCount() > 0) {
          hash = (37 * hash) + GKE_YAML_CONFIGS_FIELD_NUMBER;
          hash = (53 * hash) + getGkeYamlConfigsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Configurations for PublisherModel GKE deployment
       * </pre>
       *
       * Protobuf type {@code google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke)
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGkeOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_DeployGke_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_DeployGke_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke.class,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          gkeYamlConfigs_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
              .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_DeployGke_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke build() {
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke result =
              new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            gkeYamlConfigs_.makeImmutable();
            result.gkeYamlConfigs_ = gkeYamlConfigs_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
                  .getDefaultInstance()) return this;
          if (!other.gkeYamlConfigs_.isEmpty()) {
            if (gkeYamlConfigs_.isEmpty()) {
              gkeYamlConfigs_ = other.gkeYamlConfigs_;
              bitField0_ |= 0x00000001;
            } else {
              ensureGkeYamlConfigsIsMutable();
              gkeYamlConfigs_.addAll(other.gkeYamlConfigs_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureGkeYamlConfigsIsMutable();
                    gkeYamlConfigs_.add(s);
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList gkeYamlConfigs_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureGkeYamlConfigsIsMutable() {
          if (!gkeYamlConfigs_.isModifiable()) {
            gkeYamlConfigs_ = new com.google.protobuf.LazyStringArrayList(gkeYamlConfigs_);
          }
          bitField0_ |= 0x00000001;
        }
        /**
         *
         *
         * <pre>
         * Optional. GKE deployment configuration in yaml format.
         * </pre>
         *
         * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return A list containing the gkeYamlConfigs.
         */
        public com.google.protobuf.ProtocolStringList getGkeYamlConfigsList() {
          gkeYamlConfigs_.makeImmutable();
          return gkeYamlConfigs_;
        }
        /**
         *
         *
         * <pre>
         * Optional. GKE deployment configuration in yaml format.
         * </pre>
         *
         * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The count of gkeYamlConfigs.
         */
        public int getGkeYamlConfigsCount() {
          return gkeYamlConfigs_.size();
        }
        /**
         *
         *
         * <pre>
         * Optional. GKE deployment configuration in yaml format.
         * </pre>
         *
         * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the element to return.
         * @return The gkeYamlConfigs at the given index.
         */
        public java.lang.String getGkeYamlConfigs(int index) {
          return gkeYamlConfigs_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. GKE deployment configuration in yaml format.
         * </pre>
         *
         * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the gkeYamlConfigs at the given index.
         */
        public com.google.protobuf.ByteString getGkeYamlConfigsBytes(int index) {
          return gkeYamlConfigs_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. GKE deployment configuration in yaml format.
         * </pre>
         *
         * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index to set the value at.
         * @param value The gkeYamlConfigs to set.
         * @return This builder for chaining.
         */
        public Builder setGkeYamlConfigs(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGkeYamlConfigsIsMutable();
          gkeYamlConfigs_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. GKE deployment configuration in yaml format.
         * </pre>
         *
         * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The gkeYamlConfigs to add.
         * @return This builder for chaining.
         */
        public Builder addGkeYamlConfigs(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGkeYamlConfigsIsMutable();
          gkeYamlConfigs_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. GKE deployment configuration in yaml format.
         * </pre>
         *
         * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param values The gkeYamlConfigs to add.
         * @return This builder for chaining.
         */
        public Builder addAllGkeYamlConfigs(java.lang.Iterable<java.lang.String> values) {
          ensureGkeYamlConfigsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, gkeYamlConfigs_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. GKE deployment configuration in yaml format.
         * </pre>
         *
         * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearGkeYamlConfigs() {
          gkeYamlConfigs_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. GKE deployment configuration in yaml format.
         * </pre>
         *
         * <code>repeated string gke_yaml_configs = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The bytes of the gkeYamlConfigs to add.
         * @return This builder for chaining.
         */
        public Builder addGkeYamlConfigsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureGkeYamlConfigsIsMutable();
          gkeYamlConfigs_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke)
      private static final com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke();
      }

      public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DeployGke> PARSER =
          new com.google.protobuf.AbstractParser<DeployGke>() {
            @java.lang.Override
            public DeployGke parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DeployGke> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DeployGke> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int VIEW_REST_API_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
        viewRestApi_;
    /**
     *
     *
     * <pre>
     * Optional. To view Rest API docs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the viewRestApi field is set.
     */
    @java.lang.Override
    public boolean hasViewRestApi() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. To view Rest API docs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The viewRestApi.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
        getViewRestApi() {
      return viewRestApi_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
              .getDefaultInstance()
          : viewRestApi_;
    }
    /**
     *
     *
     * <pre>
     * Optional. To view Rest API docs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApiOrBuilder
        getViewRestApiOrBuilder() {
      return viewRestApi_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
              .getDefaultInstance()
          : viewRestApi_;
    }

    public static final int OPEN_NOTEBOOK_FIELD_NUMBER = 2;
    private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        openNotebook_;
    /**
     *
     *
     * <pre>
     * Optional. Open notebook of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openNotebook field is set.
     */
    @java.lang.Override
    public boolean hasOpenNotebook() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Open notebook of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openNotebook.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        getOpenNotebook() {
      return openNotebook_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : openNotebook_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open notebook of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenNotebookOrBuilder() {
      return openNotebook_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : openNotebook_;
    }

    public static final int OPEN_NOTEBOOKS_FIELD_NUMBER = 12;
    private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
        openNotebooks_;
    /**
     *
     *
     * <pre>
     * Optional. Open notebooks of the PublisherModel.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks open_notebooks = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openNotebooks field is set.
     */
    @java.lang.Override
    public boolean hasOpenNotebooks() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Open notebooks of the PublisherModel.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks open_notebooks = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openNotebooks.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
        getOpenNotebooks() {
      return openNotebooks_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
              .getDefaultInstance()
          : openNotebooks_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open notebooks of the PublisherModel.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks open_notebooks = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooksOrBuilder
        getOpenNotebooksOrBuilder() {
      return openNotebooks_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
              .getDefaultInstance()
          : openNotebooks_;
    }

    public static final int CREATE_APPLICATION_FIELD_NUMBER = 3;
    private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        createApplication_;
    /**
     *
     *
     * <pre>
     * Optional. Create application using the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the createApplication field is set.
     */
    @java.lang.Override
    public boolean hasCreateApplication() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Create application using the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The createApplication.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        getCreateApplication() {
      return createApplication_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : createApplication_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Create application using the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getCreateApplicationOrBuilder() {
      return createApplication_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : createApplication_;
    }

    public static final int OPEN_FINE_TUNING_PIPELINE_FIELD_NUMBER = 4;
    private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        openFineTuningPipeline_;
    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openFineTuningPipeline field is set.
     */
    @java.lang.Override
    public boolean hasOpenFineTuningPipeline() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openFineTuningPipeline.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        getOpenFineTuningPipeline() {
      return openFineTuningPipeline_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : openFineTuningPipeline_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenFineTuningPipelineOrBuilder() {
      return openFineTuningPipeline_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : openFineTuningPipeline_;
    }

    public static final int OPEN_FINE_TUNING_PIPELINES_FIELD_NUMBER = 13;
    private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
        openFineTuningPipelines_;
    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipelines of the PublisherModel.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines open_fine_tuning_pipelines = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openFineTuningPipelines field is set.
     */
    @java.lang.Override
    public boolean hasOpenFineTuningPipelines() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipelines of the PublisherModel.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines open_fine_tuning_pipelines = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openFineTuningPipelines.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
        getOpenFineTuningPipelines() {
      return openFineTuningPipelines_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
              .getDefaultInstance()
          : openFineTuningPipelines_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open fine-tuning pipelines of the PublisherModel.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines open_fine_tuning_pipelines = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .OpenFineTuningPipelinesOrBuilder
        getOpenFineTuningPipelinesOrBuilder() {
      return openFineTuningPipelines_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
              .getDefaultInstance()
          : openFineTuningPipelines_;
    }

    public static final int OPEN_PROMPT_TUNING_PIPELINE_FIELD_NUMBER = 5;
    private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        openPromptTuningPipeline_;
    /**
     *
     *
     * <pre>
     * Optional. Open prompt-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openPromptTuningPipeline field is set.
     */
    @java.lang.Override
    public boolean hasOpenPromptTuningPipeline() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Open prompt-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openPromptTuningPipeline.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        getOpenPromptTuningPipeline() {
      return openPromptTuningPipeline_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : openPromptTuningPipeline_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open prompt-tuning pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenPromptTuningPipelineOrBuilder() {
      return openPromptTuningPipeline_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : openPromptTuningPipeline_;
    }

    public static final int OPEN_GENIE_FIELD_NUMBER = 6;
    private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        openGenie_;
    /**
     *
     *
     * <pre>
     * Optional. Open Genie / Playground.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openGenie field is set.
     */
    @java.lang.Override
    public boolean hasOpenGenie() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Open Genie / Playground.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openGenie.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        getOpenGenie() {
      return openGenie_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : openGenie_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open Genie / Playground.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenGenieOrBuilder() {
      return openGenie_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : openGenie_;
    }

    public static final int DEPLOY_FIELD_NUMBER = 7;
    private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy_;
    /**
     *
     *
     * <pre>
     * Optional. Deploy the PublisherModel to Vertex Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the deploy field is set.
     */
    @java.lang.Override
    public boolean hasDeploy() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploy the PublisherModel to Vertex Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The deploy.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy getDeploy() {
      return deploy_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
              .getDefaultInstance()
          : deploy_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploy the PublisherModel to Vertex Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployOrBuilder
        getDeployOrBuilder() {
      return deploy_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
              .getDefaultInstance()
          : deploy_;
    }

    public static final int MULTI_DEPLOY_VERTEX_FIELD_NUMBER = 16;
    private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
        multiDeployVertex_;
    /**
     *
     *
     * <pre>
     * Optional. Multiple setups to deploy the PublisherModel to Vertex
     * Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex multi_deploy_vertex = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the multiDeployVertex field is set.
     */
    @java.lang.Override
    public boolean hasMultiDeployVertex() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Multiple setups to deploy the PublisherModel to Vertex
     * Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex multi_deploy_vertex = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The multiDeployVertex.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
        getMultiDeployVertex() {
      return multiDeployVertex_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
              .getDefaultInstance()
          : multiDeployVertex_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Multiple setups to deploy the PublisherModel to Vertex
     * Endpoint.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex multi_deploy_vertex = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertexOrBuilder
        getMultiDeployVertexOrBuilder() {
      return multiDeployVertex_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
              .getDefaultInstance()
          : multiDeployVertex_;
    }

    public static final int DEPLOY_GKE_FIELD_NUMBER = 14;
    private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deployGke_;
    /**
     *
     *
     * <pre>
     * Optional. Deploy PublisherModel to Google Kubernetes Engine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deploy_gke = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the deployGke field is set.
     */
    @java.lang.Override
    public boolean hasDeployGke() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploy PublisherModel to Google Kubernetes Engine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deploy_gke = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The deployGke.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
        getDeployGke() {
      return deployGke_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
              .getDefaultInstance()
          : deployGke_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deploy PublisherModel to Google Kubernetes Engine.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deploy_gke = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGkeOrBuilder
        getDeployGkeOrBuilder() {
      return deployGke_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
              .getDefaultInstance()
          : deployGke_;
    }

    public static final int OPEN_GENERATION_AI_STUDIO_FIELD_NUMBER = 8;
    private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        openGenerationAiStudio_;
    /**
     *
     *
     * <pre>
     * Optional. Open in Generation AI Studio.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openGenerationAiStudio field is set.
     */
    @java.lang.Override
    public boolean hasOpenGenerationAiStudio() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Open in Generation AI Studio.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openGenerationAiStudio.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        getOpenGenerationAiStudio() {
      return openGenerationAiStudio_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : openGenerationAiStudio_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open in Generation AI Studio.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenGenerationAiStudioOrBuilder() {
      return openGenerationAiStudio_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : openGenerationAiStudio_;
    }

    public static final int REQUEST_ACCESS_FIELD_NUMBER = 9;
    private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        requestAccess_;
    /**
     *
     *
     * <pre>
     * Optional. Request for access.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the requestAccess field is set.
     */
    @java.lang.Override
    public boolean hasRequestAccess() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Request for access.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The requestAccess.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        getRequestAccess() {
      return requestAccess_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : requestAccess_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Request for access.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getRequestAccessOrBuilder() {
      return requestAccess_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : requestAccess_;
    }

    public static final int OPEN_EVALUATION_PIPELINE_FIELD_NUMBER = 11;
    private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        openEvaluationPipeline_;
    /**
     *
     *
     * <pre>
     * Optional. Open evaluation pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_evaluation_pipeline = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the openEvaluationPipeline field is set.
     */
    @java.lang.Override
    public boolean hasOpenEvaluationPipeline() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Open evaluation pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_evaluation_pipeline = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The openEvaluationPipeline.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferences
        getOpenEvaluationPipeline() {
      return openEvaluationPipeline_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : openEvaluationPipeline_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Open evaluation pipeline of the PublisherModel.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_evaluation_pipeline = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
            .RegionalResourceReferencesOrBuilder
        getOpenEvaluationPipelineOrBuilder() {
      return openEvaluationPipeline_ == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.getDefaultInstance()
          : openEvaluationPipeline_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getViewRestApi());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getOpenNotebook());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(3, getCreateApplication());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeMessage(4, getOpenFineTuningPipeline());
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        output.writeMessage(5, getOpenPromptTuningPipeline());
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        output.writeMessage(6, getOpenGenie());
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        output.writeMessage(7, getDeploy());
      }
      if (((bitField0_ & 0x00000800) != 0)) {
        output.writeMessage(8, getOpenGenerationAiStudio());
      }
      if (((bitField0_ & 0x00001000) != 0)) {
        output.writeMessage(9, getRequestAccess());
      }
      if (((bitField0_ & 0x00002000) != 0)) {
        output.writeMessage(11, getOpenEvaluationPipeline());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(12, getOpenNotebooks());
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        output.writeMessage(13, getOpenFineTuningPipelines());
      }
      if (((bitField0_ & 0x00000400) != 0)) {
        output.writeMessage(14, getDeployGke());
      }
      if (((bitField0_ & 0x00000200) != 0)) {
        output.writeMessage(16, getMultiDeployVertex());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getViewRestApi());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOpenNotebook());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateApplication());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, getOpenFineTuningPipeline());
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, getOpenPromptTuningPipeline());
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getOpenGenie());
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getDeploy());
      }
      if (((bitField0_ & 0x00000800) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                8, getOpenGenerationAiStudio());
      }
      if (((bitField0_ & 0x00001000) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getRequestAccess());
      }
      if (((bitField0_ & 0x00002000) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                11, getOpenEvaluationPipeline());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getOpenNotebooks());
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                13, getOpenFineTuningPipelines());
      }
      if (((bitField0_ & 0x00000400) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getDeployGke());
      }
      if (((bitField0_ & 0x00000200) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(16, getMultiDeployVertex());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction other =
          (com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction) obj;

      if (hasViewRestApi() != other.hasViewRestApi()) return false;
      if (hasViewRestApi()) {
        if (!getViewRestApi().equals(other.getViewRestApi())) return false;
      }
      if (hasOpenNotebook() != other.hasOpenNotebook()) return false;
      if (hasOpenNotebook()) {
        if (!getOpenNotebook().equals(other.getOpenNotebook())) return false;
      }
      if (hasOpenNotebooks() != other.hasOpenNotebooks()) return false;
      if (hasOpenNotebooks()) {
        if (!getOpenNotebooks().equals(other.getOpenNotebooks())) return false;
      }
      if (hasCreateApplication() != other.hasCreateApplication()) return false;
      if (hasCreateApplication()) {
        if (!getCreateApplication().equals(other.getCreateApplication())) return false;
      }
      if (hasOpenFineTuningPipeline() != other.hasOpenFineTuningPipeline()) return false;
      if (hasOpenFineTuningPipeline()) {
        if (!getOpenFineTuningPipeline().equals(other.getOpenFineTuningPipeline())) return false;
      }
      if (hasOpenFineTuningPipelines() != other.hasOpenFineTuningPipelines()) return false;
      if (hasOpenFineTuningPipelines()) {
        if (!getOpenFineTuningPipelines().equals(other.getOpenFineTuningPipelines())) return false;
      }
      if (hasOpenPromptTuningPipeline() != other.hasOpenPromptTuningPipeline()) return false;
      if (hasOpenPromptTuningPipeline()) {
        if (!getOpenPromptTuningPipeline().equals(other.getOpenPromptTuningPipeline()))
          return false;
      }
      if (hasOpenGenie() != other.hasOpenGenie()) return false;
      if (hasOpenGenie()) {
        if (!getOpenGenie().equals(other.getOpenGenie())) return false;
      }
      if (hasDeploy() != other.hasDeploy()) return false;
      if (hasDeploy()) {
        if (!getDeploy().equals(other.getDeploy())) return false;
      }
      if (hasMultiDeployVertex() != other.hasMultiDeployVertex()) return false;
      if (hasMultiDeployVertex()) {
        if (!getMultiDeployVertex().equals(other.getMultiDeployVertex())) return false;
      }
      if (hasDeployGke() != other.hasDeployGke()) return false;
      if (hasDeployGke()) {
        if (!getDeployGke().equals(other.getDeployGke())) return false;
      }
      if (hasOpenGenerationAiStudio() != other.hasOpenGenerationAiStudio()) return false;
      if (hasOpenGenerationAiStudio()) {
        if (!getOpenGenerationAiStudio().equals(other.getOpenGenerationAiStudio())) return false;
      }
      if (hasRequestAccess() != other.hasRequestAccess()) return false;
      if (hasRequestAccess()) {
        if (!getRequestAccess().equals(other.getRequestAccess())) return false;
      }
      if (hasOpenEvaluationPipeline() != other.hasOpenEvaluationPipeline()) return false;
      if (hasOpenEvaluationPipeline()) {
        if (!getOpenEvaluationPipeline().equals(other.getOpenEvaluationPipeline())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasViewRestApi()) {
        hash = (37 * hash) + VIEW_REST_API_FIELD_NUMBER;
        hash = (53 * hash) + getViewRestApi().hashCode();
      }
      if (hasOpenNotebook()) {
        hash = (37 * hash) + OPEN_NOTEBOOK_FIELD_NUMBER;
        hash = (53 * hash) + getOpenNotebook().hashCode();
      }
      if (hasOpenNotebooks()) {
        hash = (37 * hash) + OPEN_NOTEBOOKS_FIELD_NUMBER;
        hash = (53 * hash) + getOpenNotebooks().hashCode();
      }
      if (hasCreateApplication()) {
        hash = (37 * hash) + CREATE_APPLICATION_FIELD_NUMBER;
        hash = (53 * hash) + getCreateApplication().hashCode();
      }
      if (hasOpenFineTuningPipeline()) {
        hash = (37 * hash) + OPEN_FINE_TUNING_PIPELINE_FIELD_NUMBER;
        hash = (53 * hash) + getOpenFineTuningPipeline().hashCode();
      }
      if (hasOpenFineTuningPipelines()) {
        hash = (37 * hash) + OPEN_FINE_TUNING_PIPELINES_FIELD_NUMBER;
        hash = (53 * hash) + getOpenFineTuningPipelines().hashCode();
      }
      if (hasOpenPromptTuningPipeline()) {
        hash = (37 * hash) + OPEN_PROMPT_TUNING_PIPELINE_FIELD_NUMBER;
        hash = (53 * hash) + getOpenPromptTuningPipeline().hashCode();
      }
      if (hasOpenGenie()) {
        hash = (37 * hash) + OPEN_GENIE_FIELD_NUMBER;
        hash = (53 * hash) + getOpenGenie().hashCode();
      }
      if (hasDeploy()) {
        hash = (37 * hash) + DEPLOY_FIELD_NUMBER;
        hash = (53 * hash) + getDeploy().hashCode();
      }
      if (hasMultiDeployVertex()) {
        hash = (37 * hash) + MULTI_DEPLOY_VERTEX_FIELD_NUMBER;
        hash = (53 * hash) + getMultiDeployVertex().hashCode();
      }
      if (hasDeployGke()) {
        hash = (37 * hash) + DEPLOY_GKE_FIELD_NUMBER;
        hash = (53 * hash) + getDeployGke().hashCode();
      }
      if (hasOpenGenerationAiStudio()) {
        hash = (37 * hash) + OPEN_GENERATION_AI_STUDIO_FIELD_NUMBER;
        hash = (53 * hash) + getOpenGenerationAiStudio().hashCode();
      }
      if (hasRequestAccess()) {
        hash = (37 * hash) + REQUEST_ACCESS_FIELD_NUMBER;
        hash = (53 * hash) + getRequestAccess().hashCode();
      }
      if (hasOpenEvaluationPipeline()) {
        hash = (37 * hash) + OPEN_EVALUATION_PIPELINE_FIELD_NUMBER;
        hash = (53 * hash) + getOpenEvaluationPipeline().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Actions could take on this Publisher Model.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction)
        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.class,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getViewRestApiFieldBuilder();
          getOpenNotebookFieldBuilder();
          getOpenNotebooksFieldBuilder();
          getCreateApplicationFieldBuilder();
          getOpenFineTuningPipelineFieldBuilder();
          getOpenFineTuningPipelinesFieldBuilder();
          getOpenPromptTuningPipelineFieldBuilder();
          getOpenGenieFieldBuilder();
          getDeployFieldBuilder();
          getMultiDeployVertexFieldBuilder();
          getDeployGkeFieldBuilder();
          getOpenGenerationAiStudioFieldBuilder();
          getRequestAccessFieldBuilder();
          getOpenEvaluationPipelineFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        viewRestApi_ = null;
        if (viewRestApiBuilder_ != null) {
          viewRestApiBuilder_.dispose();
          viewRestApiBuilder_ = null;
        }
        openNotebook_ = null;
        if (openNotebookBuilder_ != null) {
          openNotebookBuilder_.dispose();
          openNotebookBuilder_ = null;
        }
        openNotebooks_ = null;
        if (openNotebooksBuilder_ != null) {
          openNotebooksBuilder_.dispose();
          openNotebooksBuilder_ = null;
        }
        createApplication_ = null;
        if (createApplicationBuilder_ != null) {
          createApplicationBuilder_.dispose();
          createApplicationBuilder_ = null;
        }
        openFineTuningPipeline_ = null;
        if (openFineTuningPipelineBuilder_ != null) {
          openFineTuningPipelineBuilder_.dispose();
          openFineTuningPipelineBuilder_ = null;
        }
        openFineTuningPipelines_ = null;
        if (openFineTuningPipelinesBuilder_ != null) {
          openFineTuningPipelinesBuilder_.dispose();
          openFineTuningPipelinesBuilder_ = null;
        }
        openPromptTuningPipeline_ = null;
        if (openPromptTuningPipelineBuilder_ != null) {
          openPromptTuningPipelineBuilder_.dispose();
          openPromptTuningPipelineBuilder_ = null;
        }
        openGenie_ = null;
        if (openGenieBuilder_ != null) {
          openGenieBuilder_.dispose();
          openGenieBuilder_ = null;
        }
        deploy_ = null;
        if (deployBuilder_ != null) {
          deployBuilder_.dispose();
          deployBuilder_ = null;
        }
        multiDeployVertex_ = null;
        if (multiDeployVertexBuilder_ != null) {
          multiDeployVertexBuilder_.dispose();
          multiDeployVertexBuilder_ = null;
        }
        deployGke_ = null;
        if (deployGkeBuilder_ != null) {
          deployGkeBuilder_.dispose();
          deployGkeBuilder_ = null;
        }
        openGenerationAiStudio_ = null;
        if (openGenerationAiStudioBuilder_ != null) {
          openGenerationAiStudioBuilder_.dispose();
          openGenerationAiStudioBuilder_ = null;
        }
        requestAccess_ = null;
        if (requestAccessBuilder_ != null) {
          requestAccessBuilder_.dispose();
          requestAccessBuilder_ = null;
        }
        openEvaluationPipeline_ = null;
        if (openEvaluationPipelineBuilder_ != null) {
          openEvaluationPipelineBuilder_.dispose();
          openEvaluationPipelineBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
            .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_CallToAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction build() {
        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction buildPartial() {
        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction result =
            new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.viewRestApi_ =
              viewRestApiBuilder_ == null ? viewRestApi_ : viewRestApiBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.openNotebook_ =
              openNotebookBuilder_ == null ? openNotebook_ : openNotebookBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.openNotebooks_ =
              openNotebooksBuilder_ == null ? openNotebooks_ : openNotebooksBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.createApplication_ =
              createApplicationBuilder_ == null
                  ? createApplication_
                  : createApplicationBuilder_.build();
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.openFineTuningPipeline_ =
              openFineTuningPipelineBuilder_ == null
                  ? openFineTuningPipeline_
                  : openFineTuningPipelineBuilder_.build();
          to_bitField0_ |= 0x00000010;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.openFineTuningPipelines_ =
              openFineTuningPipelinesBuilder_ == null
                  ? openFineTuningPipelines_
                  : openFineTuningPipelinesBuilder_.build();
          to_bitField0_ |= 0x00000020;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.openPromptTuningPipeline_ =
              openPromptTuningPipelineBuilder_ == null
                  ? openPromptTuningPipeline_
                  : openPromptTuningPipelineBuilder_.build();
          to_bitField0_ |= 0x00000040;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.openGenie_ = openGenieBuilder_ == null ? openGenie_ : openGenieBuilder_.build();
          to_bitField0_ |= 0x00000080;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.deploy_ = deployBuilder_ == null ? deploy_ : deployBuilder_.build();
          to_bitField0_ |= 0x00000100;
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.multiDeployVertex_ =
              multiDeployVertexBuilder_ == null
                  ? multiDeployVertex_
                  : multiDeployVertexBuilder_.build();
          to_bitField0_ |= 0x00000200;
        }
        if (((from_bitField0_ & 0x00000400) != 0)) {
          result.deployGke_ = deployGkeBuilder_ == null ? deployGke_ : deployGkeBuilder_.build();
          to_bitField0_ |= 0x00000400;
        }
        if (((from_bitField0_ & 0x00000800) != 0)) {
          result.openGenerationAiStudio_ =
              openGenerationAiStudioBuilder_ == null
                  ? openGenerationAiStudio_
                  : openGenerationAiStudioBuilder_.build();
          to_bitField0_ |= 0x00000800;
        }
        if (((from_bitField0_ & 0x00001000) != 0)) {
          result.requestAccess_ =
              requestAccessBuilder_ == null ? requestAccess_ : requestAccessBuilder_.build();
          to_bitField0_ |= 0x00001000;
        }
        if (((from_bitField0_ & 0x00002000) != 0)) {
          result.openEvaluationPipeline_ =
              openEvaluationPipelineBuilder_ == null
                  ? openEvaluationPipeline_
                  : openEvaluationPipelineBuilder_.build();
          to_bitField0_ |= 0x00002000;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction) {
          return mergeFrom((com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.getDefaultInstance())
          return this;
        if (other.hasViewRestApi()) {
          mergeViewRestApi(other.getViewRestApi());
        }
        if (other.hasOpenNotebook()) {
          mergeOpenNotebook(other.getOpenNotebook());
        }
        if (other.hasOpenNotebooks()) {
          mergeOpenNotebooks(other.getOpenNotebooks());
        }
        if (other.hasCreateApplication()) {
          mergeCreateApplication(other.getCreateApplication());
        }
        if (other.hasOpenFineTuningPipeline()) {
          mergeOpenFineTuningPipeline(other.getOpenFineTuningPipeline());
        }
        if (other.hasOpenFineTuningPipelines()) {
          mergeOpenFineTuningPipelines(other.getOpenFineTuningPipelines());
        }
        if (other.hasOpenPromptTuningPipeline()) {
          mergeOpenPromptTuningPipeline(other.getOpenPromptTuningPipeline());
        }
        if (other.hasOpenGenie()) {
          mergeOpenGenie(other.getOpenGenie());
        }
        if (other.hasDeploy()) {
          mergeDeploy(other.getDeploy());
        }
        if (other.hasMultiDeployVertex()) {
          mergeMultiDeployVertex(other.getMultiDeployVertex());
        }
        if (other.hasDeployGke()) {
          mergeDeployGke(other.getDeployGke());
        }
        if (other.hasOpenGenerationAiStudio()) {
          mergeOpenGenerationAiStudio(other.getOpenGenerationAiStudio());
        }
        if (other.hasRequestAccess()) {
          mergeRequestAccess(other.getRequestAccess());
        }
        if (other.hasOpenEvaluationPipeline()) {
          mergeOpenEvaluationPipeline(other.getOpenEvaluationPipeline());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getViewRestApiFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getOpenNotebookFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getCreateApplicationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getOpenFineTuningPipelineFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getOpenPromptTuningPipelineFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getOpenGenieFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000080;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(getDeployFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000100;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(
                      getOpenGenerationAiStudioFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000800;
                  break;
                } // case 66
              case 74:
                {
                  input.readMessage(getRequestAccessFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00001000;
                  break;
                } // case 74
              case 90:
                {
                  input.readMessage(
                      getOpenEvaluationPipelineFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00002000;
                  break;
                } // case 90
              case 98:
                {
                  input.readMessage(getOpenNotebooksFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 98
              case 106:
                {
                  input.readMessage(
                      getOpenFineTuningPipelinesFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 106
              case 114:
                {
                  input.readMessage(getDeployGkeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000400;
                  break;
                } // case 114
              case 130:
                {
                  input.readMessage(
                      getMultiDeployVertexFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000200;
                  break;
                } // case 130
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          viewRestApi_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApiOrBuilder>
          viewRestApiBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the viewRestApi field is set.
       */
      public boolean hasViewRestApi() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The viewRestApi.
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
          getViewRestApi() {
        if (viewRestApiBuilder_ == null) {
          return viewRestApi_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
                  .getDefaultInstance()
              : viewRestApi_;
        } else {
          return viewRestApiBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setViewRestApi(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi value) {
        if (viewRestApiBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          viewRestApi_ = value;
        } else {
          viewRestApiBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setViewRestApi(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi.Builder
              builderForValue) {
        if (viewRestApiBuilder_ == null) {
          viewRestApi_ = builderForValue.build();
        } else {
          viewRestApiBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeViewRestApi(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi value) {
        if (viewRestApiBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && viewRestApi_ != null
              && viewRestApi_
                  != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
                      .getDefaultInstance()) {
            getViewRestApiBuilder().mergeFrom(value);
          } else {
            viewRestApi_ = value;
          }
        } else {
          viewRestApiBuilder_.mergeFrom(value);
        }
        if (viewRestApi_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearViewRestApi() {
        bitField0_ = (bitField0_ & ~0x00000001);
        viewRestApi_ = null;
        if (viewRestApiBuilder_ != null) {
          viewRestApiBuilder_.dispose();
          viewRestApiBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi.Builder
          getViewRestApiBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getViewRestApiFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApiOrBuilder
          getViewRestApiOrBuilder() {
        if (viewRestApiBuilder_ != null) {
          return viewRestApiBuilder_.getMessageOrBuilder();
        } else {
          return viewRestApi_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
                  .getDefaultInstance()
              : viewRestApi_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. To view Rest API docs.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi view_rest_api = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApiOrBuilder>
          getViewRestApiFieldBuilder() {
        if (viewRestApiBuilder_ == null) {
          viewRestApiBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.ViewRestApi
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .ViewRestApiOrBuilder>(getViewRestApi(), getParentForChildren(), isClean());
          viewRestApi_ = null;
        }
        return viewRestApiBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          openNotebook_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          openNotebookBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the openNotebook field is set.
       */
      public boolean hasOpenNotebook() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The openNotebook.
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          getOpenNotebook() {
        if (openNotebookBuilder_ == null) {
          return openNotebook_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openNotebook_;
        } else {
          return openNotebookBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenNotebook(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openNotebookBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          openNotebook_ = value;
        } else {
          openNotebookBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenNotebook(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder
              builderForValue) {
        if (openNotebookBuilder_ == null) {
          openNotebook_ = builderForValue.build();
        } else {
          openNotebookBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOpenNotebook(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openNotebookBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && openNotebook_ != null
              && openNotebook_
                  != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance()) {
            getOpenNotebookBuilder().mergeFrom(value);
          } else {
            openNotebook_ = value;
          }
        } else {
          openNotebookBuilder_.mergeFrom(value);
        }
        if (openNotebook_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOpenNotebook() {
        bitField0_ = (bitField0_ & ~0x00000002);
        openNotebook_ = null;
        if (openNotebookBuilder_ != null) {
          openNotebookBuilder_.dispose();
          openNotebookBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.Builder
          getOpenNotebookBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getOpenNotebookFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getOpenNotebookOrBuilder() {
        if (openNotebookBuilder_ != null) {
          return openNotebookBuilder_.getMessageOrBuilder();
        } else {
          return openNotebook_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openNotebook_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebook of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_notebook = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          getOpenNotebookFieldBuilder() {
        if (openNotebookBuilder_ == null) {
          openNotebookBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>(
                  getOpenNotebook(), getParentForChildren(), isClean());
          openNotebook_ = null;
        }
        return openNotebookBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          openNotebooks_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .OpenNotebooksOrBuilder>
          openNotebooksBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Open notebooks of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks open_notebooks = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the openNotebooks field is set.
       */
      public boolean hasOpenNotebooks() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebooks of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks open_notebooks = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The openNotebooks.
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
          getOpenNotebooks() {
        if (openNotebooksBuilder_ == null) {
          return openNotebooks_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
                  .getDefaultInstance()
              : openNotebooks_;
        } else {
          return openNotebooksBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebooks of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks open_notebooks = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenNotebooks(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks value) {
        if (openNotebooksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          openNotebooks_ = value;
        } else {
          openNotebooksBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebooks of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks open_notebooks = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenNotebooks(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks.Builder
              builderForValue) {
        if (openNotebooksBuilder_ == null) {
          openNotebooks_ = builderForValue.build();
        } else {
          openNotebooksBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebooks of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks open_notebooks = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOpenNotebooks(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks value) {
        if (openNotebooksBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && openNotebooks_ != null
              && openNotebooks_
                  != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
                      .getDefaultInstance()) {
            getOpenNotebooksBuilder().mergeFrom(value);
          } else {
            openNotebooks_ = value;
          }
        } else {
          openNotebooksBuilder_.mergeFrom(value);
        }
        if (openNotebooks_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebooks of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks open_notebooks = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOpenNotebooks() {
        bitField0_ = (bitField0_ & ~0x00000004);
        openNotebooks_ = null;
        if (openNotebooksBuilder_ != null) {
          openNotebooksBuilder_.dispose();
          openNotebooksBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebooks of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks open_notebooks = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks.Builder
          getOpenNotebooksBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getOpenNotebooksFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebooks of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks open_notebooks = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooksOrBuilder
          getOpenNotebooksOrBuilder() {
        if (openNotebooksBuilder_ != null) {
          return openNotebooksBuilder_.getMessageOrBuilder();
        } else {
          return openNotebooks_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
                  .getDefaultInstance()
              : openNotebooks_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open notebooks of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks open_notebooks = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .OpenNotebooksOrBuilder>
          getOpenNotebooksFieldBuilder() {
        if (openNotebooksBuilder_ == null) {
          openNotebooksBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenNotebooks
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .OpenNotebooksOrBuilder>(
                  getOpenNotebooks(), getParentForChildren(), isClean());
          openNotebooks_ = null;
        }
        return openNotebooksBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          createApplication_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          createApplicationBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the createApplication field is set.
       */
      public boolean hasCreateApplication() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The createApplication.
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          getCreateApplication() {
        if (createApplicationBuilder_ == null) {
          return createApplication_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : createApplication_;
        } else {
          return createApplicationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setCreateApplication(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (createApplicationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          createApplication_ = value;
        } else {
          createApplicationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setCreateApplication(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder
              builderForValue) {
        if (createApplicationBuilder_ == null) {
          createApplication_ = builderForValue.build();
        } else {
          createApplicationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeCreateApplication(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (createApplicationBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && createApplication_ != null
              && createApplication_
                  != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance()) {
            getCreateApplicationBuilder().mergeFrom(value);
          } else {
            createApplication_ = value;
          }
        } else {
          createApplicationBuilder_.mergeFrom(value);
        }
        if (createApplication_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearCreateApplication() {
        bitField0_ = (bitField0_ & ~0x00000008);
        createApplication_ = null;
        if (createApplicationBuilder_ != null) {
          createApplicationBuilder_.dispose();
          createApplicationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.Builder
          getCreateApplicationBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getCreateApplicationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getCreateApplicationOrBuilder() {
        if (createApplicationBuilder_ != null) {
          return createApplicationBuilder_.getMessageOrBuilder();
        } else {
          return createApplication_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : createApplication_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Create application using the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences create_application = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          getCreateApplicationFieldBuilder() {
        if (createApplicationBuilder_ == null) {
          createApplicationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>(
                  getCreateApplication(), getParentForChildren(), isClean());
          createApplication_ = null;
        }
        return createApplicationBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          openFineTuningPipeline_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          openFineTuningPipelineBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the openFineTuningPipeline field is set.
       */
      public boolean hasOpenFineTuningPipeline() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The openFineTuningPipeline.
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          getOpenFineTuningPipeline() {
        if (openFineTuningPipelineBuilder_ == null) {
          return openFineTuningPipeline_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openFineTuningPipeline_;
        } else {
          return openFineTuningPipelineBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenFineTuningPipeline(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openFineTuningPipelineBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          openFineTuningPipeline_ = value;
        } else {
          openFineTuningPipelineBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenFineTuningPipeline(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder
              builderForValue) {
        if (openFineTuningPipelineBuilder_ == null) {
          openFineTuningPipeline_ = builderForValue.build();
        } else {
          openFineTuningPipelineBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOpenFineTuningPipeline(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openFineTuningPipelineBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && openFineTuningPipeline_ != null
              && openFineTuningPipeline_
                  != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance()) {
            getOpenFineTuningPipelineBuilder().mergeFrom(value);
          } else {
            openFineTuningPipeline_ = value;
          }
        } else {
          openFineTuningPipelineBuilder_.mergeFrom(value);
        }
        if (openFineTuningPipeline_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOpenFineTuningPipeline() {
        bitField0_ = (bitField0_ & ~0x00000010);
        openFineTuningPipeline_ = null;
        if (openFineTuningPipelineBuilder_ != null) {
          openFineTuningPipelineBuilder_.dispose();
          openFineTuningPipelineBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.Builder
          getOpenFineTuningPipelineBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getOpenFineTuningPipelineFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getOpenFineTuningPipelineOrBuilder() {
        if (openFineTuningPipelineBuilder_ != null) {
          return openFineTuningPipelineBuilder_.getMessageOrBuilder();
        } else {
          return openFineTuningPipeline_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openFineTuningPipeline_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_fine_tuning_pipeline = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          getOpenFineTuningPipelineFieldBuilder() {
        if (openFineTuningPipelineBuilder_ == null) {
          openFineTuningPipelineBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>(
                  getOpenFineTuningPipeline(), getParentForChildren(), isClean());
          openFineTuningPipeline_ = null;
        }
        return openFineTuningPipelineBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelines
          openFineTuningPipelines_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .OpenFineTuningPipelines,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .OpenFineTuningPipelines.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .OpenFineTuningPipelinesOrBuilder>
          openFineTuningPipelinesBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipelines of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines open_fine_tuning_pipelines = 13 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the openFineTuningPipelines field is set.
       */
      public boolean hasOpenFineTuningPipelines() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipelines of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines open_fine_tuning_pipelines = 13 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The openFineTuningPipelines.
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
          getOpenFineTuningPipelines() {
        if (openFineTuningPipelinesBuilder_ == null) {
          return openFineTuningPipelines_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .OpenFineTuningPipelines.getDefaultInstance()
              : openFineTuningPipelines_;
        } else {
          return openFineTuningPipelinesBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipelines of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines open_fine_tuning_pipelines = 13 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenFineTuningPipelines(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
              value) {
        if (openFineTuningPipelinesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          openFineTuningPipelines_ = value;
        } else {
          openFineTuningPipelinesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipelines of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines open_fine_tuning_pipelines = 13 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenFineTuningPipelines(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
                  .Builder
              builderForValue) {
        if (openFineTuningPipelinesBuilder_ == null) {
          openFineTuningPipelines_ = builderForValue.build();
        } else {
          openFineTuningPipelinesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipelines of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines open_fine_tuning_pipelines = 13 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOpenFineTuningPipelines(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
              value) {
        if (openFineTuningPipelinesBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && openFineTuningPipelines_ != null
              && openFineTuningPipelines_
                  != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .OpenFineTuningPipelines.getDefaultInstance()) {
            getOpenFineTuningPipelinesBuilder().mergeFrom(value);
          } else {
            openFineTuningPipelines_ = value;
          }
        } else {
          openFineTuningPipelinesBuilder_.mergeFrom(value);
        }
        if (openFineTuningPipelines_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipelines of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines open_fine_tuning_pipelines = 13 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOpenFineTuningPipelines() {
        bitField0_ = (bitField0_ & ~0x00000020);
        openFineTuningPipelines_ = null;
        if (openFineTuningPipelinesBuilder_ != null) {
          openFineTuningPipelinesBuilder_.dispose();
          openFineTuningPipelinesBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipelines of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines open_fine_tuning_pipelines = 13 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines
              .Builder
          getOpenFineTuningPipelinesBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getOpenFineTuningPipelinesFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipelines of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines open_fine_tuning_pipelines = 13 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .OpenFineTuningPipelinesOrBuilder
          getOpenFineTuningPipelinesOrBuilder() {
        if (openFineTuningPipelinesBuilder_ != null) {
          return openFineTuningPipelinesBuilder_.getMessageOrBuilder();
        } else {
          return openFineTuningPipelines_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .OpenFineTuningPipelines.getDefaultInstance()
              : openFineTuningPipelines_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open fine-tuning pipelines of the PublisherModel.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.OpenFineTuningPipelines open_fine_tuning_pipelines = 13 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .OpenFineTuningPipelines,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .OpenFineTuningPipelines.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .OpenFineTuningPipelinesOrBuilder>
          getOpenFineTuningPipelinesFieldBuilder() {
        if (openFineTuningPipelinesBuilder_ == null) {
          openFineTuningPipelinesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .OpenFineTuningPipelines,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .OpenFineTuningPipelines.Builder,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .OpenFineTuningPipelinesOrBuilder>(
                  getOpenFineTuningPipelines(), getParentForChildren(), isClean());
          openFineTuningPipelines_ = null;
        }
        return openFineTuningPipelinesBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          openPromptTuningPipeline_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          openPromptTuningPipelineBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the openPromptTuningPipeline field is set.
       */
      public boolean hasOpenPromptTuningPipeline() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The openPromptTuningPipeline.
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          getOpenPromptTuningPipeline() {
        if (openPromptTuningPipelineBuilder_ == null) {
          return openPromptTuningPipeline_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openPromptTuningPipeline_;
        } else {
          return openPromptTuningPipelineBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenPromptTuningPipeline(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openPromptTuningPipelineBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          openPromptTuningPipeline_ = value;
        } else {
          openPromptTuningPipelineBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenPromptTuningPipeline(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder
              builderForValue) {
        if (openPromptTuningPipelineBuilder_ == null) {
          openPromptTuningPipeline_ = builderForValue.build();
        } else {
          openPromptTuningPipelineBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOpenPromptTuningPipeline(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openPromptTuningPipelineBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && openPromptTuningPipeline_ != null
              && openPromptTuningPipeline_
                  != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance()) {
            getOpenPromptTuningPipelineBuilder().mergeFrom(value);
          } else {
            openPromptTuningPipeline_ = value;
          }
        } else {
          openPromptTuningPipelineBuilder_.mergeFrom(value);
        }
        if (openPromptTuningPipeline_ != null) {
          bitField0_ |= 0x00000040;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOpenPromptTuningPipeline() {
        bitField0_ = (bitField0_ & ~0x00000040);
        openPromptTuningPipeline_ = null;
        if (openPromptTuningPipelineBuilder_ != null) {
          openPromptTuningPipelineBuilder_.dispose();
          openPromptTuningPipelineBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.Builder
          getOpenPromptTuningPipelineBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getOpenPromptTuningPipelineFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getOpenPromptTuningPipelineOrBuilder() {
        if (openPromptTuningPipelineBuilder_ != null) {
          return openPromptTuningPipelineBuilder_.getMessageOrBuilder();
        } else {
          return openPromptTuningPipeline_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openPromptTuningPipeline_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open prompt-tuning pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_prompt_tuning_pipeline = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          getOpenPromptTuningPipelineFieldBuilder() {
        if (openPromptTuningPipelineBuilder_ == null) {
          openPromptTuningPipelineBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>(
                  getOpenPromptTuningPipeline(), getParentForChildren(), isClean());
          openPromptTuningPipeline_ = null;
        }
        return openPromptTuningPipelineBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          openGenie_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          openGenieBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the openGenie field is set.
       */
      public boolean hasOpenGenie() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The openGenie.
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          getOpenGenie() {
        if (openGenieBuilder_ == null) {
          return openGenie_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openGenie_;
        } else {
          return openGenieBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenGenie(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openGenieBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          openGenie_ = value;
        } else {
          openGenieBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenGenie(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder
              builderForValue) {
        if (openGenieBuilder_ == null) {
          openGenie_ = builderForValue.build();
        } else {
          openGenieBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOpenGenie(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openGenieBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0)
              && openGenie_ != null
              && openGenie_
                  != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance()) {
            getOpenGenieBuilder().mergeFrom(value);
          } else {
            openGenie_ = value;
          }
        } else {
          openGenieBuilder_.mergeFrom(value);
        }
        if (openGenie_ != null) {
          bitField0_ |= 0x00000080;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOpenGenie() {
        bitField0_ = (bitField0_ & ~0x00000080);
        openGenie_ = null;
        if (openGenieBuilder_ != null) {
          openGenieBuilder_.dispose();
          openGenieBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.Builder
          getOpenGenieBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getOpenGenieFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getOpenGenieOrBuilder() {
        if (openGenieBuilder_ != null) {
          return openGenieBuilder_.getMessageOrBuilder();
        } else {
          return openGenie_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openGenie_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open Genie / Playground.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_genie = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          getOpenGenieFieldBuilder() {
        if (openGenieBuilder_ == null) {
          openGenieBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>(
                  getOpenGenie(), getParentForChildren(), isClean());
          openGenie_ = null;
        }
        return openGenieBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployOrBuilder>
          deployBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the deploy field is set.
       */
      public boolean hasDeploy() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The deploy.
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy getDeploy() {
        if (deployBuilder_ == null) {
          return deploy_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                  .getDefaultInstance()
              : deploy_;
        } else {
          return deployBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDeploy(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy value) {
        if (deployBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          deploy_ = value;
        } else {
          deployBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDeploy(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder
              builderForValue) {
        if (deployBuilder_ == null) {
          deploy_ = builderForValue.build();
        } else {
          deployBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeDeploy(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy value) {
        if (deployBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)
              && deploy_ != null
              && deploy_
                  != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                      .getDefaultInstance()) {
            getDeployBuilder().mergeFrom(value);
          } else {
            deploy_ = value;
          }
        } else {
          deployBuilder_.mergeFrom(value);
        }
        if (deploy_ != null) {
          bitField0_ |= 0x00000100;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearDeploy() {
        bitField0_ = (bitField0_ & ~0x00000100);
        deploy_ = null;
        if (deployBuilder_ != null) {
          deployBuilder_.dispose();
          deployBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder
          getDeployBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getDeployFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployOrBuilder
          getDeployOrBuilder() {
        if (deployBuilder_ != null) {
          return deployBuilder_.getMessageOrBuilder();
        } else {
          return deploy_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy
                  .getDefaultInstance()
              : deploy_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy the PublisherModel to Vertex Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy deploy = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployOrBuilder>
          getDeployFieldBuilder() {
        if (deployBuilder_ == null) {
          deployBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Deploy.Builder,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployOrBuilder>(
                  getDeploy(), getParentForChildren(), isClean());
          deploy_ = null;
        }
        return deployBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          multiDeployVertex_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertexOrBuilder>
          multiDeployVertexBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Multiple setups to deploy the PublisherModel to Vertex
       * Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex multi_deploy_vertex = 16 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the multiDeployVertex field is set.
       */
      public boolean hasMultiDeployVertex() {
        return ((bitField0_ & 0x00000200) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Multiple setups to deploy the PublisherModel to Vertex
       * Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex multi_deploy_vertex = 16 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The multiDeployVertex.
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
          getMultiDeployVertex() {
        if (multiDeployVertexBuilder_ == null) {
          return multiDeployVertex_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
                  .getDefaultInstance()
              : multiDeployVertex_;
        } else {
          return multiDeployVertexBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Multiple setups to deploy the PublisherModel to Vertex
       * Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex multi_deploy_vertex = 16 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setMultiDeployVertex(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex value) {
        if (multiDeployVertexBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          multiDeployVertex_ = value;
        } else {
          multiDeployVertexBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Multiple setups to deploy the PublisherModel to Vertex
       * Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex multi_deploy_vertex = 16 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setMultiDeployVertex(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex.Builder
              builderForValue) {
        if (multiDeployVertexBuilder_ == null) {
          multiDeployVertex_ = builderForValue.build();
        } else {
          multiDeployVertexBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Multiple setups to deploy the PublisherModel to Vertex
       * Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex multi_deploy_vertex = 16 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeMultiDeployVertex(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex value) {
        if (multiDeployVertexBuilder_ == null) {
          if (((bitField0_ & 0x00000200) != 0)
              && multiDeployVertex_ != null
              && multiDeployVertex_
                  != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
                      .getDefaultInstance()) {
            getMultiDeployVertexBuilder().mergeFrom(value);
          } else {
            multiDeployVertex_ = value;
          }
        } else {
          multiDeployVertexBuilder_.mergeFrom(value);
        }
        if (multiDeployVertex_ != null) {
          bitField0_ |= 0x00000200;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Multiple setups to deploy the PublisherModel to Vertex
       * Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex multi_deploy_vertex = 16 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearMultiDeployVertex() {
        bitField0_ = (bitField0_ & ~0x00000200);
        multiDeployVertex_ = null;
        if (multiDeployVertexBuilder_ != null) {
          multiDeployVertexBuilder_.dispose();
          multiDeployVertexBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Multiple setups to deploy the PublisherModel to Vertex
       * Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex multi_deploy_vertex = 16 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex.Builder
          getMultiDeployVertexBuilder() {
        bitField0_ |= 0x00000200;
        onChanged();
        return getMultiDeployVertexFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Multiple setups to deploy the PublisherModel to Vertex
       * Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex multi_deploy_vertex = 16 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertexOrBuilder
          getMultiDeployVertexOrBuilder() {
        if (multiDeployVertexBuilder_ != null) {
          return multiDeployVertexBuilder_.getMessageOrBuilder();
        } else {
          return multiDeployVertex_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
                  .getDefaultInstance()
              : multiDeployVertex_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Multiple setups to deploy the PublisherModel to Vertex
       * Endpoint.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex multi_deploy_vertex = 16 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertexOrBuilder>
          getMultiDeployVertexFieldBuilder() {
        if (multiDeployVertexBuilder_ == null) {
          multiDeployVertexBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployVertex
                      .Builder,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .DeployVertexOrBuilder>(
                  getMultiDeployVertex(), getParentForChildren(), isClean());
          multiDeployVertex_ = null;
        }
        return multiDeployVertexBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deployGke_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGkeOrBuilder>
          deployGkeBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Deploy PublisherModel to Google Kubernetes Engine.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deploy_gke = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the deployGke field is set.
       */
      public boolean hasDeployGke() {
        return ((bitField0_ & 0x00000400) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy PublisherModel to Google Kubernetes Engine.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deploy_gke = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The deployGke.
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
          getDeployGke() {
        if (deployGkeBuilder_ == null) {
          return deployGke_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
                  .getDefaultInstance()
              : deployGke_;
        } else {
          return deployGkeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy PublisherModel to Google Kubernetes Engine.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deploy_gke = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDeployGke(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke value) {
        if (deployGkeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          deployGke_ = value;
        } else {
          deployGkeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy PublisherModel to Google Kubernetes Engine.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deploy_gke = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDeployGke(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke.Builder
              builderForValue) {
        if (deployGkeBuilder_ == null) {
          deployGke_ = builderForValue.build();
        } else {
          deployGkeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy PublisherModel to Google Kubernetes Engine.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deploy_gke = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeDeployGke(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke value) {
        if (deployGkeBuilder_ == null) {
          if (((bitField0_ & 0x00000400) != 0)
              && deployGke_ != null
              && deployGke_
                  != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
                      .getDefaultInstance()) {
            getDeployGkeBuilder().mergeFrom(value);
          } else {
            deployGke_ = value;
          }
        } else {
          deployGkeBuilder_.mergeFrom(value);
        }
        if (deployGke_ != null) {
          bitField0_ |= 0x00000400;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy PublisherModel to Google Kubernetes Engine.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deploy_gke = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearDeployGke() {
        bitField0_ = (bitField0_ & ~0x00000400);
        deployGke_ = null;
        if (deployGkeBuilder_ != null) {
          deployGkeBuilder_.dispose();
          deployGkeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy PublisherModel to Google Kubernetes Engine.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deploy_gke = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke.Builder
          getDeployGkeBuilder() {
        bitField0_ |= 0x00000400;
        onChanged();
        return getDeployGkeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy PublisherModel to Google Kubernetes Engine.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deploy_gke = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGkeOrBuilder
          getDeployGkeOrBuilder() {
        if (deployGkeBuilder_ != null) {
          return deployGkeBuilder_.getMessageOrBuilder();
        } else {
          return deployGke_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke
                  .getDefaultInstance()
              : deployGke_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Deploy PublisherModel to Google Kubernetes Engine.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke deploy_gke = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGkeOrBuilder>
          getDeployGkeFieldBuilder() {
        if (deployGkeBuilder_ == null) {
          deployGkeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.DeployGke.Builder,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .DeployGkeOrBuilder>(getDeployGke(), getParentForChildren(), isClean());
          deployGke_ = null;
        }
        return deployGkeBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          openGenerationAiStudio_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          openGenerationAiStudioBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the openGenerationAiStudio field is set.
       */
      public boolean hasOpenGenerationAiStudio() {
        return ((bitField0_ & 0x00000800) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The openGenerationAiStudio.
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          getOpenGenerationAiStudio() {
        if (openGenerationAiStudioBuilder_ == null) {
          return openGenerationAiStudio_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openGenerationAiStudio_;
        } else {
          return openGenerationAiStudioBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenGenerationAiStudio(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openGenerationAiStudioBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          openGenerationAiStudio_ = value;
        } else {
          openGenerationAiStudioBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenGenerationAiStudio(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder
              builderForValue) {
        if (openGenerationAiStudioBuilder_ == null) {
          openGenerationAiStudio_ = builderForValue.build();
        } else {
          openGenerationAiStudioBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOpenGenerationAiStudio(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openGenerationAiStudioBuilder_ == null) {
          if (((bitField0_ & 0x00000800) != 0)
              && openGenerationAiStudio_ != null
              && openGenerationAiStudio_
                  != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance()) {
            getOpenGenerationAiStudioBuilder().mergeFrom(value);
          } else {
            openGenerationAiStudio_ = value;
          }
        } else {
          openGenerationAiStudioBuilder_.mergeFrom(value);
        }
        if (openGenerationAiStudio_ != null) {
          bitField0_ |= 0x00000800;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOpenGenerationAiStudio() {
        bitField0_ = (bitField0_ & ~0x00000800);
        openGenerationAiStudio_ = null;
        if (openGenerationAiStudioBuilder_ != null) {
          openGenerationAiStudioBuilder_.dispose();
          openGenerationAiStudioBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.Builder
          getOpenGenerationAiStudioBuilder() {
        bitField0_ |= 0x00000800;
        onChanged();
        return getOpenGenerationAiStudioFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getOpenGenerationAiStudioOrBuilder() {
        if (openGenerationAiStudioBuilder_ != null) {
          return openGenerationAiStudioBuilder_.getMessageOrBuilder();
        } else {
          return openGenerationAiStudio_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openGenerationAiStudio_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open in Generation AI Studio.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_generation_ai_studio = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          getOpenGenerationAiStudioFieldBuilder() {
        if (openGenerationAiStudioBuilder_ == null) {
          openGenerationAiStudioBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>(
                  getOpenGenerationAiStudio(), getParentForChildren(), isClean());
          openGenerationAiStudio_ = null;
        }
        return openGenerationAiStudioBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          requestAccess_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          requestAccessBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the requestAccess field is set.
       */
      public boolean hasRequestAccess() {
        return ((bitField0_ & 0x00001000) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The requestAccess.
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          getRequestAccess() {
        if (requestAccessBuilder_ == null) {
          return requestAccess_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : requestAccess_;
        } else {
          return requestAccessBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRequestAccess(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (requestAccessBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          requestAccess_ = value;
        } else {
          requestAccessBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00001000;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRequestAccess(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder
              builderForValue) {
        if (requestAccessBuilder_ == null) {
          requestAccess_ = builderForValue.build();
        } else {
          requestAccessBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00001000;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeRequestAccess(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (requestAccessBuilder_ == null) {
          if (((bitField0_ & 0x00001000) != 0)
              && requestAccess_ != null
              && requestAccess_
                  != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance()) {
            getRequestAccessBuilder().mergeFrom(value);
          } else {
            requestAccess_ = value;
          }
        } else {
          requestAccessBuilder_.mergeFrom(value);
        }
        if (requestAccess_ != null) {
          bitField0_ |= 0x00001000;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearRequestAccess() {
        bitField0_ = (bitField0_ & ~0x00001000);
        requestAccess_ = null;
        if (requestAccessBuilder_ != null) {
          requestAccessBuilder_.dispose();
          requestAccessBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.Builder
          getRequestAccessBuilder() {
        bitField0_ |= 0x00001000;
        onChanged();
        return getRequestAccessFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getRequestAccessOrBuilder() {
        if (requestAccessBuilder_ != null) {
          return requestAccessBuilder_.getMessageOrBuilder();
        } else {
          return requestAccess_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : requestAccess_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Request for access.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences request_access = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          getRequestAccessFieldBuilder() {
        if (requestAccessBuilder_ == null) {
          requestAccessBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>(
                  getRequestAccess(), getParentForChildren(), isClean());
          requestAccess_ = null;
        }
        return requestAccessBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          openEvaluationPipeline_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          openEvaluationPipelineBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Open evaluation pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_evaluation_pipeline = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the openEvaluationPipeline field is set.
       */
      public boolean hasOpenEvaluationPipeline() {
        return ((bitField0_ & 0x00002000) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Open evaluation pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_evaluation_pipeline = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The openEvaluationPipeline.
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences
          getOpenEvaluationPipeline() {
        if (openEvaluationPipelineBuilder_ == null) {
          return openEvaluationPipeline_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openEvaluationPipeline_;
        } else {
          return openEvaluationPipelineBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open evaluation pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_evaluation_pipeline = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenEvaluationPipeline(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openEvaluationPipelineBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          openEvaluationPipeline_ = value;
        } else {
          openEvaluationPipelineBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00002000;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open evaluation pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_evaluation_pipeline = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOpenEvaluationPipeline(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
                  .Builder
              builderForValue) {
        if (openEvaluationPipelineBuilder_ == null) {
          openEvaluationPipeline_ = builderForValue.build();
        } else {
          openEvaluationPipelineBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00002000;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open evaluation pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_evaluation_pipeline = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOpenEvaluationPipeline(
          com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences
              value) {
        if (openEvaluationPipelineBuilder_ == null) {
          if (((bitField0_ & 0x00002000) != 0)
              && openEvaluationPipeline_ != null
              && openEvaluationPipeline_
                  != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.getDefaultInstance()) {
            getOpenEvaluationPipelineBuilder().mergeFrom(value);
          } else {
            openEvaluationPipeline_ = value;
          }
        } else {
          openEvaluationPipelineBuilder_.mergeFrom(value);
        }
        if (openEvaluationPipeline_ != null) {
          bitField0_ |= 0x00002000;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open evaluation pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_evaluation_pipeline = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOpenEvaluationPipeline() {
        bitField0_ = (bitField0_ & ~0x00002000);
        openEvaluationPipeline_ = null;
        if (openEvaluationPipelineBuilder_ != null) {
          openEvaluationPipelineBuilder_.dispose();
          openEvaluationPipelineBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Open evaluation pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_evaluation_pipeline = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferences.Builder
          getOpenEvaluationPipelineBuilder() {
        bitField0_ |= 0x00002000;
        onChanged();
        return getOpenEvaluationPipelineFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Open evaluation pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_evaluation_pipeline = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
              .RegionalResourceReferencesOrBuilder
          getOpenEvaluationPipelineOrBuilder() {
        if (openEvaluationPipelineBuilder_ != null) {
          return openEvaluationPipelineBuilder_.getMessageOrBuilder();
        } else {
          return openEvaluationPipeline_ == null
              ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.getDefaultInstance()
              : openEvaluationPipeline_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Open evaluation pipeline of the PublisherModel.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.RegionalResourceReferences open_evaluation_pipeline = 11 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferences.Builder,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                  .RegionalResourceReferencesOrBuilder>
          getOpenEvaluationPipelineFieldBuilder() {
        if (openEvaluationPipelineBuilder_ == null) {
          openEvaluationPipelineBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferences.Builder,
                  com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                      .RegionalResourceReferencesOrBuilder>(
                  getOpenEvaluationPipeline(), getParentForChildren(), isClean());
          openEvaluationPipeline_ = null;
        }
        return openEvaluationPipelineBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction)
    private static final com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction();
    }

    public static com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CallToAction> PARSER =
        new com.google.protobuf.AbstractParser<CallToAction>() {
          @java.lang.Override
          public CallToAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CallToAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CallToAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the PublisherModel.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the PublisherModel.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object versionId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The version ID of the PublisherModel.
   * A new version is committed when a new model version is uploaded under an
   * existing model id. It is an auto-incrementing decimal number in string
   * representation.
   * </pre>
   *
   * <code>
   * string version_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The versionId.
   */
  @java.lang.Override
  public java.lang.String getVersionId() {
    java.lang.Object ref = versionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      versionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The version ID of the PublisherModel.
   * A new version is committed when a new model version is uploaded under an
   * existing model id. It is an auto-incrementing decimal number in string
   * representation.
   * </pre>
   *
   * <code>
   * string version_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for versionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionIdBytes() {
    java.lang.Object ref = versionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      versionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPEN_SOURCE_CATEGORY_FIELD_NUMBER = 7;
  private int openSourceCategory_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Indicates the open source category of the publisher model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory open_source_category = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for openSourceCategory.
   */
  @java.lang.Override
  public int getOpenSourceCategoryValue() {
    return openSourceCategory_;
  }
  /**
   *
   *
   * <pre>
   * Required. Indicates the open source category of the publisher model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory open_source_category = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The openSourceCategory.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory
      getOpenSourceCategory() {
    com.google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory result =
        com.google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory.forNumber(
            openSourceCategory_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory.UNRECOGNIZED
        : result;
  }

  public static final int PARENT_FIELD_NUMBER = 14;
  private com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent parent_;
  /**
   *
   *
   * <pre>
   * Optional. The parent that this model was customized from. E.g., Vision API,
   * Natural Language API, LaMDA, T5, etc. Foundation models don't have parents.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PublisherModel.Parent parent = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the parent field is set.
   */
  @java.lang.Override
  public boolean hasParent() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The parent that this model was customized from. E.g., Vision API,
   * Natural Language API, LaMDA, T5, etc. Foundation models don't have parents.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PublisherModel.Parent parent = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent getParent() {
    return parent_ == null
        ? com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.getDefaultInstance()
        : parent_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The parent that this model was customized from. E.g., Vision API,
   * Natural Language API, LaMDA, T5, etc. Foundation models don't have parents.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PublisherModel.Parent parent = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PublisherModel.ParentOrBuilder getParentOrBuilder() {
    return parent_ == null
        ? com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.getDefaultInstance()
        : parent_;
  }

  public static final int SUPPORTED_ACTIONS_FIELD_NUMBER = 19;
  private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction supportedActions_;
  /**
   *
   *
   * <pre>
   * Optional. Supported call-to-action options.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the supportedActions field is set.
   */
  @java.lang.Override
  public boolean hasSupportedActions() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Supported call-to-action options.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The supportedActions.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction getSupportedActions() {
    return supportedActions_ == null
        ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.getDefaultInstance()
        : supportedActions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Supported call-to-action options.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToActionOrBuilder
      getSupportedActionsOrBuilder() {
    return supportedActions_ == null
        ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.getDefaultInstance()
        : supportedActions_;
  }

  public static final int FRAMEWORKS_FIELD_NUMBER = 23;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList frameworks_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Additional information about the model's Frameworks.
   * </pre>
   *
   * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the frameworks.
   */
  public com.google.protobuf.ProtocolStringList getFrameworksList() {
    return frameworks_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional information about the model's Frameworks.
   * </pre>
   *
   * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of frameworks.
   */
  public int getFrameworksCount() {
    return frameworks_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional information about the model's Frameworks.
   * </pre>
   *
   * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The frameworks at the given index.
   */
  public java.lang.String getFrameworks(int index) {
    return frameworks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional information about the model's Frameworks.
   * </pre>
   *
   * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the frameworks at the given index.
   */
  public com.google.protobuf.ByteString getFrameworksBytes(int index) {
    return frameworks_.getByteString(index);
  }

  public static final int LAUNCH_STAGE_FIELD_NUMBER = 29;
  private int launchStage_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Indicates the launch stage of the model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage launch_stage = 29 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for launchStage.
   */
  @java.lang.Override
  public int getLaunchStageValue() {
    return launchStage_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Indicates the launch stage of the model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage launch_stage = 29 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The launchStage.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage getLaunchStage() {
    com.google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage result =
        com.google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage.forNumber(launchStage_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage.UNRECOGNIZED
        : result;
  }

  public static final int VERSION_STATE_FIELD_NUMBER = 37;
  private int versionState_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Indicates the state of the model version.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PublisherModel.VersionState version_state = 37 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for versionState.
   */
  @java.lang.Override
  public int getVersionStateValue() {
    return versionState_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Indicates the state of the model version.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PublisherModel.VersionState version_state = 37 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The versionState.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PublisherModel.VersionState getVersionState() {
    com.google.cloud.aiplatform.v1beta1.PublisherModel.VersionState result =
        com.google.cloud.aiplatform.v1beta1.PublisherModel.VersionState.forNumber(versionState_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.PublisherModel.VersionState.UNRECOGNIZED
        : result;
  }

  public static final int PUBLISHER_MODEL_TEMPLATE_FIELD_NUMBER = 30;

  @SuppressWarnings("serial")
  private volatile java.lang.Object publisherModelTemplate_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Output only. Immutable. Used to indicate this model has a
   * publisher model and provide the template of the publisher model resource
   * name.
   * </pre>
   *
   * <code>
   * string publisher_model_template = 30 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The publisherModelTemplate.
   */
  @java.lang.Override
  public java.lang.String getPublisherModelTemplate() {
    java.lang.Object ref = publisherModelTemplate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      publisherModelTemplate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Output only. Immutable. Used to indicate this model has a
   * publisher model and provide the template of the publisher model resource
   * name.
   * </pre>
   *
   * <code>
   * string publisher_model_template = 30 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for publisherModelTemplate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPublisherModelTemplateBytes() {
    java.lang.Object ref = publisherModelTemplate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      publisherModelTemplate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREDICT_SCHEMATA_FIELD_NUMBER = 31;
  private com.google.cloud.aiplatform.v1beta1.PredictSchemata predictSchemata_;
  /**
   *
   *
   * <pre>
   * Optional. The schemata that describes formats of the PublisherModel's
   * predictions and explanations as given and returned via
   * [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the predictSchemata field is set.
   */
  @java.lang.Override
  public boolean hasPredictSchemata() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The schemata that describes formats of the PublisherModel's
   * predictions and explanations as given and returned via
   * [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The predictSchemata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PredictSchemata getPredictSchemata() {
    return predictSchemata_ == null
        ? com.google.cloud.aiplatform.v1beta1.PredictSchemata.getDefaultInstance()
        : predictSchemata_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The schemata that describes formats of the PublisherModel's
   * predictions and explanations as given and returned via
   * [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PredictSchemataOrBuilder
      getPredictSchemataOrBuilder() {
    return predictSchemata_ == null
        ? com.google.cloud.aiplatform.v1beta1.PredictSchemata.getDefaultInstance()
        : predictSchemata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, versionId_);
    }
    if (openSourceCategory_
        != com.google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory
            .OPEN_SOURCE_CATEGORY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, openSourceCategory_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(14, getParent());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(19, getSupportedActions());
    }
    for (int i = 0; i < frameworks_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 23, frameworks_.getRaw(i));
    }
    if (launchStage_
        != com.google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage.LAUNCH_STAGE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(29, launchStage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publisherModelTemplate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30, publisherModelTemplate_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(31, getPredictSchemata());
    }
    if (versionState_
        != com.google.cloud.aiplatform.v1beta1.PublisherModel.VersionState.VERSION_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(37, versionState_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, versionId_);
    }
    if (openSourceCategory_
        != com.google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory
            .OPEN_SOURCE_CATEGORY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, openSourceCategory_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getParent());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, getSupportedActions());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < frameworks_.size(); i++) {
        dataSize += computeStringSizeNoTag(frameworks_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getFrameworksList().size();
    }
    if (launchStage_
        != com.google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage.LAUNCH_STAGE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(29, launchStage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publisherModelTemplate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(30, publisherModelTemplate_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(31, getPredictSchemata());
    }
    if (versionState_
        != com.google.cloud.aiplatform.v1beta1.PublisherModel.VersionState.VERSION_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(37, versionState_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PublisherModel)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.PublisherModel other =
        (com.google.cloud.aiplatform.v1beta1.PublisherModel) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getVersionId().equals(other.getVersionId())) return false;
    if (openSourceCategory_ != other.openSourceCategory_) return false;
    if (hasParent() != other.hasParent()) return false;
    if (hasParent()) {
      if (!getParent().equals(other.getParent())) return false;
    }
    if (hasSupportedActions() != other.hasSupportedActions()) return false;
    if (hasSupportedActions()) {
      if (!getSupportedActions().equals(other.getSupportedActions())) return false;
    }
    if (!getFrameworksList().equals(other.getFrameworksList())) return false;
    if (launchStage_ != other.launchStage_) return false;
    if (versionState_ != other.versionState_) return false;
    if (!getPublisherModelTemplate().equals(other.getPublisherModelTemplate())) return false;
    if (hasPredictSchemata() != other.hasPredictSchemata()) return false;
    if (hasPredictSchemata()) {
      if (!getPredictSchemata().equals(other.getPredictSchemata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + VERSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getVersionId().hashCode();
    hash = (37 * hash) + OPEN_SOURCE_CATEGORY_FIELD_NUMBER;
    hash = (53 * hash) + openSourceCategory_;
    if (hasParent()) {
      hash = (37 * hash) + PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getParent().hashCode();
    }
    if (hasSupportedActions()) {
      hash = (37 * hash) + SUPPORTED_ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSupportedActions().hashCode();
    }
    if (getFrameworksCount() > 0) {
      hash = (37 * hash) + FRAMEWORKS_FIELD_NUMBER;
      hash = (53 * hash) + getFrameworksList().hashCode();
    }
    hash = (37 * hash) + LAUNCH_STAGE_FIELD_NUMBER;
    hash = (53 * hash) + launchStage_;
    hash = (37 * hash) + VERSION_STATE_FIELD_NUMBER;
    hash = (53 * hash) + versionState_;
    hash = (37 * hash) + PUBLISHER_MODEL_TEMPLATE_FIELD_NUMBER;
    hash = (53 * hash) + getPublisherModelTemplate().hashCode();
    if (hasPredictSchemata()) {
      hash = (37 * hash) + PREDICT_SCHEMATA_FIELD_NUMBER;
      hash = (53 * hash) + getPredictSchemata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.PublisherModel parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PublisherModel parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PublisherModel parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PublisherModel parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PublisherModel parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PublisherModel parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PublisherModel parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PublisherModel parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PublisherModel parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PublisherModel parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PublisherModel parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PublisherModel parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.PublisherModel prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Model Garden Publisher Model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PublisherModel}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PublisherModel)
      com.google.cloud.aiplatform.v1beta1.PublisherModelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PublisherModel.class,
              com.google.cloud.aiplatform.v1beta1.PublisherModel.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.PublisherModel.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getParentFieldBuilder();
        getSupportedActionsFieldBuilder();
        getPredictSchemataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      versionId_ = "";
      openSourceCategory_ = 0;
      parent_ = null;
      if (parentBuilder_ != null) {
        parentBuilder_.dispose();
        parentBuilder_ = null;
      }
      supportedActions_ = null;
      if (supportedActionsBuilder_ != null) {
        supportedActionsBuilder_.dispose();
        supportedActionsBuilder_ = null;
      }
      frameworks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      launchStage_ = 0;
      versionState_ = 0;
      publisherModelTemplate_ = "";
      predictSchemata_ = null;
      if (predictSchemataBuilder_ != null) {
        predictSchemataBuilder_.dispose();
        predictSchemataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.PublisherModelProto
          .internal_static_google_cloud_aiplatform_v1beta1_PublisherModel_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.PublisherModel.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel build() {
      com.google.cloud.aiplatform.v1beta1.PublisherModel result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel buildPartial() {
      com.google.cloud.aiplatform.v1beta1.PublisherModel result =
          new com.google.cloud.aiplatform.v1beta1.PublisherModel(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.PublisherModel result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.versionId_ = versionId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.openSourceCategory_ = openSourceCategory_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.parent_ = parentBuilder_ == null ? parent_ : parentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.supportedActions_ =
            supportedActionsBuilder_ == null ? supportedActions_ : supportedActionsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        frameworks_.makeImmutable();
        result.frameworks_ = frameworks_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.launchStage_ = launchStage_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.versionState_ = versionState_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.publisherModelTemplate_ = publisherModelTemplate_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.predictSchemata_ =
            predictSchemataBuilder_ == null ? predictSchemata_ : predictSchemataBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.PublisherModel) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.PublisherModel) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.PublisherModel other) {
      if (other == com.google.cloud.aiplatform.v1beta1.PublisherModel.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getVersionId().isEmpty()) {
        versionId_ = other.versionId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.openSourceCategory_ != 0) {
        setOpenSourceCategoryValue(other.getOpenSourceCategoryValue());
      }
      if (other.hasParent()) {
        mergeParent(other.getParent());
      }
      if (other.hasSupportedActions()) {
        mergeSupportedActions(other.getSupportedActions());
      }
      if (!other.frameworks_.isEmpty()) {
        if (frameworks_.isEmpty()) {
          frameworks_ = other.frameworks_;
          bitField0_ |= 0x00000020;
        } else {
          ensureFrameworksIsMutable();
          frameworks_.addAll(other.frameworks_);
        }
        onChanged();
      }
      if (other.launchStage_ != 0) {
        setLaunchStageValue(other.getLaunchStageValue());
      }
      if (other.versionState_ != 0) {
        setVersionStateValue(other.getVersionStateValue());
      }
      if (!other.getPublisherModelTemplate().isEmpty()) {
        publisherModelTemplate_ = other.publisherModelTemplate_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasPredictSchemata()) {
        mergePredictSchemata(other.getPredictSchemata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                versionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 56:
              {
                openSourceCategory_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 56
            case 114:
              {
                input.readMessage(getParentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 114
            case 154:
              {
                input.readMessage(
                    getSupportedActionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 154
            case 186:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureFrameworksIsMutable();
                frameworks_.add(s);
                break;
              } // case 186
            case 232:
              {
                launchStage_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 232
            case 242:
              {
                publisherModelTemplate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 242
            case 250:
              {
                input.readMessage(getPredictSchemataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 250
            case 296:
              {
                versionState_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 296
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PublisherModel.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PublisherModel.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PublisherModel.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PublisherModel.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the PublisherModel.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object versionId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The version ID of the PublisherModel.
     * A new version is committed when a new model version is uploaded under an
     * existing model id. It is an auto-incrementing decimal number in string
     * representation.
     * </pre>
     *
     * <code>
     * string version_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The versionId.
     */
    public java.lang.String getVersionId() {
      java.lang.Object ref = versionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        versionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The version ID of the PublisherModel.
     * A new version is committed when a new model version is uploaded under an
     * existing model id. It is an auto-incrementing decimal number in string
     * representation.
     * </pre>
     *
     * <code>
     * string version_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for versionId.
     */
    public com.google.protobuf.ByteString getVersionIdBytes() {
      java.lang.Object ref = versionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        versionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The version ID of the PublisherModel.
     * A new version is committed when a new model version is uploaded under an
     * existing model id. It is an auto-incrementing decimal number in string
     * representation.
     * </pre>
     *
     * <code>
     * string version_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The versionId to set.
     * @return This builder for chaining.
     */
    public Builder setVersionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      versionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The version ID of the PublisherModel.
     * A new version is committed when a new model version is uploaded under an
     * existing model id. It is an auto-incrementing decimal number in string
     * representation.
     * </pre>
     *
     * <code>
     * string version_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionId() {
      versionId_ = getDefaultInstance().getVersionId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The version ID of the PublisherModel.
     * A new version is committed when a new model version is uploaded under an
     * existing model id. It is an auto-incrementing decimal number in string
     * representation.
     * </pre>
     *
     * <code>
     * string version_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for versionId to set.
     * @return This builder for chaining.
     */
    public Builder setVersionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      versionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int openSourceCategory_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Indicates the open source category of the publisher model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory open_source_category = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for openSourceCategory.
     */
    @java.lang.Override
    public int getOpenSourceCategoryValue() {
      return openSourceCategory_;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the open source category of the publisher model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory open_source_category = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for openSourceCategory to set.
     * @return This builder for chaining.
     */
    public Builder setOpenSourceCategoryValue(int value) {
      openSourceCategory_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the open source category of the publisher model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory open_source_category = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The openSourceCategory.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory
        getOpenSourceCategory() {
      com.google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory result =
          com.google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory.forNumber(
              openSourceCategory_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the open source category of the publisher model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory open_source_category = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The openSourceCategory to set.
     * @return This builder for chaining.
     */
    public Builder setOpenSourceCategory(
        com.google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      openSourceCategory_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the open source category of the publisher model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.OpenSourceCategory open_source_category = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOpenSourceCategory() {
      bitField0_ = (bitField0_ & ~0x00000004);
      openSourceCategory_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent parent_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.Builder,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.ParentOrBuilder>
        parentBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The parent that this model was customized from. E.g., Vision API,
     * Natural Language API, LaMDA, T5, etc. Foundation models don't have parents.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.Parent parent = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the parent field is set.
     */
    public boolean hasParent() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The parent that this model was customized from. E.g., Vision API,
     * Natural Language API, LaMDA, T5, etc. Foundation models don't have parents.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.Parent parent = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The parent.
     */
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent getParent() {
      if (parentBuilder_ == null) {
        return parent_ == null
            ? com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.getDefaultInstance()
            : parent_;
      } else {
        return parentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The parent that this model was customized from. E.g., Vision API,
     * Natural Language API, LaMDA, T5, etc. Foundation models don't have parents.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.Parent parent = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setParent(com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent value) {
      if (parentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parent_ = value;
      } else {
        parentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The parent that this model was customized from. E.g., Vision API,
     * Natural Language API, LaMDA, T5, etc. Foundation models don't have parents.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.Parent parent = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setParent(
        com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.Builder builderForValue) {
      if (parentBuilder_ == null) {
        parent_ = builderForValue.build();
      } else {
        parentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The parent that this model was customized from. E.g., Vision API,
     * Natural Language API, LaMDA, T5, etc. Foundation models don't have parents.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.Parent parent = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeParent(com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent value) {
      if (parentBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && parent_ != null
            && parent_
                != com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.getDefaultInstance()) {
          getParentBuilder().mergeFrom(value);
        } else {
          parent_ = value;
        }
      } else {
        parentBuilder_.mergeFrom(value);
      }
      if (parent_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The parent that this model was customized from. E.g., Vision API,
     * Natural Language API, LaMDA, T5, etc. Foundation models don't have parents.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.Parent parent = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearParent() {
      bitField0_ = (bitField0_ & ~0x00000008);
      parent_ = null;
      if (parentBuilder_ != null) {
        parentBuilder_.dispose();
        parentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The parent that this model was customized from. E.g., Vision API,
     * Natural Language API, LaMDA, T5, etc. Foundation models don't have parents.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.Parent parent = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.Builder getParentBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getParentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The parent that this model was customized from. E.g., Vision API,
     * Natural Language API, LaMDA, T5, etc. Foundation models don't have parents.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.Parent parent = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.ParentOrBuilder getParentOrBuilder() {
      if (parentBuilder_ != null) {
        return parentBuilder_.getMessageOrBuilder();
      } else {
        return parent_ == null
            ? com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.getDefaultInstance()
            : parent_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The parent that this model was customized from. E.g., Vision API,
     * Natural Language API, LaMDA, T5, etc. Foundation models don't have parents.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.Parent parent = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.Builder,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.ParentOrBuilder>
        getParentFieldBuilder() {
      if (parentBuilder_ == null) {
        parentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.Parent.Builder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.ParentOrBuilder>(
                getParent(), getParentForChildren(), isClean());
        parent_ = null;
      }
      return parentBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction supportedActions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Builder,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToActionOrBuilder>
        supportedActionsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the supportedActions field is set.
     */
    public boolean hasSupportedActions() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The supportedActions.
     */
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction getSupportedActions() {
      if (supportedActionsBuilder_ == null) {
        return supportedActions_ == null
            ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.getDefaultInstance()
            : supportedActions_;
      } else {
        return supportedActionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSupportedActions(
        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction value) {
      if (supportedActionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        supportedActions_ = value;
      } else {
        supportedActionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSupportedActions(
        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Builder builderForValue) {
      if (supportedActionsBuilder_ == null) {
        supportedActions_ = builderForValue.build();
      } else {
        supportedActionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSupportedActions(
        com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction value) {
      if (supportedActionsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && supportedActions_ != null
            && supportedActions_
                != com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction
                    .getDefaultInstance()) {
          getSupportedActionsBuilder().mergeFrom(value);
        } else {
          supportedActions_ = value;
        }
      } else {
        supportedActionsBuilder_.mergeFrom(value);
      }
      if (supportedActions_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSupportedActions() {
      bitField0_ = (bitField0_ & ~0x00000010);
      supportedActions_ = null;
      if (supportedActionsBuilder_ != null) {
        supportedActionsBuilder_.dispose();
        supportedActionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Builder
        getSupportedActionsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getSupportedActionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToActionOrBuilder
        getSupportedActionsOrBuilder() {
      if (supportedActionsBuilder_ != null) {
        return supportedActionsBuilder_.getMessageOrBuilder();
      } else {
        return supportedActions_ == null
            ? com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.getDefaultInstance()
            : supportedActions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Supported call-to-action options.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction supported_actions = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Builder,
            com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToActionOrBuilder>
        getSupportedActionsFieldBuilder() {
      if (supportedActionsBuilder_ == null) {
        supportedActionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToAction.Builder,
                com.google.cloud.aiplatform.v1beta1.PublisherModel.CallToActionOrBuilder>(
                getSupportedActions(), getParentForChildren(), isClean());
        supportedActions_ = null;
      }
      return supportedActionsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList frameworks_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureFrameworksIsMutable() {
      if (!frameworks_.isModifiable()) {
        frameworks_ = new com.google.protobuf.LazyStringArrayList(frameworks_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the frameworks.
     */
    public com.google.protobuf.ProtocolStringList getFrameworksList() {
      frameworks_.makeImmutable();
      return frameworks_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of frameworks.
     */
    public int getFrameworksCount() {
      return frameworks_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The frameworks at the given index.
     */
    public java.lang.String getFrameworks(int index) {
      return frameworks_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the frameworks at the given index.
     */
    public com.google.protobuf.ByteString getFrameworksBytes(int index) {
      return frameworks_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The frameworks to set.
     * @return This builder for chaining.
     */
    public Builder setFrameworks(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFrameworksIsMutable();
      frameworks_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The frameworks to add.
     * @return This builder for chaining.
     */
    public Builder addFrameworks(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFrameworksIsMutable();
      frameworks_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The frameworks to add.
     * @return This builder for chaining.
     */
    public Builder addAllFrameworks(java.lang.Iterable<java.lang.String> values) {
      ensureFrameworksIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, frameworks_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFrameworks() {
      frameworks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional information about the model's Frameworks.
     * </pre>
     *
     * <code>repeated string frameworks = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the frameworks to add.
     * @return This builder for chaining.
     */
    public Builder addFrameworksBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFrameworksIsMutable();
      frameworks_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int launchStage_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Indicates the launch stage of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage launch_stage = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for launchStage.
     */
    @java.lang.Override
    public int getLaunchStageValue() {
      return launchStage_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the launch stage of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage launch_stage = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStageValue(int value) {
      launchStage_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the launch stage of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage launch_stage = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The launchStage.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage getLaunchStage() {
      com.google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage result =
          com.google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage.forNumber(launchStage_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the launch stage of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage launch_stage = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStage(
        com.google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      launchStage_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the launch stage of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.LaunchStage launch_stage = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLaunchStage() {
      bitField0_ = (bitField0_ & ~0x00000040);
      launchStage_ = 0;
      onChanged();
      return this;
    }

    private int versionState_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Indicates the state of the model version.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.VersionState version_state = 37 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for versionState.
     */
    @java.lang.Override
    public int getVersionStateValue() {
      return versionState_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the state of the model version.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.VersionState version_state = 37 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for versionState to set.
     * @return This builder for chaining.
     */
    public Builder setVersionStateValue(int value) {
      versionState_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the state of the model version.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.VersionState version_state = 37 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The versionState.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PublisherModel.VersionState getVersionState() {
      com.google.cloud.aiplatform.v1beta1.PublisherModel.VersionState result =
          com.google.cloud.aiplatform.v1beta1.PublisherModel.VersionState.forNumber(versionState_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.PublisherModel.VersionState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the state of the model version.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.VersionState version_state = 37 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The versionState to set.
     * @return This builder for chaining.
     */
    public Builder setVersionState(
        com.google.cloud.aiplatform.v1beta1.PublisherModel.VersionState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      versionState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the state of the model version.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PublisherModel.VersionState version_state = 37 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      versionState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object publisherModelTemplate_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Output only. Immutable. Used to indicate this model has a
     * publisher model and provide the template of the publisher model resource
     * name.
     * </pre>
     *
     * <code>
     * string publisher_model_template = 30 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The publisherModelTemplate.
     */
    public java.lang.String getPublisherModelTemplate() {
      java.lang.Object ref = publisherModelTemplate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        publisherModelTemplate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Immutable. Used to indicate this model has a
     * publisher model and provide the template of the publisher model resource
     * name.
     * </pre>
     *
     * <code>
     * string publisher_model_template = 30 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for publisherModelTemplate.
     */
    public com.google.protobuf.ByteString getPublisherModelTemplateBytes() {
      java.lang.Object ref = publisherModelTemplate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        publisherModelTemplate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Immutable. Used to indicate this model has a
     * publisher model and provide the template of the publisher model resource
     * name.
     * </pre>
     *
     * <code>
     * string publisher_model_template = 30 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The publisherModelTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setPublisherModelTemplate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      publisherModelTemplate_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Immutable. Used to indicate this model has a
     * publisher model and provide the template of the publisher model resource
     * name.
     * </pre>
     *
     * <code>
     * string publisher_model_template = 30 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPublisherModelTemplate() {
      publisherModelTemplate_ = getDefaultInstance().getPublisherModelTemplate();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. Immutable. Used to indicate this model has a
     * publisher model and provide the template of the publisher model resource
     * name.
     * </pre>
     *
     * <code>
     * string publisher_model_template = 30 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for publisherModelTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setPublisherModelTemplateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      publisherModelTemplate_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.PredictSchemata predictSchemata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PredictSchemata,
            com.google.cloud.aiplatform.v1beta1.PredictSchemata.Builder,
            com.google.cloud.aiplatform.v1beta1.PredictSchemataOrBuilder>
        predictSchemataBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the predictSchemata field is set.
     */
    public boolean hasPredictSchemata() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The predictSchemata.
     */
    public com.google.cloud.aiplatform.v1beta1.PredictSchemata getPredictSchemata() {
      if (predictSchemataBuilder_ == null) {
        return predictSchemata_ == null
            ? com.google.cloud.aiplatform.v1beta1.PredictSchemata.getDefaultInstance()
            : predictSchemata_;
      } else {
        return predictSchemataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPredictSchemata(com.google.cloud.aiplatform.v1beta1.PredictSchemata value) {
      if (predictSchemataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        predictSchemata_ = value;
      } else {
        predictSchemataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPredictSchemata(
        com.google.cloud.aiplatform.v1beta1.PredictSchemata.Builder builderForValue) {
      if (predictSchemataBuilder_ == null) {
        predictSchemata_ = builderForValue.build();
      } else {
        predictSchemataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePredictSchemata(com.google.cloud.aiplatform.v1beta1.PredictSchemata value) {
      if (predictSchemataBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && predictSchemata_ != null
            && predictSchemata_
                != com.google.cloud.aiplatform.v1beta1.PredictSchemata.getDefaultInstance()) {
          getPredictSchemataBuilder().mergeFrom(value);
        } else {
          predictSchemata_ = value;
        }
      } else {
        predictSchemataBuilder_.mergeFrom(value);
      }
      if (predictSchemata_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPredictSchemata() {
      bitField0_ = (bitField0_ & ~0x00000200);
      predictSchemata_ = null;
      if (predictSchemataBuilder_ != null) {
        predictSchemataBuilder_.dispose();
        predictSchemataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PredictSchemata.Builder getPredictSchemataBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getPredictSchemataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PredictSchemataOrBuilder
        getPredictSchemataOrBuilder() {
      if (predictSchemataBuilder_ != null) {
        return predictSchemataBuilder_.getMessageOrBuilder();
      } else {
        return predictSchemata_ == null
            ? com.google.cloud.aiplatform.v1beta1.PredictSchemata.getDefaultInstance()
            : predictSchemata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The schemata that describes formats of the PublisherModel's
     * predictions and explanations as given and returned via
     * [PredictionService.Predict][google.cloud.aiplatform.v1beta1.PredictionService.Predict].
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PredictSchemata predict_schemata = 31 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PredictSchemata,
            com.google.cloud.aiplatform.v1beta1.PredictSchemata.Builder,
            com.google.cloud.aiplatform.v1beta1.PredictSchemataOrBuilder>
        getPredictSchemataFieldBuilder() {
      if (predictSchemataBuilder_ == null) {
        predictSchemataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PredictSchemata,
                com.google.cloud.aiplatform.v1beta1.PredictSchemata.Builder,
                com.google.cloud.aiplatform.v1beta1.PredictSchemataOrBuilder>(
                getPredictSchemata(), getParentForChildren(), isClean());
        predictSchemata_ = null;
      }
      return predictSchemataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PublisherModel)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PublisherModel)
  private static final com.google.cloud.aiplatform.v1beta1.PublisherModel DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PublisherModel();
  }

  public static com.google.cloud.aiplatform.v1beta1.PublisherModel getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PublisherModel> PARSER =
      new com.google.protobuf.AbstractParser<PublisherModel>() {
        @java.lang.Override
        public PublisherModel parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PublisherModel> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PublisherModel> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PublisherModel getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
