/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_monitoring_job.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represent the execution details of the job.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail}
 */
public final class ModelMonitoringJobExecutionDetail extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail)
    ModelMonitoringJobExecutionDetailOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelMonitoringJobExecutionDetail.newBuilder() to construct.
  private ModelMonitoringJobExecutionDetail(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelMonitoringJobExecutionDetail() {
    baselineDatasets_ = java.util.Collections.emptyList();
    targetDatasets_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelMonitoringJobExecutionDetail();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJobExecutionDetail_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetObjectiveStatus();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJobExecutionDetail_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.class,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.Builder.class);
  }

  public interface ProcessedDatasetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Actual data location of the processed dataset.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    java.lang.String getLocation();
    /**
     *
     *
     * <pre>
     * Actual data location of the processed dataset.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    com.google.protobuf.ByteString getLocationBytes();

    /**
     *
     *
     * <pre>
     * Dataset time range information if any.
     * </pre>
     *
     * <code>.google.type.Interval time_range = 2;</code>
     *
     * @return Whether the timeRange field is set.
     */
    boolean hasTimeRange();
    /**
     *
     *
     * <pre>
     * Dataset time range information if any.
     * </pre>
     *
     * <code>.google.type.Interval time_range = 2;</code>
     *
     * @return The timeRange.
     */
    com.google.type.Interval getTimeRange();
    /**
     *
     *
     * <pre>
     * Dataset time range information if any.
     * </pre>
     *
     * <code>.google.type.Interval time_range = 2;</code>
     */
    com.google.type.IntervalOrBuilder getTimeRangeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Processed dataset information.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset}
   */
  public static final class ProcessedDataset extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset)
      ProcessedDatasetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ProcessedDataset.newBuilder() to construct.
    private ProcessedDataset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ProcessedDataset() {
      location_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ProcessedDataset();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJobExecutionDetail_ProcessedDataset_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJobExecutionDetail_ProcessedDataset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                  .class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                  .Builder.class);
    }

    private int bitField0_;
    public static final int LOCATION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * Actual data location of the processed dataset.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    @java.lang.Override
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Actual data location of the processed dataset.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TIME_RANGE_FIELD_NUMBER = 2;
    private com.google.type.Interval timeRange_;
    /**
     *
     *
     * <pre>
     * Dataset time range information if any.
     * </pre>
     *
     * <code>.google.type.Interval time_range = 2;</code>
     *
     * @return Whether the timeRange field is set.
     */
    @java.lang.Override
    public boolean hasTimeRange() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Dataset time range information if any.
     * </pre>
     *
     * <code>.google.type.Interval time_range = 2;</code>
     *
     * @return The timeRange.
     */
    @java.lang.Override
    public com.google.type.Interval getTimeRange() {
      return timeRange_ == null ? com.google.type.Interval.getDefaultInstance() : timeRange_;
    }
    /**
     *
     *
     * <pre>
     * Dataset time range information if any.
     * </pre>
     *
     * <code>.google.type.Interval time_range = 2;</code>
     */
    @java.lang.Override
    public com.google.type.IntervalOrBuilder getTimeRangeOrBuilder() {
      return timeRange_ == null ? com.google.type.Interval.getDefaultInstance() : timeRange_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getTimeRange());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTimeRange());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset other =
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset)
              obj;

      if (!getLocation().equals(other.getLocation())) return false;
      if (hasTimeRange() != other.hasTimeRange()) return false;
      if (hasTimeRange()) {
        if (!getTimeRange().equals(other.getTimeRange())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
      if (hasTimeRange()) {
        hash = (37 * hash) + TIME_RANGE_FIELD_NUMBER;
        hash = (53 * hash) + getTimeRange().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDataset
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDataset
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDataset
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDataset
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDataset
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDataset
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDataset
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDataset
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDataset
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDataset
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDataset
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDataset
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Processed dataset information.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset)
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDatasetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJobExecutionDetail_ProcessedDataset_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJobExecutionDetail_ProcessedDataset_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                    .ProcessedDataset.class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                    .ProcessedDataset.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getTimeRangeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        location_ = "";
        timeRange_ = null;
        if (timeRangeBuilder_ != null) {
          timeRangeBuilder_.dispose();
          timeRangeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJobExecutionDetail_ProcessedDataset_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDataset.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
          build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
            result =
                new com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                    .ProcessedDataset(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.location_ = location_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.timeRange_ = timeRangeBuilder_ == null ? timeRange_ : timeRangeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                .ProcessedDataset) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                      .ProcessedDataset)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                .ProcessedDataset.getDefaultInstance()) return this;
        if (!other.getLocation().isEmpty()) {
          location_ = other.location_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasTimeRange()) {
          mergeTimeRange(other.getTimeRange());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  location_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getTimeRangeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object location_ = "";
      /**
       *
       *
       * <pre>
       * Actual data location of the processed dataset.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The location.
       */
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Actual data location of the processed dataset.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The bytes for location.
       */
      public com.google.protobuf.ByteString getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Actual data location of the processed dataset.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The location to set.
       * @return This builder for chaining.
       */
      public Builder setLocation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Actual data location of the processed dataset.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocation() {
        location_ = getDefaultInstance().getLocation();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Actual data location of the processed dataset.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The bytes for location to set.
       * @return This builder for chaining.
       */
      public Builder setLocationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        location_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.type.Interval timeRange_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Interval,
              com.google.type.Interval.Builder,
              com.google.type.IntervalOrBuilder>
          timeRangeBuilder_;
      /**
       *
       *
       * <pre>
       * Dataset time range information if any.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 2;</code>
       *
       * @return Whether the timeRange field is set.
       */
      public boolean hasTimeRange() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Dataset time range information if any.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 2;</code>
       *
       * @return The timeRange.
       */
      public com.google.type.Interval getTimeRange() {
        if (timeRangeBuilder_ == null) {
          return timeRange_ == null ? com.google.type.Interval.getDefaultInstance() : timeRange_;
        } else {
          return timeRangeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Dataset time range information if any.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 2;</code>
       */
      public Builder setTimeRange(com.google.type.Interval value) {
        if (timeRangeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timeRange_ = value;
        } else {
          timeRangeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Dataset time range information if any.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 2;</code>
       */
      public Builder setTimeRange(com.google.type.Interval.Builder builderForValue) {
        if (timeRangeBuilder_ == null) {
          timeRange_ = builderForValue.build();
        } else {
          timeRangeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Dataset time range information if any.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 2;</code>
       */
      public Builder mergeTimeRange(com.google.type.Interval value) {
        if (timeRangeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && timeRange_ != null
              && timeRange_ != com.google.type.Interval.getDefaultInstance()) {
            getTimeRangeBuilder().mergeFrom(value);
          } else {
            timeRange_ = value;
          }
        } else {
          timeRangeBuilder_.mergeFrom(value);
        }
        if (timeRange_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Dataset time range information if any.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 2;</code>
       */
      public Builder clearTimeRange() {
        bitField0_ = (bitField0_ & ~0x00000002);
        timeRange_ = null;
        if (timeRangeBuilder_ != null) {
          timeRangeBuilder_.dispose();
          timeRangeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Dataset time range information if any.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 2;</code>
       */
      public com.google.type.Interval.Builder getTimeRangeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getTimeRangeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Dataset time range information if any.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 2;</code>
       */
      public com.google.type.IntervalOrBuilder getTimeRangeOrBuilder() {
        if (timeRangeBuilder_ != null) {
          return timeRangeBuilder_.getMessageOrBuilder();
        } else {
          return timeRange_ == null ? com.google.type.Interval.getDefaultInstance() : timeRange_;
        }
      }
      /**
       *
       *
       * <pre>
       * Dataset time range information if any.
       * </pre>
       *
       * <code>.google.type.Interval time_range = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Interval,
              com.google.type.Interval.Builder,
              com.google.type.IntervalOrBuilder>
          getTimeRangeFieldBuilder() {
        if (timeRangeBuilder_ == null) {
          timeRangeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Interval,
                  com.google.type.Interval.Builder,
                  com.google.type.IntervalOrBuilder>(
                  getTimeRange(), getParentForChildren(), isClean());
          timeRange_ = null;
        }
        return timeRangeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDataset
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
              .ProcessedDataset();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDataset
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ProcessedDataset> PARSER =
        new com.google.protobuf.AbstractParser<ProcessedDataset>() {
          @java.lang.Override
          public ProcessedDataset parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ProcessedDataset> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ProcessedDataset> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int BASELINE_DATASETS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset>
      baselineDatasets_;
  /**
   *
   *
   * <pre>
   * Processed baseline datasets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset>
      getBaselineDatasetsList() {
    return baselineDatasets_;
  }
  /**
   *
   *
   * <pre>
   * Processed baseline datasets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                  .ProcessedDatasetOrBuilder>
      getBaselineDatasetsOrBuilderList() {
    return baselineDatasets_;
  }
  /**
   *
   *
   * <pre>
   * Processed baseline datasets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
   * </code>
   */
  @java.lang.Override
  public int getBaselineDatasetsCount() {
    return baselineDatasets_.size();
  }
  /**
   *
   *
   * <pre>
   * Processed baseline datasets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
      getBaselineDatasets(int index) {
    return baselineDatasets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Processed baseline datasets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
          .ProcessedDatasetOrBuilder
      getBaselineDatasetsOrBuilder(int index) {
    return baselineDatasets_.get(index);
  }

  public static final int TARGET_DATASETS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset>
      targetDatasets_;
  /**
   *
   *
   * <pre>
   * Processed target datasets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset>
      getTargetDatasetsList() {
    return targetDatasets_;
  }
  /**
   *
   *
   * <pre>
   * Processed target datasets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                  .ProcessedDatasetOrBuilder>
      getTargetDatasetsOrBuilderList() {
    return targetDatasets_;
  }
  /**
   *
   *
   * <pre>
   * Processed target datasets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
   * </code>
   */
  @java.lang.Override
  public int getTargetDatasetsCount() {
    return targetDatasets_.size();
  }
  /**
   *
   *
   * <pre>
   * Processed target datasets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
      getTargetDatasets(int index) {
    return targetDatasets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Processed target datasets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
          .ProcessedDatasetOrBuilder
      getTargetDatasetsOrBuilder(int index) {
    return targetDatasets_.get(index);
  }

  public static final int OBJECTIVE_STATUS_FIELD_NUMBER = 3;

  private static final class ObjectiveStatusDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.rpc.Status>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.rpc.Status>newDefaultInstance(
                    com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
                        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJobExecutionDetail_ObjectiveStatusEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.rpc.Status.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.rpc.Status> objectiveStatus_;

  private com.google.protobuf.MapField<java.lang.String, com.google.rpc.Status>
      internalGetObjectiveStatus() {
    if (objectiveStatus_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ObjectiveStatusDefaultEntryHolder.defaultEntry);
    }
    return objectiveStatus_;
  }

  public int getObjectiveStatusCount() {
    return internalGetObjectiveStatus().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Status of data processing for each monitoring objective.
   * Key is the objective.
   * </pre>
   *
   * <code>map&lt;string, .google.rpc.Status&gt; objective_status = 3;</code>
   */
  @java.lang.Override
  public boolean containsObjectiveStatus(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetObjectiveStatus().getMap().containsKey(key);
  }
  /** Use {@link #getObjectiveStatusMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.rpc.Status> getObjectiveStatus() {
    return getObjectiveStatusMap();
  }
  /**
   *
   *
   * <pre>
   * Status of data processing for each monitoring objective.
   * Key is the objective.
   * </pre>
   *
   * <code>map&lt;string, .google.rpc.Status&gt; objective_status = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.rpc.Status> getObjectiveStatusMap() {
    return internalGetObjectiveStatus().getMap();
  }
  /**
   *
   *
   * <pre>
   * Status of data processing for each monitoring objective.
   * Key is the objective.
   * </pre>
   *
   * <code>map&lt;string, .google.rpc.Status&gt; objective_status = 3;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.rpc.Status getObjectiveStatusOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.rpc.Status defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.rpc.Status> map =
        internalGetObjectiveStatus().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Status of data processing for each monitoring objective.
   * Key is the objective.
   * </pre>
   *
   * <code>map&lt;string, .google.rpc.Status&gt; objective_status = 3;</code>
   */
  @java.lang.Override
  public com.google.rpc.Status getObjectiveStatusOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.rpc.Status> map =
        internalGetObjectiveStatus().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ERROR_FIELD_NUMBER = 4;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Additional job error status.
   * </pre>
   *
   * <code>.google.rpc.Status error = 4;</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Additional job error status.
   * </pre>
   *
   * <code>.google.rpc.Status error = 4;</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Additional job error status.
   * </pre>
   *
   * <code>.google.rpc.Status error = 4;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < baselineDatasets_.size(); i++) {
      output.writeMessage(1, baselineDatasets_.get(i));
    }
    for (int i = 0; i < targetDatasets_.size(); i++) {
      output.writeMessage(2, targetDatasets_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetObjectiveStatus(), ObjectiveStatusDefaultEntryHolder.defaultEntry, 3);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getError());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < baselineDatasets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, baselineDatasets_.get(i));
    }
    for (int i = 0; i < targetDatasets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, targetDatasets_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, com.google.rpc.Status> entry :
        internalGetObjectiveStatus().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.rpc.Status> objectiveStatus__ =
          ObjectiveStatusDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, objectiveStatus__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getError());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail other =
        (com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail) obj;

    if (!getBaselineDatasetsList().equals(other.getBaselineDatasetsList())) return false;
    if (!getTargetDatasetsList().equals(other.getTargetDatasetsList())) return false;
    if (!internalGetObjectiveStatus().equals(other.internalGetObjectiveStatus())) return false;
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getBaselineDatasetsCount() > 0) {
      hash = (37 * hash) + BASELINE_DATASETS_FIELD_NUMBER;
      hash = (53 * hash) + getBaselineDatasetsList().hashCode();
    }
    if (getTargetDatasetsCount() > 0) {
      hash = (37 * hash) + TARGET_DATASETS_FIELD_NUMBER;
      hash = (53 * hash) + getTargetDatasetsList().hashCode();
    }
    if (!internalGetObjectiveStatus().getMap().isEmpty()) {
      hash = (37 * hash) + OBJECTIVE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetObjectiveStatus().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represent the execution details of the job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail)
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetailOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJobExecutionDetail_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetObjectiveStatus();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableObjectiveStatus();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJobExecutionDetail_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.Builder.class);
    }

    // Construct using
    // com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getBaselineDatasetsFieldBuilder();
        getTargetDatasetsFieldBuilder();
        getErrorFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (baselineDatasetsBuilder_ == null) {
        baselineDatasets_ = java.util.Collections.emptyList();
      } else {
        baselineDatasets_ = null;
        baselineDatasetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (targetDatasetsBuilder_ == null) {
        targetDatasets_ = java.util.Collections.emptyList();
      } else {
        targetDatasets_ = null;
        targetDatasetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableObjectiveStatus().clear();
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringJobExecutionDetail_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail build() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail result =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail result) {
      if (baselineDatasetsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          baselineDatasets_ = java.util.Collections.unmodifiableList(baselineDatasets_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.baselineDatasets_ = baselineDatasets_;
      } else {
        result.baselineDatasets_ = baselineDatasetsBuilder_.build();
      }
      if (targetDatasetsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          targetDatasets_ = java.util.Collections.unmodifiableList(targetDatasets_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.targetDatasets_ = targetDatasets_;
      } else {
        result.targetDatasets_ = targetDatasetsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.objectiveStatus_ =
            internalGetObjectiveStatus().build(ObjectiveStatusDefaultEntryHolder.defaultEntry);
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail) {
        return mergeFrom(
            (com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
              .getDefaultInstance()) return this;
      if (baselineDatasetsBuilder_ == null) {
        if (!other.baselineDatasets_.isEmpty()) {
          if (baselineDatasets_.isEmpty()) {
            baselineDatasets_ = other.baselineDatasets_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureBaselineDatasetsIsMutable();
            baselineDatasets_.addAll(other.baselineDatasets_);
          }
          onChanged();
        }
      } else {
        if (!other.baselineDatasets_.isEmpty()) {
          if (baselineDatasetsBuilder_.isEmpty()) {
            baselineDatasetsBuilder_.dispose();
            baselineDatasetsBuilder_ = null;
            baselineDatasets_ = other.baselineDatasets_;
            bitField0_ = (bitField0_ & ~0x00000001);
            baselineDatasetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBaselineDatasetsFieldBuilder()
                    : null;
          } else {
            baselineDatasetsBuilder_.addAllMessages(other.baselineDatasets_);
          }
        }
      }
      if (targetDatasetsBuilder_ == null) {
        if (!other.targetDatasets_.isEmpty()) {
          if (targetDatasets_.isEmpty()) {
            targetDatasets_ = other.targetDatasets_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTargetDatasetsIsMutable();
            targetDatasets_.addAll(other.targetDatasets_);
          }
          onChanged();
        }
      } else {
        if (!other.targetDatasets_.isEmpty()) {
          if (targetDatasetsBuilder_.isEmpty()) {
            targetDatasetsBuilder_.dispose();
            targetDatasetsBuilder_ = null;
            targetDatasets_ = other.targetDatasets_;
            bitField0_ = (bitField0_ & ~0x00000002);
            targetDatasetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTargetDatasetsFieldBuilder()
                    : null;
          } else {
            targetDatasetsBuilder_.addAllMessages(other.targetDatasets_);
          }
        }
      }
      internalGetMutableObjectiveStatus().mergeFrom(other.internalGetObjectiveStatus());
      bitField0_ |= 0x00000004;
      if (other.hasError()) {
        mergeError(other.getError());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                        .ProcessedDataset
                    m =
                        input.readMessage(
                            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                                .ProcessedDataset.parser(),
                            extensionRegistry);
                if (baselineDatasetsBuilder_ == null) {
                  ensureBaselineDatasetsIsMutable();
                  baselineDatasets_.add(m);
                } else {
                  baselineDatasetsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                        .ProcessedDataset
                    m =
                        input.readMessage(
                            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                                .ProcessedDataset.parser(),
                            extensionRegistry);
                if (targetDatasetsBuilder_ == null) {
                  ensureTargetDatasetsIsMutable();
                  targetDatasets_.add(m);
                } else {
                  targetDatasetsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.rpc.Status>
                    objectiveStatus__ =
                        input.readMessage(
                            ObjectiveStatusDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableObjectiveStatus()
                    .ensureBuilderMap()
                    .put(objectiveStatus__.getKey(), objectiveStatus__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset>
        baselineDatasets_ = java.util.Collections.emptyList();

    private void ensureBaselineDatasetsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        baselineDatasets_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                    .ProcessedDataset>(baselineDatasets_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                .Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                .ProcessedDatasetOrBuilder>
        baselineDatasetsBuilder_;

    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset>
        getBaselineDatasetsList() {
      if (baselineDatasetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(baselineDatasets_);
      } else {
        return baselineDatasetsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public int getBaselineDatasetsCount() {
      if (baselineDatasetsBuilder_ == null) {
        return baselineDatasets_.size();
      } else {
        return baselineDatasetsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
        getBaselineDatasets(int index) {
      if (baselineDatasetsBuilder_ == null) {
        return baselineDatasets_.get(index);
      } else {
        return baselineDatasetsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public Builder setBaselineDatasets(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
            value) {
      if (baselineDatasetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBaselineDatasetsIsMutable();
        baselineDatasets_.set(index, value);
        onChanged();
      } else {
        baselineDatasetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public Builder setBaselineDatasets(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                .Builder
            builderForValue) {
      if (baselineDatasetsBuilder_ == null) {
        ensureBaselineDatasetsIsMutable();
        baselineDatasets_.set(index, builderForValue.build());
        onChanged();
      } else {
        baselineDatasetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public Builder addBaselineDatasets(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
            value) {
      if (baselineDatasetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBaselineDatasetsIsMutable();
        baselineDatasets_.add(value);
        onChanged();
      } else {
        baselineDatasetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public Builder addBaselineDatasets(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
            value) {
      if (baselineDatasetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBaselineDatasetsIsMutable();
        baselineDatasets_.add(index, value);
        onChanged();
      } else {
        baselineDatasetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public Builder addBaselineDatasets(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                .Builder
            builderForValue) {
      if (baselineDatasetsBuilder_ == null) {
        ensureBaselineDatasetsIsMutable();
        baselineDatasets_.add(builderForValue.build());
        onChanged();
      } else {
        baselineDatasetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public Builder addBaselineDatasets(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                .Builder
            builderForValue) {
      if (baselineDatasetsBuilder_ == null) {
        ensureBaselineDatasetsIsMutable();
        baselineDatasets_.add(index, builderForValue.build());
        onChanged();
      } else {
        baselineDatasetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public Builder addAllBaselineDatasets(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                        .ProcessedDataset>
            values) {
      if (baselineDatasetsBuilder_ == null) {
        ensureBaselineDatasetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, baselineDatasets_);
        onChanged();
      } else {
        baselineDatasetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public Builder clearBaselineDatasets() {
      if (baselineDatasetsBuilder_ == null) {
        baselineDatasets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        baselineDatasetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public Builder removeBaselineDatasets(int index) {
      if (baselineDatasetsBuilder_ == null) {
        ensureBaselineDatasetsIsMutable();
        baselineDatasets_.remove(index);
        onChanged();
      } else {
        baselineDatasetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
            .Builder
        getBaselineDatasetsBuilder(int index) {
      return getBaselineDatasetsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDatasetOrBuilder
        getBaselineDatasetsOrBuilder(int index) {
      if (baselineDatasetsBuilder_ == null) {
        return baselineDatasets_.get(index);
      } else {
        return baselineDatasetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                    .ProcessedDatasetOrBuilder>
        getBaselineDatasetsOrBuilderList() {
      if (baselineDatasetsBuilder_ != null) {
        return baselineDatasetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(baselineDatasets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
            .Builder
        addBaselineDatasetsBuilder() {
      return getBaselineDatasetsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
            .Builder
        addBaselineDatasetsBuilder(int index) {
      return getBaselineDatasetsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Processed baseline datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset baseline_datasets = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                .Builder>
        getBaselineDatasetsBuilderList() {
      return getBaselineDatasetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                .Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                .ProcessedDatasetOrBuilder>
        getBaselineDatasetsFieldBuilder() {
      if (baselineDatasetsBuilder_ == null) {
        baselineDatasetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                    .ProcessedDataset,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                    .ProcessedDataset.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                    .ProcessedDatasetOrBuilder>(
                baselineDatasets_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        baselineDatasets_ = null;
      }
      return baselineDatasetsBuilder_;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset>
        targetDatasets_ = java.util.Collections.emptyList();

    private void ensureTargetDatasetsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        targetDatasets_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                    .ProcessedDataset>(targetDatasets_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                .Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                .ProcessedDatasetOrBuilder>
        targetDatasetsBuilder_;

    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset>
        getTargetDatasetsList() {
      if (targetDatasetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(targetDatasets_);
      } else {
        return targetDatasetsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public int getTargetDatasetsCount() {
      if (targetDatasetsBuilder_ == null) {
        return targetDatasets_.size();
      } else {
        return targetDatasetsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
        getTargetDatasets(int index) {
      if (targetDatasetsBuilder_ == null) {
        return targetDatasets_.get(index);
      } else {
        return targetDatasetsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public Builder setTargetDatasets(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
            value) {
      if (targetDatasetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetDatasetsIsMutable();
        targetDatasets_.set(index, value);
        onChanged();
      } else {
        targetDatasetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public Builder setTargetDatasets(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                .Builder
            builderForValue) {
      if (targetDatasetsBuilder_ == null) {
        ensureTargetDatasetsIsMutable();
        targetDatasets_.set(index, builderForValue.build());
        onChanged();
      } else {
        targetDatasetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public Builder addTargetDatasets(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
            value) {
      if (targetDatasetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetDatasetsIsMutable();
        targetDatasets_.add(value);
        onChanged();
      } else {
        targetDatasetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public Builder addTargetDatasets(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
            value) {
      if (targetDatasetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetDatasetsIsMutable();
        targetDatasets_.add(index, value);
        onChanged();
      } else {
        targetDatasetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public Builder addTargetDatasets(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                .Builder
            builderForValue) {
      if (targetDatasetsBuilder_ == null) {
        ensureTargetDatasetsIsMutable();
        targetDatasets_.add(builderForValue.build());
        onChanged();
      } else {
        targetDatasetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public Builder addTargetDatasets(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                .Builder
            builderForValue) {
      if (targetDatasetsBuilder_ == null) {
        ensureTargetDatasetsIsMutable();
        targetDatasets_.add(index, builderForValue.build());
        onChanged();
      } else {
        targetDatasetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public Builder addAllTargetDatasets(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                        .ProcessedDataset>
            values) {
      if (targetDatasetsBuilder_ == null) {
        ensureTargetDatasetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetDatasets_);
        onChanged();
      } else {
        targetDatasetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public Builder clearTargetDatasets() {
      if (targetDatasetsBuilder_ == null) {
        targetDatasets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        targetDatasetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public Builder removeTargetDatasets(int index) {
      if (targetDatasetsBuilder_ == null) {
        ensureTargetDatasetsIsMutable();
        targetDatasets_.remove(index);
        onChanged();
      } else {
        targetDatasetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
            .Builder
        getTargetDatasetsBuilder(int index) {
      return getTargetDatasetsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
            .ProcessedDatasetOrBuilder
        getTargetDatasetsOrBuilder(int index) {
      if (targetDatasetsBuilder_ == null) {
        return targetDatasets_.get(index);
      } else {
        return targetDatasetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                    .ProcessedDatasetOrBuilder>
        getTargetDatasetsOrBuilderList() {
      if (targetDatasetsBuilder_ != null) {
        return targetDatasetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(targetDatasets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
            .Builder
        addTargetDatasetsBuilder() {
      return getTargetDatasetsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
            .Builder
        addTargetDatasetsBuilder(int index) {
      return getTargetDatasetsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Processed target datasets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset target_datasets = 2;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                .Builder>
        getTargetDatasetsBuilderList() {
      return getTargetDatasetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail.ProcessedDataset
                .Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                .ProcessedDatasetOrBuilder>
        getTargetDatasetsFieldBuilder() {
      if (targetDatasetsBuilder_ == null) {
        targetDatasetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                    .ProcessedDataset,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                    .ProcessedDataset.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
                    .ProcessedDatasetOrBuilder>(
                targetDatasets_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        targetDatasets_ = null;
      }
      return targetDatasetsBuilder_;
    }

    private static final class ObjectiveStatusConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String, com.google.rpc.StatusOrBuilder, com.google.rpc.Status> {
      @java.lang.Override
      public com.google.rpc.Status build(com.google.rpc.StatusOrBuilder val) {
        if (val instanceof com.google.rpc.Status) {
          return (com.google.rpc.Status) val;
        }
        return ((com.google.rpc.Status.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<java.lang.String, com.google.rpc.Status> defaultEntry() {
        return ObjectiveStatusDefaultEntryHolder.defaultEntry;
      }
    };

    private static final ObjectiveStatusConverter objectiveStatusConverter =
        new ObjectiveStatusConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.rpc.StatusOrBuilder,
            com.google.rpc.Status,
            com.google.rpc.Status.Builder>
        objectiveStatus_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.rpc.StatusOrBuilder,
            com.google.rpc.Status,
            com.google.rpc.Status.Builder>
        internalGetObjectiveStatus() {
      if (objectiveStatus_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(objectiveStatusConverter);
      }
      return objectiveStatus_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.rpc.StatusOrBuilder,
            com.google.rpc.Status,
            com.google.rpc.Status.Builder>
        internalGetMutableObjectiveStatus() {
      if (objectiveStatus_ == null) {
        objectiveStatus_ = new com.google.protobuf.MapFieldBuilder<>(objectiveStatusConverter);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return objectiveStatus_;
    }

    public int getObjectiveStatusCount() {
      return internalGetObjectiveStatus().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Status of data processing for each monitoring objective.
     * Key is the objective.
     * </pre>
     *
     * <code>map&lt;string, .google.rpc.Status&gt; objective_status = 3;</code>
     */
    @java.lang.Override
    public boolean containsObjectiveStatus(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetObjectiveStatus().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getObjectiveStatusMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.rpc.Status> getObjectiveStatus() {
      return getObjectiveStatusMap();
    }
    /**
     *
     *
     * <pre>
     * Status of data processing for each monitoring objective.
     * Key is the objective.
     * </pre>
     *
     * <code>map&lt;string, .google.rpc.Status&gt; objective_status = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.rpc.Status> getObjectiveStatusMap() {
      return internalGetObjectiveStatus().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Status of data processing for each monitoring objective.
     * Key is the objective.
     * </pre>
     *
     * <code>map&lt;string, .google.rpc.Status&gt; objective_status = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.rpc.Status getObjectiveStatusOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.rpc.Status defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.rpc.StatusOrBuilder> map =
          internalGetMutableObjectiveStatus().ensureBuilderMap();
      return map.containsKey(key) ? objectiveStatusConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Status of data processing for each monitoring objective.
     * Key is the objective.
     * </pre>
     *
     * <code>map&lt;string, .google.rpc.Status&gt; objective_status = 3;</code>
     */
    @java.lang.Override
    public com.google.rpc.Status getObjectiveStatusOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.rpc.StatusOrBuilder> map =
          internalGetMutableObjectiveStatus().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return objectiveStatusConverter.build(map.get(key));
    }

    public Builder clearObjectiveStatus() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableObjectiveStatus().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of data processing for each monitoring objective.
     * Key is the objective.
     * </pre>
     *
     * <code>map&lt;string, .google.rpc.Status&gt; objective_status = 3;</code>
     */
    public Builder removeObjectiveStatus(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableObjectiveStatus().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.rpc.Status> getMutableObjectiveStatus() {
      bitField0_ |= 0x00000004;
      return internalGetMutableObjectiveStatus().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Status of data processing for each monitoring objective.
     * Key is the objective.
     * </pre>
     *
     * <code>map&lt;string, .google.rpc.Status&gt; objective_status = 3;</code>
     */
    public Builder putObjectiveStatus(java.lang.String key, com.google.rpc.Status value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableObjectiveStatus().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of data processing for each monitoring objective.
     * Key is the objective.
     * </pre>
     *
     * <code>map&lt;string, .google.rpc.Status&gt; objective_status = 3;</code>
     */
    public Builder putAllObjectiveStatus(
        java.util.Map<java.lang.String, com.google.rpc.Status> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.rpc.Status> e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableObjectiveStatus().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of data processing for each monitoring objective.
     * Key is the objective.
     * </pre>
     *
     * <code>map&lt;string, .google.rpc.Status&gt; objective_status = 3;</code>
     */
    public com.google.rpc.Status.Builder putObjectiveStatusBuilderIfAbsent(java.lang.String key) {
      java.util.Map<java.lang.String, com.google.rpc.StatusOrBuilder> builderMap =
          internalGetMutableObjectiveStatus().ensureBuilderMap();
      com.google.rpc.StatusOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.rpc.Status.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.rpc.Status) {
        entry = ((com.google.rpc.Status) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.rpc.Status.Builder) entry;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Additional job error status.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Additional job error status.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional job error status.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional job error status.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional job error status.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      if (error_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional job error status.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00000008);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional job error status.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional job error status.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional job error status.
     * </pre>
     *
     * <code>.google.rpc.Status error = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail)
  private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelMonitoringJobExecutionDetail> PARSER =
      new com.google.protobuf.AbstractParser<ModelMonitoringJobExecutionDetail>() {
        @java.lang.Override
        public ModelMonitoringJobExecutionDetail parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelMonitoringJobExecutionDetail> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelMonitoringJobExecutionDetail> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringJobExecutionDetail
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
