/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_monitoring.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * The model monitoring configuration used for Batch Prediction Job.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringConfig}
 */
public final class ModelMonitoringConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringConfig)
    ModelMonitoringConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelMonitoringConfig.newBuilder() to construct.
  private ModelMonitoringConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelMonitoringConfig() {
    objectiveConfigs_ = java.util.Collections.emptyList();
    analysisInstanceSchemaUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelMonitoringConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.class,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.Builder.class);
  }

  private int bitField0_;
  public static final int OBJECTIVE_CONFIGS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig>
      objectiveConfigs_;
  /**
   *
   *
   * <pre>
   * Model monitoring objective config.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig>
      getObjectiveConfigsList() {
    return objectiveConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Model monitoring objective config.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfigOrBuilder>
      getObjectiveConfigsOrBuilderList() {
    return objectiveConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Model monitoring objective config.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
   * </code>
   */
  @java.lang.Override
  public int getObjectiveConfigsCount() {
    return objectiveConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Model monitoring objective config.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig getObjectiveConfigs(
      int index) {
    return objectiveConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Model monitoring objective config.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfigOrBuilder
      getObjectiveConfigsOrBuilder(int index) {
    return objectiveConfigs_.get(index);
  }

  public static final int ALERT_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig alertConfig_;
  /**
   *
   *
   * <pre>
   * Model monitoring alert config.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig alert_config = 2;</code>
   *
   * @return Whether the alertConfig field is set.
   */
  @java.lang.Override
  public boolean hasAlertConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Model monitoring alert config.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig alert_config = 2;</code>
   *
   * @return The alertConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig getAlertConfig() {
    return alertConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.getDefaultInstance()
        : alertConfig_;
  }
  /**
   *
   *
   * <pre>
   * Model monitoring alert config.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig alert_config = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfigOrBuilder
      getAlertConfigOrBuilder() {
    return alertConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.getDefaultInstance()
        : alertConfig_;
  }

  public static final int ANALYSIS_INSTANCE_SCHEMA_URI_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object analysisInstanceSchemaUri_ = "";
  /**
   *
   *
   * <pre>
   * YAML schema file uri in Cloud Storage describing the format of a single
   * instance that you want Tensorflow Data Validation (TFDV) to analyze.
   *
   * If there are any data type differences between predict instance and TFDV
   * instance, this field can be used to override the schema.
   * For models trained with Vertex AI, this field must be set as all the
   * fields in predict instance formatted as string.
   * </pre>
   *
   * <code>string analysis_instance_schema_uri = 4;</code>
   *
   * @return The analysisInstanceSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getAnalysisInstanceSchemaUri() {
    java.lang.Object ref = analysisInstanceSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      analysisInstanceSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * YAML schema file uri in Cloud Storage describing the format of a single
   * instance that you want Tensorflow Data Validation (TFDV) to analyze.
   *
   * If there are any data type differences between predict instance and TFDV
   * instance, this field can be used to override the schema.
   * For models trained with Vertex AI, this field must be set as all the
   * fields in predict instance formatted as string.
   * </pre>
   *
   * <code>string analysis_instance_schema_uri = 4;</code>
   *
   * @return The bytes for analysisInstanceSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnalysisInstanceSchemaUriBytes() {
    java.lang.Object ref = analysisInstanceSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      analysisInstanceSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATS_ANOMALIES_BASE_DIRECTORY_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1beta1.GcsDestination statsAnomaliesBaseDirectory_;
  /**
   *
   *
   * <pre>
   * A Google Cloud Storage location for batch prediction model monitoring to
   * dump statistics and anomalies.
   * If not provided, a folder will be created in customer project to hold
   * statistics and anomalies.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 5;
   * </code>
   *
   * @return Whether the statsAnomaliesBaseDirectory field is set.
   */
  @java.lang.Override
  public boolean hasStatsAnomaliesBaseDirectory() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * A Google Cloud Storage location for batch prediction model monitoring to
   * dump statistics and anomalies.
   * If not provided, a folder will be created in customer project to hold
   * statistics and anomalies.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 5;
   * </code>
   *
   * @return The statsAnomaliesBaseDirectory.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsDestination getStatsAnomaliesBaseDirectory() {
    return statsAnomaliesBaseDirectory_ == null
        ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
        : statsAnomaliesBaseDirectory_;
  }
  /**
   *
   *
   * <pre>
   * A Google Cloud Storage location for batch prediction model monitoring to
   * dump statistics and anomalies.
   * If not provided, a folder will be created in customer project to hold
   * statistics and anomalies.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
      getStatsAnomaliesBaseDirectoryOrBuilder() {
    return statsAnomaliesBaseDirectory_ == null
        ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
        : statsAnomaliesBaseDirectory_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getAlertConfig());
    }
    for (int i = 0; i < objectiveConfigs_.size(); i++) {
      output.writeMessage(3, objectiveConfigs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(analysisInstanceSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, analysisInstanceSchemaUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getStatsAnomaliesBaseDirectory());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAlertConfig());
    }
    for (int i = 0; i < objectiveConfigs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, objectiveConfigs_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(analysisInstanceSchemaUri_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(4, analysisInstanceSchemaUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, getStatsAnomaliesBaseDirectory());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig other =
        (com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig) obj;

    if (!getObjectiveConfigsList().equals(other.getObjectiveConfigsList())) return false;
    if (hasAlertConfig() != other.hasAlertConfig()) return false;
    if (hasAlertConfig()) {
      if (!getAlertConfig().equals(other.getAlertConfig())) return false;
    }
    if (!getAnalysisInstanceSchemaUri().equals(other.getAnalysisInstanceSchemaUri())) return false;
    if (hasStatsAnomaliesBaseDirectory() != other.hasStatsAnomaliesBaseDirectory()) return false;
    if (hasStatsAnomaliesBaseDirectory()) {
      if (!getStatsAnomaliesBaseDirectory().equals(other.getStatsAnomaliesBaseDirectory()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getObjectiveConfigsCount() > 0) {
      hash = (37 * hash) + OBJECTIVE_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getObjectiveConfigsList().hashCode();
    }
    if (hasAlertConfig()) {
      hash = (37 * hash) + ALERT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAlertConfig().hashCode();
    }
    hash = (37 * hash) + ANALYSIS_INSTANCE_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getAnalysisInstanceSchemaUri().hashCode();
    if (hasStatsAnomaliesBaseDirectory()) {
      hash = (37 * hash) + STATS_ANOMALIES_BASE_DIRECTORY_FIELD_NUMBER;
      hash = (53 * hash) + getStatsAnomaliesBaseDirectory().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The model monitoring configuration used for Batch Prediction Job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitoringConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitoringConfig)
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getObjectiveConfigsFieldBuilder();
        getAlertConfigFieldBuilder();
        getStatsAnomaliesBaseDirectoryFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (objectiveConfigsBuilder_ == null) {
        objectiveConfigs_ = java.util.Collections.emptyList();
      } else {
        objectiveConfigs_ = null;
        objectiveConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      alertConfig_ = null;
      if (alertConfigBuilder_ != null) {
        alertConfigBuilder_.dispose();
        alertConfigBuilder_ = null;
      }
      analysisInstanceSchemaUri_ = "";
      statsAnomaliesBaseDirectory_ = null;
      if (statsAnomaliesBaseDirectoryBuilder_ != null) {
        statsAnomaliesBaseDirectoryBuilder_.dispose();
        statsAnomaliesBaseDirectoryBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitoringConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig build() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig result =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig result) {
      if (objectiveConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          objectiveConfigs_ = java.util.Collections.unmodifiableList(objectiveConfigs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.objectiveConfigs_ = objectiveConfigs_;
      } else {
        result.objectiveConfigs_ = objectiveConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.alertConfig_ =
            alertConfigBuilder_ == null ? alertConfig_ : alertConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.analysisInstanceSchemaUri_ = analysisInstanceSchemaUri_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.statsAnomaliesBaseDirectory_ =
            statsAnomaliesBaseDirectoryBuilder_ == null
                ? statsAnomaliesBaseDirectory_
                : statsAnomaliesBaseDirectoryBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig.getDefaultInstance())
        return this;
      if (objectiveConfigsBuilder_ == null) {
        if (!other.objectiveConfigs_.isEmpty()) {
          if (objectiveConfigs_.isEmpty()) {
            objectiveConfigs_ = other.objectiveConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureObjectiveConfigsIsMutable();
            objectiveConfigs_.addAll(other.objectiveConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.objectiveConfigs_.isEmpty()) {
          if (objectiveConfigsBuilder_.isEmpty()) {
            objectiveConfigsBuilder_.dispose();
            objectiveConfigsBuilder_ = null;
            objectiveConfigs_ = other.objectiveConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            objectiveConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getObjectiveConfigsFieldBuilder()
                    : null;
          } else {
            objectiveConfigsBuilder_.addAllMessages(other.objectiveConfigs_);
          }
        }
      }
      if (other.hasAlertConfig()) {
        mergeAlertConfig(other.getAlertConfig());
      }
      if (!other.getAnalysisInstanceSchemaUri().isEmpty()) {
        analysisInstanceSchemaUri_ = other.analysisInstanceSchemaUri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasStatsAnomaliesBaseDirectory()) {
        mergeStatsAnomaliesBaseDirectory(other.getStatsAnomaliesBaseDirectory());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getAlertConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.parser(),
                        extensionRegistry);
                if (objectiveConfigsBuilder_ == null) {
                  ensureObjectiveConfigsIsMutable();
                  objectiveConfigs_.add(m);
                } else {
                  objectiveConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                analysisInstanceSchemaUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getStatsAnomaliesBaseDirectoryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig>
        objectiveConfigs_ = java.util.Collections.emptyList();

    private void ensureObjectiveConfigsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        objectiveConfigs_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig>(
                objectiveConfigs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfigOrBuilder>
        objectiveConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig>
        getObjectiveConfigsList() {
      if (objectiveConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(objectiveConfigs_);
      } else {
        return objectiveConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public int getObjectiveConfigsCount() {
      if (objectiveConfigsBuilder_ == null) {
        return objectiveConfigs_.size();
      } else {
        return objectiveConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig getObjectiveConfigs(
        int index) {
      if (objectiveConfigsBuilder_ == null) {
        return objectiveConfigs_.get(index);
      } else {
        return objectiveConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public Builder setObjectiveConfigs(
        int index, com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig value) {
      if (objectiveConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectiveConfigsIsMutable();
        objectiveConfigs_.set(index, value);
        onChanged();
      } else {
        objectiveConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public Builder setObjectiveConfigs(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.Builder
            builderForValue) {
      if (objectiveConfigsBuilder_ == null) {
        ensureObjectiveConfigsIsMutable();
        objectiveConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        objectiveConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public Builder addObjectiveConfigs(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig value) {
      if (objectiveConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectiveConfigsIsMutable();
        objectiveConfigs_.add(value);
        onChanged();
      } else {
        objectiveConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public Builder addObjectiveConfigs(
        int index, com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig value) {
      if (objectiveConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectiveConfigsIsMutable();
        objectiveConfigs_.add(index, value);
        onChanged();
      } else {
        objectiveConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public Builder addObjectiveConfigs(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.Builder
            builderForValue) {
      if (objectiveConfigsBuilder_ == null) {
        ensureObjectiveConfigsIsMutable();
        objectiveConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        objectiveConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public Builder addObjectiveConfigs(
        int index,
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.Builder
            builderForValue) {
      if (objectiveConfigsBuilder_ == null) {
        ensureObjectiveConfigsIsMutable();
        objectiveConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        objectiveConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public Builder addAllObjectiveConfigs(
        java.lang.Iterable<
                ? extends com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig>
            values) {
      if (objectiveConfigsBuilder_ == null) {
        ensureObjectiveConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, objectiveConfigs_);
        onChanged();
      } else {
        objectiveConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public Builder clearObjectiveConfigs() {
      if (objectiveConfigsBuilder_ == null) {
        objectiveConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        objectiveConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public Builder removeObjectiveConfigs(int index) {
      if (objectiveConfigsBuilder_ == null) {
        ensureObjectiveConfigsIsMutable();
        objectiveConfigs_.remove(index);
        onChanged();
      } else {
        objectiveConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.Builder
        getObjectiveConfigsBuilder(int index) {
      return getObjectiveConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfigOrBuilder
        getObjectiveConfigsOrBuilder(int index) {
      if (objectiveConfigsBuilder_ == null) {
        return objectiveConfigs_.get(index);
      } else {
        return objectiveConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfigOrBuilder>
        getObjectiveConfigsOrBuilderList() {
      if (objectiveConfigsBuilder_ != null) {
        return objectiveConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(objectiveConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.Builder
        addObjectiveConfigsBuilder() {
      return getObjectiveConfigsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.Builder
        addObjectiveConfigsBuilder(int index) {
      return getObjectiveConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Model monitoring objective config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig objective_configs = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.Builder>
        getObjectiveConfigsBuilderList() {
      return getObjectiveConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfigOrBuilder>
        getObjectiveConfigsFieldBuilder() {
      if (objectiveConfigsBuilder_ == null) {
        objectiveConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfigOrBuilder>(
                objectiveConfigs_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        objectiveConfigs_ = null;
      }
      return objectiveConfigsBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig alertConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfigOrBuilder>
        alertConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Model monitoring alert config.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig alert_config = 2;</code>
     *
     * @return Whether the alertConfig field is set.
     */
    public boolean hasAlertConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Model monitoring alert config.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig alert_config = 2;</code>
     *
     * @return The alertConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig getAlertConfig() {
      if (alertConfigBuilder_ == null) {
        return alertConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.getDefaultInstance()
            : alertConfig_;
      } else {
        return alertConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Model monitoring alert config.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig alert_config = 2;</code>
     */
    public Builder setAlertConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig value) {
      if (alertConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        alertConfig_ = value;
      } else {
        alertConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring alert config.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig alert_config = 2;</code>
     */
    public Builder setAlertConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.Builder builderForValue) {
      if (alertConfigBuilder_ == null) {
        alertConfig_ = builderForValue.build();
      } else {
        alertConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring alert config.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig alert_config = 2;</code>
     */
    public Builder mergeAlertConfig(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig value) {
      if (alertConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && alertConfig_ != null
            && alertConfig_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig
                    .getDefaultInstance()) {
          getAlertConfigBuilder().mergeFrom(value);
        } else {
          alertConfig_ = value;
        }
      } else {
        alertConfigBuilder_.mergeFrom(value);
      }
      if (alertConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring alert config.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig alert_config = 2;</code>
     */
    public Builder clearAlertConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      alertConfig_ = null;
      if (alertConfigBuilder_ != null) {
        alertConfigBuilder_.dispose();
        alertConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model monitoring alert config.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig alert_config = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.Builder
        getAlertConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getAlertConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Model monitoring alert config.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig alert_config = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfigOrBuilder
        getAlertConfigOrBuilder() {
      if (alertConfigBuilder_ != null) {
        return alertConfigBuilder_.getMessageOrBuilder();
      } else {
        return alertConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.getDefaultInstance()
            : alertConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Model monitoring alert config.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig alert_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfigOrBuilder>
        getAlertConfigFieldBuilder() {
      if (alertConfigBuilder_ == null) {
        alertConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfigOrBuilder>(
                getAlertConfig(), getParentForChildren(), isClean());
        alertConfig_ = null;
      }
      return alertConfigBuilder_;
    }

    private java.lang.Object analysisInstanceSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * YAML schema file uri in Cloud Storage describing the format of a single
     * instance that you want Tensorflow Data Validation (TFDV) to analyze.
     *
     * If there are any data type differences between predict instance and TFDV
     * instance, this field can be used to override the schema.
     * For models trained with Vertex AI, this field must be set as all the
     * fields in predict instance formatted as string.
     * </pre>
     *
     * <code>string analysis_instance_schema_uri = 4;</code>
     *
     * @return The analysisInstanceSchemaUri.
     */
    public java.lang.String getAnalysisInstanceSchemaUri() {
      java.lang.Object ref = analysisInstanceSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        analysisInstanceSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * YAML schema file uri in Cloud Storage describing the format of a single
     * instance that you want Tensorflow Data Validation (TFDV) to analyze.
     *
     * If there are any data type differences between predict instance and TFDV
     * instance, this field can be used to override the schema.
     * For models trained with Vertex AI, this field must be set as all the
     * fields in predict instance formatted as string.
     * </pre>
     *
     * <code>string analysis_instance_schema_uri = 4;</code>
     *
     * @return The bytes for analysisInstanceSchemaUri.
     */
    public com.google.protobuf.ByteString getAnalysisInstanceSchemaUriBytes() {
      java.lang.Object ref = analysisInstanceSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        analysisInstanceSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * YAML schema file uri in Cloud Storage describing the format of a single
     * instance that you want Tensorflow Data Validation (TFDV) to analyze.
     *
     * If there are any data type differences between predict instance and TFDV
     * instance, this field can be used to override the schema.
     * For models trained with Vertex AI, this field must be set as all the
     * fields in predict instance formatted as string.
     * </pre>
     *
     * <code>string analysis_instance_schema_uri = 4;</code>
     *
     * @param value The analysisInstanceSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setAnalysisInstanceSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      analysisInstanceSchemaUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * YAML schema file uri in Cloud Storage describing the format of a single
     * instance that you want Tensorflow Data Validation (TFDV) to analyze.
     *
     * If there are any data type differences between predict instance and TFDV
     * instance, this field can be used to override the schema.
     * For models trained with Vertex AI, this field must be set as all the
     * fields in predict instance formatted as string.
     * </pre>
     *
     * <code>string analysis_instance_schema_uri = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnalysisInstanceSchemaUri() {
      analysisInstanceSchemaUri_ = getDefaultInstance().getAnalysisInstanceSchemaUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * YAML schema file uri in Cloud Storage describing the format of a single
     * instance that you want Tensorflow Data Validation (TFDV) to analyze.
     *
     * If there are any data type differences between predict instance and TFDV
     * instance, this field can be used to override the schema.
     * For models trained with Vertex AI, this field must be set as all the
     * fields in predict instance formatted as string.
     * </pre>
     *
     * <code>string analysis_instance_schema_uri = 4;</code>
     *
     * @param value The bytes for analysisInstanceSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setAnalysisInstanceSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      analysisInstanceSchemaUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.GcsDestination statsAnomaliesBaseDirectory_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        statsAnomaliesBaseDirectoryBuilder_;
    /**
     *
     *
     * <pre>
     * A Google Cloud Storage location for batch prediction model monitoring to
     * dump statistics and anomalies.
     * If not provided, a folder will be created in customer project to hold
     * statistics and anomalies.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 5;
     * </code>
     *
     * @return Whether the statsAnomaliesBaseDirectory field is set.
     */
    public boolean hasStatsAnomaliesBaseDirectory() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * A Google Cloud Storage location for batch prediction model monitoring to
     * dump statistics and anomalies.
     * If not provided, a folder will be created in customer project to hold
     * statistics and anomalies.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 5;
     * </code>
     *
     * @return The statsAnomaliesBaseDirectory.
     */
    public com.google.cloud.aiplatform.v1beta1.GcsDestination getStatsAnomaliesBaseDirectory() {
      if (statsAnomaliesBaseDirectoryBuilder_ == null) {
        return statsAnomaliesBaseDirectory_ == null
            ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
            : statsAnomaliesBaseDirectory_;
      } else {
        return statsAnomaliesBaseDirectoryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A Google Cloud Storage location for batch prediction model monitoring to
     * dump statistics and anomalies.
     * If not provided, a folder will be created in customer project to hold
     * statistics and anomalies.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 5;
     * </code>
     */
    public Builder setStatsAnomaliesBaseDirectory(
        com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (statsAnomaliesBaseDirectoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        statsAnomaliesBaseDirectory_ = value;
      } else {
        statsAnomaliesBaseDirectoryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Google Cloud Storage location for batch prediction model monitoring to
     * dump statistics and anomalies.
     * If not provided, a folder will be created in customer project to hold
     * statistics and anomalies.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 5;
     * </code>
     */
    public Builder setStatsAnomaliesBaseDirectory(
        com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder builderForValue) {
      if (statsAnomaliesBaseDirectoryBuilder_ == null) {
        statsAnomaliesBaseDirectory_ = builderForValue.build();
      } else {
        statsAnomaliesBaseDirectoryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Google Cloud Storage location for batch prediction model monitoring to
     * dump statistics and anomalies.
     * If not provided, a folder will be created in customer project to hold
     * statistics and anomalies.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 5;
     * </code>
     */
    public Builder mergeStatsAnomaliesBaseDirectory(
        com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
      if (statsAnomaliesBaseDirectoryBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && statsAnomaliesBaseDirectory_ != null
            && statsAnomaliesBaseDirectory_
                != com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()) {
          getStatsAnomaliesBaseDirectoryBuilder().mergeFrom(value);
        } else {
          statsAnomaliesBaseDirectory_ = value;
        }
      } else {
        statsAnomaliesBaseDirectoryBuilder_.mergeFrom(value);
      }
      if (statsAnomaliesBaseDirectory_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Google Cloud Storage location for batch prediction model monitoring to
     * dump statistics and anomalies.
     * If not provided, a folder will be created in customer project to hold
     * statistics and anomalies.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 5;
     * </code>
     */
    public Builder clearStatsAnomaliesBaseDirectory() {
      bitField0_ = (bitField0_ & ~0x00000008);
      statsAnomaliesBaseDirectory_ = null;
      if (statsAnomaliesBaseDirectoryBuilder_ != null) {
        statsAnomaliesBaseDirectoryBuilder_.dispose();
        statsAnomaliesBaseDirectoryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Google Cloud Storage location for batch prediction model monitoring to
     * dump statistics and anomalies.
     * If not provided, a folder will be created in customer project to hold
     * statistics and anomalies.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 5;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder
        getStatsAnomaliesBaseDirectoryBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getStatsAnomaliesBaseDirectoryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A Google Cloud Storage location for batch prediction model monitoring to
     * dump statistics and anomalies.
     * If not provided, a folder will be created in customer project to hold
     * statistics and anomalies.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 5;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
        getStatsAnomaliesBaseDirectoryOrBuilder() {
      if (statsAnomaliesBaseDirectoryBuilder_ != null) {
        return statsAnomaliesBaseDirectoryBuilder_.getMessageOrBuilder();
      } else {
        return statsAnomaliesBaseDirectory_ == null
            ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
            : statsAnomaliesBaseDirectory_;
      }
    }
    /**
     *
     *
     * <pre>
     * A Google Cloud Storage location for batch prediction model monitoring to
     * dump statistics and anomalies.
     * If not provided, a folder will be created in customer project to hold
     * statistics and anomalies.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination stats_anomalies_base_directory = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GcsDestination,
            com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
            com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
        getStatsAnomaliesBaseDirectoryFieldBuilder() {
      if (statsAnomaliesBaseDirectoryBuilder_ == null) {
        statsAnomaliesBaseDirectoryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GcsDestination,
                com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
                com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>(
                getStatsAnomaliesBaseDirectory(), getParentForChildren(), isClean());
        statsAnomaliesBaseDirectory_ = null;
      }
      return statsAnomaliesBaseDirectoryBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitoringConfig)
  private static final com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelMonitoringConfig> PARSER =
      new com.google.protobuf.AbstractParser<ModelMonitoringConfig>() {
        @java.lang.Override
        public ModelMonitoringConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelMonitoringConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelMonitoringConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
