/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [ModelService.ExportModel][google.cloud.aiplatform.v1beta1.ModelService.ExportModel].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ExportModelRequest}
 */
public final class ExportModelRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ExportModelRequest)
    ExportModelRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportModelRequest.newBuilder() to construct.
  private ExportModelRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportModelRequest() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportModelRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ExportModelRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_ExportModelRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ExportModelRequest.class,
            com.google.cloud.aiplatform.v1beta1.ExportModelRequest.Builder.class);
  }

  public interface OutputConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The ID of the format in which the Model must be exported. Each Model
     * lists the [export formats it
     * supports][google.cloud.aiplatform.v1beta1.Model.supported_export_formats].
     * If no value is provided here, then the first from the list of the Model's
     * supported formats is used by default.
     * </pre>
     *
     * <code>string export_format_id = 1;</code>
     *
     * @return The exportFormatId.
     */
    java.lang.String getExportFormatId();
    /**
     *
     *
     * <pre>
     * The ID of the format in which the Model must be exported. Each Model
     * lists the [export formats it
     * supports][google.cloud.aiplatform.v1beta1.Model.supported_export_formats].
     * If no value is provided here, then the first from the list of the Model's
     * supported formats is used by default.
     * </pre>
     *
     * <code>string export_format_id = 1;</code>
     *
     * @return The bytes for exportFormatId.
     */
    com.google.protobuf.ByteString getExportFormatIdBytes();

    /**
     *
     *
     * <pre>
     * The Cloud Storage location where the Model artifact is to be
     * written to. Under the directory given as the destination a new one with
     * name "`model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;`",
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     * will be created. Inside, the Model and any of its supporting files
     * will be written.
     * This field should only be set when the `exportableContent` field of the
     * [Model.supported_export_formats] object contains `ARTIFACT`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination artifact_destination = 3;</code>
     *
     * @return Whether the artifactDestination field is set.
     */
    boolean hasArtifactDestination();
    /**
     *
     *
     * <pre>
     * The Cloud Storage location where the Model artifact is to be
     * written to. Under the directory given as the destination a new one with
     * name "`model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;`",
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     * will be created. Inside, the Model and any of its supporting files
     * will be written.
     * This field should only be set when the `exportableContent` field of the
     * [Model.supported_export_formats] object contains `ARTIFACT`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination artifact_destination = 3;</code>
     *
     * @return The artifactDestination.
     */
    com.google.cloud.aiplatform.v1beta1.GcsDestination getArtifactDestination();
    /**
     *
     *
     * <pre>
     * The Cloud Storage location where the Model artifact is to be
     * written to. Under the directory given as the destination a new one with
     * name "`model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;`",
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     * will be created. Inside, the Model and any of its supporting files
     * will be written.
     * This field should only be set when the `exportableContent` field of the
     * [Model.supported_export_formats] object contains `ARTIFACT`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination artifact_destination = 3;</code>
     */
    com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder getArtifactDestinationOrBuilder();

    /**
     *
     *
     * <pre>
     * The Google Container Registry or Artifact Registry uri where the
     * Model container image will be copied to.
     * This field should only be set when the `exportableContent` field of the
     * [Model.supported_export_formats] object contains `IMAGE`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination image_destination = 4;
     * </code>
     *
     * @return Whether the imageDestination field is set.
     */
    boolean hasImageDestination();
    /**
     *
     *
     * <pre>
     * The Google Container Registry or Artifact Registry uri where the
     * Model container image will be copied to.
     * This field should only be set when the `exportableContent` field of the
     * [Model.supported_export_formats] object contains `IMAGE`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination image_destination = 4;
     * </code>
     *
     * @return The imageDestination.
     */
    com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination getImageDestination();
    /**
     *
     *
     * <pre>
     * The Google Container Registry or Artifact Registry uri where the
     * Model container image will be copied to.
     * This field should only be set when the `exportableContent` field of the
     * [Model.supported_export_formats] object contains `IMAGE`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination image_destination = 4;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestinationOrBuilder
        getImageDestinationOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Output configuration for the Model export.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig}
   */
  public static final class OutputConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig)
      OutputConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OutputConfig.newBuilder() to construct.
    private OutputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OutputConfig() {
      exportFormatId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OutputConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExportModelRequest_OutputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExportModelRequest_OutputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig.class,
              com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig.Builder.class);
    }

    private int bitField0_;
    public static final int EXPORT_FORMAT_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object exportFormatId_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the format in which the Model must be exported. Each Model
     * lists the [export formats it
     * supports][google.cloud.aiplatform.v1beta1.Model.supported_export_formats].
     * If no value is provided here, then the first from the list of the Model's
     * supported formats is used by default.
     * </pre>
     *
     * <code>string export_format_id = 1;</code>
     *
     * @return The exportFormatId.
     */
    @java.lang.Override
    public java.lang.String getExportFormatId() {
      java.lang.Object ref = exportFormatId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        exportFormatId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the format in which the Model must be exported. Each Model
     * lists the [export formats it
     * supports][google.cloud.aiplatform.v1beta1.Model.supported_export_formats].
     * If no value is provided here, then the first from the list of the Model's
     * supported formats is used by default.
     * </pre>
     *
     * <code>string export_format_id = 1;</code>
     *
     * @return The bytes for exportFormatId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getExportFormatIdBytes() {
      java.lang.Object ref = exportFormatId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        exportFormatId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ARTIFACT_DESTINATION_FIELD_NUMBER = 3;
    private com.google.cloud.aiplatform.v1beta1.GcsDestination artifactDestination_;
    /**
     *
     *
     * <pre>
     * The Cloud Storage location where the Model artifact is to be
     * written to. Under the directory given as the destination a new one with
     * name "`model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;`",
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     * will be created. Inside, the Model and any of its supporting files
     * will be written.
     * This field should only be set when the `exportableContent` field of the
     * [Model.supported_export_formats] object contains `ARTIFACT`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination artifact_destination = 3;</code>
     *
     * @return Whether the artifactDestination field is set.
     */
    @java.lang.Override
    public boolean hasArtifactDestination() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location where the Model artifact is to be
     * written to. Under the directory given as the destination a new one with
     * name "`model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;`",
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     * will be created. Inside, the Model and any of its supporting files
     * will be written.
     * This field should only be set when the `exportableContent` field of the
     * [Model.supported_export_formats] object contains `ARTIFACT`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination artifact_destination = 3;</code>
     *
     * @return The artifactDestination.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsDestination getArtifactDestination() {
      return artifactDestination_ == null
          ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
          : artifactDestination_;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location where the Model artifact is to be
     * written to. Under the directory given as the destination a new one with
     * name "`model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;`",
     * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
     * will be created. Inside, the Model and any of its supporting files
     * will be written.
     * This field should only be set when the `exportableContent` field of the
     * [Model.supported_export_formats] object contains `ARTIFACT`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.GcsDestination artifact_destination = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
        getArtifactDestinationOrBuilder() {
      return artifactDestination_ == null
          ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
          : artifactDestination_;
    }

    public static final int IMAGE_DESTINATION_FIELD_NUMBER = 4;
    private com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination imageDestination_;
    /**
     *
     *
     * <pre>
     * The Google Container Registry or Artifact Registry uri where the
     * Model container image will be copied to.
     * This field should only be set when the `exportableContent` field of the
     * [Model.supported_export_formats] object contains `IMAGE`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination image_destination = 4;
     * </code>
     *
     * @return Whether the imageDestination field is set.
     */
    @java.lang.Override
    public boolean hasImageDestination() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Google Container Registry or Artifact Registry uri where the
     * Model container image will be copied to.
     * This field should only be set when the `exportableContent` field of the
     * [Model.supported_export_formats] object contains `IMAGE`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination image_destination = 4;
     * </code>
     *
     * @return The imageDestination.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination getImageDestination() {
      return imageDestination_ == null
          ? com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination.getDefaultInstance()
          : imageDestination_;
    }
    /**
     *
     *
     * <pre>
     * The Google Container Registry or Artifact Registry uri where the
     * Model container image will be copied to.
     * This field should only be set when the `exportableContent` field of the
     * [Model.supported_export_formats] object contains `IMAGE`.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination image_destination = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestinationOrBuilder
        getImageDestinationOrBuilder() {
      return imageDestination_ == null
          ? com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination.getDefaultInstance()
          : imageDestination_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(exportFormatId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, exportFormatId_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getArtifactDestination());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(4, getImageDestination());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(exportFormatId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, exportFormatId_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, getArtifactDestination());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getImageDestination());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig other =
          (com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig) obj;

      if (!getExportFormatId().equals(other.getExportFormatId())) return false;
      if (hasArtifactDestination() != other.hasArtifactDestination()) return false;
      if (hasArtifactDestination()) {
        if (!getArtifactDestination().equals(other.getArtifactDestination())) return false;
      }
      if (hasImageDestination() != other.hasImageDestination()) return false;
      if (hasImageDestination()) {
        if (!getImageDestination().equals(other.getImageDestination())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + EXPORT_FORMAT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getExportFormatId().hashCode();
      if (hasArtifactDestination()) {
        hash = (37 * hash) + ARTIFACT_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getArtifactDestination().hashCode();
      }
      if (hasImageDestination()) {
        hash = (37 * hash) + IMAGE_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getImageDestination().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Output configuration for the Model export.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig)
        com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ExportModelRequest_OutputConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ExportModelRequest_OutputConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig.class,
                com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getArtifactDestinationFieldBuilder();
          getImageDestinationFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        exportFormatId_ = "";
        artifactDestination_ = null;
        if (artifactDestinationBuilder_ != null) {
          artifactDestinationBuilder_.dispose();
          artifactDestinationBuilder_ = null;
        }
        imageDestination_ = null;
        if (imageDestinationBuilder_ != null) {
          imageDestinationBuilder_.dispose();
          imageDestinationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_ExportModelRequest_OutputConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig build() {
        com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig result =
            new com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.exportFormatId_ = exportFormatId_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.artifactDestination_ =
              artifactDestinationBuilder_ == null
                  ? artifactDestination_
                  : artifactDestinationBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.imageDestination_ =
              imageDestinationBuilder_ == null
                  ? imageDestination_
                  : imageDestinationBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig
                .getDefaultInstance()) return this;
        if (!other.getExportFormatId().isEmpty()) {
          exportFormatId_ = other.exportFormatId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasArtifactDestination()) {
          mergeArtifactDestination(other.getArtifactDestination());
        }
        if (other.hasImageDestination()) {
          mergeImageDestination(other.getImageDestination());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  exportFormatId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 26:
                {
                  input.readMessage(
                      getArtifactDestinationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getImageDestinationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object exportFormatId_ = "";
      /**
       *
       *
       * <pre>
       * The ID of the format in which the Model must be exported. Each Model
       * lists the [export formats it
       * supports][google.cloud.aiplatform.v1beta1.Model.supported_export_formats].
       * If no value is provided here, then the first from the list of the Model's
       * supported formats is used by default.
       * </pre>
       *
       * <code>string export_format_id = 1;</code>
       *
       * @return The exportFormatId.
       */
      public java.lang.String getExportFormatId() {
        java.lang.Object ref = exportFormatId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          exportFormatId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the format in which the Model must be exported. Each Model
       * lists the [export formats it
       * supports][google.cloud.aiplatform.v1beta1.Model.supported_export_formats].
       * If no value is provided here, then the first from the list of the Model's
       * supported formats is used by default.
       * </pre>
       *
       * <code>string export_format_id = 1;</code>
       *
       * @return The bytes for exportFormatId.
       */
      public com.google.protobuf.ByteString getExportFormatIdBytes() {
        java.lang.Object ref = exportFormatId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          exportFormatId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the format in which the Model must be exported. Each Model
       * lists the [export formats it
       * supports][google.cloud.aiplatform.v1beta1.Model.supported_export_formats].
       * If no value is provided here, then the first from the list of the Model's
       * supported formats is used by default.
       * </pre>
       *
       * <code>string export_format_id = 1;</code>
       *
       * @param value The exportFormatId to set.
       * @return This builder for chaining.
       */
      public Builder setExportFormatId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        exportFormatId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the format in which the Model must be exported. Each Model
       * lists the [export formats it
       * supports][google.cloud.aiplatform.v1beta1.Model.supported_export_formats].
       * If no value is provided here, then the first from the list of the Model's
       * supported formats is used by default.
       * </pre>
       *
       * <code>string export_format_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExportFormatId() {
        exportFormatId_ = getDefaultInstance().getExportFormatId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the format in which the Model must be exported. Each Model
       * lists the [export formats it
       * supports][google.cloud.aiplatform.v1beta1.Model.supported_export_formats].
       * If no value is provided here, then the first from the list of the Model's
       * supported formats is used by default.
       * </pre>
       *
       * <code>string export_format_id = 1;</code>
       *
       * @param value The bytes for exportFormatId to set.
       * @return This builder for chaining.
       */
      public Builder setExportFormatIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        exportFormatId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1beta1.GcsDestination artifactDestination_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GcsDestination,
              com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
              com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
          artifactDestinationBuilder_;
      /**
       *
       *
       * <pre>
       * The Cloud Storage location where the Model artifact is to be
       * written to. Under the directory given as the destination a new one with
       * name "`model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;`",
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
       * will be created. Inside, the Model and any of its supporting files
       * will be written.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `ARTIFACT`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination artifact_destination = 3;</code>
       *
       * @return Whether the artifactDestination field is set.
       */
      public boolean hasArtifactDestination() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location where the Model artifact is to be
       * written to. Under the directory given as the destination a new one with
       * name "`model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;`",
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
       * will be created. Inside, the Model and any of its supporting files
       * will be written.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `ARTIFACT`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination artifact_destination = 3;</code>
       *
       * @return The artifactDestination.
       */
      public com.google.cloud.aiplatform.v1beta1.GcsDestination getArtifactDestination() {
        if (artifactDestinationBuilder_ == null) {
          return artifactDestination_ == null
              ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
              : artifactDestination_;
        } else {
          return artifactDestinationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location where the Model artifact is to be
       * written to. Under the directory given as the destination a new one with
       * name "`model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;`",
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
       * will be created. Inside, the Model and any of its supporting files
       * will be written.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `ARTIFACT`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination artifact_destination = 3;</code>
       */
      public Builder setArtifactDestination(
          com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
        if (artifactDestinationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          artifactDestination_ = value;
        } else {
          artifactDestinationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location where the Model artifact is to be
       * written to. Under the directory given as the destination a new one with
       * name "`model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;`",
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
       * will be created. Inside, the Model and any of its supporting files
       * will be written.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `ARTIFACT`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination artifact_destination = 3;</code>
       */
      public Builder setArtifactDestination(
          com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder builderForValue) {
        if (artifactDestinationBuilder_ == null) {
          artifactDestination_ = builderForValue.build();
        } else {
          artifactDestinationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location where the Model artifact is to be
       * written to. Under the directory given as the destination a new one with
       * name "`model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;`",
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
       * will be created. Inside, the Model and any of its supporting files
       * will be written.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `ARTIFACT`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination artifact_destination = 3;</code>
       */
      public Builder mergeArtifactDestination(
          com.google.cloud.aiplatform.v1beta1.GcsDestination value) {
        if (artifactDestinationBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && artifactDestination_ != null
              && artifactDestination_
                  != com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()) {
            getArtifactDestinationBuilder().mergeFrom(value);
          } else {
            artifactDestination_ = value;
          }
        } else {
          artifactDestinationBuilder_.mergeFrom(value);
        }
        if (artifactDestination_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location where the Model artifact is to be
       * written to. Under the directory given as the destination a new one with
       * name "`model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;`",
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
       * will be created. Inside, the Model and any of its supporting files
       * will be written.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `ARTIFACT`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination artifact_destination = 3;</code>
       */
      public Builder clearArtifactDestination() {
        bitField0_ = (bitField0_ & ~0x00000002);
        artifactDestination_ = null;
        if (artifactDestinationBuilder_ != null) {
          artifactDestinationBuilder_.dispose();
          artifactDestinationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location where the Model artifact is to be
       * written to. Under the directory given as the destination a new one with
       * name "`model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;`",
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
       * will be created. Inside, the Model and any of its supporting files
       * will be written.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `ARTIFACT`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination artifact_destination = 3;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder
          getArtifactDestinationBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getArtifactDestinationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location where the Model artifact is to be
       * written to. Under the directory given as the destination a new one with
       * name "`model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;`",
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
       * will be created. Inside, the Model and any of its supporting files
       * will be written.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `ARTIFACT`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination artifact_destination = 3;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder
          getArtifactDestinationOrBuilder() {
        if (artifactDestinationBuilder_ != null) {
          return artifactDestinationBuilder_.getMessageOrBuilder();
        } else {
          return artifactDestination_ == null
              ? com.google.cloud.aiplatform.v1beta1.GcsDestination.getDefaultInstance()
              : artifactDestination_;
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location where the Model artifact is to be
       * written to. Under the directory given as the destination a new one with
       * name "`model-export-&lt;model-display-name&gt;-&lt;timestamp-of-export-call&gt;`",
       * where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format,
       * will be created. Inside, the Model and any of its supporting files
       * will be written.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `ARTIFACT`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.GcsDestination artifact_destination = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.GcsDestination,
              com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
              com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>
          getArtifactDestinationFieldBuilder() {
        if (artifactDestinationBuilder_ == null) {
          artifactDestinationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.GcsDestination,
                  com.google.cloud.aiplatform.v1beta1.GcsDestination.Builder,
                  com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder>(
                  getArtifactDestination(), getParentForChildren(), isClean());
          artifactDestination_ = null;
        }
        return artifactDestinationBuilder_;
      }

      private com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination imageDestination_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination,
              com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination.Builder,
              com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestinationOrBuilder>
          imageDestinationBuilder_;
      /**
       *
       *
       * <pre>
       * The Google Container Registry or Artifact Registry uri where the
       * Model container image will be copied to.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `IMAGE`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination image_destination = 4;
       * </code>
       *
       * @return Whether the imageDestination field is set.
       */
      public boolean hasImageDestination() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The Google Container Registry or Artifact Registry uri where the
       * Model container image will be copied to.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `IMAGE`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination image_destination = 4;
       * </code>
       *
       * @return The imageDestination.
       */
      public com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination
          getImageDestination() {
        if (imageDestinationBuilder_ == null) {
          return imageDestination_ == null
              ? com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination
                  .getDefaultInstance()
              : imageDestination_;
        } else {
          return imageDestinationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The Google Container Registry or Artifact Registry uri where the
       * Model container image will be copied to.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `IMAGE`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination image_destination = 4;
       * </code>
       */
      public Builder setImageDestination(
          com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination value) {
        if (imageDestinationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          imageDestination_ = value;
        } else {
          imageDestinationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Google Container Registry or Artifact Registry uri where the
       * Model container image will be copied to.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `IMAGE`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination image_destination = 4;
       * </code>
       */
      public Builder setImageDestination(
          com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination.Builder
              builderForValue) {
        if (imageDestinationBuilder_ == null) {
          imageDestination_ = builderForValue.build();
        } else {
          imageDestinationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Google Container Registry or Artifact Registry uri where the
       * Model container image will be copied to.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `IMAGE`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination image_destination = 4;
       * </code>
       */
      public Builder mergeImageDestination(
          com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination value) {
        if (imageDestinationBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && imageDestination_ != null
              && imageDestination_
                  != com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination
                      .getDefaultInstance()) {
            getImageDestinationBuilder().mergeFrom(value);
          } else {
            imageDestination_ = value;
          }
        } else {
          imageDestinationBuilder_.mergeFrom(value);
        }
        if (imageDestination_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Google Container Registry or Artifact Registry uri where the
       * Model container image will be copied to.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `IMAGE`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination image_destination = 4;
       * </code>
       */
      public Builder clearImageDestination() {
        bitField0_ = (bitField0_ & ~0x00000004);
        imageDestination_ = null;
        if (imageDestinationBuilder_ != null) {
          imageDestinationBuilder_.dispose();
          imageDestinationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Google Container Registry or Artifact Registry uri where the
       * Model container image will be copied to.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `IMAGE`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination image_destination = 4;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination.Builder
          getImageDestinationBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getImageDestinationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The Google Container Registry or Artifact Registry uri where the
       * Model container image will be copied to.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `IMAGE`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination image_destination = 4;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestinationOrBuilder
          getImageDestinationOrBuilder() {
        if (imageDestinationBuilder_ != null) {
          return imageDestinationBuilder_.getMessageOrBuilder();
        } else {
          return imageDestination_ == null
              ? com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination
                  .getDefaultInstance()
              : imageDestination_;
        }
      }
      /**
       *
       *
       * <pre>
       * The Google Container Registry or Artifact Registry uri where the
       * Model container image will be copied to.
       * This field should only be set when the `exportableContent` field of the
       * [Model.supported_export_formats] object contains `IMAGE`.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination image_destination = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination,
              com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination.Builder,
              com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestinationOrBuilder>
          getImageDestinationFieldBuilder() {
        if (imageDestinationBuilder_ == null) {
          imageDestinationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination,
                  com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestination.Builder,
                  com.google.cloud.aiplatform.v1beta1.ContainerRegistryDestinationOrBuilder>(
                  getImageDestination(), getParentForChildren(), isClean());
          imageDestination_ = null;
        }
        return imageDestinationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig)
    private static final com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig();
    }

    public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OutputConfig> PARSER =
        new com.google.protobuf.AbstractParser<OutputConfig>() {
          @java.lang.Override
          public OutputConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OutputConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OutputConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Model to export.
   * The resource name may contain version id or version alias to specify the
   * version, if no version is specified, the default version will be exported.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Model to export.
   * The resource name may contain version id or version alias to specify the
   * version, if no version is specified, the default version will be exported.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OUTPUT_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig outputConfig_;
  /**
   *
   *
   * <pre>
   * Required. The desired output location and configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the outputConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The desired output location and configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The outputConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig getOutputConfig() {
    return outputConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig.getDefaultInstance()
        : outputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. The desired output location and configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfigOrBuilder
      getOutputConfigOrBuilder() {
    return outputConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig.getDefaultInstance()
        : outputConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getOutputConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOutputConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ExportModelRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ExportModelRequest other =
        (com.google.cloud.aiplatform.v1beta1.ExportModelRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasOutputConfig() != other.hasOutputConfig()) return false;
    if (hasOutputConfig()) {
      if (!getOutputConfig().equals(other.getOutputConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasOutputConfig()) {
      hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.ExportModelRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [ModelService.ExportModel][google.cloud.aiplatform.v1beta1.ModelService.ExportModel].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ExportModelRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ExportModelRequest)
      com.google.cloud.aiplatform.v1beta1.ExportModelRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExportModelRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExportModelRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ExportModelRequest.class,
              com.google.cloud.aiplatform.v1beta1.ExportModelRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ExportModelRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOutputConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_ExportModelRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExportModelRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ExportModelRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExportModelRequest build() {
      com.google.cloud.aiplatform.v1beta1.ExportModelRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExportModelRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ExportModelRequest result =
          new com.google.cloud.aiplatform.v1beta1.ExportModelRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ExportModelRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.outputConfig_ =
            outputConfigBuilder_ == null ? outputConfig_ : outputConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ExportModelRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ExportModelRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ExportModelRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ExportModelRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasOutputConfig()) {
        mergeOutputConfig(other.getOutputConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getOutputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model to export.
     * The resource name may contain version id or version alias to specify the
     * version, if no version is specified, the default version will be exported.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model to export.
     * The resource name may contain version id or version alias to specify the
     * version, if no version is specified, the default version will be exported.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model to export.
     * The resource name may contain version id or version alias to specify the
     * version, if no version is specified, the default version will be exported.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model to export.
     * The resource name may contain version id or version alias to specify the
     * version, if no version is specified, the default version will be exported.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Model to export.
     * The resource name may contain version id or version alias to specify the
     * version, if no version is specified, the default version will be exported.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig outputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig,
            com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfigOrBuilder>
        outputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The desired output location and configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the outputConfig field is set.
     */
    public boolean hasOutputConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The desired output location and configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The outputConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig getOutputConfig() {
      if (outputConfigBuilder_ == null) {
        return outputConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig
                .getDefaultInstance()
            : outputConfig_;
      } else {
        return outputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The desired output location and configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(
        com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputConfig_ = value;
      } else {
        outputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired output location and configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(
        com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig.Builder
            builderForValue) {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = builderForValue.build();
      } else {
        outputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired output location and configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeOutputConfig(
        com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && outputConfig_ != null
            && outputConfig_
                != com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig
                    .getDefaultInstance()) {
          getOutputConfigBuilder().mergeFrom(value);
        } else {
          outputConfig_ = value;
        }
      } else {
        outputConfigBuilder_.mergeFrom(value);
      }
      if (outputConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired output location and configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearOutputConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired output location and configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig.Builder
        getOutputConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The desired output location and configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfigOrBuilder
        getOutputConfigOrBuilder() {
      if (outputConfigBuilder_ != null) {
        return outputConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig
                .getDefaultInstance()
            : outputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The desired output location and configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig,
            com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfigOrBuilder>
        getOutputConfigFieldBuilder() {
      if (outputConfigBuilder_ == null) {
        outputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig,
                com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.ExportModelRequest.OutputConfigOrBuilder>(
                getOutputConfig(), getParentForChildren(), isClean());
        outputConfig_ = null;
      }
      return outputConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ExportModelRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ExportModelRequest)
  private static final com.google.cloud.aiplatform.v1beta1.ExportModelRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ExportModelRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.ExportModelRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportModelRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExportModelRequest>() {
        @java.lang.Override
        public ExportModelRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExportModelRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportModelRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExportModelRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
