/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ModelDeploymentMonitoringJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_MODEL_DEPLOYMENT_MONITORING_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String modelDeploymentMonitoringJob;

    @Deprecated
    protected ModelDeploymentMonitoringJobName() {
        this.project = null;
        this.location = null;
        this.modelDeploymentMonitoringJob = null;
    }

    private ModelDeploymentMonitoringJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.modelDeploymentMonitoringJob = (String)Preconditions.checkNotNull((Object)builder.getModelDeploymentMonitoringJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getModelDeploymentMonitoringJob() {
        return this.modelDeploymentMonitoringJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ModelDeploymentMonitoringJobName of(String project, String location, String modelDeploymentMonitoringJob) {
        return ModelDeploymentMonitoringJobName.newBuilder().setProject(project).setLocation(location).setModelDeploymentMonitoringJob(modelDeploymentMonitoringJob).build();
    }

    public static String format(String project, String location, String modelDeploymentMonitoringJob) {
        return ModelDeploymentMonitoringJobName.newBuilder().setProject(project).setLocation(location).setModelDeploymentMonitoringJob(modelDeploymentMonitoringJob).build().toString();
    }

    public static ModelDeploymentMonitoringJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_MODEL_DEPLOYMENT_MONITORING_JOB.validatedMatch(formattedString, "ModelDeploymentMonitoringJobName.parse: formattedString not in valid format");
        return ModelDeploymentMonitoringJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("model_deployment_monitoring_job"));
    }

    public static List<ModelDeploymentMonitoringJobName> parseList(List<String> formattedStrings) {
        ArrayList<ModelDeploymentMonitoringJobName> list = new ArrayList<ModelDeploymentMonitoringJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ModelDeploymentMonitoringJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ModelDeploymentMonitoringJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ModelDeploymentMonitoringJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_MODEL_DEPLOYMENT_MONITORING_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ModelDeploymentMonitoringJobName modelDeploymentMonitoringJobName = this;
            synchronized (modelDeploymentMonitoringJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.modelDeploymentMonitoringJob != null) {
                        fieldMapBuilder.put((Object)"model_deployment_monitoring_job", (Object)this.modelDeploymentMonitoringJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_MODEL_DEPLOYMENT_MONITORING_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "model_deployment_monitoring_job", this.modelDeploymentMonitoringJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ModelDeploymentMonitoringJobName that = (ModelDeploymentMonitoringJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.modelDeploymentMonitoringJob, that.modelDeploymentMonitoringJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.modelDeploymentMonitoringJob);
    }

    public static class Builder {
        private String project;
        private String location;
        private String modelDeploymentMonitoringJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getModelDeploymentMonitoringJob() {
            return this.modelDeploymentMonitoringJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setModelDeploymentMonitoringJob(String modelDeploymentMonitoringJob) {
            this.modelDeploymentMonitoringJob = modelDeploymentMonitoringJob;
            return this;
        }

        private Builder(ModelDeploymentMonitoringJobName modelDeploymentMonitoringJobName) {
            this.project = modelDeploymentMonitoringJobName.project;
            this.location = modelDeploymentMonitoringJobName.location;
            this.modelDeploymentMonitoringJob = modelDeploymentMonitoringJobName.modelDeploymentMonitoringJob;
        }

        public ModelDeploymentMonitoringJobName build() {
            return new ModelDeploymentMonitoringJobName(this);
        }
    }
}

