/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/vizier_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Response message for
 * [VizierService.SuggestTrials][google.cloud.aiplatform.v1.VizierService.SuggestTrials].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.SuggestTrialsResponse}
 */
public final class SuggestTrialsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.SuggestTrialsResponse)
    SuggestTrialsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SuggestTrialsResponse.newBuilder() to construct.
  private SuggestTrialsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SuggestTrialsResponse() {
    trials_ = java.util.Collections.emptyList();
    studyState_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SuggestTrialsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.VizierServiceProto
        .internal_static_google_cloud_aiplatform_v1_SuggestTrialsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.VizierServiceProto
        .internal_static_google_cloud_aiplatform_v1_SuggestTrialsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.SuggestTrialsResponse.class,
            com.google.cloud.aiplatform.v1.SuggestTrialsResponse.Builder.class);
  }

  private int bitField0_;
  public static final int TRIALS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.Trial> trials_;
  /**
   *
   *
   * <pre>
   * A list of Trials.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.Trial> getTrialsList() {
    return trials_;
  }
  /**
   *
   *
   * <pre>
   * A list of Trials.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.TrialOrBuilder>
      getTrialsOrBuilderList() {
    return trials_;
  }
  /**
   *
   *
   * <pre>
   * A list of Trials.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
   */
  @java.lang.Override
  public int getTrialsCount() {
    return trials_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of Trials.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Trial getTrials(int index) {
    return trials_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of Trials.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.TrialOrBuilder getTrialsOrBuilder(int index) {
    return trials_.get(index);
  }

  public static final int STUDY_STATE_FIELD_NUMBER = 2;
  private int studyState_ = 0;
  /**
   *
   *
   * <pre>
   * The state of the Study.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Study.State study_state = 2;</code>
   *
   * @return The enum numeric value on the wire for studyState.
   */
  @java.lang.Override
  public int getStudyStateValue() {
    return studyState_;
  }
  /**
   *
   *
   * <pre>
   * The state of the Study.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Study.State study_state = 2;</code>
   *
   * @return The studyState.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Study.State getStudyState() {
    com.google.cloud.aiplatform.v1.Study.State result =
        com.google.cloud.aiplatform.v1.Study.State.forNumber(studyState_);
    return result == null ? com.google.cloud.aiplatform.v1.Study.State.UNRECOGNIZED : result;
  }

  public static final int START_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * The time at which the operation was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 3;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time at which the operation was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 3;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the operation was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The time at which operation processing completed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 4;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time at which operation processing completed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 4;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which operation processing completed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < trials_.size(); i++) {
      output.writeMessage(1, trials_.get(i));
    }
    if (studyState_ != com.google.cloud.aiplatform.v1.Study.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, studyState_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getEndTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < trials_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, trials_.get(i));
    }
    if (studyState_ != com.google.cloud.aiplatform.v1.Study.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, studyState_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getEndTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.SuggestTrialsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.SuggestTrialsResponse other =
        (com.google.cloud.aiplatform.v1.SuggestTrialsResponse) obj;

    if (!getTrialsList().equals(other.getTrialsList())) return false;
    if (studyState_ != other.studyState_) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getTrialsCount() > 0) {
      hash = (37 * hash) + TRIALS_FIELD_NUMBER;
      hash = (53 * hash) + getTrialsList().hashCode();
    }
    hash = (37 * hash) + STUDY_STATE_FIELD_NUMBER;
    hash = (53 * hash) + studyState_;
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.SuggestTrialsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [VizierService.SuggestTrials][google.cloud.aiplatform.v1.VizierService.SuggestTrials].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.SuggestTrialsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.SuggestTrialsResponse)
      com.google.cloud.aiplatform.v1.SuggestTrialsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VizierServiceProto
          .internal_static_google_cloud_aiplatform_v1_SuggestTrialsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VizierServiceProto
          .internal_static_google_cloud_aiplatform_v1_SuggestTrialsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.SuggestTrialsResponse.class,
              com.google.cloud.aiplatform.v1.SuggestTrialsResponse.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.SuggestTrialsResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTrialsFieldBuilder();
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (trialsBuilder_ == null) {
        trials_ = java.util.Collections.emptyList();
      } else {
        trials_ = null;
        trialsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      studyState_ = 0;
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.VizierServiceProto
          .internal_static_google_cloud_aiplatform_v1_SuggestTrialsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SuggestTrialsResponse getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.SuggestTrialsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SuggestTrialsResponse build() {
      com.google.cloud.aiplatform.v1.SuggestTrialsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SuggestTrialsResponse buildPartial() {
      com.google.cloud.aiplatform.v1.SuggestTrialsResponse result =
          new com.google.cloud.aiplatform.v1.SuggestTrialsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1.SuggestTrialsResponse result) {
      if (trialsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          trials_ = java.util.Collections.unmodifiableList(trials_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.trials_ = trials_;
      } else {
        result.trials_ = trialsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.SuggestTrialsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.studyState_ = studyState_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.SuggestTrialsResponse) {
        return mergeFrom((com.google.cloud.aiplatform.v1.SuggestTrialsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.SuggestTrialsResponse other) {
      if (other == com.google.cloud.aiplatform.v1.SuggestTrialsResponse.getDefaultInstance())
        return this;
      if (trialsBuilder_ == null) {
        if (!other.trials_.isEmpty()) {
          if (trials_.isEmpty()) {
            trials_ = other.trials_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTrialsIsMutable();
            trials_.addAll(other.trials_);
          }
          onChanged();
        }
      } else {
        if (!other.trials_.isEmpty()) {
          if (trialsBuilder_.isEmpty()) {
            trialsBuilder_.dispose();
            trialsBuilder_ = null;
            trials_ = other.trials_;
            bitField0_ = (bitField0_ & ~0x00000001);
            trialsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTrialsFieldBuilder()
                    : null;
          } else {
            trialsBuilder_.addAllMessages(other.trials_);
          }
        }
      }
      if (other.studyState_ != 0) {
        setStudyStateValue(other.getStudyStateValue());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1.Trial m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.Trial.parser(), extensionRegistry);
                if (trialsBuilder_ == null) {
                  ensureTrialsIsMutable();
                  trials_.add(m);
                } else {
                  trialsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 16:
              {
                studyState_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.aiplatform.v1.Trial> trials_ =
        java.util.Collections.emptyList();

    private void ensureTrialsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        trials_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1.Trial>(trials_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Trial,
            com.google.cloud.aiplatform.v1.Trial.Builder,
            com.google.cloud.aiplatform.v1.TrialOrBuilder>
        trialsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Trial> getTrialsList() {
      if (trialsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(trials_);
      } else {
        return trialsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public int getTrialsCount() {
      if (trialsBuilder_ == null) {
        return trials_.size();
      } else {
        return trialsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.Trial getTrials(int index) {
      if (trialsBuilder_ == null) {
        return trials_.get(index);
      } else {
        return trialsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public Builder setTrials(int index, com.google.cloud.aiplatform.v1.Trial value) {
      if (trialsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrialsIsMutable();
        trials_.set(index, value);
        onChanged();
      } else {
        trialsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public Builder setTrials(
        int index, com.google.cloud.aiplatform.v1.Trial.Builder builderForValue) {
      if (trialsBuilder_ == null) {
        ensureTrialsIsMutable();
        trials_.set(index, builderForValue.build());
        onChanged();
      } else {
        trialsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public Builder addTrials(com.google.cloud.aiplatform.v1.Trial value) {
      if (trialsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrialsIsMutable();
        trials_.add(value);
        onChanged();
      } else {
        trialsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public Builder addTrials(int index, com.google.cloud.aiplatform.v1.Trial value) {
      if (trialsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrialsIsMutable();
        trials_.add(index, value);
        onChanged();
      } else {
        trialsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public Builder addTrials(com.google.cloud.aiplatform.v1.Trial.Builder builderForValue) {
      if (trialsBuilder_ == null) {
        ensureTrialsIsMutable();
        trials_.add(builderForValue.build());
        onChanged();
      } else {
        trialsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public Builder addTrials(
        int index, com.google.cloud.aiplatform.v1.Trial.Builder builderForValue) {
      if (trialsBuilder_ == null) {
        ensureTrialsIsMutable();
        trials_.add(index, builderForValue.build());
        onChanged();
      } else {
        trialsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public Builder addAllTrials(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.Trial> values) {
      if (trialsBuilder_ == null) {
        ensureTrialsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, trials_);
        onChanged();
      } else {
        trialsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public Builder clearTrials() {
      if (trialsBuilder_ == null) {
        trials_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        trialsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public Builder removeTrials(int index) {
      if (trialsBuilder_ == null) {
        ensureTrialsIsMutable();
        trials_.remove(index);
        onChanged();
      } else {
        trialsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.Trial.Builder getTrialsBuilder(int index) {
      return getTrialsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.TrialOrBuilder getTrialsOrBuilder(int index) {
      if (trialsBuilder_ == null) {
        return trials_.get(index);
      } else {
        return trialsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.TrialOrBuilder>
        getTrialsOrBuilderList() {
      if (trialsBuilder_ != null) {
        return trialsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(trials_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.Trial.Builder addTrialsBuilder() {
      return getTrialsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.Trial.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public com.google.cloud.aiplatform.v1.Trial.Builder addTrialsBuilder(int index) {
      return getTrialsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.Trial.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of Trials.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.Trial trials = 1;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.Trial.Builder> getTrialsBuilderList() {
      return getTrialsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Trial,
            com.google.cloud.aiplatform.v1.Trial.Builder,
            com.google.cloud.aiplatform.v1.TrialOrBuilder>
        getTrialsFieldBuilder() {
      if (trialsBuilder_ == null) {
        trialsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Trial,
                com.google.cloud.aiplatform.v1.Trial.Builder,
                com.google.cloud.aiplatform.v1.TrialOrBuilder>(
                trials_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        trials_ = null;
      }
      return trialsBuilder_;
    }

    private int studyState_ = 0;
    /**
     *
     *
     * <pre>
     * The state of the Study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Study.State study_state = 2;</code>
     *
     * @return The enum numeric value on the wire for studyState.
     */
    @java.lang.Override
    public int getStudyStateValue() {
      return studyState_;
    }
    /**
     *
     *
     * <pre>
     * The state of the Study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Study.State study_state = 2;</code>
     *
     * @param value The enum numeric value on the wire for studyState to set.
     * @return This builder for chaining.
     */
    public Builder setStudyStateValue(int value) {
      studyState_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the Study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Study.State study_state = 2;</code>
     *
     * @return The studyState.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Study.State getStudyState() {
      com.google.cloud.aiplatform.v1.Study.State result =
          com.google.cloud.aiplatform.v1.Study.State.forNumber(studyState_);
      return result == null ? com.google.cloud.aiplatform.v1.Study.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The state of the Study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Study.State study_state = 2;</code>
     *
     * @param value The studyState to set.
     * @return This builder for chaining.
     */
    public Builder setStudyState(com.google.cloud.aiplatform.v1.Study.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      studyState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the Study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Study.State study_state = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStudyState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      studyState_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which operation processing completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which operation processing completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which operation processing completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which operation processing completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which operation processing completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which operation processing completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which operation processing completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which operation processing completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which operation processing completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.SuggestTrialsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.SuggestTrialsResponse)
  private static final com.google.cloud.aiplatform.v1.SuggestTrialsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.SuggestTrialsResponse();
  }

  public static com.google.cloud.aiplatform.v1.SuggestTrialsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SuggestTrialsResponse> PARSER =
      new com.google.protobuf.AbstractParser<SuggestTrialsResponse>() {
        @java.lang.Override
        public SuggestTrialsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SuggestTrialsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SuggestTrialsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SuggestTrialsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
