/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/model_evaluation_slice.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * A collection of metrics calculated by comparing Model's predictions on a
 * slice of the test data against ground truth annotations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.ModelEvaluationSlice}
 */
public final class ModelEvaluationSlice extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ModelEvaluationSlice)
    ModelEvaluationSliceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModelEvaluationSlice.newBuilder() to construct.
  private ModelEvaluationSlice(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelEvaluationSlice() {
    name_ = "";
    metricsSchemaUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelEvaluationSlice();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
        .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
        .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.class,
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Builder.class);
  }

  public interface SliceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The dimension of the slice.
     * Well-known dimensions are:
     *   * `annotationSpec`: This slice is on the test data that has either
     *     ground truth or prediction with
     *     [AnnotationSpec.display_name][google.cloud.aiplatform.v1.AnnotationSpec.display_name]
     *     equals to
     *     [value][google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.value].
     *   * `slice`: This slice is a user customized slice defined by its
     *     SliceSpec.
     * </pre>
     *
     * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The dimension.
     */
    java.lang.String getDimension();
    /**
     *
     *
     * <pre>
     * Output only. The dimension of the slice.
     * Well-known dimensions are:
     *   * `annotationSpec`: This slice is on the test data that has either
     *     ground truth or prediction with
     *     [AnnotationSpec.display_name][google.cloud.aiplatform.v1.AnnotationSpec.display_name]
     *     equals to
     *     [value][google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.value].
     *   * `slice`: This slice is a user customized slice defined by its
     *     SliceSpec.
     * </pre>
     *
     * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for dimension.
     */
    com.google.protobuf.ByteString getDimensionBytes();

    /**
     *
     *
     * <pre>
     * Output only. The value of the dimension in this slice.
     * </pre>
     *
     * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The value.
     */
    java.lang.String getValue();
    /**
     *
     *
     * <pre>
     * Output only. The value of the dimension in this slice.
     * </pre>
     *
     * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString getValueBytes();

    /**
     *
     *
     * <pre>
     * Output only. Specification for how the data was sliced.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec slice_spec = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the sliceSpec field is set.
     */
    boolean hasSliceSpec();
    /**
     *
     *
     * <pre>
     * Output only. Specification for how the data was sliced.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec slice_spec = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The sliceSpec.
     */
    com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec getSliceSpec();
    /**
     *
     *
     * <pre>
     * Output only. Specification for how the data was sliced.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec slice_spec = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpecOrBuilder
        getSliceSpecOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Definition of a slice.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice}
   */
  public static final class Slice extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice)
      SliceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Slice.newBuilder() to construct.
    private Slice(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Slice() {
      dimension_ = "";
      value_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Slice();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
          .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
          .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.class,
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.Builder.class);
    }

    public interface SliceSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Mapping configuration for this SliceSpec.
       * The key is the name of the feature.
       * By default, the key will be prefixed by "instance" as a dictionary
       * prefix for Vertex Batch Predictions output format.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
       * </code>
       */
      int getConfigsCount();
      /**
       *
       *
       * <pre>
       * Mapping configuration for this SliceSpec.
       * The key is the name of the feature.
       * By default, the key will be prefixed by "instance" as a dictionary
       * prefix for Vertex Batch Predictions output format.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
       * </code>
       */
      boolean containsConfigs(java.lang.String key);
      /** Use {@link #getConfigsMap()} instead. */
      @java.lang.Deprecated
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
          getConfigs();
      /**
       *
       *
       * <pre>
       * Mapping configuration for this SliceSpec.
       * The key is the name of the feature.
       * By default, the key will be prefixed by "instance" as a dictionary
       * prefix for Vertex Batch Predictions output format.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
       * </code>
       */
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
          getConfigsMap();
      /**
       *
       *
       * <pre>
       * Mapping configuration for this SliceSpec.
       * The key is the name of the feature.
       * By default, the key will be prefixed by "instance" as a dictionary
       * prefix for Vertex Batch Predictions output format.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
       * </code>
       */
      /* nullable */
      com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
          getConfigsOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                  defaultValue);
      /**
       *
       *
       * <pre>
       * Mapping configuration for this SliceSpec.
       * The key is the name of the feature.
       * By default, the key will be prefixed by "instance" as a dictionary
       * prefix for Vertex Batch Predictions output format.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
       * </code>
       */
      com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
          getConfigsOrThrow(java.lang.String key);
    }
    /**
     *
     *
     * <pre>
     * Specification for how the data should be sliced.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec}
     */
    public static final class SliceSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec)
        SliceSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SliceSpec.newBuilder() to construct.
      private SliceSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SliceSpec() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SliceSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
            .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      @java.lang.Override
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 1:
            return internalGetConfigs();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
            .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.class,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Builder.class);
      }

      public interface SliceConfigOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * A unique specific value for a given feature.
         * Example: `{ "value": { "string_value": "12345" } }`
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value = 1;
         * </code>
         *
         * @return Whether the value field is set.
         */
        boolean hasValue();
        /**
         *
         *
         * <pre>
         * A unique specific value for a given feature.
         * Example: `{ "value": { "string_value": "12345" } }`
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value = 1;
         * </code>
         *
         * @return The value.
         */
        com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value getValue();
        /**
         *
         *
         * <pre>
         * A unique specific value for a given feature.
         * Example: `{ "value": { "string_value": "12345" } }`
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value = 1;
         * </code>
         */
        com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.ValueOrBuilder
            getValueOrBuilder();

        /**
         *
         *
         * <pre>
         * A range of values for a numerical feature.
         * Example: `{"range":{"low":10000.0,"high":50000.0}}`
         * will capture 12345 and 23334 in the slice.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range range = 2;
         * </code>
         *
         * @return Whether the range field is set.
         */
        boolean hasRange();
        /**
         *
         *
         * <pre>
         * A range of values for a numerical feature.
         * Example: `{"range":{"low":10000.0,"high":50000.0}}`
         * will capture 12345 and 23334 in the slice.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range range = 2;
         * </code>
         *
         * @return The range.
         */
        com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range getRange();
        /**
         *
         *
         * <pre>
         * A range of values for a numerical feature.
         * Example: `{"range":{"low":10000.0,"high":50000.0}}`
         * will capture 12345 and 23334 in the slice.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range range = 2;
         * </code>
         */
        com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.RangeOrBuilder
            getRangeOrBuilder();

        /**
         *
         *
         * <pre>
         * If all_values is set to true, then all possible labels of the keyed
         * feature will have another slice computed.
         * Example: `{"all_values":{"value":true}}`
         * </pre>
         *
         * <code>.google.protobuf.BoolValue all_values = 3;</code>
         *
         * @return Whether the allValues field is set.
         */
        boolean hasAllValues();
        /**
         *
         *
         * <pre>
         * If all_values is set to true, then all possible labels of the keyed
         * feature will have another slice computed.
         * Example: `{"all_values":{"value":true}}`
         * </pre>
         *
         * <code>.google.protobuf.BoolValue all_values = 3;</code>
         *
         * @return The allValues.
         */
        com.google.protobuf.BoolValue getAllValues();
        /**
         *
         *
         * <pre>
         * If all_values is set to true, then all possible labels of the keyed
         * feature will have another slice computed.
         * Example: `{"all_values":{"value":true}}`
         * </pre>
         *
         * <code>.google.protobuf.BoolValue all_values = 3;</code>
         */
        com.google.protobuf.BoolValueOrBuilder getAllValuesOrBuilder();

        com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig.KindCase
            getKindCase();
      }
      /**
       *
       *
       * <pre>
       * Specification message containing the config for this SliceSpec.
       * When `kind` is selected as `value` and/or `range`, only a single slice
       * will be computed.
       * When `all_values` is present, a separate slice will be computed for
       * each possible label/value for the corresponding key in `config`.
       * Examples, with feature zip_code with values 12345, 23334, 88888 and
       * feature country with values "US", "Canada", "Mexico" in the dataset:
       *
       * Example 1:
       *
       *     {
       *       "zip_code": { "value": { "float_value": 12345.0 } }
       *     }
       *
       * A single slice for any data with zip_code 12345 in the dataset.
       *
       * Example 2:
       *
       *     {
       *       "zip_code": { "range": { "low": 12345, "high": 20000 } }
       *     }
       *
       * A single slice containing data where the zip_codes between 12345 and
       * 20000 For this example, data with the zip_code of 12345 will be in this
       * slice.
       *
       * Example 3:
       *
       *     {
       *       "zip_code": { "range": { "low": 10000, "high": 20000 } },
       *       "country": { "value": { "string_value": "US" } }
       *     }
       *
       * A single slice containing data where the zip_codes between 10000 and
       * 20000 has the country "US". For this example, data with the zip_code of
       * 12345 and country "US" will be in this slice.
       *
       * Example 4:
       *
       *     { "country": {"all_values": { "value": true } } }
       *
       * Three slices are computed, one for each unique country in the dataset.
       *
       * Example 5:
       *
       *     {
       *       "country": { "all_values": { "value": true } },
       *       "zip_code": { "value": { "float_value": 12345.0 } }
       *     }
       *
       * Three slices are computed, one for each unique country in the dataset
       * where the zip_code is also 12345. For this example, data with zip_code
       * 12345 and country "US" will be in one slice, zip_code 12345 and country
       * "Canada" in another slice, and zip_code 12345 and country "Mexico" in
       * another slice, totaling 3 slices.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig}
       */
      public static final class SliceConfig extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig)
          SliceConfigOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use SliceConfig.newBuilder() to construct.
        private SliceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private SliceConfig() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new SliceConfig();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
              .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
              .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                      .class,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                      .Builder.class);
        }

        private int kindCase_ = 0;

        @SuppressWarnings("serial")
        private java.lang.Object kind_;

        public enum KindCase
            implements
                com.google.protobuf.Internal.EnumLite,
                com.google.protobuf.AbstractMessage.InternalOneOfEnum {
          VALUE(1),
          RANGE(2),
          ALL_VALUES(3),
          KIND_NOT_SET(0);
          private final int value;

          private KindCase(int value) {
            this.value = value;
          }
          /**
           * @param value The number of the enum to look for.
           * @return The enum associated with the given number.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static KindCase valueOf(int value) {
            return forNumber(value);
          }

          public static KindCase forNumber(int value) {
            switch (value) {
              case 1:
                return VALUE;
              case 2:
                return RANGE;
              case 3:
                return ALL_VALUES;
              case 0:
                return KIND_NOT_SET;
              default:
                return null;
            }
          }

          public int getNumber() {
            return this.value;
          }
        };

        public KindCase getKindCase() {
          return KindCase.forNumber(kindCase_);
        }

        public static final int VALUE_FIELD_NUMBER = 1;
        /**
         *
         *
         * <pre>
         * A unique specific value for a given feature.
         * Example: `{ "value": { "string_value": "12345" } }`
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value = 1;
         * </code>
         *
         * @return Whether the value field is set.
         */
        @java.lang.Override
        public boolean hasValue() {
          return kindCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * A unique specific value for a given feature.
         * Example: `{ "value": { "string_value": "12345" } }`
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value = 1;
         * </code>
         *
         * @return The value.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
            getValue() {
          if (kindCase_ == 1) {
            return (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value)
                kind_;
          }
          return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
              .getDefaultInstance();
        }
        /**
         *
         *
         * <pre>
         * A unique specific value for a given feature.
         * Example: `{ "value": { "string_value": "12345" } }`
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.ValueOrBuilder
            getValueOrBuilder() {
          if (kindCase_ == 1) {
            return (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value)
                kind_;
          }
          return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
              .getDefaultInstance();
        }

        public static final int RANGE_FIELD_NUMBER = 2;
        /**
         *
         *
         * <pre>
         * A range of values for a numerical feature.
         * Example: `{"range":{"low":10000.0,"high":50000.0}}`
         * will capture 12345 and 23334 in the slice.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range range = 2;
         * </code>
         *
         * @return Whether the range field is set.
         */
        @java.lang.Override
        public boolean hasRange() {
          return kindCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * A range of values for a numerical feature.
         * Example: `{"range":{"low":10000.0,"high":50000.0}}`
         * will capture 12345 and 23334 in the slice.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range range = 2;
         * </code>
         *
         * @return The range.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
            getRange() {
          if (kindCase_ == 2) {
            return (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range)
                kind_;
          }
          return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
              .getDefaultInstance();
        }
        /**
         *
         *
         * <pre>
         * A range of values for a numerical feature.
         * Example: `{"range":{"low":10000.0,"high":50000.0}}`
         * will capture 12345 and 23334 in the slice.
         * </pre>
         *
         * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range range = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.RangeOrBuilder
            getRangeOrBuilder() {
          if (kindCase_ == 2) {
            return (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range)
                kind_;
          }
          return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
              .getDefaultInstance();
        }

        public static final int ALL_VALUES_FIELD_NUMBER = 3;
        /**
         *
         *
         * <pre>
         * If all_values is set to true, then all possible labels of the keyed
         * feature will have another slice computed.
         * Example: `{"all_values":{"value":true}}`
         * </pre>
         *
         * <code>.google.protobuf.BoolValue all_values = 3;</code>
         *
         * @return Whether the allValues field is set.
         */
        @java.lang.Override
        public boolean hasAllValues() {
          return kindCase_ == 3;
        }
        /**
         *
         *
         * <pre>
         * If all_values is set to true, then all possible labels of the keyed
         * feature will have another slice computed.
         * Example: `{"all_values":{"value":true}}`
         * </pre>
         *
         * <code>.google.protobuf.BoolValue all_values = 3;</code>
         *
         * @return The allValues.
         */
        @java.lang.Override
        public com.google.protobuf.BoolValue getAllValues() {
          if (kindCase_ == 3) {
            return (com.google.protobuf.BoolValue) kind_;
          }
          return com.google.protobuf.BoolValue.getDefaultInstance();
        }
        /**
         *
         *
         * <pre>
         * If all_values is set to true, then all possible labels of the keyed
         * feature will have another slice computed.
         * Example: `{"all_values":{"value":true}}`
         * </pre>
         *
         * <code>.google.protobuf.BoolValue all_values = 3;</code>
         */
        @java.lang.Override
        public com.google.protobuf.BoolValueOrBuilder getAllValuesOrBuilder() {
          if (kindCase_ == 3) {
            return (com.google.protobuf.BoolValue) kind_;
          }
          return com.google.protobuf.BoolValue.getDefaultInstance();
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (kindCase_ == 1) {
            output.writeMessage(
                1,
                (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value) kind_);
          }
          if (kindCase_ == 2) {
            output.writeMessage(
                2,
                (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range) kind_);
          }
          if (kindCase_ == 3) {
            output.writeMessage(3, (com.google.protobuf.BoolValue) kind_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (kindCase_ == 1) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    1,
                    (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value)
                        kind_);
          }
          if (kindCase_ == 2) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    2,
                    (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range)
                        kind_);
          }
          if (kindCase_ == 3) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    3, (com.google.protobuf.BoolValue) kind_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig)) {
            return super.equals(obj);
          }
          com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig other =
              (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig) obj;

          if (!getKindCase().equals(other.getKindCase())) return false;
          switch (kindCase_) {
            case 1:
              if (!getValue().equals(other.getValue())) return false;
              break;
            case 2:
              if (!getRange().equals(other.getRange())) return false;
              break;
            case 3:
              if (!getAllValues().equals(other.getAllValues())) return false;
              break;
            case 0:
            default:
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          switch (kindCase_) {
            case 1:
              hash = (37 * hash) + VALUE_FIELD_NUMBER;
              hash = (53 * hash) + getValue().hashCode();
              break;
            case 2:
              hash = (37 * hash) + RANGE_FIELD_NUMBER;
              hash = (53 * hash) + getRange().hashCode();
              break;
            case 3:
              hash = (37 * hash) + ALL_VALUES_FIELD_NUMBER;
              hash = (53 * hash) + getAllValues().hashCode();
              break;
            case 0:
            default:
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfig
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfig
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfig
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfig
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfig
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfig
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfig
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfig
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfig
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfig
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfig
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfig
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Specification message containing the config for this SliceSpec.
         * When `kind` is selected as `value` and/or `range`, only a single slice
         * will be computed.
         * When `all_values` is present, a separate slice will be computed for
         * each possible label/value for the corresponding key in `config`.
         * Examples, with feature zip_code with values 12345, 23334, 88888 and
         * feature country with values "US", "Canada", "Mexico" in the dataset:
         *
         * Example 1:
         *
         *     {
         *       "zip_code": { "value": { "float_value": 12345.0 } }
         *     }
         *
         * A single slice for any data with zip_code 12345 in the dataset.
         *
         * Example 2:
         *
         *     {
         *       "zip_code": { "range": { "low": 12345, "high": 20000 } }
         *     }
         *
         * A single slice containing data where the zip_codes between 12345 and
         * 20000 For this example, data with the zip_code of 12345 will be in this
         * slice.
         *
         * Example 3:
         *
         *     {
         *       "zip_code": { "range": { "low": 10000, "high": 20000 } },
         *       "country": { "value": { "string_value": "US" } }
         *     }
         *
         * A single slice containing data where the zip_codes between 10000 and
         * 20000 has the country "US". For this example, data with the zip_code of
         * 12345 and country "US" will be in this slice.
         *
         * Example 4:
         *
         *     { "country": {"all_values": { "value": true } } }
         *
         * Three slices are computed, one for each unique country in the dataset.
         *
         * Example 5:
         *
         *     {
         *       "country": { "all_values": { "value": true } },
         *       "zip_code": { "value": { "float_value": 12345.0 } }
         *     }
         *
         * Three slices are computed, one for each unique country in the dataset
         * where the zip_code is also 12345. For this example, data with zip_code
         * 12345 and country "US" will be in one slice, zip_code 12345 and country
         * "Canada" in another slice, and zip_code 12345 and country "Mexico" in
         * another slice, totaling 3 slices.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig)
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfigOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
                .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
                .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                        .class,
                    com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                        .Builder.class);
          }

          // Construct using
          // com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            if (valueBuilder_ != null) {
              valueBuilder_.clear();
            }
            if (rangeBuilder_ != null) {
              rangeBuilder_.clear();
            }
            if (allValuesBuilder_ != null) {
              allValuesBuilder_.clear();
            }
            kindCase_ = 0;
            kind_ = null;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
                .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
              getDefaultInstanceForType() {
            return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
              build() {
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
              buildPartial() {
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig result =
                new com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig(
                    this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            buildPartialOneofs(result);
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                  result) {
            int from_bitField0_ = bitField0_;
          }

          private void buildPartialOneofs(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                  result) {
            result.kindCase_ = kindCase_;
            result.kind_ = this.kind_;
            if (kindCase_ == 1 && valueBuilder_ != null) {
              result.kind_ = valueBuilder_.build();
            }
            if (kindCase_ == 2 && rangeBuilder_ != null) {
              result.kind_ = rangeBuilder_.build();
            }
            if (kindCase_ == 3 && allValuesBuilder_ != null) {
              result.kind_ = allValuesBuilder_.build();
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig) {
              return mergeFrom(
                  (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                  other) {
            if (other
                == com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                    .getDefaultInstance()) return this;
            switch (other.getKindCase()) {
              case VALUE:
                {
                  mergeValue(other.getValue());
                  break;
                }
              case RANGE:
                {
                  mergeRange(other.getRange());
                  break;
                }
              case ALL_VALUES:
                {
                  mergeAllValues(other.getAllValues());
                  break;
                }
              case KIND_NOT_SET:
                {
                  break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(getValueFieldBuilder().getBuilder(), extensionRegistry);
                      kindCase_ = 1;
                      break;
                    } // case 10
                  case 18:
                    {
                      input.readMessage(getRangeFieldBuilder().getBuilder(), extensionRegistry);
                      kindCase_ = 2;
                      break;
                    } // case 18
                  case 26:
                    {
                      input.readMessage(getAllValuesFieldBuilder().getBuilder(), extensionRegistry);
                      kindCase_ = 3;
                      break;
                    } // case 26
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int kindCase_ = 0;
          private java.lang.Object kind_;

          public KindCase getKindCase() {
            return KindCase.forNumber(kindCase_);
          }

          public Builder clearKind() {
            kindCase_ = 0;
            kind_ = null;
            onChanged();
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value.Builder,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                      .ValueOrBuilder>
              valueBuilder_;
          /**
           *
           *
           * <pre>
           * A unique specific value for a given feature.
           * Example: `{ "value": { "string_value": "12345" } }`
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value = 1;
           * </code>
           *
           * @return Whether the value field is set.
           */
          @java.lang.Override
          public boolean hasValue() {
            return kindCase_ == 1;
          }
          /**
           *
           *
           * <pre>
           * A unique specific value for a given feature.
           * Example: `{ "value": { "string_value": "12345" } }`
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value = 1;
           * </code>
           *
           * @return The value.
           */
          @java.lang.Override
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
              getValue() {
            if (valueBuilder_ == null) {
              if (kindCase_ == 1) {
                return (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value)
                    kind_;
              }
              return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
                  .getDefaultInstance();
            } else {
              if (kindCase_ == 1) {
                return valueBuilder_.getMessage();
              }
              return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
                  .getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * A unique specific value for a given feature.
           * Example: `{ "value": { "string_value": "12345" } }`
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value = 1;
           * </code>
           */
          public Builder setValue(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value) {
            if (valueBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              kind_ = value;
              onChanged();
            } else {
              valueBuilder_.setMessage(value);
            }
            kindCase_ = 1;
            return this;
          }
          /**
           *
           *
           * <pre>
           * A unique specific value for a given feature.
           * Example: `{ "value": { "string_value": "12345" } }`
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value = 1;
           * </code>
           */
          public Builder setValue(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value.Builder
                  builderForValue) {
            if (valueBuilder_ == null) {
              kind_ = builderForValue.build();
              onChanged();
            } else {
              valueBuilder_.setMessage(builderForValue.build());
            }
            kindCase_ = 1;
            return this;
          }
          /**
           *
           *
           * <pre>
           * A unique specific value for a given feature.
           * Example: `{ "value": { "string_value": "12345" } }`
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value = 1;
           * </code>
           */
          public Builder mergeValue(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value) {
            if (valueBuilder_ == null) {
              if (kindCase_ == 1
                  && kind_
                      != com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
                          .getDefaultInstance()) {
                kind_ =
                    com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
                        .newBuilder(
                            (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                                    .Value)
                                kind_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                kind_ = value;
              }
              onChanged();
            } else {
              if (kindCase_ == 1) {
                valueBuilder_.mergeFrom(value);
              } else {
                valueBuilder_.setMessage(value);
              }
            }
            kindCase_ = 1;
            return this;
          }
          /**
           *
           *
           * <pre>
           * A unique specific value for a given feature.
           * Example: `{ "value": { "string_value": "12345" } }`
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value = 1;
           * </code>
           */
          public Builder clearValue() {
            if (valueBuilder_ == null) {
              if (kindCase_ == 1) {
                kindCase_ = 0;
                kind_ = null;
                onChanged();
              }
            } else {
              if (kindCase_ == 1) {
                kindCase_ = 0;
                kind_ = null;
              }
              valueBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A unique specific value for a given feature.
           * Example: `{ "value": { "string_value": "12345" } }`
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value = 1;
           * </code>
           */
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value.Builder
              getValueBuilder() {
            return getValueFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * A unique specific value for a given feature.
           * Example: `{ "value": { "string_value": "12345" } }`
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value = 1;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.ValueOrBuilder
              getValueOrBuilder() {
            if ((kindCase_ == 1) && (valueBuilder_ != null)) {
              return valueBuilder_.getMessageOrBuilder();
            } else {
              if (kindCase_ == 1) {
                return (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value)
                    kind_;
              }
              return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
                  .getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * A unique specific value for a given feature.
           * Example: `{ "value": { "string_value": "12345" } }`
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value value = 1;
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value.Builder,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                      .ValueOrBuilder>
              getValueFieldBuilder() {
            if (valueBuilder_ == null) {
              if (!(kindCase_ == 1)) {
                kind_ =
                    com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
                        .getDefaultInstance();
              }
              valueBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value,
                      com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
                          .Builder,
                      com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                          .ValueOrBuilder>(
                      (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value)
                          kind_,
                      getParentForChildren(),
                      isClean());
              kind_ = null;
            }
            kindCase_ = 1;
            onChanged();
            return valueBuilder_;
          }

          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range.Builder,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                      .RangeOrBuilder>
              rangeBuilder_;
          /**
           *
           *
           * <pre>
           * A range of values for a numerical feature.
           * Example: `{"range":{"low":10000.0,"high":50000.0}}`
           * will capture 12345 and 23334 in the slice.
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range range = 2;
           * </code>
           *
           * @return Whether the range field is set.
           */
          @java.lang.Override
          public boolean hasRange() {
            return kindCase_ == 2;
          }
          /**
           *
           *
           * <pre>
           * A range of values for a numerical feature.
           * Example: `{"range":{"low":10000.0,"high":50000.0}}`
           * will capture 12345 and 23334 in the slice.
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range range = 2;
           * </code>
           *
           * @return The range.
           */
          @java.lang.Override
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
              getRange() {
            if (rangeBuilder_ == null) {
              if (kindCase_ == 2) {
                return (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range)
                    kind_;
              }
              return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
                  .getDefaultInstance();
            } else {
              if (kindCase_ == 2) {
                return rangeBuilder_.getMessage();
              }
              return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
                  .getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * A range of values for a numerical feature.
           * Example: `{"range":{"low":10000.0,"high":50000.0}}`
           * will capture 12345 and 23334 in the slice.
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range range = 2;
           * </code>
           */
          public Builder setRange(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range value) {
            if (rangeBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              kind_ = value;
              onChanged();
            } else {
              rangeBuilder_.setMessage(value);
            }
            kindCase_ = 2;
            return this;
          }
          /**
           *
           *
           * <pre>
           * A range of values for a numerical feature.
           * Example: `{"range":{"low":10000.0,"high":50000.0}}`
           * will capture 12345 and 23334 in the slice.
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range range = 2;
           * </code>
           */
          public Builder setRange(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range.Builder
                  builderForValue) {
            if (rangeBuilder_ == null) {
              kind_ = builderForValue.build();
              onChanged();
            } else {
              rangeBuilder_.setMessage(builderForValue.build());
            }
            kindCase_ = 2;
            return this;
          }
          /**
           *
           *
           * <pre>
           * A range of values for a numerical feature.
           * Example: `{"range":{"low":10000.0,"high":50000.0}}`
           * will capture 12345 and 23334 in the slice.
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range range = 2;
           * </code>
           */
          public Builder mergeRange(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range value) {
            if (rangeBuilder_ == null) {
              if (kindCase_ == 2
                  && kind_
                      != com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
                          .getDefaultInstance()) {
                kind_ =
                    com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
                        .newBuilder(
                            (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                                    .Range)
                                kind_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                kind_ = value;
              }
              onChanged();
            } else {
              if (kindCase_ == 2) {
                rangeBuilder_.mergeFrom(value);
              } else {
                rangeBuilder_.setMessage(value);
              }
            }
            kindCase_ = 2;
            return this;
          }
          /**
           *
           *
           * <pre>
           * A range of values for a numerical feature.
           * Example: `{"range":{"low":10000.0,"high":50000.0}}`
           * will capture 12345 and 23334 in the slice.
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range range = 2;
           * </code>
           */
          public Builder clearRange() {
            if (rangeBuilder_ == null) {
              if (kindCase_ == 2) {
                kindCase_ = 0;
                kind_ = null;
                onChanged();
              }
            } else {
              if (kindCase_ == 2) {
                kindCase_ = 0;
                kind_ = null;
              }
              rangeBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A range of values for a numerical feature.
           * Example: `{"range":{"low":10000.0,"high":50000.0}}`
           * will capture 12345 and 23334 in the slice.
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range range = 2;
           * </code>
           */
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range.Builder
              getRangeBuilder() {
            return getRangeFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * A range of values for a numerical feature.
           * Example: `{"range":{"low":10000.0,"high":50000.0}}`
           * will capture 12345 and 23334 in the slice.
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range range = 2;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.RangeOrBuilder
              getRangeOrBuilder() {
            if ((kindCase_ == 2) && (rangeBuilder_ != null)) {
              return rangeBuilder_.getMessageOrBuilder();
            } else {
              if (kindCase_ == 2) {
                return (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range)
                    kind_;
              }
              return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
                  .getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * A range of values for a numerical feature.
           * Example: `{"range":{"low":10000.0,"high":50000.0}}`
           * will capture 12345 and 23334 in the slice.
           * </pre>
           *
           * <code>.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range range = 2;
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range.Builder,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                      .RangeOrBuilder>
              getRangeFieldBuilder() {
            if (rangeBuilder_ == null) {
              if (!(kindCase_ == 2)) {
                kind_ =
                    com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
                        .getDefaultInstance();
              }
              rangeBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range,
                      com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
                          .Builder,
                      com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                          .RangeOrBuilder>(
                      (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range)
                          kind_,
                      getParentForChildren(),
                      isClean());
              kind_ = null;
            }
            kindCase_ = 2;
            onChanged();
            return rangeBuilder_;
          }

          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.BoolValue,
                  com.google.protobuf.BoolValue.Builder,
                  com.google.protobuf.BoolValueOrBuilder>
              allValuesBuilder_;
          /**
           *
           *
           * <pre>
           * If all_values is set to true, then all possible labels of the keyed
           * feature will have another slice computed.
           * Example: `{"all_values":{"value":true}}`
           * </pre>
           *
           * <code>.google.protobuf.BoolValue all_values = 3;</code>
           *
           * @return Whether the allValues field is set.
           */
          @java.lang.Override
          public boolean hasAllValues() {
            return kindCase_ == 3;
          }
          /**
           *
           *
           * <pre>
           * If all_values is set to true, then all possible labels of the keyed
           * feature will have another slice computed.
           * Example: `{"all_values":{"value":true}}`
           * </pre>
           *
           * <code>.google.protobuf.BoolValue all_values = 3;</code>
           *
           * @return The allValues.
           */
          @java.lang.Override
          public com.google.protobuf.BoolValue getAllValues() {
            if (allValuesBuilder_ == null) {
              if (kindCase_ == 3) {
                return (com.google.protobuf.BoolValue) kind_;
              }
              return com.google.protobuf.BoolValue.getDefaultInstance();
            } else {
              if (kindCase_ == 3) {
                return allValuesBuilder_.getMessage();
              }
              return com.google.protobuf.BoolValue.getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * If all_values is set to true, then all possible labels of the keyed
           * feature will have another slice computed.
           * Example: `{"all_values":{"value":true}}`
           * </pre>
           *
           * <code>.google.protobuf.BoolValue all_values = 3;</code>
           */
          public Builder setAllValues(com.google.protobuf.BoolValue value) {
            if (allValuesBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              kind_ = value;
              onChanged();
            } else {
              allValuesBuilder_.setMessage(value);
            }
            kindCase_ = 3;
            return this;
          }
          /**
           *
           *
           * <pre>
           * If all_values is set to true, then all possible labels of the keyed
           * feature will have another slice computed.
           * Example: `{"all_values":{"value":true}}`
           * </pre>
           *
           * <code>.google.protobuf.BoolValue all_values = 3;</code>
           */
          public Builder setAllValues(com.google.protobuf.BoolValue.Builder builderForValue) {
            if (allValuesBuilder_ == null) {
              kind_ = builderForValue.build();
              onChanged();
            } else {
              allValuesBuilder_.setMessage(builderForValue.build());
            }
            kindCase_ = 3;
            return this;
          }
          /**
           *
           *
           * <pre>
           * If all_values is set to true, then all possible labels of the keyed
           * feature will have another slice computed.
           * Example: `{"all_values":{"value":true}}`
           * </pre>
           *
           * <code>.google.protobuf.BoolValue all_values = 3;</code>
           */
          public Builder mergeAllValues(com.google.protobuf.BoolValue value) {
            if (allValuesBuilder_ == null) {
              if (kindCase_ == 3 && kind_ != com.google.protobuf.BoolValue.getDefaultInstance()) {
                kind_ =
                    com.google.protobuf.BoolValue.newBuilder((com.google.protobuf.BoolValue) kind_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                kind_ = value;
              }
              onChanged();
            } else {
              if (kindCase_ == 3) {
                allValuesBuilder_.mergeFrom(value);
              } else {
                allValuesBuilder_.setMessage(value);
              }
            }
            kindCase_ = 3;
            return this;
          }
          /**
           *
           *
           * <pre>
           * If all_values is set to true, then all possible labels of the keyed
           * feature will have another slice computed.
           * Example: `{"all_values":{"value":true}}`
           * </pre>
           *
           * <code>.google.protobuf.BoolValue all_values = 3;</code>
           */
          public Builder clearAllValues() {
            if (allValuesBuilder_ == null) {
              if (kindCase_ == 3) {
                kindCase_ = 0;
                kind_ = null;
                onChanged();
              }
            } else {
              if (kindCase_ == 3) {
                kindCase_ = 0;
                kind_ = null;
              }
              allValuesBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * If all_values is set to true, then all possible labels of the keyed
           * feature will have another slice computed.
           * Example: `{"all_values":{"value":true}}`
           * </pre>
           *
           * <code>.google.protobuf.BoolValue all_values = 3;</code>
           */
          public com.google.protobuf.BoolValue.Builder getAllValuesBuilder() {
            return getAllValuesFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * If all_values is set to true, then all possible labels of the keyed
           * feature will have another slice computed.
           * Example: `{"all_values":{"value":true}}`
           * </pre>
           *
           * <code>.google.protobuf.BoolValue all_values = 3;</code>
           */
          @java.lang.Override
          public com.google.protobuf.BoolValueOrBuilder getAllValuesOrBuilder() {
            if ((kindCase_ == 3) && (allValuesBuilder_ != null)) {
              return allValuesBuilder_.getMessageOrBuilder();
            } else {
              if (kindCase_ == 3) {
                return (com.google.protobuf.BoolValue) kind_;
              }
              return com.google.protobuf.BoolValue.getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * If all_values is set to true, then all possible labels of the keyed
           * feature will have another slice computed.
           * Example: `{"all_values":{"value":true}}`
           * </pre>
           *
           * <code>.google.protobuf.BoolValue all_values = 3;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.BoolValue,
                  com.google.protobuf.BoolValue.Builder,
                  com.google.protobuf.BoolValueOrBuilder>
              getAllValuesFieldBuilder() {
            if (allValuesBuilder_ == null) {
              if (!(kindCase_ == 3)) {
                kind_ = com.google.protobuf.BoolValue.getDefaultInstance();
              }
              allValuesBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.protobuf.BoolValue,
                      com.google.protobuf.BoolValue.Builder,
                      com.google.protobuf.BoolValueOrBuilder>(
                      (com.google.protobuf.BoolValue) kind_, getParentForChildren(), isClean());
              kind_ = null;
            }
            kindCase_ = 3;
            onChanged();
            return allValuesBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig)
        private static final com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfig
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig();
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfig
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<SliceConfig> PARSER =
            new com.google.protobuf.AbstractParser<SliceConfig>() {
              @java.lang.Override
              public SliceConfig parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<SliceConfig> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<SliceConfig> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface RangeOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Inclusive low value for the range.
         * </pre>
         *
         * <code>float low = 1;</code>
         *
         * @return The low.
         */
        float getLow();

        /**
         *
         *
         * <pre>
         * Exclusive high value for the range.
         * </pre>
         *
         * <code>float high = 2;</code>
         *
         * @return The high.
         */
        float getHigh();
      }
      /**
       *
       *
       * <pre>
       * A range of values for slice(s).
       * `low` is inclusive, `high` is exclusive.
       * </pre>
       *
       * Protobuf type {@code google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range}
       */
      public static final class Range extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range)
          RangeOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Range.newBuilder() to construct.
        private Range(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Range() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Range();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
              .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_Range_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
              .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_Range_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range.class,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range.Builder
                      .class);
        }

        public static final int LOW_FIELD_NUMBER = 1;
        private float low_ = 0F;
        /**
         *
         *
         * <pre>
         * Inclusive low value for the range.
         * </pre>
         *
         * <code>float low = 1;</code>
         *
         * @return The low.
         */
        @java.lang.Override
        public float getLow() {
          return low_;
        }

        public static final int HIGH_FIELD_NUMBER = 2;
        private float high_ = 0F;
        /**
         *
         *
         * <pre>
         * Exclusive high value for the range.
         * </pre>
         *
         * <code>float high = 2;</code>
         *
         * @return The high.
         */
        @java.lang.Override
        public float getHigh() {
          return high_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (java.lang.Float.floatToRawIntBits(low_) != 0) {
            output.writeFloat(1, low_);
          }
          if (java.lang.Float.floatToRawIntBits(high_) != 0) {
            output.writeFloat(2, high_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (java.lang.Float.floatToRawIntBits(low_) != 0) {
            size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, low_);
          }
          if (java.lang.Float.floatToRawIntBits(high_) != 0) {
            size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, high_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range)) {
            return super.equals(obj);
          }
          com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range other =
              (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range) obj;

          if (java.lang.Float.floatToIntBits(getLow())
              != java.lang.Float.floatToIntBits(other.getLow())) return false;
          if (java.lang.Float.floatToIntBits(getHigh())
              != java.lang.Float.floatToIntBits(other.getHigh())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + LOW_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(getLow());
          hash = (37 * hash) + HIGH_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(getHigh());
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A range of values for slice(s).
         * `low` is inclusive, `high` is exclusive.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range)
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.RangeOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
                .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_Range_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
                .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_Range_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range.class,
                    com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
                        .Builder.class);
          }

          // Construct using
          // com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            low_ = 0F;
            high_ = 0F;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
                .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_Range_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
              getDefaultInstanceForType() {
            return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range build() {
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
              buildPartial() {
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range result =
                new com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.low_ = low_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.high_ = high_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range) {
              return mergeFrom(
                  (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range other) {
            if (other
                == com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
                    .getDefaultInstance()) return this;
            if (other.getLow() != 0F) {
              setLow(other.getLow());
            }
            if (other.getHigh() != 0F) {
              setHigh(other.getHigh());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 13:
                    {
                      low_ = input.readFloat();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 13
                  case 21:
                    {
                      high_ = input.readFloat();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 21
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private float low_;
          /**
           *
           *
           * <pre>
           * Inclusive low value for the range.
           * </pre>
           *
           * <code>float low = 1;</code>
           *
           * @return The low.
           */
          @java.lang.Override
          public float getLow() {
            return low_;
          }
          /**
           *
           *
           * <pre>
           * Inclusive low value for the range.
           * </pre>
           *
           * <code>float low = 1;</code>
           *
           * @param value The low to set.
           * @return This builder for chaining.
           */
          public Builder setLow(float value) {

            low_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Inclusive low value for the range.
           * </pre>
           *
           * <code>float low = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearLow() {
            bitField0_ = (bitField0_ & ~0x00000001);
            low_ = 0F;
            onChanged();
            return this;
          }

          private float high_;
          /**
           *
           *
           * <pre>
           * Exclusive high value for the range.
           * </pre>
           *
           * <code>float high = 2;</code>
           *
           * @return The high.
           */
          @java.lang.Override
          public float getHigh() {
            return high_;
          }
          /**
           *
           *
           * <pre>
           * Exclusive high value for the range.
           * </pre>
           *
           * <code>float high = 2;</code>
           *
           * @param value The high to set.
           * @return This builder for chaining.
           */
          public Builder setHigh(float value) {

            high_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Exclusive high value for the range.
           * </pre>
           *
           * <code>float high = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearHigh() {
            bitField0_ = (bitField0_ & ~0x00000002);
            high_ = 0F;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range)
        private static final com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .Range
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range();
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Range> PARSER =
            new com.google.protobuf.AbstractParser<Range>() {
              @java.lang.Override
              public Range parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Range> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Range> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface ValueOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * String type.
         * </pre>
         *
         * <code>string string_value = 1;</code>
         *
         * @return Whether the stringValue field is set.
         */
        boolean hasStringValue();
        /**
         *
         *
         * <pre>
         * String type.
         * </pre>
         *
         * <code>string string_value = 1;</code>
         *
         * @return The stringValue.
         */
        java.lang.String getStringValue();
        /**
         *
         *
         * <pre>
         * String type.
         * </pre>
         *
         * <code>string string_value = 1;</code>
         *
         * @return The bytes for stringValue.
         */
        com.google.protobuf.ByteString getStringValueBytes();

        /**
         *
         *
         * <pre>
         * Float type.
         * </pre>
         *
         * <code>float float_value = 2;</code>
         *
         * @return Whether the floatValue field is set.
         */
        boolean hasFloatValue();
        /**
         *
         *
         * <pre>
         * Float type.
         * </pre>
         *
         * <code>float float_value = 2;</code>
         *
         * @return The floatValue.
         */
        float getFloatValue();

        com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value.KindCase
            getKindCase();
      }
      /**
       *
       *
       * <pre>
       * Single value that supports strings and floats.
       * </pre>
       *
       * Protobuf type {@code google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value}
       */
      public static final class Value extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value)
          ValueOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Value.newBuilder() to construct.
        private Value(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Value() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Value();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
              .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_Value_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
              .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_Value_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value.class,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value.Builder
                      .class);
        }

        private int kindCase_ = 0;

        @SuppressWarnings("serial")
        private java.lang.Object kind_;

        public enum KindCase
            implements
                com.google.protobuf.Internal.EnumLite,
                com.google.protobuf.AbstractMessage.InternalOneOfEnum {
          STRING_VALUE(1),
          FLOAT_VALUE(2),
          KIND_NOT_SET(0);
          private final int value;

          private KindCase(int value) {
            this.value = value;
          }
          /**
           * @param value The number of the enum to look for.
           * @return The enum associated with the given number.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static KindCase valueOf(int value) {
            return forNumber(value);
          }

          public static KindCase forNumber(int value) {
            switch (value) {
              case 1:
                return STRING_VALUE;
              case 2:
                return FLOAT_VALUE;
              case 0:
                return KIND_NOT_SET;
              default:
                return null;
            }
          }

          public int getNumber() {
            return this.value;
          }
        };

        public KindCase getKindCase() {
          return KindCase.forNumber(kindCase_);
        }

        public static final int STRING_VALUE_FIELD_NUMBER = 1;
        /**
         *
         *
         * <pre>
         * String type.
         * </pre>
         *
         * <code>string string_value = 1;</code>
         *
         * @return Whether the stringValue field is set.
         */
        public boolean hasStringValue() {
          return kindCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * String type.
         * </pre>
         *
         * <code>string string_value = 1;</code>
         *
         * @return The stringValue.
         */
        public java.lang.String getStringValue() {
          java.lang.Object ref = "";
          if (kindCase_ == 1) {
            ref = kind_;
          }
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (kindCase_ == 1) {
              kind_ = s;
            }
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * String type.
         * </pre>
         *
         * <code>string string_value = 1;</code>
         *
         * @return The bytes for stringValue.
         */
        public com.google.protobuf.ByteString getStringValueBytes() {
          java.lang.Object ref = "";
          if (kindCase_ == 1) {
            ref = kind_;
          }
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (kindCase_ == 1) {
              kind_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int FLOAT_VALUE_FIELD_NUMBER = 2;
        /**
         *
         *
         * <pre>
         * Float type.
         * </pre>
         *
         * <code>float float_value = 2;</code>
         *
         * @return Whether the floatValue field is set.
         */
        @java.lang.Override
        public boolean hasFloatValue() {
          return kindCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Float type.
         * </pre>
         *
         * <code>float float_value = 2;</code>
         *
         * @return The floatValue.
         */
        @java.lang.Override
        public float getFloatValue() {
          if (kindCase_ == 2) {
            return (java.lang.Float) kind_;
          }
          return 0F;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (kindCase_ == 1) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, kind_);
          }
          if (kindCase_ == 2) {
            output.writeFloat(2, (float) ((java.lang.Float) kind_));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (kindCase_ == 1) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, kind_);
          }
          if (kindCase_ == 2) {
            size +=
                com.google.protobuf.CodedOutputStream.computeFloatSize(
                    2, (float) ((java.lang.Float) kind_));
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value)) {
            return super.equals(obj);
          }
          com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value other =
              (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value) obj;

          if (!getKindCase().equals(other.getKindCase())) return false;
          switch (kindCase_) {
            case 1:
              if (!getStringValue().equals(other.getStringValue())) return false;
              break;
            case 2:
              if (java.lang.Float.floatToIntBits(getFloatValue())
                  != java.lang.Float.floatToIntBits(other.getFloatValue())) return false;
              break;
            case 0:
            default:
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          switch (kindCase_) {
            case 1:
              hash = (37 * hash) + STRING_VALUE_FIELD_NUMBER;
              hash = (53 * hash) + getStringValue().hashCode();
              break;
            case 2:
              hash = (37 * hash) + FLOAT_VALUE_FIELD_NUMBER;
              hash = (53 * hash) + java.lang.Float.floatToIntBits(getFloatValue());
              break;
            case 0:
            default:
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Single value that supports strings and floats.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value)
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.ValueOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
                .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_Value_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
                .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_Value_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value.class,
                    com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
                        .Builder.class);
          }

          // Construct using
          // com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            kindCase_ = 0;
            kind_ = null;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
                .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_Value_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
              getDefaultInstanceForType() {
            return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value build() {
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
              buildPartial() {
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value result =
                new com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            buildPartialOneofs(result);
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value result) {
            int from_bitField0_ = bitField0_;
          }

          private void buildPartialOneofs(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value result) {
            result.kindCase_ = kindCase_;
            result.kind_ = this.kind_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value) {
              return mergeFrom(
                  (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value other) {
            if (other
                == com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
                    .getDefaultInstance()) return this;
            switch (other.getKindCase()) {
              case STRING_VALUE:
                {
                  kindCase_ = 1;
                  kind_ = other.kind_;
                  onChanged();
                  break;
                }
              case FLOAT_VALUE:
                {
                  setFloatValue(other.getFloatValue());
                  break;
                }
              case KIND_NOT_SET:
                {
                  break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      kindCase_ = 1;
                      kind_ = s;
                      break;
                    } // case 10
                  case 21:
                    {
                      kind_ = input.readFloat();
                      kindCase_ = 2;
                      break;
                    } // case 21
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int kindCase_ = 0;
          private java.lang.Object kind_;

          public KindCase getKindCase() {
            return KindCase.forNumber(kindCase_);
          }

          public Builder clearKind() {
            kindCase_ = 0;
            kind_ = null;
            onChanged();
            return this;
          }

          private int bitField0_;

          /**
           *
           *
           * <pre>
           * String type.
           * </pre>
           *
           * <code>string string_value = 1;</code>
           *
           * @return Whether the stringValue field is set.
           */
          @java.lang.Override
          public boolean hasStringValue() {
            return kindCase_ == 1;
          }
          /**
           *
           *
           * <pre>
           * String type.
           * </pre>
           *
           * <code>string string_value = 1;</code>
           *
           * @return The stringValue.
           */
          @java.lang.Override
          public java.lang.String getStringValue() {
            java.lang.Object ref = "";
            if (kindCase_ == 1) {
              ref = kind_;
            }
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              if (kindCase_ == 1) {
                kind_ = s;
              }
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * String type.
           * </pre>
           *
           * <code>string string_value = 1;</code>
           *
           * @return The bytes for stringValue.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getStringValueBytes() {
            java.lang.Object ref = "";
            if (kindCase_ == 1) {
              ref = kind_;
            }
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              if (kindCase_ == 1) {
                kind_ = b;
              }
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * String type.
           * </pre>
           *
           * <code>string string_value = 1;</code>
           *
           * @param value The stringValue to set.
           * @return This builder for chaining.
           */
          public Builder setStringValue(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            kindCase_ = 1;
            kind_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * String type.
           * </pre>
           *
           * <code>string string_value = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearStringValue() {
            if (kindCase_ == 1) {
              kindCase_ = 0;
              kind_ = null;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * String type.
           * </pre>
           *
           * <code>string string_value = 1;</code>
           *
           * @param value The bytes for stringValue to set.
           * @return This builder for chaining.
           */
          public Builder setStringValueBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            kindCase_ = 1;
            kind_ = value;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Float type.
           * </pre>
           *
           * <code>float float_value = 2;</code>
           *
           * @return Whether the floatValue field is set.
           */
          public boolean hasFloatValue() {
            return kindCase_ == 2;
          }
          /**
           *
           *
           * <pre>
           * Float type.
           * </pre>
           *
           * <code>float float_value = 2;</code>
           *
           * @return The floatValue.
           */
          public float getFloatValue() {
            if (kindCase_ == 2) {
              return (java.lang.Float) kind_;
            }
            return 0F;
          }
          /**
           *
           *
           * <pre>
           * Float type.
           * </pre>
           *
           * <code>float float_value = 2;</code>
           *
           * @param value The floatValue to set.
           * @return This builder for chaining.
           */
          public Builder setFloatValue(float value) {

            kindCase_ = 2;
            kind_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Float type.
           * </pre>
           *
           * <code>float float_value = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearFloatValue() {
            if (kindCase_ == 2) {
              kindCase_ = 0;
              kind_ = null;
              onChanged();
            }
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value)
        private static final com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .Value
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value();
        }

        public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Value> PARSER =
            new com.google.protobuf.AbstractParser<Value>() {
              @java.lang.Override
              public Value parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Value> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Value> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int CONFIGS_FIELD_NUMBER = 1;

      private static final class ConfigsDefaultEntryHolder {
        static final com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
            defaultEntry =
                com.google.protobuf.MapEntry
                    .<java.lang.String,
                        com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                            .SliceConfig>
                        newDefaultInstance(
                            com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
                                .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_ConfigsEntry_descriptor,
                            com.google.protobuf.WireFormat.FieldType.STRING,
                            "",
                            com.google.protobuf.WireFormat.FieldType.MESSAGE,
                            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                                .SliceConfig.getDefaultInstance());
      }

      @SuppressWarnings("serial")
      private com.google.protobuf.MapField<
              java.lang.String,
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
          configs_;

      private com.google.protobuf.MapField<
              java.lang.String,
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
          internalGetConfigs() {
        if (configs_ == null) {
          return com.google.protobuf.MapField.emptyMapField(ConfigsDefaultEntryHolder.defaultEntry);
        }
        return configs_;
      }

      public int getConfigsCount() {
        return internalGetConfigs().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Mapping configuration for this SliceSpec.
       * The key is the name of the feature.
       * By default, the key will be prefixed by "instance" as a dictionary
       * prefix for Vertex Batch Predictions output format.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
       * </code>
       */
      @java.lang.Override
      public boolean containsConfigs(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetConfigs().getMap().containsKey(key);
      }
      /** Use {@link #getConfigsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
          getConfigs() {
        return getConfigsMap();
      }
      /**
       *
       *
       * <pre>
       * Mapping configuration for this SliceSpec.
       * The key is the name of the feature.
       * By default, the key will be prefixed by "instance" as a dictionary
       * prefix for Vertex Batch Predictions output format.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
          getConfigsMap() {
        return internalGetConfigs().getMap();
      }
      /**
       *
       *
       * <pre>
       * Mapping configuration for this SliceSpec.
       * The key is the name of the feature.
       * By default, the key will be prefixed by "instance" as a dictionary
       * prefix for Vertex Batch Predictions output format.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
              .SliceConfig
          getConfigsOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                  defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
            map = internalGetConfigs().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Mapping configuration for this SliceSpec.
       * The key is the name of the feature.
       * By default, the key will be prefixed by "instance" as a dictionary
       * prefix for Vertex Batch Predictions output format.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
          getConfigsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
            map = internalGetConfigs().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
            output, internalGetConfigs(), ConfigsDefaultEntryHolder.defaultEntry, 1);
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (java.util.Map.Entry<
                java.lang.String,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
            entry : internalGetConfigs().getMap().entrySet()) {
          com.google.protobuf.MapEntry<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
              configs__ =
                  ConfigsDefaultEntryHolder.defaultEntry
                      .newBuilderForType()
                      .setKey(entry.getKey())
                      .setValue(entry.getValue())
                      .build();
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, configs__);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec other =
            (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec) obj;

        if (!internalGetConfigs().equals(other.internalGetConfigs())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (!internalGetConfigs().getMap().isEmpty()) {
          hash = (37 * hash) + CONFIGS_FIELD_NUMBER;
          hash = (53 * hash) + internalGetConfigs().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Specification for how the data should be sliced.
       * </pre>
       *
       * Protobuf type {@code google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec)
          com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
              .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_descriptor;
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
            int number) {
          switch (number) {
            case 1:
              return internalGetConfigs();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapFieldReflectionAccessor
            internalGetMutableMapFieldReflection(int number) {
          switch (number) {
            case 1:
              return internalGetMutableConfigs();
            default:
              throw new RuntimeException("Invalid map field number: " + number);
          }
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
              .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.class,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          internalGetMutableConfigs().clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
              .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_SliceSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec build() {
          com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec buildPartial() {
          com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec result =
              new com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.configs_ = internalGetConfigs().build(ConfigsDefaultEntryHolder.defaultEntry);
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec other) {
          if (other
              == com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                  .getDefaultInstance()) return this;
          internalGetMutableConfigs().mergeFrom(other.internalGetConfigs());
          bitField0_ |= 0x00000001;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.protobuf.MapEntry<
                            java.lang.String,
                            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                                .SliceConfig>
                        configs__ =
                            input.readMessage(
                                ConfigsDefaultEntryHolder.defaultEntry.getParserForType(),
                                extensionRegistry);
                    internalGetMutableConfigs()
                        .ensureBuilderMap()
                        .put(configs__.getKey(), configs__.getValue());
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private static final class ConfigsConverter
            implements com.google.protobuf.MapFieldBuilder.Converter<
                java.lang.String,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                    .SliceConfigOrBuilder,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig> {
          @java.lang.Override
          public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
              build(
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                          .SliceConfigOrBuilder
                      val) {
            if (val
                instanceof
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig) {
              return (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                      .SliceConfig)
                  val;
            }
            return ((com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                        .Builder)
                    val)
                .build();
          }

          @java.lang.Override
          public com.google.protobuf.MapEntry<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
              defaultEntry() {
            return ConfigsDefaultEntryHolder.defaultEntry;
          }
        };

        private static final ConfigsConverter configsConverter = new ConfigsConverter();

        private com.google.protobuf.MapFieldBuilder<
                java.lang.String,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                    .SliceConfigOrBuilder,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                    .Builder>
            configs_;

        private com.google.protobuf.MapFieldBuilder<
                java.lang.String,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                    .SliceConfigOrBuilder,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                    .Builder>
            internalGetConfigs() {
          if (configs_ == null) {
            return new com.google.protobuf.MapFieldBuilder<>(configsConverter);
          }
          return configs_;
        }

        private com.google.protobuf.MapFieldBuilder<
                java.lang.String,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                    .SliceConfigOrBuilder,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                    .Builder>
            internalGetMutableConfigs() {
          if (configs_ == null) {
            configs_ = new com.google.protobuf.MapFieldBuilder<>(configsConverter);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return configs_;
        }

        public int getConfigsCount() {
          return internalGetConfigs().ensureBuilderMap().size();
        }
        /**
         *
         *
         * <pre>
         * Mapping configuration for this SliceSpec.
         * The key is the name of the feature.
         * By default, the key will be prefixed by "instance" as a dictionary
         * prefix for Vertex Batch Predictions output format.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
         * </code>
         */
        @java.lang.Override
        public boolean containsConfigs(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          return internalGetConfigs().ensureBuilderMap().containsKey(key);
        }
        /** Use {@link #getConfigsMap()} instead. */
        @java.lang.Override
        @java.lang.Deprecated
        public java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
            getConfigs() {
          return getConfigsMap();
        }
        /**
         *
         *
         * <pre>
         * Mapping configuration for this SliceSpec.
         * The key is the name of the feature.
         * By default, the key will be prefixed by "instance" as a dictionary
         * prefix for Vertex Batch Predictions output format.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
         * </code>
         */
        @java.lang.Override
        public java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
            getConfigsMap() {
          return internalGetConfigs().getImmutableMap();
        }
        /**
         *
         *
         * <pre>
         * Mapping configuration for this SliceSpec.
         * The key is the name of the feature.
         * By default, the key will be prefixed by "instance" as a dictionary
         * prefix for Vertex Batch Predictions output format.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
         * </code>
         */
        @java.lang.Override
        public /* nullable */ com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                .SliceConfig
            getConfigsOrDefault(
                java.lang.String key,
                /* nullable */
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                    defaultValue) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                      .SliceConfigOrBuilder>
              map = internalGetMutableConfigs().ensureBuilderMap();
          return map.containsKey(key) ? configsConverter.build(map.get(key)) : defaultValue;
        }
        /**
         *
         *
         * <pre>
         * Mapping configuration for this SliceSpec.
         * The key is the name of the feature.
         * By default, the key will be prefixed by "instance" as a dictionary
         * prefix for Vertex Batch Predictions output format.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
            getConfigsOrThrow(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          java.util.Map<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                      .SliceConfigOrBuilder>
              map = internalGetMutableConfigs().ensureBuilderMap();
          if (!map.containsKey(key)) {
            throw new java.lang.IllegalArgumentException();
          }
          return configsConverter.build(map.get(key));
        }

        public Builder clearConfigs() {
          bitField0_ = (bitField0_ & ~0x00000001);
          internalGetMutableConfigs().clear();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Mapping configuration for this SliceSpec.
         * The key is the name of the feature.
         * By default, the key will be prefixed by "instance" as a dictionary
         * prefix for Vertex Batch Predictions output format.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
         * </code>
         */
        public Builder removeConfigs(java.lang.String key) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          internalGetMutableConfigs().ensureBuilderMap().remove(key);
          return this;
        }
        /** Use alternate mutation accessors instead. */
        @java.lang.Deprecated
        public java.util.Map<
                java.lang.String,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
            getMutableConfigs() {
          bitField0_ |= 0x00000001;
          return internalGetMutableConfigs().ensureMessageMap();
        }
        /**
         *
         *
         * <pre>
         * Mapping configuration for this SliceSpec.
         * The key is the name of the feature.
         * By default, the key will be prefixed by "instance" as a dictionary
         * prefix for Vertex Batch Predictions output format.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
         * </code>
         */
        public Builder putConfigs(
            java.lang.String key,
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig value) {
          if (key == null) {
            throw new NullPointerException("map key");
          }
          if (value == null) {
            throw new NullPointerException("map value");
          }
          internalGetMutableConfigs().ensureBuilderMap().put(key, value);
          bitField0_ |= 0x00000001;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Mapping configuration for this SliceSpec.
         * The key is the name of the feature.
         * By default, the key will be prefixed by "instance" as a dictionary
         * prefix for Vertex Batch Predictions output format.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
         * </code>
         */
        public Builder putAllConfigs(
            java.util.Map<
                    java.lang.String,
                    com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
                values) {
          for (java.util.Map.Entry<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig>
              e : values.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) {
              throw new NullPointerException();
            }
          }
          internalGetMutableConfigs().ensureBuilderMap().putAll(values);
          bitField0_ |= 0x00000001;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Mapping configuration for this SliceSpec.
         * The key is the name of the feature.
         * By default, the key will be prefixed by "instance" as a dictionary
         * prefix for Vertex Batch Predictions output format.
         * </pre>
         *
         * <code>
         * map&lt;string, .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig&gt; configs = 1;
         * </code>
         */
        public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                .Builder
            putConfigsBuilderIfAbsent(java.lang.String key) {
          java.util.Map<
                  java.lang.String,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                      .SliceConfigOrBuilder>
              builderMap = internalGetMutableConfigs().ensureBuilderMap();
          com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfigOrBuilder
              entry = builderMap.get(key);
          if (entry == null) {
            entry =
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                    .newBuilder();
            builderMap.put(key, entry);
          }
          if (entry
              instanceof
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig) {
            entry =
                ((com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig)
                        entry)
                    .toBuilder();
            builderMap.put(key, entry);
          }
          return (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
                  .Builder)
              entry;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec)
      private static final com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec();
      }

      public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SliceSpec> PARSER =
          new com.google.protobuf.AbstractParser<SliceSpec>() {
            @java.lang.Override
            public SliceSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SliceSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SliceSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int DIMENSION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dimension_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The dimension of the slice.
     * Well-known dimensions are:
     *   * `annotationSpec`: This slice is on the test data that has either
     *     ground truth or prediction with
     *     [AnnotationSpec.display_name][google.cloud.aiplatform.v1.AnnotationSpec.display_name]
     *     equals to
     *     [value][google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.value].
     *   * `slice`: This slice is a user customized slice defined by its
     *     SliceSpec.
     * </pre>
     *
     * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The dimension.
     */
    @java.lang.Override
    public java.lang.String getDimension() {
      java.lang.Object ref = dimension_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dimension_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The dimension of the slice.
     * Well-known dimensions are:
     *   * `annotationSpec`: This slice is on the test data that has either
     *     ground truth or prediction with
     *     [AnnotationSpec.display_name][google.cloud.aiplatform.v1.AnnotationSpec.display_name]
     *     equals to
     *     [value][google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.value].
     *   * `slice`: This slice is a user customized slice defined by its
     *     SliceSpec.
     * </pre>
     *
     * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for dimension.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDimensionBytes() {
      java.lang.Object ref = dimension_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dimension_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object value_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The value of the dimension in this slice.
     * </pre>
     *
     * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The value of the dimension in this slice.
     * </pre>
     *
     * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SLICE_SPEC_FIELD_NUMBER = 3;
    private com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec sliceSpec_;
    /**
     *
     *
     * <pre>
     * Output only. Specification for how the data was sliced.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec slice_spec = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the sliceSpec field is set.
     */
    @java.lang.Override
    public boolean hasSliceSpec() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification for how the data was sliced.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec slice_spec = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The sliceSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec getSliceSpec() {
      return sliceSpec_ == null
          ? com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.getDefaultInstance()
          : sliceSpec_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification for how the data was sliced.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec slice_spec = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpecOrBuilder
        getSliceSpecOrBuilder() {
      return sliceSpec_ == null
          ? com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.getDefaultInstance()
          : sliceSpec_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dimension_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dimension_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getSliceSpec());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dimension_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dimension_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSliceSpec());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice other =
          (com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice) obj;

      if (!getDimension().equals(other.getDimension())) return false;
      if (!getValue().equals(other.getValue())) return false;
      if (hasSliceSpec() != other.hasSliceSpec()) return false;
      if (hasSliceSpec()) {
        if (!getSliceSpec().equals(other.getSliceSpec())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DIMENSION_FIELD_NUMBER;
      hash = (53 * hash) + getDimension().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      if (hasSliceSpec()) {
        hash = (37 * hash) + SLICE_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSliceSpec().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Definition of a slice.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice)
        com.google.cloud.aiplatform.v1.ModelEvaluationSlice.SliceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
            .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
            .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.class,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSliceSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dimension_ = "";
        value_ = "";
        sliceSpec_ = null;
        if (sliceSpecBuilder_ != null) {
          sliceSpecBuilder_.dispose();
          sliceSpecBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
            .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_Slice_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice build() {
        com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice buildPartial() {
        com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice result =
            new com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dimension_ = dimension_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.value_ = value_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.sliceSpec_ = sliceSpecBuilder_ == null ? sliceSpec_ : sliceSpecBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice) {
          return mergeFrom((com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice other) {
        if (other == com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.getDefaultInstance())
          return this;
        if (!other.getDimension().isEmpty()) {
          dimension_ = other.dimension_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasSliceSpec()) {
          mergeSliceSpec(other.getSliceSpec());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  dimension_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  value_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getSliceSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object dimension_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The dimension of the slice.
       * Well-known dimensions are:
       *   * `annotationSpec`: This slice is on the test data that has either
       *     ground truth or prediction with
       *     [AnnotationSpec.display_name][google.cloud.aiplatform.v1.AnnotationSpec.display_name]
       *     equals to
       *     [value][google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.value].
       *   * `slice`: This slice is a user customized slice defined by its
       *     SliceSpec.
       * </pre>
       *
       * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The dimension.
       */
      public java.lang.String getDimension() {
        java.lang.Object ref = dimension_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dimension_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The dimension of the slice.
       * Well-known dimensions are:
       *   * `annotationSpec`: This slice is on the test data that has either
       *     ground truth or prediction with
       *     [AnnotationSpec.display_name][google.cloud.aiplatform.v1.AnnotationSpec.display_name]
       *     equals to
       *     [value][google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.value].
       *   * `slice`: This slice is a user customized slice defined by its
       *     SliceSpec.
       * </pre>
       *
       * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for dimension.
       */
      public com.google.protobuf.ByteString getDimensionBytes() {
        java.lang.Object ref = dimension_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dimension_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The dimension of the slice.
       * Well-known dimensions are:
       *   * `annotationSpec`: This slice is on the test data that has either
       *     ground truth or prediction with
       *     [AnnotationSpec.display_name][google.cloud.aiplatform.v1.AnnotationSpec.display_name]
       *     equals to
       *     [value][google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.value].
       *   * `slice`: This slice is a user customized slice defined by its
       *     SliceSpec.
       * </pre>
       *
       * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The dimension to set.
       * @return This builder for chaining.
       */
      public Builder setDimension(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dimension_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The dimension of the slice.
       * Well-known dimensions are:
       *   * `annotationSpec`: This slice is on the test data that has either
       *     ground truth or prediction with
       *     [AnnotationSpec.display_name][google.cloud.aiplatform.v1.AnnotationSpec.display_name]
       *     equals to
       *     [value][google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.value].
       *   * `slice`: This slice is a user customized slice defined by its
       *     SliceSpec.
       * </pre>
       *
       * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDimension() {
        dimension_ = getDefaultInstance().getDimension();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The dimension of the slice.
       * Well-known dimensions are:
       *   * `annotationSpec`: This slice is on the test data that has either
       *     ground truth or prediction with
       *     [AnnotationSpec.display_name][google.cloud.aiplatform.v1.AnnotationSpec.display_name]
       *     equals to
       *     [value][google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.value].
       *   * `slice`: This slice is a user customized slice defined by its
       *     SliceSpec.
       * </pre>
       *
       * <code>string dimension = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for dimension to set.
       * @return This builder for chaining.
       */
      public Builder setDimensionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dimension_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The value of the dimension in this slice.
       * </pre>
       *
       * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the dimension in this slice.
       * </pre>
       *
       * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the dimension in this slice.
       * </pre>
       *
       * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the dimension in this slice.
       * </pre>
       *
       * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        value_ = getDefaultInstance().getValue();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The value of the dimension in this slice.
       * </pre>
       *
       * <code>string value = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        value_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec sliceSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec,
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Builder,
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpecOrBuilder>
          sliceSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Specification for how the data was sliced.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec slice_spec = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the sliceSpec field is set.
       */
      public boolean hasSliceSpec() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Specification for how the data was sliced.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec slice_spec = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The sliceSpec.
       */
      public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec getSliceSpec() {
        if (sliceSpecBuilder_ == null) {
          return sliceSpec_ == null
              ? com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                  .getDefaultInstance()
              : sliceSpec_;
        } else {
          return sliceSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Specification for how the data was sliced.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec slice_spec = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setSliceSpec(
          com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec value) {
        if (sliceSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          sliceSpec_ = value;
        } else {
          sliceSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Specification for how the data was sliced.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec slice_spec = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setSliceSpec(
          com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Builder
              builderForValue) {
        if (sliceSpecBuilder_ == null) {
          sliceSpec_ = builderForValue.build();
        } else {
          sliceSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Specification for how the data was sliced.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec slice_spec = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeSliceSpec(
          com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec value) {
        if (sliceSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && sliceSpec_ != null
              && sliceSpec_
                  != com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                      .getDefaultInstance()) {
            getSliceSpecBuilder().mergeFrom(value);
          } else {
            sliceSpec_ = value;
          }
        } else {
          sliceSpecBuilder_.mergeFrom(value);
        }
        if (sliceSpec_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Specification for how the data was sliced.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec slice_spec = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearSliceSpec() {
        bitField0_ = (bitField0_ & ~0x00000004);
        sliceSpec_ = null;
        if (sliceSpecBuilder_ != null) {
          sliceSpecBuilder_.dispose();
          sliceSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Specification for how the data was sliced.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec slice_spec = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Builder
          getSliceSpecBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getSliceSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Specification for how the data was sliced.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec slice_spec = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpecOrBuilder
          getSliceSpecOrBuilder() {
        if (sliceSpecBuilder_ != null) {
          return sliceSpecBuilder_.getMessageOrBuilder();
        } else {
          return sliceSpec_ == null
              ? com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
                  .getDefaultInstance()
              : sliceSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Specification for how the data was sliced.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec slice_spec = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec,
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Builder,
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpecOrBuilder>
          getSliceSpecFieldBuilder() {
        if (sliceSpecBuilder_ == null) {
          sliceSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Builder,
                  com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpecOrBuilder>(
                  getSliceSpec(), getParentForChildren(), isClean());
          sliceSpec_ = null;
        }
        return sliceSpecBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice)
    private static final com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice();
    }

    public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Slice> PARSER =
        new com.google.protobuf.AbstractParser<Slice>() {
          @java.lang.Override
          public Slice parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Slice> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Slice> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the ModelEvaluationSlice.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the ModelEvaluationSlice.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SLICE_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice slice_;
  /**
   *
   *
   * <pre>
   * Output only. The slice of the test data that is used to evaluate the Model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the slice field is set.
   */
  @java.lang.Override
  public boolean hasSlice() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The slice of the test data that is used to evaluate the Model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The slice.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice getSlice() {
    return slice_ == null
        ? com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.getDefaultInstance()
        : slice_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The slice of the test data that is used to evaluate the Model.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.SliceOrBuilder getSliceOrBuilder() {
    return slice_ == null
        ? com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.getDefaultInstance()
        : slice_;
  }

  public static final int METRICS_SCHEMA_URI_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metricsSchemaUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Points to a YAML file stored on Google Cloud Storage
   * describing the
   * [metrics][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics] of this
   * ModelEvaluationSlice. The schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * </pre>
   *
   * <code>string metrics_schema_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The metricsSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getMetricsSchemaUri() {
    java.lang.Object ref = metricsSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metricsSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Points to a YAML file stored on Google Cloud Storage
   * describing the
   * [metrics][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics] of this
   * ModelEvaluationSlice. The schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * </pre>
   *
   * <code>string metrics_schema_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for metricsSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetricsSchemaUriBytes() {
    java.lang.Object ref = metricsSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metricsSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRICS_FIELD_NUMBER = 4;
  private com.google.protobuf.Value metrics_;
  /**
   *
   *
   * <pre>
   * Output only. Sliced evaluation metrics of the Model. The schema of the
   * metrics is stored in
   * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics_schema_uri]
   * </pre>
   *
   * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the metrics field is set.
   */
  @java.lang.Override
  public boolean hasMetrics() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Sliced evaluation metrics of the Model. The schema of the
   * metrics is stored in
   * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics_schema_uri]
   * </pre>
   *
   * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The metrics.
   */
  @java.lang.Override
  public com.google.protobuf.Value getMetrics() {
    return metrics_ == null ? com.google.protobuf.Value.getDefaultInstance() : metrics_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Sliced evaluation metrics of the Model. The schema of the
   * metrics is stored in
   * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics_schema_uri]
   * </pre>
   *
   * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getMetricsOrBuilder() {
    return metrics_ == null ? com.google.protobuf.Value.getDefaultInstance() : metrics_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelEvaluationSlice was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelEvaluationSlice was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelEvaluationSlice was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int MODEL_EXPLANATION_FIELD_NUMBER = 6;
  private com.google.cloud.aiplatform.v1.ModelExplanation modelExplanation_;
  /**
   *
   *
   * <pre>
   * Output only. Aggregated explanation metrics for the Model's prediction
   * output over the data this ModelEvaluation uses. This field is populated
   * only if the Model is evaluated with explanations, and only for tabular
   * Models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelExplanation model_explanation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the modelExplanation field is set.
   */
  @java.lang.Override
  public boolean hasModelExplanation() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Aggregated explanation metrics for the Model's prediction
   * output over the data this ModelEvaluation uses. This field is populated
   * only if the Model is evaluated with explanations, and only for tabular
   * Models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelExplanation model_explanation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The modelExplanation.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelExplanation getModelExplanation() {
    return modelExplanation_ == null
        ? com.google.cloud.aiplatform.v1.ModelExplanation.getDefaultInstance()
        : modelExplanation_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Aggregated explanation metrics for the Model's prediction
   * output over the data this ModelEvaluation uses. This field is populated
   * only if the Model is evaluated with explanations, and only for tabular
   * Models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelExplanation model_explanation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelExplanationOrBuilder getModelExplanationOrBuilder() {
    return modelExplanation_ == null
        ? com.google.cloud.aiplatform.v1.ModelExplanation.getDefaultInstance()
        : modelExplanation_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getSlice());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricsSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, metricsSchemaUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getMetrics());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(6, getModelExplanation());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSlice());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricsSchemaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, metricsSchemaUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMetrics());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getModelExplanation());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.ModelEvaluationSlice)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.ModelEvaluationSlice other =
        (com.google.cloud.aiplatform.v1.ModelEvaluationSlice) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasSlice() != other.hasSlice()) return false;
    if (hasSlice()) {
      if (!getSlice().equals(other.getSlice())) return false;
    }
    if (!getMetricsSchemaUri().equals(other.getMetricsSchemaUri())) return false;
    if (hasMetrics() != other.hasMetrics()) return false;
    if (hasMetrics()) {
      if (!getMetrics().equals(other.getMetrics())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasModelExplanation() != other.hasModelExplanation()) return false;
    if (hasModelExplanation()) {
      if (!getModelExplanation().equals(other.getModelExplanation())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasSlice()) {
      hash = (37 * hash) + SLICE_FIELD_NUMBER;
      hash = (53 * hash) + getSlice().hashCode();
    }
    hash = (37 * hash) + METRICS_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getMetricsSchemaUri().hashCode();
    if (hasMetrics()) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetrics().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasModelExplanation()) {
      hash = (37 * hash) + MODEL_EXPLANATION_FIELD_NUMBER;
      hash = (53 * hash) + getModelExplanation().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.ModelEvaluationSlice prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A collection of metrics calculated by comparing Model's predictions on a
   * slice of the test data against ground truth annotations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ModelEvaluationSlice}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ModelEvaluationSlice)
      com.google.cloud.aiplatform.v1.ModelEvaluationSliceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
          .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
          .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.class,
              com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.ModelEvaluationSlice.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSliceFieldBuilder();
        getMetricsFieldBuilder();
        getCreateTimeFieldBuilder();
        getModelExplanationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      slice_ = null;
      if (sliceBuilder_ != null) {
        sliceBuilder_.dispose();
        sliceBuilder_ = null;
      }
      metricsSchemaUri_ = "";
      metrics_ = null;
      if (metricsBuilder_ != null) {
        metricsBuilder_.dispose();
        metricsBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      modelExplanation_ = null;
      if (modelExplanationBuilder_ != null) {
        modelExplanationBuilder_.dispose();
        modelExplanationBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ModelEvaluationSliceProto
          .internal_static_google_cloud_aiplatform_v1_ModelEvaluationSlice_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelEvaluationSlice getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.ModelEvaluationSlice.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelEvaluationSlice build() {
      com.google.cloud.aiplatform.v1.ModelEvaluationSlice result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ModelEvaluationSlice buildPartial() {
      com.google.cloud.aiplatform.v1.ModelEvaluationSlice result =
          new com.google.cloud.aiplatform.v1.ModelEvaluationSlice(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.ModelEvaluationSlice result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.slice_ = sliceBuilder_ == null ? slice_ : sliceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.metricsSchemaUri_ = metricsSchemaUri_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.metrics_ = metricsBuilder_ == null ? metrics_ : metricsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.modelExplanation_ =
            modelExplanationBuilder_ == null ? modelExplanation_ : modelExplanationBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.ModelEvaluationSlice) {
        return mergeFrom((com.google.cloud.aiplatform.v1.ModelEvaluationSlice) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.ModelEvaluationSlice other) {
      if (other == com.google.cloud.aiplatform.v1.ModelEvaluationSlice.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSlice()) {
        mergeSlice(other.getSlice());
      }
      if (!other.getMetricsSchemaUri().isEmpty()) {
        metricsSchemaUri_ = other.metricsSchemaUri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasMetrics()) {
        mergeMetrics(other.getMetrics());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasModelExplanation()) {
        mergeModelExplanation(other.getModelExplanation());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSliceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                metricsSchemaUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getMetricsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getModelExplanationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluationSlice.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluationSlice.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluationSlice.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluationSlice.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the ModelEvaluationSlice.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice slice_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice,
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.Builder,
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.SliceOrBuilder>
        sliceBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the slice field is set.
     */
    public boolean hasSlice() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The slice.
     */
    public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice getSlice() {
      if (sliceBuilder_ == null) {
        return slice_ == null
            ? com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.getDefaultInstance()
            : slice_;
      } else {
        return sliceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSlice(com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice value) {
      if (sliceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        slice_ = value;
      } else {
        sliceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSlice(
        com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.Builder builderForValue) {
      if (sliceBuilder_ == null) {
        slice_ = builderForValue.build();
      } else {
        sliceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSlice(com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice value) {
      if (sliceBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && slice_ != null
            && slice_
                != com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.getDefaultInstance()) {
          getSliceBuilder().mergeFrom(value);
        } else {
          slice_ = value;
        }
      } else {
        sliceBuilder_.mergeFrom(value);
      }
      if (slice_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSlice() {
      bitField0_ = (bitField0_ & ~0x00000002);
      slice_ = null;
      if (sliceBuilder_ != null) {
        sliceBuilder_.dispose();
        sliceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.Builder getSliceBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSliceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModelEvaluationSlice.SliceOrBuilder getSliceOrBuilder() {
      if (sliceBuilder_ != null) {
        return sliceBuilder_.getMessageOrBuilder();
      } else {
        return slice_ == null
            ? com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.getDefaultInstance()
            : slice_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The slice of the test data that is used to evaluate the Model.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice slice = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice,
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.Builder,
            com.google.cloud.aiplatform.v1.ModelEvaluationSlice.SliceOrBuilder>
        getSliceFieldBuilder() {
      if (sliceBuilder_ == null) {
        sliceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.Builder,
                com.google.cloud.aiplatform.v1.ModelEvaluationSlice.SliceOrBuilder>(
                getSlice(), getParentForChildren(), isClean());
        slice_ = null;
      }
      return sliceBuilder_;
    }

    private java.lang.Object metricsSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Points to a YAML file stored on Google Cloud Storage
     * describing the
     * [metrics][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics] of this
     * ModelEvaluationSlice. The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The metricsSchemaUri.
     */
    public java.lang.String getMetricsSchemaUri() {
      java.lang.Object ref = metricsSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metricsSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Points to a YAML file stored on Google Cloud Storage
     * describing the
     * [metrics][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics] of this
     * ModelEvaluationSlice. The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for metricsSchemaUri.
     */
    public com.google.protobuf.ByteString getMetricsSchemaUriBytes() {
      java.lang.Object ref = metricsSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metricsSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Points to a YAML file stored on Google Cloud Storage
     * describing the
     * [metrics][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics] of this
     * ModelEvaluationSlice. The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The metricsSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setMetricsSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metricsSchemaUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Points to a YAML file stored on Google Cloud Storage
     * describing the
     * [metrics][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics] of this
     * ModelEvaluationSlice. The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetricsSchemaUri() {
      metricsSchemaUri_ = getDefaultInstance().getMetricsSchemaUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Points to a YAML file stored on Google Cloud Storage
     * describing the
     * [metrics][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics] of this
     * ModelEvaluationSlice. The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * </pre>
     *
     * <code>string metrics_schema_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for metricsSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setMetricsSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metricsSchemaUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value metrics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        metricsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the
     * metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the metrics field is set.
     */
    public boolean hasMetrics() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the
     * metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The metrics.
     */
    public com.google.protobuf.Value getMetrics() {
      if (metricsBuilder_ == null) {
        return metrics_ == null ? com.google.protobuf.Value.getDefaultInstance() : metrics_;
      } else {
        return metricsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the
     * metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setMetrics(com.google.protobuf.Value value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
      } else {
        metricsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the
     * metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setMetrics(com.google.protobuf.Value.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        metrics_ = builderForValue.build();
      } else {
        metricsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the
     * metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeMetrics(com.google.protobuf.Value value) {
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && metrics_ != null
            && metrics_ != com.google.protobuf.Value.getDefaultInstance()) {
          getMetricsBuilder().mergeFrom(value);
        } else {
          metrics_ = value;
        }
      } else {
        metricsBuilder_.mergeFrom(value);
      }
      if (metrics_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the
     * metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearMetrics() {
      bitField0_ = (bitField0_ & ~0x00000008);
      metrics_ = null;
      if (metricsBuilder_ != null) {
        metricsBuilder_.dispose();
        metricsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the
     * metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.Value.Builder getMetricsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the
     * metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.ValueOrBuilder getMetricsOrBuilder() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilder();
      } else {
        return metrics_ == null ? com.google.protobuf.Value.getDefaultInstance() : metrics_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Sliced evaluation metrics of the Model. The schema of the
     * metrics is stored in
     * [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics_schema_uri]
     * </pre>
     *
     * <code>.google.protobuf.Value metrics = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getMetrics(), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelEvaluationSlice was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.cloud.aiplatform.v1.ModelExplanation modelExplanation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModelExplanation,
            com.google.cloud.aiplatform.v1.ModelExplanation.Builder,
            com.google.cloud.aiplatform.v1.ModelExplanationOrBuilder>
        modelExplanationBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Aggregated explanation metrics for the Model's prediction
     * output over the data this ModelEvaluation uses. This field is populated
     * only if the Model is evaluated with explanations, and only for tabular
     * Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelExplanation model_explanation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the modelExplanation field is set.
     */
    public boolean hasModelExplanation() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Aggregated explanation metrics for the Model's prediction
     * output over the data this ModelEvaluation uses. This field is populated
     * only if the Model is evaluated with explanations, and only for tabular
     * Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelExplanation model_explanation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The modelExplanation.
     */
    public com.google.cloud.aiplatform.v1.ModelExplanation getModelExplanation() {
      if (modelExplanationBuilder_ == null) {
        return modelExplanation_ == null
            ? com.google.cloud.aiplatform.v1.ModelExplanation.getDefaultInstance()
            : modelExplanation_;
      } else {
        return modelExplanationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Aggregated explanation metrics for the Model's prediction
     * output over the data this ModelEvaluation uses. This field is populated
     * only if the Model is evaluated with explanations, and only for tabular
     * Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelExplanation model_explanation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setModelExplanation(com.google.cloud.aiplatform.v1.ModelExplanation value) {
      if (modelExplanationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelExplanation_ = value;
      } else {
        modelExplanationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Aggregated explanation metrics for the Model's prediction
     * output over the data this ModelEvaluation uses. This field is populated
     * only if the Model is evaluated with explanations, and only for tabular
     * Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelExplanation model_explanation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setModelExplanation(
        com.google.cloud.aiplatform.v1.ModelExplanation.Builder builderForValue) {
      if (modelExplanationBuilder_ == null) {
        modelExplanation_ = builderForValue.build();
      } else {
        modelExplanationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Aggregated explanation metrics for the Model's prediction
     * output over the data this ModelEvaluation uses. This field is populated
     * only if the Model is evaluated with explanations, and only for tabular
     * Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelExplanation model_explanation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeModelExplanation(com.google.cloud.aiplatform.v1.ModelExplanation value) {
      if (modelExplanationBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && modelExplanation_ != null
            && modelExplanation_
                != com.google.cloud.aiplatform.v1.ModelExplanation.getDefaultInstance()) {
          getModelExplanationBuilder().mergeFrom(value);
        } else {
          modelExplanation_ = value;
        }
      } else {
        modelExplanationBuilder_.mergeFrom(value);
      }
      if (modelExplanation_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Aggregated explanation metrics for the Model's prediction
     * output over the data this ModelEvaluation uses. This field is populated
     * only if the Model is evaluated with explanations, and only for tabular
     * Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelExplanation model_explanation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearModelExplanation() {
      bitField0_ = (bitField0_ & ~0x00000020);
      modelExplanation_ = null;
      if (modelExplanationBuilder_ != null) {
        modelExplanationBuilder_.dispose();
        modelExplanationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Aggregated explanation metrics for the Model's prediction
     * output over the data this ModelEvaluation uses. This field is populated
     * only if the Model is evaluated with explanations, and only for tabular
     * Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelExplanation model_explanation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModelExplanation.Builder getModelExplanationBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getModelExplanationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Aggregated explanation metrics for the Model's prediction
     * output over the data this ModelEvaluation uses. This field is populated
     * only if the Model is evaluated with explanations, and only for tabular
     * Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelExplanation model_explanation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ModelExplanationOrBuilder getModelExplanationOrBuilder() {
      if (modelExplanationBuilder_ != null) {
        return modelExplanationBuilder_.getMessageOrBuilder();
      } else {
        return modelExplanation_ == null
            ? com.google.cloud.aiplatform.v1.ModelExplanation.getDefaultInstance()
            : modelExplanation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Aggregated explanation metrics for the Model's prediction
     * output over the data this ModelEvaluation uses. This field is populated
     * only if the Model is evaluated with explanations, and only for tabular
     * Models.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ModelExplanation model_explanation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ModelExplanation,
            com.google.cloud.aiplatform.v1.ModelExplanation.Builder,
            com.google.cloud.aiplatform.v1.ModelExplanationOrBuilder>
        getModelExplanationFieldBuilder() {
      if (modelExplanationBuilder_ == null) {
        modelExplanationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ModelExplanation,
                com.google.cloud.aiplatform.v1.ModelExplanation.Builder,
                com.google.cloud.aiplatform.v1.ModelExplanationOrBuilder>(
                getModelExplanation(), getParentForChildren(), isClean());
        modelExplanation_ = null;
      }
      return modelExplanationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ModelEvaluationSlice)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ModelEvaluationSlice)
  private static final com.google.cloud.aiplatform.v1.ModelEvaluationSlice DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ModelEvaluationSlice();
  }

  public static com.google.cloud.aiplatform.v1.ModelEvaluationSlice getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelEvaluationSlice> PARSER =
      new com.google.protobuf.AbstractParser<ModelEvaluationSlice>() {
        @java.lang.Override
        public ModelEvaluationSlice parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelEvaluationSlice> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelEvaluationSlice> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ModelEvaluationSlice getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
