/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/explanation_metadata.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Metadata describing the Model's input and output for explanation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.ExplanationMetadata}
 */
public final class ExplanationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ExplanationMetadata)
    ExplanationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExplanationMetadata.newBuilder() to construct.
  private ExplanationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExplanationMetadata() {
    featureAttributionsSchemaUri_ = "";
    latentSpaceSource_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExplanationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
        .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 1:
        return internalGetInputs();
      case 2:
        return internalGetOutputs();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
        .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.ExplanationMetadata.class,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.Builder.class);
  }

  public interface InputMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Baseline inputs for this feature.
     *
     * If no baseline is specified, Vertex AI chooses the baseline for this
     * feature. If multiple baselines are specified, Vertex AI returns the
     * average attributions across them in
     * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
     *
     * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
     * of each baseline must match the shape of the input tensor. If a scalar is
     * provided, we broadcast to the same shape as the input tensor.
     *
     * For custom images, the element of the baselines must be in the same
     * format as the feature's input in the
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
     * schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
     */
    java.util.List<com.google.protobuf.Value> getInputBaselinesList();
    /**
     *
     *
     * <pre>
     * Baseline inputs for this feature.
     *
     * If no baseline is specified, Vertex AI chooses the baseline for this
     * feature. If multiple baselines are specified, Vertex AI returns the
     * average attributions across them in
     * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
     *
     * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
     * of each baseline must match the shape of the input tensor. If a scalar is
     * provided, we broadcast to the same shape as the input tensor.
     *
     * For custom images, the element of the baselines must be in the same
     * format as the feature's input in the
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
     * schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
     */
    com.google.protobuf.Value getInputBaselines(int index);
    /**
     *
     *
     * <pre>
     * Baseline inputs for this feature.
     *
     * If no baseline is specified, Vertex AI chooses the baseline for this
     * feature. If multiple baselines are specified, Vertex AI returns the
     * average attributions across them in
     * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
     *
     * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
     * of each baseline must match the shape of the input tensor. If a scalar is
     * provided, we broadcast to the same shape as the input tensor.
     *
     * For custom images, the element of the baselines must be in the same
     * format as the feature's input in the
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
     * schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
     */
    int getInputBaselinesCount();
    /**
     *
     *
     * <pre>
     * Baseline inputs for this feature.
     *
     * If no baseline is specified, Vertex AI chooses the baseline for this
     * feature. If multiple baselines are specified, Vertex AI returns the
     * average attributions across them in
     * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
     *
     * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
     * of each baseline must match the shape of the input tensor. If a scalar is
     * provided, we broadcast to the same shape as the input tensor.
     *
     * For custom images, the element of the baselines must be in the same
     * format as the feature's input in the
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
     * schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
     */
    java.util.List<? extends com.google.protobuf.ValueOrBuilder> getInputBaselinesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Baseline inputs for this feature.
     *
     * If no baseline is specified, Vertex AI chooses the baseline for this
     * feature. If multiple baselines are specified, Vertex AI returns the
     * average attributions across them in
     * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
     *
     * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
     * of each baseline must match the shape of the input tensor. If a scalar is
     * provided, we broadcast to the same shape as the input tensor.
     *
     * For custom images, the element of the baselines must be in the same
     * format as the feature's input in the
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
     * schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
     */
    com.google.protobuf.ValueOrBuilder getInputBaselinesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Name of the input tensor for this feature. Required and is only
     * applicable to Vertex AI-provided images for Tensorflow.
     * </pre>
     *
     * <code>string input_tensor_name = 2;</code>
     *
     * @return The inputTensorName.
     */
    java.lang.String getInputTensorName();
    /**
     *
     *
     * <pre>
     * Name of the input tensor for this feature. Required and is only
     * applicable to Vertex AI-provided images for Tensorflow.
     * </pre>
     *
     * <code>string input_tensor_name = 2;</code>
     *
     * @return The bytes for inputTensorName.
     */
    com.google.protobuf.ByteString getInputTensorNameBytes();

    /**
     *
     *
     * <pre>
     * Defines how the feature is encoded into the input tensor. Defaults to
     * IDENTITY.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding encoding = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for encoding.
     */
    int getEncodingValue();
    /**
     *
     *
     * <pre>
     * Defines how the feature is encoded into the input tensor. Defaults to
     * IDENTITY.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding encoding = 3;
     * </code>
     *
     * @return The encoding.
     */
    com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding getEncoding();

    /**
     *
     *
     * <pre>
     * Modality of the feature. Valid values are: numeric, image. Defaults to
     * numeric.
     * </pre>
     *
     * <code>string modality = 4;</code>
     *
     * @return The modality.
     */
    java.lang.String getModality();
    /**
     *
     *
     * <pre>
     * Modality of the feature. Valid values are: numeric, image. Defaults to
     * numeric.
     * </pre>
     *
     * <code>string modality = 4;</code>
     *
     * @return The bytes for modality.
     */
    com.google.protobuf.ByteString getModalityBytes();

    /**
     *
     *
     * <pre>
     * The domain details of the input feature value. Like min/max, original
     * mean or standard deviation if normalized.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain feature_value_domain = 5;
     * </code>
     *
     * @return Whether the featureValueDomain field is set.
     */
    boolean hasFeatureValueDomain();
    /**
     *
     *
     * <pre>
     * The domain details of the input feature value. Like min/max, original
     * mean or standard deviation if normalized.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain feature_value_domain = 5;
     * </code>
     *
     * @return The featureValueDomain.
     */
    com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
        getFeatureValueDomain();
    /**
     *
     *
     * <pre>
     * The domain details of the input feature value. Like min/max, original
     * mean or standard deviation if normalized.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain feature_value_domain = 5;
     * </code>
     */
    com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomainOrBuilder
        getFeatureValueDomainOrBuilder();

    /**
     *
     *
     * <pre>
     * Specifies the index of the values of the input tensor.
     * Required when the input tensor is a sparse representation. Refer to
     * Tensorflow documentation for more details:
     * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
     * </pre>
     *
     * <code>string indices_tensor_name = 6;</code>
     *
     * @return The indicesTensorName.
     */
    java.lang.String getIndicesTensorName();
    /**
     *
     *
     * <pre>
     * Specifies the index of the values of the input tensor.
     * Required when the input tensor is a sparse representation. Refer to
     * Tensorflow documentation for more details:
     * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
     * </pre>
     *
     * <code>string indices_tensor_name = 6;</code>
     *
     * @return The bytes for indicesTensorName.
     */
    com.google.protobuf.ByteString getIndicesTensorNameBytes();

    /**
     *
     *
     * <pre>
     * Specifies the shape of the values of the input if the input is a sparse
     * representation. Refer to Tensorflow documentation for more details:
     * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
     * </pre>
     *
     * <code>string dense_shape_tensor_name = 7;</code>
     *
     * @return The denseShapeTensorName.
     */
    java.lang.String getDenseShapeTensorName();
    /**
     *
     *
     * <pre>
     * Specifies the shape of the values of the input if the input is a sparse
     * representation. Refer to Tensorflow documentation for more details:
     * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
     * </pre>
     *
     * <code>string dense_shape_tensor_name = 7;</code>
     *
     * @return The bytes for denseShapeTensorName.
     */
    com.google.protobuf.ByteString getDenseShapeTensorNameBytes();

    /**
     *
     *
     * <pre>
     * A list of feature names for each index in the input tensor.
     * Required when the input
     * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
     * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
     * </pre>
     *
     * <code>repeated string index_feature_mapping = 8;</code>
     *
     * @return A list containing the indexFeatureMapping.
     */
    java.util.List<java.lang.String> getIndexFeatureMappingList();
    /**
     *
     *
     * <pre>
     * A list of feature names for each index in the input tensor.
     * Required when the input
     * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
     * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
     * </pre>
     *
     * <code>repeated string index_feature_mapping = 8;</code>
     *
     * @return The count of indexFeatureMapping.
     */
    int getIndexFeatureMappingCount();
    /**
     *
     *
     * <pre>
     * A list of feature names for each index in the input tensor.
     * Required when the input
     * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
     * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
     * </pre>
     *
     * <code>repeated string index_feature_mapping = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The indexFeatureMapping at the given index.
     */
    java.lang.String getIndexFeatureMapping(int index);
    /**
     *
     *
     * <pre>
     * A list of feature names for each index in the input tensor.
     * Required when the input
     * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
     * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
     * </pre>
     *
     * <code>repeated string index_feature_mapping = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the indexFeatureMapping at the given index.
     */
    com.google.protobuf.ByteString getIndexFeatureMappingBytes(int index);

    /**
     *
     *
     * <pre>
     * Encoded tensor is a transformation of the input tensor. Must be provided
     * if choosing
     * [Integrated Gradients
     * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution]
     * or [XRAI
     * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution]
     * and the input tensor is not differentiable.
     *
     * An encoded tensor is generated if the input tensor is encoded by a lookup
     * table.
     * </pre>
     *
     * <code>string encoded_tensor_name = 9;</code>
     *
     * @return The encodedTensorName.
     */
    java.lang.String getEncodedTensorName();
    /**
     *
     *
     * <pre>
     * Encoded tensor is a transformation of the input tensor. Must be provided
     * if choosing
     * [Integrated Gradients
     * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution]
     * or [XRAI
     * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution]
     * and the input tensor is not differentiable.
     *
     * An encoded tensor is generated if the input tensor is encoded by a lookup
     * table.
     * </pre>
     *
     * <code>string encoded_tensor_name = 9;</code>
     *
     * @return The bytes for encodedTensorName.
     */
    com.google.protobuf.ByteString getEncodedTensorNameBytes();

    /**
     *
     *
     * <pre>
     * A list of baselines for the encoded tensor.
     *
     * The shape of each baseline should match the shape of the encoded tensor.
     * If a scalar is provided, Vertex AI broadcasts to the same shape as the
     * encoded tensor.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
     */
    java.util.List<com.google.protobuf.Value> getEncodedBaselinesList();
    /**
     *
     *
     * <pre>
     * A list of baselines for the encoded tensor.
     *
     * The shape of each baseline should match the shape of the encoded tensor.
     * If a scalar is provided, Vertex AI broadcasts to the same shape as the
     * encoded tensor.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
     */
    com.google.protobuf.Value getEncodedBaselines(int index);
    /**
     *
     *
     * <pre>
     * A list of baselines for the encoded tensor.
     *
     * The shape of each baseline should match the shape of the encoded tensor.
     * If a scalar is provided, Vertex AI broadcasts to the same shape as the
     * encoded tensor.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
     */
    int getEncodedBaselinesCount();
    /**
     *
     *
     * <pre>
     * A list of baselines for the encoded tensor.
     *
     * The shape of each baseline should match the shape of the encoded tensor.
     * If a scalar is provided, Vertex AI broadcasts to the same shape as the
     * encoded tensor.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
     */
    java.util.List<? extends com.google.protobuf.ValueOrBuilder> getEncodedBaselinesOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of baselines for the encoded tensor.
     *
     * The shape of each baseline should match the shape of the encoded tensor.
     * If a scalar is provided, Vertex AI broadcasts to the same shape as the
     * encoded tensor.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
     */
    com.google.protobuf.ValueOrBuilder getEncodedBaselinesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Visualization configurations for image explanation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization visualization = 11;
     * </code>
     *
     * @return Whether the visualization field is set.
     */
    boolean hasVisualization();
    /**
     *
     *
     * <pre>
     * Visualization configurations for image explanation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization visualization = 11;
     * </code>
     *
     * @return The visualization.
     */
    com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
        getVisualization();
    /**
     *
     *
     * <pre>
     * Visualization configurations for image explanation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization visualization = 11;
     * </code>
     */
    com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.VisualizationOrBuilder
        getVisualizationOrBuilder();

    /**
     *
     *
     * <pre>
     * Name of the group that the input belongs to. Features with the same group
     * name will be treated as one feature when computing attributions. Features
     * grouped together can have different shapes in value. If provided, there
     * will be one single attribution generated in
     * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions],
     * keyed by the group name.
     * </pre>
     *
     * <code>string group_name = 12;</code>
     *
     * @return The groupName.
     */
    java.lang.String getGroupName();
    /**
     *
     *
     * <pre>
     * Name of the group that the input belongs to. Features with the same group
     * name will be treated as one feature when computing attributions. Features
     * grouped together can have different shapes in value. If provided, there
     * will be one single attribution generated in
     * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions],
     * keyed by the group name.
     * </pre>
     *
     * <code>string group_name = 12;</code>
     *
     * @return The bytes for groupName.
     */
    com.google.protobuf.ByteString getGroupNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Metadata of the input of a feature.
   *
   * Fields other than
   * [InputMetadata.input_baselines][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.input_baselines]
   * are applicable only for Models that are using Vertex AI-provided images for
   * Tensorflow.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata}
   */
  public static final class InputMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata)
      InputMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InputMetadata.newBuilder() to construct.
    private InputMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InputMetadata() {
      inputBaselines_ = java.util.Collections.emptyList();
      inputTensorName_ = "";
      encoding_ = 0;
      modality_ = "";
      indicesTensorName_ = "";
      denseShapeTensorName_ = "";
      indexFeatureMapping_ = com.google.protobuf.LazyStringArrayList.emptyList();
      encodedTensorName_ = "";
      encodedBaselines_ = java.util.Collections.emptyList();
      groupName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InputMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
          .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
          .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.class,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Defines how a feature is encoded. Defaults to IDENTITY.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding}
     */
    public enum Encoding implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This is the same as IDENTITY.
       * </pre>
       *
       * <code>ENCODING_UNSPECIFIED = 0;</code>
       */
      ENCODING_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The tensor represents one feature.
       * </pre>
       *
       * <code>IDENTITY = 1;</code>
       */
      IDENTITY(1),
      /**
       *
       *
       * <pre>
       * The tensor represents a bag of features where each index maps to
       * a feature.
       * [InputMetadata.index_feature_mapping][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.index_feature_mapping]
       * must be provided for this encoding. For example:
       * ```
       * input = [27, 6.0, 150]
       * index_feature_mapping = ["age", "height", "weight"]
       * ```
       * </pre>
       *
       * <code>BAG_OF_FEATURES = 2;</code>
       */
      BAG_OF_FEATURES(2),
      /**
       *
       *
       * <pre>
       * The tensor represents a bag of features where each index maps to a
       * feature. Zero values in the tensor indicates feature being
       * non-existent.
       * [InputMetadata.index_feature_mapping][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.index_feature_mapping]
       * must be provided for this encoding. For example:
       * ```
       * input = [2, 0, 5, 0, 1]
       * index_feature_mapping = ["a", "b", "c", "d", "e"]
       * ```
       * </pre>
       *
       * <code>BAG_OF_FEATURES_SPARSE = 3;</code>
       */
      BAG_OF_FEATURES_SPARSE(3),
      /**
       *
       *
       * <pre>
       * The tensor is a list of binaries representing whether a feature exists
       * or not (1 indicates existence).
       * [InputMetadata.index_feature_mapping][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.index_feature_mapping]
       * must be provided for this encoding. For example:
       * ```
       * input = [1, 0, 1, 0, 1]
       * index_feature_mapping = ["a", "b", "c", "d", "e"]
       * ```
       * </pre>
       *
       * <code>INDICATOR = 4;</code>
       */
      INDICATOR(4),
      /**
       *
       *
       * <pre>
       * The tensor is encoded into a 1-dimensional array represented by an
       * encoded tensor.
       * [InputMetadata.encoded_tensor_name][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoded_tensor_name]
       * must be provided for this encoding. For example:
       * ```
       * input = ["This", "is", "a", "test", "."]
       * encoded = [0.1, 0.2, 0.3, 0.4, 0.5]
       * ```
       * </pre>
       *
       * <code>COMBINED_EMBEDDING = 5;</code>
       */
      COMBINED_EMBEDDING(5),
      /**
       *
       *
       * <pre>
       * Select this encoding when the input tensor is encoded into a
       * 2-dimensional array represented by an encoded tensor.
       * [InputMetadata.encoded_tensor_name][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoded_tensor_name]
       * must be provided for this encoding. The first dimension of the encoded
       * tensor's shape is the same as the input tensor's shape. For example:
       * ```
       * input = ["This", "is", "a", "test", "."]
       * encoded = [[0.1, 0.2, 0.3, 0.4, 0.5],
       *            [0.2, 0.1, 0.4, 0.3, 0.5],
       *            [0.5, 0.1, 0.3, 0.5, 0.4],
       *            [0.5, 0.3, 0.1, 0.2, 0.4],
       *            [0.4, 0.3, 0.2, 0.5, 0.1]]
       * ```
       * </pre>
       *
       * <code>CONCAT_EMBEDDING = 6;</code>
       */
      CONCAT_EMBEDDING(6),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This is the same as IDENTITY.
       * </pre>
       *
       * <code>ENCODING_UNSPECIFIED = 0;</code>
       */
      public static final int ENCODING_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The tensor represents one feature.
       * </pre>
       *
       * <code>IDENTITY = 1;</code>
       */
      public static final int IDENTITY_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The tensor represents a bag of features where each index maps to
       * a feature.
       * [InputMetadata.index_feature_mapping][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.index_feature_mapping]
       * must be provided for this encoding. For example:
       * ```
       * input = [27, 6.0, 150]
       * index_feature_mapping = ["age", "height", "weight"]
       * ```
       * </pre>
       *
       * <code>BAG_OF_FEATURES = 2;</code>
       */
      public static final int BAG_OF_FEATURES_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The tensor represents a bag of features where each index maps to a
       * feature. Zero values in the tensor indicates feature being
       * non-existent.
       * [InputMetadata.index_feature_mapping][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.index_feature_mapping]
       * must be provided for this encoding. For example:
       * ```
       * input = [2, 0, 5, 0, 1]
       * index_feature_mapping = ["a", "b", "c", "d", "e"]
       * ```
       * </pre>
       *
       * <code>BAG_OF_FEATURES_SPARSE = 3;</code>
       */
      public static final int BAG_OF_FEATURES_SPARSE_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The tensor is a list of binaries representing whether a feature exists
       * or not (1 indicates existence).
       * [InputMetadata.index_feature_mapping][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.index_feature_mapping]
       * must be provided for this encoding. For example:
       * ```
       * input = [1, 0, 1, 0, 1]
       * index_feature_mapping = ["a", "b", "c", "d", "e"]
       * ```
       * </pre>
       *
       * <code>INDICATOR = 4;</code>
       */
      public static final int INDICATOR_VALUE = 4;
      /**
       *
       *
       * <pre>
       * The tensor is encoded into a 1-dimensional array represented by an
       * encoded tensor.
       * [InputMetadata.encoded_tensor_name][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoded_tensor_name]
       * must be provided for this encoding. For example:
       * ```
       * input = ["This", "is", "a", "test", "."]
       * encoded = [0.1, 0.2, 0.3, 0.4, 0.5]
       * ```
       * </pre>
       *
       * <code>COMBINED_EMBEDDING = 5;</code>
       */
      public static final int COMBINED_EMBEDDING_VALUE = 5;
      /**
       *
       *
       * <pre>
       * Select this encoding when the input tensor is encoded into a
       * 2-dimensional array represented by an encoded tensor.
       * [InputMetadata.encoded_tensor_name][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoded_tensor_name]
       * must be provided for this encoding. The first dimension of the encoded
       * tensor's shape is the same as the input tensor's shape. For example:
       * ```
       * input = ["This", "is", "a", "test", "."]
       * encoded = [[0.1, 0.2, 0.3, 0.4, 0.5],
       *            [0.2, 0.1, 0.4, 0.3, 0.5],
       *            [0.5, 0.1, 0.3, 0.5, 0.4],
       *            [0.5, 0.3, 0.1, 0.2, 0.4],
       *            [0.4, 0.3, 0.2, 0.5, 0.1]]
       * ```
       * </pre>
       *
       * <code>CONCAT_EMBEDDING = 6;</code>
       */
      public static final int CONCAT_EMBEDDING_VALUE = 6;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Encoding valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Encoding forNumber(int value) {
        switch (value) {
          case 0:
            return ENCODING_UNSPECIFIED;
          case 1:
            return IDENTITY;
          case 2:
            return BAG_OF_FEATURES;
          case 3:
            return BAG_OF_FEATURES_SPARSE;
          case 4:
            return INDICATOR;
          case 5:
            return COMBINED_EMBEDDING;
          case 6:
            return CONCAT_EMBEDDING;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Encoding> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Encoding> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Encoding>() {
            public Encoding findValueByNumber(int number) {
              return Encoding.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Encoding[] VALUES = values();

      public static Encoding valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Encoding(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding)
    }

    public interface FeatureValueDomainOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The minimum permissible value for this feature.
       * </pre>
       *
       * <code>float min_value = 1;</code>
       *
       * @return The minValue.
       */
      float getMinValue();

      /**
       *
       *
       * <pre>
       * The maximum permissible value for this feature.
       * </pre>
       *
       * <code>float max_value = 2;</code>
       *
       * @return The maxValue.
       */
      float getMaxValue();

      /**
       *
       *
       * <pre>
       * If this input feature has been normalized to a mean value of 0,
       * the original_mean specifies the mean value of the domain prior to
       * normalization.
       * </pre>
       *
       * <code>float original_mean = 3;</code>
       *
       * @return The originalMean.
       */
      float getOriginalMean();

      /**
       *
       *
       * <pre>
       * If this input feature has been normalized to a standard deviation of
       * 1.0, the original_stddev specifies the standard deviation of the domain
       * prior to normalization.
       * </pre>
       *
       * <code>float original_stddev = 4;</code>
       *
       * @return The originalStddev.
       */
      float getOriginalStddev();
    }
    /**
     *
     *
     * <pre>
     * Domain details of the input feature value. Provides numeric information
     * about the feature, such as its range (min, max). If the feature has been
     * pre-processed, for example with z-scoring, then it provides information
     * about how to recover the original feature. For example, if the input
     * feature is an image and it has been pre-processed to obtain 0-mean and
     * stddev = 1 values, then original_mean, and original_stddev refer to the
     * mean and stddev of the original feature (e.g. image tensor) from which
     * input feature (with mean = 0 and stddev = 1) was obtained.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain}
     */
    public static final class FeatureValueDomain extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain)
        FeatureValueDomainOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FeatureValueDomain.newBuilder() to construct.
      private FeatureValueDomain(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FeatureValueDomain() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FeatureValueDomain();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
            .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputMetadata_FeatureValueDomain_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
            .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputMetadata_FeatureValueDomain_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
                    .class,
                com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
                    .Builder.class);
      }

      public static final int MIN_VALUE_FIELD_NUMBER = 1;
      private float minValue_ = 0F;
      /**
       *
       *
       * <pre>
       * The minimum permissible value for this feature.
       * </pre>
       *
       * <code>float min_value = 1;</code>
       *
       * @return The minValue.
       */
      @java.lang.Override
      public float getMinValue() {
        return minValue_;
      }

      public static final int MAX_VALUE_FIELD_NUMBER = 2;
      private float maxValue_ = 0F;
      /**
       *
       *
       * <pre>
       * The maximum permissible value for this feature.
       * </pre>
       *
       * <code>float max_value = 2;</code>
       *
       * @return The maxValue.
       */
      @java.lang.Override
      public float getMaxValue() {
        return maxValue_;
      }

      public static final int ORIGINAL_MEAN_FIELD_NUMBER = 3;
      private float originalMean_ = 0F;
      /**
       *
       *
       * <pre>
       * If this input feature has been normalized to a mean value of 0,
       * the original_mean specifies the mean value of the domain prior to
       * normalization.
       * </pre>
       *
       * <code>float original_mean = 3;</code>
       *
       * @return The originalMean.
       */
      @java.lang.Override
      public float getOriginalMean() {
        return originalMean_;
      }

      public static final int ORIGINAL_STDDEV_FIELD_NUMBER = 4;
      private float originalStddev_ = 0F;
      /**
       *
       *
       * <pre>
       * If this input feature has been normalized to a standard deviation of
       * 1.0, the original_stddev specifies the standard deviation of the domain
       * prior to normalization.
       * </pre>
       *
       * <code>float original_stddev = 4;</code>
       *
       * @return The originalStddev.
       */
      @java.lang.Override
      public float getOriginalStddev() {
        return originalStddev_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (java.lang.Float.floatToRawIntBits(minValue_) != 0) {
          output.writeFloat(1, minValue_);
        }
        if (java.lang.Float.floatToRawIntBits(maxValue_) != 0) {
          output.writeFloat(2, maxValue_);
        }
        if (java.lang.Float.floatToRawIntBits(originalMean_) != 0) {
          output.writeFloat(3, originalMean_);
        }
        if (java.lang.Float.floatToRawIntBits(originalStddev_) != 0) {
          output.writeFloat(4, originalStddev_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (java.lang.Float.floatToRawIntBits(minValue_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, minValue_);
        }
        if (java.lang.Float.floatToRawIntBits(maxValue_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, maxValue_);
        }
        if (java.lang.Float.floatToRawIntBits(originalMean_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, originalMean_);
        }
        if (java.lang.Float.floatToRawIntBits(originalStddev_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, originalStddev_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain other =
            (com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain)
                obj;

        if (java.lang.Float.floatToIntBits(getMinValue())
            != java.lang.Float.floatToIntBits(other.getMinValue())) return false;
        if (java.lang.Float.floatToIntBits(getMaxValue())
            != java.lang.Float.floatToIntBits(other.getMaxValue())) return false;
        if (java.lang.Float.floatToIntBits(getOriginalMean())
            != java.lang.Float.floatToIntBits(other.getOriginalMean())) return false;
        if (java.lang.Float.floatToIntBits(getOriginalStddev())
            != java.lang.Float.floatToIntBits(other.getOriginalStddev())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MIN_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getMinValue());
        hash = (37 * hash) + MAX_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getMaxValue());
        hash = (37 * hash) + ORIGINAL_MEAN_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getOriginalMean());
        hash = (37 * hash) + ORIGINAL_STDDEV_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getOriginalStddev());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomain
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomain
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomain
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomain
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomain
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomain
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomain
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomain
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomain
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomain
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomain
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomain
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Domain details of the input feature value. Provides numeric information
       * about the feature, such as its range (min, max). If the feature has been
       * pre-processed, for example with z-scoring, then it provides information
       * about how to recover the original feature. For example, if the input
       * feature is an image and it has been pre-processed to obtain 0-mean and
       * stddev = 1 values, then original_mean, and original_stddev refer to the
       * mean and stddev of the original feature (e.g. image tensor) from which
       * input feature (with mean = 0 and stddev = 1) was obtained.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain)
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomainOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
              .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputMetadata_FeatureValueDomain_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
              .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputMetadata_FeatureValueDomain_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                      .FeatureValueDomain.class,
                  com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                      .FeatureValueDomain.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          minValue_ = 0F;
          maxValue_ = 0F;
          originalMean_ = 0F;
          originalStddev_ = 0F;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
              .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputMetadata_FeatureValueDomain_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
            build() {
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
            buildPartial() {
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
              result =
                  new com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                      .FeatureValueDomain(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.minValue_ = minValue_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.maxValue_ = maxValue_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.originalMean_ = originalMean_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.originalStddev_ = originalStddev_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                        .FeatureValueDomain)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
                other) {
          if (other
              == com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
                  .getDefaultInstance()) return this;
          if (other.getMinValue() != 0F) {
            setMinValue(other.getMinValue());
          }
          if (other.getMaxValue() != 0F) {
            setMaxValue(other.getMaxValue());
          }
          if (other.getOriginalMean() != 0F) {
            setOriginalMean(other.getOriginalMean());
          }
          if (other.getOriginalStddev() != 0F) {
            setOriginalStddev(other.getOriginalStddev());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 13:
                  {
                    minValue_ = input.readFloat();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 13
                case 21:
                  {
                    maxValue_ = input.readFloat();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 21
                case 29:
                  {
                    originalMean_ = input.readFloat();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 29
                case 37:
                  {
                    originalStddev_ = input.readFloat();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 37
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private float minValue_;
        /**
         *
         *
         * <pre>
         * The minimum permissible value for this feature.
         * </pre>
         *
         * <code>float min_value = 1;</code>
         *
         * @return The minValue.
         */
        @java.lang.Override
        public float getMinValue() {
          return minValue_;
        }
        /**
         *
         *
         * <pre>
         * The minimum permissible value for this feature.
         * </pre>
         *
         * <code>float min_value = 1;</code>
         *
         * @param value The minValue to set.
         * @return This builder for chaining.
         */
        public Builder setMinValue(float value) {

          minValue_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The minimum permissible value for this feature.
         * </pre>
         *
         * <code>float min_value = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMinValue() {
          bitField0_ = (bitField0_ & ~0x00000001);
          minValue_ = 0F;
          onChanged();
          return this;
        }

        private float maxValue_;
        /**
         *
         *
         * <pre>
         * The maximum permissible value for this feature.
         * </pre>
         *
         * <code>float max_value = 2;</code>
         *
         * @return The maxValue.
         */
        @java.lang.Override
        public float getMaxValue() {
          return maxValue_;
        }
        /**
         *
         *
         * <pre>
         * The maximum permissible value for this feature.
         * </pre>
         *
         * <code>float max_value = 2;</code>
         *
         * @param value The maxValue to set.
         * @return This builder for chaining.
         */
        public Builder setMaxValue(float value) {

          maxValue_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The maximum permissible value for this feature.
         * </pre>
         *
         * <code>float max_value = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          maxValue_ = 0F;
          onChanged();
          return this;
        }

        private float originalMean_;
        /**
         *
         *
         * <pre>
         * If this input feature has been normalized to a mean value of 0,
         * the original_mean specifies the mean value of the domain prior to
         * normalization.
         * </pre>
         *
         * <code>float original_mean = 3;</code>
         *
         * @return The originalMean.
         */
        @java.lang.Override
        public float getOriginalMean() {
          return originalMean_;
        }
        /**
         *
         *
         * <pre>
         * If this input feature has been normalized to a mean value of 0,
         * the original_mean specifies the mean value of the domain prior to
         * normalization.
         * </pre>
         *
         * <code>float original_mean = 3;</code>
         *
         * @param value The originalMean to set.
         * @return This builder for chaining.
         */
        public Builder setOriginalMean(float value) {

          originalMean_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If this input feature has been normalized to a mean value of 0,
         * the original_mean specifies the mean value of the domain prior to
         * normalization.
         * </pre>
         *
         * <code>float original_mean = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOriginalMean() {
          bitField0_ = (bitField0_ & ~0x00000004);
          originalMean_ = 0F;
          onChanged();
          return this;
        }

        private float originalStddev_;
        /**
         *
         *
         * <pre>
         * If this input feature has been normalized to a standard deviation of
         * 1.0, the original_stddev specifies the standard deviation of the domain
         * prior to normalization.
         * </pre>
         *
         * <code>float original_stddev = 4;</code>
         *
         * @return The originalStddev.
         */
        @java.lang.Override
        public float getOriginalStddev() {
          return originalStddev_;
        }
        /**
         *
         *
         * <pre>
         * If this input feature has been normalized to a standard deviation of
         * 1.0, the original_stddev specifies the standard deviation of the domain
         * prior to normalization.
         * </pre>
         *
         * <code>float original_stddev = 4;</code>
         *
         * @param value The originalStddev to set.
         * @return This builder for chaining.
         */
        public Builder setOriginalStddev(float value) {

          originalStddev_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If this input feature has been normalized to a standard deviation of
         * 1.0, the original_stddev specifies the standard deviation of the domain
         * prior to normalization.
         * </pre>
         *
         * <code>float original_stddev = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOriginalStddev() {
          bitField0_ = (bitField0_ & ~0x00000008);
          originalStddev_ = 0F;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain)
      private static final com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomain
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                .FeatureValueDomain();
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomain
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FeatureValueDomain> PARSER =
          new com.google.protobuf.AbstractParser<FeatureValueDomain>() {
            @java.lang.Override
            public FeatureValueDomain parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FeatureValueDomain> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FeatureValueDomain> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface VisualizationOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Type of the image visualization. Only applicable to
       * [Integrated Gradients
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution].
       * OUTLINES shows regions of attribution, while PIXELS shows per-pixel
       * attribution. Defaults to OUTLINES.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type type = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for type.
       */
      int getTypeValue();
      /**
       *
       *
       * <pre>
       * Type of the image visualization. Only applicable to
       * [Integrated Gradients
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution].
       * OUTLINES shows regions of attribution, while PIXELS shows per-pixel
       * attribution. Defaults to OUTLINES.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type type = 1;
       * </code>
       *
       * @return The type.
       */
      com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type getType();

      /**
       *
       *
       * <pre>
       * Whether to only highlight pixels with positive contributions, negative
       * or both. Defaults to POSITIVE.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity polarity = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for polarity.
       */
      int getPolarityValue();
      /**
       *
       *
       * <pre>
       * Whether to only highlight pixels with positive contributions, negative
       * or both. Defaults to POSITIVE.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity polarity = 2;
       * </code>
       *
       * @return The polarity.
       */
      com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity
          getPolarity();

      /**
       *
       *
       * <pre>
       * The color scheme used for the highlighted areas.
       *
       * Defaults to PINK_GREEN for
       * [Integrated Gradients
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution],
       * which shows positive attributions in green and negative in pink.
       *
       * Defaults to VIRIDIS for
       * [XRAI
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution],
       * which highlights the most influential regions in yellow and the least
       * influential in blue.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap color_map = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for colorMap.
       */
      int getColorMapValue();
      /**
       *
       *
       * <pre>
       * The color scheme used for the highlighted areas.
       *
       * Defaults to PINK_GREEN for
       * [Integrated Gradients
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution],
       * which shows positive attributions in green and negative in pink.
       *
       * Defaults to VIRIDIS for
       * [XRAI
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution],
       * which highlights the most influential regions in yellow and the least
       * influential in blue.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap color_map = 3;
       * </code>
       *
       * @return The colorMap.
       */
      com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap
          getColorMap();

      /**
       *
       *
       * <pre>
       * Excludes attributions above the specified percentile from the
       * highlighted areas. Using the clip_percent_upperbound and
       * clip_percent_lowerbound together can be useful for filtering out noise
       * and making it easier to see areas of strong attribution. Defaults to
       * 99.9.
       * </pre>
       *
       * <code>float clip_percent_upperbound = 4;</code>
       *
       * @return The clipPercentUpperbound.
       */
      float getClipPercentUpperbound();

      /**
       *
       *
       * <pre>
       * Excludes attributions below the specified percentile, from the
       * highlighted areas. Defaults to 62.
       * </pre>
       *
       * <code>float clip_percent_lowerbound = 5;</code>
       *
       * @return The clipPercentLowerbound.
       */
      float getClipPercentLowerbound();

      /**
       *
       *
       * <pre>
       * How the original image is displayed in the visualization.
       * Adjusting the overlay can help increase visual clarity if the original
       * image makes it difficult to view the visualization. Defaults to NONE.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.OverlayType overlay_type = 6;
       * </code>
       *
       * @return The enum numeric value on the wire for overlayType.
       */
      int getOverlayTypeValue();
      /**
       *
       *
       * <pre>
       * How the original image is displayed in the visualization.
       * Adjusting the overlay can help increase visual clarity if the original
       * image makes it difficult to view the visualization. Defaults to NONE.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.OverlayType overlay_type = 6;
       * </code>
       *
       * @return The overlayType.
       */
      com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.OverlayType
          getOverlayType();
    }
    /**
     *
     *
     * <pre>
     * Visualization configurations for image explanation.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization}
     */
    public static final class Visualization extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization)
        VisualizationOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Visualization.newBuilder() to construct.
      private Visualization(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Visualization() {
        type_ = 0;
        polarity_ = 0;
        colorMap_ = 0;
        overlayType_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Visualization();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
            .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputMetadata_Visualization_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
            .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputMetadata_Visualization_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                    .class,
                com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                    .Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Type of the image visualization. Only applicable to
       * [Integrated Gradients
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution].
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type}
       */
      public enum Type implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Should not be used.
         * </pre>
         *
         * <code>TYPE_UNSPECIFIED = 0;</code>
         */
        TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Shows which pixel contributed to the image prediction.
         * </pre>
         *
         * <code>PIXELS = 1;</code>
         */
        PIXELS(1),
        /**
         *
         *
         * <pre>
         * Shows which region contributed to the image prediction by outlining
         * the region.
         * </pre>
         *
         * <code>OUTLINES = 2;</code>
         */
        OUTLINES(2),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Should not be used.
         * </pre>
         *
         * <code>TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int TYPE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Shows which pixel contributed to the image prediction.
         * </pre>
         *
         * <code>PIXELS = 1;</code>
         */
        public static final int PIXELS_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Shows which region contributed to the image prediction by outlining
         * the region.
         * </pre>
         *
         * <code>OUTLINES = 2;</code>
         */
        public static final int OUTLINES_VALUE = 2;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static Type valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static Type forNumber(int value) {
          switch (value) {
            case 0:
              return TYPE_UNSPECIFIED;
            case 1:
              return PIXELS;
            case 2:
              return OUTLINES;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.forNumber(number);
              }
            };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
              .getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final Type[] VALUES = values();

        public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private Type(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type)
      }

      /**
       *
       *
       * <pre>
       * Whether to only highlight pixels with positive contributions, negative
       * or both. Defaults to POSITIVE.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity}
       */
      public enum Polarity implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Default value. This is the same as POSITIVE.
         * </pre>
         *
         * <code>POLARITY_UNSPECIFIED = 0;</code>
         */
        POLARITY_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Highlights the pixels/outlines that were most influential to the
         * model's prediction.
         * </pre>
         *
         * <code>POSITIVE = 1;</code>
         */
        POSITIVE(1),
        /**
         *
         *
         * <pre>
         * Setting polarity to negative highlights areas that does not lead to
         * the models's current prediction.
         * </pre>
         *
         * <code>NEGATIVE = 2;</code>
         */
        NEGATIVE(2),
        /**
         *
         *
         * <pre>
         * Shows both positive and negative attributions.
         * </pre>
         *
         * <code>BOTH = 3;</code>
         */
        BOTH(3),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Default value. This is the same as POSITIVE.
         * </pre>
         *
         * <code>POLARITY_UNSPECIFIED = 0;</code>
         */
        public static final int POLARITY_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Highlights the pixels/outlines that were most influential to the
         * model's prediction.
         * </pre>
         *
         * <code>POSITIVE = 1;</code>
         */
        public static final int POSITIVE_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Setting polarity to negative highlights areas that does not lead to
         * the models's current prediction.
         * </pre>
         *
         * <code>NEGATIVE = 2;</code>
         */
        public static final int NEGATIVE_VALUE = 2;
        /**
         *
         *
         * <pre>
         * Shows both positive and negative attributions.
         * </pre>
         *
         * <code>BOTH = 3;</code>
         */
        public static final int BOTH_VALUE = 3;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static Polarity valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static Polarity forNumber(int value) {
          switch (value) {
            case 0:
              return POLARITY_UNSPECIFIED;
            case 1:
              return POSITIVE;
            case 2:
              return NEGATIVE;
            case 3:
              return BOTH;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<Polarity> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<Polarity> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Polarity>() {
              public Polarity findValueByNumber(int number) {
                return Polarity.forNumber(number);
              }
            };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
              .getDescriptor()
              .getEnumTypes()
              .get(1);
        }

        private static final Polarity[] VALUES = values();

        public static Polarity valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private Polarity(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity)
      }

      /**
       *
       *
       * <pre>
       * The color scheme used for highlighting areas.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap}
       */
      public enum ColorMap implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Should not be used.
         * </pre>
         *
         * <code>COLOR_MAP_UNSPECIFIED = 0;</code>
         */
        COLOR_MAP_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Positive: green. Negative: pink.
         * </pre>
         *
         * <code>PINK_GREEN = 1;</code>
         */
        PINK_GREEN(1),
        /**
         *
         *
         * <pre>
         * Viridis color map: A perceptually uniform color mapping which is
         * easier to see by those with colorblindness and progresses from yellow
         * to green to blue. Positive: yellow. Negative: blue.
         * </pre>
         *
         * <code>VIRIDIS = 2;</code>
         */
        VIRIDIS(2),
        /**
         *
         *
         * <pre>
         * Positive: red. Negative: red.
         * </pre>
         *
         * <code>RED = 3;</code>
         */
        RED(3),
        /**
         *
         *
         * <pre>
         * Positive: green. Negative: green.
         * </pre>
         *
         * <code>GREEN = 4;</code>
         */
        GREEN(4),
        /**
         *
         *
         * <pre>
         * Positive: green. Negative: red.
         * </pre>
         *
         * <code>RED_GREEN = 6;</code>
         */
        RED_GREEN(6),
        /**
         *
         *
         * <pre>
         * PiYG palette.
         * </pre>
         *
         * <code>PINK_WHITE_GREEN = 5;</code>
         */
        PINK_WHITE_GREEN(5),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Should not be used.
         * </pre>
         *
         * <code>COLOR_MAP_UNSPECIFIED = 0;</code>
         */
        public static final int COLOR_MAP_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Positive: green. Negative: pink.
         * </pre>
         *
         * <code>PINK_GREEN = 1;</code>
         */
        public static final int PINK_GREEN_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Viridis color map: A perceptually uniform color mapping which is
         * easier to see by those with colorblindness and progresses from yellow
         * to green to blue. Positive: yellow. Negative: blue.
         * </pre>
         *
         * <code>VIRIDIS = 2;</code>
         */
        public static final int VIRIDIS_VALUE = 2;
        /**
         *
         *
         * <pre>
         * Positive: red. Negative: red.
         * </pre>
         *
         * <code>RED = 3;</code>
         */
        public static final int RED_VALUE = 3;
        /**
         *
         *
         * <pre>
         * Positive: green. Negative: green.
         * </pre>
         *
         * <code>GREEN = 4;</code>
         */
        public static final int GREEN_VALUE = 4;
        /**
         *
         *
         * <pre>
         * Positive: green. Negative: red.
         * </pre>
         *
         * <code>RED_GREEN = 6;</code>
         */
        public static final int RED_GREEN_VALUE = 6;
        /**
         *
         *
         * <pre>
         * PiYG palette.
         * </pre>
         *
         * <code>PINK_WHITE_GREEN = 5;</code>
         */
        public static final int PINK_WHITE_GREEN_VALUE = 5;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ColorMap valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static ColorMap forNumber(int value) {
          switch (value) {
            case 0:
              return COLOR_MAP_UNSPECIFIED;
            case 1:
              return PINK_GREEN;
            case 2:
              return VIRIDIS;
            case 3:
              return RED;
            case 4:
              return GREEN;
            case 6:
              return RED_GREEN;
            case 5:
              return PINK_WHITE_GREEN;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<ColorMap> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<ColorMap> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ColorMap>() {
              public ColorMap findValueByNumber(int number) {
                return ColorMap.forNumber(number);
              }
            };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
              .getDescriptor()
              .getEnumTypes()
              .get(2);
        }

        private static final ColorMap[] VALUES = values();

        public static ColorMap valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private ColorMap(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap)
      }

      /**
       *
       *
       * <pre>
       * How the original image is displayed in the visualization.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.OverlayType}
       */
      public enum OverlayType implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Default value. This is the same as NONE.
         * </pre>
         *
         * <code>OVERLAY_TYPE_UNSPECIFIED = 0;</code>
         */
        OVERLAY_TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * No overlay.
         * </pre>
         *
         * <code>NONE = 1;</code>
         */
        NONE(1),
        /**
         *
         *
         * <pre>
         * The attributions are shown on top of the original image.
         * </pre>
         *
         * <code>ORIGINAL = 2;</code>
         */
        ORIGINAL(2),
        /**
         *
         *
         * <pre>
         * The attributions are shown on top of grayscaled version of the
         * original image.
         * </pre>
         *
         * <code>GRAYSCALE = 3;</code>
         */
        GRAYSCALE(3),
        /**
         *
         *
         * <pre>
         * The attributions are used as a mask to reveal predictive parts of
         * the image and hide the un-predictive parts.
         * </pre>
         *
         * <code>MASK_BLACK = 4;</code>
         */
        MASK_BLACK(4),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Default value. This is the same as NONE.
         * </pre>
         *
         * <code>OVERLAY_TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int OVERLAY_TYPE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * No overlay.
         * </pre>
         *
         * <code>NONE = 1;</code>
         */
        public static final int NONE_VALUE = 1;
        /**
         *
         *
         * <pre>
         * The attributions are shown on top of the original image.
         * </pre>
         *
         * <code>ORIGINAL = 2;</code>
         */
        public static final int ORIGINAL_VALUE = 2;
        /**
         *
         *
         * <pre>
         * The attributions are shown on top of grayscaled version of the
         * original image.
         * </pre>
         *
         * <code>GRAYSCALE = 3;</code>
         */
        public static final int GRAYSCALE_VALUE = 3;
        /**
         *
         *
         * <pre>
         * The attributions are used as a mask to reveal predictive parts of
         * the image and hide the un-predictive parts.
         * </pre>
         *
         * <code>MASK_BLACK = 4;</code>
         */
        public static final int MASK_BLACK_VALUE = 4;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static OverlayType valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static OverlayType forNumber(int value) {
          switch (value) {
            case 0:
              return OVERLAY_TYPE_UNSPECIFIED;
            case 1:
              return NONE;
            case 2:
              return ORIGINAL;
            case 3:
              return GRAYSCALE;
            case 4:
              return MASK_BLACK;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<OverlayType> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<OverlayType>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<OverlayType>() {
                  public OverlayType findValueByNumber(int number) {
                    return OverlayType.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
              .getDescriptor()
              .getEnumTypes()
              .get(3);
        }

        private static final OverlayType[] VALUES = values();

        public static OverlayType valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private OverlayType(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.OverlayType)
      }

      public static final int TYPE_FIELD_NUMBER = 1;
      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * Type of the image visualization. Only applicable to
       * [Integrated Gradients
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution].
       * OUTLINES shows regions of attribution, while PIXELS shows per-pixel
       * attribution. Defaults to OUTLINES.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type type = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * Type of the image visualization. Only applicable to
       * [Integrated Gradients
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution].
       * OUTLINES shows regions of attribution, while PIXELS shows per-pixel
       * attribution. Defaults to OUTLINES.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type type = 1;
       * </code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type
          getType() {
        com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type result =
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type
                .forNumber(type_);
        return result == null
            ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type
                .UNRECOGNIZED
            : result;
      }

      public static final int POLARITY_FIELD_NUMBER = 2;
      private int polarity_ = 0;
      /**
       *
       *
       * <pre>
       * Whether to only highlight pixels with positive contributions, negative
       * or both. Defaults to POSITIVE.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity polarity = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for polarity.
       */
      @java.lang.Override
      public int getPolarityValue() {
        return polarity_;
      }
      /**
       *
       *
       * <pre>
       * Whether to only highlight pixels with positive contributions, negative
       * or both. Defaults to POSITIVE.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity polarity = 2;
       * </code>
       *
       * @return The polarity.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity
          getPolarity() {
        com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity
            result =
                com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                    .Polarity.forNumber(polarity_);
        return result == null
            ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                .Polarity.UNRECOGNIZED
            : result;
      }

      public static final int COLOR_MAP_FIELD_NUMBER = 3;
      private int colorMap_ = 0;
      /**
       *
       *
       * <pre>
       * The color scheme used for the highlighted areas.
       *
       * Defaults to PINK_GREEN for
       * [Integrated Gradients
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution],
       * which shows positive attributions in green and negative in pink.
       *
       * Defaults to VIRIDIS for
       * [XRAI
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution],
       * which highlights the most influential regions in yellow and the least
       * influential in blue.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap color_map = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for colorMap.
       */
      @java.lang.Override
      public int getColorMapValue() {
        return colorMap_;
      }
      /**
       *
       *
       * <pre>
       * The color scheme used for the highlighted areas.
       *
       * Defaults to PINK_GREEN for
       * [Integrated Gradients
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution],
       * which shows positive attributions in green and negative in pink.
       *
       * Defaults to VIRIDIS for
       * [XRAI
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution],
       * which highlights the most influential regions in yellow and the least
       * influential in blue.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap color_map = 3;
       * </code>
       *
       * @return The colorMap.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap
          getColorMap() {
        com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap
            result =
                com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                    .ColorMap.forNumber(colorMap_);
        return result == null
            ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                .ColorMap.UNRECOGNIZED
            : result;
      }

      public static final int CLIP_PERCENT_UPPERBOUND_FIELD_NUMBER = 4;
      private float clipPercentUpperbound_ = 0F;
      /**
       *
       *
       * <pre>
       * Excludes attributions above the specified percentile from the
       * highlighted areas. Using the clip_percent_upperbound and
       * clip_percent_lowerbound together can be useful for filtering out noise
       * and making it easier to see areas of strong attribution. Defaults to
       * 99.9.
       * </pre>
       *
       * <code>float clip_percent_upperbound = 4;</code>
       *
       * @return The clipPercentUpperbound.
       */
      @java.lang.Override
      public float getClipPercentUpperbound() {
        return clipPercentUpperbound_;
      }

      public static final int CLIP_PERCENT_LOWERBOUND_FIELD_NUMBER = 5;
      private float clipPercentLowerbound_ = 0F;
      /**
       *
       *
       * <pre>
       * Excludes attributions below the specified percentile, from the
       * highlighted areas. Defaults to 62.
       * </pre>
       *
       * <code>float clip_percent_lowerbound = 5;</code>
       *
       * @return The clipPercentLowerbound.
       */
      @java.lang.Override
      public float getClipPercentLowerbound() {
        return clipPercentLowerbound_;
      }

      public static final int OVERLAY_TYPE_FIELD_NUMBER = 6;
      private int overlayType_ = 0;
      /**
       *
       *
       * <pre>
       * How the original image is displayed in the visualization.
       * Adjusting the overlay can help increase visual clarity if the original
       * image makes it difficult to view the visualization. Defaults to NONE.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.OverlayType overlay_type = 6;
       * </code>
       *
       * @return The enum numeric value on the wire for overlayType.
       */
      @java.lang.Override
      public int getOverlayTypeValue() {
        return overlayType_;
      }
      /**
       *
       *
       * <pre>
       * How the original image is displayed in the visualization.
       * Adjusting the overlay can help increase visual clarity if the original
       * image makes it difficult to view the visualization. Defaults to NONE.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.OverlayType overlay_type = 6;
       * </code>
       *
       * @return The overlayType.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
              .OverlayType
          getOverlayType() {
        com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.OverlayType
            result =
                com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                    .OverlayType.forNumber(overlayType_);
        return result == null
            ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                .OverlayType.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (type_
            != com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type
                .TYPE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(1, type_);
        }
        if (polarity_
            != com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                .Polarity.POLARITY_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(2, polarity_);
        }
        if (colorMap_
            != com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                .ColorMap.COLOR_MAP_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(3, colorMap_);
        }
        if (java.lang.Float.floatToRawIntBits(clipPercentUpperbound_) != 0) {
          output.writeFloat(4, clipPercentUpperbound_);
        }
        if (java.lang.Float.floatToRawIntBits(clipPercentLowerbound_) != 0) {
          output.writeFloat(5, clipPercentLowerbound_);
        }
        if (overlayType_
            != com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                .OverlayType.OVERLAY_TYPE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(6, overlayType_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (type_
            != com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type
                .TYPE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
        }
        if (polarity_
            != com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                .Polarity.POLARITY_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, polarity_);
        }
        if (colorMap_
            != com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                .ColorMap.COLOR_MAP_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, colorMap_);
        }
        if (java.lang.Float.floatToRawIntBits(clipPercentUpperbound_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, clipPercentUpperbound_);
        }
        if (java.lang.Float.floatToRawIntBits(clipPercentLowerbound_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, clipPercentLowerbound_);
        }
        if (overlayType_
            != com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                .OverlayType.OVERLAY_TYPE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, overlayType_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization other =
            (com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization) obj;

        if (type_ != other.type_) return false;
        if (polarity_ != other.polarity_) return false;
        if (colorMap_ != other.colorMap_) return false;
        if (java.lang.Float.floatToIntBits(getClipPercentUpperbound())
            != java.lang.Float.floatToIntBits(other.getClipPercentUpperbound())) return false;
        if (java.lang.Float.floatToIntBits(getClipPercentLowerbound())
            != java.lang.Float.floatToIntBits(other.getClipPercentLowerbound())) return false;
        if (overlayType_ != other.overlayType_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + type_;
        hash = (37 * hash) + POLARITY_FIELD_NUMBER;
        hash = (53 * hash) + polarity_;
        hash = (37 * hash) + COLOR_MAP_FIELD_NUMBER;
        hash = (53 * hash) + colorMap_;
        hash = (37 * hash) + CLIP_PERCENT_UPPERBOUND_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getClipPercentUpperbound());
        hash = (37 * hash) + CLIP_PERCENT_LOWERBOUND_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getClipPercentLowerbound());
        hash = (37 * hash) + OVERLAY_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + overlayType_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Visualization configurations for image explanation.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization)
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.VisualizationOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
              .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputMetadata_Visualization_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
              .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputMetadata_Visualization_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                      .class,
                  com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          type_ = 0;
          polarity_ = 0;
          colorMap_ = 0;
          clipPercentUpperbound_ = 0F;
          clipPercentLowerbound_ = 0F;
          overlayType_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
              .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputMetadata_Visualization_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
            build() {
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
            buildPartial() {
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization result =
              new com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.type_ = type_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.polarity_ = polarity_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.colorMap_ = colorMap_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.clipPercentUpperbound_ = clipPercentUpperbound_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.clipPercentLowerbound_ = clipPercentLowerbound_;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.overlayType_ = overlayType_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization other) {
          if (other
              == com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                  .getDefaultInstance()) return this;
          if (other.type_ != 0) {
            setTypeValue(other.getTypeValue());
          }
          if (other.polarity_ != 0) {
            setPolarityValue(other.getPolarityValue());
          }
          if (other.colorMap_ != 0) {
            setColorMapValue(other.getColorMapValue());
          }
          if (other.getClipPercentUpperbound() != 0F) {
            setClipPercentUpperbound(other.getClipPercentUpperbound());
          }
          if (other.getClipPercentLowerbound() != 0F) {
            setClipPercentLowerbound(other.getClipPercentLowerbound());
          }
          if (other.overlayType_ != 0) {
            setOverlayTypeValue(other.getOverlayTypeValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    type_ = input.readEnum();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    polarity_ = input.readEnum();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    colorMap_ = input.readEnum();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 37:
                  {
                    clipPercentUpperbound_ = input.readFloat();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 37
                case 45:
                  {
                    clipPercentLowerbound_ = input.readFloat();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 45
                case 48:
                  {
                    overlayType_ = input.readEnum();
                    bitField0_ |= 0x00000020;
                    break;
                  } // case 48
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int type_ = 0;
        /**
         *
         *
         * <pre>
         * Type of the image visualization. Only applicable to
         * [Integrated Gradients
         * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution].
         * OUTLINES shows regions of attribution, while PIXELS shows per-pixel
         * attribution. Defaults to OUTLINES.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type type = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for type.
         */
        @java.lang.Override
        public int getTypeValue() {
          return type_;
        }
        /**
         *
         *
         * <pre>
         * Type of the image visualization. Only applicable to
         * [Integrated Gradients
         * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution].
         * OUTLINES shows regions of attribution, while PIXELS shows per-pixel
         * attribution. Defaults to OUTLINES.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type type = 1;
         * </code>
         *
         * @param value The enum numeric value on the wire for type to set.
         * @return This builder for chaining.
         */
        public Builder setTypeValue(int value) {
          type_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Type of the image visualization. Only applicable to
         * [Integrated Gradients
         * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution].
         * OUTLINES shows regions of attribution, while PIXELS shows per-pixel
         * attribution. Defaults to OUTLINES.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type type = 1;
         * </code>
         *
         * @return The type.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type
            getType() {
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type
              result =
                  com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                      .Type.forNumber(type_);
          return result == null
              ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type
                  .UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Type of the image visualization. Only applicable to
         * [Integrated Gradients
         * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution].
         * OUTLINES shows regions of attribution, while PIXELS shows per-pixel
         * attribution. Defaults to OUTLINES.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type type = 1;
         * </code>
         *
         * @param value The type to set.
         * @return This builder for chaining.
         */
        public Builder setType(
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000001;
          type_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Type of the image visualization. Only applicable to
         * [Integrated Gradients
         * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution].
         * OUTLINES shows regions of attribution, while PIXELS shows per-pixel
         * attribution. Defaults to OUTLINES.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Type type = 1;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearType() {
          bitField0_ = (bitField0_ & ~0x00000001);
          type_ = 0;
          onChanged();
          return this;
        }

        private int polarity_ = 0;
        /**
         *
         *
         * <pre>
         * Whether to only highlight pixels with positive contributions, negative
         * or both. Defaults to POSITIVE.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity polarity = 2;
         * </code>
         *
         * @return The enum numeric value on the wire for polarity.
         */
        @java.lang.Override
        public int getPolarityValue() {
          return polarity_;
        }
        /**
         *
         *
         * <pre>
         * Whether to only highlight pixels with positive contributions, negative
         * or both. Defaults to POSITIVE.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity polarity = 2;
         * </code>
         *
         * @param value The enum numeric value on the wire for polarity to set.
         * @return This builder for chaining.
         */
        public Builder setPolarityValue(int value) {
          polarity_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Whether to only highlight pixels with positive contributions, negative
         * or both. Defaults to POSITIVE.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity polarity = 2;
         * </code>
         *
         * @return The polarity.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                .Polarity
            getPolarity() {
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity
              result =
                  com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                      .Polarity.forNumber(polarity_);
          return result == null
              ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                  .Polarity.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Whether to only highlight pixels with positive contributions, negative
         * or both. Defaults to POSITIVE.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity polarity = 2;
         * </code>
         *
         * @param value The polarity to set.
         * @return This builder for chaining.
         */
        public Builder setPolarity(
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000002;
          polarity_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Whether to only highlight pixels with positive contributions, negative
         * or both. Defaults to POSITIVE.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Polarity polarity = 2;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPolarity() {
          bitField0_ = (bitField0_ & ~0x00000002);
          polarity_ = 0;
          onChanged();
          return this;
        }

        private int colorMap_ = 0;
        /**
         *
         *
         * <pre>
         * The color scheme used for the highlighted areas.
         *
         * Defaults to PINK_GREEN for
         * [Integrated Gradients
         * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution],
         * which shows positive attributions in green and negative in pink.
         *
         * Defaults to VIRIDIS for
         * [XRAI
         * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution],
         * which highlights the most influential regions in yellow and the least
         * influential in blue.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap color_map = 3;
         * </code>
         *
         * @return The enum numeric value on the wire for colorMap.
         */
        @java.lang.Override
        public int getColorMapValue() {
          return colorMap_;
        }
        /**
         *
         *
         * <pre>
         * The color scheme used for the highlighted areas.
         *
         * Defaults to PINK_GREEN for
         * [Integrated Gradients
         * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution],
         * which shows positive attributions in green and negative in pink.
         *
         * Defaults to VIRIDIS for
         * [XRAI
         * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution],
         * which highlights the most influential regions in yellow and the least
         * influential in blue.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap color_map = 3;
         * </code>
         *
         * @param value The enum numeric value on the wire for colorMap to set.
         * @return This builder for chaining.
         */
        public Builder setColorMapValue(int value) {
          colorMap_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The color scheme used for the highlighted areas.
         *
         * Defaults to PINK_GREEN for
         * [Integrated Gradients
         * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution],
         * which shows positive attributions in green and negative in pink.
         *
         * Defaults to VIRIDIS for
         * [XRAI
         * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution],
         * which highlights the most influential regions in yellow and the least
         * influential in blue.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap color_map = 3;
         * </code>
         *
         * @return The colorMap.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                .ColorMap
            getColorMap() {
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap
              result =
                  com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                      .ColorMap.forNumber(colorMap_);
          return result == null
              ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                  .ColorMap.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * The color scheme used for the highlighted areas.
         *
         * Defaults to PINK_GREEN for
         * [Integrated Gradients
         * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution],
         * which shows positive attributions in green and negative in pink.
         *
         * Defaults to VIRIDIS for
         * [XRAI
         * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution],
         * which highlights the most influential regions in yellow and the least
         * influential in blue.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap color_map = 3;
         * </code>
         *
         * @param value The colorMap to set.
         * @return This builder for chaining.
         */
        public Builder setColorMap(
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000004;
          colorMap_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The color scheme used for the highlighted areas.
         *
         * Defaults to PINK_GREEN for
         * [Integrated Gradients
         * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution],
         * which shows positive attributions in green and negative in pink.
         *
         * Defaults to VIRIDIS for
         * [XRAI
         * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution],
         * which highlights the most influential regions in yellow and the least
         * influential in blue.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.ColorMap color_map = 3;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearColorMap() {
          bitField0_ = (bitField0_ & ~0x00000004);
          colorMap_ = 0;
          onChanged();
          return this;
        }

        private float clipPercentUpperbound_;
        /**
         *
         *
         * <pre>
         * Excludes attributions above the specified percentile from the
         * highlighted areas. Using the clip_percent_upperbound and
         * clip_percent_lowerbound together can be useful for filtering out noise
         * and making it easier to see areas of strong attribution. Defaults to
         * 99.9.
         * </pre>
         *
         * <code>float clip_percent_upperbound = 4;</code>
         *
         * @return The clipPercentUpperbound.
         */
        @java.lang.Override
        public float getClipPercentUpperbound() {
          return clipPercentUpperbound_;
        }
        /**
         *
         *
         * <pre>
         * Excludes attributions above the specified percentile from the
         * highlighted areas. Using the clip_percent_upperbound and
         * clip_percent_lowerbound together can be useful for filtering out noise
         * and making it easier to see areas of strong attribution. Defaults to
         * 99.9.
         * </pre>
         *
         * <code>float clip_percent_upperbound = 4;</code>
         *
         * @param value The clipPercentUpperbound to set.
         * @return This builder for chaining.
         */
        public Builder setClipPercentUpperbound(float value) {

          clipPercentUpperbound_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Excludes attributions above the specified percentile from the
         * highlighted areas. Using the clip_percent_upperbound and
         * clip_percent_lowerbound together can be useful for filtering out noise
         * and making it easier to see areas of strong attribution. Defaults to
         * 99.9.
         * </pre>
         *
         * <code>float clip_percent_upperbound = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearClipPercentUpperbound() {
          bitField0_ = (bitField0_ & ~0x00000008);
          clipPercentUpperbound_ = 0F;
          onChanged();
          return this;
        }

        private float clipPercentLowerbound_;
        /**
         *
         *
         * <pre>
         * Excludes attributions below the specified percentile, from the
         * highlighted areas. Defaults to 62.
         * </pre>
         *
         * <code>float clip_percent_lowerbound = 5;</code>
         *
         * @return The clipPercentLowerbound.
         */
        @java.lang.Override
        public float getClipPercentLowerbound() {
          return clipPercentLowerbound_;
        }
        /**
         *
         *
         * <pre>
         * Excludes attributions below the specified percentile, from the
         * highlighted areas. Defaults to 62.
         * </pre>
         *
         * <code>float clip_percent_lowerbound = 5;</code>
         *
         * @param value The clipPercentLowerbound to set.
         * @return This builder for chaining.
         */
        public Builder setClipPercentLowerbound(float value) {

          clipPercentLowerbound_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Excludes attributions below the specified percentile, from the
         * highlighted areas. Defaults to 62.
         * </pre>
         *
         * <code>float clip_percent_lowerbound = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearClipPercentLowerbound() {
          bitField0_ = (bitField0_ & ~0x00000010);
          clipPercentLowerbound_ = 0F;
          onChanged();
          return this;
        }

        private int overlayType_ = 0;
        /**
         *
         *
         * <pre>
         * How the original image is displayed in the visualization.
         * Adjusting the overlay can help increase visual clarity if the original
         * image makes it difficult to view the visualization. Defaults to NONE.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.OverlayType overlay_type = 6;
         * </code>
         *
         * @return The enum numeric value on the wire for overlayType.
         */
        @java.lang.Override
        public int getOverlayTypeValue() {
          return overlayType_;
        }
        /**
         *
         *
         * <pre>
         * How the original image is displayed in the visualization.
         * Adjusting the overlay can help increase visual clarity if the original
         * image makes it difficult to view the visualization. Defaults to NONE.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.OverlayType overlay_type = 6;
         * </code>
         *
         * @param value The enum numeric value on the wire for overlayType to set.
         * @return This builder for chaining.
         */
        public Builder setOverlayTypeValue(int value) {
          overlayType_ = value;
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * How the original image is displayed in the visualization.
         * Adjusting the overlay can help increase visual clarity if the original
         * image makes it difficult to view the visualization. Defaults to NONE.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.OverlayType overlay_type = 6;
         * </code>
         *
         * @return The overlayType.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                .OverlayType
            getOverlayType() {
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.OverlayType
              result =
                  com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                      .OverlayType.forNumber(overlayType_);
          return result == null
              ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                  .OverlayType.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * How the original image is displayed in the visualization.
         * Adjusting the overlay can help increase visual clarity if the original
         * image makes it difficult to view the visualization. Defaults to NONE.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.OverlayType overlay_type = 6;
         * </code>
         *
         * @param value The overlayType to set.
         * @return This builder for chaining.
         */
        public Builder setOverlayType(
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                    .OverlayType
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000020;
          overlayType_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * How the original image is displayed in the visualization.
         * Adjusting the overlay can help increase visual clarity if the original
         * image makes it difficult to view the visualization. Defaults to NONE.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.OverlayType overlay_type = 6;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOverlayType() {
          bitField0_ = (bitField0_ & ~0x00000020);
          overlayType_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization)
      private static final com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .Visualization
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization();
      }

      public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Visualization> PARSER =
          new com.google.protobuf.AbstractParser<Visualization>() {
            @java.lang.Override
            public Visualization parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Visualization> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Visualization> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int INPUT_BASELINES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.protobuf.Value> inputBaselines_;
    /**
     *
     *
     * <pre>
     * Baseline inputs for this feature.
     *
     * If no baseline is specified, Vertex AI chooses the baseline for this
     * feature. If multiple baselines are specified, Vertex AI returns the
     * average attributions across them in
     * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
     *
     * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
     * of each baseline must match the shape of the input tensor. If a scalar is
     * provided, we broadcast to the same shape as the input tensor.
     *
     * For custom images, the element of the baselines must be in the same
     * format as the feature's input in the
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
     * schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.protobuf.Value> getInputBaselinesList() {
      return inputBaselines_;
    }
    /**
     *
     *
     * <pre>
     * Baseline inputs for this feature.
     *
     * If no baseline is specified, Vertex AI chooses the baseline for this
     * feature. If multiple baselines are specified, Vertex AI returns the
     * average attributions across them in
     * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
     *
     * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
     * of each baseline must match the shape of the input tensor. If a scalar is
     * provided, we broadcast to the same shape as the input tensor.
     *
     * For custom images, the element of the baselines must be in the same
     * format as the feature's input in the
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
     * schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
        getInputBaselinesOrBuilderList() {
      return inputBaselines_;
    }
    /**
     *
     *
     * <pre>
     * Baseline inputs for this feature.
     *
     * If no baseline is specified, Vertex AI chooses the baseline for this
     * feature. If multiple baselines are specified, Vertex AI returns the
     * average attributions across them in
     * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
     *
     * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
     * of each baseline must match the shape of the input tensor. If a scalar is
     * provided, we broadcast to the same shape as the input tensor.
     *
     * For custom images, the element of the baselines must be in the same
     * format as the feature's input in the
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
     * schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
     */
    @java.lang.Override
    public int getInputBaselinesCount() {
      return inputBaselines_.size();
    }
    /**
     *
     *
     * <pre>
     * Baseline inputs for this feature.
     *
     * If no baseline is specified, Vertex AI chooses the baseline for this
     * feature. If multiple baselines are specified, Vertex AI returns the
     * average attributions across them in
     * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
     *
     * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
     * of each baseline must match the shape of the input tensor. If a scalar is
     * provided, we broadcast to the same shape as the input tensor.
     *
     * For custom images, the element of the baselines must be in the same
     * format as the feature's input in the
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
     * schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getInputBaselines(int index) {
      return inputBaselines_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Baseline inputs for this feature.
     *
     * If no baseline is specified, Vertex AI chooses the baseline for this
     * feature. If multiple baselines are specified, Vertex AI returns the
     * average attributions across them in
     * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
     *
     * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
     * of each baseline must match the shape of the input tensor. If a scalar is
     * provided, we broadcast to the same shape as the input tensor.
     *
     * For custom images, the element of the baselines must be in the same
     * format as the feature's input in the
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
     * schema of any single instance may be specified via Endpoint's
     * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.ValueOrBuilder getInputBaselinesOrBuilder(int index) {
      return inputBaselines_.get(index);
    }

    public static final int INPUT_TENSOR_NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object inputTensorName_ = "";
    /**
     *
     *
     * <pre>
     * Name of the input tensor for this feature. Required and is only
     * applicable to Vertex AI-provided images for Tensorflow.
     * </pre>
     *
     * <code>string input_tensor_name = 2;</code>
     *
     * @return The inputTensorName.
     */
    @java.lang.Override
    public java.lang.String getInputTensorName() {
      java.lang.Object ref = inputTensorName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inputTensorName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the input tensor for this feature. Required and is only
     * applicable to Vertex AI-provided images for Tensorflow.
     * </pre>
     *
     * <code>string input_tensor_name = 2;</code>
     *
     * @return The bytes for inputTensorName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInputTensorNameBytes() {
      java.lang.Object ref = inputTensorName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inputTensorName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENCODING_FIELD_NUMBER = 3;
    private int encoding_ = 0;
    /**
     *
     *
     * <pre>
     * Defines how the feature is encoded into the input tensor. Defaults to
     * IDENTITY.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding encoding = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for encoding.
     */
    @java.lang.Override
    public int getEncodingValue() {
      return encoding_;
    }
    /**
     *
     *
     * <pre>
     * Defines how the feature is encoded into the input tensor. Defaults to
     * IDENTITY.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding encoding = 3;
     * </code>
     *
     * @return The encoding.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding getEncoding() {
      com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding result =
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding.forNumber(
              encoding_);
      return result == null
          ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding.UNRECOGNIZED
          : result;
    }

    public static final int MODALITY_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object modality_ = "";
    /**
     *
     *
     * <pre>
     * Modality of the feature. Valid values are: numeric, image. Defaults to
     * numeric.
     * </pre>
     *
     * <code>string modality = 4;</code>
     *
     * @return The modality.
     */
    @java.lang.Override
    public java.lang.String getModality() {
      java.lang.Object ref = modality_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modality_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Modality of the feature. Valid values are: numeric, image. Defaults to
     * numeric.
     * </pre>
     *
     * <code>string modality = 4;</code>
     *
     * @return The bytes for modality.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModalityBytes() {
      java.lang.Object ref = modality_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modality_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FEATURE_VALUE_DOMAIN_FIELD_NUMBER = 5;
    private com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
        featureValueDomain_;
    /**
     *
     *
     * <pre>
     * The domain details of the input feature value. Like min/max, original
     * mean or standard deviation if normalized.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain feature_value_domain = 5;
     * </code>
     *
     * @return Whether the featureValueDomain field is set.
     */
    @java.lang.Override
    public boolean hasFeatureValueDomain() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The domain details of the input feature value. Like min/max, original
     * mean or standard deviation if normalized.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain feature_value_domain = 5;
     * </code>
     *
     * @return The featureValueDomain.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
        getFeatureValueDomain() {
      return featureValueDomain_ == null
          ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
              .getDefaultInstance()
          : featureValueDomain_;
    }
    /**
     *
     *
     * <pre>
     * The domain details of the input feature value. Like min/max, original
     * mean or standard deviation if normalized.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain feature_value_domain = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
            .FeatureValueDomainOrBuilder
        getFeatureValueDomainOrBuilder() {
      return featureValueDomain_ == null
          ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
              .getDefaultInstance()
          : featureValueDomain_;
    }

    public static final int INDICES_TENSOR_NAME_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object indicesTensorName_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the index of the values of the input tensor.
     * Required when the input tensor is a sparse representation. Refer to
     * Tensorflow documentation for more details:
     * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
     * </pre>
     *
     * <code>string indices_tensor_name = 6;</code>
     *
     * @return The indicesTensorName.
     */
    @java.lang.Override
    public java.lang.String getIndicesTensorName() {
      java.lang.Object ref = indicesTensorName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        indicesTensorName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the index of the values of the input tensor.
     * Required when the input tensor is a sparse representation. Refer to
     * Tensorflow documentation for more details:
     * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
     * </pre>
     *
     * <code>string indices_tensor_name = 6;</code>
     *
     * @return The bytes for indicesTensorName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIndicesTensorNameBytes() {
      java.lang.Object ref = indicesTensorName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        indicesTensorName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DENSE_SHAPE_TENSOR_NAME_FIELD_NUMBER = 7;

    @SuppressWarnings("serial")
    private volatile java.lang.Object denseShapeTensorName_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the shape of the values of the input if the input is a sparse
     * representation. Refer to Tensorflow documentation for more details:
     * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
     * </pre>
     *
     * <code>string dense_shape_tensor_name = 7;</code>
     *
     * @return The denseShapeTensorName.
     */
    @java.lang.Override
    public java.lang.String getDenseShapeTensorName() {
      java.lang.Object ref = denseShapeTensorName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        denseShapeTensorName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the shape of the values of the input if the input is a sparse
     * representation. Refer to Tensorflow documentation for more details:
     * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
     * </pre>
     *
     * <code>string dense_shape_tensor_name = 7;</code>
     *
     * @return The bytes for denseShapeTensorName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDenseShapeTensorNameBytes() {
      java.lang.Object ref = denseShapeTensorName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        denseShapeTensorName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INDEX_FEATURE_MAPPING_FIELD_NUMBER = 8;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList indexFeatureMapping_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * A list of feature names for each index in the input tensor.
     * Required when the input
     * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
     * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
     * </pre>
     *
     * <code>repeated string index_feature_mapping = 8;</code>
     *
     * @return A list containing the indexFeatureMapping.
     */
    public com.google.protobuf.ProtocolStringList getIndexFeatureMappingList() {
      return indexFeatureMapping_;
    }
    /**
     *
     *
     * <pre>
     * A list of feature names for each index in the input tensor.
     * Required when the input
     * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
     * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
     * </pre>
     *
     * <code>repeated string index_feature_mapping = 8;</code>
     *
     * @return The count of indexFeatureMapping.
     */
    public int getIndexFeatureMappingCount() {
      return indexFeatureMapping_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of feature names for each index in the input tensor.
     * Required when the input
     * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
     * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
     * </pre>
     *
     * <code>repeated string index_feature_mapping = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The indexFeatureMapping at the given index.
     */
    public java.lang.String getIndexFeatureMapping(int index) {
      return indexFeatureMapping_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of feature names for each index in the input tensor.
     * Required when the input
     * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
     * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
     * </pre>
     *
     * <code>repeated string index_feature_mapping = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the indexFeatureMapping at the given index.
     */
    public com.google.protobuf.ByteString getIndexFeatureMappingBytes(int index) {
      return indexFeatureMapping_.getByteString(index);
    }

    public static final int ENCODED_TENSOR_NAME_FIELD_NUMBER = 9;

    @SuppressWarnings("serial")
    private volatile java.lang.Object encodedTensorName_ = "";
    /**
     *
     *
     * <pre>
     * Encoded tensor is a transformation of the input tensor. Must be provided
     * if choosing
     * [Integrated Gradients
     * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution]
     * or [XRAI
     * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution]
     * and the input tensor is not differentiable.
     *
     * An encoded tensor is generated if the input tensor is encoded by a lookup
     * table.
     * </pre>
     *
     * <code>string encoded_tensor_name = 9;</code>
     *
     * @return The encodedTensorName.
     */
    @java.lang.Override
    public java.lang.String getEncodedTensorName() {
      java.lang.Object ref = encodedTensorName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        encodedTensorName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Encoded tensor is a transformation of the input tensor. Must be provided
     * if choosing
     * [Integrated Gradients
     * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution]
     * or [XRAI
     * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution]
     * and the input tensor is not differentiable.
     *
     * An encoded tensor is generated if the input tensor is encoded by a lookup
     * table.
     * </pre>
     *
     * <code>string encoded_tensor_name = 9;</code>
     *
     * @return The bytes for encodedTensorName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEncodedTensorNameBytes() {
      java.lang.Object ref = encodedTensorName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        encodedTensorName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENCODED_BASELINES_FIELD_NUMBER = 10;

    @SuppressWarnings("serial")
    private java.util.List<com.google.protobuf.Value> encodedBaselines_;
    /**
     *
     *
     * <pre>
     * A list of baselines for the encoded tensor.
     *
     * The shape of each baseline should match the shape of the encoded tensor.
     * If a scalar is provided, Vertex AI broadcasts to the same shape as the
     * encoded tensor.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.protobuf.Value> getEncodedBaselinesList() {
      return encodedBaselines_;
    }
    /**
     *
     *
     * <pre>
     * A list of baselines for the encoded tensor.
     *
     * The shape of each baseline should match the shape of the encoded tensor.
     * If a scalar is provided, Vertex AI broadcasts to the same shape as the
     * encoded tensor.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
        getEncodedBaselinesOrBuilderList() {
      return encodedBaselines_;
    }
    /**
     *
     *
     * <pre>
     * A list of baselines for the encoded tensor.
     *
     * The shape of each baseline should match the shape of the encoded tensor.
     * If a scalar is provided, Vertex AI broadcasts to the same shape as the
     * encoded tensor.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
     */
    @java.lang.Override
    public int getEncodedBaselinesCount() {
      return encodedBaselines_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of baselines for the encoded tensor.
     *
     * The shape of each baseline should match the shape of the encoded tensor.
     * If a scalar is provided, Vertex AI broadcasts to the same shape as the
     * encoded tensor.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getEncodedBaselines(int index) {
      return encodedBaselines_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of baselines for the encoded tensor.
     *
     * The shape of each baseline should match the shape of the encoded tensor.
     * If a scalar is provided, Vertex AI broadcasts to the same shape as the
     * encoded tensor.
     * </pre>
     *
     * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
     */
    @java.lang.Override
    public com.google.protobuf.ValueOrBuilder getEncodedBaselinesOrBuilder(int index) {
      return encodedBaselines_.get(index);
    }

    public static final int VISUALIZATION_FIELD_NUMBER = 11;
    private com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
        visualization_;
    /**
     *
     *
     * <pre>
     * Visualization configurations for image explanation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization visualization = 11;
     * </code>
     *
     * @return Whether the visualization field is set.
     */
    @java.lang.Override
    public boolean hasVisualization() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Visualization configurations for image explanation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization visualization = 11;
     * </code>
     *
     * @return The visualization.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
        getVisualization() {
      return visualization_ == null
          ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
              .getDefaultInstance()
          : visualization_;
    }
    /**
     *
     *
     * <pre>
     * Visualization configurations for image explanation.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization visualization = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.VisualizationOrBuilder
        getVisualizationOrBuilder() {
      return visualization_ == null
          ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
              .getDefaultInstance()
          : visualization_;
    }

    public static final int GROUP_NAME_FIELD_NUMBER = 12;

    @SuppressWarnings("serial")
    private volatile java.lang.Object groupName_ = "";
    /**
     *
     *
     * <pre>
     * Name of the group that the input belongs to. Features with the same group
     * name will be treated as one feature when computing attributions. Features
     * grouped together can have different shapes in value. If provided, there
     * will be one single attribution generated in
     * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions],
     * keyed by the group name.
     * </pre>
     *
     * <code>string group_name = 12;</code>
     *
     * @return The groupName.
     */
    @java.lang.Override
    public java.lang.String getGroupName() {
      java.lang.Object ref = groupName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        groupName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the group that the input belongs to. Features with the same group
     * name will be treated as one feature when computing attributions. Features
     * grouped together can have different shapes in value. If provided, there
     * will be one single attribution generated in
     * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions],
     * keyed by the group name.
     * </pre>
     *
     * <code>string group_name = 12;</code>
     *
     * @return The bytes for groupName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGroupNameBytes() {
      java.lang.Object ref = groupName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        groupName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < inputBaselines_.size(); i++) {
        output.writeMessage(1, inputBaselines_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputTensorName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, inputTensorName_);
      }
      if (encoding_
          != com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding
              .ENCODING_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, encoding_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modality_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, modality_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(5, getFeatureValueDomain());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(indicesTensorName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, indicesTensorName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(denseShapeTensorName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, denseShapeTensorName_);
      }
      for (int i = 0; i < indexFeatureMapping_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 8, indexFeatureMapping_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(encodedTensorName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 9, encodedTensorName_);
      }
      for (int i = 0; i < encodedBaselines_.size(); i++) {
        output.writeMessage(10, encodedBaselines_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(11, getVisualization());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(groupName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 12, groupName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < inputBaselines_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, inputBaselines_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputTensorName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, inputTensorName_);
      }
      if (encoding_
          != com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding
              .ENCODING_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, encoding_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modality_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, modality_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(5, getFeatureValueDomain());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(indicesTensorName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, indicesTensorName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(denseShapeTensorName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, denseShapeTensorName_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < indexFeatureMapping_.size(); i++) {
          dataSize += computeStringSizeNoTag(indexFeatureMapping_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getIndexFeatureMappingList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(encodedTensorName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, encodedTensorName_);
      }
      for (int i = 0; i < encodedBaselines_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(10, encodedBaselines_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getVisualization());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(groupName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, groupName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata other =
          (com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata) obj;

      if (!getInputBaselinesList().equals(other.getInputBaselinesList())) return false;
      if (!getInputTensorName().equals(other.getInputTensorName())) return false;
      if (encoding_ != other.encoding_) return false;
      if (!getModality().equals(other.getModality())) return false;
      if (hasFeatureValueDomain() != other.hasFeatureValueDomain()) return false;
      if (hasFeatureValueDomain()) {
        if (!getFeatureValueDomain().equals(other.getFeatureValueDomain())) return false;
      }
      if (!getIndicesTensorName().equals(other.getIndicesTensorName())) return false;
      if (!getDenseShapeTensorName().equals(other.getDenseShapeTensorName())) return false;
      if (!getIndexFeatureMappingList().equals(other.getIndexFeatureMappingList())) return false;
      if (!getEncodedTensorName().equals(other.getEncodedTensorName())) return false;
      if (!getEncodedBaselinesList().equals(other.getEncodedBaselinesList())) return false;
      if (hasVisualization() != other.hasVisualization()) return false;
      if (hasVisualization()) {
        if (!getVisualization().equals(other.getVisualization())) return false;
      }
      if (!getGroupName().equals(other.getGroupName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getInputBaselinesCount() > 0) {
        hash = (37 * hash) + INPUT_BASELINES_FIELD_NUMBER;
        hash = (53 * hash) + getInputBaselinesList().hashCode();
      }
      hash = (37 * hash) + INPUT_TENSOR_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getInputTensorName().hashCode();
      hash = (37 * hash) + ENCODING_FIELD_NUMBER;
      hash = (53 * hash) + encoding_;
      hash = (37 * hash) + MODALITY_FIELD_NUMBER;
      hash = (53 * hash) + getModality().hashCode();
      if (hasFeatureValueDomain()) {
        hash = (37 * hash) + FEATURE_VALUE_DOMAIN_FIELD_NUMBER;
        hash = (53 * hash) + getFeatureValueDomain().hashCode();
      }
      hash = (37 * hash) + INDICES_TENSOR_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getIndicesTensorName().hashCode();
      hash = (37 * hash) + DENSE_SHAPE_TENSOR_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDenseShapeTensorName().hashCode();
      if (getIndexFeatureMappingCount() > 0) {
        hash = (37 * hash) + INDEX_FEATURE_MAPPING_FIELD_NUMBER;
        hash = (53 * hash) + getIndexFeatureMappingList().hashCode();
      }
      hash = (37 * hash) + ENCODED_TENSOR_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getEncodedTensorName().hashCode();
      if (getEncodedBaselinesCount() > 0) {
        hash = (37 * hash) + ENCODED_BASELINES_FIELD_NUMBER;
        hash = (53 * hash) + getEncodedBaselinesList().hashCode();
      }
      if (hasVisualization()) {
        hash = (37 * hash) + VISUALIZATION_FIELD_NUMBER;
        hash = (53 * hash) + getVisualization().hashCode();
      }
      hash = (37 * hash) + GROUP_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getGroupName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the input of a feature.
     *
     * Fields other than
     * [InputMetadata.input_baselines][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.input_baselines]
     * are applicable only for Models that are using Vertex AI-provided images for
     * Tensorflow.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata)
        com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
            .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
            .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.class,
                com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getInputBaselinesFieldBuilder();
          getFeatureValueDomainFieldBuilder();
          getEncodedBaselinesFieldBuilder();
          getVisualizationFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (inputBaselinesBuilder_ == null) {
          inputBaselines_ = java.util.Collections.emptyList();
        } else {
          inputBaselines_ = null;
          inputBaselinesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        inputTensorName_ = "";
        encoding_ = 0;
        modality_ = "";
        featureValueDomain_ = null;
        if (featureValueDomainBuilder_ != null) {
          featureValueDomainBuilder_.dispose();
          featureValueDomainBuilder_ = null;
        }
        indicesTensorName_ = "";
        denseShapeTensorName_ = "";
        indexFeatureMapping_ = com.google.protobuf.LazyStringArrayList.emptyList();
        encodedTensorName_ = "";
        if (encodedBaselinesBuilder_ == null) {
          encodedBaselines_ = java.util.Collections.emptyList();
        } else {
          encodedBaselines_ = null;
          encodedBaselinesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000200);
        visualization_ = null;
        if (visualizationBuilder_ != null) {
          visualizationBuilder_.dispose();
          visualizationBuilder_ = null;
        }
        groupName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
            .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata build() {
        com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata buildPartial() {
        com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata result =
            new com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata result) {
        if (inputBaselinesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            inputBaselines_ = java.util.Collections.unmodifiableList(inputBaselines_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.inputBaselines_ = inputBaselines_;
        } else {
          result.inputBaselines_ = inputBaselinesBuilder_.build();
        }
        if (encodedBaselinesBuilder_ == null) {
          if (((bitField0_ & 0x00000200) != 0)) {
            encodedBaselines_ = java.util.Collections.unmodifiableList(encodedBaselines_);
            bitField0_ = (bitField0_ & ~0x00000200);
          }
          result.encodedBaselines_ = encodedBaselines_;
        } else {
          result.encodedBaselines_ = encodedBaselinesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.inputTensorName_ = inputTensorName_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.encoding_ = encoding_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.modality_ = modality_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.featureValueDomain_ =
              featureValueDomainBuilder_ == null
                  ? featureValueDomain_
                  : featureValueDomainBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.indicesTensorName_ = indicesTensorName_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.denseShapeTensorName_ = denseShapeTensorName_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          indexFeatureMapping_.makeImmutable();
          result.indexFeatureMapping_ = indexFeatureMapping_;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.encodedTensorName_ = encodedTensorName_;
        }
        if (((from_bitField0_ & 0x00000400) != 0)) {
          result.visualization_ =
              visualizationBuilder_ == null ? visualization_ : visualizationBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000800) != 0)) {
          result.groupName_ = groupName_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata other) {
        if (other
            == com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                .getDefaultInstance()) return this;
        if (inputBaselinesBuilder_ == null) {
          if (!other.inputBaselines_.isEmpty()) {
            if (inputBaselines_.isEmpty()) {
              inputBaselines_ = other.inputBaselines_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureInputBaselinesIsMutable();
              inputBaselines_.addAll(other.inputBaselines_);
            }
            onChanged();
          }
        } else {
          if (!other.inputBaselines_.isEmpty()) {
            if (inputBaselinesBuilder_.isEmpty()) {
              inputBaselinesBuilder_.dispose();
              inputBaselinesBuilder_ = null;
              inputBaselines_ = other.inputBaselines_;
              bitField0_ = (bitField0_ & ~0x00000001);
              inputBaselinesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getInputBaselinesFieldBuilder()
                      : null;
            } else {
              inputBaselinesBuilder_.addAllMessages(other.inputBaselines_);
            }
          }
        }
        if (!other.getInputTensorName().isEmpty()) {
          inputTensorName_ = other.inputTensorName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.encoding_ != 0) {
          setEncodingValue(other.getEncodingValue());
        }
        if (!other.getModality().isEmpty()) {
          modality_ = other.modality_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (other.hasFeatureValueDomain()) {
          mergeFeatureValueDomain(other.getFeatureValueDomain());
        }
        if (!other.getIndicesTensorName().isEmpty()) {
          indicesTensorName_ = other.indicesTensorName_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        if (!other.getDenseShapeTensorName().isEmpty()) {
          denseShapeTensorName_ = other.denseShapeTensorName_;
          bitField0_ |= 0x00000040;
          onChanged();
        }
        if (!other.indexFeatureMapping_.isEmpty()) {
          if (indexFeatureMapping_.isEmpty()) {
            indexFeatureMapping_ = other.indexFeatureMapping_;
            bitField0_ |= 0x00000080;
          } else {
            ensureIndexFeatureMappingIsMutable();
            indexFeatureMapping_.addAll(other.indexFeatureMapping_);
          }
          onChanged();
        }
        if (!other.getEncodedTensorName().isEmpty()) {
          encodedTensorName_ = other.encodedTensorName_;
          bitField0_ |= 0x00000100;
          onChanged();
        }
        if (encodedBaselinesBuilder_ == null) {
          if (!other.encodedBaselines_.isEmpty()) {
            if (encodedBaselines_.isEmpty()) {
              encodedBaselines_ = other.encodedBaselines_;
              bitField0_ = (bitField0_ & ~0x00000200);
            } else {
              ensureEncodedBaselinesIsMutable();
              encodedBaselines_.addAll(other.encodedBaselines_);
            }
            onChanged();
          }
        } else {
          if (!other.encodedBaselines_.isEmpty()) {
            if (encodedBaselinesBuilder_.isEmpty()) {
              encodedBaselinesBuilder_.dispose();
              encodedBaselinesBuilder_ = null;
              encodedBaselines_ = other.encodedBaselines_;
              bitField0_ = (bitField0_ & ~0x00000200);
              encodedBaselinesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getEncodedBaselinesFieldBuilder()
                      : null;
            } else {
              encodedBaselinesBuilder_.addAllMessages(other.encodedBaselines_);
            }
          }
        }
        if (other.hasVisualization()) {
          mergeVisualization(other.getVisualization());
        }
        if (!other.getGroupName().isEmpty()) {
          groupName_ = other.groupName_;
          bitField0_ |= 0x00000800;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.protobuf.Value m =
                      input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
                  if (inputBaselinesBuilder_ == null) {
                    ensureInputBaselinesIsMutable();
                    inputBaselines_.add(m);
                  } else {
                    inputBaselinesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  inputTensorName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  encoding_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  modality_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getFeatureValueDomainFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  indicesTensorName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 58:
                {
                  denseShapeTensorName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 58
              case 66:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureIndexFeatureMappingIsMutable();
                  indexFeatureMapping_.add(s);
                  break;
                } // case 66
              case 74:
                {
                  encodedTensorName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000100;
                  break;
                } // case 74
              case 82:
                {
                  com.google.protobuf.Value m =
                      input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
                  if (encodedBaselinesBuilder_ == null) {
                    ensureEncodedBaselinesIsMutable();
                    encodedBaselines_.add(m);
                  } else {
                    encodedBaselinesBuilder_.addMessage(m);
                  }
                  break;
                } // case 82
              case 90:
                {
                  input.readMessage(getVisualizationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000400;
                  break;
                } // case 90
              case 98:
                {
                  groupName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000800;
                  break;
                } // case 98
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.protobuf.Value> inputBaselines_ =
          java.util.Collections.emptyList();

      private void ensureInputBaselinesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          inputBaselines_ = new java.util.ArrayList<com.google.protobuf.Value>(inputBaselines_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder,
              com.google.protobuf.ValueOrBuilder>
          inputBaselinesBuilder_;

      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public java.util.List<com.google.protobuf.Value> getInputBaselinesList() {
        if (inputBaselinesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(inputBaselines_);
        } else {
          return inputBaselinesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public int getInputBaselinesCount() {
        if (inputBaselinesBuilder_ == null) {
          return inputBaselines_.size();
        } else {
          return inputBaselinesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public com.google.protobuf.Value getInputBaselines(int index) {
        if (inputBaselinesBuilder_ == null) {
          return inputBaselines_.get(index);
        } else {
          return inputBaselinesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public Builder setInputBaselines(int index, com.google.protobuf.Value value) {
        if (inputBaselinesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInputBaselinesIsMutable();
          inputBaselines_.set(index, value);
          onChanged();
        } else {
          inputBaselinesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public Builder setInputBaselines(
          int index, com.google.protobuf.Value.Builder builderForValue) {
        if (inputBaselinesBuilder_ == null) {
          ensureInputBaselinesIsMutable();
          inputBaselines_.set(index, builderForValue.build());
          onChanged();
        } else {
          inputBaselinesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public Builder addInputBaselines(com.google.protobuf.Value value) {
        if (inputBaselinesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInputBaselinesIsMutable();
          inputBaselines_.add(value);
          onChanged();
        } else {
          inputBaselinesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public Builder addInputBaselines(int index, com.google.protobuf.Value value) {
        if (inputBaselinesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInputBaselinesIsMutable();
          inputBaselines_.add(index, value);
          onChanged();
        } else {
          inputBaselinesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public Builder addInputBaselines(com.google.protobuf.Value.Builder builderForValue) {
        if (inputBaselinesBuilder_ == null) {
          ensureInputBaselinesIsMutable();
          inputBaselines_.add(builderForValue.build());
          onChanged();
        } else {
          inputBaselinesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public Builder addInputBaselines(
          int index, com.google.protobuf.Value.Builder builderForValue) {
        if (inputBaselinesBuilder_ == null) {
          ensureInputBaselinesIsMutable();
          inputBaselines_.add(index, builderForValue.build());
          onChanged();
        } else {
          inputBaselinesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public Builder addAllInputBaselines(
          java.lang.Iterable<? extends com.google.protobuf.Value> values) {
        if (inputBaselinesBuilder_ == null) {
          ensureInputBaselinesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inputBaselines_);
          onChanged();
        } else {
          inputBaselinesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public Builder clearInputBaselines() {
        if (inputBaselinesBuilder_ == null) {
          inputBaselines_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          inputBaselinesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public Builder removeInputBaselines(int index) {
        if (inputBaselinesBuilder_ == null) {
          ensureInputBaselinesIsMutable();
          inputBaselines_.remove(index);
          onChanged();
        } else {
          inputBaselinesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public com.google.protobuf.Value.Builder getInputBaselinesBuilder(int index) {
        return getInputBaselinesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public com.google.protobuf.ValueOrBuilder getInputBaselinesOrBuilder(int index) {
        if (inputBaselinesBuilder_ == null) {
          return inputBaselines_.get(index);
        } else {
          return inputBaselinesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
          getInputBaselinesOrBuilderList() {
        if (inputBaselinesBuilder_ != null) {
          return inputBaselinesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(inputBaselines_);
        }
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public com.google.protobuf.Value.Builder addInputBaselinesBuilder() {
        return getInputBaselinesFieldBuilder()
            .addBuilder(com.google.protobuf.Value.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public com.google.protobuf.Value.Builder addInputBaselinesBuilder(int index) {
        return getInputBaselinesFieldBuilder()
            .addBuilder(index, com.google.protobuf.Value.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Baseline inputs for this feature.
       *
       * If no baseline is specified, Vertex AI chooses the baseline for this
       * feature. If multiple baselines are specified, Vertex AI returns the
       * average attributions across them in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
       *
       * For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
       * of each baseline must match the shape of the input tensor. If a scalar is
       * provided, we broadcast to the same shape as the input tensor.
       *
       * For custom images, the element of the baselines must be in the same
       * format as the feature's input in the
       * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances][]. The
       * schema of any single instance may be specified via Endpoint's
       * DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
       * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
       * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
       * </pre>
       *
       * <code>repeated .google.protobuf.Value input_baselines = 1;</code>
       */
      public java.util.List<com.google.protobuf.Value.Builder> getInputBaselinesBuilderList() {
        return getInputBaselinesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder,
              com.google.protobuf.ValueOrBuilder>
          getInputBaselinesFieldBuilder() {
        if (inputBaselinesBuilder_ == null) {
          inputBaselinesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.protobuf.Value,
                  com.google.protobuf.Value.Builder,
                  com.google.protobuf.ValueOrBuilder>(
                  inputBaselines_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          inputBaselines_ = null;
        }
        return inputBaselinesBuilder_;
      }

      private java.lang.Object inputTensorName_ = "";
      /**
       *
       *
       * <pre>
       * Name of the input tensor for this feature. Required and is only
       * applicable to Vertex AI-provided images for Tensorflow.
       * </pre>
       *
       * <code>string input_tensor_name = 2;</code>
       *
       * @return The inputTensorName.
       */
      public java.lang.String getInputTensorName() {
        java.lang.Object ref = inputTensorName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          inputTensorName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the input tensor for this feature. Required and is only
       * applicable to Vertex AI-provided images for Tensorflow.
       * </pre>
       *
       * <code>string input_tensor_name = 2;</code>
       *
       * @return The bytes for inputTensorName.
       */
      public com.google.protobuf.ByteString getInputTensorNameBytes() {
        java.lang.Object ref = inputTensorName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          inputTensorName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the input tensor for this feature. Required and is only
       * applicable to Vertex AI-provided images for Tensorflow.
       * </pre>
       *
       * <code>string input_tensor_name = 2;</code>
       *
       * @param value The inputTensorName to set.
       * @return This builder for chaining.
       */
      public Builder setInputTensorName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputTensorName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the input tensor for this feature. Required and is only
       * applicable to Vertex AI-provided images for Tensorflow.
       * </pre>
       *
       * <code>string input_tensor_name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInputTensorName() {
        inputTensorName_ = getDefaultInstance().getInputTensorName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the input tensor for this feature. Required and is only
       * applicable to Vertex AI-provided images for Tensorflow.
       * </pre>
       *
       * <code>string input_tensor_name = 2;</code>
       *
       * @param value The bytes for inputTensorName to set.
       * @return This builder for chaining.
       */
      public Builder setInputTensorNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        inputTensorName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int encoding_ = 0;
      /**
       *
       *
       * <pre>
       * Defines how the feature is encoded into the input tensor. Defaults to
       * IDENTITY.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding encoding = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for encoding.
       */
      @java.lang.Override
      public int getEncodingValue() {
        return encoding_;
      }
      /**
       *
       *
       * <pre>
       * Defines how the feature is encoded into the input tensor. Defaults to
       * IDENTITY.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding encoding = 3;
       * </code>
       *
       * @param value The enum numeric value on the wire for encoding to set.
       * @return This builder for chaining.
       */
      public Builder setEncodingValue(int value) {
        encoding_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defines how the feature is encoded into the input tensor. Defaults to
       * IDENTITY.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding encoding = 3;
       * </code>
       *
       * @return The encoding.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding
          getEncoding() {
        com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding result =
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding.forNumber(
                encoding_);
        return result == null
            ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Defines how the feature is encoded into the input tensor. Defaults to
       * IDENTITY.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding encoding = 3;
       * </code>
       *
       * @param value The encoding to set.
       * @return This builder for chaining.
       */
      public Builder setEncoding(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        encoding_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defines how the feature is encoded into the input tensor. Defaults to
       * IDENTITY.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Encoding encoding = 3;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEncoding() {
        bitField0_ = (bitField0_ & ~0x00000004);
        encoding_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object modality_ = "";
      /**
       *
       *
       * <pre>
       * Modality of the feature. Valid values are: numeric, image. Defaults to
       * numeric.
       * </pre>
       *
       * <code>string modality = 4;</code>
       *
       * @return The modality.
       */
      public java.lang.String getModality() {
        java.lang.Object ref = modality_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modality_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Modality of the feature. Valid values are: numeric, image. Defaults to
       * numeric.
       * </pre>
       *
       * <code>string modality = 4;</code>
       *
       * @return The bytes for modality.
       */
      public com.google.protobuf.ByteString getModalityBytes() {
        java.lang.Object ref = modality_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modality_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Modality of the feature. Valid values are: numeric, image. Defaults to
       * numeric.
       * </pre>
       *
       * <code>string modality = 4;</code>
       *
       * @param value The modality to set.
       * @return This builder for chaining.
       */
      public Builder setModality(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modality_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Modality of the feature. Valid values are: numeric, image. Defaults to
       * numeric.
       * </pre>
       *
       * <code>string modality = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModality() {
        modality_ = getDefaultInstance().getModality();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Modality of the feature. Valid values are: numeric, image. Defaults to
       * numeric.
       * </pre>
       *
       * <code>string modality = 4;</code>
       *
       * @param value The bytes for modality to set.
       * @return This builder for chaining.
       */
      public Builder setModalityBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        modality_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
          featureValueDomain_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
                  .Builder,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                  .FeatureValueDomainOrBuilder>
          featureValueDomainBuilder_;
      /**
       *
       *
       * <pre>
       * The domain details of the input feature value. Like min/max, original
       * mean or standard deviation if normalized.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain feature_value_domain = 5;
       * </code>
       *
       * @return Whether the featureValueDomain field is set.
       */
      public boolean hasFeatureValueDomain() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * The domain details of the input feature value. Like min/max, original
       * mean or standard deviation if normalized.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain feature_value_domain = 5;
       * </code>
       *
       * @return The featureValueDomain.
       */
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
          getFeatureValueDomain() {
        if (featureValueDomainBuilder_ == null) {
          return featureValueDomain_ == null
              ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
                  .getDefaultInstance()
              : featureValueDomain_;
        } else {
          return featureValueDomainBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The domain details of the input feature value. Like min/max, original
       * mean or standard deviation if normalized.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain feature_value_domain = 5;
       * </code>
       */
      public Builder setFeatureValueDomain(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
              value) {
        if (featureValueDomainBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          featureValueDomain_ = value;
        } else {
          featureValueDomainBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The domain details of the input feature value. Like min/max, original
       * mean or standard deviation if normalized.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain feature_value_domain = 5;
       * </code>
       */
      public Builder setFeatureValueDomain(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
                  .Builder
              builderForValue) {
        if (featureValueDomainBuilder_ == null) {
          featureValueDomain_ = builderForValue.build();
        } else {
          featureValueDomainBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The domain details of the input feature value. Like min/max, original
       * mean or standard deviation if normalized.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain feature_value_domain = 5;
       * </code>
       */
      public Builder mergeFeatureValueDomain(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
              value) {
        if (featureValueDomainBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && featureValueDomain_ != null
              && featureValueDomain_
                  != com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                      .FeatureValueDomain.getDefaultInstance()) {
            getFeatureValueDomainBuilder().mergeFrom(value);
          } else {
            featureValueDomain_ = value;
          }
        } else {
          featureValueDomainBuilder_.mergeFrom(value);
        }
        if (featureValueDomain_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The domain details of the input feature value. Like min/max, original
       * mean or standard deviation if normalized.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain feature_value_domain = 5;
       * </code>
       */
      public Builder clearFeatureValueDomain() {
        bitField0_ = (bitField0_ & ~0x00000010);
        featureValueDomain_ = null;
        if (featureValueDomainBuilder_ != null) {
          featureValueDomainBuilder_.dispose();
          featureValueDomainBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The domain details of the input feature value. Like min/max, original
       * mean or standard deviation if normalized.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain feature_value_domain = 5;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
              .Builder
          getFeatureValueDomainBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getFeatureValueDomainFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The domain details of the input feature value. Like min/max, original
       * mean or standard deviation if normalized.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain feature_value_domain = 5;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
              .FeatureValueDomainOrBuilder
          getFeatureValueDomainOrBuilder() {
        if (featureValueDomainBuilder_ != null) {
          return featureValueDomainBuilder_.getMessageOrBuilder();
        } else {
          return featureValueDomain_ == null
              ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
                  .getDefaultInstance()
              : featureValueDomain_;
        }
      }
      /**
       *
       *
       * <pre>
       * The domain details of the input feature value. Like min/max, original
       * mean or standard deviation if normalized.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain feature_value_domain = 5;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.FeatureValueDomain
                  .Builder,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                  .FeatureValueDomainOrBuilder>
          getFeatureValueDomainFieldBuilder() {
        if (featureValueDomainBuilder_ == null) {
          featureValueDomainBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                      .FeatureValueDomain,
                  com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                      .FeatureValueDomain.Builder,
                  com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                      .FeatureValueDomainOrBuilder>(
                  getFeatureValueDomain(), getParentForChildren(), isClean());
          featureValueDomain_ = null;
        }
        return featureValueDomainBuilder_;
      }

      private java.lang.Object indicesTensorName_ = "";
      /**
       *
       *
       * <pre>
       * Specifies the index of the values of the input tensor.
       * Required when the input tensor is a sparse representation. Refer to
       * Tensorflow documentation for more details:
       * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
       * </pre>
       *
       * <code>string indices_tensor_name = 6;</code>
       *
       * @return The indicesTensorName.
       */
      public java.lang.String getIndicesTensorName() {
        java.lang.Object ref = indicesTensorName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          indicesTensorName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the index of the values of the input tensor.
       * Required when the input tensor is a sparse representation. Refer to
       * Tensorflow documentation for more details:
       * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
       * </pre>
       *
       * <code>string indices_tensor_name = 6;</code>
       *
       * @return The bytes for indicesTensorName.
       */
      public com.google.protobuf.ByteString getIndicesTensorNameBytes() {
        java.lang.Object ref = indicesTensorName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          indicesTensorName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the index of the values of the input tensor.
       * Required when the input tensor is a sparse representation. Refer to
       * Tensorflow documentation for more details:
       * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
       * </pre>
       *
       * <code>string indices_tensor_name = 6;</code>
       *
       * @param value The indicesTensorName to set.
       * @return This builder for chaining.
       */
      public Builder setIndicesTensorName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        indicesTensorName_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the index of the values of the input tensor.
       * Required when the input tensor is a sparse representation. Refer to
       * Tensorflow documentation for more details:
       * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
       * </pre>
       *
       * <code>string indices_tensor_name = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIndicesTensorName() {
        indicesTensorName_ = getDefaultInstance().getIndicesTensorName();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the index of the values of the input tensor.
       * Required when the input tensor is a sparse representation. Refer to
       * Tensorflow documentation for more details:
       * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
       * </pre>
       *
       * <code>string indices_tensor_name = 6;</code>
       *
       * @param value The bytes for indicesTensorName to set.
       * @return This builder for chaining.
       */
      public Builder setIndicesTensorNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        indicesTensorName_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      private java.lang.Object denseShapeTensorName_ = "";
      /**
       *
       *
       * <pre>
       * Specifies the shape of the values of the input if the input is a sparse
       * representation. Refer to Tensorflow documentation for more details:
       * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
       * </pre>
       *
       * <code>string dense_shape_tensor_name = 7;</code>
       *
       * @return The denseShapeTensorName.
       */
      public java.lang.String getDenseShapeTensorName() {
        java.lang.Object ref = denseShapeTensorName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          denseShapeTensorName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the shape of the values of the input if the input is a sparse
       * representation. Refer to Tensorflow documentation for more details:
       * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
       * </pre>
       *
       * <code>string dense_shape_tensor_name = 7;</code>
       *
       * @return The bytes for denseShapeTensorName.
       */
      public com.google.protobuf.ByteString getDenseShapeTensorNameBytes() {
        java.lang.Object ref = denseShapeTensorName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          denseShapeTensorName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the shape of the values of the input if the input is a sparse
       * representation. Refer to Tensorflow documentation for more details:
       * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
       * </pre>
       *
       * <code>string dense_shape_tensor_name = 7;</code>
       *
       * @param value The denseShapeTensorName to set.
       * @return This builder for chaining.
       */
      public Builder setDenseShapeTensorName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        denseShapeTensorName_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the shape of the values of the input if the input is a sparse
       * representation. Refer to Tensorflow documentation for more details:
       * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
       * </pre>
       *
       * <code>string dense_shape_tensor_name = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDenseShapeTensorName() {
        denseShapeTensorName_ = getDefaultInstance().getDenseShapeTensorName();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the shape of the values of the input if the input is a sparse
       * representation. Refer to Tensorflow documentation for more details:
       * https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
       * </pre>
       *
       * <code>string dense_shape_tensor_name = 7;</code>
       *
       * @param value The bytes for denseShapeTensorName to set.
       * @return This builder for chaining.
       */
      public Builder setDenseShapeTensorNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        denseShapeTensorName_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList indexFeatureMapping_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureIndexFeatureMappingIsMutable() {
        if (!indexFeatureMapping_.isModifiable()) {
          indexFeatureMapping_ = new com.google.protobuf.LazyStringArrayList(indexFeatureMapping_);
        }
        bitField0_ |= 0x00000080;
      }
      /**
       *
       *
       * <pre>
       * A list of feature names for each index in the input tensor.
       * Required when the input
       * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
       * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
       * </pre>
       *
       * <code>repeated string index_feature_mapping = 8;</code>
       *
       * @return A list containing the indexFeatureMapping.
       */
      public com.google.protobuf.ProtocolStringList getIndexFeatureMappingList() {
        indexFeatureMapping_.makeImmutable();
        return indexFeatureMapping_;
      }
      /**
       *
       *
       * <pre>
       * A list of feature names for each index in the input tensor.
       * Required when the input
       * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
       * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
       * </pre>
       *
       * <code>repeated string index_feature_mapping = 8;</code>
       *
       * @return The count of indexFeatureMapping.
       */
      public int getIndexFeatureMappingCount() {
        return indexFeatureMapping_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of feature names for each index in the input tensor.
       * Required when the input
       * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
       * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
       * </pre>
       *
       * <code>repeated string index_feature_mapping = 8;</code>
       *
       * @param index The index of the element to return.
       * @return The indexFeatureMapping at the given index.
       */
      public java.lang.String getIndexFeatureMapping(int index) {
        return indexFeatureMapping_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of feature names for each index in the input tensor.
       * Required when the input
       * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
       * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
       * </pre>
       *
       * <code>repeated string index_feature_mapping = 8;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the indexFeatureMapping at the given index.
       */
      public com.google.protobuf.ByteString getIndexFeatureMappingBytes(int index) {
        return indexFeatureMapping_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * A list of feature names for each index in the input tensor.
       * Required when the input
       * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
       * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
       * </pre>
       *
       * <code>repeated string index_feature_mapping = 8;</code>
       *
       * @param index The index to set the value at.
       * @param value The indexFeatureMapping to set.
       * @return This builder for chaining.
       */
      public Builder setIndexFeatureMapping(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIndexFeatureMappingIsMutable();
        indexFeatureMapping_.set(index, value);
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of feature names for each index in the input tensor.
       * Required when the input
       * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
       * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
       * </pre>
       *
       * <code>repeated string index_feature_mapping = 8;</code>
       *
       * @param value The indexFeatureMapping to add.
       * @return This builder for chaining.
       */
      public Builder addIndexFeatureMapping(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIndexFeatureMappingIsMutable();
        indexFeatureMapping_.add(value);
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of feature names for each index in the input tensor.
       * Required when the input
       * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
       * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
       * </pre>
       *
       * <code>repeated string index_feature_mapping = 8;</code>
       *
       * @param values The indexFeatureMapping to add.
       * @return This builder for chaining.
       */
      public Builder addAllIndexFeatureMapping(java.lang.Iterable<java.lang.String> values) {
        ensureIndexFeatureMappingIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, indexFeatureMapping_);
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of feature names for each index in the input tensor.
       * Required when the input
       * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
       * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
       * </pre>
       *
       * <code>repeated string index_feature_mapping = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIndexFeatureMapping() {
        indexFeatureMapping_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of feature names for each index in the input tensor.
       * Required when the input
       * [InputMetadata.encoding][google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.encoding]
       * is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
       * </pre>
       *
       * <code>repeated string index_feature_mapping = 8;</code>
       *
       * @param value The bytes of the indexFeatureMapping to add.
       * @return This builder for chaining.
       */
      public Builder addIndexFeatureMappingBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureIndexFeatureMappingIsMutable();
        indexFeatureMapping_.add(value);
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      private java.lang.Object encodedTensorName_ = "";
      /**
       *
       *
       * <pre>
       * Encoded tensor is a transformation of the input tensor. Must be provided
       * if choosing
       * [Integrated Gradients
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution]
       * or [XRAI
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution]
       * and the input tensor is not differentiable.
       *
       * An encoded tensor is generated if the input tensor is encoded by a lookup
       * table.
       * </pre>
       *
       * <code>string encoded_tensor_name = 9;</code>
       *
       * @return The encodedTensorName.
       */
      public java.lang.String getEncodedTensorName() {
        java.lang.Object ref = encodedTensorName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          encodedTensorName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Encoded tensor is a transformation of the input tensor. Must be provided
       * if choosing
       * [Integrated Gradients
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution]
       * or [XRAI
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution]
       * and the input tensor is not differentiable.
       *
       * An encoded tensor is generated if the input tensor is encoded by a lookup
       * table.
       * </pre>
       *
       * <code>string encoded_tensor_name = 9;</code>
       *
       * @return The bytes for encodedTensorName.
       */
      public com.google.protobuf.ByteString getEncodedTensorNameBytes() {
        java.lang.Object ref = encodedTensorName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          encodedTensorName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Encoded tensor is a transformation of the input tensor. Must be provided
       * if choosing
       * [Integrated Gradients
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution]
       * or [XRAI
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution]
       * and the input tensor is not differentiable.
       *
       * An encoded tensor is generated if the input tensor is encoded by a lookup
       * table.
       * </pre>
       *
       * <code>string encoded_tensor_name = 9;</code>
       *
       * @param value The encodedTensorName to set.
       * @return This builder for chaining.
       */
      public Builder setEncodedTensorName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        encodedTensorName_ = value;
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Encoded tensor is a transformation of the input tensor. Must be provided
       * if choosing
       * [Integrated Gradients
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution]
       * or [XRAI
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution]
       * and the input tensor is not differentiable.
       *
       * An encoded tensor is generated if the input tensor is encoded by a lookup
       * table.
       * </pre>
       *
       * <code>string encoded_tensor_name = 9;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEncodedTensorName() {
        encodedTensorName_ = getDefaultInstance().getEncodedTensorName();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Encoded tensor is a transformation of the input tensor. Must be provided
       * if choosing
       * [Integrated Gradients
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.integrated_gradients_attribution]
       * or [XRAI
       * attribution][google.cloud.aiplatform.v1.ExplanationParameters.xrai_attribution]
       * and the input tensor is not differentiable.
       *
       * An encoded tensor is generated if the input tensor is encoded by a lookup
       * table.
       * </pre>
       *
       * <code>string encoded_tensor_name = 9;</code>
       *
       * @param value The bytes for encodedTensorName to set.
       * @return This builder for chaining.
       */
      public Builder setEncodedTensorNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        encodedTensorName_ = value;
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }

      private java.util.List<com.google.protobuf.Value> encodedBaselines_ =
          java.util.Collections.emptyList();

      private void ensureEncodedBaselinesIsMutable() {
        if (!((bitField0_ & 0x00000200) != 0)) {
          encodedBaselines_ = new java.util.ArrayList<com.google.protobuf.Value>(encodedBaselines_);
          bitField0_ |= 0x00000200;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder,
              com.google.protobuf.ValueOrBuilder>
          encodedBaselinesBuilder_;

      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public java.util.List<com.google.protobuf.Value> getEncodedBaselinesList() {
        if (encodedBaselinesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(encodedBaselines_);
        } else {
          return encodedBaselinesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public int getEncodedBaselinesCount() {
        if (encodedBaselinesBuilder_ == null) {
          return encodedBaselines_.size();
        } else {
          return encodedBaselinesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public com.google.protobuf.Value getEncodedBaselines(int index) {
        if (encodedBaselinesBuilder_ == null) {
          return encodedBaselines_.get(index);
        } else {
          return encodedBaselinesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public Builder setEncodedBaselines(int index, com.google.protobuf.Value value) {
        if (encodedBaselinesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEncodedBaselinesIsMutable();
          encodedBaselines_.set(index, value);
          onChanged();
        } else {
          encodedBaselinesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public Builder setEncodedBaselines(
          int index, com.google.protobuf.Value.Builder builderForValue) {
        if (encodedBaselinesBuilder_ == null) {
          ensureEncodedBaselinesIsMutable();
          encodedBaselines_.set(index, builderForValue.build());
          onChanged();
        } else {
          encodedBaselinesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public Builder addEncodedBaselines(com.google.protobuf.Value value) {
        if (encodedBaselinesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEncodedBaselinesIsMutable();
          encodedBaselines_.add(value);
          onChanged();
        } else {
          encodedBaselinesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public Builder addEncodedBaselines(int index, com.google.protobuf.Value value) {
        if (encodedBaselinesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEncodedBaselinesIsMutable();
          encodedBaselines_.add(index, value);
          onChanged();
        } else {
          encodedBaselinesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public Builder addEncodedBaselines(com.google.protobuf.Value.Builder builderForValue) {
        if (encodedBaselinesBuilder_ == null) {
          ensureEncodedBaselinesIsMutable();
          encodedBaselines_.add(builderForValue.build());
          onChanged();
        } else {
          encodedBaselinesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public Builder addEncodedBaselines(
          int index, com.google.protobuf.Value.Builder builderForValue) {
        if (encodedBaselinesBuilder_ == null) {
          ensureEncodedBaselinesIsMutable();
          encodedBaselines_.add(index, builderForValue.build());
          onChanged();
        } else {
          encodedBaselinesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public Builder addAllEncodedBaselines(
          java.lang.Iterable<? extends com.google.protobuf.Value> values) {
        if (encodedBaselinesBuilder_ == null) {
          ensureEncodedBaselinesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, encodedBaselines_);
          onChanged();
        } else {
          encodedBaselinesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public Builder clearEncodedBaselines() {
        if (encodedBaselinesBuilder_ == null) {
          encodedBaselines_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000200);
          onChanged();
        } else {
          encodedBaselinesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public Builder removeEncodedBaselines(int index) {
        if (encodedBaselinesBuilder_ == null) {
          ensureEncodedBaselinesIsMutable();
          encodedBaselines_.remove(index);
          onChanged();
        } else {
          encodedBaselinesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public com.google.protobuf.Value.Builder getEncodedBaselinesBuilder(int index) {
        return getEncodedBaselinesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public com.google.protobuf.ValueOrBuilder getEncodedBaselinesOrBuilder(int index) {
        if (encodedBaselinesBuilder_ == null) {
          return encodedBaselines_.get(index);
        } else {
          return encodedBaselinesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
          getEncodedBaselinesOrBuilderList() {
        if (encodedBaselinesBuilder_ != null) {
          return encodedBaselinesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(encodedBaselines_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public com.google.protobuf.Value.Builder addEncodedBaselinesBuilder() {
        return getEncodedBaselinesFieldBuilder()
            .addBuilder(com.google.protobuf.Value.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public com.google.protobuf.Value.Builder addEncodedBaselinesBuilder(int index) {
        return getEncodedBaselinesFieldBuilder()
            .addBuilder(index, com.google.protobuf.Value.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of baselines for the encoded tensor.
       *
       * The shape of each baseline should match the shape of the encoded tensor.
       * If a scalar is provided, Vertex AI broadcasts to the same shape as the
       * encoded tensor.
       * </pre>
       *
       * <code>repeated .google.protobuf.Value encoded_baselines = 10;</code>
       */
      public java.util.List<com.google.protobuf.Value.Builder> getEncodedBaselinesBuilderList() {
        return getEncodedBaselinesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder,
              com.google.protobuf.ValueOrBuilder>
          getEncodedBaselinesFieldBuilder() {
        if (encodedBaselinesBuilder_ == null) {
          encodedBaselinesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.protobuf.Value,
                  com.google.protobuf.Value.Builder,
                  com.google.protobuf.ValueOrBuilder>(
                  encodedBaselines_,
                  ((bitField0_ & 0x00000200) != 0),
                  getParentForChildren(),
                  isClean());
          encodedBaselines_ = null;
        }
        return encodedBaselinesBuilder_;
      }

      private com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          visualization_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                  .Builder,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                  .VisualizationOrBuilder>
          visualizationBuilder_;
      /**
       *
       *
       * <pre>
       * Visualization configurations for image explanation.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization visualization = 11;
       * </code>
       *
       * @return Whether the visualization field is set.
       */
      public boolean hasVisualization() {
        return ((bitField0_ & 0x00000400) != 0);
      }
      /**
       *
       *
       * <pre>
       * Visualization configurations for image explanation.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization visualization = 11;
       * </code>
       *
       * @return The visualization.
       */
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
          getVisualization() {
        if (visualizationBuilder_ == null) {
          return visualization_ == null
              ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                  .getDefaultInstance()
              : visualization_;
        } else {
          return visualizationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Visualization configurations for image explanation.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization visualization = 11;
       * </code>
       */
      public Builder setVisualization(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization value) {
        if (visualizationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          visualization_ = value;
        } else {
          visualizationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Visualization configurations for image explanation.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization visualization = 11;
       * </code>
       */
      public Builder setVisualization(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Builder
              builderForValue) {
        if (visualizationBuilder_ == null) {
          visualization_ = builderForValue.build();
        } else {
          visualizationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Visualization configurations for image explanation.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization visualization = 11;
       * </code>
       */
      public Builder mergeVisualization(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization value) {
        if (visualizationBuilder_ == null) {
          if (((bitField0_ & 0x00000400) != 0)
              && visualization_ != null
              && visualization_
                  != com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                      .getDefaultInstance()) {
            getVisualizationBuilder().mergeFrom(value);
          } else {
            visualization_ = value;
          }
        } else {
          visualizationBuilder_.mergeFrom(value);
        }
        if (visualization_ != null) {
          bitField0_ |= 0x00000400;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Visualization configurations for image explanation.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization visualization = 11;
       * </code>
       */
      public Builder clearVisualization() {
        bitField0_ = (bitField0_ & ~0x00000400);
        visualization_ = null;
        if (visualizationBuilder_ != null) {
          visualizationBuilder_.dispose();
          visualizationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Visualization configurations for image explanation.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization visualization = 11;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization.Builder
          getVisualizationBuilder() {
        bitField0_ |= 0x00000400;
        onChanged();
        return getVisualizationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Visualization configurations for image explanation.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization visualization = 11;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.VisualizationOrBuilder
          getVisualizationOrBuilder() {
        if (visualizationBuilder_ != null) {
          return visualizationBuilder_.getMessageOrBuilder();
        } else {
          return visualization_ == null
              ? com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                  .getDefaultInstance()
              : visualization_;
        }
      }
      /**
       *
       *
       * <pre>
       * Visualization configurations for image explanation.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization visualization = 11;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                  .Builder,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                  .VisualizationOrBuilder>
          getVisualizationFieldBuilder() {
        if (visualizationBuilder_ == null) {
          visualizationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization,
                  com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Visualization
                      .Builder,
                  com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                      .VisualizationOrBuilder>(
                  getVisualization(), getParentForChildren(), isClean());
          visualization_ = null;
        }
        return visualizationBuilder_;
      }

      private java.lang.Object groupName_ = "";
      /**
       *
       *
       * <pre>
       * Name of the group that the input belongs to. Features with the same group
       * name will be treated as one feature when computing attributions. Features
       * grouped together can have different shapes in value. If provided, there
       * will be one single attribution generated in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions],
       * keyed by the group name.
       * </pre>
       *
       * <code>string group_name = 12;</code>
       *
       * @return The groupName.
       */
      public java.lang.String getGroupName() {
        java.lang.Object ref = groupName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          groupName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the group that the input belongs to. Features with the same group
       * name will be treated as one feature when computing attributions. Features
       * grouped together can have different shapes in value. If provided, there
       * will be one single attribution generated in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions],
       * keyed by the group name.
       * </pre>
       *
       * <code>string group_name = 12;</code>
       *
       * @return The bytes for groupName.
       */
      public com.google.protobuf.ByteString getGroupNameBytes() {
        java.lang.Object ref = groupName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          groupName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the group that the input belongs to. Features with the same group
       * name will be treated as one feature when computing attributions. Features
       * grouped together can have different shapes in value. If provided, there
       * will be one single attribution generated in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions],
       * keyed by the group name.
       * </pre>
       *
       * <code>string group_name = 12;</code>
       *
       * @param value The groupName to set.
       * @return This builder for chaining.
       */
      public Builder setGroupName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        groupName_ = value;
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the group that the input belongs to. Features with the same group
       * name will be treated as one feature when computing attributions. Features
       * grouped together can have different shapes in value. If provided, there
       * will be one single attribution generated in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions],
       * keyed by the group name.
       * </pre>
       *
       * <code>string group_name = 12;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGroupName() {
        groupName_ = getDefaultInstance().getGroupName();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the group that the input belongs to. Features with the same group
       * name will be treated as one feature when computing attributions. Features
       * grouped together can have different shapes in value. If provided, there
       * will be one single attribution generated in
       * [Attribution.feature_attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions],
       * keyed by the group name.
       * </pre>
       *
       * <code>string group_name = 12;</code>
       *
       * @param value The bytes for groupName to set.
       * @return This builder for chaining.
       */
      public Builder setGroupNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        groupName_ = value;
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata)
    private static final com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata();
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InputMetadata> PARSER =
        new com.google.protobuf.AbstractParser<InputMetadata>() {
          @java.lang.Override
          public InputMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InputMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InputMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OutputMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Static mapping between the index and display name.
     *
     * Use this if the outputs are a deterministic n-dimensional array, e.g. a
     * list of scores of all the classes in a pre-defined order for a
     * multi-classification Model. It's not feasible if the outputs are
     * non-deterministic, e.g. the Model produces top-k classes or sort the
     * outputs by their values.
     *
     * The shape of the value must be an n-dimensional array of strings. The
     * number of dimensions must match that of the outputs to be explained.
     * The
     * [Attribution.output_display_name][google.cloud.aiplatform.v1.Attribution.output_display_name]
     * is populated by locating in the mapping with
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index].
     * </pre>
     *
     * <code>.google.protobuf.Value index_display_name_mapping = 1;</code>
     *
     * @return Whether the indexDisplayNameMapping field is set.
     */
    boolean hasIndexDisplayNameMapping();
    /**
     *
     *
     * <pre>
     * Static mapping between the index and display name.
     *
     * Use this if the outputs are a deterministic n-dimensional array, e.g. a
     * list of scores of all the classes in a pre-defined order for a
     * multi-classification Model. It's not feasible if the outputs are
     * non-deterministic, e.g. the Model produces top-k classes or sort the
     * outputs by their values.
     *
     * The shape of the value must be an n-dimensional array of strings. The
     * number of dimensions must match that of the outputs to be explained.
     * The
     * [Attribution.output_display_name][google.cloud.aiplatform.v1.Attribution.output_display_name]
     * is populated by locating in the mapping with
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index].
     * </pre>
     *
     * <code>.google.protobuf.Value index_display_name_mapping = 1;</code>
     *
     * @return The indexDisplayNameMapping.
     */
    com.google.protobuf.Value getIndexDisplayNameMapping();
    /**
     *
     *
     * <pre>
     * Static mapping between the index and display name.
     *
     * Use this if the outputs are a deterministic n-dimensional array, e.g. a
     * list of scores of all the classes in a pre-defined order for a
     * multi-classification Model. It's not feasible if the outputs are
     * non-deterministic, e.g. the Model produces top-k classes or sort the
     * outputs by their values.
     *
     * The shape of the value must be an n-dimensional array of strings. The
     * number of dimensions must match that of the outputs to be explained.
     * The
     * [Attribution.output_display_name][google.cloud.aiplatform.v1.Attribution.output_display_name]
     * is populated by locating in the mapping with
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index].
     * </pre>
     *
     * <code>.google.protobuf.Value index_display_name_mapping = 1;</code>
     */
    com.google.protobuf.ValueOrBuilder getIndexDisplayNameMappingOrBuilder();

    /**
     *
     *
     * <pre>
     * Specify a field name in the prediction to look for the display name.
     *
     * Use this if the prediction contains the display names for the outputs.
     *
     * The display names in the prediction must have the same shape of the
     * outputs, so that it can be located by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * for a specific output.
     * </pre>
     *
     * <code>string display_name_mapping_key = 2;</code>
     *
     * @return Whether the displayNameMappingKey field is set.
     */
    boolean hasDisplayNameMappingKey();
    /**
     *
     *
     * <pre>
     * Specify a field name in the prediction to look for the display name.
     *
     * Use this if the prediction contains the display names for the outputs.
     *
     * The display names in the prediction must have the same shape of the
     * outputs, so that it can be located by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * for a specific output.
     * </pre>
     *
     * <code>string display_name_mapping_key = 2;</code>
     *
     * @return The displayNameMappingKey.
     */
    java.lang.String getDisplayNameMappingKey();
    /**
     *
     *
     * <pre>
     * Specify a field name in the prediction to look for the display name.
     *
     * Use this if the prediction contains the display names for the outputs.
     *
     * The display names in the prediction must have the same shape of the
     * outputs, so that it can be located by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * for a specific output.
     * </pre>
     *
     * <code>string display_name_mapping_key = 2;</code>
     *
     * @return The bytes for displayNameMappingKey.
     */
    com.google.protobuf.ByteString getDisplayNameMappingKeyBytes();

    /**
     *
     *
     * <pre>
     * Name of the output tensor. Required and is only applicable to Vertex
     * AI provided images for Tensorflow.
     * </pre>
     *
     * <code>string output_tensor_name = 3;</code>
     *
     * @return The outputTensorName.
     */
    java.lang.String getOutputTensorName();
    /**
     *
     *
     * <pre>
     * Name of the output tensor. Required and is only applicable to Vertex
     * AI provided images for Tensorflow.
     * </pre>
     *
     * <code>string output_tensor_name = 3;</code>
     *
     * @return The bytes for outputTensorName.
     */
    com.google.protobuf.ByteString getOutputTensorNameBytes();

    com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata.DisplayNameMappingCase
        getDisplayNameMappingCase();
  }
  /**
   *
   *
   * <pre>
   * Metadata of the prediction output to be explained.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata}
   */
  public static final class OutputMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata)
      OutputMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OutputMetadata.newBuilder() to construct.
    private OutputMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OutputMetadata() {
      outputTensorName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OutputMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
          .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_OutputMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
          .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_OutputMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata.class,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata.Builder.class);
    }

    private int displayNameMappingCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object displayNameMapping_;

    public enum DisplayNameMappingCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      INDEX_DISPLAY_NAME_MAPPING(1),
      DISPLAY_NAME_MAPPING_KEY(2),
      DISPLAYNAMEMAPPING_NOT_SET(0);
      private final int value;

      private DisplayNameMappingCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DisplayNameMappingCase valueOf(int value) {
        return forNumber(value);
      }

      public static DisplayNameMappingCase forNumber(int value) {
        switch (value) {
          case 1:
            return INDEX_DISPLAY_NAME_MAPPING;
          case 2:
            return DISPLAY_NAME_MAPPING_KEY;
          case 0:
            return DISPLAYNAMEMAPPING_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DisplayNameMappingCase getDisplayNameMappingCase() {
      return DisplayNameMappingCase.forNumber(displayNameMappingCase_);
    }

    public static final int INDEX_DISPLAY_NAME_MAPPING_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Static mapping between the index and display name.
     *
     * Use this if the outputs are a deterministic n-dimensional array, e.g. a
     * list of scores of all the classes in a pre-defined order for a
     * multi-classification Model. It's not feasible if the outputs are
     * non-deterministic, e.g. the Model produces top-k classes or sort the
     * outputs by their values.
     *
     * The shape of the value must be an n-dimensional array of strings. The
     * number of dimensions must match that of the outputs to be explained.
     * The
     * [Attribution.output_display_name][google.cloud.aiplatform.v1.Attribution.output_display_name]
     * is populated by locating in the mapping with
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index].
     * </pre>
     *
     * <code>.google.protobuf.Value index_display_name_mapping = 1;</code>
     *
     * @return Whether the indexDisplayNameMapping field is set.
     */
    @java.lang.Override
    public boolean hasIndexDisplayNameMapping() {
      return displayNameMappingCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Static mapping between the index and display name.
     *
     * Use this if the outputs are a deterministic n-dimensional array, e.g. a
     * list of scores of all the classes in a pre-defined order for a
     * multi-classification Model. It's not feasible if the outputs are
     * non-deterministic, e.g. the Model produces top-k classes or sort the
     * outputs by their values.
     *
     * The shape of the value must be an n-dimensional array of strings. The
     * number of dimensions must match that of the outputs to be explained.
     * The
     * [Attribution.output_display_name][google.cloud.aiplatform.v1.Attribution.output_display_name]
     * is populated by locating in the mapping with
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index].
     * </pre>
     *
     * <code>.google.protobuf.Value index_display_name_mapping = 1;</code>
     *
     * @return The indexDisplayNameMapping.
     */
    @java.lang.Override
    public com.google.protobuf.Value getIndexDisplayNameMapping() {
      if (displayNameMappingCase_ == 1) {
        return (com.google.protobuf.Value) displayNameMapping_;
      }
      return com.google.protobuf.Value.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Static mapping between the index and display name.
     *
     * Use this if the outputs are a deterministic n-dimensional array, e.g. a
     * list of scores of all the classes in a pre-defined order for a
     * multi-classification Model. It's not feasible if the outputs are
     * non-deterministic, e.g. the Model produces top-k classes or sort the
     * outputs by their values.
     *
     * The shape of the value must be an n-dimensional array of strings. The
     * number of dimensions must match that of the outputs to be explained.
     * The
     * [Attribution.output_display_name][google.cloud.aiplatform.v1.Attribution.output_display_name]
     * is populated by locating in the mapping with
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index].
     * </pre>
     *
     * <code>.google.protobuf.Value index_display_name_mapping = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.ValueOrBuilder getIndexDisplayNameMappingOrBuilder() {
      if (displayNameMappingCase_ == 1) {
        return (com.google.protobuf.Value) displayNameMapping_;
      }
      return com.google.protobuf.Value.getDefaultInstance();
    }

    public static final int DISPLAY_NAME_MAPPING_KEY_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Specify a field name in the prediction to look for the display name.
     *
     * Use this if the prediction contains the display names for the outputs.
     *
     * The display names in the prediction must have the same shape of the
     * outputs, so that it can be located by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * for a specific output.
     * </pre>
     *
     * <code>string display_name_mapping_key = 2;</code>
     *
     * @return Whether the displayNameMappingKey field is set.
     */
    public boolean hasDisplayNameMappingKey() {
      return displayNameMappingCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Specify a field name in the prediction to look for the display name.
     *
     * Use this if the prediction contains the display names for the outputs.
     *
     * The display names in the prediction must have the same shape of the
     * outputs, so that it can be located by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * for a specific output.
     * </pre>
     *
     * <code>string display_name_mapping_key = 2;</code>
     *
     * @return The displayNameMappingKey.
     */
    public java.lang.String getDisplayNameMappingKey() {
      java.lang.Object ref = "";
      if (displayNameMappingCase_ == 2) {
        ref = displayNameMapping_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (displayNameMappingCase_ == 2) {
          displayNameMapping_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specify a field name in the prediction to look for the display name.
     *
     * Use this if the prediction contains the display names for the outputs.
     *
     * The display names in the prediction must have the same shape of the
     * outputs, so that it can be located by
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * for a specific output.
     * </pre>
     *
     * <code>string display_name_mapping_key = 2;</code>
     *
     * @return The bytes for displayNameMappingKey.
     */
    public com.google.protobuf.ByteString getDisplayNameMappingKeyBytes() {
      java.lang.Object ref = "";
      if (displayNameMappingCase_ == 2) {
        ref = displayNameMapping_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (displayNameMappingCase_ == 2) {
          displayNameMapping_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OUTPUT_TENSOR_NAME_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object outputTensorName_ = "";
    /**
     *
     *
     * <pre>
     * Name of the output tensor. Required and is only applicable to Vertex
     * AI provided images for Tensorflow.
     * </pre>
     *
     * <code>string output_tensor_name = 3;</code>
     *
     * @return The outputTensorName.
     */
    @java.lang.Override
    public java.lang.String getOutputTensorName() {
      java.lang.Object ref = outputTensorName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputTensorName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the output tensor. Required and is only applicable to Vertex
     * AI provided images for Tensorflow.
     * </pre>
     *
     * <code>string output_tensor_name = 3;</code>
     *
     * @return The bytes for outputTensorName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOutputTensorNameBytes() {
      java.lang.Object ref = outputTensorName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputTensorName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (displayNameMappingCase_ == 1) {
        output.writeMessage(1, (com.google.protobuf.Value) displayNameMapping_);
      }
      if (displayNameMappingCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayNameMapping_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputTensorName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, outputTensorName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (displayNameMappingCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.protobuf.Value) displayNameMapping_);
      }
      if (displayNameMappingCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayNameMapping_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputTensorName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, outputTensorName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata other =
          (com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata) obj;

      if (!getOutputTensorName().equals(other.getOutputTensorName())) return false;
      if (!getDisplayNameMappingCase().equals(other.getDisplayNameMappingCase())) return false;
      switch (displayNameMappingCase_) {
        case 1:
          if (!getIndexDisplayNameMapping().equals(other.getIndexDisplayNameMapping()))
            return false;
          break;
        case 2:
          if (!getDisplayNameMappingKey().equals(other.getDisplayNameMappingKey())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OUTPUT_TENSOR_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getOutputTensorName().hashCode();
      switch (displayNameMappingCase_) {
        case 1:
          hash = (37 * hash) + INDEX_DISPLAY_NAME_MAPPING_FIELD_NUMBER;
          hash = (53 * hash) + getIndexDisplayNameMapping().hashCode();
          break;
        case 2:
          hash = (37 * hash) + DISPLAY_NAME_MAPPING_KEY_FIELD_NUMBER;
          hash = (53 * hash) + getDisplayNameMappingKey().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the prediction output to be explained.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata)
        com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
            .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_OutputMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
            .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_OutputMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata.class,
                com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (indexDisplayNameMappingBuilder_ != null) {
          indexDisplayNameMappingBuilder_.clear();
        }
        outputTensorName_ = "";
        displayNameMappingCase_ = 0;
        displayNameMapping_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
            .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_OutputMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata build() {
        com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata buildPartial() {
        com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata result =
            new com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.outputTensorName_ = outputTensorName_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata result) {
        result.displayNameMappingCase_ = displayNameMappingCase_;
        result.displayNameMapping_ = this.displayNameMapping_;
        if (displayNameMappingCase_ == 1 && indexDisplayNameMappingBuilder_ != null) {
          result.displayNameMapping_ = indexDisplayNameMappingBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata other) {
        if (other
            == com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata
                .getDefaultInstance()) return this;
        if (!other.getOutputTensorName().isEmpty()) {
          outputTensorName_ = other.outputTensorName_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        switch (other.getDisplayNameMappingCase()) {
          case INDEX_DISPLAY_NAME_MAPPING:
            {
              mergeIndexDisplayNameMapping(other.getIndexDisplayNameMapping());
              break;
            }
          case DISPLAY_NAME_MAPPING_KEY:
            {
              displayNameMappingCase_ = 2;
              displayNameMapping_ = other.displayNameMapping_;
              onChanged();
              break;
            }
          case DISPLAYNAMEMAPPING_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getIndexDisplayNameMappingFieldBuilder().getBuilder(), extensionRegistry);
                  displayNameMappingCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  displayNameMappingCase_ = 2;
                  displayNameMapping_ = s;
                  break;
                } // case 18
              case 26:
                {
                  outputTensorName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int displayNameMappingCase_ = 0;
      private java.lang.Object displayNameMapping_;

      public DisplayNameMappingCase getDisplayNameMappingCase() {
        return DisplayNameMappingCase.forNumber(displayNameMappingCase_);
      }

      public Builder clearDisplayNameMapping() {
        displayNameMappingCase_ = 0;
        displayNameMapping_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder,
              com.google.protobuf.ValueOrBuilder>
          indexDisplayNameMappingBuilder_;
      /**
       *
       *
       * <pre>
       * Static mapping between the index and display name.
       *
       * Use this if the outputs are a deterministic n-dimensional array, e.g. a
       * list of scores of all the classes in a pre-defined order for a
       * multi-classification Model. It's not feasible if the outputs are
       * non-deterministic, e.g. the Model produces top-k classes or sort the
       * outputs by their values.
       *
       * The shape of the value must be an n-dimensional array of strings. The
       * number of dimensions must match that of the outputs to be explained.
       * The
       * [Attribution.output_display_name][google.cloud.aiplatform.v1.Attribution.output_display_name]
       * is populated by locating in the mapping with
       * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index].
       * </pre>
       *
       * <code>.google.protobuf.Value index_display_name_mapping = 1;</code>
       *
       * @return Whether the indexDisplayNameMapping field is set.
       */
      @java.lang.Override
      public boolean hasIndexDisplayNameMapping() {
        return displayNameMappingCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Static mapping between the index and display name.
       *
       * Use this if the outputs are a deterministic n-dimensional array, e.g. a
       * list of scores of all the classes in a pre-defined order for a
       * multi-classification Model. It's not feasible if the outputs are
       * non-deterministic, e.g. the Model produces top-k classes or sort the
       * outputs by their values.
       *
       * The shape of the value must be an n-dimensional array of strings. The
       * number of dimensions must match that of the outputs to be explained.
       * The
       * [Attribution.output_display_name][google.cloud.aiplatform.v1.Attribution.output_display_name]
       * is populated by locating in the mapping with
       * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index].
       * </pre>
       *
       * <code>.google.protobuf.Value index_display_name_mapping = 1;</code>
       *
       * @return The indexDisplayNameMapping.
       */
      @java.lang.Override
      public com.google.protobuf.Value getIndexDisplayNameMapping() {
        if (indexDisplayNameMappingBuilder_ == null) {
          if (displayNameMappingCase_ == 1) {
            return (com.google.protobuf.Value) displayNameMapping_;
          }
          return com.google.protobuf.Value.getDefaultInstance();
        } else {
          if (displayNameMappingCase_ == 1) {
            return indexDisplayNameMappingBuilder_.getMessage();
          }
          return com.google.protobuf.Value.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Static mapping between the index and display name.
       *
       * Use this if the outputs are a deterministic n-dimensional array, e.g. a
       * list of scores of all the classes in a pre-defined order for a
       * multi-classification Model. It's not feasible if the outputs are
       * non-deterministic, e.g. the Model produces top-k classes or sort the
       * outputs by their values.
       *
       * The shape of the value must be an n-dimensional array of strings. The
       * number of dimensions must match that of the outputs to be explained.
       * The
       * [Attribution.output_display_name][google.cloud.aiplatform.v1.Attribution.output_display_name]
       * is populated by locating in the mapping with
       * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index].
       * </pre>
       *
       * <code>.google.protobuf.Value index_display_name_mapping = 1;</code>
       */
      public Builder setIndexDisplayNameMapping(com.google.protobuf.Value value) {
        if (indexDisplayNameMappingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          displayNameMapping_ = value;
          onChanged();
        } else {
          indexDisplayNameMappingBuilder_.setMessage(value);
        }
        displayNameMappingCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Static mapping between the index and display name.
       *
       * Use this if the outputs are a deterministic n-dimensional array, e.g. a
       * list of scores of all the classes in a pre-defined order for a
       * multi-classification Model. It's not feasible if the outputs are
       * non-deterministic, e.g. the Model produces top-k classes or sort the
       * outputs by their values.
       *
       * The shape of the value must be an n-dimensional array of strings. The
       * number of dimensions must match that of the outputs to be explained.
       * The
       * [Attribution.output_display_name][google.cloud.aiplatform.v1.Attribution.output_display_name]
       * is populated by locating in the mapping with
       * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index].
       * </pre>
       *
       * <code>.google.protobuf.Value index_display_name_mapping = 1;</code>
       */
      public Builder setIndexDisplayNameMapping(com.google.protobuf.Value.Builder builderForValue) {
        if (indexDisplayNameMappingBuilder_ == null) {
          displayNameMapping_ = builderForValue.build();
          onChanged();
        } else {
          indexDisplayNameMappingBuilder_.setMessage(builderForValue.build());
        }
        displayNameMappingCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Static mapping between the index and display name.
       *
       * Use this if the outputs are a deterministic n-dimensional array, e.g. a
       * list of scores of all the classes in a pre-defined order for a
       * multi-classification Model. It's not feasible if the outputs are
       * non-deterministic, e.g. the Model produces top-k classes or sort the
       * outputs by their values.
       *
       * The shape of the value must be an n-dimensional array of strings. The
       * number of dimensions must match that of the outputs to be explained.
       * The
       * [Attribution.output_display_name][google.cloud.aiplatform.v1.Attribution.output_display_name]
       * is populated by locating in the mapping with
       * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index].
       * </pre>
       *
       * <code>.google.protobuf.Value index_display_name_mapping = 1;</code>
       */
      public Builder mergeIndexDisplayNameMapping(com.google.protobuf.Value value) {
        if (indexDisplayNameMappingBuilder_ == null) {
          if (displayNameMappingCase_ == 1
              && displayNameMapping_ != com.google.protobuf.Value.getDefaultInstance()) {
            displayNameMapping_ =
                com.google.protobuf.Value.newBuilder(
                        (com.google.protobuf.Value) displayNameMapping_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            displayNameMapping_ = value;
          }
          onChanged();
        } else {
          if (displayNameMappingCase_ == 1) {
            indexDisplayNameMappingBuilder_.mergeFrom(value);
          } else {
            indexDisplayNameMappingBuilder_.setMessage(value);
          }
        }
        displayNameMappingCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Static mapping between the index and display name.
       *
       * Use this if the outputs are a deterministic n-dimensional array, e.g. a
       * list of scores of all the classes in a pre-defined order for a
       * multi-classification Model. It's not feasible if the outputs are
       * non-deterministic, e.g. the Model produces top-k classes or sort the
       * outputs by their values.
       *
       * The shape of the value must be an n-dimensional array of strings. The
       * number of dimensions must match that of the outputs to be explained.
       * The
       * [Attribution.output_display_name][google.cloud.aiplatform.v1.Attribution.output_display_name]
       * is populated by locating in the mapping with
       * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index].
       * </pre>
       *
       * <code>.google.protobuf.Value index_display_name_mapping = 1;</code>
       */
      public Builder clearIndexDisplayNameMapping() {
        if (indexDisplayNameMappingBuilder_ == null) {
          if (displayNameMappingCase_ == 1) {
            displayNameMappingCase_ = 0;
            displayNameMapping_ = null;
            onChanged();
          }
        } else {
          if (displayNameMappingCase_ == 1) {
            displayNameMappingCase_ = 0;
            displayNameMapping_ = null;
          }
          indexDisplayNameMappingBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Static mapping between the index and display name.
       *
       * Use this if the outputs are a deterministic n-dimensional array, e.g. a
       * list of scores of all the classes in a pre-defined order for a
       * multi-classification Model. It's not feasible if the outputs are
       * non-deterministic, e.g. the Model produces top-k classes or sort the
       * outputs by their values.
       *
       * The shape of the value must be an n-dimensional array of strings. The
       * number of dimensions must match that of the outputs to be explained.
       * The
       * [Attribution.output_display_name][google.cloud.aiplatform.v1.Attribution.output_display_name]
       * is populated by locating in the mapping with
       * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index].
       * </pre>
       *
       * <code>.google.protobuf.Value index_display_name_mapping = 1;</code>
       */
      public com.google.protobuf.Value.Builder getIndexDisplayNameMappingBuilder() {
        return getIndexDisplayNameMappingFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Static mapping between the index and display name.
       *
       * Use this if the outputs are a deterministic n-dimensional array, e.g. a
       * list of scores of all the classes in a pre-defined order for a
       * multi-classification Model. It's not feasible if the outputs are
       * non-deterministic, e.g. the Model produces top-k classes or sort the
       * outputs by their values.
       *
       * The shape of the value must be an n-dimensional array of strings. The
       * number of dimensions must match that of the outputs to be explained.
       * The
       * [Attribution.output_display_name][google.cloud.aiplatform.v1.Attribution.output_display_name]
       * is populated by locating in the mapping with
       * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index].
       * </pre>
       *
       * <code>.google.protobuf.Value index_display_name_mapping = 1;</code>
       */
      @java.lang.Override
      public com.google.protobuf.ValueOrBuilder getIndexDisplayNameMappingOrBuilder() {
        if ((displayNameMappingCase_ == 1) && (indexDisplayNameMappingBuilder_ != null)) {
          return indexDisplayNameMappingBuilder_.getMessageOrBuilder();
        } else {
          if (displayNameMappingCase_ == 1) {
            return (com.google.protobuf.Value) displayNameMapping_;
          }
          return com.google.protobuf.Value.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Static mapping between the index and display name.
       *
       * Use this if the outputs are a deterministic n-dimensional array, e.g. a
       * list of scores of all the classes in a pre-defined order for a
       * multi-classification Model. It's not feasible if the outputs are
       * non-deterministic, e.g. the Model produces top-k classes or sort the
       * outputs by their values.
       *
       * The shape of the value must be an n-dimensional array of strings. The
       * number of dimensions must match that of the outputs to be explained.
       * The
       * [Attribution.output_display_name][google.cloud.aiplatform.v1.Attribution.output_display_name]
       * is populated by locating in the mapping with
       * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index].
       * </pre>
       *
       * <code>.google.protobuf.Value index_display_name_mapping = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Value,
              com.google.protobuf.Value.Builder,
              com.google.protobuf.ValueOrBuilder>
          getIndexDisplayNameMappingFieldBuilder() {
        if (indexDisplayNameMappingBuilder_ == null) {
          if (!(displayNameMappingCase_ == 1)) {
            displayNameMapping_ = com.google.protobuf.Value.getDefaultInstance();
          }
          indexDisplayNameMappingBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Value,
                  com.google.protobuf.Value.Builder,
                  com.google.protobuf.ValueOrBuilder>(
                  (com.google.protobuf.Value) displayNameMapping_,
                  getParentForChildren(),
                  isClean());
          displayNameMapping_ = null;
        }
        displayNameMappingCase_ = 1;
        onChanged();
        return indexDisplayNameMappingBuilder_;
      }

      /**
       *
       *
       * <pre>
       * Specify a field name in the prediction to look for the display name.
       *
       * Use this if the prediction contains the display names for the outputs.
       *
       * The display names in the prediction must have the same shape of the
       * outputs, so that it can be located by
       * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
       * for a specific output.
       * </pre>
       *
       * <code>string display_name_mapping_key = 2;</code>
       *
       * @return Whether the displayNameMappingKey field is set.
       */
      @java.lang.Override
      public boolean hasDisplayNameMappingKey() {
        return displayNameMappingCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Specify a field name in the prediction to look for the display name.
       *
       * Use this if the prediction contains the display names for the outputs.
       *
       * The display names in the prediction must have the same shape of the
       * outputs, so that it can be located by
       * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
       * for a specific output.
       * </pre>
       *
       * <code>string display_name_mapping_key = 2;</code>
       *
       * @return The displayNameMappingKey.
       */
      @java.lang.Override
      public java.lang.String getDisplayNameMappingKey() {
        java.lang.Object ref = "";
        if (displayNameMappingCase_ == 2) {
          ref = displayNameMapping_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (displayNameMappingCase_ == 2) {
            displayNameMapping_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specify a field name in the prediction to look for the display name.
       *
       * Use this if the prediction contains the display names for the outputs.
       *
       * The display names in the prediction must have the same shape of the
       * outputs, so that it can be located by
       * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
       * for a specific output.
       * </pre>
       *
       * <code>string display_name_mapping_key = 2;</code>
       *
       * @return The bytes for displayNameMappingKey.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDisplayNameMappingKeyBytes() {
        java.lang.Object ref = "";
        if (displayNameMappingCase_ == 2) {
          ref = displayNameMapping_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (displayNameMappingCase_ == 2) {
            displayNameMapping_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specify a field name in the prediction to look for the display name.
       *
       * Use this if the prediction contains the display names for the outputs.
       *
       * The display names in the prediction must have the same shape of the
       * outputs, so that it can be located by
       * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
       * for a specific output.
       * </pre>
       *
       * <code>string display_name_mapping_key = 2;</code>
       *
       * @param value The displayNameMappingKey to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameMappingKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayNameMappingCase_ = 2;
        displayNameMapping_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specify a field name in the prediction to look for the display name.
       *
       * Use this if the prediction contains the display names for the outputs.
       *
       * The display names in the prediction must have the same shape of the
       * outputs, so that it can be located by
       * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
       * for a specific output.
       * </pre>
       *
       * <code>string display_name_mapping_key = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayNameMappingKey() {
        if (displayNameMappingCase_ == 2) {
          displayNameMappingCase_ = 0;
          displayNameMapping_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specify a field name in the prediction to look for the display name.
       *
       * Use this if the prediction contains the display names for the outputs.
       *
       * The display names in the prediction must have the same shape of the
       * outputs, so that it can be located by
       * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
       * for a specific output.
       * </pre>
       *
       * <code>string display_name_mapping_key = 2;</code>
       *
       * @param value The bytes for displayNameMappingKey to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameMappingKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayNameMappingCase_ = 2;
        displayNameMapping_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object outputTensorName_ = "";
      /**
       *
       *
       * <pre>
       * Name of the output tensor. Required and is only applicable to Vertex
       * AI provided images for Tensorflow.
       * </pre>
       *
       * <code>string output_tensor_name = 3;</code>
       *
       * @return The outputTensorName.
       */
      public java.lang.String getOutputTensorName() {
        java.lang.Object ref = outputTensorName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          outputTensorName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the output tensor. Required and is only applicable to Vertex
       * AI provided images for Tensorflow.
       * </pre>
       *
       * <code>string output_tensor_name = 3;</code>
       *
       * @return The bytes for outputTensorName.
       */
      public com.google.protobuf.ByteString getOutputTensorNameBytes() {
        java.lang.Object ref = outputTensorName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          outputTensorName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the output tensor. Required and is only applicable to Vertex
       * AI provided images for Tensorflow.
       * </pre>
       *
       * <code>string output_tensor_name = 3;</code>
       *
       * @param value The outputTensorName to set.
       * @return This builder for chaining.
       */
      public Builder setOutputTensorName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputTensorName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the output tensor. Required and is only applicable to Vertex
       * AI provided images for Tensorflow.
       * </pre>
       *
       * <code>string output_tensor_name = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOutputTensorName() {
        outputTensorName_ = getDefaultInstance().getOutputTensorName();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the output tensor. Required and is only applicable to Vertex
       * AI provided images for Tensorflow.
       * </pre>
       *
       * <code>string output_tensor_name = 3;</code>
       *
       * @param value The bytes for outputTensorName to set.
       * @return This builder for chaining.
       */
      public Builder setOutputTensorNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        outputTensorName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata)
    private static final com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata();
    }

    public static com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OutputMetadata> PARSER =
        new com.google.protobuf.AbstractParser<OutputMetadata>() {
          @java.lang.Override
          public OutputMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OutputMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OutputMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int INPUTS_FIELD_NUMBER = 1;

  private static final class InputsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
                    newDefaultInstance(
                        com.google.cloud.aiplatform.v1.ExplanationMetadataProto
                            .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_InputsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
      inputs_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
      internalGetInputs() {
    if (inputs_ == null) {
      return com.google.protobuf.MapField.emptyMapField(InputsDefaultEntryHolder.defaultEntry);
    }
    return inputs_;
  }

  public int getInputsCount() {
    return internalGetInputs().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Required. Map from feature names to feature input metadata. Keys are the
   * name of the features. Values are the specification of the feature.
   *
   * An empty InputMetadata is valid. It describes a text feature which has the
   * name specified as the key in
   * [ExplanationMetadata.inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
   * The baseline of the empty feature is chosen by Vertex AI.
   *
   * For Vertex AI-provided Tensorflow images, the key can be any friendly
   * name of the feature. Once specified,
   * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
   * are keyed by this key (if not grouped with another feature).
   *
   * For custom images, the key must match with the key in
   * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances].
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata&gt; inputs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public boolean containsInputs(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetInputs().getMap().containsKey(key);
  }
  /** Use {@link #getInputsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
      getInputs() {
    return getInputsMap();
  }
  /**
   *
   *
   * <pre>
   * Required. Map from feature names to feature input metadata. Keys are the
   * name of the features. Values are the specification of the feature.
   *
   * An empty InputMetadata is valid. It describes a text feature which has the
   * name specified as the key in
   * [ExplanationMetadata.inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
   * The baseline of the empty feature is chosen by Vertex AI.
   *
   * For Vertex AI-provided Tensorflow images, the key can be any friendly
   * name of the feature. Once specified,
   * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
   * are keyed by this key (if not grouped with another feature).
   *
   * For custom images, the key must match with the key in
   * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances].
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata&gt; inputs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
      getInputsMap() {
    return internalGetInputs().getMap();
  }
  /**
   *
   *
   * <pre>
   * Required. Map from feature names to feature input metadata. Keys are the
   * name of the features. Values are the specification of the feature.
   *
   * An empty InputMetadata is valid. It describes a text feature which has the
   * name specified as the key in
   * [ExplanationMetadata.inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
   * The baseline of the empty feature is chosen by Vertex AI.
   *
   * For Vertex AI-provided Tensorflow images, the key can be any friendly
   * name of the feature. Once specified,
   * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
   * are keyed by this key (if not grouped with another feature).
   *
   * For custom images, the key must match with the key in
   * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances].
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata&gt; inputs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
      getInputsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
        map = internalGetInputs().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Required. Map from feature names to feature input metadata. Keys are the
   * name of the features. Values are the specification of the feature.
   *
   * An empty InputMetadata is valid. It describes a text feature which has the
   * name specified as the key in
   * [ExplanationMetadata.inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
   * The baseline of the empty feature is chosen by Vertex AI.
   *
   * For Vertex AI-provided Tensorflow images, the key can be any friendly
   * name of the feature. Once specified,
   * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
   * are keyed by this key (if not grouped with another feature).
   *
   * For custom images, the key must match with the key in
   * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances].
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata&gt; inputs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata getInputsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
        map = internalGetInputs().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int OUTPUTS_FIELD_NUMBER = 2;

  private static final class OutputsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
                    newDefaultInstance(
                        com.google.cloud.aiplatform.v1.ExplanationMetadataProto
                            .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_OutputsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
      outputs_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
      internalGetOutputs() {
    if (outputs_ == null) {
      return com.google.protobuf.MapField.emptyMapField(OutputsDefaultEntryHolder.defaultEntry);
    }
    return outputs_;
  }

  public int getOutputsCount() {
    return internalGetOutputs().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Required. Map from output names to output metadata.
   *
   * For Vertex AI-provided Tensorflow images, keys can be any user defined
   * string that consists of any UTF-8 characters.
   *
   * For custom images, keys are the name of the output field in the prediction
   * to be explained.
   *
   * Currently only one key is allowed.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata&gt; outputs = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public boolean containsOutputs(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetOutputs().getMap().containsKey(key);
  }
  /** Use {@link #getOutputsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
      getOutputs() {
    return getOutputsMap();
  }
  /**
   *
   *
   * <pre>
   * Required. Map from output names to output metadata.
   *
   * For Vertex AI-provided Tensorflow images, keys can be any user defined
   * string that consists of any UTF-8 characters.
   *
   * For custom images, keys are the name of the output field in the prediction
   * to be explained.
   *
   * Currently only one key is allowed.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata&gt; outputs = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
      getOutputsMap() {
    return internalGetOutputs().getMap();
  }
  /**
   *
   *
   * <pre>
   * Required. Map from output names to output metadata.
   *
   * For Vertex AI-provided Tensorflow images, keys can be any user defined
   * string that consists of any UTF-8 characters.
   *
   * For custom images, keys are the name of the output field in the prediction
   * to be explained.
   *
   * Currently only one key is allowed.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata&gt; outputs = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata
      getOutputsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
        map = internalGetOutputs().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Required. Map from output names to output metadata.
   *
   * For Vertex AI-provided Tensorflow images, keys can be any user defined
   * string that consists of any UTF-8 characters.
   *
   * For custom images, keys are the name of the output field in the prediction
   * to be explained.
   *
   * Currently only one key is allowed.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata&gt; outputs = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata getOutputsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
        map = internalGetOutputs().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int FEATURE_ATTRIBUTIONS_SCHEMA_URI_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object featureAttributionsSchemaUri_ = "";
  /**
   *
   *
   * <pre>
   * Points to a YAML file stored on Google Cloud Storage describing the format
   * of the [feature
   * attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
   * The schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * AutoML tabular Models always have this field populated by Vertex AI.
   * Note: The URI given on output may be different, including the URI scheme,
   * than the one given on input. The output URI will point to a location where
   * the user only has a read access.
   * </pre>
   *
   * <code>string feature_attributions_schema_uri = 3;</code>
   *
   * @return The featureAttributionsSchemaUri.
   */
  @java.lang.Override
  public java.lang.String getFeatureAttributionsSchemaUri() {
    java.lang.Object ref = featureAttributionsSchemaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      featureAttributionsSchemaUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Points to a YAML file stored on Google Cloud Storage describing the format
   * of the [feature
   * attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
   * The schema is defined as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * AutoML tabular Models always have this field populated by Vertex AI.
   * Note: The URI given on output may be different, including the URI scheme,
   * than the one given on input. The output URI will point to a location where
   * the user only has a read access.
   * </pre>
   *
   * <code>string feature_attributions_schema_uri = 3;</code>
   *
   * @return The bytes for featureAttributionsSchemaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFeatureAttributionsSchemaUriBytes() {
    java.lang.Object ref = featureAttributionsSchemaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      featureAttributionsSchemaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LATENT_SPACE_SOURCE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object latentSpaceSource_ = "";
  /**
   *
   *
   * <pre>
   * Name of the source to generate embeddings for example based explanations.
   * </pre>
   *
   * <code>string latent_space_source = 5;</code>
   *
   * @return The latentSpaceSource.
   */
  @java.lang.Override
  public java.lang.String getLatentSpaceSource() {
    java.lang.Object ref = latentSpaceSource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      latentSpaceSource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the source to generate embeddings for example based explanations.
   * </pre>
   *
   * <code>string latent_space_source = 5;</code>
   *
   * @return The bytes for latentSpaceSource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLatentSpaceSourceBytes() {
    java.lang.Object ref = latentSpaceSource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      latentSpaceSource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetInputs(), InputsDefaultEntryHolder.defaultEntry, 1);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetOutputs(), OutputsDefaultEntryHolder.defaultEntry, 2);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureAttributionsSchemaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, featureAttributionsSchemaUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latentSpaceSource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, latentSpaceSource_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
        entry : internalGetInputs().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
          inputs__ =
              InputsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, inputs__);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
        entry : internalGetOutputs().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
          outputs__ =
              OutputsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, outputs__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureAttributionsSchemaUri_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              3, featureAttributionsSchemaUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latentSpaceSource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, latentSpaceSource_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.ExplanationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.ExplanationMetadata other =
        (com.google.cloud.aiplatform.v1.ExplanationMetadata) obj;

    if (!internalGetInputs().equals(other.internalGetInputs())) return false;
    if (!internalGetOutputs().equals(other.internalGetOutputs())) return false;
    if (!getFeatureAttributionsSchemaUri().equals(other.getFeatureAttributionsSchemaUri()))
      return false;
    if (!getLatentSpaceSource().equals(other.getLatentSpaceSource())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetInputs().getMap().isEmpty()) {
      hash = (37 * hash) + INPUTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetInputs().hashCode();
    }
    if (!internalGetOutputs().getMap().isEmpty()) {
      hash = (37 * hash) + OUTPUTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetOutputs().hashCode();
    }
    hash = (37 * hash) + FEATURE_ATTRIBUTIONS_SCHEMA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getFeatureAttributionsSchemaUri().hashCode();
    hash = (37 * hash) + LATENT_SPACE_SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getLatentSpaceSource().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.ExplanationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ExplanationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.ExplanationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata describing the Model's input and output for explanation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ExplanationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ExplanationMetadata)
      com.google.cloud.aiplatform.v1.ExplanationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
          .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetInputs();
        case 2:
          return internalGetOutputs();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetMutableInputs();
        case 2:
          return internalGetMutableOutputs();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
          .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ExplanationMetadata.class,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.ExplanationMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableInputs().clear();
      internalGetMutableOutputs().clear();
      featureAttributionsSchemaUri_ = "";
      latentSpaceSource_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ExplanationMetadataProto
          .internal_static_google_cloud_aiplatform_v1_ExplanationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationMetadata getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.ExplanationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationMetadata build() {
      com.google.cloud.aiplatform.v1.ExplanationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationMetadata buildPartial() {
      com.google.cloud.aiplatform.v1.ExplanationMetadata result =
          new com.google.cloud.aiplatform.v1.ExplanationMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.ExplanationMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.inputs_ = internalGetInputs().build(InputsDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.outputs_ = internalGetOutputs().build(OutputsDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.featureAttributionsSchemaUri_ = featureAttributionsSchemaUri_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.latentSpaceSource_ = latentSpaceSource_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.ExplanationMetadata) {
        return mergeFrom((com.google.cloud.aiplatform.v1.ExplanationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.ExplanationMetadata other) {
      if (other == com.google.cloud.aiplatform.v1.ExplanationMetadata.getDefaultInstance())
        return this;
      internalGetMutableInputs().mergeFrom(other.internalGetInputs());
      bitField0_ |= 0x00000001;
      internalGetMutableOutputs().mergeFrom(other.internalGetOutputs());
      bitField0_ |= 0x00000002;
      if (!other.getFeatureAttributionsSchemaUri().isEmpty()) {
        featureAttributionsSchemaUri_ = other.featureAttributionsSchemaUri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getLatentSpaceSource().isEmpty()) {
        latentSpaceSource_ = other.latentSpaceSource_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
                    inputs__ =
                        input.readMessage(
                            InputsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableInputs()
                    .ensureBuilderMap()
                    .put(inputs__.getKey(), inputs__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
                    outputs__ =
                        input.readMessage(
                            OutputsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableOutputs()
                    .ensureBuilderMap()
                    .put(outputs__.getKey(), outputs__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                featureAttributionsSchemaUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                latentSpaceSource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private static final class InputsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadataOrBuilder,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata> {
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata build(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadataOrBuilder val) {
        if (val instanceof com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata) {
          return (com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata) val;
        }
        return ((com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Builder) val)
            .build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
          defaultEntry() {
        return InputsDefaultEntryHolder.defaultEntry;
      }
    };

    private static final InputsConverter inputsConverter = new InputsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadataOrBuilder,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Builder>
        inputs_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadataOrBuilder,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Builder>
        internalGetInputs() {
      if (inputs_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(inputsConverter);
      }
      return inputs_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadataOrBuilder,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Builder>
        internalGetMutableInputs() {
      if (inputs_ == null) {
        inputs_ = new com.google.protobuf.MapFieldBuilder<>(inputsConverter);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return inputs_;
    }

    public int getInputsCount() {
      return internalGetInputs().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Required. Map from feature names to feature input metadata. Keys are the
     * name of the features. Values are the specification of the feature.
     *
     * An empty InputMetadata is valid. It describes a text feature which has the
     * name specified as the key in
     * [ExplanationMetadata.inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
     * The baseline of the empty feature is chosen by Vertex AI.
     *
     * For Vertex AI-provided Tensorflow images, the key can be any friendly
     * name of the feature. Once specified,
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * are keyed by this key (if not grouped with another feature).
     *
     * For custom images, the key must match with the key in
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata&gt; inputs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public boolean containsInputs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetInputs().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getInputsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
        getInputs() {
      return getInputsMap();
    }
    /**
     *
     *
     * <pre>
     * Required. Map from feature names to feature input metadata. Keys are the
     * name of the features. Values are the specification of the feature.
     *
     * An empty InputMetadata is valid. It describes a text feature which has the
     * name specified as the key in
     * [ExplanationMetadata.inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
     * The baseline of the empty feature is chosen by Vertex AI.
     *
     * For Vertex AI-provided Tensorflow images, the key can be any friendly
     * name of the feature. Once specified,
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * are keyed by this key (if not grouped with another feature).
     *
     * For custom images, the key must match with the key in
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata&gt; inputs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
        getInputsMap() {
      return internalGetInputs().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Required. Map from feature names to feature input metadata. Keys are the
     * name of the features. Values are the specification of the feature.
     *
     * An empty InputMetadata is valid. It describes a text feature which has the
     * name specified as the key in
     * [ExplanationMetadata.inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
     * The baseline of the empty feature is chosen by Vertex AI.
     *
     * For Vertex AI-provided Tensorflow images, the key can be any friendly
     * name of the feature. Once specified,
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * are keyed by this key (if not grouped with another feature).
     *
     * For custom images, the key must match with the key in
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata&gt; inputs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata
        getInputsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadataOrBuilder>
          map = internalGetMutableInputs().ensureBuilderMap();
      return map.containsKey(key) ? inputsConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Required. Map from feature names to feature input metadata. Keys are the
     * name of the features. Values are the specification of the feature.
     *
     * An empty InputMetadata is valid. It describes a text feature which has the
     * name specified as the key in
     * [ExplanationMetadata.inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
     * The baseline of the empty feature is chosen by Vertex AI.
     *
     * For Vertex AI-provided Tensorflow images, the key can be any friendly
     * name of the feature. Once specified,
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * are keyed by this key (if not grouped with another feature).
     *
     * For custom images, the key must match with the key in
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata&gt; inputs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata getInputsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadataOrBuilder>
          map = internalGetMutableInputs().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return inputsConverter.build(map.get(key));
    }

    public Builder clearInputs() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableInputs().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Map from feature names to feature input metadata. Keys are the
     * name of the features. Values are the specification of the feature.
     *
     * An empty InputMetadata is valid. It describes a text feature which has the
     * name specified as the key in
     * [ExplanationMetadata.inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
     * The baseline of the empty feature is chosen by Vertex AI.
     *
     * For Vertex AI-provided Tensorflow images, the key can be any friendly
     * name of the feature. Once specified,
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * are keyed by this key (if not grouped with another feature).
     *
     * For custom images, the key must match with the key in
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata&gt; inputs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeInputs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableInputs().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
        getMutableInputs() {
      bitField0_ |= 0x00000001;
      return internalGetMutableInputs().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Required. Map from feature names to feature input metadata. Keys are the
     * name of the features. Values are the specification of the feature.
     *
     * An empty InputMetadata is valid. It describes a text feature which has the
     * name specified as the key in
     * [ExplanationMetadata.inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
     * The baseline of the empty feature is chosen by Vertex AI.
     *
     * For Vertex AI-provided Tensorflow images, the key can be any friendly
     * name of the feature. Once specified,
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * are keyed by this key (if not grouped with another feature).
     *
     * For custom images, the key must match with the key in
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata&gt; inputs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder putInputs(
        java.lang.String key,
        com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableInputs().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Map from feature names to feature input metadata. Keys are the
     * name of the features. Values are the specification of the feature.
     *
     * An empty InputMetadata is valid. It describes a text feature which has the
     * name specified as the key in
     * [ExplanationMetadata.inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
     * The baseline of the empty feature is chosen by Vertex AI.
     *
     * For Vertex AI-provided Tensorflow images, the key can be any friendly
     * name of the feature. Once specified,
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * are keyed by this key (if not grouped with another feature).
     *
     * For custom images, the key must match with the key in
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata&gt; inputs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder putAllInputs(
        java.util.Map<
                java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableInputs().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Map from feature names to feature input metadata. Keys are the
     * name of the features. Values are the specification of the feature.
     *
     * An empty InputMetadata is valid. It describes a text feature which has the
     * name specified as the key in
     * [ExplanationMetadata.inputs][google.cloud.aiplatform.v1.ExplanationMetadata.inputs].
     * The baseline of the empty feature is chosen by Vertex AI.
     *
     * For Vertex AI-provided Tensorflow images, the key can be any friendly
     * name of the feature. Once specified,
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * are keyed by this key (if not grouped with another feature).
     *
     * For custom images, the key must match with the key in
     * [instance][google.cloud.aiplatform.v1.ExplainRequest.instances].
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata&gt; inputs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Builder
        putInputsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadataOrBuilder>
          builderMap = internalGetMutableInputs().ensureBuilderMap();
      com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadataOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata) {
        entry =
            ((com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.aiplatform.v1.ExplanationMetadata.InputMetadata.Builder) entry;
    }

    private static final class OutputsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadataOrBuilder,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata> {
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata build(
          com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadataOrBuilder val) {
        if (val instanceof com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata) {
          return (com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata) val;
        }
        return ((com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata.Builder) val)
            .build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
          defaultEntry() {
        return OutputsDefaultEntryHolder.defaultEntry;
      }
    };

    private static final OutputsConverter outputsConverter = new OutputsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadataOrBuilder,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata.Builder>
        outputs_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadataOrBuilder,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata.Builder>
        internalGetOutputs() {
      if (outputs_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(outputsConverter);
      }
      return outputs_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadataOrBuilder,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata,
            com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata.Builder>
        internalGetMutableOutputs() {
      if (outputs_ == null) {
        outputs_ = new com.google.protobuf.MapFieldBuilder<>(outputsConverter);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return outputs_;
    }

    public int getOutputsCount() {
      return internalGetOutputs().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Required. Map from output names to output metadata.
     *
     * For Vertex AI-provided Tensorflow images, keys can be any user defined
     * string that consists of any UTF-8 characters.
     *
     * For custom images, keys are the name of the output field in the prediction
     * to be explained.
     *
     * Currently only one key is allowed.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata&gt; outputs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public boolean containsOutputs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetOutputs().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getOutputsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
        getOutputs() {
      return getOutputsMap();
    }
    /**
     *
     *
     * <pre>
     * Required. Map from output names to output metadata.
     *
     * For Vertex AI-provided Tensorflow images, keys can be any user defined
     * string that consists of any UTF-8 characters.
     *
     * For custom images, keys are the name of the output field in the prediction
     * to be explained.
     *
     * Currently only one key is allowed.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata&gt; outputs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
        getOutputsMap() {
      return internalGetOutputs().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Required. Map from output names to output metadata.
     *
     * For Vertex AI-provided Tensorflow images, keys can be any user defined
     * string that consists of any UTF-8 characters.
     *
     * For custom images, keys are the name of the output field in the prediction
     * to be explained.
     *
     * Currently only one key is allowed.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata&gt; outputs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata
        getOutputsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadataOrBuilder>
          map = internalGetMutableOutputs().ensureBuilderMap();
      return map.containsKey(key) ? outputsConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Required. Map from output names to output metadata.
     *
     * For Vertex AI-provided Tensorflow images, keys can be any user defined
     * string that consists of any UTF-8 characters.
     *
     * For custom images, keys are the name of the output field in the prediction
     * to be explained.
     *
     * Currently only one key is allowed.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata&gt; outputs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata getOutputsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadataOrBuilder>
          map = internalGetMutableOutputs().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return outputsConverter.build(map.get(key));
    }

    public Builder clearOutputs() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableOutputs().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Map from output names to output metadata.
     *
     * For Vertex AI-provided Tensorflow images, keys can be any user defined
     * string that consists of any UTF-8 characters.
     *
     * For custom images, keys are the name of the output field in the prediction
     * to be explained.
     *
     * Currently only one key is allowed.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata&gt; outputs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeOutputs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableOutputs().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
        getMutableOutputs() {
      bitField0_ |= 0x00000002;
      return internalGetMutableOutputs().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Required. Map from output names to output metadata.
     *
     * For Vertex AI-provided Tensorflow images, keys can be any user defined
     * string that consists of any UTF-8 characters.
     *
     * For custom images, keys are the name of the output field in the prediction
     * to be explained.
     *
     * Currently only one key is allowed.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata&gt; outputs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder putOutputs(
        java.lang.String key,
        com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableOutputs().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Map from output names to output metadata.
     *
     * For Vertex AI-provided Tensorflow images, keys can be any user defined
     * string that consists of any UTF-8 characters.
     *
     * For custom images, keys are the name of the output field in the prediction
     * to be explained.
     *
     * Currently only one key is allowed.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata&gt; outputs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder putAllOutputs(
        java.util.Map<
                java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableOutputs().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Map from output names to output metadata.
     *
     * For Vertex AI-provided Tensorflow images, keys can be any user defined
     * string that consists of any UTF-8 characters.
     *
     * For custom images, keys are the name of the output field in the prediction
     * to be explained.
     *
     * Currently only one key is allowed.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata&gt; outputs = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata.Builder
        putOutputsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadataOrBuilder>
          builderMap = internalGetMutableOutputs().ensureBuilderMap();
      com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadataOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata) {
        entry =
            ((com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.aiplatform.v1.ExplanationMetadata.OutputMetadata.Builder) entry;
    }

    private java.lang.Object featureAttributionsSchemaUri_ = "";
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing the format
     * of the [feature
     * attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML tabular Models always have this field populated by Vertex AI.
     * Note: The URI given on output may be different, including the URI scheme,
     * than the one given on input. The output URI will point to a location where
     * the user only has a read access.
     * </pre>
     *
     * <code>string feature_attributions_schema_uri = 3;</code>
     *
     * @return The featureAttributionsSchemaUri.
     */
    public java.lang.String getFeatureAttributionsSchemaUri() {
      java.lang.Object ref = featureAttributionsSchemaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        featureAttributionsSchemaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing the format
     * of the [feature
     * attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML tabular Models always have this field populated by Vertex AI.
     * Note: The URI given on output may be different, including the URI scheme,
     * than the one given on input. The output URI will point to a location where
     * the user only has a read access.
     * </pre>
     *
     * <code>string feature_attributions_schema_uri = 3;</code>
     *
     * @return The bytes for featureAttributionsSchemaUri.
     */
    public com.google.protobuf.ByteString getFeatureAttributionsSchemaUriBytes() {
      java.lang.Object ref = featureAttributionsSchemaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        featureAttributionsSchemaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing the format
     * of the [feature
     * attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML tabular Models always have this field populated by Vertex AI.
     * Note: The URI given on output may be different, including the URI scheme,
     * than the one given on input. The output URI will point to a location where
     * the user only has a read access.
     * </pre>
     *
     * <code>string feature_attributions_schema_uri = 3;</code>
     *
     * @param value The featureAttributionsSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureAttributionsSchemaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      featureAttributionsSchemaUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing the format
     * of the [feature
     * attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML tabular Models always have this field populated by Vertex AI.
     * Note: The URI given on output may be different, including the URI scheme,
     * than the one given on input. The output URI will point to a location where
     * the user only has a read access.
     * </pre>
     *
     * <code>string feature_attributions_schema_uri = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFeatureAttributionsSchemaUri() {
      featureAttributionsSchemaUri_ = getDefaultInstance().getFeatureAttributionsSchemaUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a YAML file stored on Google Cloud Storage describing the format
     * of the [feature
     * attributions][google.cloud.aiplatform.v1.Attribution.feature_attributions].
     * The schema is defined as an OpenAPI 3.0.2 [Schema
     * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
     * AutoML tabular Models always have this field populated by Vertex AI.
     * Note: The URI given on output may be different, including the URI scheme,
     * than the one given on input. The output URI will point to a location where
     * the user only has a read access.
     * </pre>
     *
     * <code>string feature_attributions_schema_uri = 3;</code>
     *
     * @param value The bytes for featureAttributionsSchemaUri to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureAttributionsSchemaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      featureAttributionsSchemaUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object latentSpaceSource_ = "";
    /**
     *
     *
     * <pre>
     * Name of the source to generate embeddings for example based explanations.
     * </pre>
     *
     * <code>string latent_space_source = 5;</code>
     *
     * @return The latentSpaceSource.
     */
    public java.lang.String getLatentSpaceSource() {
      java.lang.Object ref = latentSpaceSource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        latentSpaceSource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the source to generate embeddings for example based explanations.
     * </pre>
     *
     * <code>string latent_space_source = 5;</code>
     *
     * @return The bytes for latentSpaceSource.
     */
    public com.google.protobuf.ByteString getLatentSpaceSourceBytes() {
      java.lang.Object ref = latentSpaceSource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        latentSpaceSource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the source to generate embeddings for example based explanations.
     * </pre>
     *
     * <code>string latent_space_source = 5;</code>
     *
     * @param value The latentSpaceSource to set.
     * @return This builder for chaining.
     */
    public Builder setLatentSpaceSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      latentSpaceSource_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the source to generate embeddings for example based explanations.
     * </pre>
     *
     * <code>string latent_space_source = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLatentSpaceSource() {
      latentSpaceSource_ = getDefaultInstance().getLatentSpaceSource();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the source to generate embeddings for example based explanations.
     * </pre>
     *
     * <code>string latent_space_source = 5;</code>
     *
     * @param value The bytes for latentSpaceSource to set.
     * @return This builder for chaining.
     */
    public Builder setLatentSpaceSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      latentSpaceSource_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ExplanationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ExplanationMetadata)
  private static final com.google.cloud.aiplatform.v1.ExplanationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ExplanationMetadata();
  }

  public static com.google.cloud.aiplatform.v1.ExplanationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExplanationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<ExplanationMetadata>() {
        @java.lang.Override
        public ExplanationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExplanationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExplanationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ExplanationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
