/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/featurestore_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Response message for
 * [FeaturestoreService.DeleteFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.DeleteFeatureValues].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.DeleteFeatureValuesResponse}
 */
public final class DeleteFeatureValuesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.DeleteFeatureValuesResponse)
    DeleteFeatureValuesResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DeleteFeatureValuesResponse.newBuilder() to construct.
  private DeleteFeatureValuesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeleteFeatureValuesResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeleteFeatureValuesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.class,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.Builder.class);
  }

  public interface SelectEntityOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The count of deleted entity rows in the offline storage.
     * Each row corresponds to the combination of an entity ID and a timestamp.
     * One entity ID can have multiple rows in the offline storage.
     * </pre>
     *
     * <code>int64 offline_storage_deleted_entity_row_count = 1;</code>
     *
     * @return The offlineStorageDeletedEntityRowCount.
     */
    long getOfflineStorageDeletedEntityRowCount();

    /**
     *
     *
     * <pre>
     * The count of deleted entities in the online storage.
     * Each entity ID corresponds to one entity.
     * </pre>
     *
     * <code>int64 online_storage_deleted_entity_count = 2;</code>
     *
     * @return The onlineStorageDeletedEntityCount.
     */
    long getOnlineStorageDeletedEntityCount();
  }
  /**
   *
   *
   * <pre>
   * Response message if the request uses the SelectEntity option.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity}
   */
  public static final class SelectEntity extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity)
      SelectEntityOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SelectEntity.newBuilder() to construct.
    private SelectEntity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SelectEntity() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SelectEntity();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesResponse_SelectEntity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesResponse_SelectEntity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity.class,
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity.Builder
                  .class);
    }

    public static final int OFFLINE_STORAGE_DELETED_ENTITY_ROW_COUNT_FIELD_NUMBER = 1;
    private long offlineStorageDeletedEntityRowCount_ = 0L;
    /**
     *
     *
     * <pre>
     * The count of deleted entity rows in the offline storage.
     * Each row corresponds to the combination of an entity ID and a timestamp.
     * One entity ID can have multiple rows in the offline storage.
     * </pre>
     *
     * <code>int64 offline_storage_deleted_entity_row_count = 1;</code>
     *
     * @return The offlineStorageDeletedEntityRowCount.
     */
    @java.lang.Override
    public long getOfflineStorageDeletedEntityRowCount() {
      return offlineStorageDeletedEntityRowCount_;
    }

    public static final int ONLINE_STORAGE_DELETED_ENTITY_COUNT_FIELD_NUMBER = 2;
    private long onlineStorageDeletedEntityCount_ = 0L;
    /**
     *
     *
     * <pre>
     * The count of deleted entities in the online storage.
     * Each entity ID corresponds to one entity.
     * </pre>
     *
     * <code>int64 online_storage_deleted_entity_count = 2;</code>
     *
     * @return The onlineStorageDeletedEntityCount.
     */
    @java.lang.Override
    public long getOnlineStorageDeletedEntityCount() {
      return onlineStorageDeletedEntityCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (offlineStorageDeletedEntityRowCount_ != 0L) {
        output.writeInt64(1, offlineStorageDeletedEntityRowCount_);
      }
      if (onlineStorageDeletedEntityCount_ != 0L) {
        output.writeInt64(2, onlineStorageDeletedEntityCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (offlineStorageDeletedEntityRowCount_ != 0L) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt64Size(
                1, offlineStorageDeletedEntityRowCount_);
      }
      if (onlineStorageDeletedEntityCount_ != 0L) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt64Size(
                2, onlineStorageDeletedEntityCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity other =
          (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity) obj;

      if (getOfflineStorageDeletedEntityRowCount()
          != other.getOfflineStorageDeletedEntityRowCount()) return false;
      if (getOnlineStorageDeletedEntityCount() != other.getOnlineStorageDeletedEntityCount())
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OFFLINE_STORAGE_DELETED_ENTITY_ROW_COUNT_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(getOfflineStorageDeletedEntityRowCount());
      hash = (37 * hash) + ONLINE_STORAGE_DELETED_ENTITY_COUNT_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashLong(getOnlineStorageDeletedEntityCount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Response message if the request uses the SelectEntity option.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity)
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntityOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesResponse_SelectEntity_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesResponse_SelectEntity_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity.class,
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        offlineStorageDeletedEntityRowCount_ = 0L;
        onlineStorageDeletedEntityCount_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesResponse_SelectEntity_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity build() {
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
          buildPartial() {
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity result =
            new com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.offlineStorageDeletedEntityRowCount_ = offlineStorageDeletedEntityRowCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.onlineStorageDeletedEntityCount_ = onlineStorageDeletedEntityCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity other) {
        if (other
            == com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
                .getDefaultInstance()) return this;
        if (other.getOfflineStorageDeletedEntityRowCount() != 0L) {
          setOfflineStorageDeletedEntityRowCount(other.getOfflineStorageDeletedEntityRowCount());
        }
        if (other.getOnlineStorageDeletedEntityCount() != 0L) {
          setOnlineStorageDeletedEntityCount(other.getOnlineStorageDeletedEntityCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  offlineStorageDeletedEntityRowCount_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  onlineStorageDeletedEntityCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long offlineStorageDeletedEntityRowCount_;
      /**
       *
       *
       * <pre>
       * The count of deleted entity rows in the offline storage.
       * Each row corresponds to the combination of an entity ID and a timestamp.
       * One entity ID can have multiple rows in the offline storage.
       * </pre>
       *
       * <code>int64 offline_storage_deleted_entity_row_count = 1;</code>
       *
       * @return The offlineStorageDeletedEntityRowCount.
       */
      @java.lang.Override
      public long getOfflineStorageDeletedEntityRowCount() {
        return offlineStorageDeletedEntityRowCount_;
      }
      /**
       *
       *
       * <pre>
       * The count of deleted entity rows in the offline storage.
       * Each row corresponds to the combination of an entity ID and a timestamp.
       * One entity ID can have multiple rows in the offline storage.
       * </pre>
       *
       * <code>int64 offline_storage_deleted_entity_row_count = 1;</code>
       *
       * @param value The offlineStorageDeletedEntityRowCount to set.
       * @return This builder for chaining.
       */
      public Builder setOfflineStorageDeletedEntityRowCount(long value) {

        offlineStorageDeletedEntityRowCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The count of deleted entity rows in the offline storage.
       * Each row corresponds to the combination of an entity ID and a timestamp.
       * One entity ID can have multiple rows in the offline storage.
       * </pre>
       *
       * <code>int64 offline_storage_deleted_entity_row_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOfflineStorageDeletedEntityRowCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        offlineStorageDeletedEntityRowCount_ = 0L;
        onChanged();
        return this;
      }

      private long onlineStorageDeletedEntityCount_;
      /**
       *
       *
       * <pre>
       * The count of deleted entities in the online storage.
       * Each entity ID corresponds to one entity.
       * </pre>
       *
       * <code>int64 online_storage_deleted_entity_count = 2;</code>
       *
       * @return The onlineStorageDeletedEntityCount.
       */
      @java.lang.Override
      public long getOnlineStorageDeletedEntityCount() {
        return onlineStorageDeletedEntityCount_;
      }
      /**
       *
       *
       * <pre>
       * The count of deleted entities in the online storage.
       * Each entity ID corresponds to one entity.
       * </pre>
       *
       * <code>int64 online_storage_deleted_entity_count = 2;</code>
       *
       * @param value The onlineStorageDeletedEntityCount to set.
       * @return This builder for chaining.
       */
      public Builder setOnlineStorageDeletedEntityCount(long value) {

        onlineStorageDeletedEntityCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The count of deleted entities in the online storage.
       * Each entity ID corresponds to one entity.
       * </pre>
       *
       * <code>int64 online_storage_deleted_entity_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOnlineStorageDeletedEntityCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        onlineStorageDeletedEntityCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity)
    private static final com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity();
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SelectEntity> PARSER =
        new com.google.protobuf.AbstractParser<SelectEntity>() {
          @java.lang.Override
          public SelectEntity parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SelectEntity> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SelectEntity> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SelectTimeRangeAndFeatureOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The count of the features or columns impacted.
     * This is the same as the feature count in the request.
     * </pre>
     *
     * <code>int64 impacted_feature_count = 1;</code>
     *
     * @return The impactedFeatureCount.
     */
    long getImpactedFeatureCount();

    /**
     *
     *
     * <pre>
     * The count of modified entity rows in the offline storage.
     * Each row corresponds to the combination of an entity ID and a timestamp.
     * One entity ID can have multiple rows in the offline storage.
     * Within each row, only the features specified in the request are
     * deleted.
     * </pre>
     *
     * <code>int64 offline_storage_modified_entity_row_count = 2;</code>
     *
     * @return The offlineStorageModifiedEntityRowCount.
     */
    long getOfflineStorageModifiedEntityRowCount();

    /**
     *
     *
     * <pre>
     * The count of modified entities in the online storage.
     * Each entity ID corresponds to one entity.
     * Within each entity, only the features specified in the request are
     * deleted.
     * </pre>
     *
     * <code>int64 online_storage_modified_entity_count = 3;</code>
     *
     * @return The onlineStorageModifiedEntityCount.
     */
    long getOnlineStorageModifiedEntityCount();
  }
  /**
   *
   *
   * <pre>
   * Response message if the request uses the SelectTimeRangeAndFeature option.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature}
   */
  public static final class SelectTimeRangeAndFeature extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature)
      SelectTimeRangeAndFeatureOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SelectTimeRangeAndFeature.newBuilder() to construct.
    private SelectTimeRangeAndFeature(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SelectTimeRangeAndFeature() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SelectTimeRangeAndFeature();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesResponse_SelectTimeRangeAndFeature_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesResponse_SelectTimeRangeAndFeature_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
                  .class,
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
                  .Builder.class);
    }

    public static final int IMPACTED_FEATURE_COUNT_FIELD_NUMBER = 1;
    private long impactedFeatureCount_ = 0L;
    /**
     *
     *
     * <pre>
     * The count of the features or columns impacted.
     * This is the same as the feature count in the request.
     * </pre>
     *
     * <code>int64 impacted_feature_count = 1;</code>
     *
     * @return The impactedFeatureCount.
     */
    @java.lang.Override
    public long getImpactedFeatureCount() {
      return impactedFeatureCount_;
    }

    public static final int OFFLINE_STORAGE_MODIFIED_ENTITY_ROW_COUNT_FIELD_NUMBER = 2;
    private long offlineStorageModifiedEntityRowCount_ = 0L;
    /**
     *
     *
     * <pre>
     * The count of modified entity rows in the offline storage.
     * Each row corresponds to the combination of an entity ID and a timestamp.
     * One entity ID can have multiple rows in the offline storage.
     * Within each row, only the features specified in the request are
     * deleted.
     * </pre>
     *
     * <code>int64 offline_storage_modified_entity_row_count = 2;</code>
     *
     * @return The offlineStorageModifiedEntityRowCount.
     */
    @java.lang.Override
    public long getOfflineStorageModifiedEntityRowCount() {
      return offlineStorageModifiedEntityRowCount_;
    }

    public static final int ONLINE_STORAGE_MODIFIED_ENTITY_COUNT_FIELD_NUMBER = 3;
    private long onlineStorageModifiedEntityCount_ = 0L;
    /**
     *
     *
     * <pre>
     * The count of modified entities in the online storage.
     * Each entity ID corresponds to one entity.
     * Within each entity, only the features specified in the request are
     * deleted.
     * </pre>
     *
     * <code>int64 online_storage_modified_entity_count = 3;</code>
     *
     * @return The onlineStorageModifiedEntityCount.
     */
    @java.lang.Override
    public long getOnlineStorageModifiedEntityCount() {
      return onlineStorageModifiedEntityCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (impactedFeatureCount_ != 0L) {
        output.writeInt64(1, impactedFeatureCount_);
      }
      if (offlineStorageModifiedEntityRowCount_ != 0L) {
        output.writeInt64(2, offlineStorageModifiedEntityRowCount_);
      }
      if (onlineStorageModifiedEntityCount_ != 0L) {
        output.writeInt64(3, onlineStorageModifiedEntityCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (impactedFeatureCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, impactedFeatureCount_);
      }
      if (offlineStorageModifiedEntityRowCount_ != 0L) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt64Size(
                2, offlineStorageModifiedEntityRowCount_);
      }
      if (onlineStorageModifiedEntityCount_ != 0L) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt64Size(
                3, onlineStorageModifiedEntityCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature other =
          (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature)
              obj;

      if (getImpactedFeatureCount() != other.getImpactedFeatureCount()) return false;
      if (getOfflineStorageModifiedEntityRowCount()
          != other.getOfflineStorageModifiedEntityRowCount()) return false;
      if (getOnlineStorageModifiedEntityCount() != other.getOnlineStorageModifiedEntityCount())
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + IMPACTED_FEATURE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getImpactedFeatureCount());
      hash = (37 * hash) + OFFLINE_STORAGE_MODIFIED_ENTITY_ROW_COUNT_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(getOfflineStorageModifiedEntityRowCount());
      hash = (37 * hash) + ONLINE_STORAGE_MODIFIED_ENTITY_COUNT_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(getOnlineStorageModifiedEntityCount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeature
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeature
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeature
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeature
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeature
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeature
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeature
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeature
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeature
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeature
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeature
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeature
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Response message if the request uses the SelectTimeRangeAndFeature option.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature)
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeatureOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesResponse_SelectTimeRangeAndFeature_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesResponse_SelectTimeRangeAndFeature_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
                    .class,
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        impactedFeatureCount_ = 0L;
        offlineStorageModifiedEntityRowCount_ = 0L;
        onlineStorageModifiedEntityCount_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesResponse_SelectTimeRangeAndFeature_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
          build() {
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
          buildPartial() {
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
            result =
                new com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
                    .SelectTimeRangeAndFeature(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.impactedFeatureCount_ = impactedFeatureCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.offlineStorageModifiedEntityRowCount_ = offlineStorageModifiedEntityRowCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.onlineStorageModifiedEntityCount_ = onlineStorageModifiedEntityCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
              other) {
        if (other
            == com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
                .getDefaultInstance()) return this;
        if (other.getImpactedFeatureCount() != 0L) {
          setImpactedFeatureCount(other.getImpactedFeatureCount());
        }
        if (other.getOfflineStorageModifiedEntityRowCount() != 0L) {
          setOfflineStorageModifiedEntityRowCount(other.getOfflineStorageModifiedEntityRowCount());
        }
        if (other.getOnlineStorageModifiedEntityCount() != 0L) {
          setOnlineStorageModifiedEntityCount(other.getOnlineStorageModifiedEntityCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  impactedFeatureCount_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  offlineStorageModifiedEntityRowCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  onlineStorageModifiedEntityCount_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long impactedFeatureCount_;
      /**
       *
       *
       * <pre>
       * The count of the features or columns impacted.
       * This is the same as the feature count in the request.
       * </pre>
       *
       * <code>int64 impacted_feature_count = 1;</code>
       *
       * @return The impactedFeatureCount.
       */
      @java.lang.Override
      public long getImpactedFeatureCount() {
        return impactedFeatureCount_;
      }
      /**
       *
       *
       * <pre>
       * The count of the features or columns impacted.
       * This is the same as the feature count in the request.
       * </pre>
       *
       * <code>int64 impacted_feature_count = 1;</code>
       *
       * @param value The impactedFeatureCount to set.
       * @return This builder for chaining.
       */
      public Builder setImpactedFeatureCount(long value) {

        impactedFeatureCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The count of the features or columns impacted.
       * This is the same as the feature count in the request.
       * </pre>
       *
       * <code>int64 impacted_feature_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearImpactedFeatureCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        impactedFeatureCount_ = 0L;
        onChanged();
        return this;
      }

      private long offlineStorageModifiedEntityRowCount_;
      /**
       *
       *
       * <pre>
       * The count of modified entity rows in the offline storage.
       * Each row corresponds to the combination of an entity ID and a timestamp.
       * One entity ID can have multiple rows in the offline storage.
       * Within each row, only the features specified in the request are
       * deleted.
       * </pre>
       *
       * <code>int64 offline_storage_modified_entity_row_count = 2;</code>
       *
       * @return The offlineStorageModifiedEntityRowCount.
       */
      @java.lang.Override
      public long getOfflineStorageModifiedEntityRowCount() {
        return offlineStorageModifiedEntityRowCount_;
      }
      /**
       *
       *
       * <pre>
       * The count of modified entity rows in the offline storage.
       * Each row corresponds to the combination of an entity ID and a timestamp.
       * One entity ID can have multiple rows in the offline storage.
       * Within each row, only the features specified in the request are
       * deleted.
       * </pre>
       *
       * <code>int64 offline_storage_modified_entity_row_count = 2;</code>
       *
       * @param value The offlineStorageModifiedEntityRowCount to set.
       * @return This builder for chaining.
       */
      public Builder setOfflineStorageModifiedEntityRowCount(long value) {

        offlineStorageModifiedEntityRowCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The count of modified entity rows in the offline storage.
       * Each row corresponds to the combination of an entity ID and a timestamp.
       * One entity ID can have multiple rows in the offline storage.
       * Within each row, only the features specified in the request are
       * deleted.
       * </pre>
       *
       * <code>int64 offline_storage_modified_entity_row_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOfflineStorageModifiedEntityRowCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        offlineStorageModifiedEntityRowCount_ = 0L;
        onChanged();
        return this;
      }

      private long onlineStorageModifiedEntityCount_;
      /**
       *
       *
       * <pre>
       * The count of modified entities in the online storage.
       * Each entity ID corresponds to one entity.
       * Within each entity, only the features specified in the request are
       * deleted.
       * </pre>
       *
       * <code>int64 online_storage_modified_entity_count = 3;</code>
       *
       * @return The onlineStorageModifiedEntityCount.
       */
      @java.lang.Override
      public long getOnlineStorageModifiedEntityCount() {
        return onlineStorageModifiedEntityCount_;
      }
      /**
       *
       *
       * <pre>
       * The count of modified entities in the online storage.
       * Each entity ID corresponds to one entity.
       * Within each entity, only the features specified in the request are
       * deleted.
       * </pre>
       *
       * <code>int64 online_storage_modified_entity_count = 3;</code>
       *
       * @param value The onlineStorageModifiedEntityCount to set.
       * @return This builder for chaining.
       */
      public Builder setOnlineStorageModifiedEntityCount(long value) {

        onlineStorageModifiedEntityCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The count of modified entities in the online storage.
       * Each entity ID corresponds to one entity.
       * Within each entity, only the features specified in the request are
       * deleted.
       * </pre>
       *
       * <code>int64 online_storage_modified_entity_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOnlineStorageModifiedEntityCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        onlineStorageModifiedEntityCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature)
    private static final com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeature
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
              .SelectTimeRangeAndFeature();
    }

    public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeature
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SelectTimeRangeAndFeature> PARSER =
        new com.google.protobuf.AbstractParser<SelectTimeRangeAndFeature>() {
          @java.lang.Override
          public SelectTimeRangeAndFeature parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SelectTimeRangeAndFeature> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SelectTimeRangeAndFeature> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int responseCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object response_;

  public enum ResponseCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SELECT_ENTITY(1),
    SELECT_TIME_RANGE_AND_FEATURE(2),
    RESPONSE_NOT_SET(0);
    private final int value;

    private ResponseCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResponseCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResponseCase forNumber(int value) {
      switch (value) {
        case 1:
          return SELECT_ENTITY;
        case 2:
          return SELECT_TIME_RANGE_AND_FEATURE;
        case 0:
          return RESPONSE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResponseCase getResponseCase() {
    return ResponseCase.forNumber(responseCase_);
  }

  public static final int SELECT_ENTITY_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Response for request specifying the entities to delete
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity select_entity = 1;
   * </code>
   *
   * @return Whether the selectEntity field is set.
   */
  @java.lang.Override
  public boolean hasSelectEntity() {
    return responseCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Response for request specifying the entities to delete
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity select_entity = 1;
   * </code>
   *
   * @return The selectEntity.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity getSelectEntity() {
    if (responseCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity) response_;
    }
    return com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Response for request specifying the entities to delete
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity select_entity = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntityOrBuilder
      getSelectEntityOrBuilder() {
    if (responseCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity) response_;
    }
    return com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
        .getDefaultInstance();
  }

  public static final int SELECT_TIME_RANGE_AND_FEATURE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Response for request specifying time range and feature
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature select_time_range_and_feature = 2;
   * </code>
   *
   * @return Whether the selectTimeRangeAndFeature field is set.
   */
  @java.lang.Override
  public boolean hasSelectTimeRangeAndFeature() {
    return responseCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Response for request specifying time range and feature
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature select_time_range_and_feature = 2;
   * </code>
   *
   * @return The selectTimeRangeAndFeature.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
      getSelectTimeRangeAndFeature() {
    if (responseCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature)
          response_;
    }
    return com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Response for request specifying time range and feature
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature select_time_range_and_feature = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
          .SelectTimeRangeAndFeatureOrBuilder
      getSelectTimeRangeAndFeatureOrBuilder() {
    if (responseCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature)
          response_;
    }
    return com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (responseCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity) response_);
    }
    if (responseCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature)
              response_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (responseCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity) response_);
    }
    if (responseCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature)
                  response_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse other =
        (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse) obj;

    if (!getResponseCase().equals(other.getResponseCase())) return false;
    switch (responseCase_) {
      case 1:
        if (!getSelectEntity().equals(other.getSelectEntity())) return false;
        break;
      case 2:
        if (!getSelectTimeRangeAndFeature().equals(other.getSelectTimeRangeAndFeature()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (responseCase_) {
      case 1:
        hash = (37 * hash) + SELECT_ENTITY_FIELD_NUMBER;
        hash = (53 * hash) + getSelectEntity().hashCode();
        break;
      case 2:
        hash = (37 * hash) + SELECT_TIME_RANGE_AND_FEATURE_FIELD_NUMBER;
        hash = (53 * hash) + getSelectTimeRangeAndFeature().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [FeaturestoreService.DeleteFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.DeleteFeatureValues].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.DeleteFeatureValuesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.DeleteFeatureValuesResponse)
      com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.class,
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (selectEntityBuilder_ != null) {
        selectEntityBuilder_.clear();
      }
      if (selectTimeRangeAndFeatureBuilder_ != null) {
        selectTimeRangeAndFeatureBuilder_.clear();
      }
      responseCase_ = 0;
      response_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.FeaturestoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_DeleteFeatureValuesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse build() {
      com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse buildPartial() {
      com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse result =
          new com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse result) {
      result.responseCase_ = responseCase_;
      result.response_ = this.response_;
      if (responseCase_ == 1 && selectEntityBuilder_ != null) {
        result.response_ = selectEntityBuilder_.build();
      }
      if (responseCase_ == 2 && selectTimeRangeAndFeatureBuilder_ != null) {
        result.response_ = selectTimeRangeAndFeatureBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse) {
        return mergeFrom((com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse other) {
      if (other == com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.getDefaultInstance())
        return this;
      switch (other.getResponseCase()) {
        case SELECT_ENTITY:
          {
            mergeSelectEntity(other.getSelectEntity());
            break;
          }
        case SELECT_TIME_RANGE_AND_FEATURE:
          {
            mergeSelectTimeRangeAndFeature(other.getSelectTimeRangeAndFeature());
            break;
          }
        case RESPONSE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getSelectEntityFieldBuilder().getBuilder(), extensionRegistry);
                responseCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getSelectTimeRangeAndFeatureFieldBuilder().getBuilder(), extensionRegistry);
                responseCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int responseCase_ = 0;
    private java.lang.Object response_;

    public ResponseCase getResponseCase() {
      return ResponseCase.forNumber(responseCase_);
    }

    public Builder clearResponse() {
      responseCase_ = 0;
      response_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity.Builder,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntityOrBuilder>
        selectEntityBuilder_;
    /**
     *
     *
     * <pre>
     * Response for request specifying the entities to delete
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity select_entity = 1;
     * </code>
     *
     * @return Whether the selectEntity field is set.
     */
    @java.lang.Override
    public boolean hasSelectEntity() {
      return responseCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying the entities to delete
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity select_entity = 1;
     * </code>
     *
     * @return The selectEntity.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
        getSelectEntity() {
      if (selectEntityBuilder_ == null) {
        if (responseCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity)
              response_;
        }
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
            .getDefaultInstance();
      } else {
        if (responseCase_ == 1) {
          return selectEntityBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying the entities to delete
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity select_entity = 1;
     * </code>
     */
    public Builder setSelectEntity(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity value) {
      if (selectEntityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        response_ = value;
        onChanged();
      } else {
        selectEntityBuilder_.setMessage(value);
      }
      responseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying the entities to delete
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity select_entity = 1;
     * </code>
     */
    public Builder setSelectEntity(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity.Builder
            builderForValue) {
      if (selectEntityBuilder_ == null) {
        response_ = builderForValue.build();
        onChanged();
      } else {
        selectEntityBuilder_.setMessage(builderForValue.build());
      }
      responseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying the entities to delete
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity select_entity = 1;
     * </code>
     */
    public Builder mergeSelectEntity(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity value) {
      if (selectEntityBuilder_ == null) {
        if (responseCase_ == 1
            && response_
                != com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
                    .getDefaultInstance()) {
          response_ =
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity.newBuilder(
                      (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity)
                          response_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          response_ = value;
        }
        onChanged();
      } else {
        if (responseCase_ == 1) {
          selectEntityBuilder_.mergeFrom(value);
        } else {
          selectEntityBuilder_.setMessage(value);
        }
      }
      responseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying the entities to delete
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity select_entity = 1;
     * </code>
     */
    public Builder clearSelectEntity() {
      if (selectEntityBuilder_ == null) {
        if (responseCase_ == 1) {
          responseCase_ = 0;
          response_ = null;
          onChanged();
        }
      } else {
        if (responseCase_ == 1) {
          responseCase_ = 0;
          response_ = null;
        }
        selectEntityBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying the entities to delete
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity select_entity = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity.Builder
        getSelectEntityBuilder() {
      return getSelectEntityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying the entities to delete
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity select_entity = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntityOrBuilder
        getSelectEntityOrBuilder() {
      if ((responseCase_ == 1) && (selectEntityBuilder_ != null)) {
        return selectEntityBuilder_.getMessageOrBuilder();
      } else {
        if (responseCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity)
              response_;
        }
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying the entities to delete
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity select_entity = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity.Builder,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntityOrBuilder>
        getSelectEntityFieldBuilder() {
      if (selectEntityBuilder_ == null) {
        if (!(responseCase_ == 1)) {
          response_ =
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
                  .getDefaultInstance();
        }
        selectEntityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity,
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity.Builder,
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntityOrBuilder>(
                (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity) response_,
                getParentForChildren(),
                isClean());
        response_ = null;
      }
      responseCase_ = 1;
      onChanged();
      return selectEntityBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
                .Builder,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
                .SelectTimeRangeAndFeatureOrBuilder>
        selectTimeRangeAndFeatureBuilder_;
    /**
     *
     *
     * <pre>
     * Response for request specifying time range and feature
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature select_time_range_and_feature = 2;
     * </code>
     *
     * @return Whether the selectTimeRangeAndFeature field is set.
     */
    @java.lang.Override
    public boolean hasSelectTimeRangeAndFeature() {
      return responseCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying time range and feature
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature select_time_range_and_feature = 2;
     * </code>
     *
     * @return The selectTimeRangeAndFeature.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
        getSelectTimeRangeAndFeature() {
      if (selectTimeRangeAndFeatureBuilder_ == null) {
        if (responseCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
                  .SelectTimeRangeAndFeature)
              response_;
        }
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
            .getDefaultInstance();
      } else {
        if (responseCase_ == 2) {
          return selectTimeRangeAndFeatureBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying time range and feature
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature select_time_range_and_feature = 2;
     * </code>
     */
    public Builder setSelectTimeRangeAndFeature(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
            value) {
      if (selectTimeRangeAndFeatureBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        response_ = value;
        onChanged();
      } else {
        selectTimeRangeAndFeatureBuilder_.setMessage(value);
      }
      responseCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying time range and feature
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature select_time_range_and_feature = 2;
     * </code>
     */
    public Builder setSelectTimeRangeAndFeature(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature.Builder
            builderForValue) {
      if (selectTimeRangeAndFeatureBuilder_ == null) {
        response_ = builderForValue.build();
        onChanged();
      } else {
        selectTimeRangeAndFeatureBuilder_.setMessage(builderForValue.build());
      }
      responseCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying time range and feature
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature select_time_range_and_feature = 2;
     * </code>
     */
    public Builder mergeSelectTimeRangeAndFeature(
        com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
            value) {
      if (selectTimeRangeAndFeatureBuilder_ == null) {
        if (responseCase_ == 2
            && response_
                != com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
                    .SelectTimeRangeAndFeature.getDefaultInstance()) {
          response_ =
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
                              .SelectTimeRangeAndFeature)
                          response_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          response_ = value;
        }
        onChanged();
      } else {
        if (responseCase_ == 2) {
          selectTimeRangeAndFeatureBuilder_.mergeFrom(value);
        } else {
          selectTimeRangeAndFeatureBuilder_.setMessage(value);
        }
      }
      responseCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying time range and feature
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature select_time_range_and_feature = 2;
     * </code>
     */
    public Builder clearSelectTimeRangeAndFeature() {
      if (selectTimeRangeAndFeatureBuilder_ == null) {
        if (responseCase_ == 2) {
          responseCase_ = 0;
          response_ = null;
          onChanged();
        }
      } else {
        if (responseCase_ == 2) {
          responseCase_ = 0;
          response_ = null;
        }
        selectTimeRangeAndFeatureBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying time range and feature
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature select_time_range_and_feature = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
            .Builder
        getSelectTimeRangeAndFeatureBuilder() {
      return getSelectTimeRangeAndFeatureFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying time range and feature
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature select_time_range_and_feature = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
            .SelectTimeRangeAndFeatureOrBuilder
        getSelectTimeRangeAndFeatureOrBuilder() {
      if ((responseCase_ == 2) && (selectTimeRangeAndFeatureBuilder_ != null)) {
        return selectTimeRangeAndFeatureBuilder_.getMessageOrBuilder();
      } else {
        if (responseCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
                  .SelectTimeRangeAndFeature)
              response_;
        }
        return com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Response for request specifying time range and feature
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature select_time_range_and_feature = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
                .Builder,
            com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
                .SelectTimeRangeAndFeatureOrBuilder>
        getSelectTimeRangeAndFeatureFieldBuilder() {
      if (selectTimeRangeAndFeatureBuilder_ == null) {
        if (!(responseCase_ == 2)) {
          response_ =
              com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
                  .getDefaultInstance();
        }
        selectTimeRangeAndFeatureBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
                    .SelectTimeRangeAndFeature,
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
                    .Builder,
                com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
                    .SelectTimeRangeAndFeatureOrBuilder>(
                (com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
                        .SelectTimeRangeAndFeature)
                    response_,
                getParentForChildren(),
                isClean());
        response_ = null;
      }
      responseCase_ = 2;
      onChanged();
      return selectTimeRangeAndFeatureBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.DeleteFeatureValuesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.DeleteFeatureValuesResponse)
  private static final com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse();
  }

  public static com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeleteFeatureValuesResponse> PARSER =
      new com.google.protobuf.AbstractParser<DeleteFeatureValuesResponse>() {
        @java.lang.Override
        public DeleteFeatureValuesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeleteFeatureValuesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeleteFeatureValuesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeleteFeatureValuesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
