/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/openapi.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Schema is used to define the format of input/output data. Represents a select
 * subset of an [OpenAPI 3.0 schema
 * object](https://spec.openapis.org/oas/v3.0.3#schema). More fields may be
 * added in the future as needed.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.Schema}
 */
public final class Schema extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.Schema)
    SchemaOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Schema.newBuilder() to construct.
  private Schema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Schema() {
    type_ = 0;
    format_ = "";
    description_ = "";
    enum_ = com.google.protobuf.LazyStringArrayList.emptyList();
    required_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Schema();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.OpenApiProto
        .internal_static_google_cloud_aiplatform_v1_Schema_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetProperties();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.OpenApiProto
        .internal_static_google_cloud_aiplatform_v1_Schema_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.Schema.class,
            com.google.cloud.aiplatform.v1.Schema.Builder.class);
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The type of the data.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Type type = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The type of the data.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Type type = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Type getType() {
    com.google.cloud.aiplatform.v1.Type result =
        com.google.cloud.aiplatform.v1.Type.forNumber(type_);
    return result == null ? com.google.cloud.aiplatform.v1.Type.UNRECOGNIZED : result;
  }

  public static final int FORMAT_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object format_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The format of the data.
   * Supported formats:
   *  for NUMBER type: float, double
   *  for INTEGER type: int32, int64
   * </pre>
   *
   * <code>string format = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The format.
   */
  @java.lang.Override
  public java.lang.String getFormat() {
    java.lang.Object ref = format_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      format_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The format of the data.
   * Supported formats:
   *  for NUMBER type: float, double
   *  for INTEGER type: int32, int64
   * </pre>
   *
   * <code>string format = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for format.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFormatBytes() {
    java.lang.Object ref = format_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      format_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The description of the data.
   * </pre>
   *
   * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The description of the data.
   * </pre>
   *
   * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NULLABLE_FIELD_NUMBER = 6;
  private boolean nullable_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Indicates if the value may be null.
   * </pre>
   *
   * <code>bool nullable = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The nullable.
   */
  @java.lang.Override
  public boolean getNullable() {
    return nullable_;
  }

  public static final int ITEMS_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1.Schema items_;
  /**
   *
   *
   * <pre>
   * Optional. Schema of the elements of Type.ARRAY.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the items field is set.
   */
  @java.lang.Override
  public boolean hasItems() {
    return items_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Schema of the elements of Type.ARRAY.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The items.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Schema getItems() {
    return items_ == null ? com.google.cloud.aiplatform.v1.Schema.getDefaultInstance() : items_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Schema of the elements of Type.ARRAY.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.SchemaOrBuilder getItemsOrBuilder() {
    return items_ == null ? com.google.cloud.aiplatform.v1.Schema.getDefaultInstance() : items_;
  }

  public static final int ENUM_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList enum_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Possible values of the element of Type.STRING with enum format.
   * For example we can define an Enum Direction as :
   * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
   * </pre>
   *
   * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the enum.
   */
  public com.google.protobuf.ProtocolStringList getEnumList() {
    return enum_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Possible values of the element of Type.STRING with enum format.
   * For example we can define an Enum Direction as :
   * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
   * </pre>
   *
   * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of enum.
   */
  public int getEnumCount() {
    return enum_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Possible values of the element of Type.STRING with enum format.
   * For example we can define an Enum Direction as :
   * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
   * </pre>
   *
   * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The enum at the given index.
   */
  public java.lang.String getEnum(int index) {
    return enum_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Possible values of the element of Type.STRING with enum format.
   * For example we can define an Enum Direction as :
   * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
   * </pre>
   *
   * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the enum at the given index.
   */
  public com.google.protobuf.ByteString getEnumBytes(int index) {
    return enum_.getByteString(index);
  }

  public static final int PROPERTIES_FIELD_NUMBER = 3;

  private static final class PropertiesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.aiplatform.v1.Schema>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.aiplatform.v1.Schema>newDefaultInstance(
                    com.google.cloud.aiplatform.v1.OpenApiProto
                        .internal_static_google_cloud_aiplatform_v1_Schema_PropertiesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.cloud.aiplatform.v1.Schema.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1.Schema>
      properties_;

  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1.Schema>
      internalGetProperties() {
    if (properties_ == null) {
      return com.google.protobuf.MapField.emptyMapField(PropertiesDefaultEntryHolder.defaultEntry);
    }
    return properties_;
  }

  public int getPropertiesCount() {
    return internalGetProperties().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Properties of Type.OBJECT.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsProperties(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetProperties().getMap().containsKey(key);
  }
  /** Use {@link #getPropertiesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Schema> getProperties() {
    return getPropertiesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Properties of Type.OBJECT.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Schema> getPropertiesMap() {
    return internalGetProperties().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Properties of Type.OBJECT.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.aiplatform.v1.Schema getPropertiesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.aiplatform.v1.Schema defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Schema> map =
        internalGetProperties().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Properties of Type.OBJECT.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.aiplatform.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Schema getPropertiesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Schema> map =
        internalGetProperties().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int REQUIRED_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList required_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Required properties of Type.OBJECT.
   * </pre>
   *
   * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the required.
   */
  public com.google.protobuf.ProtocolStringList getRequiredList() {
    return required_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Required properties of Type.OBJECT.
   * </pre>
   *
   * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of required.
   */
  public int getRequiredCount() {
    return required_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Required properties of Type.OBJECT.
   * </pre>
   *
   * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The required at the given index.
   */
  public java.lang.String getRequired(int index) {
    return required_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Required properties of Type.OBJECT.
   * </pre>
   *
   * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the required at the given index.
   */
  public com.google.protobuf.ByteString getRequiredBytes(int index) {
    return required_.getByteString(index);
  }

  public static final int EXAMPLE_FIELD_NUMBER = 4;
  private com.google.protobuf.Value example_;
  /**
   *
   *
   * <pre>
   * Optional. Example of the object. Will only populated when the object is the
   * root.
   * </pre>
   *
   * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the example field is set.
   */
  @java.lang.Override
  public boolean hasExample() {
    return example_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Example of the object. Will only populated when the object is the
   * root.
   * </pre>
   *
   * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The example.
   */
  @java.lang.Override
  public com.google.protobuf.Value getExample() {
    return example_ == null ? com.google.protobuf.Value.getDefaultInstance() : example_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Example of the object. Will only populated when the object is the
   * root.
   * </pre>
   *
   * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getExampleOrBuilder() {
    return example_ == null ? com.google.protobuf.Value.getDefaultInstance() : example_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (type_ != com.google.cloud.aiplatform.v1.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, type_);
    }
    if (items_ != null) {
      output.writeMessage(2, getItems());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetProperties(), PropertiesDefaultEntryHolder.defaultEntry, 3);
    if (example_ != null) {
      output.writeMessage(4, getExample());
    }
    for (int i = 0; i < required_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, required_.getRaw(i));
    }
    if (nullable_ != false) {
      output.writeBool(6, nullable_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(format_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, format_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, description_);
    }
    for (int i = 0; i < enum_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, enum_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_ != com.google.cloud.aiplatform.v1.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
    }
    if (items_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getItems());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.aiplatform.v1.Schema> entry :
        internalGetProperties().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.aiplatform.v1.Schema>
          properties__ =
              PropertiesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, properties__);
    }
    if (example_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getExample());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < required_.size(); i++) {
        dataSize += computeStringSizeNoTag(required_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRequiredList().size();
    }
    if (nullable_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, nullable_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(format_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, format_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, description_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < enum_.size(); i++) {
        dataSize += computeStringSizeNoTag(enum_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getEnumList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.Schema)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.Schema other = (com.google.cloud.aiplatform.v1.Schema) obj;

    if (type_ != other.type_) return false;
    if (!getFormat().equals(other.getFormat())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (getNullable() != other.getNullable()) return false;
    if (hasItems() != other.hasItems()) return false;
    if (hasItems()) {
      if (!getItems().equals(other.getItems())) return false;
    }
    if (!getEnumList().equals(other.getEnumList())) return false;
    if (!internalGetProperties().equals(other.internalGetProperties())) return false;
    if (!getRequiredList().equals(other.getRequiredList())) return false;
    if (hasExample() != other.hasExample()) return false;
    if (hasExample()) {
      if (!getExample().equals(other.getExample())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + getFormat().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + NULLABLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getNullable());
    if (hasItems()) {
      hash = (37 * hash) + ITEMS_FIELD_NUMBER;
      hash = (53 * hash) + getItems().hashCode();
    }
    if (getEnumCount() > 0) {
      hash = (37 * hash) + ENUM_FIELD_NUMBER;
      hash = (53 * hash) + getEnumList().hashCode();
    }
    if (!internalGetProperties().getMap().isEmpty()) {
      hash = (37 * hash) + PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetProperties().hashCode();
    }
    if (getRequiredCount() > 0) {
      hash = (37 * hash) + REQUIRED_FIELD_NUMBER;
      hash = (53 * hash) + getRequiredList().hashCode();
    }
    if (hasExample()) {
      hash = (37 * hash) + EXAMPLE_FIELD_NUMBER;
      hash = (53 * hash) + getExample().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.Schema parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Schema parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Schema parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Schema parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Schema parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.Schema parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Schema parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Schema parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Schema parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Schema parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.Schema parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.Schema parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.Schema prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Schema is used to define the format of input/output data. Represents a select
   * subset of an [OpenAPI 3.0 schema
   * object](https://spec.openapis.org/oas/v3.0.3#schema). More fields may be
   * added in the future as needed.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.Schema}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.Schema)
      com.google.cloud.aiplatform.v1.SchemaOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.OpenApiProto
          .internal_static_google_cloud_aiplatform_v1_Schema_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.OpenApiProto
          .internal_static_google_cloud_aiplatform_v1_Schema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.Schema.class,
              com.google.cloud.aiplatform.v1.Schema.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.Schema.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = 0;
      format_ = "";
      description_ = "";
      nullable_ = false;
      items_ = null;
      if (itemsBuilder_ != null) {
        itemsBuilder_.dispose();
        itemsBuilder_ = null;
      }
      enum_ = com.google.protobuf.LazyStringArrayList.emptyList();
      internalGetMutableProperties().clear();
      required_ = com.google.protobuf.LazyStringArrayList.emptyList();
      example_ = null;
      if (exampleBuilder_ != null) {
        exampleBuilder_.dispose();
        exampleBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.OpenApiProto
          .internal_static_google_cloud_aiplatform_v1_Schema_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Schema getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.Schema.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Schema build() {
      com.google.cloud.aiplatform.v1.Schema result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Schema buildPartial() {
      com.google.cloud.aiplatform.v1.Schema result =
          new com.google.cloud.aiplatform.v1.Schema(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.Schema result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.format_ = format_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.nullable_ = nullable_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.items_ = itemsBuilder_ == null ? items_ : itemsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        enum_.makeImmutable();
        result.enum_ = enum_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.properties_ = internalGetProperties();
        result.properties_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        required_.makeImmutable();
        result.required_ = required_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.example_ = exampleBuilder_ == null ? example_ : exampleBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.Schema) {
        return mergeFrom((com.google.cloud.aiplatform.v1.Schema) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.Schema other) {
      if (other == com.google.cloud.aiplatform.v1.Schema.getDefaultInstance()) return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.getFormat().isEmpty()) {
        format_ = other.format_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getNullable() != false) {
        setNullable(other.getNullable());
      }
      if (other.hasItems()) {
        mergeItems(other.getItems());
      }
      if (!other.enum_.isEmpty()) {
        if (enum_.isEmpty()) {
          enum_ = other.enum_;
          bitField0_ |= 0x00000020;
        } else {
          ensureEnumIsMutable();
          enum_.addAll(other.enum_);
        }
        onChanged();
      }
      internalGetMutableProperties().mergeFrom(other.internalGetProperties());
      bitField0_ |= 0x00000040;
      if (!other.required_.isEmpty()) {
        if (required_.isEmpty()) {
          required_ = other.required_;
          bitField0_ |= 0x00000080;
        } else {
          ensureRequiredIsMutable();
          required_.addAll(other.required_);
        }
        onChanged();
      }
      if (other.hasExample()) {
        mergeExample(other.getExample());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(getItemsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.aiplatform.v1.Schema>
                    properties__ =
                        input.readMessage(
                            PropertiesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableProperties()
                    .getMutableMap()
                    .put(properties__.getKey(), properties__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getExampleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRequiredIsMutable();
                required_.add(s);
                break;
              } // case 42
            case 48:
              {
                nullable_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 48
            case 58:
              {
                format_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 58
            case 66:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 66
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureEnumIsMutable();
                enum_.add(s);
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The type of the data.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Type type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of the data.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Type type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of the data.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Type type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Type getType() {
      com.google.cloud.aiplatform.v1.Type result =
          com.google.cloud.aiplatform.v1.Type.forNumber(type_);
      return result == null ? com.google.cloud.aiplatform.v1.Type.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of the data.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Type type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.aiplatform.v1.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of the data.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Type type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object format_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The format of the data.
     * Supported formats:
     *  for NUMBER type: float, double
     *  for INTEGER type: int32, int64
     * </pre>
     *
     * <code>string format = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The format.
     */
    public java.lang.String getFormat() {
      java.lang.Object ref = format_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        format_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The format of the data.
     * Supported formats:
     *  for NUMBER type: float, double
     *  for INTEGER type: int32, int64
     * </pre>
     *
     * <code>string format = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for format.
     */
    public com.google.protobuf.ByteString getFormatBytes() {
      java.lang.Object ref = format_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        format_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The format of the data.
     * Supported formats:
     *  for NUMBER type: float, double
     *  for INTEGER type: int32, int64
     * </pre>
     *
     * <code>string format = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The format to set.
     * @return This builder for chaining.
     */
    public Builder setFormat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      format_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The format of the data.
     * Supported formats:
     *  for NUMBER type: float, double
     *  for INTEGER type: int32, int64
     * </pre>
     *
     * <code>string format = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFormat() {
      format_ = getDefaultInstance().getFormat();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The format of the data.
     * Supported formats:
     *  for NUMBER type: float, double
     *  for INTEGER type: int32, int64
     * </pre>
     *
     * <code>string format = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for format to set.
     * @return This builder for chaining.
     */
    public Builder setFormatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      format_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The description of the data.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the data.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the data.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the data.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the data.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean nullable_;
    /**
     *
     *
     * <pre>
     * Optional. Indicates if the value may be null.
     * </pre>
     *
     * <code>bool nullable = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The nullable.
     */
    @java.lang.Override
    public boolean getNullable() {
      return nullable_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates if the value may be null.
     * </pre>
     *
     * <code>bool nullable = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The nullable to set.
     * @return This builder for chaining.
     */
    public Builder setNullable(boolean value) {

      nullable_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates if the value may be null.
     * </pre>
     *
     * <code>bool nullable = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNullable() {
      bitField0_ = (bitField0_ & ~0x00000008);
      nullable_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.Schema items_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Schema,
            com.google.cloud.aiplatform.v1.Schema.Builder,
            com.google.cloud.aiplatform.v1.SchemaOrBuilder>
        itemsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the items field is set.
     */
    public boolean hasItems() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The items.
     */
    public com.google.cloud.aiplatform.v1.Schema getItems() {
      if (itemsBuilder_ == null) {
        return items_ == null ? com.google.cloud.aiplatform.v1.Schema.getDefaultInstance() : items_;
      } else {
        return itemsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setItems(com.google.cloud.aiplatform.v1.Schema value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        items_ = value;
      } else {
        itemsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setItems(com.google.cloud.aiplatform.v1.Schema.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        items_ = builderForValue.build();
      } else {
        itemsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeItems(com.google.cloud.aiplatform.v1.Schema value) {
      if (itemsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && items_ != null
            && items_ != com.google.cloud.aiplatform.v1.Schema.getDefaultInstance()) {
          getItemsBuilder().mergeFrom(value);
        } else {
          items_ = value;
        }
      } else {
        itemsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearItems() {
      bitField0_ = (bitField0_ & ~0x00000010);
      items_ = null;
      if (itemsBuilder_ != null) {
        itemsBuilder_.dispose();
        itemsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.Schema.Builder getItemsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getItemsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.SchemaOrBuilder getItemsOrBuilder() {
      if (itemsBuilder_ != null) {
        return itemsBuilder_.getMessageOrBuilder();
      } else {
        return items_ == null ? com.google.cloud.aiplatform.v1.Schema.getDefaultInstance() : items_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.Schema,
            com.google.cloud.aiplatform.v1.Schema.Builder,
            com.google.cloud.aiplatform.v1.SchemaOrBuilder>
        getItemsFieldBuilder() {
      if (itemsBuilder_ == null) {
        itemsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.Schema,
                com.google.cloud.aiplatform.v1.Schema.Builder,
                com.google.cloud.aiplatform.v1.SchemaOrBuilder>(
                getItems(), getParentForChildren(), isClean());
        items_ = null;
      }
      return itemsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList enum_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureEnumIsMutable() {
      if (!enum_.isModifiable()) {
        enum_ = new com.google.protobuf.LazyStringArrayList(enum_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of Type.STRING with enum format.
     * For example we can define an Enum Direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the enum.
     */
    public com.google.protobuf.ProtocolStringList getEnumList() {
      enum_.makeImmutable();
      return enum_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of Type.STRING with enum format.
     * For example we can define an Enum Direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of enum.
     */
    public int getEnumCount() {
      return enum_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of Type.STRING with enum format.
     * For example we can define an Enum Direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The enum at the given index.
     */
    public java.lang.String getEnum(int index) {
      return enum_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of Type.STRING with enum format.
     * For example we can define an Enum Direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the enum at the given index.
     */
    public com.google.protobuf.ByteString getEnumBytes(int index) {
      return enum_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of Type.STRING with enum format.
     * For example we can define an Enum Direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The enum to set.
     * @return This builder for chaining.
     */
    public Builder setEnum(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnumIsMutable();
      enum_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of Type.STRING with enum format.
     * For example we can define an Enum Direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enum to add.
     * @return This builder for chaining.
     */
    public Builder addEnum(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnumIsMutable();
      enum_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of Type.STRING with enum format.
     * For example we can define an Enum Direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The enum to add.
     * @return This builder for chaining.
     */
    public Builder addAllEnum(java.lang.Iterable<java.lang.String> values) {
      ensureEnumIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, enum_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of Type.STRING with enum format.
     * For example we can define an Enum Direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnum() {
      enum_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of Type.STRING with enum format.
     * For example we can define an Enum Direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the enum to add.
     * @return This builder for chaining.
     */
    public Builder addEnumBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureEnumIsMutable();
      enum_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1.Schema>
        properties_;

    private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1.Schema>
        internalGetProperties() {
      if (properties_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PropertiesDefaultEntryHolder.defaultEntry);
      }
      return properties_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.cloud.aiplatform.v1.Schema>
        internalGetMutableProperties() {
      if (properties_ == null) {
        properties_ =
            com.google.protobuf.MapField.newMapField(PropertiesDefaultEntryHolder.defaultEntry);
      }
      if (!properties_.isMutable()) {
        properties_ = properties_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return properties_;
    }

    public int getPropertiesCount() {
      return internalGetProperties().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Properties of Type.OBJECT.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetProperties().getMap().containsKey(key);
    }
    /** Use {@link #getPropertiesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Schema> getProperties() {
      return getPropertiesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Properties of Type.OBJECT.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Schema>
        getPropertiesMap() {
      return internalGetProperties().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Properties of Type.OBJECT.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.aiplatform.v1.Schema getPropertiesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.aiplatform.v1.Schema defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Schema> map =
          internalGetProperties().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Properties of Type.OBJECT.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Schema getPropertiesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Schema> map =
          internalGetProperties().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearProperties() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableProperties().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Properties of Type.OBJECT.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableProperties().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Schema>
        getMutableProperties() {
      bitField0_ |= 0x00000040;
      return internalGetMutableProperties().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Properties of Type.OBJECT.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putProperties(
        java.lang.String key, com.google.cloud.aiplatform.v1.Schema value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableProperties().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Properties of Type.OBJECT.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.aiplatform.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllProperties(
        java.util.Map<java.lang.String, com.google.cloud.aiplatform.v1.Schema> values) {
      internalGetMutableProperties().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private com.google.protobuf.LazyStringArrayList required_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRequiredIsMutable() {
      if (!required_.isModifiable()) {
        required_ = new com.google.protobuf.LazyStringArrayList(required_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the required.
     */
    public com.google.protobuf.ProtocolStringList getRequiredList() {
      required_.makeImmutable();
      return required_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of required.
     */
    public int getRequiredCount() {
      return required_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The required at the given index.
     */
    public java.lang.String getRequired(int index) {
      return required_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the required at the given index.
     */
    public com.google.protobuf.ByteString getRequiredBytes(int index) {
      return required_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The required to set.
     * @return This builder for chaining.
     */
    public Builder setRequired(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequiredIsMutable();
      required_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The required to add.
     * @return This builder for chaining.
     */
    public Builder addRequired(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequiredIsMutable();
      required_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The required to add.
     * @return This builder for chaining.
     */
    public Builder addAllRequired(java.lang.Iterable<java.lang.String> values) {
      ensureRequiredIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, required_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequired() {
      required_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the required to add.
     * @return This builder for chaining.
     */
    public Builder addRequiredBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRequiredIsMutable();
      required_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value example_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        exampleBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the example field is set.
     */
    public boolean hasExample() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The example.
     */
    public com.google.protobuf.Value getExample() {
      if (exampleBuilder_ == null) {
        return example_ == null ? com.google.protobuf.Value.getDefaultInstance() : example_;
      } else {
        return exampleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setExample(com.google.protobuf.Value value) {
      if (exampleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        example_ = value;
      } else {
        exampleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setExample(com.google.protobuf.Value.Builder builderForValue) {
      if (exampleBuilder_ == null) {
        example_ = builderForValue.build();
      } else {
        exampleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder mergeExample(com.google.protobuf.Value value) {
      if (exampleBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && example_ != null
            && example_ != com.google.protobuf.Value.getDefaultInstance()) {
          getExampleBuilder().mergeFrom(value);
        } else {
          example_ = value;
        }
      } else {
        exampleBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder clearExample() {
      bitField0_ = (bitField0_ & ~0x00000100);
      example_ = null;
      if (exampleBuilder_ != null) {
        exampleBuilder_.dispose();
        exampleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.protobuf.Value.Builder getExampleBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getExampleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.protobuf.ValueOrBuilder getExampleOrBuilder() {
      if (exampleBuilder_ != null) {
        return exampleBuilder_.getMessageOrBuilder();
      } else {
        return example_ == null ? com.google.protobuf.Value.getDefaultInstance() : example_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getExampleFieldBuilder() {
      if (exampleBuilder_ == null) {
        exampleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getExample(), getParentForChildren(), isClean());
        example_ = null;
      }
      return exampleBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.Schema)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.Schema)
  private static final com.google.cloud.aiplatform.v1.Schema DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.Schema();
  }

  public static com.google.cloud.aiplatform.v1.Schema getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Schema> PARSER =
      new com.google.protobuf.AbstractParser<Schema>() {
        @java.lang.Override
        public Schema parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Schema> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Schema> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Schema getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
