/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.web;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.LlmAgent;
import com.google.adk.tools.AgentTool;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.FunctionTool;
import com.google.adk.tools.retrieval.BaseRetrievalTool;
import guru.nidi.graphviz.attribute.Arrow;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.Rank;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.attribute.Style;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentGraphGenerator {
    private static final Logger log = LoggerFactory.getLogger(AgentGraphGenerator.class);
    private static final Color DARK_GREEN = Color.rgb((String)"#0F5223");
    private static final Color LIGHT_GREEN = Color.rgb((String)"#69CB87");
    private static final Color LIGHT_GRAY = Color.rgb((String)"#CCCCCC");
    private static final Color BG_COLOR = Color.rgb((String)"#333537");

    public static Optional<String> getAgentGraphDotSource(BaseAgent rootAgent, List<List<String>> highlightPairs) {
        log.debug("Building agent graph with root: {}, highlights: {}", (Object)rootAgent.name(), highlightPairs);
        try {
            MutableGraph graph = (MutableGraph)Factory.mutGraph((String)"AgentGraph").setDirected(true).graphAttrs().add((Attributes)Rank.dir((Rank.RankDir)Rank.RankDir.LEFT_TO_RIGHT), (Attributes)BG_COLOR.background());
            HashSet<String> visitedNodes = new HashSet<String>();
            AgentGraphGenerator.buildGraphRecursive(graph, rootAgent, highlightPairs, visitedNodes);
            String dotSource = Graphviz.fromGraph((MutableGraph)graph).render(Format.DOT).toString();
            log.debug("Generated DOT source successfully.");
            return Optional.of(dotSource);
        }
        catch (Exception e) {
            log.error("Error generating agent graph DOT source", (Throwable)e);
            return Optional.empty();
        }
    }

    private static void buildGraphRecursive(MutableGraph graph, BaseAgent agent, List<List<String>> highlightPairs, Set<String> visitedNodes) {
        LlmAgent llmAgent;
        List tools;
        if (agent == null || visitedNodes.contains(AgentGraphGenerator.getNodeName(agent))) {
            return;
        }
        AgentGraphGenerator.drawNode(graph, agent, highlightPairs, visitedNodes);
        if (agent.subAgents() != null) {
            for (BaseAgent subAgent : agent.subAgents()) {
                if (subAgent == null) continue;
                AgentGraphGenerator.drawEdge(graph, AgentGraphGenerator.getNodeName(agent), AgentGraphGenerator.getNodeName(subAgent), highlightPairs);
                AgentGraphGenerator.buildGraphRecursive(graph, subAgent, highlightPairs, visitedNodes);
            }
        }
        if (agent instanceof LlmAgent && (tools = (llmAgent = (LlmAgent)agent).tools()) != null) {
            for (BaseTool tool : tools) {
                if (tool == null) continue;
                AgentGraphGenerator.drawNode(graph, tool, highlightPairs, visitedNodes);
                AgentGraphGenerator.drawEdge(graph, AgentGraphGenerator.getNodeName(agent), AgentGraphGenerator.getNodeName(tool), highlightPairs);
            }
        }
    }

    private static void drawNode(MutableGraph graph, Object toolOrAgent, List<List<String>> highlightPairs, Set<String> visitedNodes) {
        String name = AgentGraphGenerator.getNodeName(toolOrAgent);
        if (name == null || name.isEmpty() || visitedNodes.contains(name)) {
            return;
        }
        Shape shape = AgentGraphGenerator.getNodeShape(toolOrAgent);
        String caption = AgentGraphGenerator.getNodeCaption(toolOrAgent);
        boolean isHighlighted = AgentGraphGenerator.isNodeHighlighted(name, highlightPairs);
        MutableNode node = Factory.mutNode((String)name).add((Attributes)Label.of((String)caption)).add((Attributes)shape).add((Attributes)LIGHT_GRAY.font());
        if (isHighlighted) {
            node.add((Attributes)Style.FILLED);
            node.add((Attributes)DARK_GREEN);
        } else {
            node.add((Attributes)Style.ROUNDED);
            node.add((Attributes)LIGHT_GRAY);
        }
        graph.add((LinkSource)node);
        visitedNodes.add(name);
        log.trace("Added node: name={}, caption={}, shape={}, highlighted={}", new Object[]{name, caption, shape, isHighlighted});
    }

    private static void drawEdge(MutableGraph graph, String fromName, String toName, List<List<String>> highlightPairs) {
        if (fromName == null || fromName.isEmpty() || toName == null || toName.isEmpty()) {
            log.warn("Skipping edge draw due to null or empty name: from='{}', to='{}'", (Object)fromName, (Object)toName);
            return;
        }
        Optional<Boolean> highlightForward = AgentGraphGenerator.isEdgeHighlighted(fromName, toName, highlightPairs);
        Link link = Factory.to((LinkTarget)Factory.mutNode((String)toName));
        if (highlightForward.isPresent()) {
            link = link.with((Attributes)LIGHT_GREEN);
            link = !highlightForward.get().booleanValue() ? link.with(Arrow.NORMAL.dir(Arrow.DirType.BACK)) : link.with((Attributes)Arrow.NORMAL);
        } else {
            link = (Link)link.with((Attributes)LIGHT_GRAY, (Attributes)Arrow.NONE);
        }
        graph.add((LinkSource)Factory.mutNode((String)fromName).addLink((LinkTarget)link));
        log.trace("Added edge: from={}, to={}, highlighted={}", new Object[]{fromName, toName, highlightForward.isPresent()});
    }

    private static String getNodeName(Object toolOrAgent) {
        if (toolOrAgent instanceof BaseAgent) {
            return ((BaseAgent)toolOrAgent).name();
        }
        if (toolOrAgent instanceof BaseTool) {
            return ((BaseTool)toolOrAgent).name();
        }
        log.warn("Unsupported type for getNodeName: {}", (Object)toolOrAgent.getClass().getName());
        return "unknown_" + toolOrAgent.hashCode();
    }

    private static String getNodeCaption(Object toolOrAgent) {
        String name = AgentGraphGenerator.getNodeName(toolOrAgent);
        if (toolOrAgent instanceof BaseAgent) {
            return "\ud83e\udd16 " + name;
        }
        if (toolOrAgent instanceof BaseRetrievalTool) {
            return "\ud83d\udd0e " + name;
        }
        if (toolOrAgent instanceof FunctionTool) {
            return "\ud83d\udd27 " + name;
        }
        if (toolOrAgent instanceof AgentTool) {
            return "\ud83e\udd16 " + name;
        }
        if (toolOrAgent instanceof BaseTool) {
            return "\ud83d\udd27 " + name;
        }
        log.warn("Unsupported type for getNodeCaption: {}", (Object)toolOrAgent.getClass().getName());
        return "\u2753 " + name;
    }

    private static Shape getNodeShape(Object toolOrAgent) {
        if (toolOrAgent instanceof BaseAgent) {
            return Shape.ELLIPSE;
        }
        if (toolOrAgent instanceof BaseRetrievalTool) {
            return Shape.CYLINDER;
        }
        if (toolOrAgent instanceof FunctionTool) {
            return Shape.BOX;
        }
        if (toolOrAgent instanceof BaseTool) {
            return Shape.BOX;
        }
        log.warn("Unsupported type for getNodeShape: {}", (Object)toolOrAgent.getClass().getName());
        return Shape.EGG;
    }

    private static boolean isNodeHighlighted(String nodeName, List<List<String>> highlightPairs) {
        if (highlightPairs == null || nodeName == null) {
            return false;
        }
        for (List<String> pair : highlightPairs) {
            if (pair == null || !pair.contains(nodeName)) continue;
            return true;
        }
        return false;
    }

    private static Optional<Boolean> isEdgeHighlighted(String fromName, String toName, List<List<String>> highlightPairs) {
        if (highlightPairs == null || fromName == null || toName == null) {
            return Optional.empty();
        }
        for (List<String> pair : highlightPairs) {
            if (pair == null || pair.size() != 2) continue;
            String pairFrom = pair.get(0);
            String pairTo = pair.get(1);
            if (fromName.equals(pairFrom) && toName.equals(pairTo)) {
                return Optional.of(true);
            }
            if (!fromName.equals(pairTo) || !toName.equals(pairFrom)) continue;
            return Optional.of(false);
        }
        return Optional.empty();
    }
}

