/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.servlet.NegotiateSecurityFilter;
import waffle.util.AuthorizationHeader;
import waffle.util.CorsPreflightCheck;

public class CorsAwareNegotiateSecurityFilter
extends NegotiateSecurityFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorsAwareNegotiateSecurityFilter.class);

    public CorsAwareNegotiateSecurityFilter() {
        LOGGER.info("[waffle.servlet.CorsAwareNegotiateSecurityFilter] loaded");
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.info("[waffle.servlet.CorsAwareNegotiateSecurityFilter] Starting");
        super.init(filterConfig);
        LOGGER.info("[waffle.servlet.CorsAwareNegotiateSecurityFilter] Started");
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOGGER.info("[waffle.servlet.CorsAwareNegotiateSecurityFilter] Filtering");
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(httpServletRequest);
        if (CorsPreflightCheck.isPreflight(httpServletRequest)) {
            LOGGER.info("[waffle.servlet.CorsAwareNegotiateSecurityFilter] Request is CORS preflight; continue filter chain");
            chain.doFilter(request, response);
        } else if (authorizationHeader.isBearerAuthorizationHeader()) {
            LOGGER.info("[waffle.servlet.CorsAwareNegotiateSecurityFilter] Request is Bearer, continue filter chain");
            chain.doFilter(request, response);
        } else {
            LOGGER.info("[waffle.servlet.CorsAwareNegotiateSecurityFilter] Request is Not CORS preflight");
            super.doFilter(request, response, chain);
            LOGGER.info("[waffle.servlet.CorsAwareNegotiateSecurityFilter] Authentication Completed");
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        LOGGER.info("[waffle.servlet.CorsAwareNegotiateSecurityFilter] unloaded");
    }
}

