/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.encoder;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.juli.logging.ch.qos.logback.core.encoder.Encoder;
import org.apache.juli.logging.ch.qos.logback.core.encoder.EncoderBase;
import org.apache.juli.logging.ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import org.apache.juli.logging.ch.qos.logback.core.pattern.PatternLayoutBase;
import org.apache.juli.logging.ch.qos.logback.core.spi.DeferredProcessingAware;
import org.apache.juli.logging.net.logstash.logback.composite.AbstractCompositeJsonFormatter;
import org.apache.juli.logging.net.logstash.logback.composite.JsonProviders;
import org.apache.juli.logging.net.logstash.logback.decorate.JsonFactoryDecorator;
import org.apache.juli.logging.net.logstash.logback.decorate.JsonGeneratorDecorator;
import org.apache.juli.logging.net.logstash.logback.encoder.SeparatorParser;
import org.apache.juli.logging.net.logstash.logback.encoder.StreamingEncoder;
import org.apache.juli.logging.net.logstash.logback.util.ReusableByteBuffer;
import org.apache.juli.logging.net.logstash.logback.util.ThreadLocalReusableByteBuffer;

public abstract class CompositeJsonEncoder<Event extends DeferredProcessingAware>
extends EncoderBase<Event>
implements StreamingEncoder<Event> {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private int minBufferSize = 1024;
    private ThreadLocalReusableByteBuffer threadLocalBuffer;
    private Encoder<Event> prefix;
    private Encoder<Event> suffix;
    private final AbstractCompositeJsonFormatter<Event> formatter;
    private String lineSeparator = System.lineSeparator();
    private byte[] lineSeparatorBytes;
    private Charset charset;

    public CompositeJsonEncoder() {
        this.formatter = Objects.requireNonNull(this.createFormatter());
    }

    protected abstract AbstractCompositeJsonFormatter<Event> createFormatter();

    @Override
    public void encode(Event event, OutputStream outputStream) throws IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException("Encoder is not started");
        }
        this.encode(outputStream, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode(Event event) {
        if (!this.isStarted()) {
            throw new IllegalStateException("Encoder is not started");
        }
        ReusableByteBuffer buffer = (ReusableByteBuffer)this.threadLocalBuffer.acquire();
        try {
            this.encode(buffer, event);
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            this.addWarn("Error encountered while encoding log event. Event: " + event, e);
            byte[] byArray = EMPTY_BYTES;
            return byArray;
        }
        finally {
            this.threadLocalBuffer.release();
        }
    }

    private void encode(OutputStream outputStream, Event event) throws IOException {
        this.encode(this.prefix, event, outputStream);
        this.formatter.writeEvent(event, outputStream);
        this.encode(this.suffix, event, outputStream);
        outputStream.write(this.lineSeparatorBytes);
    }

    private void encode(Encoder<Event> encoder, Event event, OutputStream outputStream) throws IOException {
        byte[] data;
        if (encoder != null && (data = encoder.encode(event)) != null) {
            outputStream.write(data);
        }
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        super.start();
        this.formatter.setContext(this.getContext());
        this.formatter.start();
        this.charset = Charset.forName(this.formatter.getEncoding());
        this.lineSeparatorBytes = this.lineSeparator == null ? EMPTY_BYTES : this.lineSeparator.getBytes(this.charset);
        this.startWrapped(this.prefix);
        this.startWrapped(this.suffix);
        this.threadLocalBuffer = new ThreadLocalReusableByteBuffer(this.minBufferSize);
    }

    private void startWrapped(Encoder<Event> wrapped) {
        if (wrapped instanceof LayoutWrappingEncoder) {
            LayoutWrappingEncoder layoutWrappedEncoder = (LayoutWrappingEncoder)wrapped;
            layoutWrappedEncoder.setCharset(this.charset);
            if (layoutWrappedEncoder.getLayout() instanceof PatternLayoutBase) {
                PatternLayoutBase layout = (PatternLayoutBase)layoutWrappedEncoder.getLayout();
                layout.setPostCompileProcessor(null);
                layout.start();
            }
        }
        if (wrapped != null && !wrapped.isStarted()) {
            wrapped.start();
        }
    }

    @Override
    public void stop() {
        if (this.isStarted()) {
            super.stop();
            this.formatter.stop();
            this.stopWrapped(this.prefix);
            this.stopWrapped(this.suffix);
            this.threadLocalBuffer = null;
        }
    }

    private void stopWrapped(Encoder<Event> wrapped) {
        if (wrapped != null && wrapped.isStarted()) {
            wrapped.stop();
        }
    }

    @Override
    public byte[] headerBytes() {
        return EMPTY_BYTES;
    }

    @Override
    public byte[] footerBytes() {
        return EMPTY_BYTES;
    }

    public JsonProviders<Event> getProviders() {
        return this.formatter.getProviders();
    }

    public void setProviders(JsonProviders<Event> jsonProviders) {
        this.formatter.setProviders(jsonProviders);
    }

    public JsonFactoryDecorator getJsonFactoryDecorator() {
        return this.formatter.getJsonFactoryDecorator();
    }

    public void setJsonFactoryDecorator(JsonFactoryDecorator jsonFactoryDecorator) {
        this.formatter.setJsonFactoryDecorator(jsonFactoryDecorator);
    }

    public JsonGeneratorDecorator getJsonGeneratorDecorator() {
        return this.formatter.getJsonGeneratorDecorator();
    }

    public String getEncoding() {
        return this.formatter.getEncoding();
    }

    public void setEncoding(String encodingName) {
        this.formatter.setEncoding(encodingName);
    }

    public void setFindAndRegisterJacksonModules(boolean findAndRegisterJacksonModules) {
        this.formatter.setFindAndRegisterJacksonModules(findAndRegisterJacksonModules);
    }

    public void setJsonGeneratorDecorator(JsonGeneratorDecorator jsonGeneratorDecorator) {
        this.formatter.setJsonGeneratorDecorator(jsonGeneratorDecorator);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = SeparatorParser.parseSeparator(lineSeparator);
    }

    public int getMinBufferSize() {
        return this.minBufferSize;
    }

    public void setMinBufferSize(int minBufferSize) {
        this.minBufferSize = minBufferSize;
    }

    protected AbstractCompositeJsonFormatter<Event> getFormatter() {
        return this.formatter;
    }

    public Encoder<Event> getPrefix() {
        return this.prefix;
    }

    public void setPrefix(Encoder<Event> prefix) {
        this.prefix = prefix;
    }

    public Encoder<Event> getSuffix() {
        return this.suffix;
    }

    public void setSuffix(Encoder<Event> suffix) {
        this.suffix = suffix;
    }
}

