/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.decorate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.juli.logging.com.fasterxml.jackson.core.JsonFactory;
import org.apache.juli.logging.com.fasterxml.jackson.core.SerializableString;
import org.apache.juli.logging.com.fasterxml.jackson.core.io.CharacterEscapes;
import org.apache.juli.logging.com.fasterxml.jackson.core.io.SerializedString;
import org.apache.juli.logging.net.logstash.logback.decorate.JsonFactoryDecorator;

public class CharacterEscapesJsonFactoryDecorator
implements JsonFactoryDecorator {
    private boolean includeStandardAsciiEscapesForJSON = true;
    private final List<Escape> escapes = new ArrayList<Escape>();
    private boolean needsInitialization = true;
    private CustomizedCharacterEscapes characterEscapes;

    @Override
    public JsonFactory decorate(JsonFactory factory) {
        if (this.needsInitialization) {
            this.characterEscapes = new CustomizedCharacterEscapes(this.includeStandardAsciiEscapesForJSON, this.escapes);
            this.needsInitialization = false;
        }
        return factory.setCharacterEscapes(this.characterEscapes);
    }

    public boolean isIncludeStandardAsciiEscapesForJSON() {
        return this.includeStandardAsciiEscapesForJSON;
    }

    public void setIncludeStandardAsciiEscapesForJSON(boolean includeStandardAsciiEscapesForJSON) {
        this.includeStandardAsciiEscapesForJSON = includeStandardAsciiEscapesForJSON;
        this.needsInitialization = true;
    }

    public void addEscape(Escape escape) {
        escape.assertValid();
        this.escapes.add(escape);
        this.needsInitialization = true;
    }

    public void removeEscape(Escape escape) {
        this.escapes.remove(escape);
        this.needsInitialization = true;
    }

    private static class CustomizedCharacterEscapes
    extends CharacterEscapes {
        private final int[] escapeCodesForAscii;
        private final int[] targetCharacterCodes;
        private final SerializedString[] escapeSequences;

        private CustomizedCharacterEscapes(boolean includeStandardAsciiEscapesForJSON, List<Escape> escapes) {
            if (includeStandardAsciiEscapesForJSON) {
                this.escapeCodesForAscii = CustomizedCharacterEscapes.standardAsciiEscapesForJSON();
            } else {
                this.escapeCodesForAscii = new int[128];
                Arrays.fill(this.escapeCodesForAscii, 0);
            }
            ArrayList<Escape> sortedEscapes = new ArrayList<Escape>(escapes);
            Collections.sort(sortedEscapes);
            this.targetCharacterCodes = new int[sortedEscapes.size()];
            this.escapeSequences = new SerializedString[sortedEscapes.size()];
            for (int i = 0; i < sortedEscapes.size(); ++i) {
                Escape escape = (Escape)sortedEscapes.get(i);
                if (escape.getTargetCharacterCode() < 128) {
                    this.escapeCodesForAscii[escape.getTargetCharacterCode()] = -2;
                }
                this.targetCharacterCodes[i] = escape.getTargetCharacterCode();
                this.escapeSequences[i] = escape.getEscapeSequence();
            }
        }

        @Override
        public SerializableString getEscapeSequence(int ch) {
            int index = Arrays.binarySearch(this.targetCharacterCodes, ch);
            if (index >= 0) {
                return this.escapeSequences[index];
            }
            return null;
        }

        @Override
        public int[] getEscapeCodesForAscii() {
            return this.escapeCodesForAscii;
        }
    }

    public static class Escape
    implements Comparable<Escape> {
        private static final SerializedString EMPTY_ESCAPE_SEQUENCE = new SerializedString("");
        private int targetCharacterCode = -1;
        private SerializedString escapeSequence = EMPTY_ESCAPE_SEQUENCE;

        public Escape() {
        }

        public Escape(String target, String escapeSequence) {
            this.setTarget(target);
            this.setEscapeSequence(escapeSequence);
        }

        public Escape(int targetCharacterCode, String escapeSequence) {
            this.setTargetCharacterCode(targetCharacterCode);
            this.setEscapeSequence(escapeSequence);
        }

        public Escape(char targetCharacter, String escapeSequence) {
            this.setTargetCharacter(targetCharacter);
            this.setEscapeSequence(escapeSequence);
        }

        public void setTarget(String target) {
            if (target == null || target.length() != 1) {
                throw new IllegalArgumentException("target's length must be 1");
            }
            this.setTargetCharacterCode(target.charAt(0));
        }

        public void setTargetCharacter(char targetCharacter) {
            this.setTargetCharacterCode(targetCharacter);
        }

        public int getTargetCharacterCode() {
            return this.targetCharacterCode;
        }

        public void setTargetCharacterCode(int targetCharacterCode) {
            if (targetCharacterCode < 0) {
                throw new IllegalArgumentException("targetCharacterCode must be greater than zero");
            }
            this.targetCharacterCode = targetCharacterCode;
        }

        public SerializedString getEscapeSequence() {
            return this.escapeSequence;
        }

        public void setEscapeSequence(String escapeSequence) {
            this.escapeSequence = escapeSequence == null ? EMPTY_ESCAPE_SEQUENCE : new SerializedString(escapeSequence);
        }

        private void assertValid() {
            if (this.targetCharacterCode < 0) {
                throw new IllegalArgumentException("targetCharacterCode must be 0 or greater");
            }
        }

        @Override
        public int compareTo(Escape that) {
            if (that == null) {
                return 1;
            }
            int targetCharacterCodeComparison = this.targetCharacterCode - that.targetCharacterCode;
            if (targetCharacterCodeComparison != 0) {
                return targetCharacterCodeComparison;
            }
            return this.escapeSequence.getValue().compareTo(that.escapeSequence.getValue());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Escape that = (Escape)o;
            return this.targetCharacterCode == that.targetCharacterCode && this.escapeSequence.equals(that.escapeSequence);
        }

        public int hashCode() {
            return Objects.hash(this.targetCharacterCode);
        }
    }
}

