/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.composite.loggingevent.mdc;

import java.io.IOException;
import org.apache.juli.logging.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.mdc.MdcEntryWriter;

public class LongMdcEntryWriter
implements MdcEntryWriter {
    @Override
    public boolean writeMdcEntry(JsonGenerator generator, String fieldName, String mdcKey, String mdcValue) throws IOException {
        if (this.shouldParse(mdcValue)) {
            try {
                long parsedValue = Long.parseLong(mdcValue);
                generator.writeFieldName(fieldName);
                generator.writeNumber(parsedValue);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean shouldParse(String value) {
        if (value == null || value.isEmpty() || value.length() > 20) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!(c == '+' || c == '-' ? i != 0 || value.length() == 1 : !Character.isDigit(c))) continue;
            return false;
        }
        return true;
    }
}

