/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.composite.loggingevent;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.juli.logging.ch.qos.logback.classic.spi.ILoggingEvent;
import org.apache.juli.logging.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.juli.logging.net.logstash.logback.composite.AbstractFieldJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.FieldNamesAware;
import org.apache.juli.logging.net.logstash.logback.composite.loggingevent.LogstashMarkersJsonProvider;
import org.apache.juli.logging.net.logstash.logback.fieldnames.LogstashFieldNames;
import org.apache.juli.logging.org.slf4j.Marker;

public class TagsJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    public static final String FIELD_TAGS = "tags";

    public TagsJsonProvider() {
        this.setFieldName(FIELD_TAGS);
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        boolean hasWrittenStart = false;
        if (hasWrittenStart = this.writeTagIfNecessary(generator, hasWrittenStart, event.getMarkerList())) {
            generator.writeEndArray();
        }
    }

    private boolean writeTagIfNecessary(JsonGenerator generator, boolean hasWrittenStart, List<Marker> markers) throws IOException {
        if (markers != null) {
            for (Marker marker : markers) {
                hasWrittenStart |= this.writeTagIfNecessary(generator, hasWrittenStart, marker);
            }
        }
        return hasWrittenStart;
    }

    private boolean writeTagIfNecessary(JsonGenerator generator, boolean hasWrittenStart, Marker marker) throws IOException {
        if (marker != null) {
            if (!LogstashMarkersJsonProvider.isLogstashMarker(marker)) {
                if (!hasWrittenStart) {
                    generator.writeArrayFieldStart(this.getFieldName());
                    hasWrittenStart = true;
                }
                generator.writeString(marker.getName());
            }
            if (marker.hasReferences()) {
                Iterator<Marker> i = marker.iterator();
                while (i.hasNext()) {
                    Marker next = i.next();
                    hasWrittenStart |= this.writeTagIfNecessary(generator, hasWrittenStart, next);
                }
            }
        }
        return hasWrittenStart;
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getTags());
    }
}

