/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.composite.loggingevent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.juli.logging.ch.qos.logback.classic.spi.ILoggingEvent;
import org.apache.juli.logging.ch.qos.logback.classic.spi.IThrowableProxy;
import org.apache.juli.logging.ch.qos.logback.classic.spi.ThrowableProxy;
import org.apache.juli.logging.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.juli.logging.net.logstash.logback.composite.AbstractFieldJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.JsonWritingUtils;
import org.apache.juli.logging.net.logstash.logback.stacktrace.StackElementFilter;
import org.apache.juli.logging.net.logstash.logback.stacktrace.StackHasher;
import org.apache.juli.logging.net.logstash.logback.util.StringUtils;

public class StackHashJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent> {
    public static final String FIELD_NAME = "stack_hash";
    private List<Pattern> excludes = new ArrayList<Pattern>();
    private StackHasher hasher;

    public StackHashJsonProvider() {
        this.setFieldName(FIELD_NAME);
    }

    @Override
    public void start() {
        if (!this.isStarted()) {
            this.hasher = new StackHasher(StackElementFilter.byPattern(this.excludes));
            super.start();
        }
    }

    @Override
    public void stop() {
        if (this.isStarted()) {
            super.stop();
            this.hasher = null;
        }
    }

    public void addExclude(String exclusionPattern) {
        this.excludes.add(Pattern.compile(exclusionPattern));
    }

    public void addExclusions(String commaSeparatedPatterns) {
        for (String regex : StringUtils.commaDelimitedListToStringArray(commaSeparatedPatterns)) {
            this.addExclude(regex);
        }
    }

    public void setExcludes(List<String> exclusionPatterns) {
        this.excludes = new ArrayList<Pattern>(exclusionPatterns.size());
        for (String pattern : exclusionPatterns) {
            this.addExclude(pattern);
        }
    }

    public List<String> getExcludes() {
        return this.excludes.stream().map(Pattern::pattern).collect(Collectors.toList());
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        this.assertIsStarted();
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy instanceof ThrowableProxy) {
            String hash = this.hasher.hexHash(((ThrowableProxy)event.getThrowableProxy()).getThrowable());
            JsonWritingUtils.writeStringField(generator, this.getFieldName(), hash);
        }
    }
}

