/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.appender.listener;

import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.juli.logging.ch.qos.logback.core.spi.DeferredProcessingAware;
import org.apache.juli.logging.net.logstash.logback.appender.listener.FailureSummaryAppenderListener;
import org.apache.juli.logging.net.logstash.logback.argument.StructuredArguments;
import org.apache.juli.logging.org.slf4j.Logger;
import org.apache.juli.logging.org.slf4j.LoggerFactory;

public class FailureSummaryLoggingAppenderListener<Event extends DeferredProcessingAware>
extends FailureSummaryAppenderListener<Event> {
    private volatile Logger logger = LoggerFactory.getLogger(FailureSummaryLoggingAppenderListener.class);

    @Override
    protected void handleFailureSummary(FailureSummaryAppenderListener.FailureSummary failureSummary, FailureSummaryAppenderListener.CallbackType callbackType) {
        if (this.logger.isWarnEnabled()) {
            if (failureSummary.getFirstFailure() != failureSummary.getMostRecentFailure()) {
                failureSummary.getMostRecentFailure().addSuppressed(failureSummary.getFirstFailure());
            }
            this.logger.warn("{} {} failures since {} for {}.", StructuredArguments.value("failEventCount", failureSummary.getConsecutiveFailures()), StructuredArguments.value("failType", callbackType.name().toLowerCase()), StructuredArguments.value("failStartTime", DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(TimeZone.getDefault().toZoneId()).format(Instant.ofEpochMilli(failureSummary.getFirstFailureTime()))), StructuredArguments.value("failDuration", Duration.ofMillis(System.currentTimeMillis() - failureSummary.getFirstFailureTime()).toString()), failureSummary.getMostRecentFailure());
        }
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String loggerName) {
        this.logger = LoggerFactory.getLogger(Objects.requireNonNull(loggerName));
    }
}

