/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.appender.destination;

import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.UnaryOperator;
import org.apache.juli.logging.net.logstash.logback.appender.destination.DestinationConnectionStrategyWithTtl;

public class RandomDestinationConnectionStrategy
extends DestinationConnectionStrategyWithTtl {
    private final UnaryOperator<Integer> randomSupplier;

    public RandomDestinationConnectionStrategy() {
        this(bound -> ThreadLocalRandom.current().nextInt((int)bound));
    }

    public RandomDestinationConnectionStrategy(UnaryOperator<Integer> randomSupplier) {
        this.randomSupplier = Objects.requireNonNull(randomSupplier);
    }

    @Override
    public int selectNextDestinationIndex(int previousDestinationIndex, int numDestinations) {
        return (Integer)this.randomSupplier.apply(numDestinations);
    }
}

