/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.appender.destination;

import org.apache.juli.logging.ch.qos.logback.core.spi.ContextAwareBase;
import org.apache.juli.logging.ch.qos.logback.core.spi.LifeCycle;
import org.apache.juli.logging.net.logstash.logback.appender.destination.DestinationConnectionStrategy;
import org.apache.juli.logging.net.logstash.logback.appender.destination.PreferPrimaryDestinationConnectionStrategy;
import org.apache.juli.logging.net.logstash.logback.appender.destination.RandomDestinationConnectionStrategy;
import org.apache.juli.logging.net.logstash.logback.appender.destination.RoundRobinDestinationConnectionStrategy;

public class DelegateDestinationConnectionStrategy
extends ContextAwareBase
implements DestinationConnectionStrategy,
LifeCycle {
    private DestinationConnectionStrategy delegate;
    private volatile boolean started;

    @Override
    public int selectNextDestinationIndex(int previousDestinationIndex, int numDestinations) {
        return this.delegate.selectNextDestinationIndex(previousDestinationIndex, numDestinations);
    }

    @Override
    public void connectSuccess(long connectionStartTimeInMillis, int connectedDestinationIndex, int numDestinations) {
        this.delegate.connectSuccess(connectionStartTimeInMillis, connectedDestinationIndex, numDestinations);
    }

    @Override
    public void connectFailed(long connectionStartTimeInMillis, int failedDestinationIndex, int numDestinations) {
        this.delegate.connectFailed(connectionStartTimeInMillis, failedDestinationIndex, numDestinations);
    }

    @Override
    public boolean shouldReconnect(long currentTimeInMillis, int currentDestinationIndex, int numDestinations) {
        return this.delegate.shouldReconnect(currentTimeInMillis, currentDestinationIndex, numDestinations);
    }

    @Override
    public void start() {
        this.started = true;
        if (this.delegate == null) {
            throw new IllegalStateException("No destinationConnectionStrategy configured.");
        }
    }

    @Override
    public void stop() {
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public void setPreferPrimary(PreferPrimaryDestinationConnectionStrategy strategy) {
        this.setDelegate(strategy);
    }

    public void setRandom(RandomDestinationConnectionStrategy strategy) {
        this.setDelegate(strategy);
    }

    public void setRoundRobin(RoundRobinDestinationConnectionStrategy strategy) {
        this.setDelegate(strategy);
    }

    private void setDelegate(DestinationConnectionStrategy delegate) {
        if (this.delegate != null) {
            throw new IllegalStateException(String.format("Attempted to set two destination connection strategies: %s %s", this.delegate, delegate));
        }
        this.delegate = delegate;
    }
}

