/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.appender;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.juli.logging.ch.qos.logback.core.UnsynchronizedAppenderBase;
import org.apache.juli.logging.ch.qos.logback.core.spi.DeferredProcessingAware;
import org.apache.juli.logging.ch.qos.logback.core.status.OnConsoleStatusListener;
import org.apache.juli.logging.ch.qos.logback.core.util.Duration;
import org.apache.juli.logging.net.logstash.logback.appender.RingBufferFullException;
import org.apache.juli.logging.net.logstash.logback.appender.ShutdownInProgressException;
import org.apache.juli.logging.net.logstash.logback.appender.WaitStrategyFactory;
import org.apache.juli.logging.net.logstash.logback.appender.listener.AppenderListener;
import org.apache.juli.logging.net.logstash.logback.encoder.com.lmax.disruptor.BlockingWaitStrategy;
import org.apache.juli.logging.net.logstash.logback.encoder.com.lmax.disruptor.EventFactory;
import org.apache.juli.logging.net.logstash.logback.encoder.com.lmax.disruptor.EventHandler;
import org.apache.juli.logging.net.logstash.logback.encoder.com.lmax.disruptor.EventTranslatorOneArg;
import org.apache.juli.logging.net.logstash.logback.encoder.com.lmax.disruptor.ExceptionHandler;
import org.apache.juli.logging.net.logstash.logback.encoder.com.lmax.disruptor.LifecycleAware;
import org.apache.juli.logging.net.logstash.logback.encoder.com.lmax.disruptor.Sequence;
import org.apache.juli.logging.net.logstash.logback.encoder.com.lmax.disruptor.SequenceReportingEventHandler;
import org.apache.juli.logging.net.logstash.logback.encoder.com.lmax.disruptor.WaitStrategy;
import org.apache.juli.logging.net.logstash.logback.encoder.com.lmax.disruptor.dsl.Disruptor;
import org.apache.juli.logging.net.logstash.logback.encoder.com.lmax.disruptor.dsl.ProducerType;
import org.apache.juli.logging.net.logstash.logback.status.LevelFilteringStatusListener;

public abstract class AsyncDisruptorAppender<Event extends DeferredProcessingAware, Listener extends AppenderListener<Event>>
extends UnsynchronizedAppenderBase<Event> {
    private static final long SLEEP_TIME_DURING_SHUTDOWN = 50000000L;
    protected static final String APPENDER_NAME_FORMAT = "%1$s";
    protected static final String THREAD_INDEX_FORMAT = "%2$d";
    public static final String DEFAULT_THREAD_NAME_FORMAT = "logback-appender-%1$s-%2$d";
    public static final int DEFAULT_RING_BUFFER_SIZE = 8192;
    public static final ProducerType DEFAULT_PRODUCER_TYPE = ProducerType.MULTI;
    public static final WaitStrategy DEFAULT_WAIT_STRATEGY = new BlockingWaitStrategy();
    public static final int DEFAULT_DROPPED_WARN_FREQUENCY = 1000;
    private static final RingBufferFullException RING_BUFFER_FULL_EXCEPTION = new RingBufferFullException();
    private int ringBufferSize = 8192;
    private ProducerType producerType = DEFAULT_PRODUCER_TYPE;
    private WaitStrategy waitStrategy = DEFAULT_WAIT_STRATEGY;
    private String threadNameFormat = "logback-appender-%1$s-%2$d";
    private boolean useDaemonThread = true;
    private boolean addDefaultStatusListener = true;
    private int droppedWarnFrequency = 1000;
    private ThreadFactory threadFactory = new WorkerThreadFactory();
    private Disruptor<LogEvent<Event>> disruptor;
    private EventTranslatorOneArg<LogEvent<Event>, Event> eventTranslator = new LogEventTranslator();
    private ExceptionHandler<LogEvent<Event>> exceptionHandler = new LogEventExceptionHandler();
    private final AtomicLong consecutiveDroppedCount = new AtomicLong();
    private LogEventFactory<Event> eventFactory = new LogEventFactory();
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    protected final List<Listener> listeners = new ArrayList<Listener>();
    private Duration appendTimeout = Duration.buildByMilliseconds(0.0);
    private Duration appendRetryFrequency = Duration.buildByMilliseconds(5.0);
    private Duration shutdownGracePeriod = Duration.buildByMinutes(1.0);
    private final ReentrantLock lock = new ReentrantLock();

    @Override
    public void start() {
        if (this.addDefaultStatusListener && this.getStatusManager() != null && this.getStatusManager().getCopyOfStatusListenerList().isEmpty()) {
            LevelFilteringStatusListener statusListener = new LevelFilteringStatusListener();
            statusListener.setLevelValue(1);
            statusListener.setDelegate(new OnConsoleStatusListener());
            statusListener.setContext(this.getContext());
            statusListener.start();
            this.getStatusManager().add(statusListener);
        }
        this.disruptor = new Disruptor<Event>(this.eventFactory, this.ringBufferSize, this.threadFactory, this.producerType, this.waitStrategy);
        this.disruptor.setDefaultExceptionHandler(this.exceptionHandler);
        this.disruptor.handleEventsWith(new EventClearingEventHandler<Event>(this.createEventHandler()));
        this.disruptor.start();
        super.start();
        this.fireAppenderStarted();
    }

    @Override
    public void stop() {
        long deadline;
        if (!super.isStarted()) {
            return;
        }
        super.stop();
        long l = deadline = this.getShutdownGracePeriod().getMilliseconds() < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + this.getShutdownGracePeriod().getMilliseconds();
        while (!this.isRingBufferEmpty() && System.currentTimeMillis() < deadline) {
            LockSupport.parkNanos(50000000L);
        }
        this.disruptor.halt();
        if (!this.isRingBufferEmpty()) {
            this.addWarn("Some queued events have not been logged due to requested shutdown");
        }
        this.fireAppenderStopped();
    }

    protected abstract EventHandler<LogEvent<Event>> createEventHandler();

    protected boolean isRingBufferEmpty() {
        return this.disruptor.getRingBuffer().hasAvailableCapacity(this.getRingBufferSize());
    }

    @Override
    protected void append(Event event) {
        long startTime = System.nanoTime();
        try {
            this.prepareForDeferredProcessing(event);
        }
        catch (RuntimeException e) {
            this.addWarn("Unable to prepare event for deferred processing. Event output might be missing data.", e);
        }
        try {
            if (this.enqueue(event)) {
                long consecutiveDropped = this.consecutiveDroppedCount.get();
                if (consecutiveDropped != 0L && this.consecutiveDroppedCount.compareAndSet(consecutiveDropped, 0L)) {
                    this.addWarn("Dropped " + consecutiveDropped + " total events due to ring buffer at max capacity [" + this.ringBufferSize + "]");
                }
                this.fireEventAppended(event, System.nanoTime() - startTime);
            } else {
                long consecutiveDropped = this.consecutiveDroppedCount.incrementAndGet();
                if (consecutiveDropped % (long)this.droppedWarnFrequency == 1L) {
                    this.addWarn("Dropped " + consecutiveDropped + " events (and counting...) due to ring buffer at max capacity [" + this.ringBufferSize + "]");
                }
                this.fireEventAppendFailed(event, RING_BUFFER_FULL_EXCEPTION);
            }
        }
        catch (ShutdownInProgressException e) {
            this.addWarn("Attempted to append to non started appender [" + this.getName() + "].");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enqueue(Event event) throws ShutdownInProgressException, InterruptedException {
        if (this.disruptor.getRingBuffer().tryPublishEvent(this.eventTranslator, event)) {
            return true;
        }
        if (this.appendTimeout.getMilliseconds() == 0L) {
            return false;
        }
        long deadline = Long.MAX_VALUE;
        if (this.appendTimeout.getMilliseconds() < 0L) {
            this.lock.lockInterruptibly();
        } else {
            deadline = System.currentTimeMillis() + this.appendTimeout.getMilliseconds();
            if (!this.lock.tryLock(this.appendTimeout.getMilliseconds(), TimeUnit.MILLISECONDS)) {
                return false;
            }
        }
        long backoff = 1L;
        long backoffLimit = TimeUnit.MILLISECONDS.toNanos(this.appendRetryFrequency.getMilliseconds());
        try {
            do {
                if (!this.isStarted()) {
                    throw new ShutdownInProgressException();
                }
                if (deadline <= System.currentTimeMillis()) {
                    boolean bl = false;
                    return bl;
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                LockSupport.parkNanos(backoff);
                backoff = Math.min(backoff * 2L, backoffLimit);
            } while (!this.disruptor.getRingBuffer().tryPublishEvent(this.eventTranslator, event));
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void prepareForDeferredProcessing(Event event) {
        event.prepareForDeferredProcessing();
    }

    protected String calculateThreadName() {
        List<Object> threadNameFormatParams = this.getThreadNameFormatParams();
        return String.format(this.threadNameFormat, threadNameFormatParams.toArray());
    }

    protected List<Object> getThreadNameFormatParams() {
        return Arrays.asList(this.getName(), this.threadNumber.incrementAndGet());
    }

    protected void fireAppenderStarted() {
        this.safelyFireEvent(l -> l.appenderStarted(this));
    }

    protected void fireAppenderStopped() {
        this.safelyFireEvent(l -> l.appenderStopped(this));
    }

    protected void fireEventAppended(Event event, long durationInNanos) {
        this.safelyFireEvent(l -> l.eventAppended(this, event, durationInNanos));
    }

    protected void fireEventAppendFailed(Event event, Throwable reason) {
        this.safelyFireEvent(l -> l.eventAppendFailed(this, event, reason));
    }

    protected void safelyFireEvent(Consumer<Listener> callback) {
        for (AppenderListener listener : this.listeners) {
            try {
                callback.accept(listener);
            }
            catch (Exception e) {
                this.addError("Failed to invoke listener " + listener, e);
            }
        }
    }

    protected void setEventFactory(LogEventFactory<Event> eventFactory) {
        this.eventFactory = eventFactory;
    }

    protected EventTranslatorOneArg<LogEvent<Event>, Event> getEventTranslator() {
        return this.eventTranslator;
    }

    protected void setEventTranslator(EventTranslatorOneArg<LogEvent<Event>, Event> eventTranslator) {
        this.eventTranslator = eventTranslator;
    }

    protected Disruptor<LogEvent<Event>> getDisruptor() {
        return this.disruptor;
    }

    public String getThreadNameFormat() {
        return this.threadNameFormat;
    }

    public void setThreadNameFormat(String threadNameFormat) {
        this.threadNameFormat = Objects.requireNonNull(threadNameFormat);
    }

    public int getRingBufferSize() {
        return this.ringBufferSize;
    }

    public void setRingBufferSize(int ringBufferSize) {
        if (ringBufferSize <= 0 || !AsyncDisruptorAppender.isPowerOfTwo(ringBufferSize)) {
            throw new IllegalArgumentException("ringBufferSize must be a positive power of 2");
        }
        this.ringBufferSize = ringBufferSize;
    }

    public ProducerType getProducerType() {
        return this.producerType;
    }

    @Deprecated
    public void setProducerType(ProducerType producerType) {
        this.producerType = Objects.requireNonNull(producerType);
        this.addWarn("<producerType> is deprecated and will be removed without replacement in future release");
    }

    public WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    public void setWaitStrategy(WaitStrategy waitStrategy) {
        this.waitStrategy = Objects.requireNonNull(waitStrategy);
    }

    public void setWaitStrategyType(String waitStrategyType) {
        this.setWaitStrategy(WaitStrategyFactory.createWaitStrategyFromString(waitStrategyType));
    }

    public Duration getAppendRetryFrequency() {
        return this.appendRetryFrequency;
    }

    public void setAppendRetryFrequency(Duration appendRetryFrequency) {
        if (Objects.requireNonNull(appendRetryFrequency).getMilliseconds() <= 0L) {
            throw new IllegalArgumentException("appendRetryFrequency must be > 0");
        }
        this.appendRetryFrequency = appendRetryFrequency;
    }

    public Duration getAppendTimeout() {
        return this.appendTimeout;
    }

    public void setAppendTimeout(Duration appendTimeout) {
        this.appendTimeout = Objects.requireNonNull(appendTimeout);
    }

    public void setShutdownGracePeriod(Duration shutdownGracePeriod) {
        this.shutdownGracePeriod = Objects.requireNonNull(shutdownGracePeriod);
    }

    public Duration getShutdownGracePeriod() {
        return this.shutdownGracePeriod;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = Objects.requireNonNull(threadFactory);
    }

    public int getDroppedWarnFrequency() {
        return this.droppedWarnFrequency;
    }

    public void setDroppedWarnFrequency(int droppedWarnFrequency) {
        this.droppedWarnFrequency = droppedWarnFrequency;
    }

    public boolean isDaemon() {
        return this.useDaemonThread;
    }

    public void setDaemon(boolean useDaemonThread) {
        this.useDaemonThread = useDaemonThread;
    }

    public void addListener(Listener listener) {
        this.listeners.add((AppenderListener)Objects.requireNonNull(listener));
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public boolean isAddDefaultStatusListener() {
        return this.addDefaultStatusListener;
    }

    public void setAddDefaultStatusListener(boolean addDefaultStatusListener) {
        this.addDefaultStatusListener = addDefaultStatusListener;
    }

    private static boolean isPowerOfTwo(int x) {
        return x != 0 && (x & x - 1) == 0;
    }

    static {
        RING_BUFFER_FULL_EXCEPTION.setStackTrace(new StackTraceElement[]{new StackTraceElement(AsyncDisruptorAppender.class.getName(), "append(..)", null, -1)});
    }

    private class WorkerThreadFactory
    implements ThreadFactory {
        private WorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName(AsyncDisruptorAppender.this.calculateThreadName());
            t.setDaemon(AsyncDisruptorAppender.this.useDaemonThread);
            return t;
        }
    }

    protected static class LogEventTranslator<Event>
    implements EventTranslatorOneArg<LogEvent<Event>, Event> {
        protected LogEventTranslator() {
        }

        @Override
        public void translateTo(LogEvent<Event> logEvent, long sequence, Event event) {
            logEvent.event = event;
        }
    }

    private class LogEventExceptionHandler
    implements ExceptionHandler<LogEvent<Event>> {
        private LogEventExceptionHandler() {
        }

        @Override
        public void handleEventException(Throwable ex, long sequence, LogEvent<Event> event) {
            AsyncDisruptorAppender.this.addError("Unable to process event: " + ex.getMessage(), ex);
        }

        @Override
        public void handleOnStartException(Throwable ex) {
            AsyncDisruptorAppender.this.addError("Unable start disruptor", ex);
        }

        @Override
        public void handleOnShutdownException(Throwable ex) {
            AsyncDisruptorAppender.this.addError("Unable shutdown disruptor", ex);
        }
    }

    protected static class LogEventFactory<Event>
    implements EventFactory<LogEvent<Event>> {
        protected LogEventFactory() {
        }

        @Override
        public LogEvent<Event> newInstance() {
            return new LogEvent();
        }
    }

    private static class EventClearingEventHandler<Event>
    implements SequenceReportingEventHandler<LogEvent<Event>>,
    LifecycleAware {
        private final EventHandler<LogEvent<Event>> delegate;
        private Sequence sequenceCallback;

        EventClearingEventHandler(EventHandler<LogEvent<Event>> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(LogEvent<Event> event, long sequence, boolean endOfBatch) throws Exception {
            try {
                this.delegate.onEvent(event, sequence, endOfBatch);
            }
            finally {
                event.recycle();
                this.sequenceCallback.set(sequence);
            }
        }

        @Override
        public void onStart() {
            if (this.delegate instanceof LifecycleAware) {
                ((LifecycleAware)((Object)this.delegate)).onStart();
            }
        }

        @Override
        public void onShutdown() {
            if (this.delegate instanceof LifecycleAware) {
                ((LifecycleAware)((Object)this.delegate)).onShutdown();
            }
        }

        @Override
        public void setSequenceCallback(Sequence sequenceCallback) {
            this.sequenceCallback = sequenceCallback;
        }
    }

    protected static class LogEvent<Event> {
        public volatile Event event;

        protected LogEvent() {
        }

        public void recycle() {
            this.event = null;
        }
    }
}

