/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback.abbreviator;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.juli.logging.ch.qos.logback.classic.pattern.Abbreviator;

public class CachingAbbreviator
implements Abbreviator {
    private final Abbreviator delegate;
    private final ConcurrentMap<String, String> cache = new ConcurrentHashMap<String, String>();

    public CachingAbbreviator(Abbreviator delegate) {
        this.delegate = delegate;
    }

    @Override
    public String abbreviate(String in) {
        return this.cache.computeIfAbsent(in, this.delegate::abbreviate);
    }

    public void clear() {
        this.cache.clear();
    }
}

