/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.net.logstash.logback;

import org.apache.juli.logging.ch.qos.logback.access.spi.IAccessEvent;
import org.apache.juli.logging.ch.qos.logback.core.joran.spi.DefaultClass;
import org.apache.juli.logging.ch.qos.logback.core.spi.ContextAware;
import org.apache.juli.logging.com.fasterxml.jackson.databind.JsonNode;
import org.apache.juli.logging.net.logstash.logback.composite.ContextJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.FieldNamesAware;
import org.apache.juli.logging.net.logstash.logback.composite.GlobalCustomFieldsJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.JsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.JsonProviders;
import org.apache.juli.logging.net.logstash.logback.composite.LogstashVersionJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.AccessEventCompositeJsonFormatter;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.AccessEventFormattedTimestampJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.AccessEventJsonProviders;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.AccessEventPatternJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.AccessMessageJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.ContentLengthJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.ElapsedTimeJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.HeaderFilter;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.IncludeExcludeHeaderFilter;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.MethodJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.ProtocolJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.RemoteHostJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.RemoteUserJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.RequestHeadersJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.RequestedUriJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.RequestedUrlJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.ResponseHeadersJsonProvider;
import org.apache.juli.logging.net.logstash.logback.composite.accessevent.StatusCodeJsonProvider;
import org.apache.juli.logging.net.logstash.logback.fieldnames.LogstashAccessFieldNames;

public class LogstashAccessFormatter
extends AccessEventCompositeJsonFormatter {
    protected LogstashAccessFieldNames fieldNames = new LogstashAccessFieldNames();
    private final AccessEventFormattedTimestampJsonProvider timestampProvider = new AccessEventFormattedTimestampJsonProvider();
    private final LogstashVersionJsonProvider<IAccessEvent> versionProvider = new LogstashVersionJsonProvider();
    private final MethodJsonProvider methodProvider = new MethodJsonProvider();
    private final ProtocolJsonProvider protocolProvider = new ProtocolJsonProvider();
    private final StatusCodeJsonProvider statusCodeProvider = new StatusCodeJsonProvider();
    private final RequestedUrlJsonProvider requestedUrlProvider = new RequestedUrlJsonProvider();
    private final RequestedUriJsonProvider requestedUriProvider = new RequestedUriJsonProvider();
    private final RemoteHostJsonProvider remoteHostProvider = new RemoteHostJsonProvider();
    private final RemoteUserJsonProvider remoteUserProvider = new RemoteUserJsonProvider();
    private final ContentLengthJsonProvider contentLengthProvider = new ContentLengthJsonProvider();
    private final ElapsedTimeJsonProvider elapsedTimeProvider = new ElapsedTimeJsonProvider();
    private final RequestHeadersJsonProvider requestHeadersProvider = new RequestHeadersJsonProvider();
    private final ResponseHeadersJsonProvider responseHeadersProvider = new ResponseHeadersJsonProvider();
    private JsonProvider<IAccessEvent> messageProvider;
    private ContextJsonProvider<IAccessEvent> contextProvider = new ContextJsonProvider();
    private GlobalCustomFieldsJsonProvider<IAccessEvent> globalCustomFieldsProvider;
    private String messagePattern;

    public LogstashAccessFormatter(ContextAware declaredOrigin) {
        super(declaredOrigin);
        this.getProviders().addTimestamp(this.timestampProvider);
        this.getProviders().addVersion(this.versionProvider);
        this.getProviders().addMethod(this.methodProvider);
        this.getProviders().addProtocol(this.protocolProvider);
        this.getProviders().addStatusCode(this.statusCodeProvider);
        this.getProviders().addRequestedUrl(this.requestedUrlProvider);
        this.getProviders().addRequestedUri(this.requestedUriProvider);
        this.getProviders().addRemoteHost(this.remoteHostProvider);
        this.getProviders().addRemoteUser(this.remoteUserProvider);
        this.getProviders().addContentLength(this.contentLengthProvider);
        this.getProviders().addElapsedTime(this.elapsedTimeProvider);
        this.getProviders().addRequestHeaders(this.requestHeadersProvider);
        this.getProviders().addResponseHeaders(this.responseHeadersProvider);
        this.getProviders().addContext(this.contextProvider);
    }

    @Override
    public void start() {
        this.updateMessageProvider();
        this.configureProviderFieldNames();
        super.start();
    }

    private void updateMessageProvider() {
        this.getProviders().removeProvider(this.messageProvider);
        if (this.messagePattern != null) {
            String accessEventPattern = "{\"" + this.fieldNames.getMessage() + "\": \"" + LogstashAccessFormatter.escapeJson(this.messagePattern) + "\"}";
            AccessEventPatternJsonProvider messagePatternProvider = new AccessEventPatternJsonProvider();
            messagePatternProvider.setPattern(accessEventPattern);
            this.messageProvider = messagePatternProvider;
        } else {
            AccessMessageJsonProvider accessMessageJsonProvider = new AccessMessageJsonProvider();
            accessMessageJsonProvider.setTimeZone(this.timestampProvider.getTimeZone());
            this.messageProvider = accessMessageJsonProvider;
        }
        this.getProviders().addProvider(this.messageProvider);
    }

    protected void configureProviderFieldNames() {
        for (JsonProvider provider : this.getProviders().getProviders()) {
            if (!(provider instanceof FieldNamesAware)) continue;
            ((FieldNamesAware)((Object)provider)).setFieldNames(this.fieldNames);
        }
    }

    public void addProvider(JsonProvider<IAccessEvent> provider) {
        this.getProviders().addProvider(provider);
    }

    public AccessEventJsonProviders getProviders() {
        return (AccessEventJsonProviders)super.getProviders();
    }

    public LogstashAccessFieldNames getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(LogstashAccessFieldNames fieldNames) {
        this.fieldNames = fieldNames;
    }

    public String getTimeZone() {
        return this.timestampProvider.getTimeZone();
    }

    public void setTimeZone(String timeZoneId) {
        this.timestampProvider.setTimeZone(timeZoneId);
    }

    public String getTimestampPattern() {
        return this.timestampProvider.getPattern();
    }

    public void setTimestampPattern(String pattern) {
        this.timestampProvider.setPattern(pattern);
    }

    public String getCustomFieldsAsString() {
        return this.globalCustomFieldsProvider == null ? null : this.globalCustomFieldsProvider.getCustomFields();
    }

    public void setCustomFieldsFromString(String customFields) {
        if (customFields == null || customFields.length() == 0) {
            this.getProviders().removeProvider(this.globalCustomFieldsProvider);
            this.globalCustomFieldsProvider = null;
        } else {
            if (this.globalCustomFieldsProvider == null) {
                this.globalCustomFieldsProvider = new GlobalCustomFieldsJsonProvider();
                this.getProviders().addGlobalCustomFields(this.globalCustomFieldsProvider);
            }
            this.globalCustomFieldsProvider.setCustomFields(customFields);
        }
    }

    public void setCustomFields(JsonNode customFields) {
        if (customFields == null) {
            this.getProviders().removeProvider(this.globalCustomFieldsProvider);
            this.globalCustomFieldsProvider = null;
        } else {
            if (this.globalCustomFieldsProvider == null) {
                this.globalCustomFieldsProvider = new GlobalCustomFieldsJsonProvider();
                this.getProviders().addGlobalCustomFields(this.globalCustomFieldsProvider);
            }
            this.globalCustomFieldsProvider.setCustomFieldsNode(customFields);
        }
    }

    public JsonNode getCustomFields() {
        return this.globalCustomFieldsProvider == null ? null : this.globalCustomFieldsProvider.getCustomFieldsNode();
    }

    public boolean getLowerCaseHeaderNames() {
        return this.requestHeadersProvider.getLowerCaseHeaderNames();
    }

    public void setLowerCaseHeaderNames(boolean lowerCaseHeaderNames) {
        this.requestHeadersProvider.setLowerCaseHeaderNames(lowerCaseHeaderNames);
        this.responseHeadersProvider.setLowerCaseHeaderNames(lowerCaseHeaderNames);
    }

    public HeaderFilter getRequestHeaderFilter() {
        return this.requestHeadersProvider.getFilter();
    }

    @DefaultClass(value=IncludeExcludeHeaderFilter.class)
    public void setRequestHeaderFilter(HeaderFilter filter) {
        this.requestHeadersProvider.setFilter(filter);
    }

    public HeaderFilter getResponseHeaderFilter() {
        return this.responseHeadersProvider.getFilter();
    }

    @DefaultClass(value=IncludeExcludeHeaderFilter.class)
    public void setResponseHeaderFilter(HeaderFilter filter) {
        this.responseHeadersProvider.setFilter(filter);
    }

    public boolean isIncludeContext() {
        return this.contextProvider != null;
    }

    public void setIncludeContext(boolean includeContext) {
        if (this.isIncludeContext() != includeContext) {
            this.getProviders().removeProvider(this.contextProvider);
            if (includeContext) {
                this.contextProvider = new ContextJsonProvider();
                this.getProviders().addContext(this.contextProvider);
            } else {
                this.contextProvider = null;
            }
        }
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }

    public void setMessagePattern(String messagePattern) {
        this.messagePattern = messagePattern;
    }

    public String getVersion() {
        return this.versionProvider.getVersion();
    }

    public void setVersion(String version) {
        this.versionProvider.setVersion(version);
    }

    public boolean isWriteVersionAsInteger() {
        return this.versionProvider.isWriteAsInteger();
    }

    public void setWriteVersionAsInteger(boolean writeVersionAsInteger) {
        this.versionProvider.setWriteAsInteger(writeVersionAsInteger);
    }

    @Override
    public void setProviders(JsonProviders<IAccessEvent> jsonProviders) {
        if (super.getProviders() != null && !super.getProviders().getProviders().isEmpty()) {
            this.addError("Unable to set providers when using predefined composites.");
        } else {
            super.setProviders(jsonProviders);
        }
    }

    private static String escapeJson(String str) {
        return str.replace("\"", "\\\"");
    }
}

