/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.ch.qos.logback.classic.model.processor;

import org.apache.juli.logging.ch.qos.logback.classic.LoggerContext;
import org.apache.juli.logging.ch.qos.logback.classic.model.ConfigurationModel;
import org.apache.juli.logging.ch.qos.logback.core.Context;
import org.apache.juli.logging.ch.qos.logback.core.model.Model;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.ModelHandlerBase;
import org.apache.juli.logging.ch.qos.logback.core.model.processor.ModelInterpretationContext;
import org.apache.juli.logging.ch.qos.logback.core.status.OnConsoleStatusListener;
import org.apache.juli.logging.ch.qos.logback.core.util.ContextUtil;
import org.apache.juli.logging.ch.qos.logback.core.util.Duration;
import org.apache.juli.logging.ch.qos.logback.core.util.OptionHelper;
import org.apache.juli.logging.ch.qos.logback.core.util.StatusListenerConfigHelper;

public class ConfigurationModelHandler
extends ModelHandlerBase {
    static final Duration SCAN_PERIOD_DEFAULT = Duration.buildByMinutes(1.0);

    public ConfigurationModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext mic) {
        return new ConfigurationModelHandler(context);
    }

    protected Class<ConfigurationModel> getSupportedModelClass() {
        return ConfigurationModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext mic, Model model) {
        ConfigurationModel configurationModel = (ConfigurationModel)model;
        String debugAttrib = OptionHelper.getSystemProperty("logback.debug", null);
        if (debugAttrib == null) {
            debugAttrib = mic.subst(configurationModel.getDebugStr());
        }
        if (!(OptionHelper.isNullOrEmpty(debugAttrib) || debugAttrib.equalsIgnoreCase(Boolean.FALSE.toString()) || debugAttrib.equalsIgnoreCase("null"))) {
            StatusListenerConfigHelper.addOnConsoleListenerInstance(this.context, new OnConsoleStatusListener());
        }
        this.processScanAttrib(mic, configurationModel);
        LoggerContext lc = (LoggerContext)this.context;
        boolean packagingData = OptionHelper.toBoolean(mic.subst(configurationModel.getPackagingDataStr()), false);
        lc.setPackagingDataEnabled(packagingData);
        ContextUtil contextUtil = new ContextUtil(this.context);
        contextUtil.addGroovyPackages(lc.getFrameworkPackages());
    }

    protected void processScanAttrib(ModelInterpretationContext mic, ConfigurationModel configurationModel) {
        String scanStr = mic.subst(configurationModel.getScanStr());
        if (!OptionHelper.isNullOrEmpty(scanStr) && !"false".equalsIgnoreCase(scanStr)) {
            this.addInfo("Skipping ReconfigureOnChangeTask registration");
        }
    }
}

