package org.apache.juli.logging.ch.qos.logback.core.model.processor;

import org.apache.juli.logging.ch.qos.logback.core.model.Model;
import org.apache.juli.logging.ch.qos.logback.core.spi.FilterReply;

public class AllowModelFilter implements ModelFilter {

    final Class<? extends Model> allowedModelType;

    AllowModelFilter(Class<? extends Model> allowedType) {
        this.allowedModelType = allowedType;
    }

    @Override
    public FilterReply decide(Model model) {

        if (model.getClass() == allowedModelType) {
            return FilterReply.ACCEPT;
        }

        return FilterReply.NEUTRAL;
    }

}
