/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.google.common.eventbus;

import java.lang.reflect.Method;
import java.util.Set;
import wiremock.com.google.common.collect.HashMultimap;
import wiremock.com.google.common.collect.Multimap;
import wiremock.com.google.common.eventbus.AllowConcurrentEvents;
import wiremock.com.google.common.eventbus.EventHandler;
import wiremock.com.google.common.eventbus.HandlerFindingStrategy;
import wiremock.com.google.common.eventbus.Subscribe;
import wiremock.com.google.common.eventbus.SynchronizedEventHandler;
import wiremock.com.google.common.reflect.TypeToken;

class AnnotatedHandlerFinder
implements HandlerFindingStrategy {
    AnnotatedHandlerFinder() {
    }

    @Override
    public Multimap<Class<?>, EventHandler> findAllHandlers(Object listener) {
        HashMultimap<Class<?>, EventHandler> methodsInListener = HashMultimap.create();
        Class<?> clazz = listener.getClass();
        Set supers = TypeToken.of(clazz).getTypes().rawTypes();
        block2: for (Method method : clazz.getMethods()) {
            for (Class c : supers) {
                try {
                    Method m = c.getMethod(method.getName(), method.getParameterTypes());
                    if (!m.isAnnotationPresent(Subscribe.class)) continue;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length != 1) {
                        throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation, but requires " + parameterTypes.length + " arguments.  Event handler methods must require a single argument.");
                    }
                    Class<?> eventType = parameterTypes[0];
                    EventHandler handler = AnnotatedHandlerFinder.makeHandler(listener, method);
                    methodsInListener.put(eventType, handler);
                    continue block2;
                }
                catch (NoSuchMethodException ignored) {
                }
            }
        }
        return methodsInListener;
    }

    private static EventHandler makeHandler(Object listener, Method method) {
        EventHandler wrapper = AnnotatedHandlerFinder.methodIsDeclaredThreadSafe(method) ? new EventHandler(listener, method) : new SynchronizedEventHandler(listener, method);
        return wrapper;
    }

    private static boolean methodIsDeclaredThreadSafe(Method method) {
        return method.getAnnotation(AllowConcurrentEvents.class) != null;
    }
}

