/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.fasterxml.jackson.databind.ser.std;

import wiremock.com.fasterxml.jackson.databind.BeanProperty;
import wiremock.com.fasterxml.jackson.databind.JavaType;
import wiremock.com.fasterxml.jackson.databind.JsonSerializer;
import wiremock.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import wiremock.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import wiremock.com.fasterxml.jackson.databind.ser.impl.IndexedListSerializer;
import wiremock.com.fasterxml.jackson.databind.ser.impl.IteratorSerializer;
import wiremock.com.fasterxml.jackson.databind.ser.std.CollectionSerializer;
import wiremock.com.fasterxml.jackson.databind.ser.std.EnumSetSerializer;
import wiremock.com.fasterxml.jackson.databind.ser.std.IterableSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdContainerSerializers {
    protected StdContainerSerializers() {
    }

    public static ContainerSerializer<?> indexedListSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
        return new IndexedListSerializer(elemType, staticTyping, vts, null, valueSerializer);
    }

    public static ContainerSerializer<?> collectionSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
        return new CollectionSerializer(elemType, staticTyping, vts, null, valueSerializer);
    }

    public static ContainerSerializer<?> iteratorSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts) {
        return new IteratorSerializer(elemType, staticTyping, vts, null);
    }

    public static ContainerSerializer<?> iterableSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts) {
        return new IterableSerializer(elemType, staticTyping, vts, null);
    }

    public static JsonSerializer<?> enumSetSerializer(JavaType enumType) {
        return new EnumSetSerializer(enumType, null);
    }

    @Deprecated
    public static ContainerSerializer<?> indexedListSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property, JsonSerializer<Object> valueSerializer) {
        return StdContainerSerializers.indexedListSerializer(elemType, staticTyping, vts, valueSerializer);
    }

    @Deprecated
    public static ContainerSerializer<?> collectionSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property, JsonSerializer<Object> valueSerializer) {
        return StdContainerSerializers.collectionSerializer(elemType, staticTyping, vts, valueSerializer);
    }
}

