/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.core.Container;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockApp;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.global.RequestDelayControl;
import com.github.tomakehurst.wiremock.global.ThreadSafeRequestDelayControl;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.BasicResponseRenderer;
import com.github.tomakehurst.wiremock.http.ProxyResponseRenderer;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.http.StubResponseRenderer;
import com.github.tomakehurst.wiremock.jetty.DelayableSocketConnector;
import com.github.tomakehurst.wiremock.jetty.DelayableSslSocketConnector;
import com.github.tomakehurst.wiremock.servlet.ContentTypeSettingFilter;
import com.github.tomakehurst.wiremock.servlet.HandlerDispatchingServlet;
import com.github.tomakehurst.wiremock.servlet.TrailingSlashFilter;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsLoader;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsSaver;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.stubbing.StubMappingJsonRecorder;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import java.util.HashMap;
import wiremock.com.google.common.base.Preconditions;
import wiremock.com.google.common.collect.Maps;
import wiremock.org.mortbay.jetty.MimeTypes;
import wiremock.org.mortbay.jetty.Server;
import wiremock.org.mortbay.jetty.servlet.Context;
import wiremock.org.mortbay.jetty.servlet.DefaultServlet;
import wiremock.org.mortbay.jetty.servlet.ServletHolder;

public class WireMockServer
implements Container {
    public static final String FILES_ROOT = "__files";
    public static final String MAPPINGS_ROOT = "mappings";
    private static final String FILES_URL_MATCH = String.format("/%s/*", "__files");
    private final WireMockApp wireMockApp;
    private final AdminRequestHandler adminRequestHandler;
    private final StubRequestHandler stubRequestHandler;
    private Server jettyServer;
    private final RequestDelayControl requestDelayControl;
    private final FileSource fileSource;
    private final Notifier notifier;
    private final int port;
    private final String bindAddress;
    private final Options options;
    private DelayableSocketConnector httpConnector;
    private DelayableSslSocketConnector httpsConnector;

    public WireMockServer(Options options) {
        this.options = options;
        this.fileSource = options.filesRoot();
        this.port = options.portNumber();
        this.bindAddress = options.bindAddress();
        this.notifier = options.notifier();
        this.requestDelayControl = new ThreadSafeRequestDelayControl();
        MappingsLoader defaultMappingsLoader = this.makeDefaultMappingsLoader();
        JsonFileMappingsSaver mappingsSaver = new JsonFileMappingsSaver(this.fileSource.child(MAPPINGS_ROOT));
        this.wireMockApp = new WireMockApp(this.requestDelayControl, options.browserProxyingEnabled(), defaultMappingsLoader, mappingsSaver, options.requestJournalDisabled(), this);
        this.adminRequestHandler = new AdminRequestHandler(this.wireMockApp, new BasicResponseRenderer());
        this.stubRequestHandler = new StubRequestHandler(this.wireMockApp, new StubResponseRenderer(this.fileSource.child(FILES_ROOT), this.wireMockApp.getGlobalSettingsHolder(), new ProxyResponseRenderer(options.proxyVia())));
    }

    private MappingsLoader makeDefaultMappingsLoader() {
        FileSource mappingsFileSource = this.fileSource.child(MAPPINGS_ROOT);
        if (mappingsFileSource.exists()) {
            return new JsonFileMappingsLoader(mappingsFileSource);
        }
        return new NoOpMappingsLoader();
    }

    public WireMockServer(int port, Integer httpsPort, FileSource fileSource, boolean enableBrowserProxying, ProxySettings proxySettings, Notifier notifier) {
        this(WireMockConfiguration.wireMockConfig().port(port).httpsPort(httpsPort).fileSource(fileSource).enableBrowserProxying(enableBrowserProxying).proxyVia(proxySettings).notifier(notifier));
    }

    public WireMockServer(int port, FileSource fileSource, boolean enableBrowserProxying, ProxySettings proxySettings) {
        this(WireMockConfiguration.wireMockConfig().port(port).fileSource(fileSource).enableBrowserProxying(enableBrowserProxying).proxyVia(proxySettings));
    }

    public WireMockServer(int port, FileSource fileSource, boolean enableBrowserProxying) {
        this(WireMockConfiguration.wireMockConfig().port(port).fileSource(fileSource).enableBrowserProxying(enableBrowserProxying));
    }

    public WireMockServer(int port) {
        this(WireMockConfiguration.wireMockConfig().port(port));
    }

    public WireMockServer(int port, Integer httpsPort) {
        this(WireMockConfiguration.wireMockConfig().port(port).httpsPort(httpsPort));
    }

    public WireMockServer() {
        this(WireMockConfiguration.wireMockConfig());
    }

    public void loadMappingsUsing(MappingsLoader mappingsLoader) {
        this.wireMockApp.loadMappingsUsing(mappingsLoader);
    }

    public void addMockServiceRequestListener(RequestListener listener) {
        this.stubRequestHandler.addRequestListener(listener);
    }

    public void enableRecordMappings(FileSource mappingsFileSource, FileSource filesFileSource) {
        this.addMockServiceRequestListener(new StubMappingJsonRecorder(mappingsFileSource, filesFileSource, this.wireMockApp, this.options.matchingHeaders()));
        this.notifier.info("Recording mappings to " + mappingsFileSource.getPath());
    }

    public void stop() {
        try {
            this.httpConnector = null;
            this.httpsConnector = null;
            this.jettyServer.stop();
            this.jettyServer.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        try {
            this.jettyServer = new Server();
            this.httpConnector = this.createHttpConnector();
            this.jettyServer.addConnector(this.httpConnector);
            if (this.options.httpsSettings().enabled()) {
                this.httpsConnector = this.createHttpsConnector();
                this.jettyServer.addConnector(this.httpsConnector);
            }
            this.addAdminContext();
            this.addMockServiceContext();
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void shutdown() {
        final WireMockServer server = this;
        Thread shutdownThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                server.stop();
            }
        });
        shutdownThread.start();
    }

    public int port() {
        Preconditions.checkState(this.httpConnector != null, "Not listening on HTTP port. The WireMock server is most likely stopped");
        return this.httpConnector.getLocalPort();
    }

    public int httpsPort() {
        Preconditions.checkState(this.httpsConnector != null, "Not listening on HTTPS port. Either HTTPS is not enabled or the WireMock server is stopped.");
        return this.httpsConnector.getLocalPort();
    }

    private DelayableSocketConnector createHttpConnector() {
        DelayableSocketConnector connector = new DelayableSocketConnector(this.requestDelayControl);
        connector.setHost(this.bindAddress);
        connector.setPort(this.port);
        connector.setHeaderBufferSize(8192);
        return connector;
    }

    private DelayableSslSocketConnector createHttpsConnector() {
        DelayableSslSocketConnector connector = new DelayableSslSocketConnector(this.requestDelayControl);
        connector.setPort(this.options.httpsSettings().port());
        connector.setHeaderBufferSize(8192);
        connector.setKeystore(this.options.httpsSettings().keyStorePath());
        connector.setKeyPassword("password");
        return connector;
    }

    public boolean isRunning() {
        return this.jettyServer != null && this.jettyServer.isRunning();
    }

    private void addMockServiceContext() {
        Context mockServiceContext = new Context(this.jettyServer, "/");
        HashMap<String, String> initParams = Maps.newHashMap();
        initParams.put("wiremock.org.mortbay.jetty.servlet.Default.maxCacheSize", "0");
        initParams.put("wiremock.org.mortbay.jetty.servlet.Default.resourceBase", this.fileSource.getPath());
        initParams.put("wiremock.org.mortbay.jetty.servlet.Default.dirAllowed", "false");
        mockServiceContext.setInitParams(initParams);
        mockServiceContext.addServlet(DefaultServlet.class, FILES_URL_MATCH);
        mockServiceContext.setAttribute(StubRequestHandler.class.getName(), this.stubRequestHandler);
        mockServiceContext.setAttribute("Notifier", this.notifier);
        ServletHolder servletHolder = mockServiceContext.addServlet(HandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", StubRequestHandler.class.getName());
        servletHolder.setInitParameter("shouldForwardToFilesContext", "true");
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("json", "application/json");
        mimeTypes.addMimeMapping("html", "text/html");
        mimeTypes.addMimeMapping("xml", "application/xml");
        mimeTypes.addMimeMapping("txt", "text/plain");
        mockServiceContext.setMimeTypes(mimeTypes);
        mockServiceContext.setWelcomeFiles(new String[]{"index.json", "index.html", "index.xml", "index.txt"});
        mockServiceContext.addFilter(ContentTypeSettingFilter.class, FILES_URL_MATCH, 2);
        mockServiceContext.addFilter(TrailingSlashFilter.class, FILES_URL_MATCH, 15);
        this.jettyServer.addHandler(mockServiceContext);
    }

    private void addAdminContext() {
        Context adminContext = new Context(this.jettyServer, "/__admin");
        ServletHolder servletHolder = adminContext.addServlet(HandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", AdminRequestHandler.class.getName());
        adminContext.setAttribute(AdminRequestHandler.class.getName(), this.adminRequestHandler);
        adminContext.setAttribute("Notifier", this.notifier);
        this.jettyServer.addHandler(adminContext);
    }

    private static class NoOpMappingsLoader
    implements MappingsLoader {
        private NoOpMappingsLoader() {
        }

        @Override
        public void loadMappingsInto(StubMappings stubMappings) {
        }
    }
}

